/*
 * Decompiled with CFR 0.152.
 */
public class Game
extends GameCommon {
    public static PlatformGraphics g;
    public static final int BOGA_REVERSI = 0;
    public static final int BOGA_CONNECT = 1;
    public static final int BOGA_CHECKER = 2;
    public static final int BOGA_CNT = 3;
    private BoardGame boGame;
    public static int boGameType;
    public static int theme_index;
    public static final int ANIM_BIGBLOCKS = 8;
    public static final int ANIM_BLOCKFRAG = 4;
    public static final int ANIM_SLOWDOWN = 0;
    public static final int CHEAT_SHOW_CHEATMENU = 19;
    public static String[] msg;
    public static String[] endMsg;
    public static String[] endMsgtmp;
    public static int msg_upScrLine;
    public static int msg_maxLines;
    public static int msg_box_x;
    public static int msg_box_y;
    public static int msg_box_w;
    public static int msg_box_h;
    public static final int MSG_INLINEGAP = 3;
    public static final int TXT_INLINEGAP = 6;
    public static final int MSG_BORDERLR = 50;
    public static final int MSG_BORDERUD = 4;
    public static final int GS_GLOBAL = 0;
    public static final int GS_DOUBLE = 1;
    public static final int GS_TRIPLE = 2;
    public static final int GS_KNOCK = 3;
    public static final int GS_DIFFY = 4;
    public static final int GS_CNT = 5;
    public static int[] gameStats;
    public static String[] gameSTxt;
    public static final int GAME_SM_CNT = 3;
    public static final int GMS_STONED = 0;
    public static final int GMS_SMALLG = 1;
    public static final int GMS_BIGGEM = 2;
    public static final int GMS_KNOCKO = 3;
    public static final int GMS_DIFEAS = 4;
    public static final int GMS_DIFMED = 5;
    public static final int GMS_DIFHAR = 6;
    public static int winMsgIndex;
    public static boolean winerScoreS;
    public static String winerName;
    public static boolean winTrophy;
    public static final int PLAYER_ONE = 1;
    public static final int PLAYER_TWO = 2;
    public static final int PLAYER_AI1 = 3;
    public static final int PLAYER_BT1 = 4;
    public static byte[] PLAYERS;

    public Game() {
        GameCommon.deskW = GMain.canvasWidth;
        GameCommon.deskH = GMain.canvasHeight;
        GameCommon.deskW_2 = GameCommon.deskW >> 1;
        GameCommon.deskH_2 = GameCommon.deskH >> 1;
        GameCommon.deskX = 0;
        GameCommon.deskY = 0;
    }

    public static void setPlayers(int n, int n2) {
        Game.PLAYERS[0] = (byte)n;
        Game.PLAYERS[1] = (byte)n2;
    }

    public void processCheat(int n) {
        switch (n) {
            case 19: {
                if (this.boGame == null) break;
                this.boGame.doCheat(n);
                break;
            }
            case 34: {
                break;
            }
            case 86: {
                break;
            }
            case 84: {
                break;
            }
            case 85: {
                break;
            }
            case 68: {
                break;
            }
        }
    }

    protected boolean canPause() {
        if (this.boGame != null) {
            return this.boGame.canPause();
        }
        return false;
    }

    public void enterNotify() {
        super.enterNotify();
        GameCommon.gameState = 1;
        this.loadLevel(GameCommon.level);
        GameCommon.gameState = 10;
    }

    protected void showNotify() {
        super.showNotify();
        if (this.boGame != null) {
            this.boGame.resume();
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        if (this.boGame != null) {
            this.boGame.pause();
        }
    }

    protected void loadLevel(PlatformResource platformResource) {
        Sound.stopSound();
        Main.cleanMenuRes();
        this.ensureResources(true);
        boGameType = platformResource.readShort();
        theme_index = platformResource.readByte();
        if (theme_index < 0) {
            theme_index = (byte)Main.getCurrentProfileThemeIndex();
        }
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        switch (boGameType) {
            case 0: {
                this.boGame = new Reversi(GameCommon.deskW, GameCommon.deskH, this);
                n = 3 + theme_index;
                n2 = 6 + theme_index;
                break;
            }
            case 1: {
                this.boGame = new ConnectFour(GameCommon.deskW, GameCommon.deskH, this);
                n = 1 + theme_index;
                n2 = 4 + theme_index;
                n3 = 0 + theme_index;
                break;
            }
            case 2: {
                this.boGame = new Checker(GameCommon.deskW, GameCommon.deskH, this);
                n = 2 + theme_index;
                n2 = 5 + theme_index;
            }
        }
        Main.lodaImage(5, n);
        if (boGameType == 2) {
            Main.bgColor = 1982234;
        }
        if (boGameType == 0) {
            Main.bgColor = 7143465;
        }
        if (boGameType == 1) {
            Main.bgColor = 4178;
        }
        GMain.showBusy();
        if (n2 >= 0) {
            Main.lodaImage(6, n2);
        }
        if (n3 >= 0) {
            Main.lodaImage(7, n3);
        }
        switch (boGameType) {
            case 0: {
                Main.lodaImage(8, 10);
                Main.lodaImage(9, 13);
                break;
            }
            case 1: {
                Main.lodaImage(8, 9);
                Main.lodaImage(9, 12);
                break;
            }
            case 2: {
                Main.lodaImage(8, 11);
                Main.lodaImage(9, 14);
            }
        }
        Main.lodaImage(13, 7);
        Main.lodaImage(14, 8);
        if (this.boGame != null) {
            this.boGame.load(platformResource);
        }
    }

    public void restartThis() {
        if (this.boGame != null) {
            this.boGame.retryGame();
        }
    }

    public PlatformResource loadLevelRes(boolean bl) {
        return Platform.getResource("/l" + this.themeIndex(bl));
    }

    public int themeIndex(boolean bl) {
        int n = 0;
        switch (boGameType) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
            }
        }
        n += theme_index * 6;
        return n += bl ? 3 : 0;
    }

    public static int gameIndex(boolean bl) {
        int n = 0;
        switch (boGameType) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 2;
            }
        }
        return n += bl ? 3 : 0;
    }

    public void update() {
        int n = GameCommon.keyLast;
        GameCommon.keyLast = 0;
        if (n != 0) {
            if (msg != null) {
                switch (n) {
                    case 128: {
                        this.boGame.msgClose((byte)-1);
                        Game.closeMsg();
                        break;
                    }
                    case 2: {
                        if (msg_upScrLine + msg_maxLines > msg.length - 1) {
                            this.boGame.msgClose((byte)-1);
                            Game.closeMsg();
                            break;
                        }
                        if ((msg_upScrLine += msg_maxLines) > msg.length - msg_maxLines) {
                            msg_upScrLine = msg.length - msg_maxLines;
                        }
                        if (msg_upScrLine >= 0) break;
                        msg_upScrLine = 0;
                        break;
                    }
                    case 32: {
                        if (--msg_upScrLine >= 0) break;
                        msg_upScrLine = 0;
                        break;
                    }
                    case 64: {
                        if (++msg_upScrLine > msg.length - msg_maxLines) {
                            msg_upScrLine = msg.length - msg_maxLines;
                        }
                        if (msg_upScrLine >= 0) break;
                        msg_upScrLine = 0;
                    }
                }
            } else if (this.boGame != null) {
                this.boGame.keyPress(n);
            }
        }
        if (this.boGame != null) {
            this.boGame.doLogic();
        }
    }

    protected void draw() {
        g = Platform.getDisplayGraphics();
        if (GameCommon.paused) {
            if (this.boGame != null) {
                this.boGame.paintBG();
            }
        } else if (msg != null) {
            this.paintMsg();
        } else if (this.boGame != null) {
            BoardGame.actualizeGraphics(g);
            this.boGame.paint();
        } else {
            int n = GameCommon.deskW;
            int n2 = GameCommon.deskH;
            g.setClip(0, 0, n, n2);
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, n, n2);
            g.setColor(0);
        }
    }

    public static int paintRolledImg(int n, int n2, int n3, int n4, int n5, int n6) {
        g.setClip(0, 0, GameCommon.deskW, GameCommon.deskH);
        PlatformImage platformImage = GMain.imageCache[n];
        if (n4 < 1) {
            return n5 + n6 - 1;
        }
        int n7 = n4 - (n6 - 2);
        if (n7 > n5) {
            g.drawImage(platformImage, n2, n3, 20);
            return 0;
        }
        if (n7 < 1) {
            n7 = 1;
        }
        int n8 = n4 > n6 - 1 ? n6 - 1 : n4;
        int n9 = n4 > n5 ? n5 : n4;
        int n10 = GMain.getImageWidth(n);
        int n11 = GMain.getImageHeight(n);
        g.setColor(0);
        g.fillRect(n2, n3, n10, n11);
        int n12 = ((n7 - 1) * n6 + n8) * n11 / (n5 * n6);
        g.setClip(n2, n3, n10, n12);
        g.drawImage(platformImage, n2, n3, 20);
        --n8;
        for (int i = n7 + 1; i < n9 + 1; ++i) {
            int n13 = (i - 1) * n11 / n5;
            n12 = n8 * n11 / (n6 * n5);
            g.setClip(n2, n3 + n13, n10, n12);
            g.drawImage(platformImage, n2, n3, 20);
            --n8;
        }
        g.setClip(0, 0, GameCommon.deskW, GameCommon.deskH);
        return n5 + n6 - 1 - n4;
    }

    public void paintWinScreen() {
        if (this.boGame != null) {
            this.boGame.paintBG();
        }
    }

    public static void playEffekt(int n) {
    }

    public void leaveNotify() {
        this.ensureResources(true);
    }

    protected void ensureResources(boolean bl) {
        if (this.boGame != null) {
            this.boGame.clean();
        }
        this.boGame = null;
        GMain.imageCache[5] = null;
        GMain.imageCache[6] = null;
        GMain.imageCache[7] = null;
        GMain.imageCache[8] = null;
        GMain.imageCache[9] = null;
        GMain.imageCache[10] = null;
        GMain.imageCache[13] = null;
        GMain.imageCache[14] = null;
        GMain.imageCache[15] = null;
        GMain.imageCache[20] = null;
        GMain.imageCache[12] = null;
        if (Main.winSprites != null) {
            for (int i = 0; i < Main.winSprites.length; ++i) {
                if (Main.winSprites[i] == null) continue;
                Main.winSprites[i].clean();
                Main.winSprites[i] = null;
            }
            Main.winSprites = null;
        }
        Sprite.ensureResources();
    }

    public static void showMsg(int n, int n2, int n3, int n4, int n5, int n6) {
        String string = Main.getTxt(n, n2);
        int n7 = n5 - 100;
        msg = GForm.processText(string, n7, 0);
        msg_upScrLine = 0;
        msg_maxLines = (n6 - 3 - 8) / (Fonts.getFontHeight(0) + 3);
        msg_box_x = n3;
        msg_box_y = n4;
        msg_box_w = n5;
        msg_box_h = n6;
    }

    public static boolean msgIsShow() {
        return msg != null;
    }

    public static void setGameEndScreen() {
        GameCommon.paused = true;
        GameCommon.gameState = 95;
        GMain.instance.showGameMenu();
    }

    public static void setGameWinScreen(int n, int n2) {
        GameCommon.paused = true;
        winMsgIndex = winerName != null ? 11 : 0;
        winTrophy = false;
        if (GMain.demoMode) {
            GameCommon.quitStatus = 3;
            return;
        }
        if (winerName != null) {
            if (winerName.equals(Main.getCurrentProfileName())) {
                byte by;
                winerScoreS = true;
                int n3 = Main.isCurrentLvlCampain();
                if (n3 == (by = Main.profiles[10 * Main.activeProfile + 2]) && n > -1 && n2 > -1) {
                    winTrophy = true;
                    Game.showMsg(n, n2, GMain.canvasWidth - 300 >> 1, 90, 300, 200);
                    endMsgtmp = msg;
                    endMsg = null;
                    msg = null;
                }
            } else {
                winerName = Main.getStr(66);
            }
        } else {
            winerScoreS = false;
        }
        if (PLAYERS[0] == 2 || PLAYERS[1] == 2) {
            winerScoreS = false;
        } else if (Main.isCurrentLvlPuzle()) {
            winerScoreS = false;
        }
        GameCommon.gameState = 90;
        GMain.instance.showGameMenu();
    }

    public static String getAvatarName(int n) {
        return Main.getTxt(0, 22 + n);
    }

    public void paintMsg() {
        int n;
        if (this.boGame != null) {
            this.boGame.paintBG();
            this.boGame.paintUI();
        }
        int n2 = msg_upScrLine;
        int n3 = msg_box_y + 3 + 4;
        int n4 = Main.getColorARGB(150, 10, 10, 10);
        int n5 = (msg_upScrLine + msg_maxLines) * (Fonts.getFontHeight(0) + 3) + 5;
        int n6 = GMain.canvasWidth - 2 * (msg_box_x + 50 - 5);
        int[] nArray = new int[GMain.canvasWidth];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = n4;
        }
        for (n = 0; n < n5; ++n) {
            g.drawRGB(nArray, 0, GMain.canvasWidth, msg_box_x + 50 - 5, n3 - 5 + n, n6, 1);
        }
        while (n2 < msg.length && n2 < msg_upScrLine + msg_maxLines) {
            Fonts.drawGraphicString(0, msg[n2], msg_box_x + 50, n3, 20);
            ++n2;
            n3 += Fonts.getFontHeight(0) + 3;
        }
    }

    public static void paintTXT() {
        if (msg == null) {
            return;
        }
        int n = msg_upScrLine;
        int n2 = msg_box_y + 6 + 4;
        while (n < msg.length && n < msg_upScrLine + msg_maxLines) {
            Fonts.drawGraphicString(0, msg[n], GMain.canvasWidth >> 1, n2, 17);
            ++n;
            n2 += Fonts.getFontHeight(0) + 6;
        }
    }

    public static void paintEndMsg() {
        int n = msg_upScrLine;
        int n2 = 90;
        while (n < endMsg.length && n < msg_upScrLine + msg_maxLines) {
            Fonts.drawGraphicString(0, endMsg[n], msg_box_x + 50, n2, 20);
            ++n;
            n2 += Fonts.getFontHeight(0) + 3;
        }
    }

    public static void closeMsg() {
        msg = null;
        endMsg = null;
    }

    static {
        gameStats = new int[5];
        gameSTxt = new String[6];
        PLAYERS = new byte[2];
    }
}

