/*
 * Decompiled with CFR 0.152.
 */
public class Entity {
    private static int counter = 0;
    protected final int current;
    private Sprite iam;
    private Sprite second;
    public static final int TTL_BOARDISHIDE = 1;
    public static final int TTL_SHOWINBOARD = 2;
    private short ttl;
    private byte initVisible = (byte)-1;
    private short initPosX;
    private short initPosY;
    private byte initDirX;
    private byte initDirY;
    private byte maxDirX;
    private byte maxDirY;
    private int score;
    public int state;
    private int playingPath;
    public int initAnim = -1;
    public static final int MOVE_SHIFT = 8;
    private int posX_MS;
    private int posY_MS;
    private int dirX_MS;
    private int dirY_MS;

    public Entity() {
        this.current = counter++;
    }

    public Entity(int n) {
        this.current = counter++;
        this.iam = Entity.loadSprite(n);
    }

    public Entity(int n, int n2) {
        this.current = counter++;
        this.iam = Entity.loadSprite(n);
        this.second = Entity.loadSprite(n2);
    }

    public Entity(PlatformResource platformResource) {
        this.current = counter++;
        this.read(platformResource);
    }

    public Entity(Entity entity, int n) {
        this.current = counter++;
        this.iam = new Sprite(entity.iam.cacheIndex);
        this.setVisible(true);
        this.startPath(n);
        this.update();
        this.reset();
        this.iam.colorVariant = entity.iam.colorVariant;
    }

    public void setColorVariant(int n) {
        this.iam.colorVariant = (byte)n;
    }

    public int getCacheIndex() {
        return this.iam.cacheIndex;
    }

    public void reset() {
        this.posX_MS = 0;
        this.dirX_MS = 0;
        this.posY_MS = 0;
        this.dirY_MS = 0;
        if (this.iam != null) {
            this.iam.posX = 0;
            this.iam.posY = 0;
        }
        if (this.second != null) {
            this.second.posX = 0;
            this.second.posY = 0;
        }
        if (this.initVisible != -1) {
            this.iam.visible = this.initVisible == 1;
        }
    }

    public void restart() {
        this.startPath(this.initAnim);
    }

    public void read(PlatformResource platformResource) {
        int n = platformResource.readByte() & 0xFF;
        this.iam = Entity.loadSprite(n);
        this.iam.colorVariant = 0;
        short s = platformResource.readShort();
        while ((s = (short)(s - 1)) >= 0) {
            byte by = platformResource.readByte();
            switch (by) {
                case 0: {
                    this.ttl = platformResource.readShort();
                    break;
                }
                case 1: {
                    this.initPosX = platformResource.readShort();
                    break;
                }
                case 2: {
                    this.initPosY = platformResource.readShort();
                    break;
                }
                case 3: {
                    this.initDirX = platformResource.readByte();
                    break;
                }
                case 4: {
                    this.initDirY = platformResource.readByte();
                    break;
                }
                case 5: {
                    boolean bl = platformResource.readBoolean();
                    this.initVisible = (byte)(bl ? 1 : 0);
                    this.setVisible(bl);
                    break;
                }
                case 6: {
                    this.posX_MS = platformResource.readShort() << 8;
                    break;
                }
                case 7: {
                    this.posY_MS = platformResource.readShort() << 8;
                    break;
                }
                case 8: {
                    this.maxDirX = platformResource.readByte();
                    break;
                }
                case 9: {
                    this.score = platformResource.readByte() * 100;
                    break;
                }
                case 10: {
                    this.maxDirY = platformResource.readByte();
                    break;
                }
                case 11: {
                    this.iam.colorVariant = platformResource.readByte();
                    break;
                }
                case 12: {
                    this.state = platformResource.readInt();
                    break;
                }
                case 13: {
                    this.initAnim = platformResource.readByte();
                    this.startPath(this.initAnim);
                    break;
                }
                case 14: {
                    this.iam.directOrientation = platformResource.readByte() != 0 ? (byte)1 : 0;
                    break;
                }
            }
        }
    }

    public void startPath(int n) {
        this.iam.startPath(n);
        this.playingPath = n;
    }

    public void startPath(boolean bl, int n) {
        if (bl) {
            this.iam.startPath(n);
            this.playingPath = n;
            this.second.visible = false;
        } else {
            this.second.startPath(n);
            this.playingPath = n;
            this.iam.visible = false;
        }
    }

    public void update() {
        if (!this.iam.visible) {
            return;
        }
        this.iam.update();
        this.posX_MS += this.dirX_MS;
        this.posY_MS += this.dirY_MS;
    }

    public void updateLive() {
        if (this.iam != null && this.iam.visible) {
            this.iam.update();
        }
        if (this.second != null && this.second.visible) {
            this.second.update();
        }
    }

    public int currentPath() {
        short s = this.iam.playingPath;
        return s;
    }

    public void plusXY(int n, int n2) {
        this.posX_MS += n << 8;
        this.posY_MS += n2 << 8;
    }

    public void setPosXY(int n, int n2) {
        this.posX_MS = n << 8;
        this.posY_MS = n2 << 8;
    }

    public void setPosX(int n) {
        this.posX_MS = n << 8;
    }

    public void setPosY(int n) {
        this.posY_MS = n << 8;
    }

    public int getX() {
        return this.posX_MS >> 8;
    }

    public int getY() {
        return this.posY_MS >> 8;
    }

    public void paint(int n, int n2) {
        this.iam.paint(n + (this.posX_MS >> 8), n2 + (this.posY_MS >> 8));
    }

    public int paintGetX(int n, int n2) {
        int n3 = n + (this.posX_MS >> 8);
        this.iam.paint(n3, n2 + (this.posY_MS >> 8));
        return n3;
    }

    public void paint(boolean bl, int n, int n2) {
        if (bl) {
            this.iam.paint(n + (this.posX_MS >> 8), n2 + (this.posY_MS >> 8));
        } else {
            this.second.paint(n + (this.posX_MS >> 8), n2 + (this.posY_MS >> 8));
        }
    }

    public static Sprite loadSprite(int n) {
        Sprite sprite = new Sprite(n);
        Sprite.acquire(n);
        Sprite.ensureResources();
        sprite.visible = true;
        sprite.startPath(0);
        sprite.update();
        return sprite;
    }

    public void setVisible(boolean bl) {
        this.iam.visible = bl;
    }

    public boolean getVisible() {
        return this.iam.visible;
    }

    public void setVisible(boolean bl, boolean bl2) {
        this.iam.visible = bl;
        this.second.visible = bl2;
    }

    public boolean isVisible() {
        return this.iam.visible;
    }

    public void doTTLfunciton(int n) {
        switch (n) {
            case 1: {
                if (this.ttl == 1) {
                    this.iam.visible = true;
                }
                if (this.ttl != 2) break;
                this.iam.visible = false;
                break;
            }
            case 2: {
                if (this.ttl == 1) {
                    this.iam.visible = false;
                }
                if (this.ttl != 2) break;
                this.iam.visible = true;
                break;
            }
            default: {
                this.iam.visible = true;
            }
        }
    }

    public void clean() {
        if (this.iam != null) {
            Sprite.release(this.iam.cacheIndex);
        }
        this.iam = null;
        if (this.second != null) {
            Sprite.release(this.second.cacheIndex);
        }
        this.second = null;
    }
}

