/*
 * Decompiled with CFR 0.152.
 */
public class CheckersBoard {
    private byte[] pieces = new byte[32];
    public static final byte EMPTY = 0;
    public static final byte WHITE = 2;
    public static final byte WHITE_KING = 3;
    public static final byte BLACK = 4;
    public static final byte BLACK_KING = 5;
    private static final byte KING = 1;
    private int whitePieces;
    private int blackPieces;
    private int currentPlayer;
    private static final int NONE = 0;
    private static final int LEFT_BELOW = 1;
    private static final int LEFT_ABOVE = 2;
    private static final int RIGHT_BELOW = 3;
    private static final int RIGHT_ABOVE = 4;

    public CheckersBoard() {
        this.clearBoard();
    }

    public int getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(int n) {
        this.currentPlayer = n;
    }

    public int getWhitePieces() {
        return this.whitePieces;
    }

    public int getBlackPieces() {
        return this.blackPieces;
    }

    public Object clone() {
        CheckersBoard checkersBoard = new CheckersBoard();
        checkersBoard.currentPlayer = this.currentPlayer;
        checkersBoard.whitePieces = this.whitePieces;
        checkersBoard.blackPieces = this.blackPieces;
        checkersBoard.pieces = CheckersBoard.arrayCopyByte(this.pieces, 0, checkersBoard.pieces, 0, 32);
        return checkersBoard;
    }

    public void copyFrom(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pieces[i] = (byte)nArray[i];
        }
    }

    public CheckersList legalMoves() {
        int n = this.currentPlayer;
        int n2 = n == 2 ? 4 : 2;
        if (this.mustAttack()) {
            return this.generateAttackMoves(n, n2);
        }
        return this.generateMoves(n, n2);
    }

    private CheckersList generateAttackMoves(int n, int n2) {
        CheckersList checkersList = new CheckersList();
        for (int i = 0; i < 32; ++i) {
            CheckersList checkersList2;
            if ((this.pieces[i] & 0xFFFFFFFE) != this.currentPlayer) continue;
            if ((this.pieces[i] & 1) == 0) {
                checkersList2 = this.simpleAttack(i, n, n2);
            } else {
                CheckersList checkersList3 = new CheckersList();
                checkersList3.push_back(new Integer(i));
                checkersList2 = this.kingAttack(checkersList3, i, 0, n, n2);
            }
            if (!this.notNull(checkersList2)) continue;
            checkersList.append(checkersList2);
        }
        return checkersList;
    }

    private CheckersList simpleAttack(int n, int n2, int n3) {
        CheckersList checkersList;
        int n4;
        int n5;
        int n6;
        int n7 = this.posToCol(n);
        int n8 = this.posToLine(n);
        CheckersList checkersList2 = new CheckersList();
        int n9 = n6 = n2 == 2 ? -1 : 1;
        if (n7 < 6 && n8 + n6 > 0 && n8 + n6 < 7) {
            n5 = this.colLineToPos(n7 + 1, n8 + n6);
            n4 = this.colLineToPos(n7 + 2, n8 + 2 * n6);
            if ((this.pieces[n5] & 0xFFFFFFFE) == n3 && this.pieces[n4] == 0) {
                checkersList = this.simpleAttack(n4, n2, n3);
                checkersList2.append(this.addMove(new CheckersMove(n, n4), checkersList));
            }
        }
        if (n7 > 1 && n8 + n6 > 0 && n8 + n6 < 7) {
            n5 = this.colLineToPos(n7 - 1, n8 + n6);
            n4 = this.colLineToPos(n7 - 2, n8 + 2 * n6);
            if ((this.pieces[n5] & 0xFFFFFFFE) == n3 && this.pieces[n4] == 0) {
                checkersList = this.simpleAttack(n4, n2, n3);
                checkersList2.append(this.addMove(new CheckersMove(n, n4), checkersList));
            }
        }
        if (checkersList2.isEmpty()) {
            checkersList2.push_back(new CheckersList());
        }
        return checkersList2;
    }

    private CheckersList kingAttack(CheckersList checkersList, int n, int n2, int n3, int n4) {
        CheckersList checkersList2;
        int n5;
        int n6;
        int n7 = this.posToCol(n);
        int n8 = this.posToLine(n);
        CheckersList checkersList3 = new CheckersList();
        int n9 = 1;
        if (n7 < 6 && n8 + n9 > 0 && n8 + n9 < 7) {
            n6 = this.colLineToPos(n7 + 1, n8 + n9);
            n5 = this.colLineToPos(n7 + 2, n8 + 2 * n9);
            if ((this.pieces[n6] & 0xFFFFFFFE) == n4 && this.pieces[n5] == 0 && !checkersList.has(new Integer(n5))) {
                checkersList.push_back(new Integer(n5));
                checkersList2 = this.kingAttack(checkersList, n5, 0, n3, n4);
                checkersList3.append(this.addMove(new CheckersMove(n, n5), checkersList2));
            }
        }
        if (n7 > 1 && n8 + n9 > 0 && n8 + n9 < 7) {
            n6 = this.colLineToPos(n7 - 1, n8 + n9);
            n5 = this.colLineToPos(n7 - 2, n8 + 2 * n9);
            if ((this.pieces[n6] & 0xFFFFFFFE) == n4 && this.pieces[n5] == 0 && !checkersList.has(new Integer(n5))) {
                checkersList.push_back(new Integer(n5));
                checkersList2 = this.kingAttack(checkersList, n5, 0, n3, n4);
                checkersList3.append(this.addMove(new CheckersMove(n, n5), checkersList2));
            }
        }
        n9 = -1;
        if (n7 < 6 && n8 + n9 > 0 && n8 + n9 < 7) {
            n6 = this.colLineToPos(n7 + 1, n8 + n9);
            n5 = this.colLineToPos(n7 + 2, n8 + 2 * n9);
            if ((this.pieces[n6] & 0xFFFFFFFE) == n4 && this.pieces[n5] == 0 && !checkersList.has(new Integer(n5))) {
                checkersList.push_back(new Integer(n5));
                checkersList2 = this.kingAttack(checkersList, n5, 0, n3, n4);
                checkersList3.append(this.addMove(new CheckersMove(n, n5), checkersList2));
            }
        }
        if (n7 > 1 && n8 + n9 > 0 && n8 + n9 < 7) {
            n6 = this.colLineToPos(n7 - 1, n8 + n9);
            n5 = this.colLineToPos(n7 - 2, n8 + 2 * n9);
            if ((this.pieces[n6] & 0xFFFFFFFE) == n4 && this.pieces[n5] == 0 && !checkersList.has(new Integer(n5))) {
                checkersList.push_back(new Integer(n5));
                checkersList2 = this.kingAttack(checkersList, n5, 0, n3, n4);
                checkersList3.append(this.addMove(new CheckersMove(n, n5), checkersList2));
            }
        }
        if (checkersList3.isEmpty()) {
            checkersList3.push_back(new CheckersList());
        }
        return checkersList3;
    }

    private CheckersList kingDiagAttack(CheckersList checkersList, int n, int n2, int n3, int n4, int n5) {
        int n6 = this.posToCol(n);
        int n7 = this.posToLine(n);
        CheckersList checkersList2 = new CheckersList();
        int n8 = (Integer)checkersList.peek_head();
        int n9 = n6 + n4;
        int n10 = n7 + n5;
        if (n9 > 0 && n9 < 7 && n10 > 0 && n10 < 7 && (this.pieces[this.colLineToPos(n9, n10)] & 0xFFFFFFFE) == n3 && !checkersList.has(new Integer(this.pieces[this.colLineToPos(n9, n10)]))) {
            CheckersList checkersList3;
            checkersList.push_back(new Integer(this.pieces[this.colLineToPos(n9, n10)]));
            int n11 = n9 += n4;
            int n12 = n10 += n5;
            if (n9 >= 0 && n9 <= 7 && n10 >= 0 && n10 <= 7 && (this.pieces[this.colLineToPos(n9, n10)] == 0 || this.colLineToPos(n9, n10) == n8)) {
                int n13 = n4 == 1 && n5 == 1 ? 2 : (n4 == -1 && n5 == -1 ? 3 : (n4 == -1 && n5 == 1 ? 4 : 1));
                CheckersList checkersList4 = (CheckersList)checkersList.clone();
                checkersList3 = this.kingAttack(checkersList4, this.colLineToPos(n9, n10), n13, n2, n3);
                if (this.notNull(checkersList3)) {
                    checkersList2.append(this.addMove(new CheckersMove(n, this.colLineToPos(n9, n10)), checkersList3));
                }
                n9 += n4;
                n10 += n5;
            }
            checkersList.pop_back();
            if (checkersList2.isEmpty()) {
                n9 = n11;
                n10 = n12;
                if (n9 >= 0 && n9 <= 7 && n10 >= 0 && n10 <= 7 && (this.pieces[this.colLineToPos(n9, n10)] == 0 || this.colLineToPos(n9, n10) == n8)) {
                    checkersList3 = new CheckersList();
                    checkersList3.push_back(new CheckersMove(n, this.colLineToPos(n9, n10)));
                    checkersList2.push_back(checkersList3);
                    n9 += n4;
                    n10 += n5;
                }
            }
        }
        return checkersList2;
    }

    private boolean notNull(CheckersList checkersList) {
        return !checkersList.isEmpty() && !((CheckersList)checkersList.peek_head()).isEmpty();
    }

    private CheckersList addMove(CheckersMove checkersMove, CheckersList checkersList) {
        if (checkersMove == null) {
            return checkersList;
        }
        CheckersList checkersList2 = new CheckersList();
        while (!checkersList.isEmpty()) {
            CheckersList checkersList3 = (CheckersList)checkersList.pop_front();
            checkersList3.push_front(checkersMove);
            checkersList2.push_back(checkersList3);
        }
        return checkersList2;
    }

    private CheckersList generateMoves(int n, int n2) {
        CheckersList checkersList = new CheckersList();
        for (int i = 0; i < 32; ++i) {
            CheckersList checkersList2;
            int n3;
            if ((this.pieces[i] & 0xFFFFFFFE) != this.currentPlayer) continue;
            int n4 = this.posToCol(i);
            int n5 = this.posToLine(i);
            if ((this.pieces[i] & 1) == 0) {
                int n6 = n3 = n == 2 ? -1 : 1;
                if (n4 < 7 && n5 + n3 >= 0 && n5 + n3 <= 7 && this.pieces[this.colLineToPos(n4 + 1, n5 + n3)] == 0) {
                    checkersList2 = new CheckersList();
                    checkersList2.push_back(new CheckersMove(i, this.colLineToPos(n4 + 1, n5 + n3)));
                    checkersList.push_back(checkersList2);
                }
                if (n4 <= 0 || n5 + n3 < 0 || n5 + n3 > 7 || this.pieces[this.colLineToPos(n4 - 1, n5 + n3)] != 0) continue;
                checkersList2 = new CheckersList();
                checkersList2.push_back(new CheckersMove(i, this.colLineToPos(n4 - 1, n5 + n3)));
                checkersList.push_back(checkersList2);
                continue;
            }
            n3 = n4 + 1;
            int n7 = n5 + 1;
            if (n4 < 7 && n7 >= 0 && n7 <= 7 && this.pieces[this.colLineToPos(n3, n7)] == 0) {
                checkersList2 = new CheckersList();
                checkersList2.push_back(new CheckersMove(i, this.colLineToPos(n3, n7)));
                checkersList.push_back(checkersList2);
            }
            n3 = n4 - 1;
            n7 = n5 - 1;
            if (n4 > 0 && n7 >= 0 && n7 <= 7 && this.pieces[this.colLineToPos(n3, n7)] == 0) {
                checkersList2 = new CheckersList();
                checkersList2.push_back(new CheckersMove(i, this.colLineToPos(n3, n7)));
                checkersList.push_back(checkersList2);
            }
            n3 = n4 + 1;
            n7 = n5 - 1;
            if (n4 < 7 && n7 >= 0 && n7 <= 7 && this.pieces[this.colLineToPos(n3, n7)] == 0) {
                checkersList2 = new CheckersList();
                checkersList2.push_back(new CheckersMove(i, this.colLineToPos(n3, n7)));
                checkersList.push_back(checkersList2);
            }
            n3 = n4 - 1;
            n7 = n5 + 1;
            if (n4 <= 0 || n7 < 0 || n7 > 7 || this.pieces[this.colLineToPos(n3, n7)] != 0) continue;
            checkersList2 = new CheckersList();
            checkersList2.push_back(new CheckersMove(i, this.colLineToPos(n3, n7)));
            checkersList.push_back(checkersList2);
        }
        return checkersList;
    }

    public boolean isValidMove(int n, int n2) {
        int n3;
        if (n < 0 || n > 32 || n2 < 0 || n2 > 32) {
            return false;
        }
        if (this.pieces[n] == 0 || this.pieces[n2] != 0) {
            return false;
        }
        if ((this.pieces[n] & 0xFFFFFFFE) != this.currentPlayer) {
            return false;
        }
        int n4 = this.pieces[n] & 0xFFFFFFFE;
        int n5 = n4 == 2 ? 4 : 2;
        int n6 = this.posToLine(n);
        int n7 = this.posToCol(n);
        int n8 = this.posToLine(n2);
        int n9 = this.posToCol(n2);
        int n10 = n7 > n9 ? -1 : 1;
        int n11 = n6 > n8 ? -1 : 1;
        int n12 = n7 + n10;
        if ((this.pieces[n] & 1) == 0) {
            boolean bl = n11 == -1 && n4 == 2 || n11 == 1 && n4 == 4;
            if (n12 == n9 && n3 == n8) {
                return bl && !this.mustAttack();
            }
            return bl && n12 + n10 == n9 && n3 + n11 == n8 && (this.pieces[this.colLineToPos(n12, n3)] & 0xFFFFFFFE) == n5;
        }
        boolean bl = false;
        for (n3 = n6 + n11; n12 != n9 && n3 != n8 && this.pieces[this.colLineToPos(n12, n3)] == 0; n12 += n10, n3 += n11) {
        }
        if (n12 == n9 && n3 == n8) {
            return !this.mustAttack();
        }
        if ((this.pieces[this.colLineToPos(n12, n3)] & 0xFFFFFFFE) == n5) {
            n12 += n10;
            n3 += n11;
            while (n12 != n9 && n3 != n8 && this.pieces[this.colLineToPos(n12, n3)] == 0) {
                n12 += n10;
                n3 += n11;
            }
            if (n12 == n9 && n3 == n8) {
                return true;
            }
        }
        return false;
    }

    public boolean mustAttack() {
        for (int i = 0; i < 32; ++i) {
            if ((this.pieces[i] & 0xFFFFFFFE) != this.currentPlayer || !this.mayAttack(i)) continue;
            return true;
        }
        return false;
    }

    public boolean mayAttack(int n) {
        if (this.pieces[n] == 0) {
            return false;
        }
        int n2 = this.pieces[n] & 0xFFFFFFFE;
        int n3 = n2 == 2 ? 4 : 2;
        int n4 = this.posToCol(n);
        int n5 = this.posToLine(n);
        if ((this.pieces[n] & 1) == 0) {
            int n6;
            int n7 = n6 = n2 == 2 ? -1 : 1;
            if (n4 < 6 && n5 + n6 > 0 && n5 + n6 < 7 && (this.pieces[this.colLineToPos(n4 + 1, n5 + n6)] & 0xFFFFFFFE) == n3 && this.pieces[this.colLineToPos(n4 + 2, n5 + 2 * n6)] == 0) {
                return true;
            }
            if (n4 > 1 && n5 + n6 > 0 && n5 + n6 < 7 && (this.pieces[this.colLineToPos(n4 - 1, n5 + n6)] & 0xFFFFFFFE) == n3 && this.pieces[this.colLineToPos(n4 - 2, n5 + 2 * n6)] == 0) {
                return true;
            }
        } else {
            int n8 = 1;
            if (n4 < 6 && n5 + n8 > 0 && n5 + n8 < 7 && (this.pieces[this.colLineToPos(n4 + 1, n5 + n8)] & 0xFFFFFFFE) == n3 && this.pieces[this.colLineToPos(n4 + 2, n5 + 2 * n8)] == 0) {
                return true;
            }
            if (n4 > 1 && n5 + n8 > 0 && n5 + n8 < 7 && (this.pieces[this.colLineToPos(n4 - 1, n5 + n8)] & 0xFFFFFFFE) == n3 && this.pieces[this.colLineToPos(n4 - 2, n5 + 2 * n8)] == 0) {
                return true;
            }
            n8 = -1;
            if (n4 < 6 && n5 + n8 > 0 && n5 + n8 < 7 && (this.pieces[this.colLineToPos(n4 + 1, n5 + n8)] & 0xFFFFFFFE) == n3 && this.pieces[this.colLineToPos(n4 + 2, n5 + 2 * n8)] == 0) {
                return true;
            }
            if (n4 > 1 && n5 + n8 > 0 && n5 + n8 < 7 && (this.pieces[this.colLineToPos(n4 - 1, n5 + n8)] & 0xFFFFFFFE) == n3 && this.pieces[this.colLineToPos(n4 - 2, n5 + 2 * n8)] == 0) {
                return true;
            }
        }
        return false;
    }

    public void move(int n, int n2) {
        boolean bl = this.mustAttack();
        this.applyMove(n, n2);
        if (!bl) {
            this.changeSide();
        } else if (!this.mayAttack(n2)) {
            this.changeSide();
        }
    }

    public void move(CheckersList checkersList) {
        CheckersEnum checkersEnum = checkersList.elements();
        while (checkersEnum.hasMoreElements()) {
            CheckersMove checkersMove = (CheckersMove)checkersEnum.nextElement();
            this.applyMove(checkersMove.getFrom(), checkersMove.getTo());
        }
        this.changeSide();
    }

    private void changeSide() {
        this.currentPlayer = this.currentPlayer == 2 ? 4 : 2;
    }

    private void applyMove(int n, int n2) {
        if (!this.isValidMove(n, n2)) {
            // empty if block
        }
        this.clearPiece(n, n2);
        this.pieces[n2] = n2 < 4 && this.pieces[n] == 2 ? 3 : (n2 > 27 && this.pieces[n] == 4 ? 5 : this.pieces[n]);
        this.pieces[n] = 0;
    }

    public byte getPiece(int n) {
        return this.pieces[n];
    }

    public boolean hasEnded() {
        return this.whitePieces == 0 || this.blackPieces == 0 || !this.notNull(this.legalMoves());
    }

    public int winner() {
        if (this.currentPlayer == 2) {
            if (this.notNull(this.legalMoves())) {
                return 2;
            }
            return 4;
        }
        if (this.notNull(this.legalMoves())) {
            return 4;
        }
        return 2;
    }

    private void clearPiece(int n, int n2) {
        int n3 = this.posToLine(n);
        int n4 = this.posToCol(n);
        int n5 = this.posToLine(n2);
        int n6 = this.posToCol(n2);
        int n7 = n4 > n6 ? -1 : 1;
        int n8 = n3 > n5 ? -1 : 1;
        n4 += n7;
        n3 += n8;
        while (n3 != n5 && n4 != n6) {
            int n9 = this.colLineToPos(n4, n3);
            byte by = this.pieces[n9];
            if ((by & 0xFFFFFFFE) == 2) {
                --this.whitePieces;
            } else if ((by & 0xFFFFFFFE) == 4) {
                --this.blackPieces;
            }
            this.pieces[n9] = 0;
            n4 += n7;
            n3 += n8;
        }
    }

    public void clearBoard() {
        int n;
        this.whitePieces = 12;
        this.blackPieces = 12;
        this.currentPlayer = 4;
        for (n = 0; n < 12; ++n) {
            this.pieces[n] = 4;
        }
        for (n = 12; n < 20; ++n) {
            this.pieces[n] = 0;
        }
        for (n = 20; n < 32; ++n) {
            this.pieces[n] = 2;
        }
    }

    public static byte[] arrayCopyByte(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray2[n2 + i] = byArray[n + i];
        }
        return byArray2;
    }

    private boolean isEven(int n) {
        return n % 2 == 0;
    }

    private int colLineToPos(int n, int n2) {
        if (this.isEven(n2)) {
            return n2 * 4 + (n - 1) / 2;
        }
        return n2 * 4 + n / 2;
    }

    private int posToLine(int n) {
        return n / 4;
    }

    private int posToCol(int n) {
        return n % 4 * 2 + (n / 4 % 2 == 0 ? 1 : 0);
    }
}

