/*
 * Decompiled with CFR 0.152.
 */
public class Checker
extends BoardGame {
    public static final int BOX_N_PILLAR = 8;
    public static final int BOX_N_LINE = 8;
    public static final int BOX_CNT = 32;
    public static final int START_STONES = 12;
    public static final int PLAYER_OUT = -1;
    public static final int PLAYER_WHITE = 2;
    public static final int PLAYER_WHITE_K = 3;
    public static final int PLAYER_BLACK = 4;
    public static final int PLAYER_BLACK_K = 5;
    public static final int MOVE_LEFT = -1;
    public static final int MOVE_RIGHT = 1;
    public static final int MOVE_UPP = -1;
    public static final int MOVE_DOWN = 1;
    public static final int BOX_ONE_W = 24;
    public static final int BOX_ONE_H = 24;
    public static final int STONE_WH = 16;
    private boolean bStonesFromXML = false;
    private byte[] stonesXml;
    private boolean bFirstPlayerXML = false;
    private byte firstPlayerXml;
    private boolean bSetDiff = false;
    private byte diffFromXML;
    private int[] stones;
    public static final int ST_ANIM_MOVE = 5;
    public static final int ST_P_CATCH = 6;
    public static final int ST_P_CATCH2 = 7;
    public static final int ST_AI_CHOOSESTONE_ANIM = 8;
    public static final int ST_AI_MOVE_ANIM = 9;
    public static final int ST_KING = 10;
    public static final int ST_SELFDESTRUCTION = 12;
    public static final int ST_PUTDOWNBOMB = 13;
    public static final int ST_ENEMYDESTRUCTION = 14;
    private CheckersBoard board;
    private CheckersList legalMoves;
    private CheckersList computerMoves;
    private CheckersComputer computer;
    private final int box_top;
    private final int box_left;
    private Entity player_wk_table;
    private Entity player_bk_table;
    private Entity playedStone;
    private Entity planedStone;
    private Entity[] kurzorStone;
    public static final int START_MOVE = -99;
    private int stoneXoff;
    private int stoneYoff;
    public static final int STONE_MOVEFRAME_P_ONE_BOX = 2;
    public static final int DELUXE_BOMB_BOOM_FRAMES = 9;
    public static final int AI_CHOOSESTONE_ANIM_FRAME = 3;
    private int stoneMoveFrame;
    private int playedStoneX;
    private int playedStoneY;
    private int planed_X;
    private int planed_Y;
    private int playedStonePlannedIndex;
    private int kickFlag;
    private boolean enemy_have_king;
    private boolean ai_first = false;

    public Checker(int n, int n2, Game game) {
        super(n, n2, game, 2);
        this.instance = this;
        int n3 = Main.SOFT_LIST_H;
        this.box_top = (this.height - 192 >> 1) + 12 - (n3 >> 1);
        this.box_left = (this.width - 192 >> 1) + 12;
    }

    public void load(PlatformResource platformResource) {
        this.board_x_off = 0;
        this.board_y_off = 0;
        this.gameStates = new byte[2];
        this.gameStates[0] = platformResource.readByte();
        this.gameStates[1] = platformResource.readByte();
        if (this.gameStates[0] == 0 || this.gameStates[1] == 0) {
            this.gameStates = Game.PLAYERS;
        } else {
            Game.setPlayers(this.gameStates[0], this.gameStates[1]);
        }
        int n = platformResource.readShort();
        this.setDiff(Main.getCurrentProfileDifficulty());
        int n2 = -1;
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        this.scriptMoves = null;
        this.initMovesLeft = (byte)-1;
        this.tutorialPointer = (byte)-1;
        this.tmpSprite1ID = -1;
        this.tmpSprite2ID = -1;
        this.gameEndMsg = null;
        this.puzzleWinScore = -1;
        block18: for (int i = 0; i < n; ++i) {
            byte by = platformResource.readByte();
            switch (by) {
                case 1: {
                    this.diffFromXML = platformResource.readByte();
                    if (this.diffFromXML == 3) {
                        this.diffFromXML = (byte)Main.getCampaignLevelDifficulty();
                    }
                    this.bSetDiff = true;
                    continue block18;
                }
                case 2: {
                    int n4;
                    short s = platformResource.readShort();
                    this.stonesXml = new byte[s];
                    for (n4 = 0; n4 < s; ++n4) {
                        this.stonesXml[n4] = platformResource.readByte();
                    }
                    this.bStonesFromXML = true;
                    continue block18;
                }
                case 3: {
                    this.firstPlayerXml = platformResource.readByte();
                    this.bFirstPlayerXML = true;
                    continue block18;
                }
                case 4: {
                    this.board_x_off = platformResource.readByte();
                    continue block18;
                }
                case 5: {
                    this.board_y_off = platformResource.readByte();
                    continue block18;
                }
                case 6: {
                    n2 = platformResource.readByte();
                    continue block18;
                }
                case 7: {
                    n3 = platformResource.readByte();
                    continue block18;
                }
                case 8: {
                    bl = platformResource.readByte() == 1;
                    continue block18;
                }
                case 9: {
                    bl2 = platformResource.readByte() == 1;
                    continue block18;
                }
                case 10: {
                    int n5;
                    int n4 = platformResource.readShort();
                    this.gameMsg = new byte[n4];
                    for (n5 = 0; n5 < n4; ++n5) {
                        this.gameMsg[n5] = platformResource.readByte();
                    }
                    continue block18;
                }
                case 11: {
                    this.initMovesLeft = platformResource.readByte();
                    continue block18;
                }
                case 12: {
                    int n6;
                    int n5 = platformResource.readShort();
                    this.scriptMoves = new byte[n5];
                    for (n6 = 0; n6 < this.scriptMoves.length; ++n6) {
                        this.scriptMoves[n6] = platformResource.readByte();
                    }
                    if (n5 <= 0) continue block18;
                    this.scriptMovesPointer = 0;
                    continue block18;
                }
                case 13: {
                    this.tmpSprite1ID = platformResource.readByte();
                    continue block18;
                }
                case 14: {
                    this.tmpSprite2ID = platformResource.readByte();
                    continue block18;
                }
                case 15: {
                    int n6 = platformResource.readShort();
                    this.gameEndMsg = new byte[n6];
                    for (int j = 0; j < n6; ++j) {
                        this.gameEndMsg[j] = platformResource.readByte();
                    }
                    continue block18;
                }
                case 16: {
                    this.puzzleWinScore = platformResource.readShort();
                }
            }
        }
        this.player_one = n2 >= 0 ? new Entity(n2) : new Entity(Main.getCurrentProfileStone(0));
        this.player_two = n3 >= 0 ? new Entity(n3) : new Entity(Main.getCurrentProfileStone(1));
        this.player_two.setColorVariant(1);
        this.loadEfekts(platformResource);
        this.loadDeluxeElements(platformResource);
        this.loadTutorial(platformResource);
        platformResource.close();
        this.loadDeafults(bl, bl2);
        this.initGame();
    }

    public void initGame() {
        this.kurzorStone = new Entity[2];
        this.kurzorStone[0] = new Entity(this.player_one, 6);
        this.kurzorStone[1] = new Entity(this.player_two, 6);
        this.player_one_table = new Entity(this.player_one, 0);
        this.player_two_table = new Entity(this.player_two, 0);
        this.player_wk_table = new Entity(this.player_one, 1);
        this.player_wk_table.update();
        this.player_bk_table = new Entity(this.player_two, 1);
        this.player_bk_table.update();
        this.stones = new int[32];
        this.planedStone = this.kurzorStone[0];
        this.planedStone.setVisible(false);
        this.backup = new int[3][32];
        this.backupLast = 0;
        this.kickFlag = -1;
        this.board = new CheckersBoard();
        if (this.gameStates[0] == 3) {
            this.computer = new CheckersComputer(this.board, 2);
        } else if (this.gameStates[1] == 3) {
            this.computer = new CheckersComputer(this.board, 4);
        }
        if (this.computer != null) {
            if (this.bSetDiff) {
                this.setDiff(this.diffFromXML);
            } else {
                this.setDiff(Main.getCurrentProfileDifficulty());
            }
        }
        String string = "p one";
        String string2 = "p two";
        int n = -1;
        int n2 = -1;
        switch (this.gameStates[0]) {
            case 1: {
                string = Main.getCurrentProfileName();
                if (string != null) break;
                string = "p one";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                string = null;
                break;
            }
        }
        switch (this.gameStates[1]) {
            case 1: {
                string2 = Main.getCurrentProfileName();
                if (string2 != null) break;
                string2 = "p two";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                string2 = null;
                break;
            }
        }
        this.initInternal(n, n2);
        this.setName(string, string2, n, n2);
        int n3 = GMain.getImageWidth(6);
        int n4 = GMain.getImageHeight(6);
        this.board_x = this.box_left - 12 - (n3 - 192) / 2 + this.board_x_off;
        this.board_y = this.box_top - 12 - (n4 - 192) / 2 + this.board_y_off;
        int n5 = GMain.getImageWidth(9);
        int n6 = GMain.getImageHeight(9);
        int n7 = Main.SOFT_LIST_H;
        this.ui_bignum_xoff = GMain.getImageWidth(14) / 10;
        this.ui_bignum_yoff = GMain.getImageHeight(14);
        this.ui_top_c = (this.height >> 1) - (n6 >> 1);
        this.ui_down_c = (this.height >> 1) + (n6 >> 1);
        this.ui_lft = this.board_x >> 1;
        this.ui_rght = this.width - this.ui_lft;
        this.initCheatList();
        this.reset();
        this.gameStateCurrent = (byte)101;
    }

    public void reset() {
        int n;
        super.reset();
        if (this.bStonesFromXML) {
            for (n = 0; n < this.stonesXml.length; ++n) {
                this.stones[n] = this.stonesXml[n];
            }
            this.board.copyFrom(this.stones);
        } else {
            for (n = 0; n < 12; ++n) {
                this.stones[n] = 4;
            }
            while (n < 20) {
                this.stones[n] = 0;
                ++n;
            }
            while (n < 32) {
                this.stones[n] = 2;
                ++n;
            }
            this.board.clearBoard();
        }
        if (this.bFirstPlayerXML) {
            if (this.firstPlayerXml == this.gameStates[0]) {
                this.gameStateIndex = 0;
                this.board.setCurrentPlayer(2);
            } else {
                this.gameStateIndex = 1;
                this.board.setCurrentPlayer(4);
            }
        } else {
            this.gameStateIndex = 0;
            this.board.setCurrentPlayer(2);
        }
        this.arangeDeluxeElements();
        this.enemy_have_king = false;
        this.gameStateCurrent = this.gameStates[this.gameStateIndex];
        n = this.colorInMove();
        this.board.setCurrentPlayer(n);
        this.legalMoves = this.board.legalMoves();
        this.setCanMove(n, (CheckersList)this.legalMoves.peek_head());
        this.stoneMoveFrame = 0;
        this.gameStateCurrent = (byte)102;
    }

    private void arangeDeluxeElements() {
    }

    private void wakeUpItem(int n, int n2, int n3) {
    }

    public void setDiff(int n) {
        super.setDiff(n);
        if (this.computer != null) {
            switch (n) {
                case 0: {
                    this.computer.setDifficulty(1);
                    break;
                }
                case 1: {
                    this.computer.setDifficulty(2);
                    break;
                }
                case 2: {
                    this.computer.setDifficulty(3);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean keyPress(int n) {
        block30: {
            if (super.keyPress(n)) {
                return true;
            }
            int n2 = this.getStoneCurrentIndex();
            block0 : switch (this.gameStateCurrent) {
                case 101: {
                    if ((n & 2) == 0) return false;
                    this.stopBgEfekts();
                    this.gameStateCurrent = (byte)102;
                    return false;
                }
                case 1: 
                case 2: 
                case 105: {
                    if (this.bShowTutMsg) return false;
                    switch (n) {
                        case 8: 
                        case 16: 
                        case 32: 
                        case 64: {
                            this.stepKeyNext(n);
                            return false;
                        }
                        case 2: {
                            if (this.playedStone.currentPath() == 9) return false;
                            if (this.playedStone.currentPath() == 11) return false;
                            if (this.tutorialPointer > -1) {
                                if (this.tutEventArr[this.tutorialPointer][1] != n2 << 1) return false;
                                this.tutGoNext();
                            }
                            this.planedStone = this.kurzorStone[this.gameStateIndex];
                            switch (this.stones[n2]) {
                                case 2: 
                                case 4: {
                                    this.playedStone.startPath(2);
                                    this.planedStone.startPath(6);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    this.playedStone.startPath(12);
                                    this.planedStone.startPath(6);
                                }
                            }
                            this.playedStone.update();
                            this.planedStone.update();
                            this.planedStone.setVisible(true);
                            this.planedStone.setPosX(this.playedStone.getX());
                            this.planedStone.setPosY(this.playedStone.getY());
                            this.planed_X = this.playedStoneX;
                            this.planed_Y = this.playedStoneY;
                            this.kickFlag = -1;
                            this.playedStonePlannedIndex = n2;
                            this.gameStateCurrent = (byte)6;
                            Game.playEffekt(-1);
                        }
                        default: {
                            return false;
                        }
                    }
                }
                case 6: 
                case 7: 
                case 110: {
                    switch (n) {
                        case 8: {
                            if (this.planed_X <= 0) return false;
                            --this.planed_X;
                            this.goTo(this.planed_X, this.planed_Y);
                            break block30;
                        }
                        case 16: {
                            if (this.planed_X >= 7) return false;
                            ++this.planed_X;
                            this.goTo(this.planed_X, this.planed_Y);
                            break block30;
                        }
                        case 32: {
                            if (this.planed_Y <= 0) return false;
                            --this.planed_Y;
                            this.goTo(this.planed_X, this.planed_Y);
                            break block30;
                        }
                        case 64: {
                            if (this.planed_Y >= 7) return false;
                            ++this.planed_Y;
                            this.goTo(this.planed_X, this.planed_Y);
                            break block30;
                        }
                        case 2: {
                            if (this.canGo(n2, this.playedStonePlannedIndex, this.planed_X, this.planed_Y)) {
                                if (Math.abs(this.playedStoneY - this.planed_Y) > 1) {
                                    this.kickFlag = this.getIndex(this.playedStoneX + this.planed_X >> 1, this.playedStoneY + this.planed_Y >> 1);
                                }
                                this.stoneMoveFrame = -99;
                                this.gameStateCurrent = (byte)5;
                                this.playedStonePlannedIndex = this.getIndex(this.planed_X, this.planed_Y);
                                this.bTutMsgShutDown = true;
                                break block0;
                            }
                            if (this.gameStateCurrent == 7 || this.tutorialPointer > -1) return false;
                            this.gameStateCurrent = this.gameStates[this.gameStateIndex];
                            this.stones[n2] = Math.abs(this.stones[n2]);
                            this.setPlayedStone(n2, this.playedStoneX, this.playedStoneY);
                            this.kickFlag = -1;
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean checkKing(int n) {
        boolean bl = false;
        switch (this.stones[n]) {
            case 2: {
                if (n >= 4) break;
                this.stones[n] = -3;
                bl = true;
                break;
            }
            case 4: {
                if (n <= 27) break;
                this.stones[n] = -5;
                bl = true;
            }
        }
        if (bl) {
            if (this.gameStates[this.gameStateIndex] != 1) {
                this.enemy_have_king = true;
            }
            this.stoneMoveFrame = 0;
            this.gameStateCurrent = (byte)10;
            this.playedStone.startPath(1);
            this.playedStone.setVisible(true);
            this.playedStone.update();
            int n2 = n / 4;
            int n3 = (n - n2 * 4 << 1) + (n2 + 1 & 1);
            this.doKingInLineStart(n3 + n2 * 8);
            n3 = this.box_left + n3 * 24;
            n2 = this.box_top + n2 * 24;
            this.playedStone.setPosXY(n3, n2);
            this.planedStone.setVisible(false);
            this.playedStonePlannedIndex = n;
            return true;
        }
        return false;
    }

    private void stepKeyNext(int n) {
        int[] nArray = new int[this.legalMoves.length()];
        CheckersEnum checkersEnum = this.legalMoves.elements();
        for (int i = 0; i < this.legalMoves.length(); ++i) {
            CheckersList checkersList = (CheckersList)checkersEnum.nextElement();
            CheckersMove checkersMove = (CheckersMove)checkersList.peek_head();
            nArray[i] = checkersMove.getFrom();
        }
        this.stepKey(n, nArray, this.playedStoneX, this.playedStoneY);
    }

    private void stepKey(int n, int[] nArray, int n2, int n3) {
        switch (n) {
            case 8: {
                n2 = n2 - 2 < 0 ? 6 + (n3 + 1 & 1) : (n2 -= 2);
                if (this.canStepHere(n2, n3, nArray)) break;
                this.stepKey(n, nArray, n2, n3);
                break;
            }
            case 16: {
                n2 = n2 + 2 > 7 ? n3 + 1 & 1 : (n2 += 2);
                if (this.canStepHere(n2, n3, nArray)) break;
                this.stepKey(n, nArray, n2, n3);
                break;
            }
            case 32: {
                if (--n3 < 0) {
                    n3 = 7;
                }
                if (this.canUseLine(n3, nArray)) {
                    this.useKeyLine(n3, 0, nArray);
                    break;
                }
                this.stepKey(n, nArray, n2, n3);
                break;
            }
            case 64: {
                if (++n3 > 7) {
                    n3 = 0;
                }
                if (this.canUseLine(n3, nArray)) {
                    this.useKeyLine(n3, 0, nArray);
                    break;
                }
                this.stepKey(n, nArray, n2, n3);
            }
        }
    }

    private boolean useKeyLine(int n, int n2, int[] nArray) {
        if (this.playedStoneX - n2 < 0 && this.playedStoneX + n2 > 7) {
            return false;
        }
        if (this.playedStoneX < 4) {
            if (this.isValidIndex(this.playedStoneX + n2, n) && this.canStepHere(this.playedStoneX + n2, n, nArray)) {
                return true;
            }
            if (this.isValidIndex(this.playedStoneX - n2, n) && this.canStepHere(this.playedStoneX - n2, n, nArray)) {
                return true;
            }
        } else {
            if (this.isValidIndex(this.playedStoneX - n2, n) && this.canStepHere(this.playedStoneX - n2, n, nArray)) {
                return true;
            }
            if (this.isValidIndex(this.playedStoneX + n2, n) && this.canStepHere(this.playedStoneX + n2, n, nArray)) {
                return true;
            }
        }
        return this.useKeyLine(n, n2 + 1, nArray);
    }

    private boolean isValidIndex(int n, int n2) {
        if (n < 0 || n > 7) {
            return false;
        }
        return (n + (n2 & 1) & 1) == 1;
    }

    private boolean isValidIndexCheats(int n, int n2, int n3, int n4) {
        if (!this.isValidIndex(n, n2)) {
            return false;
        }
        return (n + n3) % 2 == 0;
    }

    private boolean canUseLine(int n, int[] nArray) {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        switch (this.colorInMove()) {
            case 2: {
                n2 = 2;
                n3 = 3;
                break;
            }
            case 4: {
                n2 = 4;
                n3 = 5;
            }
        }
        for (int i = n * 4; i < n * 4 + 4; ++i) {
            bl |= this.stones[i] == n2 || this.stones[i] == n3;
        }
        return bl;
    }

    private boolean canStepHere(int n, int n2, int[] nArray) {
        int n3 = n2 * 4 + (n >> 1);
        int n4 = 0;
        int n5 = 0;
        switch (this.colorInMove()) {
            case 2: {
                n4 = 2;
                n5 = 3;
                break;
            }
            case 4: {
                n4 = 4;
                n5 = 5;
            }
        }
        if (this.stones[n3] == n4) {
            if (this.isInTheLegals(n3, nArray)) {
                this.playedStone.startPath(8);
            } else {
                this.playedStone.startPath(9);
            }
            this.playedStone.setPosX(this.box_left + n * 24);
            this.playedStone.setPosY(this.box_top + n2 * 24);
            this.playedStoneX = n;
            this.playedStoneY = n2;
            return true;
        }
        if (this.stones[n3] == n5) {
            if (this.isInTheLegals(n3, nArray)) {
                this.playedStone.startPath(10);
            } else {
                this.playedStone.startPath(11);
            }
            this.playedStone.setPosX(this.box_left + n * 24);
            this.playedStone.setPosY(this.box_top + n2 * 24);
            this.playedStoneX = n;
            this.playedStoneY = n2;
            return true;
        }
        return false;
    }

    private boolean isInTheLegals(int n, int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            bl |= nArray[i] == n;
        }
        return bl;
    }

    public void doLogic() {
        switch (this.gameStateCurrent) {
            case 1: 
            case 2: {
                if (!this.bShowTutMsg) break;
                this.bShowTutMsg = false;
                this.tutStateInit();
                if (this.showTutMsg()) break;
                this.tutEventExe();
                break;
            }
            case 102: {
                if (this.stoneMoveFrame == 0) {
                    if (this.gameMsg != null) {
                        this.showMsg(this.gameMsg[0], this.gameMsg[1], 10, this.board_y - 0, this.width - 20, 192);
                    }
                    ++this.stoneMoveFrame;
                    break;
                }
                if (++this.stoneMoveFrame <= 12) break;
                this.gameStateCurrent = this.gameStates[this.gameStateIndex];
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                if (this.planedStone == null) break;
                this.planedStone.update();
                break;
            }
            case 10: {
                if (this.stoneMoveFrame++ <= 5) break;
                this.stones[this.playedStonePlannedIndex] = Math.abs(this.stones[this.playedStonePlannedIndex]);
                if (this.doKingInLineEnd()) break;
                this.goNext();
                break;
            }
            case 5: {
                if (this.stoneMoveFrame == -99) {
                    int n;
                    int n2 = 0;
                    this.stoneXoff = this.planedStone.getX() > this.playedStone.getX() ? 12 : -12;
                    int n3 = this.stoneYoff = this.planedStone.getY() > this.playedStone.getY() ? 12 : -12;
                    if (this.kickFlag != -1) {
                        this.planedStone = this.kurzorStone[1 - this.gameStateIndex];
                        n = this.kickFlag;
                        int n4 = this.stones[n];
                        if (n4 == 4 || n4 == 2) {
                            this.planedStone.startPath(0);
                        } else {
                            this.planedStone.startPath(0);
                        }
                        this.planedStone.update();
                        this.planedStone.setVisible(true);
                        int n5 = n / 4;
                        int n6 = (n - n5 * 4) * 2 + (n5 + 1 & 1);
                        n6 = this.box_left + n6 * 24;
                        n5 = this.box_top + n5 * 24;
                        this.planedStone.setPosXY(n6, n5);
                        this.stones[this.kickFlag] = 0;
                        this.stoneMoveFrame = -2;
                        ++this.stoneMoveFrame;
                        Game.playEffekt(-1);
                    } else {
                        this.planedStone.setVisible(false);
                        this.stoneMoveFrame = 1;
                    }
                    n = 0;
                    switch (this.stones[this.getStoneCurrentIndex()]) {
                        case -4: 
                        case -2: 
                        case 2: 
                        case 4: {
                            n = 0 + n2;
                            this.playedStone.startPath(n);
                            break;
                        }
                        case -5: 
                        case -3: 
                        case 3: 
                        case 5: {
                            n = 0 + n2;
                            this.playedStone.startPath(n);
                        }
                    }
                    this.playedStone.setVisible(true);
                    this.doMoveStart(this.playedStoneX, this.playedStoneY, this.planed_X, this.planed_Y);
                } else if (this.stoneMoveFrame == 0) {
                    if (this.planedStone.isVisible()) {
                        this.playedStone.setPosX(this.planedStone.getX());
                        this.playedStone.setPosY(this.planedStone.getY());
                    }
                    ++this.stoneMoveFrame;
                } else if (++this.stoneMoveFrame > 2) {
                    int n;
                    int n7 = this.getStoneCurrentIndex();
                    this.board.move(n7, this.playedStonePlannedIndex);
                    this.stones[this.playedStonePlannedIndex] = this.stones[n7] * -1;
                    this.stones[n7] = 0;
                    int n8 = this.playedStonePlannedIndex / 4;
                    this.playedStoneX = n = (this.playedStonePlannedIndex - n8 * 4) * 2 + (n8 + 1 & 1);
                    this.playedStoneY = n8;
                    this.planedStone.setVisible(false);
                    this.playedStone.setPosX(this.box_left + n * 24);
                    this.playedStone.setPosY(this.box_top + n8 * 24);
                    if (this.checkKing(this.playedStonePlannedIndex)) {
                        return;
                    }
                    if (Math.abs(n7 - this.playedStonePlannedIndex) > 5 && this.canAttack(this.playedStonePlannedIndex, n, n8)) {
                        if (!this.doMoveEnd()) {
                            this.planedStone = this.kurzorStone[this.gameStateIndex];
                            n7 = this.playedStonePlannedIndex;
                            switch (this.stones[n7]) {
                                case 2: 
                                case 4: {
                                    this.playedStone.startPath(2);
                                    this.planedStone.startPath(6);
                                    break;
                                }
                                case 3: 
                                case 5: {
                                    this.playedStone.startPath(12);
                                    this.planedStone.startPath(6);
                                }
                            }
                            this.playedStone.update();
                            this.planedStone.setVisible(true);
                            this.planedStone.setPosX(this.playedStone.getX());
                            this.planedStone.setPosY(this.playedStone.getY());
                            this.kickFlag = -1;
                            this.gameStateCurrent = (byte)7;
                            if (this.tutorialPointer > -1) {
                                this.tutGoNext();
                                if (this.bShowTutMsg) {
                                    this.bShowTutMsg = false;
                                    if (this.tutorialPointer > -1) {
                                        this.tutStateInit();
                                        if (!this.showTutMsg()) {
                                            this.tutEventExe();
                                        }
                                    }
                                }
                            }
                        }
                    } else if (!this.doMoveEnd()) {
                        this.goNext();
                    }
                }
                if (this.gameStateCurrent == 5) {
                    this.playedStone.plusXY(this.stoneXoff, this.stoneYoff);
                } else {
                    this.playedStone.plusXY(0, 0);
                    this.stoneXoff = 0;
                    this.stoneYoff = 0;
                }
                this.planedStone.update();
                break;
            }
            case 6: 
            case 7: 
            case 110: {
                if (this.bShowTutMsg) {
                    this.bShowTutMsg = false;
                    if (!this.showTutMsg()) {
                        this.tutStateInit();
                        this.tutEventExe();
                    } else {
                        this.tutStateInit();
                    }
                }
                if (this.planedStone == null) break;
                this.planedStone.update();
                break;
            }
            case 3: {
                if (this.bShowTutMsg) {
                    this.bShowTutMsg = false;
                    this.gameStateCurrent = (byte)8;
                    this.stoneMoveFrame = 0;
                    this.tutStateInit();
                    if (this.showTutMsg()) break;
                    this.tutEventExe();
                    break;
                }
                if (this.scriptMovesPointer >= 0 && this.scriptMovesPointer < this.scriptMoves.length) {
                    boolean bl;
                    int n = this.scriptMovesPointer;
                    CheckersList checkersList = new CheckersList();
                    do {
                        bl = false;
                        byte by = this.scriptMoves[n];
                        byte by2 = this.scriptMoves[n + 1];
                        CheckersMove checkersMove = new CheckersMove(by, by2);
                        checkersList.push_back(checkersMove);
                        if ((n += 2) >= this.scriptMoves.length - 1) continue;
                        boolean bl2 = bl = this.scriptMoves[n - 1] == this.scriptMoves[n];
                    } while (bl);
                    this.computerMoves = checkersList;
                    this.board.move(checkersList);
                } else {
                    this.computerMoves = this.computer.play();
                }
                this.gameStateCurrent = (byte)8;
                this.stoneMoveFrame = 0;
                break;
            }
            case 8: {
                CheckersMove checkersMove;
                int n;
                if (++this.stoneMoveFrame <= 3) break;
                this.stoneMoveFrame = 1;
                CheckersList checkersList = (CheckersList)this.legalMoves.peek_head();
                CheckersMove checkersMove2 = (CheckersMove)checkersList.peek_head();
                int n9 = checkersMove2.getFrom();
                if (n9 == (n = (checkersMove = (CheckersMove)this.computerMoves.peek_head()).getFrom())) {
                    this.gameStateCurrent = (byte)9;
                    this.stoneMoveFrame = -2;
                    ++this.stoneMoveFrame;
                    switch (this.stones[n9]) {
                        case 2: 
                        case 4: {
                            this.playedStone.startPath(2);
                            break;
                        }
                        case 3: 
                        case 5: {
                            this.playedStone.startPath(12);
                        }
                    }
                    Game.playEffekt(-1);
                    this.ai_first = true;
                    break;
                }
                checkersList = (CheckersList)this.legalMoves.goToNext();
                this.setCanMove(this.colorInMove(), checkersList);
                break;
            }
            case 9: {
                if (this.stoneMoveFrame == 0) {
                    if (this.planedStone.isVisible()) {
                        this.playedStone.setPosX(this.planedStone.getX());
                        this.playedStone.setPosY(this.planedStone.getY());
                    }
                    ++this.stoneMoveFrame;
                } else if (++this.stoneMoveFrame > 2) {
                    this.stoneMoveFrame = 1;
                    CheckersMove checkersMove = (CheckersMove)this.computerMoves.pop_front();
                    if (checkersMove != null) {
                        if (this.doMoveEnd()) {
                            this.computerMoves.push_front(checkersMove);
                        } else {
                            int n;
                            int n10;
                            int n11 = checkersMove.getFrom();
                            int n12 = checkersMove.getTo();
                            int n13 = n11 / 4;
                            this.playedStoneX = n10 = (n11 - n13 * 4) * 2 + (n13 + 1 & 1);
                            this.playedStoneY = n13;
                            this.playedStone.setPosX(this.box_left + n10 * 24);
                            this.playedStone.setPosY(this.box_top + n13 * 24);
                            n13 = n12 / 4;
                            n10 = (n12 - n13 * 4) * 2 + (n13 + 1 & 1);
                            int n14 = 0;
                            this.stoneXoff = n10 > this.playedStoneX ? 12 : -12;
                            int n15 = this.stoneYoff = n12 > n11 ? 12 : -12;
                            if (Math.abs(n11 - n12) > 5) {
                                n = n11 / 4 & 1;
                                int n16 = (n12 + n11 + (1 - n)) / 2;
                                n13 = n16 / 4;
                                n10 = (n16 - n13 * 4) * 2 + (n13 + 1 & 1);
                                this.planedStone = this.kurzorStone[1 - this.gameStateIndex];
                                switch (this.stones[n16]) {
                                    case 2: 
                                    case 4: {
                                        this.planedStone.startPath(0);
                                        break;
                                    }
                                    case 3: 
                                    case 5: {
                                        this.planedStone.startPath(0);
                                    }
                                }
                                this.planedStone.setVisible(true);
                                this.planedStone.setPosX(this.box_left + n10 * 24);
                                this.planedStone.setPosY(this.box_top + n13 * 24);
                                this.stones[n16] = 0;
                                this.stoneMoveFrame = -2;
                                ++this.stoneMoveFrame;
                                Game.playEffekt(-1);
                            }
                            this.stones[n12] = -Math.abs(this.stones[n11]);
                            this.playedStonePlannedIndex = n12;
                            n = 0;
                            switch (this.stones[n11]) {
                                case -4: 
                                case -2: 
                                case 2: 
                                case 4: {
                                    n = 0 + n14;
                                    this.playedStone.startPath(n);
                                    break;
                                }
                                case -5: 
                                case -3: 
                                case 3: 
                                case 5: {
                                    n = 0 + n14;
                                    this.playedStone.startPath(n);
                                }
                            }
                            this.doMoveStart(n11, n12);
                            this.stones[n11] = 0;
                        }
                    } else {
                        this.planedStone.setVisible(false);
                        this.stones[this.playedStonePlannedIndex] = Math.abs(this.stones[this.playedStonePlannedIndex]);
                        if (this.checkKing(this.playedStonePlannedIndex)) {
                            return;
                        }
                        if (!this.doMoveEnd()) {
                            this.goNext();
                        }
                    }
                }
                if (this.gameStateCurrent == 9) {
                    this.playedStone.plusXY(this.stoneXoff, this.stoneYoff);
                } else {
                    this.playedStone.plusXY(0, 0);
                    this.stoneXoff = 0;
                    this.stoneYoff = 0;
                }
                if (this.planedStone == null) break;
                this.planedStone.update();
                break;
            }
            case 126: {
                if (++this.stoneMoveFrame <= 18) break;
                this.gameStateCurrent = (byte)127;
                this.gameWin();
            }
        }
        this.playedStone.update();
    }

    private void checkPuzzleMove(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (this.scriptMovesPointer < 0) {
            return;
        }
        if (n2 >= 0) {
            n6 = n2 * 8 + n >> 1;
            n5 = n4 * 8 + n3 >> 1;
        } else {
            n6 = n;
            n5 = n3;
        }
        if (n6 == this.scriptMoves[this.scriptMovesPointer] && n5 == this.scriptMoves[this.scriptMovesPointer + 1]) {
            this.scriptMovesPointer += 2;
            if (this.scriptMovesPointer > this.scriptMoves.length - 1) {
                this.scriptMovesPointer = -1;
            }
        } else {
            this.scriptMovesPointer = -1;
        }
    }

    private void doMoveStart(int n, int n2) {
        this.checkPuzzleMove(n, -1, n2, -1);
    }

    private void doMoveStart(int n, int n2, int n3, int n4) {
        this.checkPuzzleMove(n, n2, n3, n4);
    }

    private boolean doMoveEnd() {
        if (!this.ai_first) {
            Game.playEffekt(-1);
        }
        this.ai_first = false;
        return false;
    }

    private void doKingInLineStart(int n) {
    }

    private boolean doKingInLineEnd() {
        return false;
    }

    public boolean tutEventExe() {
        if (!super.tutEventExe()) {
            return false;
        }
        byte by = this.tutorialScript[this.tutorialPointer][2];
        switch (by) {
            case 108: {
                this.gameStateCurrent = (byte)8;
                this.stoneMoveFrame = 3;
                this.playedStone.setVisible(true);
                break;
            }
            case 105: {
                this.playedStone.setVisible(true);
                this.planedStone.setVisible(true);
                int n = this.tutEventArr[this.tutorialPointer][1] >> 1;
                this.gameStateCurrent = this.stones[n] == 0 ? (byte)110 : (byte)105;
            }
        }
        return true;
    }

    public void tutStateInit() {
        super.tutStateInit();
        byte by = this.tutorialScript[this.tutorialPointer][2];
        switch (by) {
            case 104: {
                if (this.playedStone != null) {
                    this.playedStone.setVisible(false);
                }
                if (this.planedStone == null) break;
                this.planedStone.setVisible(false);
                break;
            }
            case 106: {
                byte by2;
                if (this.playedStone != null) {
                    this.playedStone.setVisible(false);
                }
                if (this.planedStone != null) {
                    this.planedStone.setVisible(false);
                }
                if (this.stones[(by2 = this.tutEventArr[this.tutorialPointer][0]) >> 1] == 0) break;
                this.planedStone = this.kurzorStone[this.gameStateIndex];
                this.planedStone.setVisible(true);
                this.planedStone.startPath(2);
                this.planedStone.update();
                int n = by2 / 8;
                int n2 = by2 - n * 8;
                this.planedStone.setPosXY(this.box_left + n2 * 24, this.box_top + n * 24);
                break;
            }
            case 109: {
                if (this.playedStone != null) {
                    this.playedStone.setVisible(false);
                }
                if (this.planedStone != null) {
                    this.planedStone.setVisible(false);
                }
                this.playedStone.setVisible(false);
                for (int i = 0; i < this.stones.length; ++i) {
                    this.stones[i] = this.tutEventArr[this.tutorialPointer][i];
                }
                this.board.copyFrom(this.stones);
                break;
            }
            case 108: {
                boolean bl;
                int n = 0;
                this.kickFlag = -1;
                this.gameStateIndex = this.gameStates[0] == 1 ? (byte)1 : 0;
                int n3 = this.colorInMove();
                this.board.setCurrentPlayer(n3);
                this.legalMoves = this.board.legalMoves();
                CheckersList checkersList = new CheckersList();
                do {
                    bl = false;
                    int n4 = this.tutEventArr[this.tutorialPointer][n] >> 1;
                    int n5 = this.tutEventArr[this.tutorialPointer][n + 1] >> 1;
                    CheckersMove checkersMove = new CheckersMove(n4, n5);
                    checkersList.push_back(checkersMove);
                    if ((n += 2) >= this.tutEventArr[this.tutorialPointer].length - 1) continue;
                    boolean bl2 = bl = this.tutEventArr[this.tutorialPointer][n - 1] == this.tutEventArr[this.tutorialPointer][n];
                } while (bl);
                this.setPlayedStone(this.tutEventArr[this.tutorialPointer][0] >> 1);
                this.playedStone.startPath(2);
                this.playedStone.setVisible(false);
                this.computerMoves = checkersList;
                this.board.move(checkersList);
                break;
            }
            case 105: {
                this.kickFlag = -1;
                int n = this.tutEventArr[this.tutorialPointer][0];
                int n6 = this.tutEventArr[this.tutorialPointer][1];
                int n7 = n6 / 8;
                int n8 = n6 - n7 * 8;
                n >>= 1;
                if (this.stones[n6 >>= 1] != 0) {
                    this.planedStone = this.kurzorStone[this.gameStateIndex];
                    this.planedStone.setVisible(true);
                    if (this.stones[n] == 2 || this.stones[n] == 4) {
                        this.planedStone.startPath(2);
                    } else {
                        this.planedStone.startPath(12);
                    }
                    this.planedStone.update();
                    this.planedStone.setPosXY(this.box_left + n8 * 24, this.box_top + n7 * 24);
                    int n9 = this.colorInMove();
                    this.board.setCurrentPlayer(n9);
                    this.legalMoves = this.board.legalMoves();
                    this.playedStone = this.gameStateIndex == 0 ? this.player_one : this.player_two;
                    this.setPlayedStone(n);
                    this.playedStone.setVisible(false);
                    break;
                }
                this.playedStone = this.gameStateIndex == 0 ? this.player_one : this.player_two;
                this.setPlayedStone(n);
                if (this.stones[n] == 2 || this.stones[n] == 4) {
                    this.playedStone.startPath(2);
                } else {
                    this.playedStone.startPath(12);
                }
                byte by3 = this.tutEventArr[this.tutorialPointer][1];
                n7 = by3 / 8;
                n8 = by3 - n7 * 8;
                this.planedStone = this.kurzorStone[this.gameStateIndex];
                this.planed_X = n8;
                this.planed_Y = n7;
                this.goTo(n8, n7);
                this.planedStone.startPath(5);
                int n10 = this.colorInMove();
                this.board.setCurrentPlayer(n10);
                this.legalMoves = this.board.legalMoves();
                this.planedStone.setVisible(false);
                this.playedStone.setVisible(true);
                break;
            }
            case 111: {
                byte by4 = this.tutEventArr[this.tutorialPointer][0];
                byte by5 = this.tutEventArr[this.tutorialPointer][1];
                break;
            }
            case 107: {
                this.playedStone.setVisible(false);
            }
        }
    }

    private void goNext() {
        this.stoneXoff = 0;
        this.stoneYoff = 0;
        int n = this.sumstones(2, 3);
        int n2 = this.sumstones(4, 5);
        this.scoreOne = (n - n2) * Main.gameStatisticMultiper[0][0];
        this.scoreOne = this.scoreOne > 0 ? this.scoreOne : 0;
        this.scoreOne += this.gems[0] * Main.gameStatisticMultiper[2][1] + this.gems[1] * Main.gameStatisticMultiper[2][2];
        this.scoreTwo = (n2 - n) * Main.gameStatisticMultiper[0][0];
        this.scoreTwo = this.scoreTwo > 0 ? this.scoreTwo : 0;
        this.scoreTwo += this.gems[2] * Main.gameStatisticMultiper[2][1] + this.gems[3] * Main.gameStatisticMultiper[2][2];
        if (this.movesLeftb >= 0) {
            if (this.gameStateIndex == 0) {
                this.movesLeftw = (byte)(this.movesLeftw - 1);
            } else {
                this.movesLeftb = (byte)(this.movesLeftb - 1);
            }
        }
        if ((this.gameStateIndex = (byte)(this.gameStateIndex + 1)) > this.gameStates.length - 1) {
            this.gameStateIndex = 0;
        }
        this.gameStateCurrent = this.gameStates[this.gameStateIndex];
        int n3 = this.colorInMove();
        this.board.setCurrentPlayer(n3);
        this.legalMoves = this.board.legalMoves();
        this.tutGoNext();
        if (this.gameStateCurrent == 107) {
            this.gameStateCurrent = (byte)103;
        } else {
            int n4;
            if (this.legalMoves.length() == 0) {
                this.gameStateCurrent = (byte)127;
                this.whoWin = this.gameStates[1 - this.gameStateIndex];
                this.planedStone.setVisible(false);
                this.playedStone.setVisible(false);
                if (this.whoWin == 1) {
                    Game.winerScoreS = true;
                    Game.playEffekt(-1);
                } else {
                    Game.winerScoreS = false;
                    Game.playEffekt(-1);
                }
                Game.winerName = 1 - this.gameStateIndex == 0 ? this.pOneName : this.pTwoName;
                this.gameStateCurrent = (byte)126;
                this.stoneMoveFrame = 0;
                return;
            }
            if (this.puzzleWinScore > -1) {
                int n5 = n4 = this.gameStates[0] == 1 ? this.scoreOne : this.scoreTwo;
                if (n4 >= this.puzzleWinScore) {
                    this.playedStone.setVisible(false);
                    Game.winerScoreS = false;
                    Game.winerName = this.gameStates[0] == 1 ? this.pOneName : this.pTwoName;
                    this.stoneMoveFrame = 0;
                    this.gameStateCurrent = (byte)126;
                    Game.playEffekt(-1);
                    return;
                }
            }
            if (this.movesLeftb == 0 || this.movesLeftw == 0) {
                if (this.gameStates[0] == 1) {
                    this.whoWin = this.gameStates[1];
                    Game.winerName = this.pTwoName;
                } else {
                    this.whoWin = this.gameStates[0];
                    Game.winerName = this.pOneName;
                }
                this.playedStone.setVisible(false);
                this.gameStateCurrent = (byte)127;
                if (this.whoWin == 1) {
                    Game.playEffekt(-1);
                } else {
                    Game.playEffekt(-1);
                }
                Game.winerScoreS = false;
                this.gameStateCurrent = (byte)126;
                this.stoneMoveFrame = 0;
                return;
            }
            this.setCanMove(n3, (CheckersList)this.legalMoves.peek_head());
            if (this.gameStateCurrent == 1) {
                if (++this.backupLast > 2) {
                    this.backupLast = 0;
                }
                for (n4 = 0; n4 < this.stones.length; ++n4) {
                    this.backup[this.backupLast][n4] = this.stones[n4];
                }
            }
        }
        this.changeSides(this.gameStateIndex);
        if (this.bShowTutMsg) {
            this.bShowTutMsg = false;
            if (this.tutorialPointer > -1) {
                this.tutStateInit();
                if (!this.showTutMsg()) {
                    this.tutEventExe();
                }
            }
        }
    }

    public int sumstones(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.stones.length; ++i) {
            int n4 = this.stones[i];
            if (n4 == n) {
                ++n3;
                continue;
            }
            if (n4 != n2) continue;
            n3 += 2;
        }
        return n3;
    }

    protected void gameWin() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.gameStates[0] == 1) {
            n = 2;
            n2 = 3;
            n3 = 4;
            n4 = 5;
        } else {
            n = 4;
            n2 = 5;
            n3 = 2;
            n4 = 3;
        }
        int n5 = this.sumstones(n, n2);
        int n6 = this.sumstones(n3, n4);
        int n7 = (n5 - n6) * Main.gameStatisticMultiper[0][0];
        Game.gameStats[0] = n7 > 0 ? n7 : 0;
        Game.gameSTxt[0] = "" + n5 + " : " + n6;
        Game.gameStats[1] = 0;
        Game.gameSTxt[1] = "";
        Game.gameStats[2] = 0;
        Game.gameSTxt[2] = "";
        if (!this.enemy_have_king) {
            Game.gameStats[3] = Main.gameStatisticMultiper[0][3];
            Game.gameSTxt[3] = Main.getTxt(0, 8);
        } else {
            Game.gameStats[3] = 0;
            Game.gameSTxt[3] = "";
        }
        switch (this.ai_difficulty) {
            case 0: {
                Game.gameStats[4] = Main.gameStatisticMultiper[2][4];
                Game.gameSTxt[4] = Main.getStr(58);
                break;
            }
            case 1: {
                Game.gameStats[4] = Main.gameStatisticMultiper[2][5];
                Game.gameSTxt[4] = Main.getStr(59);
                break;
            }
            case 2: {
                Game.gameStats[4] = Main.gameStatisticMultiper[2][6];
                Game.gameSTxt[4] = Main.getStr(60);
                break;
            }
            default: {
                Game.gameStats[4] = 0;
                Game.gameSTxt[4] = "";
            }
        }
        Game.gameSTxt[Game.gameSTxt.length - 1] = Main.getStr(31);
        super.gameWin();
    }

    private int colorInMove() {
        return this.gameStateIndex == 0 ? 2 : 4;
    }

    private int getStoneCurrentIndex() {
        return this.playedStoneY * 4 + (this.playedStoneX >> 1);
    }

    private int getIndex(int n, int n2) {
        return n2 * 4 + (n >> 1);
    }

    private boolean setCanMove(int n, CheckersList checkersList) {
        boolean bl = false;
        if (!this.legalMoves.isEmpty()) {
            switch (n) {
                case 2: {
                    this.playedStone = this.player_one;
                    break;
                }
                case 4: {
                    this.playedStone = this.player_two;
                }
            }
            CheckersMove checkersMove = (CheckersMove)checkersList.peek_head();
            this.setPlayedStone(checkersMove.getFrom());
            bl = true;
        }
        return true;
    }

    private void setPlayedStone(int n) {
        int n2 = n / 4;
        int n3 = (n - n2 * 4) * 2 + (n2 + 1 & 1);
        this.setPlayedStone(n, n3, n2);
    }

    private void setPlayedStone(int n, int n2, int n3) {
        this.playedStone.setPosX(this.box_left + n2 * 24);
        this.playedStone.setPosY(this.box_top + n3 * 24);
        this.playedStone.setVisible(true);
        this.playedStoneX = n2;
        this.playedStoneY = n3;
        this.setPossibleGesture(n);
    }

    private void setPossibleGesture(int n) {
        switch (this.stones[n]) {
            case 2: 
            case 4: {
                this.playedStone.startPath(8);
                break;
            }
            case 3: 
            case 5: {
                this.playedStone.startPath(10);
            }
        }
        this.playedStone.update();
    }

    private void goTo(int n, int n2) {
        this.planedStone.setPosX(this.box_left + this.planed_X * 24);
        this.planedStone.setPosY(this.box_top + this.planed_Y * 24);
        int n3 = this.getIndex(this.playedStoneX, this.playedStoneY);
        this.playedStonePlannedIndex = this.getIndex(n, n2);
        if (this.canGo(n3, this.playedStonePlannedIndex, n, n2)) {
            this.planedStone.startPath(5);
        } else {
            this.planedStone.startPath(6);
        }
        if (n != this.playedStoneX && n2 != this.playedStoneY) {
            this.stones[n3] = -Math.abs(this.stones[n3]);
        }
    }

    private boolean canGo(int n, int n2, int n3, int n4) {
        int n5;
        if ((n3 & 1) == (n4 & 1)) {
            return false;
        }
        if (this.tutorialPointer > -1 && this.gameStateCurrent == 110 && this.tutEventArr[this.tutorialPointer][1] != (n5 = n4 * 8 + n3)) {
            return false;
        }
        if (!this.legalMoves.isEmpty()) {
            CheckersEnum checkersEnum = this.legalMoves.elements();
            for (int i = 0; i < this.legalMoves.length(); ++i) {
                CheckersList checkersList = (CheckersList)checkersEnum.nextElement();
                CheckersEnum checkersEnum2 = checkersList.elements();
                for (int j = 0; j < checkersList.length(); ++j) {
                    CheckersMove checkersMove = (CheckersMove)checkersEnum2.nextElement();
                    if (checkersMove.getFrom() != n || checkersMove.getTo() != n2) continue;
                    return true;
                }
            }
        } else {
            return false;
        }
        return false;
    }

    private boolean canAttack(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (this.stones[n]) {
            case -2: 
            case 2: {
                n6 = -1;
                n4 = 4;
                n5 = 5;
                break;
            }
            case -3: 
            case 3: {
                n6 = 1;
                n4 = 4;
                n5 = 5;
                break;
            }
            case -4: 
            case 4: {
                n6 = 1;
                n4 = 2;
                n5 = 3;
                break;
            }
            case -5: 
            case 5: {
                n6 = -1;
                n4 = 2;
                n5 = 3;
            }
        }
        int n7 = this.whoisin(n2 - 1, n3 + n6);
        int n8 = this.whoisin(n2 + 1, n3 + n6);
        if ((n7 == n4 || n7 == n5) && this.whoisin(n2 - 2, n3 + 2 * n6) == 0) {
            return true;
        }
        if ((n8 == n4 || n8 == n5) && this.whoisin(n2 + 2, n3 + 2 * n6) == 0) {
            return true;
        }
        if (Math.abs(this.stones[n]) == 3 || Math.abs(this.stones[n]) == 5) {
            n7 = this.whoisin(n2 - 1, n3 + (n6 *= -1));
            n8 = this.whoisin(n2 + 1, n3 + n6);
            if ((n7 == n4 || n7 == n5) && this.whoisin(n2 - 2, n3 + 2 * n6) == 0) {
                return true;
            }
            if ((n8 == n4 || n8 == n5) && this.whoisin(n2 + 2, n3 + 2 * n6) == 0) {
                return true;
            }
        }
        return false;
    }

    private int whoisin(int n, int n2) {
        if (n < 0 || n > 7) {
            return -1;
        }
        if (n2 < 0 || n2 > 7) {
            return -1;
        }
        return this.stones[this.getIndex(n, n2)];
    }

    public void paint() {
        BoardGame.g.setClip(0, 0, this.width, this.height);
        BoardGame.g.setColor(0);
        BoardGame.g.fillRect(0, 0, this.width, this.height);
        this.paintBG();
        switch (this.gameStateCurrent) {
            case 101: {
                this.paintSoftListText(55);
                return;
            }
            case 102: {
                Game.paintRolledImg(6, this.board_x, this.board_y, this.stoneMoveFrame >> 0, 8, 4);
                this.paintUI();
                return;
            }
            case 5: 
            case 9: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                this.planedStone.paint(0, 0);
                this.playedStone.paint(0, 0);
                break;
            }
            case 14: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                this.paintDeluxElements();
                this.planedStone.paint(0, 0);
                this.paintBoxNums();
                return;
            }
            case 13: 
            case 66: {
                this.paintPlayfield();
                this.paintStones();
                this.playedStone.paint(0, 0);
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintUI();
                this.planedStone.paint(0, 0);
                return;
            }
            case 6: 
            case 7: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                this.playedStone.paint(0, 0);
                this.planedStone.paint(0, 0);
                break;
            }
            case 92: {
                this.paintPlayfield();
                this.paintStones();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintUI();
                this.paintCheatMenu();
                return;
            }
            case 94: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                int n = this.box_left - 12 + this.pu_pos_x * 24 + 4;
                int n2 = this.box_top - 12 + this.pu_pos_y * 24 + 4;
                BoardGame.g.setColor(0xFFFF00);
                BoardGame.g.drawRect(n, n2, 15, 15);
                break;
            }
            case 126: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                break;
            }
            case 127: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintSoftListText(55);
                return;
            }
            case 103: 
            case 104: {
                this.paintPlayfield();
                this.paintStones();
                this.playedStone.paint(0, 0);
                if (this.planedStone != null) {
                    this.planedStone.paint(0, 0);
                }
                this.paintUI();
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintTutMsg();
                return;
            }
            case 106: 
            case 107: 
            case 109: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                if (this.planedStone != null) {
                    this.planedStone.paint(0, 0);
                }
                this.paintDeluxElements();
                this.paintBoxNums();
                this.paintSoftListText(55);
                return;
            }
            case 105: 
            case 108: 
            case 110: {
                this.paintPlayfield();
                this.paintStones();
                if (this.planedStone != null) {
                    this.planedStone.paint(0, 0);
                }
                this.playedStone.paint(0, 0);
                this.paintUI();
                break;
            }
            default: {
                this.paintPlayfield();
                this.paintStones();
                this.paintUI();
                this.playedStone.paint(0, 0);
            }
        }
        this.paintDeluxElements();
        this.paintBoxNums();
    }

    public void paintBoxNums() {
    }

    public void paintPlayfield() {
        BoardGame.g.setClip(0, 0, GMain.canvasWidth, GMain.canvasHeight);
        BoardGame.g.drawImage(GMain.imageCache[6], this.board_x, this.board_y, 20);
        int n = GMain.getImageWidth(6);
        int n2 = GMain.getImageHeight(6);
        BoardGame.g.drawImage(GMain.imageCache[17], this.board_x + n, this.board_y, 20);
        BoardGame.g.drawImage(GMain.imageCache[16], this.board_x, this.board_y + n2, 20);
    }

    private void paintStones() {
        if (this.tutEventArr != null) {
            this.paintTutUnderLight(this.box_left, this.box_top, 8, 8, 24, 24);
        }
        block6: for (int i = 0; i < this.stones.length; ++i) {
            int n = this.stones[i];
            if (n == 0) continue;
            int n2 = i / 4;
            int n3 = i - n2 * 4;
            n3 = this.box_left + 2 * (n3 * 24) + (n2 + 1 & 1) * 24;
            n2 = this.box_top + n2 * 24;
            switch (n) {
                case 2: {
                    this.player_one_table.paint(n3, n2);
                    continue block6;
                }
                case 3: {
                    this.player_wk_table.paint(n3, n2);
                    continue block6;
                }
                case 4: {
                    this.player_two_table.paint(n3, n2);
                    continue block6;
                }
                case 5: {
                    this.player_bk_table.paint(n3, n2);
                }
            }
        }
    }

    public void paintUI() {
        this.paintUIb(this.gameStateIndex);
    }

    public void clean() {
        super.clean();
        this.player_one_table.clean();
        this.player_one_table = null;
        this.player_two_table.clean();
        this.player_two_table = null;
        this.player_wk_table.clean();
        this.player_wk_table = null;
        this.player_bk_table.clean();
        this.player_bk_table = null;
        if (this.kurzorStone != null) {
            for (int i = 0; i < this.kurzorStone.length; ++i) {
                this.kurzorStone[i].clean();
                this.kurzorStone[i] = null;
            }
        }
        this.player_one.clean();
        this.player_two.clean();
        this.player_one = null;
        this.player_two = null;
        this.playedStone = null;
        this.planedStone = null;
        this.computer = null;
        this.computerMoves = null;
        this.legalMoves = null;
        this.board = null;
    }
}

