/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.FullCanvas;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import wrapper.WrapperMIDlet;

public class Menu
extends FullCanvas
implements Runnable,
Constants {
    private static final String emptyString = "";
    private static final int LB = 36;
    private static final int RB = 40;
    private Graphics screen;
    private Image[] images = null;
    static String portalURL;
    static String portalText;
    static Bundle bundle;
    public static int lang_sel;
    public static int lang_num;
    public static String[] lang_code;
    public static String[] lang_name;
    private static boolean isLanguagesSelector;
    private static boolean isMultiLanguages;
    public static boolean isDemo;
    private int selectedLanguageIndex = 0;
    private Image splash;
    private Image icon;
    private XFont font = new XFont();
    private String[] names;
    private int type;
    private Throwable t;
    private int state;
    private int softkeyHeight;
    private String lsk;
    private String rsk;
    private int screenWidth = 0;
    private int screenHeight = 0;
    private int scrollingPosition = 0;
    private int selected;
    private String[][] text;
    public static String[][] texts;
    private String[] portals;
    private int scrollCount = 0;
    private int pressedKey = 0;

    private void setSoftLabel(int key, String label) {
        if (key == -6) {
            this.lsk = label;
        } else if (key == -7) {
            this.rsk = label;
        }
    }

    private void setSoftkeys(String lsk, String rsk) {
        this.setSoftLabel(-6, lsk);
        this.setSoftLabel(-7, rsk);
    }

    public void keyPressed(int keyCode) {
        switch (this.state) {
            case 3: {
                if (this.isAction(keyCode)) {
                    if (2 == this.selected) {
                        if (null == portalURL) {
                            this.changeState(5);
                        } else {
                            this.changeState(4);
                        }
                    } else if (3 == this.selected) {
                        this.changeState(5);
                    } else {
                        this.changeState(200);
                    }
                    this.repaint();
                    this.serviceRepaints();
                } else if (this.isLeft(keyCode)) {
                    --this.selected;
                    if (this.selected < 0) {
                        this.selected = this.names.length - 1;
                    }
                    this.scrollingPosition = 0;
                    this.pressedKey = keyCode;
                } else if (this.isRight(keyCode)) {
                    ++this.selected;
                    if (this.selected >= this.names.length) {
                        this.selected = 0;
                    }
                    this.scrollingPosition = 0;
                    this.pressedKey = keyCode;
                }
                if (keyCode != -7) break;
                this.changeState(100);
                break;
            }
            case 2: {
                this.handleSelectLanguage(keyCode);
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 4: {
                if (this.isAction(keyCode)) {
                    this.startBrowser(portalURL);
                    break;
                }
                if (keyCode == -7) {
                    this.changeState(3);
                    break;
                }
                this.handleCursor(keyCode);
                this.repaint();
                this.serviceRepaints();
                break;
            }
            case 5: {
                if (keyCode == -7) {
                    this.changeState(3);
                    break;
                }
                this.handleCursor(keyCode);
                this.repaint();
                this.serviceRepaints();
            }
        }
    }

    private boolean isAction(int keyCode) {
        if (keyCode == 53 || keyCode == -6) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 8;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isUp(int keyCode) {
        if (keyCode == 50) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 1;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isDown(int keyCode) {
        if (keyCode == 56) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 6;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isLeft(int keyCode) {
        if (keyCode == 52) {
            return true;
        }
        try {
            if (this.getGameAction(keyCode) == 2) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isRight(int keyCode) {
        if (keyCode == 54) {
            return true;
        }
        try {
            return this.getGameAction(keyCode) == 5;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void executionException(int type, Throwable t) {
        this.type = type;
        this.t = t;
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        while (this.state != 100) {
            switch (this.state) {
                case 0: {
                    try {
                        this.splash = Image.createImage((String)"/disney_logo.png");
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.load();
                    this.font.load("/font.png", "/font.xft");
                    this.softkeyHeight = this.font.getHeight() + this.changeScaleValueFromQVGA(6);
                    isLanguagesSelector = false;
                    isMultiLanguages = false;
                    this.readSettings();
                    if (!this.isInitializedLanguages()) {
                        isLanguagesSelector = true;
                        if (lang_sel == 0) {
                            lang_sel = 1;
                        }
                        this.loadStrings();
                    } else {
                        this.loadStrings();
                    }
                    this.changeState(1);
                    break;
                }
                case 1: {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (1 < lang_num) {
                        isMultiLanguages = true;
                    }
                    if (1 < lang_num && isLanguagesSelector) {
                        this.changeState(2);
                        break;
                    }
                    this.loadStrings();
                    this.changeState(3);
                    break;
                }
                case 2: {
                    this.repaint();
                    this.serviceRepaints();
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception e3) {}
                    break;
                }
                case 3: {
                    this.handleMenu();
                    break;
                }
                case 200: {
                    this.free();
                    this.setSoftkeys(null, null);
                    WrapperMIDlet.getInstance().executeMIDlet(this.selected);
                    this.changeState(300);
                }
                case 300: {
                    this.repaint();
                    this.serviceRepaints();
                    try {
                        Thread.sleep(100L);
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        WrapperMIDlet.getInstance().notifyDestroyed();
    }

    public void changeState(int newState) {
        this.state = newState;
        switch (this.state) {
            case 3: {
                this.load();
                this.setSoftkeys(Menu.getMessage(131070), Menu.getMessage(131072));
                break;
            }
            case 2: {
                this.setSoftkeys("OK", null);
                break;
            }
            case 300: {
                break;
            }
            case 200: {
                break;
            }
            case 4: {
                this.text = this.font.breakPages(this.portals[0], this.screenWidth - 20, this.screenHeight - (this.changeScaleValueFromQVGA(24) + 20));
                this.setSoftkeys(Menu.getMessage(131070), Menu.getMessage(131071));
                break;
            }
            case 5: {
                String about = XFont.replace(WrapperMIDlet.getInstance().getAppProperty("MIDlet-Version"), Menu.getMessage(196605));
                this.text = this.font.breakPages(about, this.screenWidth - 20, this.screenHeight - (this.changeScaleValueFromQVGA(24) + 20));
                this.setSoftkeys(null, Menu.getMessage(131071));
            }
        }
        this.repaint();
        this.serviceRepaints();
    }

    protected void paint(Graphics g2) {
        if (null == g2) {
            return;
        }
        this.screen = g2;
        switch (this.state) {
            case 0: {
                this.paintLoading(this.screen);
                break;
            }
            case 1: {
                this.paintSplash(this.screen);
                break;
            }
            case 2: {
                this.drawSelectLanguage(this.screen);
                break;
            }
            case 3: {
                this.paintMenu(this.screen);
                break;
            }
            case 200: 
            case 300: {
                this.screen.setColor(0xFFFFFF);
                this.screen.fillRect(0, 0, this.screenWidth, this.screenHeight);
                break;
            }
            case 4: 
            case 5: {
                this.drawTextBox(this.screen, this.text, 10, 10, this.screenWidth - 20, this.screenHeight - (this.changeScaleValueFromQVGA(24) + 20));
                this.screen.setClip(0, 0, this.screenWidth, this.screenHeight);
                this.paintSoftkeys(this.screen);
            }
        }
    }

    private void paintLoading(Graphics g2) {
    }

    private void paintSplash(Graphics g2) {
        g2.setColor(0xFFFFFF);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.splash != null) {
            g2.drawImage(this.splash, this.screenWidth / 2, this.screenHeight / 2, 3);
        }
    }

    private int changeScaleValueFromQVGA(int n) {
        return n * 10000 / 136 / 100;
    }

    private int changeScaleValueFromMLes(int n) {
        return n;
    }

    private void paintMenu(Graphics g2) {
        int offsetY = this.changeScaleValueFromMLes(220) - this.screenHeight;
        int DUCK_X = this.changeScaleValueFromQVGA(8);
        int DUCK_Y = this.screenHeight - this.changeScaleValueFromQVGA(24);
        int IMAGE_BOX_X = 70;
        int IMAGE_BOX_Y = 45 - offsetY / 3;
        int TEXT_BOX_Y = 164 - (offsetY / 2 + offsetY / 4);
        g2.setColor(11328503);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.selected < 0) {
            this.selected = this.names.length - 1;
        }
        if (this.selected >= this.names.length) {
            this.selected = 0;
        }
        g2.drawImage(this.images[0], this.screenWidth / 2, this.changeScaleValueFromQVGA(8) - offsetY / 6, 17);
        if (this.screenWidth <= this.images[4].getWidth()) {
            g2.drawImage(this.images[4], 0, this.screenHeight, 36);
        }
        g2.drawImage(this.images[3], DUCK_X, DUCK_Y, 36);
        int x = 70;
        int y = IMAGE_BOX_Y;
        if (0 == this.selected) {
            this.drawScreenShotWithShadow(g2, this.images[1], x, y);
        } else if (1 == this.selected) {
            this.drawScreenShotWithShadow(g2, this.images[2], x, y);
        } else if (2 == this.selected) {
            if (null == portalURL) {
                this.drawScreenShotWithShadow(g2, this.images[24], x, y);
            } else {
                this.drawScreenShotWithShadow(g2, this.images[23], x, y);
            }
        } else if (3 == this.selected) {
            this.drawScreenShotWithShadow(g2, this.images[24], x, y);
        }
        y = TEXT_BOX_Y;
        this.drawLabelBox(g2, this.names[this.selected], x, y, this.images[1].getWidth(), this.changeScaleValueFromMLes(30));
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        this.paintSoftkeys(g2);
    }

    private void handleMenu() {
        this.scrollingPosition += this.changeScaleValueFromMLes(3);
        int tw = this.font.stringWidth(this.names[this.selected]) + this.changeScaleValueFromQVGA(60);
        if (tw < this.scrollingPosition) {
            this.scrollingPosition = 0;
        }
        this.repaint();
        this.serviceRepaints();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void paintSoftkeys(Graphics g2) {
        if (this.lsk != null || this.rsk != null) {
            int fullHeight = this.screenHeight;
            int y = fullHeight - this.changeScaleValueFromQVGA(3);
            if (this.lsk != null) {
                this.drawSoftkeyLabelBox(g2, this.lsk, 0, this.screenHeight, 36);
            }
            if (this.rsk != null) {
                this.drawSoftkeyLabelBox(g2, this.rsk, this.screenWidth, this.screenHeight, 40);
            }
        }
    }

    private void drawScreenShotWithShadow(Graphics g2, Image img, int x, int y) {
        int i;
        g2.drawImage(img, x, y, 20);
        int w = img.getWidth();
        int h2 = img.getHeight();
        int iw = this.images[16].getWidth();
        int ih = this.images[22].getHeight();
        int s = this.images[15].getWidth() / 2;
        g2.setClip(x + s, 0, w - s * 2, this.screenHeight);
        for (i = x + s; i < x + w; i += iw) {
            g2.drawImage(this.images[16], i, y, 3);
            g2.drawImage(this.images[20], i, y + h2, 3);
        }
        g2.setClip(0, y + s, this.screenWidth, h2 - s * 2);
        for (i = y + s; i < y + h2; i += ih) {
            g2.drawImage(this.images[22], x, i, 3);
            g2.drawImage(this.images[18], x + w, i, 3);
        }
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        g2.drawImage(this.images[15], x, y, 3);
        g2.drawImage(this.images[17], x + w, y, 3);
        g2.drawImage(this.images[19], x + w, y + h2, 3);
        g2.drawImage(this.images[21], x, y + h2, 3);
    }

    private void drawLabelBox(Graphics g2, String label, int x, int y, int w, int h2) {
        int CURSOR_LEFT_X = this.changeScaleValueFromMLes(5);
        int CURSOR_RIGHT_X = this.changeScaleValueFromMLes(7);
        this.drawBox(g2, x, y, w, h2);
        g2.setClip(x + 5, y, w - 10, h2);
        int y2 = y + h2 / 2 + this.changeScaleValueFromQVGA(2);
        int tw = this.font.stringWidth(this.names[this.selected]) + this.changeScaleValueFromQVGA(60);
        this.font.drawString(g2, this.names[this.selected], this.screenWidth / 2 - (this.scrollingPosition + tw), y2, 6);
        this.font.drawString(g2, this.names[this.selected], this.screenWidth / 2 - this.scrollingPosition, y2, 6);
        this.font.drawString(g2, this.names[this.selected], this.screenWidth / 2 - (this.scrollingPosition - tw), y2, 6);
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        if (this.isLeft(this.pressedKey)) {
            g2.drawImage(this.images[5], x - (CURSOR_LEFT_X + 3), y2, 10);
        } else {
            g2.drawImage(this.images[5], x - CURSOR_LEFT_X, y2, 10);
        }
        if (this.isRight(this.pressedKey)) {
            g2.drawImage(this.images[6], x + w + (CURSOR_RIGHT_X + 3), y2, 6);
        } else {
            g2.drawImage(this.images[6], x + w + CURSOR_RIGHT_X, y2, 6);
        }
        this.pressedKey = 0;
    }

    private void drawBox(Graphics g2, int x, int y, int w, int h2) {
        int i;
        g2.setColor(210, 210, 210);
        g2.fillRect(x, y, w, h2);
        boolean IMAGE_OFFSET_X = true;
        int iw = this.images[8].getWidth();
        int ih = this.images[14].getHeight();
        int s = this.images[7].getWidth() / 2;
        g2.setClip(x + s, 0, w - s * 2, this.screenHeight);
        for (i = x + s; i < x + w; i += iw) {
            g2.drawImage(this.images[8], i, y, 3);
            g2.drawImage(this.images[12], i, y + h2, 3);
        }
        g2.setClip(0, y + s, this.screenWidth, h2 - s * 2);
        for (i = y + s; i < y + h2; i += ih) {
            g2.drawImage(this.images[14], x, i, 3);
            g2.drawImage(this.images[10], x + w + 1, i, 3);
        }
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        g2.drawImage(this.images[7], x, y, 3);
        g2.drawImage(this.images[9], x + w, y, 3);
        g2.drawImage(this.images[11], x + w, y + h2, 3);
        g2.drawImage(this.images[13], x, y + h2, 3);
    }

    private void drawSoftkeyLabelBox(Graphics g2, String label, int x, int y, int anchor) {
        g2.setColor(210, 210, 210);
        int x2 = x;
        int y2 = y;
        int w = this.font.stringWidth(label);
        int h2 = this.font.getHeight();
        w += 12;
        if (0 != (8 & anchor)) {
            x2 = x - w;
            x -= 6;
        } else if (0 != (1 & anchor)) {
            x2 = (x - w) / 2;
        } else if (0 != (4 & anchor)) {
            x += 6;
        }
        if (0 != (0x20 & anchor)) {
            y2 = y - this.font.getHeight();
        } else if (0 != (2 & anchor)) {
            y2 = (y - this.font.getHeight()) / 2;
        }
        g2.fillRect(x2, y2, w, h2);
        g2.setColor(180, 180, 180);
        g2.drawRect(x2 + 1, y2 + 1, w - 3, h2 - 2);
        this.font.drawString(g2, label, x, y, anchor);
    }

    public DataInputStream initializeImageFromBNDL(String resource) throws Exception {
        DataInputStream in = null;
        String string = resource;
        Class<?> clazz = this.getClass();
        Object var3_5 = null;
        InputStream inputStream = null;
        inputStream = clazz.getResourceAsStream(string);
        in = new DataInputStream(inputStream);
        in.readInt();
        return in;
    }

    public Image loadImageFromBNDL(DataInputStream in) throws Exception {
        Image img = null;
        int numBytes = in.readInt();
        byte[] b2 = new byte[numBytes];
        in.readFully(b2);
        img = Image.createImage((byte[])b2, (int)0, (int)numBytes);
        b2 = null;
        return img;
    }

    public void skipImageFromBNDL(DataInputStream in) throws Exception {
        int numBytes = in.readInt();
        in.skipBytes(numBytes);
    }

    public void closeImageFromBNDL(DataInputStream in) throws Exception {
        if (null != in) {
            in.close();
        }
        in = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        block12: {
            System.gc();
            if (null != this.images) {
                return;
            }
            DataInputStream bndl = null;
            this.images = new Image[25];
            bndl = this.initializeImageFromBNDL("/menu.bin");
            for (int i = 0; i < this.images.length; ++i) {
                this.images[i] = this.loadImageFromBNDL(bndl);
                System.out.println(" load images " + i + ", " + this.images[i]);
            }
            try {
                this.closeImageFromBNDL(bndl);
            }
            catch (Exception e2) {}
            break block12;
            catch (Exception e3) {
                try {
                    e3.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        this.closeImageFromBNDL(bndl);
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    this.closeImageFromBNDL(bndl);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void free() {
        this.splash = null;
        if (null != this.images) {
            for (int i = 0; i < this.images.length; ++i) {
                if (null == this.images[i]) continue;
                this.images[i] = null;
            }
        }
        System.gc();
        this.images = null;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public void startBrowser(String urlName) {
        System.out.println("platformRequest: " + urlName);
        try {
            if (null != urlName) {
                Thread.sleep(100L);
                WrapperMIDlet.getInstance().platformRequest(urlName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.terminate();
    }

    public void terminate() {
        try {
            WrapperMIDlet.getInstance().notifyDestroyed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadStrings() {
        try {
            String lang = lang_code[lang_sel - 1];
            Bundle bundle = null;
            try {
                System.out.println("/text__" + lang + ".txt");
                bundle = new Bundle("/text__" + lang + ".txt");
                texts = new String[4][];
                Menu.texts[0] = bundle.getArray("menu");
                Menu.texts[1] = bundle.getArray("names");
                Menu.texts[2] = bundle.getArray("softkeys");
                Menu.texts[3] = bundle.getArray("messages");
                bundle = null;
            }
            catch (Exception e2) {
                System.out.println("loadStrings1 " + e2);
            }
            try {
                bundle = new Bundle("/portal__" + lang + ".txt");
                this.portals = bundle.getArray("portal");
                bundle = null;
            }
            catch (Exception e3) {
                System.out.println("loadStrings2 " + e3);
            }
            Menu.readSpecialFeatures(lang_sel - 1);
            if (null == portalURL) {
                this.names = new String[3];
                this.names[0] = Menu.getMessage(65535);
                this.names[1] = Menu.getMessage(65536);
                this.names[2] = Menu.getMessage(0);
            } else {
                this.names = new String[4];
                this.names[0] = Menu.getMessage(65535);
                this.names[1] = Menu.getMessage(65536);
                this.names[2] = Menu.getMessage(1);
                this.names[3] = Menu.getMessage(0);
            }
        }
        catch (Exception e4) {
            System.out.println("loadStrings3 " + e4);
        }
    }

    public static void readSpecialFeatures(int sel) {
        System.out.println(" readSpecialFeatures ");
        try {
            bundle = new Bundle("lang.txt");
        }
        catch (Exception e2) {
            System.out.println("file lang.txt not found");
            return;
        }
        portalURL = null;
        String portalTag = "portal=";
        try {
            String[] urls = bundle.getArray("urls");
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    if (urls[i].indexOf("portal=") != 0) continue;
                    portalURL = Menu.getPropertyURL(Menu.getKeyValue(urls[i]));
                }
            }
        }
        catch (Exception e3) {
            System.out.println("portal / url not found");
        }
        Menu.cleanBundle();
        String langCode = lang_code[sel];
        try {
            bundle = new Bundle("portal__" + langCode + ".txt");
            portalText = bundle.getArray("portal")[0];
        }
        catch (Exception e4) {
            System.out.println("file portal__" + langCode + ".txt not found");
            return;
        }
        Menu.cleanBundle();
    }

    public static void cleanBundle() {
        if (bundle != null) {
            Menu.bundle.hash.clear();
            bundle = null;
            System.gc();
        }
    }

    public static String getPropertyURL(String value) {
        int pos = value.indexOf("jad:");
        if (pos != 0) {
            return value;
        }
        int pos2 = value.indexOf(124);
        String tag = value.substring(pos + "jad:".length(), pos2);
        value = value.substring(pos2 + 1);
        String valJAD = WrapperMIDlet.getInstance().getAppProperty(tag);
        if (valJAD == null) {
            return value;
        }
        if ((value = value + "&url=" + valJAD).length() > 128) {
            return valJAD;
        }
        return value;
    }

    public static String getKeyValue(String str) {
        return str.substring(str.indexOf("=") + 1, str.length());
    }

    private boolean isInitializedLanguages() {
        this.loadLanguageInfo();
        if (lang_num <= 1) {
            lang_sel = 1;
            return true;
        }
        if (lang_sel == 0) {
            this.initializeLanguages();
            return false;
        }
        return true;
    }

    private void loadLanguageInfo() {
        Bundle b2 = null;
        try {
            try {
                b2 = new Bundle("lang.txt");
            }
            catch (Exception e2) {
                System.out.println("file lang.txt not found");
            }
            String[] content = b2.getArray("lang");
            b2 = null;
            lang_code = new String[content.length];
            lang_name = new String[content.length];
            int next_lang = 0;
            DataInputStream test = null;
            Vector<String> langVec = new Vector<String>();
            for (int i = 0; i < content.length; ++i) {
                int pos = content[i].indexOf(",");
                Menu.lang_code[next_lang] = content[i].substring(0, pos);
                Menu.lang_name[next_lang] = content[i].substring(pos + 1, content[i].length());
                try {
                    String string = "/text__" + lang_code[next_lang] + ".txt";
                    Class<?> clazz = this.getClass();
                    Object var9_12 = null;
                    InputStream inputStream = null;
                    inputStream = clazz.getResourceAsStream(string);
                    test = new DataInputStream(inputStream);
                    ((InputStream)test).close();
                    test = null;
                }
                catch (Exception e3) {
                    System.out.println("/text__" + lang_code[next_lang] + ".txt NOT FOUND");
                    continue;
                }
                System.out.println("/text__" + lang_code[next_lang] + ".txt FOUND");
                langVec.addElement(lang_name[next_lang]);
                ++next_lang;
            }
            lang_num = next_lang;
            lang_name = new String[lang_num];
            int count = 0;
            Enumeration e4 = langVec.elements();
            while (e4.hasMoreElements()) {
                Menu.lang_name[count] = (String)e4.nextElement();
                ++count;
            }
            content = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializeLanguages() {
        String property = System.getProperty("microedition.locale");
        if (property == null) {
            lang_sel = 1;
        } else {
            for (lang_sel = 1; lang_sel <= lang_num && !property.startsWith(lang_code[lang_sel - 1]); ++lang_sel) {
            }
            if (lang_sel >= lang_num + 1) {
                lang_sel = 1;
            }
        }
    }

    private void handleSelectLanguage(int keyCode) {
        if (this.isAction(keyCode)) {
            lang_sel = 1 + this.selectedLanguageIndex;
            this.loadStrings();
            this.saveSettings();
            this.changeState(3);
        } else if (this.isUp(keyCode)) {
            --this.selectedLanguageIndex;
            if (this.selectedLanguageIndex < 0) {
                this.selectedLanguageIndex = lang_num - 1;
            }
        } else if (this.isDown(keyCode)) {
            ++this.selectedLanguageIndex;
            if (lang_num <= this.selectedLanguageIndex) {
                this.selectedLanguageIndex = 0;
            }
        }
    }

    private void drawSelectLanguage(Graphics g2) {
        g2.setClip(0, 0, this.screenWidth, this.screenHeight);
        g2.setColor(11328503);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        if (this.screenWidth <= this.images[4].getWidth()) {
            g2.drawImage(this.images[4], 0, this.screenHeight, 36);
        }
        this.paintSoftkeys(g2);
        for (int i = 0; i < lang_num; ++i) {
            if (this.selectedLanguageIndex == i) {
                g2.drawImage(this.images[6], this.screenWidth / 2 - (this.font.stringWidth(lang_name[i]) + 10) / 2, 30 + this.font.getHeight() * i, 10);
                g2.drawImage(this.images[5], this.screenWidth / 2 + (this.font.stringWidth(lang_name[i]) + 10) / 2, 30 + this.font.getHeight() * i, 6);
                this.font.drawString(g2, lang_name[i], this.screenWidth / 2, 30 + this.font.getHeight() * i, 3);
                continue;
            }
            this.font.drawString(g2, lang_name[i], this.screenWidth / 2, 30 + this.font.getHeight() * i, 3);
        }
    }

    public void saveSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Donald_Selection_V1", (boolean)true);
            ByteArrayOutputStream ba = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(ba);
            byte[] buffer = null;
            try {
                out.writeInt(lang_sel);
                buffer = ba.toByteArray();
                rs.setRecord(1, buffer, 0, buffer.length);
            }
            catch (InvalidRecordIDException e2) {
                rs.addRecord(buffer, 0, buffer.length);
            }
            rs.closeRecordStore();
            rs = null;
            out.close();
            out = null;
            ba.close();
            ba = null;
            System.gc();
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettings() {
        boolean isNoData = false;
        try {
            FilterInputStream in = null;
            byte[] buffer = null;
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"Donald_Selection_V1", (boolean)true);
                try {
                    buffer = rs.getRecord(1);
                    if (buffer == null || buffer.length == 0) {
                        throw new IllegalStateException();
                    }
                }
                catch (Exception e2) {
                    buffer = new byte[1024];
                    isNoData = true;
                }
                rs.closeRecordStore();
                rs = null;
                System.gc();
            }
            catch (Exception e3) {
                // empty catch block
            }
            try {
                in = new DataInputStream(new ByteArrayInputStream(buffer));
                lang_sel = ((DataInputStream)in).readInt();
            }
            catch (Exception e4) {
                e4.printStackTrace();
            }
            finally {
                if (null != in) {
                    in.close();
                    in = null;
                }
                System.gc();
            }
        }
        catch (Exception e5) {
            e5.printStackTrace();
        }
    }

    private void handleTextBox() {
    }

    private void drawTextBox(Graphics g2, String[][] text, int x, int y, int w, int h2) {
        g2.setColor(11328503);
        g2.fillRect(0, 0, this.screenWidth, this.screenHeight);
        g2.drawImage(this.images[0], this.screenWidth / 2, this.changeScaleValueFromQVGA(8), 17);
        if (this.screenWidth <= this.images[4].getWidth()) {
            g2.drawImage(this.images[4], 0, this.screenHeight, 36);
        }
        this.drawBox(g2, x - 5, y - 5, w + 10, h2 + 10);
        for (int i = 0; i < text[this.scrollCount].length; ++i) {
            this.font.drawString(g2, text[this.scrollCount][i], x, y, 20);
            y += this.font.getHeight();
        }
        if (1 < text.length) {
            this.drawCursor(g2, 0 < this.scrollCount, this.scrollCount < text.length - 1);
        }
    }

    private void handleCursor(int keyCode) {
        try {
            if (this.isLeft(keyCode) && 0 < this.scrollCount) {
                --this.scrollCount;
            }
            if (this.isRight(keyCode) && this.scrollCount < this.text.length - 1) {
                ++this.scrollCount;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawCursor(Graphics g2, boolean isLeft, boolean isRight) {
        int x = this.screenWidth / 2;
        int y = this.screenHeight - 3;
        if (isLeft) {
            g2.drawImage(this.images[5], x - 10, y, 40);
        }
        if (isRight) {
            g2.drawImage(this.images[6], x + 10, y, 36);
        }
    }

    public static String getMessage(int id) {
        if (texts == null) {
            return "null";
        }
        return texts[id / 65535][id % 65535];
    }

    static {
        bundle = null;
        lang_sel = 0;
        lang_code = null;
        lang_name = null;
        isLanguagesSelector = false;
        isMultiLanguages = false;
        isDemo = false;
    }
}

