/*
 * Decompiled with CFR 0.152.
 */
import com.mg.MGCanvas;
import javax.microedition.lcdui.Graphics;

public class GameDisplay
extends MGCanvas
implements GameConfig {
    GameResource res = null;
    GameRuntime runtime = null;
    public static final int[][] PageImage = new int[32][];
    public int[] IMAGE_CAP = new int[]{102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112};
    public int[][] IMAGE_JOCKEY = new int[][]{{65, 76, 76, 65}, {66, 77, 77, 66}, {67, 78, 78, 67}, {68, 79, 79, 68}, {69, 80, 80, 69}, {70, 81, 81, 70}, {71, 82, 82, 71}, {72, 83, 83, 72}, {73, 84, 84, 73}, {74, 85, 85, 74}, {75, 86, 86, 75}};
    public int[] horseshiftX = new int[]{21, 20, 20, 21};
    public int[] horseshiftY = new int[]{23, 23, 23, 23};
    int WinnerScrolling = 0;
    int horsewidth = 71;
    int horseheight = 45;
    public int horseRacingShiftY = 0;
    public long horseRacingTime = 0L;
    public int horseMoveShiftY = 0;
    public long horseMoveTime = 0L;
    public int moveDirectionY = 1;
    public int moveCount = 0;
    public int beginPoint = GAME_WIDTH - GAME_WIDTH / 5;
    int MenuAnimation = 0;
    long MenuAniTimeCount = 0L;
    public int RaceAnimationX = 0;
    public int RaceSpeed = 7;
    public int RaceHorseAni = 0;
    public int[] IMAGE_CUP = new int[]{0, 1, 2};
    public boolean ishandle = false;

    public GameDisplay() {
        this.initImages();
        GameDisplay.setImageFileList(new String[]{"data://res.dat"});
        this.setFrame(null, 240, 260);
    }

    public void drawMGMenuButton(Graphics graphics, int n, Object object, int n2, int n3, int n4, boolean bl) {
    }

    public void drawCanvas(Graphics graphics) {
        graphics.setClip(0, 0, GAME_WIDTH, GAME_HEIGHT);
        if (this.res != null && this.res.isReady && !isLoading) {
            graphics.setFont(F_NORMAL);
            graphics.setColor(0);
            try {
                switch (this.res.iState) {
                    case 0: {
                        this.drawLogoPage(graphics);
                        break;
                    }
                    case 2: {
                        this.drawMenuPage(graphics);
                        break;
                    }
                    case 1: {
                        this.drawTitlePage(graphics);
                        break;
                    }
                    case 7: {
                        this.drawOfficePage(graphics);
                        break;
                    }
                    case 8: {
                        this.drawStablePage(graphics);
                        break;
                    }
                    case 9: {
                        this.drawRacingPage(graphics);
                        break;
                    }
                    case 10: {
                        this.drawPausePage(graphics);
                        break;
                    }
                    case 11: {
                        this.drawExitAlert(graphics);
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.drawDialogPage(graphics);
                        break;
                    }
                    case 5: {
                        this.drawOptionPage(graphics);
                        break;
                    }
                    case 13: {
                        this.drawStartRacing(graphics);
                        break;
                    }
                    case 14: {
                        this.drawRacingRank(graphics);
                        break;
                    }
                    case 15: {
                        this.drawRankingPage(graphics);
                        break;
                    }
                    case 17: {
                        this.drawLobbyPage(graphics);
                        break;
                    }
                    case 6: 
                    case 18: {
                        this.drawRegisterPage(graphics);
                        break;
                    }
                    case 16: 
                    case 19: {
                        this.drawViewRecord(graphics);
                        break;
                    }
                    case 20: {
                        this.drawArrageRace(graphics);
                        break;
                    }
                    case 21: {
                        this.drawUpgradeStable(graphics);
                        break;
                    }
                    case 22: {
                        this.drawMiniGame(graphics);
                        break;
                    }
                    case 23: {
                        this.drawBetPage(graphics);
                        break;
                    }
                    case 24: {
                        this.drawViewHorseStatus(graphics);
                        break;
                    }
                    case 25: {
                        this.drawStrategyPage(graphics);
                        break;
                    }
                    case 26: {
                        this.drawMinigameResult(graphics);
                        break;
                    }
                    case 27: {
                        this.drawHorseStatus(graphics);
                        break;
                    }
                    case 28: {
                        this.drawBetTips(graphics);
                        break;
                    }
                    case 29: {
                        this.drawRacingAward(graphics);
                        break;
                    }
                    case 30: {
                        this.drawBetResult(graphics);
                        break;
                    }
                    case 31: {
                        this.drawRestAlert(graphics);
                        break;
                    }
                    case 12: {
                        this.drawViewRace(graphics);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.res.errormessage != null && !this.res.errormessage.equals("")) {
                this.drawOutlinedBox(graphics, 5, GAME_HEIGHT / 2, GAME_WIDTH - 10, GAME_HEIGHT / 2 - 15);
                try {
                    GameDisplay.loadImage(95);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics.drawImage(images[95], GAME_WIDTH * 2 / 3, GAME_HEIGHT / 2, 33);
                graphics.setFont(F_NORMAL);
                graphics.setColor(0);
                if (this.res.errormessage.length() > 8) {
                    this.drawMGDialog(graphics, this.res.errormessage, 20, GAME_HEIGHT / 2 + 15, GAME_WIDTH - 50, GAME_HEIGHT / 2 - 45, false);
                } else {
                    graphics.drawString(this.res.errormessage, GAME_WIDTH / 2, GAME_HEIGHT * 2 / 3, 33);
                }
            }
        }
    }

    public void drawViewRace(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(77, 189, 57);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        for (n2 = 0; n2 < GAME_WIDTH; n2 += images[118].getWidth()) {
            for (n = 0; n < GAME_HEIGHT; n += images[117].getHeight()) {
                graphics.drawImage(images[117], n2, n, 20);
            }
        }
        for (n2 = 0; n2 < GAME_WIDTH; n2 += images[118].getWidth()) {
            graphics.drawImage(images[118], n2, 98, 20);
        }
        for (n2 = 0; n2 < GAME_WIDTH; n2 += images[101].getWidth()) {
            graphics.drawImage(images[101], n2, 98 + images[118].getHeight() + 2, 36);
        }
        graphics.setColor(73, 117, 12);
        graphics.fillRect(0, 0, GAME_WIDTH, 3);
        graphics.setColor(85, 146, 24);
        graphics.fillRect(0, 3, GAME_WIDTH, 4);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 7, GAME_WIDTH, 33);
        graphics.setColor(154, 207, 48);
        graphics.fillRect(0, 40, GAME_WIDTH, 6);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 46, GAME_WIDTH, 3);
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        graphics.drawImage(images[40], GAME_WIDTH - 2, GAME_HEIGHT - 1, 40);
        graphics.drawImage(images[89], GAME_WIDTH, 0, 24);
        int[] nArray = new int[]{10384128, 16444558, 10384128, 1787648};
        n = 0 - nArray.length;
        int n3 = 49;
        int n4 = GAME_WIDTH + nArray.length * 2;
        int n5 = 49;
        for (int i = 0; i < nArray.length; ++i) {
            graphics.setColor(nArray[i]);
            graphics.fillRect(n + i, n3 + i, n4 - i * 2, n5 - i * 2);
        }
        graphics.drawImage(images[4], GAME_WIDTH / 2, n3 + nArray.length, 17);
        this.drawOutlinedString(graphics, this.res.RACE_NAME[this.res.raceid], GAME_WIDTH / 2, 82, 65, 10384128, 16775369);
        graphics.drawImage(images[113], GAME_WIDTH / 2 - (this.res.RACE_NAME[this.res.raceid].length() / 2 + 1) * graphics.getFont().getHeight(), 84, 33);
        graphics.drawImage(images[116], GAME_WIDTH / 2 + (this.res.RACE_NAME[this.res.raceid].length() / 2 + 1) * graphics.getFont().getHeight(), 84, 33);
        this.drawOutlinedString(graphics, this.res.RACE_NAME[this.res.raceid], GAME_WIDTH / 2, 136, 65, 0, 0xFFFFFF);
        this.drawOutlinedString(graphics, this.res.RACE_LOCATION[this.res.RACE_ATTRIBUTE[this.res.raceid][5]], 0, 173, 68, 0, 0xFFFFFF);
        this.drawOutlinedString(graphics, "Awards", GAME_WIDTH / 3, 209, 65, 0, 0xFFFFFF);
        this.drawOutlinedString(graphics, "$" + this.res.RACE_ATTRIBUTE[this.res.raceid][3] + "K", GAME_WIDTH / 3 * 2, 209, 65, 0, 0xFFFFFF);
        if (this.res.totaldistance == 1000) {
            this.drawClipImage(graphics, images[58], 210, 148, 0, 0, images[58].getWidth() / 6, images[58].getHeight(), 17);
        } else if (this.res.totaldistance == 1200) {
            this.drawClipImage(graphics, images[58], 210, 148, images[58].getWidth() / 6, 0, images[58].getWidth() / 6, images[58].getHeight(), 17);
        } else if (this.res.totaldistance == 1400) {
            this.drawClipImage(graphics, images[58], 210, 148, images[58].getWidth() / 6 * 2, 0, images[58].getWidth() / 6, images[58].getHeight(), 17);
        } else if (this.res.totaldistance == 1600) {
            this.drawClipImage(graphics, images[58], 210, 148, images[58].getWidth() / 6 * 3, 0, images[58].getWidth() / 6, images[58].getHeight(), 17);
        } else if (this.res.totaldistance == 2000) {
            this.drawClipImage(graphics, images[58], 210, 148, images[58].getWidth() / 6 * 4, 0, images[58].getWidth() / 6, images[58].getHeight(), 17);
        } else if (this.res.totaldistance == 2400) {
            this.drawClipImage(graphics, images[58], 210, 148, images[58].getWidth() / 6 * 5, 0, images[58].getWidth() / 6, images[58].getHeight(), 17);
        }
        this.drawClipImage(graphics, images[60], 160, 148, images[60].getWidth() / 8 * this.res.raceland, 0, images[60].getWidth() / 8, images[60].getHeight(), 17);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawRestAlert(Graphics graphics) {
        this.drawTitleBoard(graphics, "", 17);
        int n = 10;
        int n2 = 60;
        int n3 = GAME_WIDTH - n * 2;
        int n4 = 135;
        this.drawOutlinedBox(graphics, n, n2, n3, n4);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Rest", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        graphics.setColor(149, 149, 74);
        graphics.fillRect(18, 67, GAME_WIDTH - 36, 25);
        graphics.drawRect(18, 98, GAME_WIDTH - 36, 85);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Taking Rest", GAME_WIDTH / 2, 86, 65);
        graphics.setColor(0);
        this.drawMGDialog(graphics, "It takes one week to take the rest, are you sure to do that?", 30, 105, GAME_WIDTH - 60, 87, false);
        graphics.setColor(244, 253, 224);
        graphics.fillRect(120, 200, 104, 32);
        graphics.setColor(60, 90, 56);
        graphics.fillRect(121, 201, 102, 30);
        graphics.setColor(244, 253, 224);
        graphics.fillRect(123, 203, 98, 26);
        graphics.drawImage(images[36], 146, 216 - images[36].getHeight() / 2, 17);
        graphics.drawImage(images[26], 198, 216 - images[36].getHeight() / 2, 17);
        if (this.res.menuindex == 1) {
            this.drawMask(graphics, 198 - images[36].getWidth() / 2, 216 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        } else {
            this.drawMask(graphics, 146 - images[36].getWidth() / 2, 216 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Cancel", false);
    }

    public void drawBetResult(Graphics graphics) {
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Betting Result", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        int n = 10;
        int n2 = 50;
        int n3 = GAME_WIDTH - n * 2;
        int n4 = 190;
        this.drawOutlinedBox(graphics, n, n2, n3, n4);
        int n5 = 25;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(18, 75, 90, 23);
        graphics.fillRect(18, 75 + n5, 90, 23);
        graphics.fillRect(18, 75 + n5 * 2, 90, 23);
        graphics.drawRect(18, GAME_HEIGHT * 2 / 3 - 10, GAME_WIDTH - 36, 63);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Money", 63, 95, 65);
        graphics.drawString("Prize", 63, 95 + n5, 65);
        graphics.drawString("Total", 63, 95 + n5 * 2, 65);
        graphics.drawImage(images[57], 35, 72, 33);
        graphics.setColor(0xFF0000);
        graphics.fillRect(48, 72, 170, 1);
        graphics.setColor(221, 221, 190);
        graphics.fillRect(108, 75, 116, 23);
        graphics.fillRect(108, 75 + n5, 116, 23);
        graphics.fillRect(108, 75 + n5 * 2, 116, 23);
        graphics.setColor(0);
        graphics.drawString("" + this.res.initMoney, 166, 95, 65);
        if (this.res.finalrank[0] == this.res.betindex) {
            graphics.drawString("" + this.res.betmoney * this.res.RaceHorses[this.res.finalrank[0]][2] / 100, 166, 95 + n5, 65);
            this.drawMGDialog(graphics, "Congratulations!" + this.res.RaceHorsesName[this.res.betindex] + "win the race.", 25, GAME_HEIGHT * 2 / 3, GAME_WIDTH - 50, 70, false);
        } else {
            this.drawMGDialog(graphics, "Remember to read the horse racing post next time!", 25, GAME_HEIGHT * 2 / 3, GAME_WIDTH - 50, 70, false);
            graphics.drawString("0", 166, 95 + n5, 65);
        }
        graphics.drawString("" + this.res.OwnerMoney, 166, 95 + n5 * 2, 65);
        if (this.res.taskrequire) {
            this.drawTaskDialog(graphics, this.res.TaskResult[this.res.taskid][this.res.taskdone - 1], this.res.TaskChar[this.res.taskid]);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawRacingAward(Graphics graphics) {
        int[] nArray = new int[]{10384128, 16444558, 10384128, 1787648};
        int n = 0 - nArray.length;
        int n2 = 0;
        int n3 = GAME_WIDTH + nArray.length * 2;
        int n4 = 49;
        for (int i = 0; i < nArray.length; ++i) {
            graphics.setColor(nArray[i]);
            graphics.fillRect(n + i, n2 + i, n3 - i * 2, n4 - i * 2);
        }
        graphics.drawImage(images[4], GAME_WIDTH / 2, n2 + nArray.length, 17);
        this.drawOutlinedString(graphics, this.res.RACE_NAME[this.res.raceid], GAME_WIDTH / 2, 30, 65, 10384128, 16775369);
        graphics.drawImage(images[113], GAME_WIDTH / 2 - (this.res.RACE_NAME[this.res.raceid].length() / 2 + 1) * graphics.getFont().getHeight(), 40, 33);
        graphics.drawImage(images[116], GAME_WIDTH / 2 + (this.res.RACE_NAME[this.res.raceid].length() / 2 + 1) * graphics.getFont().getHeight(), 40, 33);
        graphics.drawImage(images[this.IMAGE_CUP[this.res.playerAward]], GAME_WIDTH / 2, 164, 33);
        graphics.drawImage(images[3], GAME_WIDTH / 2, 170, 33);
        this.drawOutlinedBox(graphics, 1, GAME_HEIGHT - 70, GAME_WIDTH - 2, 70);
        int[] nArray2 = new int[]{625, 250, 125};
        graphics.setColor(0);
        this.drawMGDialog(graphics, "Congratulations! You WIN!" + this.res.RACE_ATTRIBUTE[this.res.raceid][3] * nArray2[this.res.playerAward], 8, GAME_HEIGHT - 60, GAME_WIDTH - 16, 55, false);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawBetTips(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        graphics.drawImage(images[94], GAME_WIDTH / 2, 0, 17);
        graphics.setColor(82, 151, 143);
        graphics.fillRect(4, 92, 9, 154);
        graphics.setColor(181, 215, 211);
        graphics.fillRect(6, 93, 2, 154);
        int n = 8;
        int n2 = 5;
        int n3 = 0;
        try {
            n3 = 92 + (154 - n2) * dialog_index / (dialog_length - dialog_displayheight);
        }
        catch (Exception exception) {
            n3 = 92;
        }
        graphics.setColor(176, 255, 239);
        graphics.fillRect(3, n3, 13, 8);
        graphics.setColor(24, 92, 168);
        graphics.drawRect(3, n3, 13, 8);
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        graphics.drawImage(images[40], GAME_WIDTH - 2, GAME_HEIGHT - 1, 40);
        graphics.setColor(0, 0, 0);
        this.drawMGDialog(graphics, this.res.betTipsString, 20, 92, 212, 150, false);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawHorseStatus(Graphics graphics) {
        int n = 76;
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Horse Info", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        this.drawOutlinedBox(graphics, 10, 50, GAME_WIDTH - 20 + 5, 190);
        int n2 = 28;
        int n3 = 57;
        int n4 = 25;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(18, n3, 90, n4);
        graphics.fillRect(18, n3 + n2, 90, n4);
        graphics.fillRect(18, n3 + n2 * 2, 90, n4);
        graphics.fillRect(18, n3 + n2 * 3, 90, n4);
        graphics.fillRect(18, n3 + n2 * 4, 90, n4);
        graphics.fillRect(18, n3 + n2 * 5, 90, n4);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Horse", 63, n, 65);
        graphics.drawString("Speed", 63, n + n2, 65);
        graphics.drawString("Records", 63, n + n2 * 2, 65);
        graphics.drawString("Status", 63, n + n2 * 3, 65);
        graphics.drawString("Race Class", 63, n + n2 * 4, 65);
        graphics.drawString("Rating", 63, n + n2 * 5, 65);
        graphics.setColor(221, 221, 190);
        graphics.fillRect(108, n3, 116, n4);
        graphics.fillRect(108, n3 + n2, 116, n4);
        graphics.fillRect(108, n3 + n2 * 2, 116, n4);
        graphics.fillRect(108, n3 + n2 * 3, 116, n4);
        graphics.fillRect(108, n3 + n2 * 4, 116, n4);
        graphics.fillRect(108, n3 + n2 * 5, 116, n4);
        graphics.setColor(0);
        graphics.drawString("" + this.res.OwnerHorseName, 166, n, 65);
        graphics.drawString("" + this.res.OwnerHorseMt / 100, 166, n + n2, 65);
        graphics.drawString("" + this.res.RaceRecord.size() + "(" + this.res.WinRecord.size() + " Wins)", 166, n + n2 * 2, 65);
        graphics.drawImage(images[59], 166, n + n2 * 3 + 2, 33);
        this.drawClipImage(graphics, images[62], 166, n + n2 * 3 + 2, this.res.OwnerHorseStatus * images[62].getWidth() / 3, 0, images[62].getWidth() / 3, images[62].getHeight(), 33);
        graphics.drawString("" + this.res.HOUSE_GRADE[this.res.OwnerHorseLevel], 166, n + n2 * 4, 65);
        graphics.drawString("" + this.res.OwnerHorseScore, 166, n + n2 * 5, 65);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawMinigameResult(Graphics graphics) {
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Training Result", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        this.drawOutlinedBox(graphics, 10, 50, GAME_WIDTH - 20 + 5, 190);
        graphics.setFont(F_TITLE);
        graphics.drawImage(images[132], 60, 110, 33);
        this.drawClipImage(graphics, images[125], GAME_WIDTH / 2, 110, images[125].getWidth() * this.res.gamerank / 5, 0, images[125].getWidth() / 5, images[125].getHeight(), 33);
        graphics.setFont(F_SMALL);
        graphics.setColor(148, 148, 74);
        graphics.fillRect(18, GAME_HEIGHT / 2, 90, 25);
        graphics.drawRect(18, GAME_HEIGHT / 5 * 3 + 10, 206, 60);
        graphics.setColor(222, 221, 190);
        graphics.fillRect(108, GAME_HEIGHT / 2, 116, 25);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Result", 63, GAME_HEIGHT / 2 + 23, 65);
        graphics.setColor(0);
        graphics.drawString(this.res.gameresult + "%", 166, GAME_HEIGHT / 2 + 23, 65);
        this.drawMGDialog(graphics, this.res.OwnerHorseName + " Speed Increased to " + this.res.OwnerHorseMt / 100, 24, GAME_HEIGHT / 5 * 3 + 10, 190, 55, false);
        try {
            GameDisplay.loadImage(GameResource.horseimage[this.res.OwnerHorseID][0]);
            graphics.drawImage(images[GameResource.horseimage[this.res.OwnerHorseID][0]], 180 - this.horsewidth / 2, 110, 36);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.drawImage(images[this.IMAGE_JOCKEY[0][0]], 180 + this.horseshiftX[this.res.raceimage] - this.horsewidth / 2, 110 - this.horseshiftY[this.res.raceimage], 36);
        if (this.res.taskrequire) {
            this.drawTaskDialog(graphics, this.res.TaskResult[this.res.taskid][this.res.taskdone - 1], this.res.TaskChar[this.res.taskid]);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawStrategyPage(Graphics graphics) {
        int n;
        int n2;
        for (n2 = 0; n2 < GAME_WIDTH; n2 += images[118].getWidth()) {
            for (n = 0; n < GAME_HEIGHT; n += images[117].getHeight()) {
                graphics.drawImage(images[117], n2, n, 20);
            }
        }
        for (n2 = 0; n2 < GAME_WIDTH; n2 += images[118].getWidth()) {
            graphics.drawImage(images[118], n2, 37, 20);
        }
        for (n2 = 0; n2 < GAME_WIDTH; n2 += images[101].getWidth()) {
            graphics.drawImage(images[101], n2, 37 + images[118].getHeight() + 2, 36);
        }
        this.drawTitleBoard(graphics, "", -1);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Acceleration", images[92].getWidth() / 2, 27, 65, 869376, 0xFFFFFF);
        this.drawOutlinedBox(graphics, 37, 45, GAME_WIDTH - 74, 198);
        graphics.setColor(149, 149, 74);
        graphics.fillRect(48, 56, GAME_WIDTH - 96, 27);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Acceleration", GAME_WIDTH / 2, 79, 65);
        graphics.setColor(88, 131, 80);
        graphics.drawRect((GAME_WIDTH - 142) / 2, 87, 142, 146);
        n2 = 36;
        for (n = 0; n < this.res.strategyoption.length; ++n) {
            if (this.res.strategyindex == n) {
                graphics.drawImage(images[32], GAME_WIDTH / 2, 121 + n2 * n, 33);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.drawImage(images[31], GAME_WIDTH / 2, 121 + n2 * n, 33);
                graphics.setColor(0);
            }
            graphics.drawString(this.res.strategyoption[n], GAME_WIDTH / 2, 116 + n2 * n - 3, 65);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawMask(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setClip(n, n2, n3, n4);
        try {
            GameDisplay.loadImage(88);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.drawImage(images[88], n, n2, 20);
        graphics.setClip(0, 0, GAME_WIDTH, GAME_HEIGHT);
    }

    public void drawViewHorseStatus(Graphics graphics) {
        graphics.setColor(77, 189, 57);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Observation", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        this.drawOutlinedBox(graphics, 0, 45, GAME_WIDTH, 195);
        graphics.setColor(89, 130, 80);
        graphics.drawRect(6, 53, GAME_WIDTH - 12, 24);
        graphics.drawString("Horse Details", 70, 72, 65);
        int n = 96;
        int n2 = 23;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(6, 79, 55, 21);
        graphics.fillRect(6, 79 + n2, 55, 21);
        graphics.fillRect(6, 79 + n2 * 2, 55, 21);
        graphics.fillRect(6, 79 + n2 * 3, 55, 21);
        graphics.fillRect(6, 79 + n2 * 4, 55, 21);
        graphics.fillRect(6, 79 + n2 * 5, 55, 21);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Horse", 33, n, 65);
        graphics.drawString("Place", 33, n + n2, 65);
        graphics.drawString("No.", 33, n + n2 * 2, 65);
        graphics.drawString("Owner", 33, n + n2 * 3, 65);
        graphics.drawString("Rating", 33, n + n2 * 4, 65);
        graphics.drawString("Record", 33, n + n2 * 5, 65);
        graphics.setColor(221, 221, 190);
        graphics.fillRect(62, 79, 85, 21);
        graphics.fillRect(62, 79 + n2, 85, 21);
        graphics.fillRect(62, 79 + n2 * 2, 85, 21);
        graphics.fillRect(62, 79 + n2 * 3, 85, 21);
        graphics.fillRect(62, 79 + n2 * 4, 85, 21);
        graphics.fillRect(62, 79 + n2 * 5, 85, 21);
        graphics.setColor(0);
        graphics.drawString("" + this.res.RaceHorsesName[this.res.racestatusindex * 2], 103, n, 65);
        graphics.drawString("" + this.res.RaceHorsesOwner[this.res.racestatusindex * 2], 103, n + n2 * 3, 65);
        graphics.drawString("" + (this.res.racestatusindex * 2 + 1), 103, n + n2, 65);
        graphics.drawString("" + this.res.RaceHorses[this.res.racestatusindex * 2][3], 103, n + n2 * 2, 65);
        graphics.drawString("" + this.res.RaceHorses[this.res.racestatusindex * 2][1], 103, n + n2 * 4, 65);
        graphics.drawString("" + this.res.RaceHorses[this.res.racestatusindex * 2][4] + "(" + this.res.RaceHorses[this.res.racestatusindex * 2][5] + " Wins)", 103, n + n2 * 5, 65);
        if (this.res.racestatusindex * 2 + 1 < this.res.RaceHorses.length) {
            graphics.setColor(221, 221, 190);
            graphics.fillRect(149, 79, 85, 21);
            graphics.fillRect(149, 79 + n2, 85, 21);
            graphics.fillRect(149, 79 + n2 * 2, 85, 21);
            graphics.fillRect(149, 79 + n2 * 3, 85, 21);
            graphics.fillRect(149, 79 + n2 * 4, 85, 21);
            graphics.fillRect(149, 79 + n2 * 5, 85, 21);
            graphics.setColor(0);
            graphics.drawString("" + this.res.RaceHorsesName[this.res.racestatusindex * 2 + 1], 191, n, 65);
            graphics.drawString("" + (this.res.racestatusindex * 2 + 2), 191, n + n2, 65);
            graphics.drawString("" + this.res.RaceHorses[this.res.racestatusindex * 2 + 1][3], 191, n + n2 * 2, 65);
            graphics.drawString("" + this.res.RaceHorsesOwner[this.res.racestatusindex * 2 + 1], 191, n + n2 * 3, 65);
            graphics.drawString("" + this.res.RaceHorses[this.res.racestatusindex * 2 + 1][1], 191, n + n2 * 4, 65);
            graphics.drawString(this.res.RaceHorses[this.res.racestatusindex * 2 + 1][4] + "(" + this.res.RaceHorses[this.res.racestatusindex * 2 + 1][5] + " Wins)", 191, n + n2 * 5, 65);
        }
        graphics.drawImage(images[22], 65, 217, 20);
        graphics.drawImage(images[27], 182, 217, 20);
        graphics.drawString(this.res.racestatusindex + 1 + "/" + (this.res.opponentNumber + 2) / 2, 128, 230, 65);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawBetPage(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < GAME_WIDTH; n4 += images[118].getWidth()) {
            for (n3 = 0; n3 < GAME_HEIGHT; n3 += images[117].getHeight()) {
                graphics.drawImage(images[117], n4, n3, 20);
            }
        }
        for (n4 = 0; n4 < GAME_WIDTH; n4 += images[118].getWidth()) {
            graphics.drawImage(images[118], n4, 37, 20);
        }
        for (n4 = 0; n4 < GAME_WIDTH; n4 += images[101].getWidth()) {
            graphics.drawImage(images[101], n4, 37 + images[118].getHeight() + 2, 36);
        }
        this.drawTitleBoard(graphics, "", -1);
        this.drawOutlinedString(graphics, "WEEK " + (this.res.date + 1), GAME_WIDTH - 3, 17, 72, 0, 0xFFFFFF);
        this.drawOutlinedString(graphics, "$ " + this.res.OwnerMoney, GAME_WIDTH - 3, 19, 24, 0, 0xFFFFFF);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Bet", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(32, 52, 196, 147);
        graphics.setColor(0);
        graphics.drawRect(32, 52, 196, 147);
        graphics.drawImage(images[7], 130, 53, 17);
        graphics.drawImage(images[8], 130, 149, 17);
        graphics.drawImage(images[13], 93, 86, 33);
        graphics.setColor(0xFF0000);
        graphics.drawString("Win Odds", 193, 81, 65);
        graphics.fillRect(44, 87, 173, 1);
        graphics.fillRect(44, 90, 173, 20);
        graphics.fillRect(128, 151, 7, 47);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(F_SMALL);
        graphics.drawString("Horse Number", 130, 104, 65);
        graphics.setFont(F_NORMAL);
        n4 = 56;
        n3 = 135;
        int n5 = 21;
        int n6 = 45;
        for (n2 = 0; n2 < this.res.RaceHorses.length; ++n2) {
            if (n2 < 8) {
                graphics.setColor(0xFF0000);
                graphics.drawImage(images[15], n4 + n5 * n2, 113, 17);
                graphics.drawString("" + (n2 + 1), n4 + n5 * n2, n3, 65);
                continue;
            }
            graphics.setColor(0xFF0000);
            graphics.drawImage(images[15], n4 + n5 * (n2 - 8), 113 + n6, 17);
            graphics.drawString("" + (n2 + 1), n4 + n5 * (n2 - 8), n3 + n6, 65);
        }
        for (n2 = 0; n2 < this.res.RaceHorses.length; ++n2) {
            int n7;
            if (n2 < 8) {
                graphics.setColor(0xFF0000);
                if (n2 == this.res.betindex) {
                    if (this.res.betStatePointer == 0) {
                        n7 = -7;
                        if (System.currentTimeMillis() % 1500L > 500L) {
                            n7 = -1;
                        } else if (System.currentTimeMillis() % 1500L > 1000L) {
                            n7 = 5;
                        }
                        graphics.drawImage(images[96], 59 + n5 * n2, 133 + n7, 36);
                    }
                    graphics.setColor(0, 0, 0);
                }
                if (n2 != this.res.betHorseID || this.res.betHorseID == -1) continue;
                graphics.drawImage(images[5], 53 + n5 * n2, 113, 20);
                continue;
            }
            graphics.setColor(0xFF0000);
            if (n2 == this.res.betindex && this.res.betStatePointer == 0) {
                n7 = -7;
                if (System.currentTimeMillis() % 1500L > 500L) {
                    n7 = -1;
                } else if (System.currentTimeMillis() % 1500L > 1000L) {
                    n7 = 5;
                }
                if (this.res.betStatePointer == 0 && n2 == this.res.betindex) {
                    graphics.drawImage(images[96], 59 + n5 * (n2 - 8), 133 + n6 + n7, 36);
                }
            }
            if (n2 != this.res.betHorseID || this.res.betHorseID == -1) continue;
            graphics.drawImage(images[5], 53 + n5 * (n2 - 8), 113 + n6, 20);
        }
        graphics.drawImage(images[14], 163, 161, 33);
        graphics.drawImage(images[16], 157, 178, 33);
        graphics.drawImage(images[16], 201, 178, 33);
        graphics.drawImage(images[16], 157, 195, 33);
        graphics.drawImage(images[16], 201, 195, 33);
        graphics.drawImage(images[12], 157, 178, 33);
        graphics.drawImage(images[11], 201, 178, 33);
        graphics.drawImage(images[10], 157, 195, 33);
        graphics.drawImage(images[9], 201, 195, 33);
        int[] nArray = new int[]{141, 185, 141, 185};
        int[] nArray2 = new int[]{168, 168, 185, 185};
        if (this.res.betStatePointer == 1) {
            n = 0;
            if (System.currentTimeMillis() % 1500L > 500L) {
                n = -13;
            } else if (System.currentTimeMillis() % 1500L > 1000L) {
                n = -27;
            }
            graphics.drawImage(images[96], nArray[this.res.betValuePointer] + 26 + n, nArray2[this.res.betValuePointer], 36);
        }
        graphics.setColor(0);
        if (this.res.betmoney > 0) {
            for (n = 0; n < this.res.betValue.length; ++n) {
                if (this.res.betmoney != this.res.betValue[n]) continue;
                graphics.drawImage(images[6], nArray[n], nArray2[n], 20);
            }
        }
        if (this.res.betStatePointer == 0) {
            graphics.setColor(244, 253, 224);
            graphics.fillRect(-4, 203, GAME_WIDTH + 8, 41);
            graphics.setColor(60, 90, 56);
            graphics.fillRect(-3, 204, GAME_WIDTH + 8 - 2, 39);
            graphics.setColor(244, 253, 224);
            graphics.fillRect(-1, 206, GAME_WIDTH + 8 - 6, 35);
            graphics.setColor(0);
            graphics.drawString(this.res.betindex + 1 + "." + this.res.RaceHorsesName[this.res.betindex], 58, 231, 65);
            graphics.setColor(148, 148, 74);
            graphics.fillRect(145, 210, 92, 27);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("Odds " + this.res.RaceHorses[this.res.betindex][2] / 100 + "." + this.res.RaceHorses[this.res.betindex][2] % 100, 191, 231, 65);
        } else {
            graphics.setColor(244, 253, 224);
            graphics.fillRect(120, 203, 104, 32);
            graphics.setColor(60, 90, 56);
            graphics.fillRect(121, 204, 102, 30);
            graphics.setColor(244, 253, 224);
            graphics.fillRect(123, 206, 98, 26);
            graphics.drawImage(images[36], 146, 219 - images[36].getHeight() / 2, 17);
            graphics.drawImage(images[26], 198, 219 - images[36].getHeight() / 2, 17);
            if (this.res.betStatePointer == 2) {
                if (this.res.cardConfirm) {
                    this.drawMask(graphics, 198 - images[36].getWidth() / 2, 219 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
                } else {
                    this.drawMask(graphics, 146 - images[36].getWidth() / 2, 219 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
                }
                this.drawOutlinedBox(graphics, 0, 203, 110, 32);
                graphics.setColor(0, 0, 0);
                if (this.res.cardConfirm) {
                    graphics.drawString("Confirm Betting", 55, 222, 65);
                } else {
                    graphics.drawString("Refuse Betting", 55, 222, 65);
                }
            } else {
                this.drawMask(graphics, 198 - images[36].getWidth() / 2, 219 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
                this.drawMask(graphics, 146 - images[36].getWidth() / 2, 219 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
                this.drawOutlinedBox(graphics, 0, 203, 110, 32);
                graphics.setColor(0, 0, 0);
                graphics.drawString("Betting Amount", 55, 222, 65);
            }
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "MGPost", false);
        graphics.drawImage(images[61], GAME_WIDTH - 3, GAME_HEIGHT, 40);
        graphics.setColor(0xFFFFFF);
        graphics.setFont(F_SMALL);
        graphics.drawString("Press 0 to cancel the bet", GAME_WIDTH / 2, GAME_HEIGHT, 65);
        graphics.setFont(F_NORMAL);
    }

    public void drawTrack(Graphics graphics, int n) {
        int n2;
        graphics.setClip(0, 49, GAME_WIDTH, 135);
        for (n2 = this.res.animationBoardX - images[118].getWidth(); n2 < GAME_WIDTH; n2 += images[118].getWidth()) {
            for (int i = 37 + n; i < GAME_HEIGHT; i += images[117].getHeight()) {
                graphics.drawImage(images[117], n2, i, 20);
            }
            graphics.drawImage(images[118], n2, n + 53, 20);
        }
        graphics.setColor(82, 98, 53);
        graphics.fillRect(0, n + 80, GAME_WIDTH, 2);
        graphics.setColor(1, 63, 0);
        graphics.fillRect(0, n + 82, GAME_WIDTH, 1);
        if (this.res.iState == 13) {
            for (n2 = 0; n2 < this.res.disbar[0].length; ++n2) {
                graphics.setClip(0, 49, GAME_WIDTH, 135);
                if ((this.res.totaldistance - this.res.disbar[1][n2]) % 400 == 0 && this.res.totaldistance - this.res.disbar[1][n2] != 0) {
                    graphics.drawImage(images[98], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 78, 33);
                } else if (this.res.totaldistance - this.res.disbar[1][n2] == 0) {
                    graphics.drawImage(images[100], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 78, 33);
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(GAME_WIDTH - this.res.disbar[0][n2] + 5 - 2, 67 + n, 2, 130 - n);
                    graphics.fillRect(GAME_WIDTH - this.res.disbar[0][n2] + 5 - 2 + 3, 67 + n, 2, 130 - n);
                }
                if (this.res.totaldistance - this.res.disbar[1][n2] == 2000) {
                    this.drawClipImage(graphics, images[129], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 60, images[129].getWidth() / 5 * 4, 0, images[129].getWidth() / 5, images[129].getHeight(), 33);
                    continue;
                }
                if (this.res.totaldistance - this.res.disbar[1][n2] == 1600) {
                    this.drawClipImage(graphics, images[129], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 60, images[129].getWidth() / 5 * 3, 0, images[129].getWidth() / 5, images[129].getHeight(), 33);
                    continue;
                }
                if (this.res.totaldistance - this.res.disbar[1][n2] == 1200) {
                    this.drawClipImage(graphics, images[129], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 60, images[129].getWidth() / 5 * 2, 0, images[129].getWidth() / 5, images[129].getHeight(), 33);
                    continue;
                }
                if (this.res.totaldistance - this.res.disbar[1][n2] == 800) {
                    this.drawClipImage(graphics, images[129], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 60, images[129].getWidth() / 5, 0, images[129].getWidth() / 5, images[129].getHeight(), 33);
                    continue;
                }
                if (this.res.totaldistance - this.res.disbar[1][n2] != 400) continue;
                this.drawClipImage(graphics, images[129], GAME_WIDTH - this.res.disbar[0][n2] + 5, n + 60, 0, 0, images[129].getWidth() / 5, images[129].getHeight(), 33);
            }
        }
        graphics.setClip(0, 49, GAME_WIDTH, 135);
        for (n2 = this.res.animationBoardX - images[118].getWidth(); n2 < GAME_WIDTH; n2 += images[101].getWidth()) {
            graphics.drawImage(images[101], n2, n + 84, 36);
        }
        graphics.setClip(0, 0, GAME_WIDTH, GAME_HEIGHT);
    }

    public void drawMiniGame(Graphics graphics) {
        graphics.setColor(68, 188, 17);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        graphics.setColor(73, 117, 12);
        graphics.fillRect(0, 0, GAME_WIDTH, 3);
        graphics.setColor(85, 146, 24);
        graphics.fillRect(0, 3, GAME_WIDTH, 4);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 7, GAME_WIDTH, 33);
        graphics.setColor(154, 207, 48);
        graphics.fillRect(0, 40, GAME_WIDTH, 6);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 46, GAME_WIDTH, 3);
        graphics.drawImage(images[89], GAME_WIDTH, 0, 24);
        graphics.setColor(16, 107, 0);
        graphics.fillRect(0, 47, GAME_WIDTH, 5);
        graphics.setColor(66, 173, 24);
        graphics.fillRect(0, 48, GAME_WIDTH, 3);
        graphics.setColor(198, 255, 148);
        graphics.fillRect(0, 49, GAME_WIDTH, 1);
        graphics.setColor(16, 107, 0);
        graphics.fillRect(0, 186, GAME_WIDTH, 5);
        graphics.setColor(66, 173, 24);
        graphics.fillRect(0, 187, GAME_WIDTH, 3);
        graphics.setColor(198, 255, 148);
        graphics.fillRect(0, 188, GAME_WIDTH, 1);
        graphics.setColor(23, 110, 0);
        graphics.fillRect(0, 191, GAME_WIDTH, 49);
        graphics.setColor(22, 134, 0);
        graphics.fillRect(0, 196, GAME_WIDTH, 39);
        graphics.setColor(29, 156, 0);
        graphics.fillRect(0, 202, GAME_WIDTH, 27);
        graphics.setColor(41, 168, 24);
        graphics.fillRect(0, 210, GAME_WIDTH, 13);
        graphics.setColor(65, 190, 27);
        graphics.fillRect(0, 215, GAME_WIDTH, 2);
        graphics.setColor(16, 107, 0);
        graphics.fillRect(0, 246, GAME_WIDTH, 5);
        graphics.setColor(66, 173, 24);
        graphics.fillRect(0, 247, GAME_WIDTH, 3);
        graphics.setColor(198, 255, 148);
        graphics.fillRect(0, 248, GAME_WIDTH, 1);
        this.drawTrack(graphics, 0);
        graphics.drawImage(images[4], GAME_WIDTH / 2, 191, 17);
        try {
            GameDisplay.loadImage(GameResource.horseimage[this.res.OwnerHorseID][this.res.raceimage]);
            graphics.drawImage(images[GameResource.horseimage[this.res.OwnerHorseID][this.res.raceimage]], GAME_WIDTH - this.res.distance[0] + this.horsewidth / 2, GAME_HEIGHT / 2, 40);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.drawImage(images[this.IMAGE_JOCKEY[0][this.res.raceimage]], GAME_WIDTH - this.res.distance[0] + this.horseshiftX[this.res.raceimage] - this.horsewidth / 2, GAME_HEIGHT / 2 - this.horseshiftY[this.res.raceimage], 36);
        graphics.setColor(0);
        this.drawOutlinedString(graphics, "Training Gait", 57, 25, 65, 0xFFFFFF, 0);
        this.drawOutlinedString(graphics, "LV " + (this.res.OwnerStablesLvl + 1), 143, 25, 65, 0xFFFFFF, 0);
        graphics.setColor(0xCF3333);
        graphics.fillRect(GAME_WIDTH - 10 - images[123].getWidth() / 2, 191, GAME_WIDTH, 49);
        graphics.setColor(0xDD3737);
        graphics.fillRect(GAME_WIDTH - 10 - images[123].getWidth() / 2, 196, GAME_WIDTH, 39);
        graphics.setColor(14893377);
        graphics.fillRect(GAME_WIDTH - 10 - images[123].getWidth() / 2, 202, GAME_WIDTH, 27);
        graphics.setColor(15226454);
        graphics.fillRect(GAME_WIDTH - 10 - images[123].getWidth() / 2, 210, GAME_WIDTH, 13);
        graphics.setColor(0xEC6666);
        graphics.fillRect(GAME_WIDTH - 10 - images[123].getWidth() / 2, 215, GAME_WIDTH, 2);
        int n = 231;
        int n2 = 26;
        for (int i = 0; i < this.res.game_ball.length; ++i) {
            graphics.drawImage(images[123], this.res.game_ball[i][0], n, 36);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("" + this.res.game_ball[i][1], this.res.game_ball[i][0] + images[123].getWidth() / 2, 222, 65);
        }
        graphics.setColor(234, 18, 18);
        graphics.fillRect(GAME_WIDTH - 10 - images[123].getWidth() / 2, 192, 4, 47);
        graphics.setColor(253, 232, 232);
        graphics.fillRect(GAME_WIDTH - 9 - images[123].getWidth() / 2, 193, 2, 47);
        graphics.drawImage(images[124], GAME_WIDTH / 2, 185, 33);
        if (this.res.bonusspeed == 3) {
            graphics.setColor(234, 18, 18);
            this.drawClipImage(graphics, images[128], 211, 182, 0, 0, images[128].getWidth() / 3, images[128].getHeight(), 33);
            this.res.bonusspeed = 0;
        } else if (this.res.bonusspeed == 2) {
            graphics.setColor(234, 18, 18);
            this.drawClipImage(graphics, images[128], 211, 182, images[128].getWidth() / 3, 0, images[128].getWidth() / 3, images[128].getHeight(), 33);
            this.res.bonusspeed = 0;
        } else if (this.res.bonusspeed == 1) {
            graphics.setColor(234, 18, 18);
            this.drawClipImage(graphics, images[128], 211, 182, images[128].getWidth() / 3 * 2, 0, images[128].getWidth() / 3, images[128].getHeight(), 33);
            this.res.bonusspeed = 0;
        }
        this.drawMGCommandOK(graphics, null, "", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        graphics.drawImage(images[40], GAME_WIDTH - 2, GAME_HEIGHT - 1, 40);
    }

    public void drawUpgradeStable(Graphics graphics) {
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "H/W Upgrade", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        int n = 10;
        int n2 = 50;
        int n3 = GAME_WIDTH - n * 2 + 5;
        int n4 = 190;
        this.drawOutlinedBox(graphics, n, n2, n3, n4);
        graphics.drawImage(images[64], 18, 57, 20);
        graphics.setColor(148, 148, 74);
        graphics.fillRect(90, 57, 134, 22);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Course", 157, 77, 65);
        int n5 = 25;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(18, 120, 90, 23);
        graphics.fillRect(18, 120 + n5, 90, 23);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Money", 63, 138, 65);
        graphics.drawString("Upgr. Fee", 63, 138 + n5, 65);
        graphics.setColor(221, 221, 190);
        graphics.fillRect(108, 120, 116, 23);
        graphics.fillRect(108, 120 + n5, 116, 23);
        graphics.fillRect(108, 120 + n5 * 2, 116, 23);
        graphics.setColor(0);
        graphics.drawString("" + this.res.OwnerMoney, 166, 138, 65);
        graphics.drawString("" + this.res.STABLE_ATTRIBUTE[this.res.OwnerStablesLvl] * 1000, 166, 138 + n5, 65);
        graphics.drawString("" + (this.res.OwnerMoney - this.res.STABLE_ATTRIBUTE[this.res.OwnerStablesLvl] * 1000), 166, 138 + n5 * 2, 65);
        graphics.drawImage(images[126], 107, 114, 33);
        this.drawClipImage(graphics, images[127], 127, 114, images[127].getWidth() / 6 * this.res.OwnerStablesLvl, 0, images[127].getWidth() / 6, images[127].getHeight(), 33);
        graphics.drawImage(images[63], 153, 105, 17);
        graphics.drawImage(images[126], 183, 114, 33);
        this.drawClipImage(graphics, images[127], 203, 114, images[127].getWidth() / 6 * (this.res.OwnerStablesLvl + 1), 0, images[127].getWidth() / 6, images[127].getHeight(), 33);
        graphics.setColor(244, 254, 224);
        graphics.fillRect(120, 200, 104, 34);
        graphics.setColor(61, 91, 56);
        graphics.drawRect(120, 200, 104, 34);
        graphics.drawImage(images[36], 146, 217 - images[36].getHeight() / 2, 17);
        graphics.drawImage(images[26], 198, 217 - images[36].getHeight() / 2, 17);
        if (this.res.upgradeindex == 1) {
            this.drawMask(graphics, 198 - images[36].getWidth() / 2, 217 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        } else {
            this.drawMask(graphics, 146 - images[36].getWidth() / 2, 217 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawArrageRace(Graphics graphics) {
        int n;
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Race Arranging", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        this.drawOutlinedString(graphics, "WEEK " + (this.res.date + 1), GAME_WIDTH - 3, 17, 72, 0, 0xFFFFFF);
        this.drawOutlinedString(graphics, "$ " + this.res.OwnerMoney, GAME_WIDTH - 3, 19, 24, 0, 0xFFFFFF);
        this.drawOutlinedBox(graphics, 2, 97, GAME_WIDTH - 4, 147);
        int[] nArray = new int[]{10384128, 16444558, 10384128, 1787648};
        int n2 = 0 - nArray.length;
        int n3 = 48;
        int n4 = GAME_WIDTH + nArray.length * 2;
        int n5 = 48;
        for (n = 0; n < nArray.length; ++n) {
            graphics.setColor(nArray[n]);
            graphics.fillRect(n2 + n, n3 + n, n4 - n * 2, n5 - n * 2);
        }
        graphics.drawImage(images[4], GAME_WIDTH / 2, n3 + nArray.length, 17);
        this.drawOutlinedString(graphics, this.res.RACE_NAME[this.res.raceid], GAME_WIDTH / 2, 80, 65, 10384128, 16775369);
        graphics.drawImage(images[113], GAME_WIDTH / 2 - (this.res.RACE_NAME[this.res.raceid].length() / 2 + 1) * graphics.getFont().getHeight(), 83, 33);
        graphics.drawImage(images[116], GAME_WIDTH / 2 + (this.res.RACE_NAME[this.res.raceid].length() / 2 + 1) * graphics.getFont().getHeight(), 83, 33);
        n = 27;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(18, 106, 90, 25);
        graphics.fillRect(18, 106 + n, 90, 25);
        graphics.drawRect(10, 168, GAME_WIDTH - 20, 69);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Awards", 63, 126, 65);
        graphics.drawString("Fee", 63, 126 + n, 65);
        graphics.setColor(221, 221, 190);
        graphics.fillRect(108, 106, 116, 25);
        graphics.fillRect(108, 106 + n, 116, 25);
        graphics.setColor(0);
        graphics.drawString("" + this.res.RACE_ATTRIBUTE[this.res.raceid][3] + "K", 166, 126, 65);
        if (this.res.specialRace < 0) {
            graphics.drawString("" + this.res.RACE_ATTRIBUTE[this.res.raceid][4], 166, 126 + n, 65);
        } else {
            graphics.drawString("" + this.res.RACE_ATTRIBUTE[this.res.raceid][3] * 2, 166, 126 + n, 65);
        }
        graphics.setColor(0);
        graphics.setFont(F_SMALL);
        this.drawMGDialog(graphics, "Participating the game?", 15, 170, GAME_WIDTH - 30, 59, false);
        graphics.setFont(F_NORMAL);
        graphics.setColor(244, 254, 224);
        graphics.fillRect(110, 200, 104, 32);
        graphics.setColor(61, 91, 56);
        graphics.drawRect(110, 200, 104, 32);
        graphics.drawImage(images[36], 136, 216 - images[36].getHeight() / 2, 17);
        graphics.drawImage(images[26], 188, 216 - images[36].getHeight() / 2, 17);
        if (this.res.arrangePageIsRace) {
            this.drawMask(graphics, 188 - images[36].getWidth() / 2, 216 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        } else {
            this.drawMask(graphics, 136 - images[36].getWidth() / 2, 216 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawViewRecord(Graphics graphics) {
        int n = 73;
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[92], 0, 8, 20);
        if (this.res.iState == 19) {
            this.drawOutlinedString(graphics, "Race Record", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        } else {
            this.drawOutlinedString(graphics, "User Information", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        }
        int n2 = 10;
        int n3 = 50;
        int n4 = GAME_WIDTH - n2 * 2 + 7;
        int n5 = 190;
        this.drawOutlinedBox(graphics, n2, n3, n4, n5);
        int n6 = 24;
        int n7 = 22;
        int n8 = 56;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(18, n8, 90, n7);
        graphics.fillRect(18, n8 + n6, 90, n7);
        graphics.fillRect(18, n8 + n6 * 2, 90, n7);
        graphics.fillRect(18, n8 + n6 * 3, 90, n7);
        graphics.fillRect(18, n8 + n6 * 4, 90, n7);
        graphics.drawRect(18, 175, 192, 56);
        graphics.fillRect(18, 203, 192, 1);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Owner", 63, n, 65);
        graphics.drawString("Money", 63, n + n6, 65);
        graphics.drawString("Awards", 63, n + n6 * 2, 65);
        graphics.drawString("Horse", 63, n + n6 * 3, 65);
        graphics.drawString("Race record", 63, n + n6 * 4, 65);
        graphics.setColor(221, 221, 190);
        graphics.fillRect(108, n8, 116, n7);
        graphics.fillRect(108, n8 + n6, 116, n7);
        graphics.fillRect(108, n8 + n6 * 2, 116, n7);
        graphics.fillRect(108, n8 + n6 * 3, 116, n7);
        graphics.setColor(0);
        graphics.drawString("" + this.res.OwnerName, 166, n, 65);
        graphics.drawString("" + this.res.OwnerMoney, 166, n + n6, 65);
        graphics.drawString("" + this.res.OwnerBonus, 166, n + n6 * 2, 65);
        graphics.drawString("" + this.res.OwnerHorseName, 166, n + n6 * 3, 65);
        graphics.drawImage(images[33], 221, 178, 17);
        graphics.drawImage(images[19], 221, 230, 33);
        graphics.setColor(0, 0, 0);
        graphics.drawString("WIN record", 30, 198, 68);
        if (this.res.WinRecord.size() > 0) {
            int[] nArray = (int[])this.res.WinRecord.elementAt(this.res.winrcindex);
            graphics.drawString("WEEK " + (nArray[1] + 1), 205, 198, 72);
            graphics.drawString(this.res.RACE_NAME[nArray[0]], 30, 226, 68);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawLobbyMenu(Graphics graphics, String string, String[] stringArray, int n) {
        this.drawTitleBoard(graphics, string, n);
        if (this.res.iState != 2 && this.res.iState != 10) {
            this.drawOutlinedString(graphics, "WEEK " + (this.res.date + 1), GAME_WIDTH - 3, 22, 72, 0, 0xFFFFFF);
            this.drawOutlinedString(graphics, "$ " + this.res.OwnerMoney, GAME_WIDTH - 3, 24, 24, 0, 0xFFFFFF);
        }
        int n2 = 0;
        int n3 = 50;
        int n4 = 29;
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.res.menuindex == i) {
                graphics.drawImage(images[92], n2, n3 + n4 * i, 20);
                this.drawOutlinedString(graphics, stringArray[i], images[92].getWidth() / 2, 70 + i * n4, 65, 804096, 0xFFFFFF);
                continue;
            }
            graphics.drawImage(images[91], n2, n3 + n4 * i, 20);
            graphics.setColor(48, 105, 12);
            graphics.drawString(stringArray[i], images[91].getWidth() / 2, 70 + i * n4, 65);
        }
    }

    public void drawLobbyPage(Graphics graphics) {
        this.drawLobbyMenu(graphics, "", this.res.lobbyoption, 17);
        graphics.drawImage(images[56], 180, 190, 33);
        this.drawOutlinedBox(graphics, 140, 200, 90, 40);
        graphics.setColor(0);
        graphics.drawString("Main Menu", 185, 228, 65);
        if (this.res.inviting) {
            this.drawOutlinedBox(graphics, 2, 98, GAME_WIDTH - 4, 96);
            graphics.drawImage(images[95], 144, 98, 33);
            graphics.setFont(F_SMALL);
            graphics.setColor(0);
            this.drawMGDialog(graphics, "Are you sure to take part in the " + this.res.RACE_NAME[this.res.specialRace] + "?", 10, 108, GAME_WIDTH - 30, 70, false);
            graphics.drawImage(images[36], 120, 170 - images[36].getHeight() / 2, 17);
            graphics.drawImage(images[26], 172, 170 - images[36].getHeight() / 2, 17);
            if (this.res.isSelectedInvite) {
                this.drawMask(graphics, 172 - images[36].getWidth() / 2, 170 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
            } else {
                this.drawMask(graphics, 120 - images[36].getWidth() / 2, 170 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
            }
        } else if (this.res.taskrequire) {
            if (this.res.taskid == 2 && this.res.taskdone > 0) {
                this.drawTaskDialog(graphics, this.res.TaskResult[this.res.taskid][this.res.taskdone - 1], this.res.TaskChar[this.res.taskid]);
            } else {
                this.drawTaskDialog(graphics, this.res.TaskString[this.res.taskid], this.res.TaskChar[this.res.taskid]);
            }
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Pause", false);
    }

    public void drawTaskDialog(Graphics graphics, String string, int n) {
        this.drawOutlinedBox(graphics, 5, GAME_HEIGHT / 2, GAME_WIDTH - 10, GAME_HEIGHT / 2 - 15);
        int[] nArray = new int[]{95, 87, 42, 39, 41};
        try {
            GameDisplay.loadImage(nArray[n]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.drawImage(images[nArray[n]], GAME_WIDTH * 3 / 4, GAME_HEIGHT / 2, 33);
        graphics.setFont(F_SMALL);
        graphics.setColor(0);
        this.drawMGDialog(graphics, string, 20, GAME_HEIGHT / 2 + 15, GAME_WIDTH - 50, GAME_HEIGHT / 2 - 45, false);
        graphics.drawImage(images[33], 220, GAME_HEIGHT / 2 + 15, 17);
        graphics.drawImage(images[19], 220, GAME_HEIGHT - 45, 33);
    }

    public void drawRankingPage(Graphics graphics) {
        this.drawTitleBoard(graphics, "", 17);
        this.drawOutlinedBox(graphics, 10, 50, GAME_WIDTH - 20, 190);
        this.drawOutlinedString(graphics, "Ranking", 152, 31, 65, 0, 0xFFFFFF);
        int n = 36;
        int n2 = 30;
        for (int i = 0; i < this.res.RankingName.length; ++i) {
            graphics.setColor(222, 221, 190);
            graphics.fillRect(45, 58 + i * n, GAME_WIDTH - 65, n2);
            graphics.setColor(0, 0, 0);
            graphics.drawString("" + this.res.RankingName[i], GAME_WIDTH / 3, 80 + i * n, 65);
            graphics.drawString("" + this.res.RankingScore[i], 210, 80 + i * n, 72);
            graphics.setColor(148, 148, 74);
            graphics.fillRect(20, 57 + i * n, 25, n2);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("" + (i + 1) + ".", 33, 80 + i * n, 65);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawRacingRank(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        int n = 35;
        graphics.setColor(255, 226, 88);
        graphics.drawString("Place", 23, 50, 65);
        graphics.drawString("Number", 86, 50, 65);
        graphics.drawString("Horse", 182, 50, 65);
        for (int i = 0; i < 5; ++i) {
            graphics.drawImage(images[119], GAME_WIDTH / 2, 55 + i * n, 17);
            graphics.setColor(255, 226, 88);
            graphics.drawString("" + (i + 1), 23, 74 + i * n, 65);
            graphics.drawString("" + (this.res.finalrank[i] + 1), 86, 77 + i * n, 65);
            graphics.drawString(this.res.RaceHorsesName[this.res.finalrank[i]], 182, 77 + i * n, 65);
        }
        graphics.setColor(209, 209, 209);
        graphics.fillRect(0, 22, GAME_WIDTH, 1);
        graphics.setColor(129, 129, 129);
        graphics.fillRect(0, 230, GAME_WIDTH, 1);
        this.WinnerScrolling += 10;
        this.WinnerScrolling %= GAME_WIDTH;
        graphics.drawImage(images[134], GAME_WIDTH - this.WinnerScrolling, 11, 36);
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        graphics.drawImage(images[40], GAME_WIDTH - 2, GAME_HEIGHT - 1, 40);
        if (this.res.taskrequire) {
            if (this.res.taskid == 13 && this.res.taskdone == 1) {
                this.drawTaskDialog(graphics, this.res.TaskResult[this.res.taskid][this.res.taskdone - 1], 4);
            } else {
                this.drawTaskDialog(graphics, this.res.TaskResult[this.res.taskid][this.res.taskdone - 1], this.res.TaskChar[this.res.taskid]);
            }
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawStartRacing(Graphics graphics) {
        graphics.setColor(73, 117, 12);
        graphics.fillRect(0, 0, GAME_WIDTH, 3);
        graphics.setColor(85, 146, 24);
        graphics.fillRect(0, 3, GAME_WIDTH, 4);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 7, GAME_WIDTH, 33);
        graphics.setColor(154, 207, 48);
        graphics.fillRect(0, 40, GAME_WIDTH, 6);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 46, GAME_WIDTH, 3);
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        graphics.drawImage(images[89], GAME_WIDTH, 0, 24);
        graphics.setColor(16, 107, 0);
        graphics.fillRect(0, 47, GAME_WIDTH, 5);
        graphics.setColor(66, 173, 24);
        graphics.fillRect(0, 48, GAME_WIDTH, 3);
        graphics.setColor(198, 255, 148);
        graphics.fillRect(0, 49, GAME_WIDTH, 1);
        int n = 0;
        if (this.res.racefocus > 3) {
            n = -(this.res.racefocus - 2) * (this.horseheight / 2 - this.horseRacingShiftY);
        }
        this.drawTrack(graphics, n);
        int n2 = 4 - (this.res.totaldistance / 400 - 1);
        int n3 = this.res.capBeginDistance - this.res.totaldistance % 400;
        while (n3 > 0 - this.res.totaldistance) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(n3 / this.res.tmpRate + this.beginPoint, 4, 1, 44);
            if (n2 == 0 && this.res.totaldistance != 2000) {
                this.drawClipImage(graphics, images[130], n3 / this.res.tmpRate + this.beginPoint, 0, images[130].getWidth() / 5 * 4, 0, images[130].getWidth() / 5, images[130].getHeight(), 17);
            } else if (n2 == 1 && this.res.totaldistance != 1600) {
                this.drawClipImage(graphics, images[130], n3 / this.res.tmpRate + this.beginPoint, 0, images[130].getWidth() / 5 * 3, 0, images[130].getWidth() / 5, images[130].getHeight(), 17);
            } else if (n2 == 2 && this.res.totaldistance != 1200) {
                this.drawClipImage(graphics, images[130], n3 / this.res.tmpRate + this.beginPoint, 0, images[130].getWidth() / 5 * 2, 0, images[130].getWidth() / 5, images[130].getHeight(), 17);
            } else if (n2 == 3 && this.res.totaldistance != 800) {
                this.drawClipImage(graphics, images[130], n3 / this.res.tmpRate + this.beginPoint, 0, images[130].getWidth() / 5, 0, images[130].getWidth() / 5, images[130].getHeight(), 17);
            } else if (n2 == 4 && this.res.totaldistance != 400) {
                this.drawClipImage(graphics, images[130], n3 / this.res.tmpRate + this.beginPoint, 0, 0, 0, images[130].getWidth() / 5, images[130].getHeight(), 17);
            } else if (n2 == 5) {
                this.drawClipImage(graphics, images[131], n3 / this.res.tmpRate + this.beginPoint + 1, 0, images[131].getWidth() / 2, 0, images[131].getWidth() / 2, images[131].getHeight(), 17);
                graphics.fillRect(n3 / this.res.tmpRate + this.beginPoint + 2, 4, 1, 44);
            }
            n3 -= 400;
            ++n2;
        }
        this.drawClipImage(graphics, images[131], this.res.capBeginDistance / this.res.tmpRate + this.beginPoint, 0, 0, 0, images[131].getWidth() / 2, images[131].getHeight(), 17);
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(this.res.capBeginDistance / this.res.tmpRate + this.beginPoint, 4, 1, 44);
        for (n3 = 0; n3 < this.res.distance.length; ++n3) {
            graphics.drawImage(images[this.IMAGE_CAP[n3]], this.res.cap_location[n3], 3 + n3 * 2, 17);
            this.drawClipImage(graphics, images[133], this.res.cap_location[n3], 3 + n3 * 2 + images[this.IMAGE_CAP[n3]].getHeight(), images[133].getWidth() / 11 * n3, 0, images[133].getWidth() / 11, images[133].getHeight(), 33);
        }
        graphics.setClip(0, 49, GAME_WIDTH, 135);
        if (this.horseRacingShiftY < this.horseheight / 4 && this.runtime.waittimer >= 3000 && this.horseRacingTime < System.currentTimeMillis()) {
            ++this.horseRacingShiftY;
            this.horseRacingTime = System.currentTimeMillis() + 500L;
        }
        if (this.res.racestep == 0) {
            for (n3 = 0; n3 < this.res.distance.length; ++n3) {
                if (this.res.racefocus == n3) {
                    graphics.setColor(0xFF0000);
                } else {
                    graphics.setColor(255);
                }
                if (GAME_WIDTH - this.res.distance[n3] > 0 && GAME_WIDTH - this.res.distance[n3] - this.horsewidth < GAME_WIDTH && GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * n3 + n > 49 && GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * n3 + n - this.horseheight < 184) {
                    if (n3 == 0 && this.res.playeringame) {
                        try {
                            GameDisplay.loadImage(GameResource.horseimage[this.res.OwnerHorseID][(this.res.raceimage + n3) % 4]);
                            graphics.drawImage(images[GameResource.horseimage[this.res.OwnerHorseID][(this.res.raceimage + n3) % 4]], GAME_WIDTH - this.res.distance[n3] + this.horsewidth / 2, GAME_HEIGHT / 2 - 10 + this.horseheight / 2 * n3 + n + this.horseMoveShiftY * (1 + (n3 + 3) % 2 * -2), 40);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            GameDisplay.loadImage(this.IMAGE_JOCKEY[n3][(this.res.raceimage + n3) % 4]);
                            graphics.drawImage(images[this.IMAGE_JOCKEY[n3][(this.res.raceimage + n3) % 4]], GAME_WIDTH - this.res.distance[n3] - this.horsewidth + this.horseshiftX[(this.res.raceimage + n3) % 4] + this.horsewidth / 2, GAME_HEIGHT / 2 - 10 + this.horseheight / 2 * n3 - this.horseshiftY[(this.res.raceimage + n3) % 4] + n + this.horseMoveShiftY * (1 + (n3 + 3) % 2 * -2), 36);
                        }
                        catch (Exception exception) {}
                    } else {
                        try {
                            GameDisplay.loadImage(GameResource.horseimage[this.res.horseType[n3] % 3][(this.res.raceimage + n3) % 4]);
                            graphics.drawImage(images[GameResource.horseimage[this.res.horseType[n3] % 3][(this.res.raceimage + n3) % 4]], GAME_WIDTH - this.res.distance[n3] + this.horsewidth / 2, GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * n3 + n + this.horseMoveShiftY * (1 + (n3 + 3) % 2 * -2), 40);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            GameDisplay.loadImage(this.IMAGE_JOCKEY[n3][(this.res.raceimage + n3) % 4]);
                            graphics.drawImage(images[this.IMAGE_JOCKEY[n3][(this.res.raceimage + n3) % 4]], GAME_WIDTH - this.res.distance[n3] - this.horsewidth + this.horseshiftX[(this.res.raceimage + n3) % 4] + this.horsewidth / 2, GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * n3 - this.horseshiftY[(this.res.raceimage + n3) % 4] + n + this.horseMoveShiftY * (1 + (n3 + 3) % 2 * -2), 36);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (this.res.disbar[1][0] != 0) continue;
                graphics.drawImage(images[99], GAME_WIDTH - this.res.disbar[0][0] + 15, 50 + n3 * this.horseheight / 2, 20);
            }
        } else if (this.res.racestep == 1) {
            // empty if block
        }
        graphics.setClip(0, 0, GAME_WIDTH, GAME_HEIGHT);
        if (System.currentTimeMillis() % 1000L > 500L) {
            graphics.drawImage(images[114], GAME_WIDTH - this.res.distance[this.res.racefocus], GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * this.res.racefocus + n - this.horseheight - 3, 33);
            this.drawClipImage(graphics, images[133], GAME_WIDTH - this.res.distance[this.res.racefocus], GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * this.res.racefocus + n - this.horseheight - 3 - 7, images[133].getWidth() / 11 * this.res.racefocus, 0, images[133].getWidth() / 11, images[133].getHeight(), 33);
        } else {
            graphics.drawImage(images[114], GAME_WIDTH - this.res.distance[this.res.racefocus], GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * this.res.racefocus + n - this.horseheight, 33);
            this.drawClipImage(graphics, images[133], GAME_WIDTH - this.res.distance[this.res.racefocus], GAME_HEIGHT / 2 - 10 + (this.horseheight / 2 - this.horseRacingShiftY) * this.res.racefocus + n - this.horseheight - 7, images[133].getWidth() / 11 * this.res.racefocus, 0, images[133].getWidth() / 11, images[133].getHeight(), 33);
        }
        graphics.setFont(F_SMALL);
        this.drawOutlinedBox(graphics, 0, 183, GAME_WIDTH, 63);
        graphics.setColor(0);
        if (this.res.RaceDescription != null && !this.res.RaceDescription.equals("")) {
            graphics.setFont(F_SMALL);
            this.drawMGDialog(graphics, this.res.RaceDescription, 50, 190, 170, 50, false);
            graphics.setFont(F_NORMAL);
            if (System.currentTimeMillis() > this.res.pressDialogCount) {
                this.pressDialogDown();
                this.res.pressDialogCount = System.currentTimeMillis() + 3000L;
            }
            graphics.drawImage(images[37], 28, 239, 33);
            if (this.res.talkAnimation > System.currentTimeMillis()) {
                if (System.currentTimeMillis() % 1000L > 500L) {
                    this.drawClipImage(graphics, images[38], 20, 227, 0, 0, images[38].getWidth() / 2, images[38].getHeight(), 33);
                } else {
                    this.drawClipImage(graphics, images[38], 20, 227, images[38].getWidth() / 2, 0, images[38].getWidth() / 2, images[38].getHeight(), 33);
                }
            } else {
                this.drawClipImage(graphics, images[38], 20, 227, 0, 0, images[38].getWidth() / 2, images[38].getHeight(), 33);
            }
        }
        if (this.res.playeringame && this.runtime.progress == this.res.strategyindex + 1) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 167, GAME_WIDTH, 17);
            graphics.setColor(0);
            graphics.fillRect(1, 168, GAME_WIDTH - 2, 15);
            graphics.setColor(255, 138, 138);
            graphics.fillRect(3, 170, GAME_WIDTH - 6, 11);
            graphics.setColor(255, 240, 180);
            graphics.fillRect(GAME_WIDTH - this.res.racehit - 3 - images[115].getWidth() / 2, 170, this.res.racehit + images[115].getWidth() / 2, 11);
            n3 = 16;
            int n4 = 7;
            for (int i = 0; i < this.res.game_ball.length; ++i) {
                graphics.drawImage(images[115], this.res.game_ball[i][0], 169, 24);
            }
            graphics.setColor(0xFF0000);
            if (this.res.bonusspeed == 3) {
                this.res.bonusspeed = 0;
                this.drawClipImage(graphics, images[128], GAME_WIDTH - this.res.racehit - 5, 165, 0, 0, images[128].getWidth() / 3, images[128].getHeight(), 33);
            } else if (this.res.bonusspeed == 2) {
                this.res.bonusspeed = 0;
                this.drawClipImage(graphics, images[128], GAME_WIDTH - this.res.racehit - 5, 165, images[128].getWidth() / 3, 0, images[128].getWidth() / 3, images[128].getHeight(), 33);
            } else if (this.res.bonusspeed == 1) {
                this.res.bonusspeed = 0;
                this.drawClipImage(graphics, images[128], GAME_WIDTH - this.res.racehit - 5, 165, images[128].getWidth() / 3 * 2, 0, images[128].getWidth() / 3, images[128].getHeight(), 33);
            }
        }
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
    }

    public void drawLogoPage(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        graphics.drawImage(images[93], GAME_WIDTH / 2, GAME_HEIGHT / 2, 3);
    }

    public void drawTitlePage(Graphics graphics) {
        try {
            graphics.drawImage(images[43], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        }
        catch (Exception exception) {
            System.out.println("here");
        }
        if (System.currentTimeMillis() % 1500L < 750L) {
            this.drawOutlinedString(graphics, "Press any Key", GAME_WIDTH / 2, 223, 65, 0, 0xFFFFFF);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawTitleBoard(Graphics graphics, String string, int n) {
        if (n >= 0) {
            try {
                GameDisplay.loadImage(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics.drawImage(images[n], GAME_WIDTH, GAME_HEIGHT - 12, 40);
        }
        graphics.setColor(73, 117, 12);
        graphics.fillRect(0, 0, GAME_WIDTH, 3);
        graphics.setColor(85, 146, 24);
        graphics.fillRect(0, 3, GAME_WIDTH, 4);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 7, GAME_WIDTH, 33);
        graphics.setColor(154, 207, 48);
        graphics.fillRect(0, 40, GAME_WIDTH, 6);
        graphics.setColor(117, 174, 36);
        graphics.fillRect(0, 46, GAME_WIDTH, 5);
        try {
            GameDisplay.loadImage(90);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.drawImage(images[90], 0, 0, 20);
        this.drawOutlinedString(graphics, string, GAME_WIDTH / 2, 5, 17, 0, 0xFFFFFF);
        try {
            GameDisplay.loadImage(18);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        if (this.res.iState != 9) {
            try {
                GameDisplay.loadImage(40);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            graphics.drawImage(images[40], GAME_WIDTH - 2, GAME_HEIGHT - 1, 40);
        }
        try {
            GameDisplay.loadImage(89);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        graphics.drawImage(images[89], GAME_WIDTH, 0, 24);
    }

    public void drawOutlinedBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(255, 224, 224);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(89, 130, 80);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.setColor(132, 199, 127);
        graphics.fillRect(n + 4, n2 + 4, n3 - 8, n4 - 8);
        graphics.setColor(255, 250, 236);
        graphics.fillRect(n + 5, n2 + 5, n3 - 10, n4 - 10);
    }

    public void drawDialogPage(Graphics graphics) {
        String string = null;
        String string2 = null;
        if (this.res.iState == 4) {
            string = "Production Team";
            string2 = this.res.credit;
        } else {
            string = "Game Description";
            string2 = this.res.instruction;
        }
        this.drawTitleBoard(graphics, "", 17);
        this.drawOutlinedString(graphics, string, 152, 29, 65, 869376, 0xFFFFFF);
        int n = 13;
        int n2 = 50;
        int n3 = 200;
        int n4 = 190;
        this.drawOutlinedBox(graphics, n, n2, n3, n4);
        graphics.drawImage(images[24], 106, 29, 40);
        graphics.drawImage(images[29], 198, 29, 36);
        graphics.setColor(0);
        this.drawMGDialog(graphics, string2, n + 10, n2 + 10, n3 - 20, n4 - 20, false);
        this.drawScrollingBar(graphics, 226, 50, 5, 190);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawScrollingBar(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = graphics.getColor();
        int n6 = 19;
        int n7 = n2 + (n4 - n6) * dialog_index / (dialog_length - dialog_displayheight);
        int[] nArray = new int[]{0xFFFFFF, 16030023};
        int[] nArray2 = new int[]{0, 0xFFFFFF};
        for (int i = 0; i < nArray2.length; ++i) {
            graphics.setColor(nArray2[i]);
            graphics.fillRect(n - n3 / 2 + i, n2 + i, n3 - i * 2, n4 - i * 2);
        }
        try {
            GameDisplay.loadImage(120);
        }
        catch (Exception exception) {
            // empty catch block
        }
        graphics.drawImage(images[120], n - n6 / 2, n7, 20);
        graphics.setColor(n5);
    }

    public void drawMenuPage(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT);
        graphics.drawImage(images[43], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        this.drawOutlinedBox(graphics, GAME_WIDTH / 2 - 75, 194, 150, 35);
        graphics.setColor(158, 178, 158);
        graphics.fillRect(GAME_WIDTH / 2 - 50, 200, 100, 24);
        graphics.setColor(20, 99, 0);
        graphics.drawRect(GAME_WIDTH / 2 - 50, 200, 100, 24);
        this.drawOutlinedString(graphics, this.res.menuoption[this.res.menuindex], GAME_WIDTH / 2, 216, 65, 0xFFFFFF, 0);
        if (this.MenuAniTimeCount < System.currentTimeMillis()) {
            ++this.MenuAnimation;
            this.MenuAniTimeCount = System.currentTimeMillis() + 500L;
        }
        this.MenuAnimation %= 3;
        for (int i = 0; i < 3; ++i) {
            graphics.drawImage(images[25], 67 - i * 3, 205, 24);
            graphics.drawImage(images[30], GAME_WIDTH - 67 + i * 3, 205, 20);
        }
        graphics.drawImage(images[24], 67 - this.MenuAnimation * 3, 205, 24);
        graphics.drawImage(images[29], GAME_WIDTH - 67 + this.MenuAnimation * 3, 205, 20);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawPausePage(Graphics graphics) {
        this.drawOutlinedBox(graphics, 37, 45, GAME_WIDTH - 74, 162);
        graphics.setColor(149, 149, 74);
        graphics.fillRect(48, 56, GAME_WIDTH - 96, 27);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Menu", GAME_WIDTH / 2, 79, 65);
        graphics.setColor(88, 131, 80);
        graphics.drawRect((GAME_WIDTH - 142) / 2, 87, 142, 110);
        int n = 36;
        for (int i = 0; i < this.res.pauseoption.length; ++i) {
            if (this.res.menuindex == i) {
                graphics.drawImage(images[32], GAME_WIDTH / 2, 121 + n * i, 33);
                graphics.setColor(0xFFFFFF);
            } else {
                graphics.drawImage(images[31], GAME_WIDTH / 2, 121 + n * i, 33);
                graphics.setColor(0);
            }
            graphics.drawString(this.res.pauseoption[i], GAME_WIDTH / 2, 116 + n * i, 65);
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawExitAlert(Graphics graphics) {
        this.drawOutlinedBox(graphics, 2, GAME_HEIGHT / 2, GAME_WIDTH - 4, GAME_HEIGHT / 2 - 20);
        graphics.drawImage(images[95], GAME_WIDTH * 3 / 4, GAME_HEIGHT / 2, 33);
        graphics.setFont(F_NORMAL);
        graphics.setColor(0);
        graphics.setColor(0);
        graphics.drawString("Are you sure to exit?", GAME_WIDTH / 2, 160, 65);
        graphics.setFont(F_NORMAL);
        graphics.drawImage(images[36], 146, 213 - images[36].getHeight() / 2, 17);
        graphics.drawImage(images[26], 198, 213 - images[36].getHeight() / 2, 17);
        if (this.res.menuindex == 0) {
            this.drawMask(graphics, 198 - images[36].getWidth() / 2, 213 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        } else {
            this.drawMask(graphics, 146 - images[36].getWidth() / 2, 213 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawOptionPage(Graphics graphics) {
        int n;
        this.drawTitleBoard(graphics, "", 17);
        graphics.drawImage(images[56], 180, 190, 33);
        graphics.drawImage(images[92], 0, 8, 20);
        this.drawOutlinedString(graphics, "Setting", images[92].getWidth() / 2, 29, 65, 869376, 0xFFFFFF);
        int n2 = 10;
        int n3 = 50;
        int n4 = GAME_WIDTH - n2 * 2 + 8;
        int n5 = 100;
        this.drawOutlinedBox(graphics, n2, n3, n4, n5);
        int n6 = GAME_WIDTH / 4 * 3 - 15;
        int n7 = 90;
        int n8 = 6;
        int n9 = 8;
        int n10 = 3;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(GAME_WIDTH / 3 - 50, 63, 100, 30);
        graphics.setColor(222, 221, 190);
        graphics.fillRect(GAME_WIDTH / 3 + 50, 63, 100, 30);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Audio Setting", GAME_WIDTH / 3, n7 - 3, 65);
        for (n = 0; n < this.res.bEffect; ++n) {
            graphics.setColor(0);
            graphics.fillRect(n6 + n8 * n + n, n7 - n9 - n10 * n, n8, n9 + n10 * n);
            if (n > 2) {
                graphics.setColor(8, 115, 198);
            } else {
                graphics.setColor(4, 174, 249);
            }
            graphics.fillRect(n6 + n8 * n + 1 + n, n7 - n9 - n10 * n + 1, n8 - 2, n9 + n10 * n - 2);
        }
        n = 40;
        graphics.setColor(148, 148, 74);
        graphics.fillRect(GAME_WIDTH / 3 - 50, 63 + n, 100, 30);
        graphics.setColor(222, 221, 190);
        graphics.fillRect(GAME_WIDTH / 3 + 50, 63 + n, 100, 30);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("Delete Record", GAME_WIDTH / 3, n7 + n - 3, 65);
        if (this.res.deleteRecordPointer) {
            graphics.setColor(0, 0, 0);
        } else {
            graphics.setColor(148, 149, 148);
        }
        graphics.drawString("Yes", GAME_WIDTH / 4 * 3 - GAME_WIDTH / 10, n7 + n - 3, 65);
        if (!this.res.deleteRecordPointer) {
            graphics.setColor(0, 0, 0);
        } else {
            graphics.setColor(148, 149, 148);
        }
        graphics.drawString("No", GAME_WIDTH / 4 * 3 + GAME_WIDTH / 10, n7 + n - 3, 65);
        if (this.res.deleteRecordPointer) {
            this.drawOutlinedBox(graphics, n2, 160, n4, 75);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Are you sure to delete?", 22, 190, 68);
            graphics.setColor(244, 254, 224);
            graphics.fillRect(120, 200, 104, 32);
            graphics.setColor(61, 91, 56);
            graphics.drawRect(120, 200, 104, 32);
            graphics.drawImage(images[36], 146, 216 - images[36].getHeight() / 2, 17);
            graphics.drawImage(images[26], 198, 216 - images[36].getHeight() / 2, 17);
            if (this.res.confirmDeleteRecord) {
                this.drawMask(graphics, 198 - images[36].getWidth() / 2, 216 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
            } else {
                this.drawMask(graphics, 146 - images[36].getWidth() / 2, 216 - images[36].getHeight() / 2, images[36].getWidth(), images[36].getHeight());
            }
        }
        if (this.res.optionPointer == 0) {
            this.drawMask(graphics, GAME_WIDTH / 3 - 50, 63 + n, 200, 30);
        } else {
            this.drawMask(graphics, GAME_WIDTH / 3 - 50, 63, 200, 30);
        }
        graphics.setColor(0);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawRegisterPage(Graphics graphics) {
        graphics.setColor(8934416);
        graphics.fillRect(0, 0, GAME_WIDTH, GAME_HEIGHT - images[18].getHeight());
        graphics.setColor(12685630);
        graphics.drawRect(0, 0, GAME_WIDTH, GAME_HEIGHT - images[18].getHeight());
        graphics.setColor(0x767676);
        graphics.fillRect(6, 6, GAME_WIDTH - 12, GAME_HEIGHT - 12 - images[18].getHeight());
        graphics.setColor(3415814);
        graphics.drawRect(6, 6, GAME_WIDTH - 12, GAME_HEIGHT - 12 - images[18].getHeight());
        graphics.setColor(0x979797);
        graphics.fillRect(7, 7, GAME_WIDTH - 14, GAME_HEIGHT - 14 - images[18].getHeight());
        graphics.setColor(0xC6C6C6);
        graphics.fillRect(9, 9, GAME_WIDTH - 18, GAME_HEIGHT - 18 - images[18].getHeight());
        graphics.setColor(0xEDEDED);
        graphics.fillRect(12, 12, GAME_WIDTH - 24, GAME_HEIGHT - 24 - images[18].getHeight());
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(16, 16, GAME_WIDTH - 32, GAME_HEIGHT - 32 - images[18].getHeight());
        graphics.setColor(0xFF0000);
        graphics.drawString("Mobile Jockey Club", GAME_WIDTH / 2, 60, 65);
        graphics.fillRect(18, 62, GAME_WIDTH - 36, 1);
        graphics.fillRect(18, 65, GAME_WIDTH - 36, 1);
        graphics.fillRect(18, 116, GAME_WIDTH - 36, 1);
        graphics.fillRect(18, 167, GAME_WIDTH - 36, 1);
        graphics.setColor(0);
        graphics.drawString("Owner", GAME_WIDTH / 2, 88, 65);
        graphics.drawString("Horse", GAME_WIDTH / 2, 139, 65);
        graphics.drawString(this.res.OwnerName, GAME_WIDTH / 2, 113, 65);
        graphics.drawImage(images[18], GAME_WIDTH / 2, GAME_HEIGHT, 33);
        graphics.drawImage(images[23], 25, 146, 17);
        graphics.drawImage(images[28], GAME_WIDTH - 25, 146, 17);
        graphics.drawImage(images[121], 210, 240, 33);
        if (this.res.OwnerHorseID != -1) {
            int n;
            graphics.drawString(this.res.NEWHORSE_NAME[this.res.OwnerHorseID], GAME_WIDTH / 2, 163, 65);
            graphics.setColor(0, 0, 0);
            graphics.drawString("Speed", 89, 193, 65);
            graphics.drawString("Potential", 89, 217, 65);
            for (n = 0; n < this.res.horseSpeed[this.res.OwnerHorseID]; ++n) {
                graphics.drawImage(images[122], 123 + 22 * n, 193, 33);
            }
            for (n = 0; n < this.res.horseBase[this.res.OwnerHorseID]; ++n) {
                graphics.drawImage(images[122], 123 + 22 * n, 217, 33);
            }
        }
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawOfficePage(Graphics graphics) {
        this.drawLobbyMenu(graphics, "", this.res.officeoption, 17);
        this.drawOutlinedBox(graphics, 140, 200, 90, 40);
        graphics.setColor(0);
        graphics.drawString("Office", 185, 228, 65);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawStablePage(Graphics graphics) {
        this.drawLobbyMenu(graphics, "", this.res.stableoption, 17);
        graphics.drawImage(images[56], 180, 190, 33);
        this.drawOutlinedBox(graphics, 140, 200, 90, 40);
        graphics.setColor(0);
        graphics.drawString("Shippen", 185, 228, 65);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "Back", false);
    }

    public void drawRacingPage(Graphics graphics) {
        int n;
        for (n = this.RaceAnimationX; n < GAME_WIDTH; n += images[118].getWidth()) {
            for (int i = 0; i < GAME_HEIGHT; i += images[117].getHeight()) {
                graphics.drawImage(images[117], n, i, 20);
            }
        }
        for (n = this.RaceAnimationX; n < GAME_WIDTH; n += images[118].getWidth()) {
            graphics.drawImage(images[118], n, 49, 20);
        }
        for (n = this.RaceAnimationX; n < GAME_WIDTH; n += images[101].getWidth()) {
            graphics.drawImage(images[101], n, 49 + images[118].getHeight() + 2, 36);
        }
        this.drawLobbyMenu(graphics, "", this.res.racingoption, -1);
        if (this.res.playeringame) {
            try {
                GameDisplay.loadImage(GameResource.horseimage[this.res.OwnerHorseID][this.RaceHorseAni]);
                graphics.drawImage(images[GameResource.horseimage[this.res.OwnerHorseID][this.RaceHorseAni]], 185 - this.horsewidth / 2, GAME_HEIGHT / 2, 36);
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphics.drawImage(images[this.IMAGE_JOCKEY[0][this.RaceHorseAni]], 185 + this.horseshiftX[this.res.raceimage] - this.horsewidth / 2, GAME_HEIGHT / 2 - this.horseshiftY[this.res.raceimage], 36);
            graphics.setColor(0xFFFFFF);
            graphics.drawString("1." + this.res.OwnerHorseName, 185, GAME_HEIGHT / 3 * 2, 65);
        }
        this.drawOutlinedBox(graphics, 140, 200, 90, 40);
        graphics.setColor(0);
        graphics.drawString("Racecourse", 185, 228, 65);
        this.drawMGCommandOK(graphics, null, "Confirm", false);
        this.drawMGCommandCancel(graphics, null, "", false);
        this.RaceSpeed = this.res.playeringame ? 7 : 0;
        this.RaceAnimationX = this.RaceAnimationX + this.RaceSpeed < 0 ? (this.RaceAnimationX += this.RaceSpeed) : (this.RaceAnimationX -= 77);
        ++this.RaceHorseAni;
        this.RaceHorseAni %= 4;
    }

    private void drawStraightString(Graphics graphics, String string, int n, int n2, int n3) {
        for (int i = 0; i < string.length(); ++i) {
            graphics.drawString(string.substring(i, i + 1), n, n2 + i * graphics.getFont().getHeight(), n3);
        }
    }

    private void initImages() {
        GameDisplay.PageImage[11] = new int[]{92, 91, 36, 26, 95, 40};
        GameDisplay.PageImage[16] = new int[]{92, 91, 36, 26, 33, 19, 92};
        GameDisplay.PageImage[6] = new int[]{23, 28, 18, 40, 121, 122};
        GameDisplay.PageImage[18] = new int[]{23, 28, 40, 18, 121, 122};
        GameDisplay.PageImage[29] = new int[]{0, 1, 2, 4, 113, 40, 116, 3, 18};
        GameDisplay.PageImage[4] = new int[]{92, 24, 29};
        GameDisplay.PageImage[3] = new int[]{92, 24, 29};
        GameDisplay.PageImage[0] = new int[]{93};
        GameDisplay.PageImage[23] = new int[]{96, 13, 14, 92, 36, 26, 12, 11, 10, 9, 7, 8, 16, 15, 5, 6, 117, 118, 101, 61};
        GameDisplay.PageImage[2] = new int[]{22, 27, 23, 28, 24, 29, 25, 30, 43};
        GameDisplay.PageImage[1] = new int[]{24, 29, 43};
        GameDisplay.PageImage[13] = new int[]{131, 97, 117, 118, 101, 18, 40, 89, 120, 128, 115, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 133, 98, 129, 100, 99, 37, 38, 114, 130};
        GameDisplay.PageImage[26] = new int[]{92, 44, 132, 95, 33, 19, 125, this.IMAGE_JOCKEY[0][0]};
        GameDisplay.PageImage[22] = new int[]{18, 40, 89, 4, 117, 118, 101, 123, 124, 128, 95, 33, 19, 65, 76};
        GameDisplay.PageImage[5] = new int[]{92, 91, 36, 26, 56};
        GameDisplay.PageImage[17] = new int[]{92, 91, 95, 33, 19, 36, 26, 56};
        GameDisplay.PageImage[8] = new int[]{92, 91, 56};
        GameDisplay.PageImage[7] = new int[]{92, 91};
        GameDisplay.PageImage[9] = new int[]{92, 91, 117, 118, 101, this.IMAGE_JOCKEY[0][0], this.IMAGE_JOCKEY[0][1], this.IMAGE_JOCKEY[0][2], this.IMAGE_JOCKEY[0][3]};
        GameDisplay.PageImage[31] = new int[]{92, 91, 36, 26};
        GameDisplay.PageImage[21] = new int[]{64, 36, 26, 92, 91, 63, 126, 127};
        GameDisplay.PageImage[10] = new int[]{92, 91, 56, 32, 31};
        GameDisplay.PageImage[20] = new int[]{92, 91, 36, 26, 4, 113, 116};
        GameDisplay.PageImage[12] = new int[]{92, 91, 36, 26, 4, 40, 113, 116, 58, 60, 22, 27, 117, 118, 101, 18, 89};
        GameDisplay.PageImage[24] = new int[]{92, 91, 36, 26, 4, 40, 113, 116, 58, 60, 22, 27, 117, 118, 101, 18, 89};
        GameDisplay.PageImage[24] = new int[]{92, 91, 36, 26, 40, 22, 27};
        GameDisplay.PageImage[19] = new int[]{92, 91, 36, 26, 33, 19, 92, 40};
        GameDisplay.PageImage[25] = new int[]{31, 32, 36, 26, 92, 91, 40, 57, 117, 118, 101};
        GameDisplay.PageImage[28] = new int[]{94, 18, 61, 40};
        GameDisplay.PageImage[27] = new int[]{92, 91, 36, 26, 33, 40, 19, 92, 59, 62};
        GameDisplay.PageImage[14] = new int[]{92, 91, 36, 26, 33, 40, 19, 92, 119, 134, 18, 95};
        GameDisplay.PageImage[30] = new int[]{92, 91, 36, 26, 33, 40, 19, 92, 119, 134, 18, 64, 57, 95};
    }

    public void loadImageTmp(int n) {
        this.res.isReady = false;
        try {
            if (PageImage[n] != null) {
                this.loadImage(PageImage[n]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.res.isReady = true;
    }

    public void keyPressed(int n) {
        if (!this.res.isSwitchPage && !this.ishandle) {
            this.ishandle = true;
            try {
                this.runtime.keyPressed(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ishandle = false;
        }
    }

    public void hideNotify() {
        GameMidlet.instance.pauseApp();
    }
}

