/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public final class Menu
implements BabbleDefs {
    public static final boolean gNeedRefresh = true;
    public static ItemSoftKey softBack = null;
    public static ItemSoftKey softOkay = null;
    public static ItemSoftKey softConfirm = null;
    public int maxTextAreaHeight = 0;
    private int mId = -1;
    public BCanvas can = null;
    public MenuEventHandler EH = null;
    public MenuItem[] item = null;
    public ScrollBar scrollbar = null;
    public Image back = null;
    public Sprite sprLeftRight = null;
    public static Sprite sprArrows = null;
    private int startItem = 0;
    public int numItems = 0;
    public int curItem = 0;
    public int menuTop = 0;
    public int itemTop = 0;
    public int height = 0;
    public int width = 0;
    public BFrame textArea = null;
    public int numEnabledItems = 0;
    public String title = null;
    private int titleX = 10;
    public int mMenuTop = 0;
    public BFont titleFont = null;
    public int titleTop = 0;
    public boolean textMenu = false;
    public boolean simpleMenu = false;
    public int ITEM_V_SPACING = 2;
    public static int soundSelect = 0;
    public static int soundScroll = 1;
    public static int soundBack = 2;
    public static int soundCheck = 3;
    public static boolean soundEnabled = false;
    static ItemSoftKey softStar = null;
    static ItemSoftKey softPause = null;

    private static void MNU_DBG(String string) {
    }

    public static void needRefresh() {
    }

    public static void enableSound(boolean bl) {
        soundEnabled = bl;
    }

    public static void playSound(int n) {
        if (soundEnabled) {
            BSound.playSound(n);
        }
    }

    public static void setSoftKeyBack(String string, int n, int n2, String string2) {
        if (string != null) {
            softBack = new ItemSoftKey(Use.loadImage(string), n, n2, string2);
        }
    }

    public static void setSoftKeyOkay(String string, int n, int n2, String string2) {
        if (string != null) {
            softOkay = new ItemSoftKey(Use.loadImage(string), n, n2, string2);
        }
    }

    public static void setSoftKeyConfirm(String string, int n, int n2, String string2) {
        if (string != null) {
            softConfirm = new ItemSoftKey(Use.loadImage(string), n, n2, string2);
        }
    }

    public static void setSoftKeyStar(String string, int n, int n2, String string2) {
        if (string != null) {
            softStar = new ItemSoftKey(Use.loadImage(string), n, n2, string2);
        }
    }

    public static void setSoftKeyPause(String string, int n, int n2, String string2) {
        if (string != null) {
            softPause = new ItemSoftKey(Use.loadImage(string), n, n2, string2);
        }
    }

    public static void showBack(int n) {
        if (softBack != null) {
            Menu.softBack.menuIndex = n;
            Menu.softBack.visible = true;
        }
    }

    public static void showOK(boolean bl) {
        if (softOkay != null) {
            Menu.softOkay.visible = bl;
        }
    }

    public static void showConfirm(int n) {
        if (softConfirm != null) {
            Menu.softConfirm.menuIndex = n;
            Menu.softConfirm.visible = true;
        }
    }

    public static void showSoftKeys(boolean bl) {
        if (softBack != null) {
            Menu.softBack.visible = bl;
        }
        if (softOkay != null) {
            Menu.softOkay.visible = bl;
        }
        if (softConfirm != null) {
            Menu.softConfirm.visible = bl;
        }
    }

    public Menu(BCanvas bCanvas, MenuEventHandler menuEventHandler, BFrame bFrame) {
        if (bCanvas == null) {
            return;
        }
        this.can = bCanvas;
        this.EH = menuEventHandler;
        this.textArea = new BFrame(bFrame.x, bFrame.y, bFrame.w, bFrame.h);
        this.mMenuTop = this.textArea.y;
        this.titleX = 0;
        this.scrollbar = new ScrollBar(BBuild.WIDTH - 4, this.menuTop, 3, BBuild.HEIGHT - this.menuTop, 0);
        this.createMenu(-1, null, null);
    }

    public void setTitleFont(String string, int n) {
        this.titleFont = BFont.loadFont(string, n);
    }

    public void setTitlePosition(int n, int n2) {
        this.titleTop = n2;
        this.titleX = n;
    }

    public void setMaxTextAreaHeight(int n) {
        this.maxTextAreaHeight = n;
    }

    public void setTextArea(BFrame bFrame, boolean bl) {
        this.setTextArea(bFrame);
        if (bl) {
            this.clampTextArea();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTextArea(BFrame bFrame) {
        this.textArea.x = bFrame.x;
        this.textArea.y = bFrame.y;
        this.textArea.w = bFrame.w;
        this.textArea.h = bFrame.h;
        if (this.textArea.y + this.textArea.h > BBuild.HEIGHT - 10) {
            this.textArea.h -= this.textArea.y + this.textArea.h - (BBuild.HEIGHT - 10);
        }
        if (this.textArea.x < MenuItem.pointerWidth + 4) {
            this.textArea.x = MenuItem.pointerWidth + 4;
        }
        if (softOkay != null && Menu.softOkay.visible) {
            if (this.textArea.y + this.textArea.h >= BBuild.HEIGHT - 28) {
                this.scrollbar.setup(BBuild.WIDTH - 5, this.textArea.y, 4, this.textArea.h - (this.textArea.y + this.textArea.h - (BBuild.HEIGHT - 28)), 0);
                return;
            }
        }
        this.scrollbar.setup(BBuild.WIDTH - 5, this.textArea.y, 4, this.textArea.h, 0);
    }

    public void clampTextArea() {
        if (this.textArea == null || this.scrollbar == null) {
            return;
        }
        if (this.textArea.y + this.textArea.h > this.maxTextAreaHeight) {
            this.textArea.h = this.maxTextAreaHeight - this.textArea.y;
        }
        this.scrollbar.setup(BBuild.WIDTH - 5, this.textArea.y, 4, this.textArea.h, 0);
    }

    public void createMenu(int n, String string, String string2) {
        this.createMenu(n, string);
        this.back = Use.loadImage(string2);
    }

    public void createMenu(int n, String string) {
        this.mId = n;
        this.title = string;
        if (this.titleFont != null) {
            this.title = this.titleFont.WrapText(this.title, BBuild.WIDTH);
        }
        this.destroy();
        this.simpleMenu = false;
        this.textMenu = false;
        this.menuTop = this.mMenuTop;
        this.itemTop = this.menuTop + this.can.getFontHeight();
        this.height = this.getMenuHeight(this.itemTop);
        this.startItem = 0;
        this.numEnabledItems = 0;
    }

    public void createSimpleMenu(int n, String string, Image image, Sprite sprite, int n2, int n3, int n4, int n5) {
        this.createMenu(n, string);
        this.back = image;
        this.sprLeftRight = sprite;
        this.addItem(BCanvas.bab(13), n2);
        this.addItem(BCanvas.bab(14), n3);
        this.addItem(BCanvas.bab(8), n4);
        this.addItem(BCanvas.bab(15), n5);
        this.simpleMenu = true;
    }

    public void createSimpleMenu(int n, Image image, Sprite sprite, int n2, int n3, int n4, int n5) {
        this.createSimpleMenu(n, null, image, sprite, n2, n3, n4, n5);
    }

    public int getMenuId() {
        return this.mId;
    }

    private int getMenuHeight(int n) {
        return (BBuild.HEIGHT - n) / this.can.getFontHeight() * this.can.getFontHeight();
    }

    public int getMenuHeight() {
        int n = 0;
        for (int i = 0; i < this.numItems; ++i) {
            if (this.item[i] == null) continue;
            n += this.item[i].getHeight();
            if (i >= this.numItems - 1) continue;
            n += this.ITEM_V_SPACING;
        }
        return n;
    }

    public int getMenuLines() {
        int n = 0;
        for (int i = 0; i < this.numItems; ++i) {
            n += this.item[i].lines;
        }
        return n;
    }

    public void centerVertical() {
        if (this.item == null) {
            return;
        }
        this.itemTop = BBuild.CX - (this.numItems + 1) * this.can.getFontHeight() / 2;
        if (this.itemTop < this.can.getFontHeight()) {
            this.menuTop = this.can.getFontHeight();
            this.itemTop = this.menuTop + this.can.getFontHeight();
        } else {
            this.menuTop = this.itemTop - this.can.getFontHeight();
        }
        this.height = this.getMenuHeight(this.itemTop);
    }

    public void destroy() {
        this.numItems = 0;
        this.curItem = 0;
        if (this.item != null) {
            for (int i = 0; i < this.numItems; ++i) {
                this.item[i] = null;
                System.gc();
            }
            this.item = null;
            System.gc();
        }
        Use.deleteObject(this.back);
    }

    public void addBlankItemsEx(int n) {
        if (this.can == null) {
            return;
        }
        int n2 = this.textArea.y + this.textArea.h - (this.can.getFontHeight() + this.ITEM_V_SPACING) * n;
        for (int i = this.textArea.y + this.numItems * this.can.getFontHeight() + this.ITEM_V_SPACING; i < n2; i += this.can.getFontHeight() + this.ITEM_V_SPACING) {
            this.addLabel();
        }
    }

    public int addLabel() {
        return this.addLabel("");
    }

    public int addLabelLeft(String string, int n) {
        return this.addLabelLeft(string, n, false);
    }

    public int addLabelLeft(String string, int n, boolean bl) {
        return this.addLabel(string, 0, n, bl);
    }

    public int addLabel(String string) {
        return this.addLabel(string, 1);
    }

    public int addLabel(String string, int n) {
        return this.addLabel(string, n, -1);
    }

    public int addLabel(String string, int n, int n2) {
        return this.addLabel(string, n, n2, false);
    }

    public int addLabel(String string, int n, int n2, boolean bl) {
        return this.addItem(string, n2, 0, n, bl, false);
    }

    public int addLabelWraped(String string, int n, int n2, boolean bl) {
        string = this.can.font.WrapText(string, this.textArea.w);
        boolean bl2 = false;
        int n3 = string.indexOf(10);
        while (n3 != -1) {
            if (n3 > 1) {
                this.addItem(string.substring(0, n3), n2, 0, n, bl, false);
            }
            string = string.substring(n3 + 1);
            n3 = string.indexOf(10);
        }
        int n4 = this.addItem(string, n2, 0, n, bl, false);
        return n4;
    }

    public void addLabels(int n) {
        for (int i = 0; i < n; ++i) {
            this.addLabel();
        }
    }

    public int addCheckItem(String string, int n, boolean bl) {
        int n2 = this.addItem(string, n, 1, 1, true, true);
        if (n2 == -1) {
            return n2;
        }
        this.item[n2].checked = bl;
        return n2;
    }

    public int addItem(String string, int n) {
        return this.addItem(string, n, 0, 1, true, true);
    }

    public int addItem(String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = this.createItem();
        if (n4 == -1) {
            return n4;
        }
        this.item[n4] = new MenuItem(this, string, n4, n, n2, n3, bl);
        this.item[n4].selectable = bl2;
        this.updateMenu(n4);
        return n4;
    }

    public int addTextItem(String string, int n) {
        return this.addTextItem(string, n, 0);
    }

    public int addTextItem(String string, int n, int n2) {
        return this.addTextItem(string, n, n2, true);
    }

    public int addTextItem(String string, int n, int n2, boolean bl) {
        int n3 = this.createItem();
        if (n3 == -1) {
            return n3;
        }
        this.item[n3] = new MenuItemText(this, string, n3, n, n2, true, bl);
        this.updateMenu(n3);
        return n3;
    }

    public int addImageItem(String string, Image image, int n, int n2, boolean bl, boolean bl2, String string2) {
        return this.addImageItem(string, image, n, n2, bl, bl2, string2, BBuild.WIDTH - this.textArea.x, 2);
    }

    public int addImageItem(String string, Image image, int n, int n2, boolean bl, boolean bl2, String string2, int n3, int n4) {
        int n5 = this.createItem();
        if (n5 == -1) {
            return n5;
        }
        this.item[n5] = new MenuItemImage(this, string, image, n5, n2, 0, bl);
        ((MenuItemImage)this.item[n5]).setImageAttributes(this.can, n, n3, n4, string2);
        this.item[n5].selectable = bl2;
        this.updateMenu(n5);
        return n5;
    }

    private int createItem() {
        int n = this.numItems++;
        MenuItem[] menuItemArray = null;
        if (this.item != null) {
            menuItemArray = new MenuItem[this.item.length];
            System.arraycopy(this.item, 0, menuItemArray, 0, this.item.length);
        }
        this.item = new MenuItem[this.numItems];
        if (menuItemArray != null) {
            System.arraycopy(menuItemArray, 0, this.item, 0, menuItemArray.length);
            menuItemArray = null;
            System.gc();
        }
        return n;
    }

    private int getEnabledItemCount() {
        if (this.numItems <= 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.numItems; ++i) {
            if (!this.item[i].enabled) continue;
            ++n;
        }
        if (n == 0) {
            n = this.getItemsOffscreen() + 1;
        }
        return n;
    }

    private int getItemsOffscreen() {
        int n = 0;
        int n2 = 0;
        int n3 = this.textArea.y;
        int n4 = this.textArea.y + this.textArea.h;
        for (n = 0; n < this.numItems; ++n) {
            n2 = this.item[n].getHeight();
            if (n3 > n4 - n2) {
                return this.numItems - n;
            }
            n3 += n2 + this.ITEM_V_SPACING;
        }
        return 0;
    }

    private void updateMenu(int n) {
        if (this.item[n].enabled) {
            this.item[n].setEnabledIndex(this.numEnabledItems);
            ++this.numEnabledItems;
        }
        if (this.simpleMenu) {
            this.scrollbar.setMax(this.getEnabledItemCount() - 4 - this.getItemsPerScreen(this.simpleMenu) + 1);
        } else {
            this.scrollbar.setMax(this.getEnabledItemCount());
        }
    }

    public void selectLastItem() {
        if (this.numItems <= 0) {
            return;
        }
        this.curItem = this.numItems - 1;
        this.item[this.curItem].selected = true;
        this.scrollbar.setVal(this.item[this.curItem].getEnabledIndex());
    }

    public void selectFirstSelectableItem() {
        for (int i = 0; i < this.numItems; ++i) {
            if (!this.item[i].enabled) continue;
            this.curItem = i;
            this.item[this.curItem].selected = true;
            this.scrollbar.setVal(this.item[this.curItem].getEnabledIndex());
            this.updateStartItem();
            break;
        }
    }

    public void selectItem(int n) {
        this.selectItem(n, 1);
    }

    public void selectItem(int n, int n2) {
        if (n < 0 || n > this.numItems - 1) {
            this.selectFirstSelectableItem();
            return;
        }
        this.unSelectAll();
        int n3 = n;
        int n4 = -1;
        for (int i = 0; i < this.numItems; ++i) {
            if (this.item[n3].enabled) {
                n4 = n3;
                break;
            }
            n3 = Use.clamp(n3 + n2, 0, this.numItems - 1);
            if (n3 != 0 && n3 != this.numItems - 1) continue;
        }
        if (n4 != -1) {
            this.curItem = n4;
            if (this.curItem >= 0 && this.curItem < this.numItems) {
                this.item[this.curItem].selected = true;
                this.scrollbar.setVal(this.item[this.curItem].getEnabledIndex());
            }
            this.updateStartItem();
        }
    }

    public void scrollUp() {
        int n = this.curItem;
        int n2 = this.numItems;
        if (this.simpleMenu) {
            n2 -= 4;
        }
        int n3 = Use.croll(this.curItem - 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            if (this.item[n3].enabled) {
                this.curItem = n3;
                this.item[n].selected = false;
                this.item[this.curItem].selected = true;
                this.scrollbar.setVal(this.item[this.curItem].getEnabledIndex());
                this.updateStartItem();
                return;
            }
            n3 = Use.croll(n3 - 1, 0, n2 - 1);
        }
        int n4 = this.scrollbar.getMax();
        if (n4 > 0) {
            this.scrollbar.scrollUp();
            this.curItem = n2 / n4;
            if (this.scrollbar.getValue() == n4 - 1) {
                this.curItem = n2 - 1;
            }
            this.updateStartItem();
        }
    }

    public void scrollDown() {
        int n = this.curItem;
        int n2 = this.numItems;
        if (this.simpleMenu) {
            n2 -= 4;
        }
        int n3 = Use.croll(this.curItem + 1, 0, n2 - 1);
        for (int i = 0; i < n2; ++i) {
            if (this.item[n3].enabled) {
                this.curItem = n3;
                this.item[n].selected = false;
                this.item[this.curItem].selected = true;
                this.scrollbar.setVal(this.item[this.curItem].getEnabledIndex());
                this.updateStartItem();
                return;
            }
            n3 = Use.croll(n3 + 1, 0, n2 - 1);
        }
        int n4 = this.scrollbar.getMax();
        if (n4 > 0) {
            this.scrollbar.scrollDown();
            this.curItem = n2 / n4;
            if (this.scrollbar.getValue() == n4 - 1) {
                this.curItem = n2 - 1;
            }
            this.updateStartItem();
        }
    }

    public void selectItemByID(int n) {
        for (int i = 0; i < this.numItems; ++i) {
            if (this.item[i].menuIndex != n) continue;
            this.selectItem(i);
            break;
        }
    }

    public String selectedText() {
        if (this.curItem >= 0 && this.curItem < this.numItems) {
            return BCanvas.UnWrap(this.item[this.curItem].text);
        }
        return null;
    }

    public MenuItem getItem(int n) {
        if (n >= 0 && n < this.numItems) {
            return this.item[n];
        }
        return null;
    }

    private int getItemsPerScreen(boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = this.textArea.y;
        int n4 = this.textArea.y + this.textArea.h;
        int n5 = 4;
        if (!bl) {
            n5 = 0;
        }
        for (n = n5; n < this.numItems; ++n) {
            n2 = this.item[n].getHeight();
            if (n3 > n4 - n2) {
                return n - n5;
            }
            n3 += n2 + this.ITEM_V_SPACING;
        }
        return this.numItems - n5;
    }

    private void updateStartItem() {
        if (this.simpleMenu) {
            this.startItem = Use.clamp(this.curItem + 4, 4, this.numItems - this.getItemsPerScreen(this.simpleMenu));
            return;
        }
        if (this.getMenuHeight() <= this.textArea.h) {
            this.startItem = 0;
            return;
        }
        if (this.curItem == 0) {
            this.startItem = 0;
        } else {
            int n;
            int n2 = 0;
            int n3 = n = Use.clamp(this.curItem, 0, this.numItems - 1);
            while (n3 >= 0) {
                if ((n2 += this.item[n3].getHeight() + this.ITEM_V_SPACING) > this.textArea.h) {
                    return;
                }
                this.startItem = n3--;
            }
        }
    }

    public void render() {
        Menu.MNU_DBG("menu render");
        if (this.can == null) {
            return;
        }
        if (this.back != null) {
            if (this.back.getHeight() > BBuild.HEIGHT) {
                this.can.renderImage(this.back, 0, 0);
            } else {
                this.can.renderImage(this.back);
            }
        }
        if (this.titleFont != null) {
            this.can.drawText(this.titleFont, this.title, this.titleTop);
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.textArea.y;
        int n4 = this.textArea.y + this.textArea.h;
        if (this.simpleMenu) {
            this.checkInput();
            for (n = this.startItem; n < this.numItems; ++n) {
                if (n <= 3) continue;
                n2 = this.item[n].getHeight();
                if (n3 > n4 - n2) break;
                this.item[n].render(this.can, n3);
                n3 += n2 + this.ITEM_V_SPACING;
            }
            if (this.sprLeftRight != null) {
                int n5 = BBuild.CX - (this.sprLeftRight.image.getWidth(0, 0) >> 1);
                int n6 = BBuild.CX + (this.sprLeftRight.image.getWidth(0, 0) >> 1);
                int n7 = BBuild.HEIGHT - (Menu.sprArrows.image.getHeight(0, 0) << 1);
                int n8 = BBuild.CX - this.sprLeftRight.image.getWidth(0, 0);
                int n9 = BBuild.CX;
                int n10 = BBuild.HEIGHT - (this.sprLeftRight.image.getHeight(0, 0) << 2);
                int n11 = this.sprLeftRight.image.getWidth(0, 0);
                int n12 = this.sprLeftRight.image.getHeight(0, 0) << 2;
                this.can.bTouchLeft = false;
                this.can.bTouchRight = false;
                if (this.can.checkTouchInput(true, n8, n10, n11, n12)) {
                    this.can.bTouchLeft = true;
                } else if (this.can.checkTouchInput(true, n9, n10, n11, n12)) {
                    this.can.bTouchRight = true;
                }
                if (sprArrows != null) {
                    sprArrows.renderFrame(this.can, 0, n5, n7);
                    sprArrows.renderFrame(this.can, 1, n6, n7);
                }
                if (this.can.Left() || this.can.bTouchLeft) {
                    this.sprLeftRight.renderFrame(this.can, 0, n5, n7);
                } else if (this.can.Right() || this.can.bTouchRight) {
                    this.sprLeftRight.renderFrame(this.can, 1, n6, n7);
                }
            }
            this.can.clearClip();
            this.renderSoftKeys();
            if (this.getMenuHeight() > this.textArea.h && this.numItems > 6) {
                this.scrollbar.render(this.can);
            }
            return;
        }
        if (this.textMenu) {
            for (n = this.startItem; n < this.numItems; ++n) {
                n2 = this.item[n].getHeight();
                if (this.item[n].selectable && this.can.checkTouchInput(true, 20, n3 - 10, this.can.getWidth() - 50, n2)) {
                    if (this.curItem == n) {
                        this.selectCurrentItem();
                        return;
                    }
                    this.selectItem(n);
                }
                if (n3 <= n4) {
                    this.item[n].render(this.can, n3);
                    n3 += n2 + this.ITEM_V_SPACING;
                    continue;
                }
                break;
            }
        } else {
            for (n = this.startItem; n < this.numItems; ++n) {
                n2 = this.item[n].getHeight();
                if (this.item[n].selectable) {
                    if (n3 - 10 + n2 < BBuild.HEIGHT - this.getSoftkeyHeight() && this.can.checkTouchInput(true, 20, n3 - 10, this.can.getWidth() - 50, n2)) {
                        if (this.curItem == n) {
                            this.selectCurrentItem();
                            return;
                        }
                        this.selectItem(n);
                    }
                }
                if (n3 > n4 - n2) break;
                this.item[n].render(this.can, n3);
                n3 += n2 + this.ITEM_V_SPACING;
            }
            if (this.getMenuHeight() > this.textArea.h) {
                this.scrollbar.render(this.can);
            }
        }
        this.renderSoftKeys();
        this.checkInput();
    }

    public void renderSoftKeys() {
        if (softBack != null) {
            softBack.render(this.can);
        }
        if (softOkay != null) {
            softOkay.render(this.can);
        }
        if (softConfirm != null) {
            softConfirm.render(this.can);
        }
    }

    public int getSoftkeyHeight() {
        if (softOkay != null) {
            return Menu.softOkay.image.getHeight();
        }
        return 0;
    }

    public void renderItem(MenuItem menuItem, int n) {
        if (this.can != null) {
            menuItem.render(this.can, n);
        }
    }

    public int selectedItem() {
        for (int i = 0; i < this.numItems; ++i) {
            if (!this.item[i].selected) continue;
            return i;
        }
        return -1;
    }

    public int backItemExists() {
        for (int i = 0; i < this.numItems; ++i) {
            if (this.item[i].type != 0 || !this.item[i].text.equals(BCanvas.bab(8)) && !this.item[i].text.equals(BCanvas.bab(10)) && !this.item[i].text.equals(BCanvas.bab(7)) && !this.item[i].text.equals(BCanvas.bab(16)) && !this.item[i].text.equals(BCanvas.bab(12))) continue;
            return i;
        }
        return -1;
    }

    public int itemExists(String string) {
        for (int i = 0; i < this.numItems; ++i) {
            if (!this.item[i].text.equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void checkInput() {
        if (this.EH == null || this.item == null || this.can == null) {
            return;
        }
        int n = 0;
        if (this.simpleMenu) {
            if (softBack != null && Menu.softBack.visible && (this.can.leftSoftClick() || this.can.checkTouchInput(true, Menu.softBack.x, Menu.softBack.y, Menu.softBack.image.getWidth(), Menu.softBack.image.getHeight()))) {
                Menu.enableSound(true);
                Menu.playSound(soundBack);
                this.EH.itemSelected(Menu.softBack.menuIndex);
                Menu.needRefresh();
                return;
            }
            String string = null;
            if (this.can.leftClick() || this.can.bTouchLeft) {
                string = BCanvas.bab(13);
            } else if (this.can.rightClick() || this.can.bTouchRight) {
                string = BCanvas.bab(14);
            } else if (this.can.leftSoftClick() || this.can.checkTouchInput(true, Menu.softBack.x, Menu.softBack.y, Menu.softBack.image.getWidth(), Menu.softBack.image.getHeight())) {
                string = BCanvas.bab(8);
            } else if (this.can.rightSoftClick() || this.can.checkTouchInput(true, Menu.softOkay.x, Menu.softOkay.y, Menu.softOkay.image.getWidth(), Menu.softOkay.image.getHeight())) {
                string = BCanvas.bab(15);
            } else if (this.can.fireClick()) {
                string = BCanvas.bab(15);
            }
            if (string != null && (n = this.itemExists(string)) != -1) {
                if (string.equals(BCanvas.bab(13)) || string.equals(BCanvas.bab(8))) {
                    Menu.playSound(soundBack);
                } else {
                    Menu.playSound(soundSelect);
                }
                this.EH.itemSelected(this.item[n]);
                Menu.needRefresh();
            }
            n = this.curItem;
            if (this.can.upClick() || this.can.bTouchUp) {
                this.scrollUp();
                Menu.needRefresh();
            } else if (this.can.downClick() || this.can.bTouchDown) {
                this.scrollDown();
                Menu.needRefresh();
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.can.fireClick()) {
            bl = true;
        } else if (softOkay != null && Menu.softOkay.visible && (this.can.rightSoftClick() || this.can.checkTouchInput(true, Menu.softOkay.x, Menu.softOkay.y, Menu.softOkay.image.getWidth(), Menu.softOkay.image.getHeight()))) {
            bl = true;
        }
        if (softBack != null && Menu.softBack.visible && (this.can.leftSoftClick() || this.can.checkTouchInput(true, Menu.softBack.x, Menu.softBack.y, Menu.softBack.image.getWidth(), Menu.softBack.image.getHeight()))) {
            bl2 = true;
        }
        if (softConfirm != null && Menu.softConfirm.visible) {
            if (this.can.rightSoftClick() || this.can.checkTouchInput(true, Menu.softConfirm.x, Menu.softConfirm.y, Menu.softConfirm.image.getWidth(), Menu.softConfirm.image.getHeight())) {
                bl3 = true;
            } else if (bl) {
                bl3 = true;
            }
        }
        if (bl3) {
            Menu.playSound(soundSelect);
            this.EH.itemSelected(Menu.softConfirm.menuIndex);
            Menu.needRefresh();
            return;
        }
        if (bl) {
            this.selectCurrentItem();
            Menu.needRefresh();
            return;
        }
        if (bl2) {
            Menu.playSound(soundBack);
            this.EH.itemSelected(Menu.softBack.menuIndex);
            Menu.needRefresh();
            return;
        }
        if (!this.textMenu) {
            n = this.curItem;
            if (this.can.upClick() || this.can.bTouchUp) {
                this.scrollUp();
                Menu.needRefresh();
            } else if (this.can.downClick() || this.can.bTouchDown) {
                this.scrollDown();
                Menu.needRefresh();
            }
        } else if (this.can.upClick() || this.can.bTouchUp) {
            ((MenuItemText)this.item[0]).scroll(-1);
            Menu.needRefresh();
        } else if (this.can.downClick() || this.can.bTouchDown) {
            ((MenuItemText)this.item[0]).scroll(1);
            Menu.needRefresh();
        }
    }

    public void selectCurrentItem() {
        if (this.item[this.curItem].type == 1) {
            this.item[this.curItem].toggleCheck();
            this.EH.itemChecked(this.item[this.curItem]);
            Menu.playSound(soundCheck);
        } else {
            if (this.item[this.curItem].menuIndex != -1) {
                Menu.playSound(soundSelect);
            }
            this.EH.itemSelected(this.item[this.curItem]);
        }
        Menu.needRefresh();
    }

    public void unSelectAll() {
        for (int i = 0; i < this.numItems; ++i) {
            this.item[i].selected = false;
        }
    }

    public void createMenuFromFile(int n, String string, String string2, String string3, int n2) {
        this.createMenuFromFile(n, string, string2, string3, n2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMenuFromFile(int n, String string, String string2, String string3, int n2, String string4) {
        if (this.can == null) {
            return;
        }
        this.createMenu(n, string, string3);
        this.textMenu = true;
        byte[] byArray = new byte[1];
        String string5 = "";
        InputStream inputStream = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            int n3;
            char c;
            inputStream = this.getClass().getResourceAsStream(string2);
            while (inputStream.read(byArray) != -1 && (c = (char)byArray[0]) != '\u0000') {
                if (c == '\r') continue;
                string5 = string5 + c;
            }
            if (string4 != null) {
                string5 = string4 + string5;
            }
            if ((n3 = this.addTextItem(string5, n2)) != -1) {
                ((MenuItemText)this.item[n3]).addScrollbar(this.can, this.textArea);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                inputStream.close();
                inputStream = null;
                System.gc();
            }
            catch (IOException iOException) {}
        }
        byArray = null;
        System.gc();
    }

    public void createTextMenu(int n, String string, String string2, String string3, int n2) {
        if (this.can == null) {
            return;
        }
        this.createMenu(n, string, string3);
        this.textMenu = true;
        int n3 = this.addTextItem(string2, n2);
        if (n3 != -1) {
            ((MenuItemText)this.item[n3]).addScrollbar(this.can, this.textArea);
        }
    }

    public void addTextItems(String string, int n) {
        string = this.can.font.WrapText(string, this.textArea.w);
        boolean bl = false;
        int n2 = string.indexOf(10);
        while (n2 != -1) {
            if (n2 > 1) {
                this.addTextItem(string.substring(0, n2), n, 0, false);
            }
            string = string.substring(n2 + 1);
            n2 = string.indexOf(10);
        }
        int n3 = this.addTextItem(string, n, 0, false);
    }

    void lshowMem() {
        System.gc();
    }
}

