/*
 * Decompiled with CFR 0.152.
 */
class ScrollBar {
    int m_top;
    int m_height;
    int m_xPos;
    int m_width;
    int m_max;
    int m_curVal;
    int thumbHeight;
    private final int MIN_THUMB_HEIGHT;
    static BImage mArrows = null;
    static BImage mRedArrows = null;

    ScrollBar(int n, int n2, int n3, int n4, int n5) {
        this.MIN_THUMB_HEIGHT = 10;
        this.setup(n, n2, n3, n4, n5);
    }

    public void setup(int n, int n2, int n3, int n4, int n5) {
        this.m_top = n2;
        this.m_height = n4;
        this.m_xPos = n;
        this.m_width = n3;
        this.m_curVal = 0;
        this.setMax(n5);
        if (mArrows == null) {
            mArrows = new BImage("tarrows");
            if (mArrows == null) {
                return;
            }
            int n6 = mArrows.getImageWidth();
            int n7 = mArrows.getImageHeight();
            mArrows.createColumnByRow("arrows", 2, 1, 0, 0, n6 / 2, n7 / 1, 1);
            mRedArrows = new BImage("rarrows");
            if (mRedArrows == null) {
                return;
            }
            n6 = mRedArrows.getImageWidth();
            n7 = mRedArrows.getImageHeight();
            mRedArrows.createColumnByRow("arrows", 2, 1, 0, 0, n6 / 2, n7 / 1, 1);
        }
    }

    public void scrollUp() {
        this.m_curVal = Use.croll(this.m_curVal - 1, 0, this.m_max - 1);
    }

    public void scrollDown() {
        this.m_curVal = Use.croll(this.m_curVal + 1, 0, this.m_max - 1);
    }

    public void setVal(int n) {
        this.m_curVal = Use.clamp(n, 0, this.m_max);
    }

    public int getValue() {
        return this.m_curVal;
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setMax(int n) {
        this.m_max = n;
        if (this.m_max == 0) {
            return;
        }
        this.thumbHeight = Use.clamp(this.m_height / this.m_max, 10, this.m_height);
        this.m_curVal = Use.clamp(this.m_curVal, 0, this.m_max);
    }

    public int getMax() {
        return this.m_max;
    }

    public void render(BCanvas bCanvas) {
        int n = Use.clamp(Use.MUL(this.m_height - this.thumbHeight, Use.DIV(this.m_curVal, this.m_max - 1)), 0, this.m_height - this.thumbHeight) + this.m_top;
        if (this.thumbHeight < this.m_height) {
            bCanvas.renderFillRect(0x404040, this.m_xPos, this.m_top, this.m_width, this.m_height);
            bCanvas.renderFillRect(16512467, this.m_xPos + 1, this.m_top + 1, this.m_width - 2, this.m_height - 2);
            bCanvas.renderFillRect(0x404040, this.m_xPos - 1, n, this.m_width + 2, this.thumbHeight);
            bCanvas.renderFillRect(16512467, this.m_xPos, n + 1, this.m_width, this.thumbHeight - 2);
            bCanvas.bTouchUp = false;
            bCanvas.bTouchDown = false;
            if (mArrows != null) {
                if (bCanvas.checkTouchInputFast(true, BBuild.CX - mArrows.getWidth(0, 0) / 2 - BBuild.WIDTH / 4, 0, BBuild.WIDTH / 2 + mArrows.getWidth(0, 0), this.m_top)) {
                    bCanvas.bTouchUp = true;
                    if (mRedArrows != null) {
                        mRedArrows.render(bCanvas, BBuild.CX - mArrows.getWidth(0, 0) / 2, this.m_top - mArrows.getHeight(0, 0), 0, 0);
                    }
                } else {
                    mArrows.render(bCanvas, BBuild.CX - mArrows.getWidth(0, 0) / 2, this.m_top - mArrows.getHeight(0, 0), 0, 0);
                }
                if (bCanvas.checkTouchInputFast(true, BBuild.CX - mArrows.getWidth(0, 0) / 2 - BBuild.WIDTH / 4, this.m_top + this.m_height, BBuild.WIDTH / 2 + mArrows.getWidth(0, 0), BBuild.HEIGHT)) {
                    bCanvas.bTouchDown = true;
                    if (mRedArrows != null) {
                        mRedArrows.render(bCanvas, BBuild.CX, this.m_top + this.m_height, 0, 1);
                    }
                } else {
                    mArrows.render(bCanvas, BBuild.CX, this.m_top + this.m_height, 0, 1);
                }
            } else if (bCanvas.checkTouchInputFast(true, this.m_xPos - 30, 0, (this.m_width << 1) + 40, n)) {
                bCanvas.bTouchUp = true;
            } else if (bCanvas.checkTouchInputFast(true, this.m_xPos - 30, n, (this.m_width << 1) + 40, this.m_top + this.m_height - n)) {
                bCanvas.bTouchDown = true;
            }
            bCanvas.clearClip();
        }
    }
}

