/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.VolumeControl;

public final class Fret
implements PlayerListener {
    public static final int SONG_END_PADDING = 1000;
    public static final byte NOTE_HOLD_PADDING = 8;
    public static final byte CHORD_TYPE_100 = 0;
    public static final byte CHORD_TYPE_010 = 1;
    public static final byte CHORD_TYPE_001 = 2;
    public static final byte CHORD_TYPE_110 = 3;
    public static final byte CHORD_TYPE_011 = 4;
    public static final byte CHORD_TYPE_101 = 5;
    public static final byte CHORD_TYPE_111 = 6;
    public static final byte[] CHORD_100 = new byte[]{1, 0, 0};
    public static final byte[] CHORD_010 = new byte[]{0, 1, 0};
    public static final byte[] CHORD_001 = new byte[]{0, 0, 1};
    public static final byte[] CHORD_110 = new byte[]{1, 1, 0};
    public static final byte[] CHORD_011 = new byte[]{0, 1, 1};
    public static final byte[] CHORD_101 = new byte[]{1, 0, 1};
    public static final byte[] CHORD_111 = new byte[]{1, 1, 1};
    public static final byte[][] SINGLE_CHORD_110 = new byte[][]{{1, 0, 0}, {0, 1, 0}};
    public static final byte[][] SINGLE_CHORD_011 = new byte[][]{{0, 1, 0}, {0, 0, 1}};
    public static final byte[][] SINGLE_CHORD_101 = new byte[][]{{1, 0, 0}, {0, 0, 1}};
    public static final byte[][] SINGLE_CHORD_111 = new byte[][]{{1, 0, 0}, {0, 0, 1}, {0, 1, 0}};
    public boolean playing = false;
    public static Player clip = null;
    public MIDIControl control = null;
    public VolumeControl vControl = null;
    public FretEventHandler FH = null;
    public static int numStrings = 0;
    public static final byte COLLISION_RANGE = 16;
    public static int rate = 16;
    public static int top = 0;
    public static int bottom = 0;
    public static int height = 0;
    public static int center = 0;
    public static int oneThird = 0;
    public static int twoThird = 0;
    public int CY1 = 0;
    public int CY2 = 0;
    public Line[] string = null;
    public Image tile = null;
    public int tileMod = 0;
    public int tileHeight = 0;
    public BCollisionBox hitBox = null;
    public NoteEvent[] note = null;
    public int num = 0;
    public static int numTempos = 0;
    public static int[] tempoTimes = null;
    public static int[] tempoTempos = null;
    public static int fretBarStep = 0;
    public static int songTime = 0;
    public boolean[] keyDown = null;
    public boolean[] keyPress = null;
    public boolean paused = true;
    public int numStarPower = 0;
    public int numStarPowerNotes = 0;
    public int notesDead = 0;
    public boolean notesStarted = false;
    public static final int BLANK_IGNORED_OFFSET = 1500;
    public static final int SONGS_PER_VENUE = 5;
    public static final int SONG1 = 0;
    public static final int SONG2 = 1;
    public static final int SONG3 = 2;
    public static final int SONG4 = 3;
    public static final int SONG5 = 4;
    public static final int SONG6 = 5;
    public static final int SONG7 = 6;
    public static final int SONG8 = 7;
    public static final int SONG9 = 8;
    public static final int SONG10 = 9;
    public static final int SONG11 = 10;
    public static final int SONG12 = 11;
    public static final int SONG13 = 12;
    public static final int SONG14 = 13;
    public static final int SONG15 = 14;
    public static final String SONG_JAD1 = "SONG_01_OFFSET";
    public static final String SONG_JAD2 = "SONG_02_OFFSET";
    public static final String SONG_JAD3 = "SONG_03_OFFSET";
    public static final String SONG_JAD4 = "SONG_04_OFFSET";
    public static final String SONG_JAD5 = "SONG_05_OFFSET";
    public static final String SONG_JAD6 = "SONG_06_OFFSET";
    public static final String SONG_JAD7 = "SONG_07_OFFSET";
    public static final String SONG_JAD8 = "SONG_08_OFFSET";
    public static final String SONG_JAD9 = "SONG_09_OFFSET";
    public static final String SONG_JAD10 = "SONG_10_OFFSET";
    public static final String SONG_JAD11 = "SONG_11_OFFSET";
    public static final String SONG_JAD12 = "SONG_12_OFFSET";
    public static final String SONG_JAD13 = "SONG_13_OFFSET";
    public static final String SONG_JAD14 = "SONG_14_OFFSET";
    public static final String SONG_JAD15 = "SONG_15_OFFSET";
    public static boolean firstTform = true;
    public static boolean masterMute = true;
    private byte[] m_data = null;
    public static long CLIP_START = 0L;

    public Fret(FretEventHandler fretEventHandler, int n, int n2, int n3, Point[] pointArray) {
        numStrings = 0;
        this.notesStarted = false;
        this.paused = true;
        this.notesDead = 0;
        if (Use.validObject(pointArray) && fretEventHandler != null) {
            top = n2;
            bottom = n3;
            this.CY1 = n3 - 16;
            this.CY2 = n3 + 8;
            height = n3 - n2;
            center = n2 + height / 2;
            oneThird = n2 + height / 3;
            twoThird = oneThird + height / 3;
            numStrings = pointArray.length;
            this.string = new Line[numStrings];
            for (int i = 0; i < numStrings; ++i) {
                this.string[i] = new Line(pointArray[i].x, n2, pointArray[i].y, n3);
            }
            this.FH = fretEventHandler;
            rate = n;
            this.keyDown = new boolean[numStrings];
            this.keyPress = new boolean[numStrings];
        }
    }

    public void setTile(String string) {
        if (numStrings == 0) {
            return;
        }
        this.tileMod = 0;
        this.tile = Use.loadImage(string);
        if (this.tile != null) {
            this.tileHeight = this.tile.getHeight();
            this.tileMod = rate * this.tileHeight;
        } else {
            numStrings = 0;
        }
    }

    public void setHits(String[] stringArray, int n, int n2, int n3, int n4) {
        if (numStrings == 0 || stringArray == null) {
            return;
        }
        if (this.hitBox == null) {
            this.hitBox = new BCollisionBox();
        }
        this.hitBox.addHit(stringArray, this.string, bottom, n, n2, n3, n4);
    }

    public void setLightning(String string, int n, int n2) {
        this.setEffect("LIGHTNING", 0, string, n, n2, 2);
    }

    public void setFlame(String string, int n, int n2) {
        this.setEffect("FLAME", 1, string, n, n2, 2);
    }

    public void setSpark(String string, int n, int n2) {
        this.setEffect("SPARK", 2, string, n, n2, 1);
    }

    public void setEffect(String string, int n, String string2, int n2, int n3, int n4) {
        BImage bImage;
        if (numStrings == 0 || string2 == null) {
            return;
        }
        if (this.hitBox == null) {
            this.hitBox = new BCollisionBox();
        }
        if ((bImage = new BImage(string2)) == null) {
            return;
        }
        int n5 = bImage.getImageWidth();
        int n6 = bImage.getImageHeight();
        bImage.createColumnByRow(string, n2, n3, 0, 0, n5 / n2, n6 / n3, n4);
        switch (n) {
            case 0: {
                this.hitBox.addLightning(bImage, numStrings);
                break;
            }
            case 1: {
                this.hitBox.addFlame(bImage, numStrings);
                break;
            }
            case 2: {
                this.hitBox.addSpark(bImage, numStrings);
            }
        }
    }

    public void setNoteData() {
        NoteEvent.sprStarPower = new Sprite[4];
        NoteEvent.sprStarPower[0] = new Sprite(BImage.CreateColumnByRow("star_g", "STARG", 3, 1, 0, 0, 24, 11));
        NoteEvent.sprStarPower[1] = new Sprite(BImage.CreateColumnByRow("star_r", "STARR", 3, 1, 0, 0, 24, 11));
        NoteEvent.sprStarPower[2] = new Sprite(BImage.CreateColumnByRow("star_y", "STARY", 3, 1, 0, 0, 24, 11));
        NoteEvent.sprStarPower[3] = new Sprite(BImage.CreateColumnByRow("star_b", "STARB", 3, 1, 0, 0, 24, 11));
        String[] stringArray = new String[]{"n_g_s", "n_r_s", "n_y_s", "n_b_s"};
        String[] stringArray2 = new String[]{"n_g_m", "n_r_m", "n_y_m", "n_b_m"};
        String[] stringArray3 = new String[]{"n_g_l", "n_r_l", "n_y_l", "n_b_l"};
        if (numStrings == 0) {
            return;
        }
        NoteEvent.color = new int[]{65280, 0xFF0000, 0xFFFF00, 60152};
        NoteEvent.imgNoteSM = new Image[stringArray.length];
        NoteEvent.imgNoteMD = new Image[stringArray2.length];
        NoteEvent.imgNoteLG = new Image[stringArray3.length];
        for (int i = 0; i < stringArray3.length; ++i) {
            NoteEvent.imgNoteSM[i] = Use.loadImage(stringArray[i]);
            NoteEvent.imgNoteMD[i] = Use.loadImage(stringArray2[i]);
            NoteEvent.imgNoteLG[i] = Use.loadImage(stringArray3[i]);
            if (NoteEvent.imgNoteSM[i] != null) continue;
            numStrings = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadNotesFromFile(String string, int n, int n2, int n3) {
        if (numStrings == 0) {
            return 0;
        }
        DataInputStream dataInputStream = null;
        int n4 = 0;
        try {
            dataInputStream = Use.loadDataFile(Use.fixFilePath(string));
            n4 = this.setNotes(dataInputStream, n, n2, n3);
        }
        catch (IOException iOException) {
            numStrings = 0;
            iOException.printStackTrace();
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                dataInputStream = null;
                System.gc();
            }
            catch (IOException iOException) {}
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadNotesFromStream(DataInputStream dataInputStream, int n, int n2, int n3) {
        if (numStrings == 0) {
            return 0;
        }
        int n4 = 0;
        try {
            n4 = this.setNotes(dataInputStream, n, n2, n3);
        }
        catch (IOException iOException) {
            numStrings = 0;
            iOException.printStackTrace();
        }
        finally {
            try {
                if (dataInputStream != null) {
                    dataInputStream.close();
                }
                dataInputStream = null;
                System.gc();
            }
            catch (IOException iOException) {}
        }
        return n4;
    }

    private int setNotes(DataInputStream dataInputStream, int n, int n2, int n3) throws IOException {
        int n4;
        short s;
        if (numStrings == 0) {
            return 0;
        }
        this.num = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        byte by = dataInputStream.readByte();
        fretBarStep = 0;
        songTime = dataInputStream.readInt();
        int n7 = dataInputStream.readInt();
        Scene.MASTER_TIME_OFFSET = ST.jadPropertyExists("MIDI-Master-Offset") ? ST.appPropertyInt("MIDI-Master-Offset") : 0;
        BBuild.soundRateFix = ST.jadPropertyExists("MIDI-Master-Rate") ? (long)ST.appPropertyInt("MIDI-Master-Rate") : 0L;
        if (Can.IGNORE_BLANK_MIDI_TIME) {
            Scene.MASTER_TIME_OFFSET += -n7;
            songTime -= n7;
        }
        int n8 = n2 * 5 + n3;
        String string = null;
        switch (n8) {
            case 0: {
                string = SONG_JAD1;
                break;
            }
            case 1: {
                string = SONG_JAD2;
                break;
            }
            case 2: {
                string = SONG_JAD3;
                break;
            }
            case 3: {
                string = SONG_JAD4;
                break;
            }
            case 4: {
                string = SONG_JAD5;
                break;
            }
            case 5: {
                string = SONG_JAD6;
                break;
            }
            case 6: {
                string = SONG_JAD7;
                break;
            }
            case 7: {
                string = SONG_JAD8;
                break;
            }
            case 8: {
                string = SONG_JAD9;
                break;
            }
            case 9: {
                string = SONG_JAD10;
                break;
            }
            case 10: {
                string = SONG_JAD11;
                break;
            }
            case 11: {
                string = SONG_JAD12;
                break;
            }
            case 12: {
                string = SONG_JAD13;
                break;
            }
            case 13: {
                string = SONG_JAD14;
                break;
            }
            case 14: {
                string = SONG_JAD15;
            }
        }
        if (string != null && ST.jadPropertyExists(string)) {
            Scene.MASTER_TIME_OFFSET = ST.appPropertyInt(string);
        }
        if (string != null && ST.jadPropertyExists("SONG_RATE_" + (n8 + 1))) {
            BBuild.soundRateFix = ST.appPropertyInt("SONG_RATE_" + (n8 + 1));
        }
        numTempos = dataInputStream.readShort();
        tempoTimes = null;
        tempoTempos = null;
        if (numTempos > 0) {
            tempoTimes = new int[numTempos];
            tempoTempos = new int[numTempos];
            n5 = 0;
            while (n5 < numTempos) {
                Fret.tempoTimes[n5] = dataInputStream.readInt();
                Fret.tempoTempos[n5] = dataInputStream.readInt();
                int n9 = n5++;
                tempoTempos[n9] = tempoTempos[n9] / 1000;
            }
            fretBarStep = tempoTempos[0];
        }
        if ((s = dataInputStream.readShort()) > 0) {
            byte[] byArray = null;
            for (n5 = 0; n5 < s; ++n5) {
                n4 = dataInputStream.readInt();
                byte by2 = dataInputStream.readByte();
                int n10 = dataInputStream.readByte();
                if (n10 <= 0) continue;
                for (n6 = 0; n6 < n10; ++n6) {
                    byte by3 = dataInputStream.readByte();
                    short s2 = dataInputStream.readShort();
                    if (s2 <= 0) continue;
                    byte by4 = dataInputStream.readByte();
                    if (by3 != n) continue;
                    switch (by4) {
                        case 0: {
                            byArray = CHORD_100;
                            break;
                        }
                        case 1: {
                            byArray = CHORD_010;
                            break;
                        }
                        case 2: {
                            byArray = CHORD_001;
                            break;
                        }
                        case 3: {
                            byArray = SINGLE_CHORD_110[Use.rnd(SINGLE_CHORD_110.length - 1)];
                            break;
                        }
                        case 4: {
                            byArray = SINGLE_CHORD_011[Use.rnd(SINGLE_CHORD_011.length - 1)];
                            break;
                        }
                        case 5: {
                            byArray = SINGLE_CHORD_101[Use.rnd(SINGLE_CHORD_101.length - 1)];
                            break;
                        }
                        case 6: {
                            byArray = SINGLE_CHORD_111[Use.rnd(SINGLE_CHORD_111.length - 1)];
                        }
                    }
                    if (Can.IGNORE_BLANK_MIDI_TIME && n4 <= n7 + 1500) continue;
                    this.addNoteEvent(n4, by2, s2, byArray);
                }
            }
            System.gc();
        }
        if (this.num > 0 && songTime != (n4 = this.note[this.num - 1].time + this.note[this.num - 1].len)) {
            if (n4 > songTime) {
                songTime = n4 + 1000;
            } else if (songTime - n4 < 1000) {
                songTime += 1000;
            }
        }
        if (!this.loadMIDI(Use.getData(dataInputStream))) {
            this.num = 0;
        }
        this.setNumStarPower();
        return this.num;
    }

    private int addNoteEvent(int n, byte by, int n2, byte[] byArray) {
        int n3 = this.num++;
        NoteEvent[] noteEventArray = null;
        if (this.note != null) {
            noteEventArray = new NoteEvent[this.note.length];
            System.arraycopy(this.note, 0, noteEventArray, 0, this.note.length);
        }
        this.note = new NoteEvent[this.num];
        if (noteEventArray != null) {
            System.arraycopy(noteEventArray, 0, this.note, 0, noteEventArray.length);
        }
        this.note[n3] = new NoteEvent(n3, n, by, n2, byArray);
        if (noteEventArray != null) {
            noteEventArray = null;
            System.gc();
        }
        return n3;
    }

    private void setNumStarPower() {
        this.numStarPowerNotes = 0;
        this.numStarPower = 0;
        boolean bl = false;
        for (int i = 0; i < this.num; ++i) {
            if (this.note[i].type == 1) {
                if (!bl) {
                    ++this.numStarPower;
                    bl = true;
                }
                ++this.numStarPowerNotes;
                continue;
            }
            if (!bl) continue;
            bl = false;
        }
    }

    public boolean starPowerStart(NoteEvent noteEvent) {
        int n;
        if (noteEvent.type == 1 && (n = noteEvent.index - 1) >= 0 && n < this.num) {
            if (this.note[n].type == 0) {
                return true;
            }
            if (n == 0) {
                return true;
            }
        }
        return false;
    }

    public boolean starPowerEnd(NoteEvent noteEvent) {
        int n;
        if (noteEvent.type == 1 && (n = noteEvent.index + 1) >= 0 && n < this.num) {
            if (this.note[n].type == 0) {
                return true;
            }
            if (n == this.num - 1) {
                return true;
            }
        }
        return false;
    }

    public void playLightning(int n) {
        if (this.hitBox != null) {
            this.hitBox.playLightning(n);
        }
    }

    public int interpolate(int n, int n2) {
        if (numStrings == 0) {
            return 0;
        }
        return this.string[n].x1 + Use.MUL(this.string[n].w, Use.DIV(n2 - top, height));
    }

    public int transform(int n) {
        int n2 = (BBuild.getSongTime() - (n - BBuild.songTimeOffset) + bottom * rate) / rate;
        return n2;
    }

    public int transformClipped(int n) {
        return Use.clamp((BBuild.getSongTime() - (n - BBuild.songTimeOffset) + bottom * rate) / rate, top, bottom);
    }

    public void disableHits() {
        if (this.hitBox != null) {
            this.hitBox.disableHits();
        }
    }

    public void change(BCanvas bCanvas) {
        if (bCanvas == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        if (this.paused) {
            this.disableHits();
            return;
        }
        this.hitBox.playHit(bCanvas.playKeysDown());
        for (n = 0; n < numStrings; ++n) {
            this.keyDown[n] = bCanvas.playKeyDown(n);
        }
        boolean bl = false;
        for (n = this.notesDead; n < this.num; ++n) {
            if (!this.note[n].inPlay()) continue;
            bl = true;
            this.notesStarted = true;
            break;
        }
        if (!bl && bCanvas.anyPlayKeyPressed()) {
            this.noteMissed(true);
            Use.print("NO NOTE IN PLAY -- MISS!");
            return;
        }
        for (n = this.notesDead; n < this.num; ++n) {
            if (!this.note[n].active()) continue;
            if (!this.note[n].onKeys(this.keyDown)) break;
            Use.print(" -------- KEYDOWN ----------");
            for (n2 = 0; n2 < numStrings; ++n2) {
                this.keyPress[n2] = bCanvas.playKeyPressed(n2);
            }
            if (!this.note[n].onKeys(this.keyPress)) break;
            if (this.note[n].inRange(this.CY1, this.CY2)) {
                this.noteHit(this.note[n]);
                Use.print(" -------- NOTE IN PLAY -- HIT!");
                break;
            }
            this.noteMissed(true);
            Use.print(" -------- NOTE IN PLAY -- MISS!");
            break;
        }
    }

    public byte noteStatus(int n) {
        if (n < top) {
            return 0;
        }
        if (n < this.CY2) {
            return 1;
        }
        return 4;
    }

    public void noteHit(NoteEvent noteEvent) {
        this.FH.onHit(noteEvent);
        noteEvent.status = 2;
        this.playGuitar();
        this.hitBox.playFlame(noteEvent);
    }

    public void noteHeld(NoteEvent noteEvent) {
        if (numStrings == 0) {
            return;
        }
        if (this.hitBox != null) {
            this.hitBox.playSpark(noteEvent);
        }
        this.playGuitar();
        this.FH.onHeld(noteEvent);
    }

    public void noteLostHold(NoteEvent noteEvent, int n) {
        if (numStrings == 0) {
            return;
        }
        if (this.hitBox != null) {
            this.hitBox.stopSpark(noteEvent);
        }
        if (n > 8) {
            this.muteGuitar();
        }
        this.FH.onLostHold(noteEvent, n);
    }

    public void killNote(NoteEvent noteEvent) {
        noteEvent.status = 3;
        ++this.notesDead;
        Use.print("NOTE DIED: " + this.notesDead + " of " + Scene.notesNeeded);
    }

    public void noteMissed(boolean bl) {
        if (numStrings == 0) {
            return;
        }
        this.muteGuitar();
        this.FH.onMiss();
        if (bl) {
            BSound.vibrate();
        }
    }

    public boolean visible(int n) {
        return n > top && n < BBuild.HEIGHT;
    }

    public void renderTile(BCanvas bCanvas) {
        if (numStrings == 0) {
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = BBuild.getSongTime();
        if (this.paused) {
            n3 = 0;
        }
        if (Scene.MASTER_TIME_OFFSET > 0) {
            n3 += Scene.MASTER_TIME_OFFSET;
        }
        if (this.tileMod > 0) {
            bCanvas.setClip(0, top, BBuild.WIDTH, BBuild.HEIGHT - top);
            n2 = BBuild.HEIGHT - this.tileHeight + (n3 % this.tileMod + rate) / rate;
            bCanvas.renderImage(this.tile, n2 - this.tileHeight);
            bCanvas.renderImage(this.tile, n2);
        }
        for (n = 0; n < this.string.length; ++n) {
            bCanvas.drawGradLine(this.string[n], ST.FRET_LINE_COLOUR, 6);
        }
        if (fretBarStep > 0) {
            for (n = numTempos - 1; n >= 0; --n) {
                if (n3 <= tempoTimes[n]) continue;
                fretBarStep = tempoTempos[n];
                break;
            }
            bCanvas.clearClip();
            bCanvas.setColor(ST.FRET_BAR_COLOUR);
            for (n = 0; n < songTime; n += fretBarStep) {
                n2 = (n3 - n + bottom * rate) / rate;
                if (n2 <= top || n2 >= bottom) continue;
                bCanvas.graphics.drawLine(0, n2, BBuild.WIDTH, n2);
            }
        }
    }

    public void render(BCanvas bCanvas, boolean bl) {
        if (numStrings == 0) {
            return;
        }
        if (!this.paused) {
            for (int i = this.notesDead; i < this.num; ++i) {
                this.note[i].render(bCanvas, this, bl);
            }
        }
        if (this.hitBox != null) {
            this.hitBox.render(bCanvas, false);
        }
    }

    public static void setMasterMute(boolean bl) {
        masterMute = bl;
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string.equals("started")) {
            this.songStart();
        } else if (string.equals("volumeChanged")) {
            // empty if block
        }
    }

    private void songStart() {
        this.paused = false;
        this.FH.onSongStart();
    }

    public boolean loadMIDI(byte[] byArray) {
        this.playing = false;
        clip = null;
        this.control = null;
        if (!BBuild.HAS_SOUND) {
            return true;
        }
        this.m_data = byArray;
        System.gc();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMIDI() {
        InputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(this.m_data);
            clip = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
                inputStream = null;
                System.gc();
            }
            catch (Exception exception) {}
        }
        this.playing = true;
        if (BBuild.HAS_SOUND) {
            if (clip != null) {
                clip.addPlayerListener((PlayerListener)this);
                try {
                    clip.realize();
                    this.control = (MIDIControl)clip.getControl("MIDIControl");
                    if (this.control == null && masterMute) {
                        this.vControl = (VolumeControl)clip.getControl("VolumeControl");
                    }
                    clip.prefetch();
                    CLIP_START = System.currentTimeMillis() - Scene.MIDI_START_TIME;
                    clip.start();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.playing = false;
                }
            } else {
                this.songStart();
            }
        } else {
            this.songStart();
        }
    }

    public long getMIDIDuration() {
        if (BBuild.HAS_SOUND) {
            long l = 0L;
            if (clip != null) {
                try {
                    l = clip.getDuration();
                    l = l == -1L ? 0L : (l /= 1000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return l;
        }
        return 0L;
    }

    public long setMIDITime() {
        if (BBuild.HAS_SOUND) {
            long l = 0L;
            if (clip != null) {
                try {
                    l = System.currentTimeMillis() - CLIP_START;
                    clip.setMediaTime(l * 1000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return l;
        }
        return 0L;
    }

    public static long getMIDITime() {
        if (BBuild.HAS_SOUND) {
            long l = 0L;
            if (clip != null) {
                try {
                    l = clip.getMediaTime();
                    l = l == -1L ? 0L : (l /= 1000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return l;
        }
        return 0L;
    }

    public void stopMIDI() {
        this.paused = true;
        if (clip != null) {
            try {
                clip.deallocate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void destroyMIDI(boolean bl) {
        this.paused = true;
        if (clip != null && bl) {
            try {
                clip.removePlayerListener((PlayerListener)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                clip.deallocate();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                clip.close();
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.FH = null;
        this.vControl = null;
        this.control = null;
        clip = null;
        System.gc();
    }

    public void muteGuitar() {
        System.out.println("IN muteGuitar()");
        if (this.paused || !BBuild.HAS_SOUND || clip == null) {
            return;
        }
        if (this.control != null) {
            if (this.playing) {
                this.control.setChannelVolume(0, 0);
                this.playing = false;
            }
        } else if (this.vControl != null && this.playing) {
            this.vControl.setMute(true);
            this.playing = false;
        }
    }

    private void playGuitar() {
        if (this.paused || !BBuild.HAS_SOUND || clip == null) {
            return;
        }
        if (this.control != null) {
            if (!this.playing) {
                this.control.setChannelVolume(0, 127);
                this.playing = true;
            }
        } else if (this.vControl != null && !this.playing) {
            this.vControl.setMute(false);
            this.playing = true;
        }
    }

    public void destroy() {
        Use.deleteObject(this.string);
        Use.deleteObject((Object)tempoTimes);
        Use.deleteObject((Object)tempoTempos);
        if (this.hitBox != null) {
            this.hitBox.destroy();
        }
        Use.deleteObject(this.hitBox);
        Use.deleteObject((Object)NoteEvent.color);
        Use.deleteObject(NoteEvent.imgNoteSM);
        Use.deleteObject(NoteEvent.imgNoteMD);
        Use.deleteObject(NoteEvent.imgNoteLG);
        for (int i = 0; i < this.num; ++i) {
            this.note[i].destroy();
        }
        Use.deleteObject(this.note);
        this.num = 0;
    }
}

