/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class BDataStore {
    private static final byte SET = 0;
    private static final byte GET = 1;
    private DataEventHandler DH = null;
    private String name = null;
    public int numRecords = 0;

    public BDataStore(String string, DataEventHandler dataEventHandler) {
        if (dataEventHandler == null || string == null) {
            return;
        }
        if (string.length() == 0) {
            return;
        }
        this.DH = dataEventHandler;
        this.name = string;
        this.numRecords = 0;
    }

    public void reset() {
        this.put(true);
        this.get();
    }

    public void save() {
        this.put(false);
    }

    public void put(boolean bl) {
        if (this.numRecords == 0) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.DH.setData(dataOutputStream, bl);
            this.access(byteArrayOutputStream.toByteArray(), 0);
            dataOutputStream.close();
            dataOutputStream = null;
            System.gc();
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void get() {
        if (this.numRecords == 0) {
            return;
        }
        try {
            byte[] byArray = this.access(null, 1);
            if (byArray == null) {
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.DH.getData(dataInputStream);
            dataInputStream.close();
            dataInputStream = null;
            System.gc();
        }
        catch (RecordStoreException recordStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] access(byte[] byArray, int n) throws RecordStoreException {
        RecordStore recordStore = RecordStore.openRecordStore((String)this.name, (boolean)false);
        this.numRecords = recordStore.getNumRecords();
        byte[] byArray2 = null;
        switch (n) {
            case 0: {
                if (byArray == null) {
                    return null;
                }
                recordStore.setRecord(1, byArray, 0, byArray.length);
                break;
            }
            case 1: {
                byArray2 = recordStore.getRecord(1);
            }
        }
        recordStore.closeRecordStore();
        return byArray2;
    }

    public boolean storeExists() {
        if (this.name == null) {
            return false;
        }
        boolean bl = false;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)this.name, (boolean)true);
            this.numRecords = recordStore.getNumRecords();
            if (this.numRecords == 0) {
                byte[] byArray = new byte[1];
                this.numRecords = recordStore.addRecord(byArray, 0, byArray.length);
                byArray = null;
                System.gc();
            } else {
                bl = true;
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        return bl;
    }
}

