/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Engine;
import com.gameever.akatis.Paintable;
import javax.microedition.lcdui.Graphics;

public final class CenteredLayer
implements Paintable {
    final byte[] bg;
    public int speed;
    boolean topLayer = false;

    public CenteredLayer(byte[] _bg, int _speed) {
        this.speed = _speed;
        this.bg = _bg;
        if (this.speed == 4608) {
            this.topLayer = true;
        }
    }

    public void setTopLayer() {
        this.topLayer = true;
    }

    public int getXPosFor(int xpos) {
        return Engine.penmiddle - (96 - xpos);
    }

    public void draw(Graphics g, int time) {
        g.setClip(Engine.pleft, Engine.ptop, Engine.pwidth, Engine.pheight);
        int bgPos = time * this.speed >> 16;
        int bgPosMod = bgPos & 0x1F;
        int bgPosDiv = bgPos >> 5;
        int vscrleft = Engine.vscrl + (this.topLayer ? Engine.enshift - Engine.bgshift : Engine.vscrdelta * this.speed + 32768 >> 16);
        int bgIndex = bgPosDiv * 12;
        for (int i = 1; i <= Engine.tileHeightToDraw; ++i) {
            int topPos = i << 5;
            if (bgIndex >= this.bg.length) {
                bgIndex %= this.bg.length;
            }
            for (int j = 0; j < 12; ++j) {
                int leftPos;
                byte actImIndex;
                if ((actImIndex = this.bg[bgIndex++]) < 0 || actImIndex >= Engine.bgImages.length || topPos - Engine.bgHeight[actImIndex] > Engine.pheight + bgPosMod || (leftPos = (j << 4) - vscrleft) >= Engine.pright || Engine.bgWidth[actImIndex] + leftPos < Engine.pleft) continue;
                g.drawImage(Engine.bgImages[actImIndex], Engine.pleft + leftPos, Engine.pbottom + bgPosMod - topPos, 20);
            }
        }
    }
}

