/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Engine;
import com.gameever.akatis.HighScoreItem;
import com.gameever.akatis.RMS;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public final class HighScores {
    private static final int MAX = 8;
    private static final HighScores INSTANCE = new HighScores();
    private final Vector vector = new Vector();
    private static final String[] FAKE_NAMES = new String[]{"ghost", "barrage", "sam", "wildcat", "bear", "unknown", "unknown", "unknown"};
    private static final int[] FAKE_POINTS = new int[]{10000, 8000, 6000, 5000, 4000, 3000, 2000, 1000};
    private static final int[] FAKE_DIFFICULTIES = new int[]{0, 0, 1, 2, 1, 2, 0, 2};

    protected static HighScores getInsctance() {
        return INSTANCE;
    }

    private HighScores() {
    }

    protected int getSize() {
        int size = this.vector.size();
        if (size > 8) {
            size = 8;
        }
        return size;
    }

    protected HighScoreItem get(int index) {
        return (HighScoreItem)this.vector.elementAt(index);
    }

    protected void put(HighScoreItem item, int index) {
        this.vector.insertElementAt(item, index);
        while (this.vector.size() > 8) {
            this.vector.removeElementAt(8);
        }
    }

    protected void load() {
        this.vector.removeAllElements();
        byte[] bytes = RMS.getInstance().get("Akatis_highscores");
        if (bytes == null) {
            this.init();
            this.save();
        } else {
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size = dis.readInt();
                for (int i = 0; i < size; ++i) {
                    HighScoreItem item = new HighScoreItem();
                    item.load(dis);
                    this.vector.addElement(item);
                }
            }
            catch (IOException e) {
                Engine.getInstance().error("Unable to load high scores", e);
            }
        }
    }

    public String toString() {
        int size = this.vector.size();
        StringBuffer sb = new StringBuffer("HighScores: " + size + '\n');
        for (int i = 0; i < size; ++i) {
            HighScoreItem item = (HighScoreItem)this.vector.elementAt(i);
            sb.append("[" + i + "]: " + item + '\n');
        }
        return sb.toString();
    }

    protected void save() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int size = this.vector.size();
        try {
            dos.writeInt(size);
            for (int i = 0; i < size; ++i) {
                HighScoreItem item = (HighScoreItem)this.vector.elementAt(i);
                item.save(dos);
            }
            dos.close();
        }
        catch (IOException e) {
            Engine.getInstance().error("Unable to save high scores", e);
            return;
        }
        byte[] bytes = baos.toByteArray();
        RMS.getInstance().set("Akatis_highscores", bytes);
    }

    private void init() {
        for (int i = 0; i < 8; ++i) {
            HighScoreItem item = new HighScoreItem(FAKE_NAMES[i], FAKE_POINTS[i], FAKE_DIFFICULTIES[i]);
            this.vector.addElement(item);
        }
    }
}

