/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Engine;
import com.gameever.akatis.Stuff;

public final class Bullet {
    public boolean enemy;
    public int fxAct;
    public int fyAct;
    public int angle;
    public int speed;
    public int type;
    public int actFrame;
    public int accFrameTime;
    public int fdx;
    public int fdy;
    public int fd;
    public int damage;
    public int fPhase = -1;
    final int actblfrnum;
    public int spawnParticle = 0;

    public Bullet(boolean _enemy, int _fxAct, int _fyAct, int _angle, int _speed, int _type, int _damage) {
        this.enemy = _enemy;
        this.fxAct = _fxAct;
        this.fyAct = _fyAct;
        this.speed = _speed * Engine.bulletSpeed >> 8;
        this.angle = _angle;
        this.type = _type;
        this.damage = _damage;
        this.actblfrnum = Engine.bulletFrameNum[this.type];
        this.fxAct -= Engine.fBulletWidth[this.type] >> 1;
    }

    public void move(int ft) {
        if (this.actblfrnum > 1) {
            this.accFrameTime += ft;
            this.spawnParticle += ft;
            this.actFrame += this.accFrameTime >> 5;
            this.accFrameTime &= 0x1F;
            while (this.actFrame >= this.actblfrnum) {
                this.actFrame -= this.actblfrnum;
            }
        }
        if (this.fPhase >= 0) {
            int oldph = Stuff.sin(this.fPhase >> 8);
            this.fPhase += ft * 90;
            while (this.fPhase >= 92160) {
                this.fPhase -= 92160;
            }
            int actph = Stuff.sin(this.fPhase >> 8);
            this.fxAct += (actph - oldph) * 8 >> 8;
            this.fyAct += ft * this.speed;
            return;
        }
        int d = ft * this.speed;
        if (d == 0) {
            return;
        }
        if (this.angle >= 0) {
            this.fxAct += Stuff.cos(this.angle) * d >> 16;
            this.fyAct -= Stuff.sin(this.angle) * d >> 16;
        } else {
            while (d > this.fd) {
                this.fxAct += this.fdx;
                this.fyAct += this.fdy;
                d -= this.fd;
            }
            int ratio = (d << 8) / this.fd;
            this.fxAct += ratio * this.fdx >> 8;
            this.fyAct += ratio * this.fdy >> 8;
        }
    }

    void seek(int mindx, int mindy, int mind, int ft) {
        this.angle = -1;
        this.fdx = mindx;
        this.fdy = mindy;
        this.fd = mind;
        int actd = ft * this.speed;
        if (actd >= mind) {
            this.fxAct += mindx;
            this.fyAct += mindy;
        } else {
            int ratio = (actd << 8) / mind;
            this.fxAct += ratio * mindx >> 8;
            this.fyAct += ratio * mindy >> 8;
        }
    }
}

