/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Logger;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class Streaming {
    private static final Streaming INSTANCE = new Streaming();
    private static final int EOF = -1;
    private static final int N = 10;
    private static final int R = 13;
    private static final int C = 35;

    private Streaming() {
    }

    public static String[] readLines(InputStream is, boolean dropComments) {
        try {
            int c;
            Vector vector = new Vector();
            StringBuffer buffer = new StringBuffer();
            while ((c = is.read()) != -1) {
                if (c == 13) continue;
                if (c == 10) {
                    if (dropComments && buffer.charAt(0) == '#') {
                        buffer.setLength(0);
                        continue;
                    }
                    Streaming.add(buffer, vector);
                    continue;
                }
                buffer.append((char)c);
            }
            Streaming.add(buffer, vector);
            is.close();
            Object[] lines = new String[vector.size()];
            vector.copyInto(lines);
            return lines;
        }
        catch (Throwable t) {
            Logger.error(INSTANCE, "Unable to read lines!", t);
            return null;
        }
    }

    public static String[] readLines(InputStream is, int EOF) {
        try {
            int c;
            Vector vector = new Vector();
            StringBuffer buffer = new StringBuffer();
            int n = 10;
            while ((c = is.read()) != -1 && c != EOF) {
                if (c == n) {
                    Streaming.add(buffer, vector);
                    continue;
                }
                buffer.append((char)c);
            }
            Streaming.add(buffer, vector);
            Object[] texts = new String[vector.size()];
            vector.copyInto(texts);
            return texts;
        }
        catch (Exception e) {
            Logger.error(INSTANCE, "Unable to load text", e);
            return null;
        }
    }

    private static void add(StringBuffer buffer, Vector vector) {
        vector.addElement(buffer.toString());
        buffer.setLength(0);
    }

    public static byte[] read(InputStream is, boolean isDebug) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streaming.copy(is, baos, -1, isDebug);
        return baos.toByteArray();
    }

    public static byte[] read(InputStream is, int length, boolean isDebug) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streaming.copy(is, baos, length, isDebug);
        return baos.toByteArray();
    }

    public static int read(InputStream is, OutputStream os, int size) throws IOException {
        int length = size;
        if (length > 1024) {
            length = 1024;
        }
        byte[] buffer = new byte[length];
        int read = 0;
        int diff = size;
        do {
            if ((length = is.available()) < 1 || length > diff) {
                length = diff;
            }
            if (length > buffer.length) {
                length = buffer.length;
            }
            length = is.read(buffer, 0, length);
            Thread.yield();
            if (length == -1) break;
            os.write(buffer, 0, length);
        } while ((diff = size - (read += length)) > 0);
        if (diff != 0) {
            Logger.error(INSTANCE, "read size: " + diff);
        }
        buffer = null;
        os.flush();
        Thread.yield();
        return read;
    }

    public static byte[] read(InputStream is, String pattern, boolean isDebug) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Streaming.read(is, baos, pattern, isDebug);
        return baos.toByteArray();
    }

    private static int read(InputStream is, OutputStream os, String pattern, boolean isDebug) {
        ByteArrayOutputStream baos;
        block13: {
            baos = new ByteArrayOutputStream(1024);
            StringBuffer buffer = new StringBuffer();
            int ch = -1;
            try {
                do {
                    if ((ch = is.read()) == -1) {
                        if (isDebug) {
                            Logger.debug(INSTANCE, "EOF signal received");
                        }
                        break block13;
                    }
                    buffer.append((char)ch);
                    baos.write(ch);
                } while (!buffer.toString().endsWith(pattern));
                if (isDebug) {
                    Logger.debug(INSTANCE, "Pattern found: " + pattern);
                }
            }
            catch (IOException e) {
                Logger.error(INSTANCE, "Unable to read stream", e);
            }
        }
        try {
            baos.flush();
        }
        catch (IOException e) {
            Logger.error(INSTANCE, "Unable to flush stream", e);
        }
        byte[] bytes = baos.toByteArray();
        try {
            os.write(bytes);
        }
        catch (IOException e) {
            Logger.error(INSTANCE, "Unable to write stream", e);
        }
        try {
            os.flush();
        }
        catch (IOException e) {
            Logger.error(INSTANCE, "Unable to flush stream", e);
        }
        if (isDebug) {
            Logger.debug(INSTANCE, bytes.length + " bytes were received");
        }
        return bytes.length;
    }

    public static byte[] read(String file) throws IOException {
        return Streaming.read(Streaming.getStream(file), false);
    }

    public static String[] readLines(String file, boolean dropComments) {
        return Streaming.readLines(Streaming.getStream(file), dropComments);
    }

    public static InputStream getStream(String file) {
        InputStream stream = null;
        try {
            stream = INSTANCE.getClass().getResourceAsStream('/' + file);
            if (stream == null) {
                throw new IOException("File not found: " + file);
            }
        }
        catch (Throwable t) {
            Logger.error(INSTANCE, "Unable to open file: " + file, t);
            return null;
        }
        return stream;
    }

    public static int copy(InputStream is, OutputStream os, int size, boolean isDebug) {
        int copied;
        byte[] buffer;
        block16: {
            int length;
            if (isDebug) {
                Logger.debug(INSTANCE, "reading stream: " + size);
            }
            if ((length = size) <= 0) {
                length = 2048;
            }
            buffer = new byte[length];
            copied = 0;
            do {
                length = buffer.length;
                if (size > 0 && copied + length > size) {
                    length = size - copied;
                }
                if (isDebug) {
                    Logger.debug(INSTANCE, "reading... " + length);
                }
                try {
                    length = is.read(buffer, 0, length);
                }
                catch (IOException e) {
                    Logger.error(INSTANCE, "Unable to read stream", e);
                    break block16;
                }
                if (length == -1) {
                    if (isDebug) {
                        Logger.debug(INSTANCE, "EOF signal received at: " + copied);
                    }
                    break block16;
                }
                try {
                    os.write(buffer, 0, length);
                }
                catch (IOException e) {
                    Logger.error(INSTANCE, "Unable to write stream", e);
                    break block16;
                }
            } while (size <= 0 || (copied += length) < size);
            if (isDebug) {
                Logger.debug(INSTANCE, "End of stream at: " + copied);
            }
        }
        buffer = null;
        try {
            os.flush();
        }
        catch (IOException e) {
            Logger.error(INSTANCE, "Unable to flush stream", e);
            return -1;
        }
        if (isDebug) {
            Logger.debug(INSTANCE, copied + "/" + size + " bytes were copied");
        }
        if (copied != size && isDebug) {
            Logger.warning(INSTANCE, "size doesn't match: " + copied + " != " + size);
        }
        return copied;
    }

    public static byte[] readLine(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c = is.read();
        if (c == -1) {
            throw new EOFException();
        }
        while (c != 10 && c != -1) {
            if (Character.isDigit((char)c)) {
                baos.write(c);
            }
            c = is.read();
        }
        baos.flush();
        baos.close();
        return baos.toByteArray();
    }
}

