/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Engine;
import com.gameever.akatis.Paintable;
import javax.microedition.lcdui.Graphics;

public final class JustifiedLayer
implements Paintable {
    final byte[] bg;
    public int speed;
    int maxShift;
    int justCenterTile;
    boolean topLayer = false;

    public JustifiedLayer(byte[] _bg, int _speed) {
        this.speed = _speed;
        this.bg = _bg;
        if (this.speed == 4608) {
            this.topLayer = true;
        }
    }

    public void setTopLayer() {
        this.topLayer = true;
    }

    public void postInit() {
        this.maxShift = 16 * ((this.speed << 8) / Engine.fMaxBGSpeed) + 128 >> 8;
        this.justCenterTile = Engine.pwidth + this.maxShift >> 5;
        if ((Engine.pwidth + this.maxShift & 0x1F) != 0) {
            ++this.justCenterTile;
        }
        if (this.justCenterTile > 6) {
            this.justCenterTile = 6;
        }
    }

    public int getXPosFor(int xpos) {
        if (xpos < Engine.penmiddle) {
            return xpos;
        }
        if (xpos >= 192 - Engine.penmiddle) {
            return Engine.penwidth - (192 - xpos);
        }
        return -1;
    }

    public void draw(Graphics g, int time) {
        int leftPos;
        byte actImIndex;
        int j;
        int topPos;
        int bgIndex;
        int i;
        int bgPos = time * this.speed >> 16;
        int bgPosMod = bgPos & 0x1F;
        int bgPosDiv = bgPos >> 5;
        int vscrleft = this.topLayer ? Engine.enshift - Engine.bgshift : Engine.vscrdelta * this.speed + 32768 >> 16;
        g.setClip(Engine.pleft, Engine.ptop, Engine.pwidth >> 1, Engine.pheight);
        for (i = 1; i <= Engine.tileHeightToDraw; ++i) {
            bgIndex = (bgPosDiv + i - 1) * 12;
            if (bgIndex >= this.bg.length) {
                bgIndex %= this.bg.length;
            }
            topPos = i << 5;
            for (j = 0; j < this.justCenterTile; ++j) {
                if ((actImIndex = this.bg[bgIndex++]) < 0 || actImIndex >= Engine.bgImages.length || topPos - Engine.bgHeight[actImIndex] > Engine.pheight + bgPosMod) continue;
                leftPos = (j << 4) - this.maxShift - vscrleft;
                g.drawImage(Engine.bgImages[actImIndex], Engine.pleft + leftPos, Engine.pbottom + bgPosMod - topPos, 20);
            }
        }
        g.setClip(Engine.pwidth >> 1, Engine.ptop, Engine.pwidth >> 1, Engine.pheight);
        for (i = 1; i <= Engine.tileHeightToDraw; ++i) {
            bgIndex = (bgPosDiv + i - 1) * 12 + 6;
            if (bgIndex >= this.bg.length) {
                bgIndex %= this.bg.length;
            }
            topPos = i << 5;
            for (j = 6; j < 12; ++j) {
                if ((actImIndex = this.bg[bgIndex++]) < 0 || actImIndex >= Engine.bgImages.length || (leftPos = Engine.pwidth + this.maxShift - vscrleft - (12 - j << 4)) >= Engine.pright || Engine.bgWidth[actImIndex] + leftPos < Engine.pleft + (Engine.pwidth >> 2) || topPos - Engine.bgHeight[actImIndex] > Engine.pheight + bgPosMod) continue;
                g.drawImage(Engine.bgImages[actImIndex], Engine.pleft + leftPos, Engine.pbottom + bgPosMod - topPos, 20);
            }
        }
    }
}

