/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.EnemyType;
import com.gameever.akatis.Engine;
import com.gameever.akatis.Path;

public final class Enemy {
    public int bgPos;
    public int hp;
    public int type;
    public int dx;
    public int dy;
    public int lastShot;
    public int bulletFreq;
    final EnemyType entype;
    final Path p;
    public int pathPoint = -1;
    int fxPoint;
    int fyPoint;
    int fdAct;
    int fwait;
    public int fxAct;
    public int fyAct;
    public int explosionTime = -1;
    public int flashTime = 0;
    public Enemy[] shadows;
    public int fxGhost;
    public int fyGhost;
    public int ghostTime = -1;
    public byte[] actorParams;

    public Enemy(int _type, int _bgPos, int _path, int _dx, int _dy, EnemyType _entype) {
        this.type = _type;
        this.entype = _entype;
        this.bgPos = _bgPos;
        this.dx = _dx;
        this.dy = _dy;
        this.hp = this.entype.hp;
        if (this.entype.bulletType >= 16) {
            this.bulletFreq = this.entype.bulletFreq;
        } else {
            this.lastShot = -1;
        }
        this.p = _path < Engine.pathes.length ? Engine.pathes[_path] : null;
        if (this.type == 9) {
            this.shadows = new Enemy[3];
            this.shadows[0] = new Enemy(59, this.bgPos, _path, this.dx, this.dy, this.entype);
            this.shadows[1] = new Enemy(59, this.bgPos, _path, this.dx, this.dy, this.entype);
            this.shadows[2] = new Enemy(59, this.bgPos, _path, this.dx, this.dy, this.entype);
        }
        if (this.type == 19) {
            this.actorParams = new byte[2];
            this.dx = 0;
        }
    }

    public Enemy(int _type, int _bgPos, byte[] _actorParams) {
        this.type = _type;
        this.entype = null;
        this.p = null;
        this.bgPos = _bgPos;
        this.actorParams = _actorParams;
    }

    void activate(int penmiddle, int penwidth, int pheight, int fAccBGTime, int accFrameTime) {
        if (this.p == null) {
            if (this.type == 17) {
                if (Engine.levelNum == 9) {
                    this.fxAct = Engine.bgLayers[Engine.bgLayers.length - 1].getXPosFor(this.dx) - 16 << 8;
                    this.fyAct = Engine.enbgpos - this.bgPos << 8;
                } else {
                    this.fxAct = Engine.bgLayers[Engine.bgLayers.length - 1].getXPosFor(this.dx) + 70 << 8;
                    this.fyAct = Engine.enbgpos - this.bgPos << 8;
                }
            } else {
                this.fxAct = Engine.bgLayers[Engine.bgLayers.length - 2].getXPosFor(this.dx) << 8;
                this.fyAct = Engine.enbgpos - this.bgPos << 8;
            }
            this.pathPoint = 0;
            return;
        }
        if (this.type == 10) {
            this.fyPoint = Short.MIN_VALUE;
            this.fxPoint = Short.MIN_VALUE;
            this.fyAct = Short.MIN_VALUE;
            this.fxAct = Short.MIN_VALUE;
            this.ghostTime = 0;
            this.fxGhost = (this.dx << 8) / 192;
            this.fyGhost = this.dy + this.p.y[0];
            System.out.println("Activating; fxGhost: " + this.fxGhost + ", fyGhost: " + this.fyGhost + ", dx: " + this.dx + ", dy: " + this.dy + " bgPos: " + this.bgPos + ", p.x[0]: " + this.p.x[0] + ", p.y[0]:" + this.p.y[0] + ", p.dx[0]: " + this.p.dx[0] + ", p.dy[0]: " + this.p.dy[0]);
        } else {
            this.fxAct = this.fxPoint = (this.dx << 8) / 192;
            this.fyAct = this.fyPoint = (this.dy - Engine.enHeight[this.type] << 16) / pheight >> 8;
        }
        this.pathPoint = 0;
        this.fwait = this.p.wait[0];
        if (this.type == 9) {
            for (int i = 0; i < 3; ++i) {
                this.shadows[i].fxPoint = this.fxPoint;
                this.shadows[i].fyPoint = this.fyPoint;
                this.shadows[i].fxAct = this.fxAct;
                this.shadows[i].fyAct = this.fyAct;
                this.shadows[i].pathPoint = this.pathPoint;
                this.shadows[i].fwait = 32 * (i + 1);
            }
        }
        int temp1 = this.bgPos - Engine.enHeight[this.type] - pheight - (fAccBGTime * Engine.fEnemyBGSpeed >> 16);
        int temp2 = (int)(((long)temp1 << 16) / (long)Engine.fEnemyBGSpeed);
        int time = accFrameTime - temp2;
        this.move(time, penwidth, pheight);
    }

    void move(int ft, int penwidth, int pheight) {
        if (this.p == null) {
            this.fyAct = Engine.enbgpos - this.bgPos << 8;
            return;
        }
        if (this.shadows != null) {
            this.shadows[0].move(ft, penwidth, pheight);
            this.shadows[1].move(ft, penwidth, pheight);
            this.shadows[2].move(ft, penwidth, pheight);
        } else if (this.ghostTime >= 0) {
            this.ghostTime += ft;
            if (this.ghostTime >= 96) {
                ft -= this.ghostTime - 96;
                this.ghostTime = -1;
                this.fdAct = 0;
                this.fxPoint = this.fxGhost;
                this.fyPoint = this.fyGhost;
                this.fxAct = this.fxPoint * penwidth;
                this.fyAct = this.fyPoint * pheight;
                if (this.pathPoint < this.p.length) {
                    ++this.pathPoint;
                    this.fwait = this.p.wait[this.pathPoint];
                } else {
                    return;
                }
            }
        }
        if (this.fwait > 0) {
            if (this.fwait > ft) {
                this.fwait -= ft;
                ft = 0;
            } else {
                ft -= this.fwait;
                this.fwait = 0;
            }
        }
        int fdAdv = ft * this.entype.speed * this.p.speed[this.pathPoint] >> 8;
        int fdRem = this.p.fDist[this.pathPoint] - this.fdAct;
        while (fdAdv > fdRem) {
            fdAdv -= fdRem;
            this.fxPoint += this.p.dx[this.pathPoint];
            this.fyPoint += this.p.dy[this.pathPoint];
            if (this.pathPoint < this.p.length || this.type >= 20) {
                ++this.pathPoint;
                if (this.type >= 20 && this.pathPoint >= this.p.length) {
                    this.pathPoint -= this.p.length;
                }
                this.fwait = this.p.wait[this.pathPoint];
                if (this.fwait > 0) {
                    int fremft = (fdAdv << 8) / (this.entype.speed * this.p.speed[this.pathPoint]);
                    if (fremft > this.fwait) {
                        this.fwait = 0;
                        fdAdv = (fremft -= this.fwait) * this.entype.speed * this.p.speed[this.pathPoint] >> 8;
                    } else {
                        this.fwait -= fremft;
                        fdAdv = 0;
                    }
                }
            }
            this.fdAct = 0;
            fdRem = this.p.fDist[this.pathPoint];
        }
        this.fdAct += fdAdv;
        if (this.type == 10 && this.ghostTime < 0 && fdRem >> 2 < this.fdAct) {
            this.ghostTime = 0;
            if (this.pathPoint < this.p.length) {
                this.fxGhost += this.p.dx[this.pathPoint];
                this.fyGhost += this.p.dy[this.pathPoint];
            } else {
                this.fyGhost = Short.MIN_VALUE;
                this.fxGhost = Short.MIN_VALUE;
            }
        }
        int fdRatio = (this.fdAct << 8) / this.p.fDist[this.pathPoint];
        this.fxAct = ((this.fxPoint << 8) + fdRatio * this.p.dx[this.pathPoint]) * penwidth >> 8;
        this.fyAct = ((this.fyPoint << 8) + fdRatio * this.p.dy[this.pathPoint]) * pheight >> 8;
    }
}

