/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Engine;
import com.gameever.akatis.Paintable;
import javax.microedition.lcdui.Graphics;

public final class RepeatedLayer
implements Paintable {
    final byte[] bg;
    public int speed;
    public int tileWidthToDraw;
    public int startTile;
    public int endTile;
    boolean topLayer = false;

    public RepeatedLayer(byte[] _bg, int _speed) {
        this.speed = _speed;
        this.bg = _bg;
        int actwidth = Engine.pwidth + (16 * ((this.speed << 8) / Engine.fMaxBGSpeed) >> 7);
        this.tileWidthToDraw = actwidth >> 4;
        if ((Engine.pwidth & 0xF) != 0) {
            ++this.tileWidthToDraw;
        }
        this.startTile = 6 - (this.tileWidthToDraw >> 1);
        this.endTile = 6 + (this.tileWidthToDraw >> 1);
        if (this.speed == 4608) {
            this.topLayer = true;
        }
    }

    public void setTopLayer() {
        this.topLayer = true;
    }

    public int getXPosFor(int xpos) {
        return Engine.penmiddle - (96 - xpos);
    }

    public void draw(Graphics g, int time) {
        g.setClip(Engine.pleft, Engine.ptop, Engine.pwidth, Engine.pheight);
        int bgPos = time * this.speed >> 16;
        int bgPosMod = bgPos & 0x1F;
        int bgPosDiv = bgPos >> 5;
        int vscrleft = Engine.vscrl + (this.topLayer ? Engine.enshift - Engine.bgshift : Engine.vscrdelta * this.speed + 32768 >> 16);
        for (int i = 1; i <= Engine.tileHeightToDraw; ++i) {
            int bgIndex = (bgPosDiv + i - 1) * 12;
            if (bgIndex >= this.bg.length) {
                bgIndex %= this.bg.length;
            }
            int topPos = i << 5;
            for (int j = -7; j < this.endTile; ++j) {
                int leftPos;
                int actInd;
                for (actInd = j; actInd < 0; actInd += 6) {
                }
                while (actInd >= 12) {
                    actInd -= 6;
                }
                byte actImIndex = this.bg[bgIndex + actInd];
                if (actImIndex < 0 || actImIndex >= Engine.bgImages.length || topPos - Engine.bgHeight[actImIndex] > Engine.pheight + bgPosMod || (leftPos = (j << 4) - vscrleft) >= Engine.pright || Engine.bgWidth[actImIndex] + leftPos < Engine.pleft) continue;
                g.drawImage(Engine.bgImages[actImIndex], Engine.pleft + leftPos, Engine.pbottom + bgPosMod - topPos, 20);
            }
        }
    }
}

