/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

public class Logger {
    private static final String COLUM_SEPARATOR = ": ";
    private static final int LEVEL_OFF = 0;
    private static final int LEVEL_ERROR = 1;
    private static final int LEVEL_WARNING = 2;
    private static final int LEVEL_DEBUG = 3;
    private static final int LEVEL_LOG = 4;
    private static final String[] LEVELS = new String[]{"off", "error", "warning", "debug", "log"};
    private static final int LEVEL = Logger.getLevel();
    private static int id = 0;

    private Logger() {
    }

    private static void println(String name, String level, String message) {
        String line = "" + id++ + " | " + level + COLUM_SEPARATOR + name + COLUM_SEPARATOR + message;
        System.out.println(line);
    }

    private static void write(Object source, String level, String message) {
        String name = Logger.getName(source);
        Logger.println(name, level, message);
    }

    public static void log(Object source, String message) {
        if (LEVEL < 4) {
            return;
        }
        Logger.write(source, LEVELS[4], message);
    }

    public static void debug(Object source, String message) {
        if (LEVEL < 3) {
            return;
        }
        Logger.write(source, LEVELS[3], message);
    }

    public static void warning(Object source, String message) {
        if (LEVEL < 2) {
            return;
        }
        Logger.write(source, LEVELS[2], message);
    }

    public static void error(Object source, String message) {
        if (LEVEL < 1) {
            return;
        }
        Logger.write(source, LEVELS[1], message);
    }

    public static void error(Object source, String message, Throwable t) {
        if (LEVEL < 1) {
            return;
        }
        Logger.write(source, LEVELS[1], message + " " + Logger.getErrorMessage(t));
    }

    public static String getErrorMessage(Throwable t) {
        return Logger.getName(t) + " " + t.getMessage();
    }

    public static String getName(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        String name = object.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    private static int getLevel() {
        return 4;
    }
}

