/*
 * Decompiled with CFR 0.152.
 */
package com.gameever.akatis;

import com.gameever.akatis.Bullet;
import com.gameever.akatis.CenteredLayer;
import com.gameever.akatis.Enemy;
import com.gameever.akatis.EnemyType;
import com.gameever.akatis.Event;
import com.gameever.akatis.HighScoreItem;
import com.gameever.akatis.HighScores;
import com.gameever.akatis.JustifiedLayer;
import com.gameever.akatis.Logger;
import com.gameever.akatis.Main;
import com.gameever.akatis.Paintable;
import com.gameever.akatis.Path;
import com.gameever.akatis.RMS;
import com.gameever.akatis.RepeatedLayer;
import com.gameever.akatis.Streaming;
import com.gameever.akatis.Stuff;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

final class Engine
extends Canvas
implements Runnable {
    private static final int FPS = 100;
    private static final int FRAME_TIME = 10;
    protected static final int GTL = 20;
    protected static final boolean ISHIRES = true;
    protected static final boolean ISLORES = false;
    private static int[] numberWidth = new int[]{10, 8, 10, 10, 10, 10, 10, 10, 10, 10};
    private static int[] fontWidth = new int[]{0};
    private static int[] shopNumberWidth = new int[]{9, 7, 8, 8, 9, 8, 9, 8, 9, 9};
    private static int bottomButtonYOffset = 6;
    private static int bottom1ButtonXOffset = 10;
    private static int bottom3ButtonXOffset = 6;
    private static int top1NumXOffset = 8;
    private static int top1NumYOffset = 6;
    private static int top3NumXOffset = 27;
    private static int top3NumYOffset = 6;
    private static int[] extraGunVerticalTilt = new int[]{768, 1024, 1024};
    private static int menuPointYOffset = 14;
    private static int weaponInfo1YOffset = 6;
    private static int weaponInfo2YOffset = 32;
    private static int weaponInfo3YOffset = 9;
    private static int fBoss1WingOffsetX = 9984;
    private static int fBoss1WingOffsetY = 6144;
    private static int fBoss2WingOffsetX = 9984;
    private static int fBoss2WingOffsetY = 6144;
    private static int fBoss3WingOffsetX = 9984;
    private static int fBoss3WingOffsetY = 6144;
    private static int fBoss4WingOffsetX = 9984;
    private static int fBoss4WingOffsetY = 6144;
    private static int scrDissolveSize = 2;
    private static int rocketParticleYOffset = 8;
    private static int PAINT_CHAPTER_Y = 24;
    private static final int STATE_START = 0;
    private static final int STATE_MENU_IN = 1;
    private static final int STATE_MENU_DOOR_OUT = 7;
    private static final int STATE_MENU = 2;
    private static final int STATE_MENU_NEWQUESTION = 36;
    private static final int STATE_MENU_UPGRADE_OPEN = 9;
    private static final int STATE_MENU_UPGRADE = 11;
    private static final int STATE_MENU_UPGRADE_CLOSE = 10;
    private static final int STATE_MENU_DOOR_IN = 8;
    private static final int STATE_MENU_TO_GAME = 3;
    private static final int STATE_MENU_CHAPTER_OPEN = 33;
    private static final int STATE_MENU_CHAPTER = 34;
    private static final int STATE_MENU_CHAPTER_CLOSE = 35;
    private static final int STATE_GAME = 4;
    private static final int STATE_GAME_TOP_IN = 12;
    private static final int STATE_GAME_TOP_OUT = 13;
    private static final int STATE_GAME_TO_MENU_PAR = 5;
    private static final int STATE_GAME_QUITQUESTION = 32;
    private static final int STATE_WEAPONINFO_IN = 14;
    private static final int STATE_WEAPONINFO_OUT = 15;
    private static final int STATE_NOT_ENOUGH_MONEY = 16;
    private static final int STATE_MENU_TO_SCORES = 18;
    private static final int STATE_SCORES = 19;
    private static final int STATE_SCORES_TO_MENU = 20;
    private static final int STATE_MENU_TO_STORY = 21;
    private static final int STATE_STORY = 22;
    private static final int STATE_STORY_NEXT_PAGE = 23;
    private static final int STATE_STORY_TO_GAME = 24;
    private static final int STATE_GAME_TO_STORY = 25;
    private static final int STATE_STORY_TO_MENU = 26;
    private static final int STATE_STORY_TO_SCORES = 30;
    private static final int STATE_GAME_LEVEL_END = 27;
    private static final int STATE_EXIT = 28;
    private static final int STATE_GAME_TO_SCORES = 29;
    private static final int STATE_LOGO = 31;
    static final int STATE_MENU_TO_ABCO = 37;
    static final int STATE_GAME_TO_SCE = 38;
    private static final int STATE_CHAPTER_BACK_TO_MENU = 101;
    private static final int STATE_MENU_RESTARTQUESTION = 102;
    private static final int STATE_STR_SCE = 103;
    private static final int STATE_NEWGAME = 104;
    private static final int STATE_LOAD = 105;
    private static final int STATE_QES_TO_GAME = 106;
    private int state = 31;
    private int nextState;
    private int prevState;
    private static final int FLASH_RED = 1;
    private static final int FLASH_BLUE = 2;
    private static final int FLASH_WHITE = 3;
    private static final int shipSpeed = 142;
    private static final int extraGunSpeed = 96;
    protected static final int maxBGShift = 16;
    private static final int maxShipSlideTime = 64;
    private final int SCREEN_WIDTH;
    private final int SCREEN_HEIGHT;
    private final int REAL_WIDTH;
    private final int REAL_HEIGHT;
    static int pleft;
    static int pright;
    static int ptop;
    static int ptop2;
    static int pbottom;
    static int fShipX;
    static int fShipY;
    static int fShipSlidePos;
    static int fShipLimitX;
    static int fShipLimitY;
    static int shipHP;
    static int shipPrevHP;
    static int maxShipHP;
    static int shipSlideTime;
    static int shipDestroyTime;
    static int shipFrostTime;
    private int shipWeaponFront = -1;
    private int shipWeaponBack = -1;
    private int shipWeaponShield = -1;
    private int shipWeaponExtra = -1;
    static int fExtraGunX;
    static int fExtraGunY;
    static int shipFrontFired;
    static int shipBackFired;
    static int shipExtraFired;
    static boolean shipWeaponFrontDualLeft;
    static boolean shipWeaponBackDualLeft;
    static boolean shipWeaponExtraLeft;
    static boolean language;
    static boolean[] gombok;
    static boolean ngage;
    static boolean gameend;
    static int pwidth;
    static int pheight;
    static int pmiddle;
    static int penwidth;
    static int fpenwidth;
    static int penmiddle;
    static int vscrl;
    static int vscrr;
    static int vscrdelta;
    static int maxvscrdelta;
    static int fMaxBGSpeed;
    static int fEnemyBGSpeed;
    static int fMaxEnShift;
    static int fenshift;
    static int enshift;
    static int bgshift;
    static int enbgpos;
    static int vseged;
    static int tileHeightToDraw;
    static long levelStartTime;
    static long figyel;
    private int lastFrameTime;
    private int accFrameTime;
    private int lastFrameStart;
    private int actFrameStart;
    private int actdtt;
    private int dxtt;
    private int dytt;
    private int fAccBGTime;
    static Image[] bgImages;
    static int[] bgWidth;
    static int[] bgHeight;
    static Paintable[] bgLayers;
    static Enemy[] enemies;
    static Image[] enemyImages;
    private static final int[] enWidth;
    static final int[] enHeight;
    private static final int[] fenWidth;
    private static final int[] fenHeight;
    private static final int[] enExpl;
    static int explSize;
    static int fExplSize;
    static int enBegin;
    static final Image[] bulletImages;
    private static final int[] bulletHeight;
    private static final int[] bulletWidth;
    private static final int[] fBulletHeight;
    protected static final int[] fBulletWidth;
    public static final Bullet[] bullets;
    public static int bulletLast;
    public static int topause;
    public static int tothread;
    private final int[] weaponRate = new int[]{95, 80, 160, 95, 100, 120, 150, 180, 240, 160, 160, 160, 256, 190, 460, 300};
    private static final int[] weaponPrice;
    protected static final int[] bulletFrameNum;
    static Image[] explosionImages;
    static Image shipImage;
    static int shipWidth;
    static int shipHeight;
    static int fShipWidth;
    static int fShipHeight;
    static int readyWidth;
    static int readyHeight;
    static Path[] pathes;
    static final char[] fontChar;
    private static final int[] fontStart;
    private static final int[] numberStart;
    private static final int[] shopNumberStart;
    static int fontHeight;
    static int numberHeight;
    static int shopNumberHeight;
    static Image shopNumberImage;
    static Image numberImage;
    static Image fontImage;
    static Image readyImage;
    static Image topBorder;
    static Image topLives;
    static Image topScore;
    static Image menuk;
    static int topScorePos;
    static int topLivesPos;
    static int topBorderPos;
    static int menukPos;
    private Image bottomLeftDisplay;
    private Image bottomRightDisplay;
    private Image bottomBorder;
    private int softTop;
    static int bottomLeftDisplayPos;
    static int bottomRightDisplayPos;
    static int bottomBorderPos;
    static Image bottomNext;
    static Image bottomPrev;
    static Image buttonRight;
    static Image bottomHP;
    static Image bottomHelp;
    static int bottomLeftIconPos;
    static int bottomRightIconPos;
    static int topHeight;
    static int top1Width;
    static int top3Width;
    static int top1Height;
    static int menukHeight;
    static int menukWidth;
    static int bottomHeight;
    static int bottom1Width;
    static int bottom3Width;
    static int button1Width;
    static int button3Width;
    static int buttonHeight;
    static int leftDoorWidth;
    static int rightDoorWidth;
    static int weaponInfoHeight;
    static int actMenuHeight;
    static int accMenuTime;
    private Image menuBG;
    private Image menuBGAct;
    private Image menuBGActNew;
    private Image doorImageRight;
    private Image doorImageLeft;
    static int leftDoorPos;
    static int rightDoorPos;
    static int weaponInfoPos;
    private Image upgradeBG;
    private Image weaponInfoImage;
    private Image weaponInfoImageNew;
    private Image nyil;
    static Image[] chapterBigImages;
    static Image[] chapterNOOK;
    static Image[] chapterLabelImages;
    static Image[] chapterNumImages;
    static int chapterBigImageX;
    static int chapterScrollDelta;
    static int[] chapterBigImageIndices;
    private int selectedChapter;
    static int menuParent;
    private int menuSelect;
    private int menuIndex;
    private static final int[] menu;
    private static final int[] menuJump;
    private static final int[] menuHelp;
    private String[] messages;
    static EnemyType[] entypes;
    static int messageID;
    static int messageTime;
    private static final int readyTime = 50;
    private static final int weaponNameIndex = 30;
    private static final int gameMessageIndex = 39;
    private static final int storyMessageIndex = 43;
    static int shipBlinkingTime;
    static Random random;
    static int shipFlashTime;
    static int shipFlashType;
    static int shipFlashWidth;
    static int shipFlashHeight;
    static Image[] particleImages;
    static int[] particlefXPos;
    static int[] particlefYPos;
    static int[] particlefTime;
    static int[] particleAngleSin;
    static int[] particleAngleCos;
    static int[] particleSpeed;
    static int[] particleAnimPos;
    private int score = 0;
    private int actScore = 0;
    private int levelNumHPScore = 0;
    private int levelNums = 0;
    static int levelNum;
    private int shopWeaponFront;
    private int shopWeaponBack;
    private int shopWeaponShield;
    private int shopWeaponExtra;
    private static final int[] shieldBulletIndex;
    private final String[] highScoreNamesX = new String[8];
    private final int[] highScoresX = new int[8];
    static int[] storyPageIndex;
    static int actStory;
    static int actStoryPage;
    static int prevStoryPage;
    static int lastStoryPage;
    static int storyMargin;
    static int storyWidth;
    static int prevMainEnemyHP;
    static Enemy mainEnemy;
    static boolean scrollLevel;
    static int[] meDestroyTime;
    static int[] meDestroyX;
    static int[] meDestroyY;
    static boolean mainEnemyDualLeft;
    static int mainEnemyFront;
    static int playerLives;
    private static final int[] storyBeforeLevel;
    static final int[] storyAfterLevel;
    private boolean highScorePossible = false;
    static boolean shouldDrawShip;
    static int prevPlayerLives;
    static int prevScore;
    public static int bulletSpeed;
    static Image shipEngineParticleImage;
    static Image shipEngineParticleImageFW;
    static Image shipEngineParticleImageFW2;
    static int shipEngineParticleXOffset;
    static int shipEngineParticleYOffset;
    static int shipEngineParticleXSize;
    static int shipEngineParticleYSize;
    static int shipEngineParticleSpawnTime;
    public static Player player;
    public static String TT;
    public static String actMusic;
    private boolean isRestartable = false;
    private int restartScore;
    private int restartShipWeaponFront;
    private int restartShipWeaponBack;
    private int restartShipWeaponShield;
    private int restartShipWeaponExtra;
    private static final Engine INSTANCE;
    Thread thread;
    private static final String RMS_GAME = "Akatis_game_1";
    private static final int FRAME_TIME_MINIMUM = 1;
    private static final int FRAME_TIME_MAXIMUM = 32;
    public static boolean isRunning;
    static int nextBulletInd;
    private boolean isContunue = false;
    private boolean isArcade = false;
    private int savedWeaponFront;
    private int savedWeaponBack;
    private int savedWeaponShield;
    private int savedWeaponExtra;
    private int savedScore;
    protected static final int DIFF_EASY = 0;
    protected static final int DIFF_NORMAL = 1;
    protected static final int DIFF_HARD = 2;
    private int difficulty = 0;
    private byte[] levels = new byte[]{0, 0, 0};
    private static final int WEAPON_FRONT_RED1 = 0;
    private static final int WEAPON_FRONT_RED2 = 1;
    private static final int WEAPON_FRONT_RED3 = 2;
    private static final int WEAPON_FRONT_BLUE1 = 3;
    private static final int WEAPON_FRONT_BLUE2 = 4;
    private static final int WEAPON_FRONT_BLUE3 = 5;
    private static final int WEAPON_FRONT_FIRE1 = 6;
    private static final int WEAPON_FRONT_FIRE2 = 7;
    private static final int WEAPON_FRONT_FIRE3 = 8;
    private static final int WEAPON_FRONT_CHUTE1 = 9;
    private static final int WEAPON_FRONT_CHUTE2 = 10;
    private static final int[] WEAPONS_FRONT;
    private static final int WEAPON_BACK_BLUE1 = 12;
    private static final int WEAPON_BACK_BLUE2 = 13;
    private static final int WEAPON_BACK_RED1 = 14;
    private static final int WEAPON_BACK_RED2 = 15;
    private static final int[] WEAPONS_BACK;
    private static final int WEAPON_SHIELD1 = 0;
    private static final int WEAPON_SHIELD2 = 1;
    private static final int[] WEAPONS_SHIELD;
    private static final int WEAPON_EXTRA_BLUE = 0;
    private static final int WEAPON_EXTRA_GREEN = 1;
    private static final int WEAPON_EXTRA_PURPLE = 2;
    private static final int[] WEAPONS_EXTRA;
    private static final int[][] WEAPONS;
    private static final int WEAPON_TYPE_FRONT = 0;
    private static final int WEAPON_TYPE_BACK = 1;
    private static final int WEAPON_TYPE_SHIELD = 2;
    private static final int WEAPON_TYPE_EXTRA = 3;
    private static final int[][] AVAILABLE_WEAPONS;
    private static final int[] MAX_SCORES;
    private static final int DIRECTION_INCREASE = 1;
    private static final int DIRECTION_DECREASE = -1;
    private static final int[][] WEAPONS_NEW_FRONT;
    private static final int[][] WEAPONS_NEW_BACK;
    private static final int[][] WEAPONS_NEW_SHIELD;
    private static final int[][] WEAPONS_NEW_EXTRA;
    private static final int[][][] WEAPONS_NEW;
    static int editingHighScore;
    static int editingHighScorePos;
    static char[] editingName;
    static Image[] storyImages;
    static int[] storyBG;
    static int storyBGX;
    static int storyBGY;
    static int prevStoryBGMod;
    static int prevStoryBGDiv;
    static boolean storyBGPlanet;
    static int accStoryBGTime;
    private boolean isSoundEnabled = RMS.getInstance().getString("Akatis_sound", "true").equals("true");
    Thread t;
    private static final int DOOR_SPEED = 10;
    private long lastPaintTime;
    static int x1max;
    static int x2min;
    static int y1max;
    static int y2min;
    private static final int SPEED = 1;
    private final Event[] ehie = new Event[16];
    private int ehFirst = 0;
    private int ehLast = 0;
    private static final int SOFT_LEFT = -6;
    private static final int SPECIAL_BACK = -99;
    private static final int SOFT_RIGHT = -7;
    private boolean error;

    protected static Engine getInstance() {
        return INSTANCE;
    }

    private Engine() {
        this.setFullScreenMode(true);
        this.SCREEN_WIDTH = 240;
        this.SCREEN_HEIGHT = 320;
        this.REAL_WIDTH = this.SCREEN_WIDTH;
        this.REAL_HEIGHT = this.SCREEN_HEIGHT;
        pleft = 0;
        pright = this.SCREEN_WIDTH;
        pwidth = pright - pleft;
        pmiddle = (pleft + pright) / 2;
        vseged = vscrl = (pwidth >> 1) + 64;
        vscrr = (pwidth >> 1) + 96;
        Engine.shieldBulletIndex[1] = -1;
        Engine.shieldBulletIndex[0] = -1;
        storyMargin = this.SCREEN_WIDTH >> 5;
        storyWidth = this.SCREEN_WIDTH - 2 * storyMargin;
        shipFlashWidth = this.SCREEN_WIDTH >> 5;
        bulletSpeed = (this.SCREEN_HEIGHT << 8) / 128;
    }

    private void loadStatic() {
        String debug = "debug 1";
        try {
            int i;
            InputStream is = this.getClass().getResourceAsStream("/intla");
            this.messages = Streaming.readLines(is, true);
            debug = "debug 3";
            this.nyil = Image.createImage((String)"/nyil.png");
            debug = "debug 3.1";
            shipImage = Image.createImage((String)"/pl.png");
            debug = "debug 3.2";
            shipWidth = shipImage.getWidth() / 3;
            debug = "debug 3.3";
            shipHeight = shipImage.getHeight();
            debug = "debug 3.4";
            fShipWidth = shipWidth << 8;
            debug = "debug 3.5";
            fShipHeight = shipHeight << 8;
            debug = "debug 4";
            for (int i2 = 0; i2 < bulletImages.length; ++i2) {
                int j = i2;
                if (i2 == 30 || i2 == 32 || i2 == 33 || i2 == 11) continue;
                if (i2 == 15 || i2 == 16) {
                    j = 17;
                }
                debug = "debug 4.1";
                Engine.bulletImages[i2] = Image.createImage((String)("/en/b" + j / 10 + j % 10 + ".png"));
                debug = "debug 4.2";
                Engine.bulletWidth[i2] = bulletImages[i2].getWidth() / bulletFrameNum[j];
                debug = "debug 4.3";
                Engine.bulletHeight[i2] = bulletImages[i2].getHeight();
                Engine.fBulletWidth[i2] = bulletWidth[i2] << 8;
                Engine.fBulletHeight[i2] = bulletHeight[i2] << 8;
            }
            debug = "debug 5";
            readyImage = Image.createImage((String)"/ready.png");
            readyWidth = readyImage.getWidth() / 3;
            readyHeight = readyImage.getHeight();
            fontImage = Image.createImage((String)"/font.png");
            numberImage = Image.createImage((String)"/num.png");
            debug = "debug 6";
            int actFontStart = 0;
            for (i = 0; i < fontChar.length; ++i) {
                try {
                    Engine.fontStart[i] = actFontStart;
                    actFontStart += fontWidth[i];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return;
                }
            }
            debug = "debug 7";
            actFontStart = 0;
            for (i = 0; i < 10; ++i) {
                Engine.numberStart[i] = actFontStart;
                actFontStart += numberWidth[i];
            }
            debug = "debug 8";
            fontHeight = fontImage.getHeight();
            numberHeight = numberImage.getHeight();
            debug = "debug 8.1";
            this.bottomLeftDisplay = Image.createImage((String)"/bottom_1.png");
            this.softTop = this.SCREEN_HEIGHT - this.bottomLeftDisplay.getHeight();
            this.bottomBorder = Image.createImage((String)"/bottom_2.png");
            this.bottomRightDisplay = Image.createImage((String)"/bottom_3.png");
            debug = "debug 8.2";
            topBorder = Image.createImage((String)"/top.png");
            menuk = Image.createImage((String)"/menuk.png");
            topLives = Image.createImage((String)"/top_live.png");
            topScore = Image.createImage((String)"/top_score.png");
            debug = "debug 8.3";
            topHeight = topBorder.getHeight();
            top1Width = topScore.getWidth();
            top1Height = topScore.getHeight();
            top3Width = topLives.getWidth();
            menukHeight = menuk.getHeight();
            menukWidth = menuk.getWidth();
            debug = "debug 8.4";
            bottomHeight = this.bottomBorder.getHeight();
            bottom1Width = this.bottomLeftDisplay.getWidth();
            bottom3Width = this.bottomRightDisplay.getWidth();
            shipFlashHeight = this.SCREEN_HEIGHT - bottomHeight - Math.max(top1Height, topLives.getHeight());
            debug = "debug 8.5";
            HighScores.getInsctance().load();
            ptop = topHeight;
            ptop2 = Math.max(topHeight, top1Height);
            pbottom = this.SCREEN_HEIGHT - bottomHeight;
            pheight = pbottom - ptop;
            tileHeightToDraw = pheight + 128 >> 5;
            if ((pheight & 0x1F) > 0) {
                ++tileHeightToDraw;
            }
            debug = "debug 9";
        }
        catch (Exception e) {
            this.error("loadStatic: " + debug, e);
        }
    }

    public void setLayer(int i, int stretch, byte[] bg, int speed) {
        switch (stretch) {
            case 0: {
                Engine.bgLayers[i] = new CenteredLayer(bg, speed);
                break;
            }
            case 1: {
                Engine.bgLayers[i] = new RepeatedLayer(bg, speed);
                break;
            }
            case 2: {
                Engine.bgLayers[i] = new JustifiedLayer(bg, speed);
            }
        }
    }

    private void loadLevel(int levelNum) {
        try {
            int i;
            int i2;
            int len;
            String imageFile;
            if (entypes == null) {
                entypes = new EnemyType[64];
            }
            InputStream is = this.getClass().getResourceAsStream("/entypes");
            String actLine = Stuff.readLine(is);
            int i3 = 0;
            while (actLine != null && actLine.length() > 0) {
                if (actLine.startsWith("#")) {
                    --i3;
                } else {
                    String[] sp = new String[6];
                    int actIndex = 0;
                    int spInd = 0;
                    StringBuffer acts = new StringBuffer();
                    while (spInd < 6) {
                        char actc;
                        char c = actc = actIndex < actLine.length() ? (char)actLine.charAt(actIndex) : (char)',';
                        if (actc == ',') {
                            sp[spInd++] = acts.toString();
                            acts.setLength(0);
                        } else {
                            acts.append(actc);
                        }
                        ++actIndex;
                    }
                    int[] isp = new int[sp.length];
                    for (int j = 0; j < sp.length; ++j) {
                        isp[j] = Integer.parseInt(sp[j].trim());
                    }
                    Engine.entypes[i3] = new EnemyType(isp[0], isp[1], isp[2], isp[3], isp[4], isp[5]);
                }
                actLine = Stuff.readLine(is);
                ++i3;
            }
            Vector<Image> v = new Vector<Image>(20, 10);
            is = this.getClass().getResourceAsStream("/l" + levelNum + "trl");
            int i4 = 0;
            while ((imageFile = Stuff.readLine(is)).length() > 1) {
                v.addElement(Image.createImage((String)imageFile));
                ++i4;
            }
            bgImages = new Image[v.size()];
            v.copyInto(bgImages);
            bgWidth = new int[bgImages.length];
            bgHeight = new int[bgImages.length];
            for (i4 = 0; i4 < bgImages.length; ++i4) {
                Engine.bgWidth[i4] = bgImages[i4].getWidth();
                Engine.bgHeight[i4] = bgImages[i4].getHeight();
            }
            if (pathes == null) {
                is = this.getClass().getResourceAsStream("/p");
                int pNum = is.read();
                pathes = new Path[pNum];
                for (int i5 = 0; i5 < pNum; ++i5) {
                    Path actpath;
                    len = is.read();
                    Engine.pathes[i5] = actpath = new Path(len);
                    int j = 0;
                    while (j < len) {
                        actpath.x[j] = is.read();
                        actpath.y[j] = is.read();
                        actpath.speed[j] = is.read();
                        int n = j;
                        actpath.speed[n] = actpath.speed[n] + (is.read() << 8);
                        actpath.wait[j] = is.read();
                        int n2 = j++;
                        actpath.wait[n2] = actpath.wait[n2] + (is.read() << 8);
                    }
                    actpath.init();
                }
            }
            fMaxBGSpeed = 5;
            is = this.getClass().getResourceAsStream("/l" + levelNum);
            int bgNum = is.read();
            bgLayers = new Paintable[bgNum];
            for (i2 = 0; i2 < bgNum && (len = is.read()) != -1; ++i2) {
                len += is.read() << 8;
                int speed = is.read();
                if ((speed += is.read() << 8) > fMaxBGSpeed) {
                    fMaxBGSpeed = speed;
                }
                fEnemyBGSpeed = speed;
                int stretch = is.read();
                byte[] bg = new byte[len];
                is.read(bg);
                this.setLayer(i2, stretch, bg, speed);
            }
            maxvscrdelta = 0x100000 / fMaxBGSpeed;
            fMaxEnShift = 16 * ((fEnemyBGSpeed << 8) / fMaxBGSpeed);
            penwidth = pwidth + (fMaxEnShift >> 7);
            fpenwidth = penwidth << 8;
            penmiddle = penwidth >> 1;
            bgshift = maxvscrdelta * fEnemyBGSpeed + 32768 >> 16;
            for (i2 = 0; i2 < bgLayers.length; ++i2) {
                if (!(bgLayers[i2] instanceof JustifiedLayer)) continue;
                ((JustifiedLayer)bgLayers[i2]).postInit();
            }
            bgLayers[bgLayers.length - 1].setTopLayer();
            int enNum = is.read();
            int villamNum = 0;
            enemies = new Enemy[enNum];
            block15: for (i = 0; i < enNum; ++i) {
                int enTypeNum = is.read();
                int bgPos = is.read();
                bgPos += is.read() << 8;
                if (enTypeNum < 64) {
                    EnemyType entype = entypes[enTypeNum];
                    int type = entype.imageNum;
                    int path = is.read();
                    int dx = is.read();
                    int dy = is.read();
                    Engine.enemies[i] = new Enemy(type, bgPos, path, dx, dy, entype);
                    if (type == 19) {
                        Engine.enemies[i].fwait = villamNum++;
                        if (villamNum >= 3) {
                            villamNum -= 3;
                        }
                    }
                    if (enemyImages[type] != null) continue;
                    int j = type;
                    if (type == 20) {
                        j = 23;
                    }
                    if (type == 16) {
                        j = 17;
                    }
                    String image = "/en/e" + j / 10 + j % 10 + ".png";
                    Engine.enemyImages[type] = Image.createImage((String)image);
                    Engine.enHeight[type] = enemyImages[type].getHeight();
                    Engine.enWidth[type] = enemyImages[type].getWidth();
                    if (type == 9 || type == 10) {
                        int n = type;
                        enWidth[n] = enWidth[n] / 5;
                    } else if (type == 19) {
                        Engine.enWidth[type] = this.SCREEN_WIDTH + 32;
                        Engine.enHeight[type] = 24;
                        Engine.enemyImages[18] = Image.createImage((String)"/en/e18.png");
                    } else if (type < 20) {
                        int n = type;
                        enWidth[n] = enWidth[n] >> 1;
                    }
                    Engine.fenHeight[type] = enHeight[type] << 8;
                    Engine.fenWidth[type] = enWidth[type] << 8;
                    continue;
                }
                switch (enTypeNum) {
                    case 64: {
                        byte[] t = new byte[]{(byte)is.read(), (byte)is.read()};
                        Engine.enemies[i] = new Enemy(enTypeNum, bgPos, t);
                        continue block15;
                    }
                    case 66: {
                        byte[] t = new byte[bgNum * 2];
                        for (int l = 0; l < t.length; ++l) {
                            t[l] = (byte)is.read();
                        }
                        Engine.enemies[i] = new Enemy(enTypeNum, bgPos, t);
                        continue block15;
                    }
                    default: {
                        Engine.enemies[i] = new Enemy(enTypeNum, bgPos, null);
                    }
                }
            }
            if (explosionImages == null) {
                explosionImages = new Image[3];
                for (i = 0; i < 3; ++i) {
                    Engine.explosionImages[i] = Image.createImage((String)"/ex0.png");
                }
                explSize = explosionImages[0].getHeight();
                fExplSize = explSize << 8;
            }
            if (particleImages == null) {
                particleImages = new Image[6];
                for (i = 0; i < 6; ++i) {
                    Engine.particleImages[i] = Image.createImage((String)("/part" + i + ".png"));
                }
                shipEngineParticleImage = Image.createImage((String)"/ps.png");
                shipEngineParticleImageFW = Image.createImage((String)"/ps2.png");
                shipEngineParticleImageFW2 = Image.createImage((String)"/ps3.png");
                shipEngineParticleXSize = shipEngineParticleImage.getWidth() >> 1;
                shipEngineParticleYSize = shipEngineParticleImage.getHeight();
                shipEngineParticleXOffset = (shipWidth >> 1) - (shipEngineParticleXSize >> 1);
                shipEngineParticleYOffset = shipHeight - 1 - shipHeight / 24;
            }
            if (bottomHP == null) {
                bottomHP = Image.createImage((String)"/bottom_3_hp.png");
            }
            particlefXPos = new int[64];
            particlefYPos = new int[64];
            particlefTime = new int[64];
            particleSpeed = new int[64];
            particleAngleSin = new int[64];
            particleAngleCos = new int[64];
            particleAnimPos = new int[64];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void disposeLevel() {
        bgLayers = null;
        bgImages = null;
        bgWidth = null;
        bgHeight = null;
        enemies = null;
        enemyImages = new Image[32];
        pathes = null;
        explosionImages = null;
        bottomHP = null;
        entypes = null;
        particleAnimPos = null;
        particleSpeed = null;
        particleAngleCos = null;
        particleAngleSin = null;
        particlefTime = null;
        particlefYPos = null;
        particlefXPos = null;
        particleImages = null;
        shipEngineParticleImage = null;
    }

    private void loadMenu(boolean full) {
        try {
            if (full && this.menuBG == null) {
                this.menuBG = Image.createImage((String)"/m.png");
                this.menuBGAct = Image.createImage((String)"/mact.png");
                this.menuBGActNew = Image.createImage((String)"/mactz.png");
                rightDoorWidth = this.menuBG.getWidth();
                actMenuHeight = this.menuBGAct.getHeight();
            }
            if (this.doorImageLeft == null) {
                this.doorImageLeft = Image.createImage((String)"/door.png");
                leftDoorWidth = this.doorImageLeft.getWidth();
            }
            if (this.doorImageRight == null) {
                this.doorImageRight = Image.createImage((String)"/door2.png");
                leftDoorWidth = this.doorImageLeft.getWidth();
            }
            if (bottomNext == null) {
                bottomNext = Image.createImage((String)"/bottom_3_next.png");
                bottomPrev = Image.createImage((String)"/bottom_1_back.png");
                bottomHelp = Image.createImage((String)"/bottom_3_ask.png");
                button1Width = bottomPrev.getWidth();
                button3Width = bottomNext.getWidth();
                buttonHeight = bottomNext.getHeight();
                buttonRight = bottomNext;
            }
            if (full && this.upgradeBG == null) {
                this.weaponInfoImageNew = this.weaponInfoImage = Image.createImage((String)"/winf.png");
                this.weaponInfoImageNew = Image.createImage((String)"/winfnew.png");
                shopNumberImage = Image.createImage((String)"/wfont.png");
                int actFontStart = 0;
                for (int i = 0; i < 10; ++i) {
                    Engine.shopNumberStart[i] = actFontStart;
                    actFontStart += shopNumberWidth[i];
                }
                shopNumberHeight = shopNumberImage.getHeight();
                weaponInfoHeight = this.weaponInfoImage.getHeight();
            }
            if (chapterBigImages == null) {
                chapterBigImages = new Image[3];
                Engine.chapterBigImages[0] = Image.createImage((String)"/c1.png");
                Engine.chapterBigImages[1] = Image.createImage((String)"/c2.png");
                Engine.chapterBigImages[2] = Image.createImage((String)"/c3.png");
                chapterLabelImages = new Image[2];
                Engine.chapterLabelImages[0] = Image.createImage((String)"/chapter1.png");
                Engine.chapterLabelImages[1] = Image.createImage((String)"/chapter2.png");
                chapterNumImages = new Image[2];
                Engine.chapterNumImages[0] = Image.createImage((String)"/c1font.png");
                Engine.chapterNumImages[1] = Image.createImage((String)"/c1font.png");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void disposeMenu(boolean full) {
        this.menuBGActNew = null;
        this.menuBGAct = null;
        this.menuBG = null;
        if (full) {
            buttonRight = null;
            bottomHelp = null;
            bottomPrev = null;
            bottomNext = null;
            this.doorImageRight = null;
            this.doorImageLeft = null;
        }
        shopNumberImage = null;
        this.weaponInfoImageNew = null;
        this.weaponInfoImage = null;
    }

    public void init() {
        levelStartTime = System.currentTimeMillis();
        this.actFrameStart = 0;
        accMenuTime = 0;
        this.setSound(this.isSoundEnabled);
        this.thread = new Thread(this);
    }

    public void start() {
        if (!isRunning) {
            isRunning = true;
            if (!this.thread.isAlive()) {
                this.thread = new Thread(this);
            }
            this.thread.start();
        }
    }

    private int getMaxLevel() {
        return this.getMaxLevel(this.levels[this.getDifficulty()]);
    }

    private void setMaxLevel(int level, String reason) {
        this.levels[this.getDifficulty()] = (byte)this.getMaxLevel(level);
    }

    private int getMaxLevel(int level) {
        int max = this.getAbsoluteMaxLevel();
        if (level > max) {
            level = max;
        }
        return level;
    }

    private int getAbsoluteMaxLevel() {
        int max = 9;
        if (this.getDifficulty() == 0) {
            max = 4;
        }
        return max;
    }

    private void saveGame(String reason) {
        if (this.isArcade()) {
            return;
        }
        try {
            this.deleteGame("deleteGame before saveGame");
            this.saveLevels("Akatis_story_levels");
            RecordStore actrs = RecordStore.openRecordStore((String)RMS_GAME, (boolean)true);
            byte[] data = this.fAccBGTime > 0 ? new byte[15] : new byte[8];
            data[0] = (byte)this.getDifficulty();
            data[1] = (byte)(this.score >> 8 & 0xFF);
            data[2] = (byte)(this.score & 0xFF);
            data[3] = (byte)this.shipWeaponFront;
            data[4] = (byte)this.shipWeaponBack;
            data[5] = (byte)this.shipWeaponShield;
            data[6] = (byte)this.shipWeaponExtra;
            data[7] = (byte)playerLives;
            if (this.fAccBGTime > 0) {
                data[8] = (byte)(this.fAccBGTime >> 24 & 0xFF);
                data[9] = (byte)(this.fAccBGTime >> 16 & 0xFF);
                data[10] = (byte)(this.fAccBGTime >> 8 & 0xFF);
                data[11] = (byte)(this.fAccBGTime & 0xFF);
                data[12] = (byte)shipHP;
                data[13] = (byte)(this.actScore >> 8 & 0xFF);
                data[14] = (byte)(this.actScore & 0xFF);
            }
            actrs.addRecord(data, 0, data.length);
            actrs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            e.printStackTrace();
        }
    }

    private void deleteGame(String reason) {
        if (this.isArcade()) {
            return;
        }
        try {
            RecordStore.deleteRecordStore((String)RMS_GAME);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (this.loadGamePossible()) {
            this.error("Unable to delete game!", null);
        }
    }

    private boolean loadGamePossible() {
        try {
            RecordStore actrs = RecordStore.openRecordStore((String)RMS_GAME, (boolean)false);
            actrs.closeRecordStore();
        }
        catch (RecordStoreException e) {
            return false;
        }
        return true;
    }

    private void loadGame() {
        this.loadLevels("Akatis_story_levels");
        byte[] data = null;
        try {
            RecordStore actrs = RecordStore.openRecordStore((String)RMS_GAME, (boolean)false);
            data = actrs.getRecord(1);
            actrs.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        if (data != null) {
            this.resetGame("loadGame");
            this.setDifficulty(data[0]);
            this.score = (data[1] << 8) + data[2];
            this.shipWeaponFront = data[3];
            this.shipWeaponBack = data[4];
            this.shipWeaponShield = data[5];
            this.shipWeaponExtra = data[6];
            playerLives = data[7];
            if (data.length > 8) {
                this.fAccBGTime = (data[8] << 24) + (data[9] << 16) + (data[10] << 8) + data[11];
                shipHP = data[12];
                this.actScore = (data[13] << 8) + data[14];
            }
        }
    }

    static final int asubyte(byte v) {
        if (v < 0) {
            return v + 256;
        }
        return v;
    }

    private void resetGame(String reason) {
        this.resetLevel();
        this.levelNums = levelNum;
        levelNum = 0;
        this.shipWeaponFront = 0;
        this.shipWeaponBack = -1;
        this.shipWeaponShield = -1;
        this.shipWeaponExtra = -1;
        playerLives = 15;
        this.score = 0;
    }

    private void resetLevel() {
        tothread = 0;
        for (int i = 0; i < bullets.length; ++i) {
            Engine.bullets[i] = null;
        }
        bulletLast = 0;
        this.fAccBGTime = 0;
        switch (this.getDifficulty()) {
            case 0: {
                maxShipHP = 200;
                break;
            }
            case 1: {
                maxShipHP = 100;
                break;
            }
            case 2: {
                maxShipHP = 50;
            }
        }
        shipHP = maxShipHP;
        this.actScore = 0;
        shouldDrawShip = true;
        prevScore = -1;
        prevPlayerLives = -1;
        this.ehLast = this.ehFirst;
    }

    private void initLevel() {
        if (levelNum == 0 || levelNum == 1 || levelNum == 2 || levelNum == 9) {
            this.stopMidi();
            actMusic = "/ingame.mid";
            this.startMidi("setSound");
        }
        if (levelNum == 3 || levelNum == 4 || levelNum == 5) {
            this.stopMidi();
            actMusic = "/ingame2.mid";
            this.startMidi("setSound");
        }
        if (levelNum == 6 || levelNum == 7 || levelNum == 8) {
            this.stopMidi();
            actMusic = "/ingame3.mid";
            this.startMidi("setSound");
        }
        this.resetLevel();
        this.levelNumHPScore = 200;
        this.loadLevel(levelNum);
        int actbgpos = this.fAccBGTime * fEnemyBGSpeed >> 16;
        for (enBegin = 0; enBegin < enemies.length && actbgpos > Engine.enemies[Engine.enBegin].bgPos; ++enBegin) {
        }
        this.accFrameTime = 0;
        fShipLimitX = penwidth - shipWidth << 8;
        fShipLimitY = pheight - shipHeight << 8;
        fShipX = fShipLimitX >> 1;
        fShipY = fShipLimitY;
        if (this.shipWeaponExtra >= 0) {
            fExtraGunX = fShipX + fShipWidth;
            fExtraGunY = fShipY + fShipHeight - fBulletHeight[15 + this.shipWeaponExtra] - extraGunVerticalTilt[this.shipWeaponExtra];
        }
        shipPrevHP = -1;
        mainEnemy = null;
        meDestroyY = null;
        meDestroyX = null;
        meDestroyTime = null;
        prevMainEnemyHP = -1;
        scrollLevel = true;
        shipBackFired = 0;
        shipFrontFired = 0;
        vscrdelta = 0;
        shipSlideTime = 32;
        shipDestroyTime = -1;
        shipFrostTime = -1;
        for (int i = 0; i < bullets.length; ++i) {
            Engine.bullets[i] = null;
        }
        Engine.initShield(this.shipWeaponShield);
        levelStartTime = System.currentTimeMillis();
        this.actFrameStart = 0;
        messageTime = 1700;
        shipBlinkingTime = 400;
        this.movePlayer(1, 1, 0);
    }

    static final void initShield(int num) {
        int i;
        for (i = 0; i <= num; ++i) {
            if (shieldBulletIndex[i] >= 0 && bullets[shieldBulletIndex[i]] != null) continue;
            int index = 0;
            while (bullets[index] != null) {
                ++index;
            }
            Engine.shieldBulletIndex[i] = index;
            int angle = i * 180;
            if (i != 0 && (angle = Engine.bullets[Engine.shieldBulletIndex[i - 1]].angle + 180) >= 360) {
                angle -= 360;
            }
            Engine.bullets[index] = new Bullet(false, -10000, -10000, angle, 0, 14, 30);
            if (bulletLast >= ++index) continue;
            bulletLast = index;
        }
        for (i = ++num; i < 2; ++i) {
            if (shieldBulletIndex[i] < 0) continue;
            Engine.bullets[Engine.shieldBulletIndex[i]] = null;
            Engine.shieldBulletIndex[i] = -1;
        }
    }

    static final void initStory(int story) {
        actStory = story;
        actStoryPage = 0;
        prevStoryPage = 0;
        lastStoryPage = Integer.MAX_VALUE;
    }

    private void setState(int state) {
        if (state == 2) {
            boolean loadGamePossible = this.loadGamePossible();
            Engine.menu[6] = loadGamePossible ? 6 : -1;
            Engine.menu[12] = !this.isArcade() && this.isRestartable ? 56 : -1;
        } else if (state == 4) {
            boolean bl = this.isRestartable = !this.isArcade();
            if (this.isRestartable) {
                if (this.prevState != 32) {
                    this.restartScore = this.score;
                }
                this.restartShipWeaponFront = this.shipWeaponFront;
                this.restartShipWeaponBack = this.shipWeaponBack;
                this.restartShipWeaponShield = this.shipWeaponShield;
                this.restartShipWeaponExtra = this.shipWeaponExtra;
            }
        }
        this.prevState = this.state;
        this.state = state;
    }

    public void run() {
        long time = 0L;
        while (isRunning) {
            time = System.currentTimeMillis();
            if (this.state == 4 && tothread == 1) {
                this.setState(32);
                tothread = 0;
            }
            if (this.state != 32) {
                this.lastFrameStart = this.actFrameStart;
                this.actFrameStart = (int)(System.currentTimeMillis() - levelStartTime);
                this.lastFrameTime = this.actFrameStart - this.lastFrameStart + 2 >> 2;
                if (this.lastFrameTime == 0) {
                    this.lastFrameStart = this.actFrameStart - 16;
                    this.lastFrameTime = this.actFrameStart - this.lastFrameStart + 2 >> 2;
                }
                if (this.lastFrameTime > 32) {
                    this.lastFrameTime = 32;
                } else if (this.lastFrameTime < 1) {
                    this.lastFrameTime = 1;
                }
                if (scrollLevel) {
                    this.accFrameTime += this.lastFrameTime;
                }
            } else {
                this.lastFrameTime = 1;
            }
            if (this.state == 4 || this.state == 12 || this.state == 3) {
                int unslideTime = this.lastFrameStart;
                int num = this.ehSize();
                for (int i = 0; i < num; ++i) {
                    Event ie = this.ehNext();
                    if (ie == null) {
                        num = this.ehSize();
                        continue;
                    }
                    int length = ie.length;
                    if (unslideTime < this.actFrameStart) {
                        int t = ie.start - unslideTime >> 2;
                        if (t > 0) {
                            this.unslidePlayer(t);
                        }
                        unslideTime = length < 0 ? this.actFrameStart : ie.start + ie.length;
                    }
                    if (length < 0) {
                        length = this.actFrameStart - ie.start;
                        ie.start = this.actFrameStart;
                        this.ehAdd(ie);
                    }
                    length >>= 2;
                    if (shipFrostTime < 0 && shipDestroyTime < 0) {
                        switch (ie.key) {
                            case 1: {
                                this.movePlayer(0, -1, length);
                                break;
                            }
                            case 6: {
                                this.movePlayer(0, 1, length);
                                break;
                            }
                            case 2: {
                                this.movePlayer(-1, 0, length);
                                break;
                            }
                            case 5: {
                                this.movePlayer(1, 0, length);
                                break;
                            }
                            case 8: {
                                if (ie.repeated) break;
                                shipWeaponExtraLeft = !shipWeaponExtraLeft;
                            }
                        }
                    }
                    ie.repeated = true;
                }
                if (unslideTime < this.actFrameStart) {
                    this.unslidePlayer(this.actFrameStart - unslideTime >> 2);
                }
                if (shipFrostTime >= 0) {
                    shipFrostTime -= this.lastFrameTime;
                }
            }
            this.repaint();
            this.serviceRepaints();
            time = 10L - (System.currentTimeMillis() - time);
            if (time < 1L) {
                time = 1L;
            }
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                this.error("Interrupted", e);
            }
        }
        if (this.state == 28) {
            Main.getInstance().exitApp();
        }
    }

    public void stop() {
        isRunning = false;
        topause = 1;
        this.setSound(false);
    }

    private void movePlayer(int x, int y, int elapsedTime) {
        if (x != 0) {
            if ((fShipX += x * 142 * elapsedTime) < 0) {
                this.ehRemove(2);
                fShipX = 0;
            } else if (fShipX > fShipLimitX) {
                this.ehRemove(5);
                fShipX = fShipLimitX;
            }
            vscrdelta = fShipX * ((maxvscrdelta << 16) / fShipLimitX) + 32768 >> 16;
            fenshift = vscrdelta * fEnemyBGSpeed + 127 >> 7;
            enshift = vscrdelta * fEnemyBGSpeed + Short.MAX_VALUE >> 15;
            vscrdelta = (vscrdelta << 1) - maxvscrdelta;
            if ((shipSlideTime += x * elapsedTime) > 64) {
                shipSlideTime = 64;
            }
            if (shipSlideTime < 0) {
                shipSlideTime = 0;
            }
        }
        if (y != 0) {
            if ((fShipY += y * 142 * elapsedTime) < 0) {
                this.ehRemove(1);
                fShipY = 0;
            } else if (fShipY > fShipLimitY) {
                this.ehRemove(6);
                fShipY = fShipLimitY;
            }
        }
    }

    private void resetEvents() {
        this.ehFirst = this.ehLast;
    }

    private void unslidePlayer(int elapsedTime) {
        if (shipSlideTime > 32) {
            if ((shipSlideTime -= elapsedTime) < 32) {
                shipSlideTime = 32;
            }
        } else if ((shipSlideTime += elapsedTime) > 32) {
            shipSlideTime = 32;
        }
    }

    static final void addBullet(boolean enemy, int fx, int fy, int angle, int speed, int imageNum, int damage) {
        while (bullets[nextBulletInd] != null) {
            ++nextBulletInd;
        }
        Engine.bullets[Engine.nextBulletInd] = new Bullet(enemy, fx, fy, angle, speed, imageNum, damage);
    }

    static final void fireTower(boolean enemy, int fx, int fy) {
        int fdy;
        int fdx = fShipX + (fShipWidth >> 1) - fx;
        for (fdy = fShipY + (fShipHeight >> 1) - fy; fdx > 32768 || fdy > 32768; fdx >>= 1, fdy >>= 1) {
        }
        int fd = Stuff.sqrt(fdx * fdx + fdy * fdy);
        if (fd > 0) {
            Engine.addBullet(enemy, fx, fy, -1, 40, 35, 12);
            Engine.bullets[Engine.nextBulletInd].fdy = fdy;
            Engine.bullets[Engine.nextBulletInd].fdx = fdx;
            Engine.bullets[Engine.nextBulletInd].fd = fd;
        }
    }

    private void fireBoss1(boolean enemy, int fx, int fy) {
        int actShotTime = this.actFrameStart - Engine.mainEnemy.lastShot;
        int phase = actShotTime % 20480 >> 2;
        if ((phase >= 0 && phase < 512 || phase >= 1280 && phase < 2048 || phase >= 2560 && phase < 3072 || phase >= 3840 && phase < 4608) && (phase & 0x40) == 64) {
            Engine.addBullet(enemy, fx, fy, 270, 50, 19, 4);
        }
        if (phase >= 2560 && phase < 3072) {
            Engine.addBullet(enemy, fx - fBoss1WingOffsetX, fy - fBoss1WingOffsetY, 225, 72, 37, 3);
        }
        if (phase >= 2560 && phase < 3072) {
            Engine.addBullet(enemy, fx, fy, 225, 72, 37, 3);
        }
        if (phase >= 3072 && phase < 3584) {
            Engine.addBullet(enemy, fx, fy, 315, 72, 36, 3);
        }
        if (phase > 3072 && phase < 3584) {
            Engine.addBullet(enemy, fx + fBoss1WingOffsetX, fy - fBoss1WingOffsetY, 315, 72, 36, 3);
        }
        if (phase >= 2048 && phase < 2560 || phase >= 512 && phase < 1280) {
            if (mainEnemyDualLeft) {
                Engine.addBullet(enemy, fx - fBoss1WingOffsetX, fy - fBoss1WingOffsetY, 270, 60, 18, 3);
            } else {
                Engine.addBullet(enemy, fx + fBoss1WingOffsetX, fy - fBoss1WingOffsetY, 270, 60, 18, 3);
            }
            boolean bl = mainEnemyDualLeft = !mainEnemyDualLeft;
        }
        if (phase >= 3584 && phase < 5120) {
            switch (mainEnemyFront) {
                case 0: {
                    Engine.addBullet(enemy, fx - fBoss1WingOffsetX, fy - fBoss1WingOffsetY, 225, 72, 37, 3);
                    break;
                }
                case 1: {
                    Engine.addBullet(enemy, fx, fy, 225, 72, 37, 3);
                    break;
                }
                case 2: {
                    Engine.addBullet(enemy, fx, fy, 315, 72, 36, 3);
                    break;
                }
                case 3: {
                    Engine.addBullet(enemy, fx + fBoss1WingOffsetX, fy - fBoss1WingOffsetY, 315, 72, 36, 3);
                }
            }
            if (mainEnemyDualLeft) {
                if (mainEnemyFront > 0) {
                    --mainEnemyFront;
                } else {
                    mainEnemyDualLeft = false;
                    mainEnemyFront = 1;
                }
            } else if (mainEnemyFront < 3) {
                ++mainEnemyFront;
            } else {
                mainEnemyDualLeft = true;
                mainEnemyFront = 2;
            }
        }
    }

    private void fireBoss2(boolean enemy, int fx, int fy) {
    }

    private void fireBoss3(boolean enemy, int fx, int fy) {
    }

    private void fireBoss4(boolean enemy, int fx, int fy) {
    }

    private void fireWeapon(boolean enemy, int fx, int fy, int type) {
        nextBulletInd = 0;
        switch (type) {
            case 0: {
                Engine.addBullet(enemy, fx, fy, 90, 96, 0, 10);
                break;
            }
            case 1: {
                if (shipWeaponFrontDualLeft) {
                    Engine.addBullet(enemy, fx - 2560, fy + 768, 90, 96, 0, 10);
                } else {
                    Engine.addBullet(enemy, fx + 2560, fy + 768, 90, 96, 0, 10);
                }
                shipWeaponFrontDualLeft = !shipWeaponFrontDualLeft;
                break;
            }
            case 2: {
                Engine.addBullet(enemy, fx - 1024, fy, 110, 85, 0, 10);
                Engine.addBullet(enemy, fx, fy, 90, 96, 0, 10);
                Engine.addBullet(enemy, fx + 1024, fy, 70, 85, 0, 10);
                break;
            }
            case 3: {
                Engine.addBullet(enemy, fx, fy, 90, 60, 5, 15);
                break;
            }
            case 4: {
                if (shipWeaponFrontDualLeft) {
                    Engine.addBullet(enemy, fx - 2560, fy, 90, 65, 5, 15);
                } else {
                    Engine.addBullet(enemy, fx + 2560, fy, 90, 65, 5, 15);
                }
                shipWeaponFrontDualLeft = !shipWeaponFrontDualLeft;
                break;
            }
            case 5: {
                Engine.addBullet(enemy, fx - 1024, fy, 180, 80, 7, 30);
                Engine.addBullet(enemy, fx, fy, 90, 70, 8, 20);
                Engine.addBullet(enemy, fx + 1024, fy, 0, 80, 6, 20);
                break;
            }
            case 6: {
                Engine.addBullet(enemy, fx, fy, 90, 70, 1, 40);
                break;
            }
            case 7: {
                Engine.addBullet(enemy, fx - 2560, fy, 90, 70, 1, 25);
                Engine.addBullet(enemy, fx + 2560, fy, 90, 70, 1, 25);
                break;
            }
            case 8: {
                Engine.addBullet(enemy, fx - 1024, fy, 135, 45, 3, 30);
                Engine.addBullet(enemy, fx, fy, 90, 55, 4, 25);
                Engine.addBullet(enemy, fx + 1024, fy, 45, 55, 2, 25);
                break;
            }
            case 9: {
                Engine.addBullet(enemy, fx, fy, 90, 85, 9, 30);
                break;
            }
            case 10: {
                Engine.addBullet(enemy, fx, fy, 90, 85, 10, 40);
                break;
            }
            case 11: {
                Engine.addBullet(enemy, fx, fy, 90, 85, 11, 75);
                break;
            }
            case 12: {
                Engine.addBullet(enemy, fx, fy + (shipHeight << 8), 270, 40, 12, 20);
                break;
            }
            case 13: {
                if (shipWeaponBackDualLeft) {
                    Engine.addBullet(enemy, fx, fy + (shipHeight - 3 << 8), 300, 45, 12, 10);
                } else {
                    Engine.addBullet(enemy, fx, fy + (shipHeight - 3 << 8), 240, 45, 12, 10);
                }
                shipWeaponBackDualLeft = !shipWeaponBackDualLeft;
                break;
            }
            case 14: {
                Engine.addBullet(enemy, fx, fy + (shipHeight << 8), 270, 50, 13, 20);
                break;
            }
            case 15: {
                Engine.addBullet(enemy, fx, fy + (shipHeight << 8), 270, 50, 13, 20);
                break;
            }
            case 16: {
                Engine.addBullet(enemy, fx - 768, fy, 225, 60, 20, 2);
                Engine.addBullet(enemy, fx - 256, fy, 255, 60, 18, 2);
                Engine.addBullet(enemy, fx + 256, fy, 285, 60, 18, 2);
                Engine.addBullet(enemy, fx + 768, fy, 315, 60, 23, 2);
                break;
            }
            case 17: {
                Engine.addBullet(enemy, fx, fy, 270, 60, 19, 16);
                break;
            }
            case 18: {
                Engine.addBullet(enemy, fx - 768, fy, 225, 60, 20, 6);
                Engine.addBullet(enemy, fx - 256, fy, 255, 60, 18, 6);
                Engine.addBullet(enemy, fx + 256, fy, 285, 60, 18, 6);
                Engine.addBullet(enemy, fx + 768, fy, 315, 60, 23, 6);
                Engine.addBullet(enemy, fx - 768, fy -= 2048, 135, 50, 21, 6);
                Engine.addBullet(enemy, fx + 768, fy, 45, 50, 22, 6);
                break;
            }
            case 19: {
                Engine.addBullet(enemy, fx - 1280, fy -= 1536, 270, 50, 24, 10);
                Engine.bullets[Engine.nextBulletInd].fPhase = 0;
                Engine.addBullet(enemy, fx + 1280, fy, 270, 50, 24, 10);
                Engine.bullets[Engine.nextBulletInd].fPhase = 23040;
                break;
            }
            case 20: {
                Engine.addBullet(enemy, fx, fy -= 512, 244 + (random.nextInt() & 0x3F), 50, 24, 6);
                break;
            }
            case 21: {
                Engine.addBullet(enemy, fx, fy, 270, 65, 18, 2);
                Engine.addBullet(enemy, fx + 1280, fy -= 1536, 285, 50, 24, 14);
                Engine.addBullet(enemy, fx - 1280, fy, 255, 50, 24, 14);
                break;
            }
            case 22: {
                Engine.addBullet(enemy, fx, fy, 270, 60, 28, 4);
                break;
            }
            case 23: {
                Engine.addBullet(enemy, fx - 1024, fy, 270, 60, 25, 8);
                Engine.addBullet(enemy, fx + 1024, fy, 270, 60, 25, 8);
                break;
            }
            case 24: {
                Engine.addBullet(enemy, fx - 768, fy, 240, 50, 28, 4);
                Engine.addBullet(enemy, fx, fy, 270, 30, 28, 4);
                Engine.addBullet(enemy, fx + 768, fy, 300, 50, 28, 4);
                Engine.addBullet(enemy, fx, fy, 180, 30, 26, 12);
                Engine.addBullet(enemy, fx, fy, 0, 30, 27, 12);
                break;
            }
            case 25: {
                Engine.addBullet(enemy, fx, fy, 270, 50, 29, 130);
                break;
            }
            case 26: {
                Engine.addBullet(enemy, fx, fy, 270, 50, 31, 200);
                break;
            }
            case 27: {
                Engine.addBullet(enemy, fx, fy, 270, 30, 30, 128);
                Engine.addBullet(enemy, fx - 768, fy, 225, 80, 32, 64);
                Engine.addBullet(enemy, fx + 768, fy, 315, 80, 33, 64);
                break;
            }
            case 28: {
                Engine.fireTower(enemy, fx, fy);
                break;
            }
            case 29: {
                this.fireBoss1(enemy, fx, fy);
                break;
            }
            case 30: {
                this.fireBoss2(enemy, fx, fy);
                break;
            }
            case 31: {
                this.fireBoss3(enemy, fx, fy);
                break;
            }
            case 32: {
                Engine.addBullet(enemy, fx - 256, fy, 270, 40, 18, 2);
                break;
            }
            case 33: {
                Engine.addBullet(enemy, fx - 1536, fy, 270, 60, 18, 2);
                Engine.addBullet(enemy, fx + 1536, fy, 270, 60, 18, 2);
                break;
            }
            case 34: {
                Engine.addBullet(enemy, fx, fy, 270, 60, 25, 8);
                break;
            }
            case 35: {
                this.fireBoss4(enemy, fx, fy);
            }
        }
        if (bulletLast < ++nextBulletInd) {
            bulletLast = nextBulletInd;
        }
    }

    private void setContinue(boolean isContinue) {
        this.isContunue = isContinue;
    }

    private boolean isContinue() {
        return this.isContunue;
    }

    private void setArcade(boolean isArcade) {
        if (this.isArcade == isArcade) {
            return;
        }
        this.isArcade = isArcade;
        if (isArcade) {
            this.savedWeaponFront = this.shipWeaponFront;
            this.savedWeaponBack = this.shipWeaponBack;
            this.savedWeaponShield = this.shipWeaponShield;
            this.savedWeaponExtra = this.shipWeaponExtra;
            this.savedScore = this.score;
            this.shipWeaponFront = 0;
            this.shipWeaponBack = -1;
            this.shipWeaponShield = -1;
            this.shipWeaponExtra = -1;
            this.score = 0;
            Engine.menu[24] = 9;
            this.loadLevels("Akatis_arcade_levels");
        } else {
            this.shipWeaponFront = this.savedWeaponFront;
            this.shipWeaponBack = this.savedWeaponBack;
            this.shipWeaponShield = this.savedWeaponShield;
            this.shipWeaponExtra = this.savedWeaponExtra;
            this.score = this.savedScore;
            Engine.menu[24] = 8;
        }
    }

    private boolean isArcade() {
        return this.isArcade;
    }

    private void moveMenu(int key) {
        block0 : switch (key) {
            case 6: {
                ++this.menuSelect;
                if (this.menuSelect >= 5) {
                    this.menuSelect -= 5;
                }
                while (menu[this.menuSelect + this.menuIndex] < 0) {
                    ++this.menuSelect;
                    if (this.menuSelect < 5) continue;
                    this.menuSelect -= 5;
                }
                break;
            }
            case 1: {
                --this.menuSelect;
                if (this.menuSelect < 0) {
                    this.menuSelect += 5;
                }
                while (menu[this.menuSelect + this.menuIndex] < 0) {
                    --this.menuSelect;
                    if (this.menuSelect >= 0) continue;
                    this.menuSelect += 5;
                }
                break;
            }
            case -6: {
                if (language) break;
                for (int i = 0; i < 5; ++i) {
                    if (menuJump[i + this.menuIndex] < 0 || menuJump[i + this.menuIndex] >= this.menuIndex) continue;
                    this.menuSelect = menuParent >= 0 ? menuParent % 5 : 0;
                    if (i + this.menuIndex == 24 && !this.isArcade()) {
                        this.setState(10);
                    } else if (i + this.menuIndex == 24 && this.isArcade()) {
                        this.isArcade = false;
                        Engine.menu[24] = 8;
                        this.setState(10);
                        this.setMenu(5, "arcboljatekmenube");
                        break block0;
                    }
                    if (i + this.menuIndex == 29) {
                        this.setState(15);
                    }
                    if (this.menuIndex == 35) {
                        i = 3;
                    }
                    menuParent = -1;
                    this.setMenu(menuJump[i + this.menuIndex], "hack");
                    break block0;
                }
                break;
            }
            case -7: {
                if (menuHelp[this.menuSelect + this.menuIndex] >= 0) {
                    Engine.initStory(34 + menuHelp[this.menuSelect + this.menuIndex]);
                    this.setState(37);
                    break;
                }
            }
            case 8: {
                int index = this.menuSelect + this.menuIndex;
                switch (index) {
                    case 2: {
                        Engine.initStory(8);
                        this.setState(37);
                        break;
                    }
                    case 3: {
                        Engine.initStory(7);
                        this.setState(37);
                        break;
                    }
                    case 4: {
                        this.setState(28);
                        break;
                    }
                    case 5: {
                        if (menu[6] > 0) {
                            this.setState(36);
                            break;
                        }
                        this.setState(105);
                        this.nextState = 104;
                        break;
                    }
                    case 6: {
                        this.setArcade(false);
                        this.setContinue(true);
                        this.loadGame();
                        break;
                    }
                    case 7: {
                        this.resetGame("arcade");
                        this.setArcade(true);
                        this.setContinue(false);
                        this.selectedChapter = 0;
                        chapterBigImageX = 0;
                        accMenuTime = 0;
                        break;
                    }
                    case 8: {
                        this.setState(38);
                        break;
                    }
                    case 10: {
                        if (!this.isArcade()) {
                            this.setContinue(true);
                        }
                        this.setState(33);
                        this.selectedChapter = this.getMaxLevel();
                        chapterBigImageX = 0;
                        accMenuTime = 0;
                        break;
                    }
                    case 11: {
                        this.startUpgrade();
                        break;
                    }
                    case 12: {
                        this.setState(102);
                        break;
                    }
                    case 20: {
                        if (language) {
                            this.lang("/intla");
                            break;
                        }
                    }
                    case 21: {
                        if (language) {
                            this.lang("/intln");
                            break;
                        }
                    }
                    case 22: {
                        if (language) {
                            this.lang("/intlo");
                            break;
                        }
                    }
                    case 23: {
                        if (language) {
                            this.lang("/intlf");
                            break;
                        }
                        this.shopWeaponFront = this.shipWeaponFront;
                        this.shopWeaponBack = this.shipWeaponBack;
                        this.shopWeaponShield = this.shipWeaponShield;
                        this.shopWeaponExtra = this.shipWeaponExtra;
                        this.setState(14);
                        break;
                    }
                    case 24: {
                        if (language) {
                            this.lang("/intls");
                            break;
                        }
                        this.setState(10);
                        break;
                    }
                    case 29: {
                        this.shopWeaponFront = this.shipWeaponFront;
                        this.shopWeaponBack = this.shipWeaponBack;
                        this.shopWeaponShield = this.shipWeaponShield;
                        this.shopWeaponExtra = this.shipWeaponExtra;
                        Engine.initShield(this.shopWeaponShield);
                        this.setState(15);
                        break;
                    }
                    case 27: {
                        switch (menuParent) {
                            case 20: {
                                int newWeapon;
                                if (this.shopWeaponFront >= 0 && this.score >= weaponPrice[this.shopWeaponFront] || this.shipWeaponFront >= 0 && this.score + weaponPrice[this.shipWeaponFront] >= weaponPrice[this.shopWeaponFront]) {
                                    this.score -= weaponPrice[this.shopWeaponFront];
                                    newWeapon = this.shopWeaponFront;
                                    if (this.shipWeaponFront >= 0) {
                                        this.sellWeapon(menuParent);
                                    }
                                    this.shipWeaponFront = this.shopWeaponFront = newWeapon;
                                    break;
                                }
                                this.setState(16);
                                break;
                            }
                            case 21: {
                                int newWeapon;
                                if (this.shopWeaponBack >= 0 && this.score >= weaponPrice[this.shopWeaponBack] || this.shipWeaponBack >= 0 && this.score + weaponPrice[this.shipWeaponBack] >= weaponPrice[this.shopWeaponBack]) {
                                    this.score -= weaponPrice[this.shopWeaponBack];
                                    newWeapon = this.shopWeaponBack;
                                    if (this.shipWeaponBack >= 0) {
                                        this.sellWeapon(menuParent);
                                    }
                                    this.shipWeaponBack = this.shopWeaponBack = newWeapon;
                                    break;
                                }
                                this.setState(16);
                                break;
                            }
                            case 22: {
                                int newWeapon;
                                if (this.shopWeaponShield >= 0 && this.score >= weaponPrice[this.shopWeaponShield + 16] || this.shipWeaponShield >= 0 && this.score + weaponPrice[this.shipWeaponShield + 16] >= weaponPrice[this.shopWeaponShield + 16]) {
                                    this.score -= weaponPrice[this.shopWeaponShield + 16];
                                    newWeapon = this.shopWeaponShield;
                                    if (this.shipWeaponShield >= 0) {
                                        this.sellWeapon(menuParent);
                                    }
                                    this.shipWeaponShield = this.shopWeaponShield = newWeapon;
                                    Engine.initShield(this.shopWeaponShield);
                                    break;
                                }
                                this.setState(16);
                                break;
                            }
                            case 23: {
                                int newWeapon;
                                if (this.shopWeaponExtra >= 0 && this.score >= weaponPrice[this.shopWeaponExtra + 18] || this.shipWeaponExtra >= 0 && this.score + weaponPrice[this.shipWeaponExtra + 18] >= weaponPrice[this.shopWeaponExtra + 18]) {
                                    this.score -= weaponPrice[this.shopWeaponExtra + 18];
                                    newWeapon = this.shopWeaponExtra;
                                    if (this.shipWeaponExtra >= 0) {
                                        this.sellWeapon(menuParent);
                                    }
                                    this.shipWeaponExtra = this.shopWeaponExtra = newWeapon;
                                    break;
                                }
                                this.setState(16);
                            }
                        }
                        break;
                    }
                    case 28: {
                        this.sellWeapon(menuParent);
                        break;
                    }
                    case 25: {
                        switch (menuParent) {
                            case 20: {
                                this.shopWeaponFront = this.getNextWeapon(0, this.shopWeaponFront, 1);
                                if (this.shopWeaponFront == this.shipWeaponFront) {
                                    Engine.menu[27] = -1;
                                    break;
                                }
                                Engine.menu[27] = 23;
                                break;
                            }
                            case 21: {
                                this.shopWeaponBack = this.getNextWeapon(1, this.shopWeaponBack, 1);
                                if (this.shopWeaponBack == this.shipWeaponBack) {
                                    Engine.menu[27] = -1;
                                    break;
                                }
                                Engine.menu[27] = 23;
                                break;
                            }
                            case 22: {
                                this.shopWeaponShield = this.getNextWeapon(2, this.shopWeaponShield, 1);
                                Engine.menu[27] = this.shopWeaponShield == this.shipWeaponShield ? -1 : 23;
                                Engine.initShield(this.shopWeaponShield);
                                break;
                            }
                            case 23: {
                                this.shopWeaponExtra = this.getNextWeapon(3, this.shopWeaponExtra, 1);
                                Engine.menu[27] = this.shopWeaponExtra == this.shipWeaponExtra ? -1 : 23;
                            }
                        }
                        break;
                    }
                    case 26: {
                        switch (menuParent) {
                            case 20: {
                                this.shopWeaponFront = this.getNextWeapon(0, this.shopWeaponFront, -1);
                                if (this.shopWeaponFront == this.shipWeaponFront) {
                                    Engine.menu[27] = -1;
                                    break;
                                }
                                Engine.menu[27] = 23;
                                break;
                            }
                            case 21: {
                                this.shopWeaponBack = this.getNextWeapon(1, this.shopWeaponBack, -1);
                                if (this.shopWeaponBack == this.shipWeaponBack) {
                                    Engine.menu[27] = -1;
                                    break;
                                }
                                Engine.menu[27] = 23;
                                break;
                            }
                            case 22: {
                                this.shopWeaponShield = this.getNextWeapon(2, this.shopWeaponShield, -1);
                                Engine.menu[27] = this.shopWeaponShield == this.shipWeaponShield ? -1 : 23;
                                Engine.initShield(this.shopWeaponShield);
                                break;
                            }
                            case 23: {
                                this.shopWeaponExtra = this.getNextWeapon(3, this.shopWeaponExtra, -1);
                                Engine.menu[27] = this.shopWeaponExtra == this.shipWeaponExtra ? -1 : 23;
                            }
                        }
                        break;
                    }
                    case 30: {
                        this.setSound(!this.isSoundEnabled);
                        break;
                    }
                    case 35: {
                        this.setDifficulty(0);
                        if (!this.isArcade()) break;
                        this.setState(33);
                        break;
                    }
                    case 36: {
                        this.setDifficulty(1);
                        if (!this.isArcade()) break;
                        this.setState(33);
                        break;
                    }
                    case 37: {
                        this.setDifficulty(2);
                        if (!this.isArcade()) break;
                        this.setState(33);
                    }
                }
                int parent = this.menuSelect + this.menuIndex;
                int jump = menuJump[parent];
                if (jump < 0) break;
                menuParent = parent;
                this.setMenu(jump, "jump");
            }
        }
    }

    private void setDifficulty(int difficulty) {
        this.difficulty = difficulty;
    }

    private int getDifficulty() {
        return this.difficulty;
    }

    public String getDifficulty(int difficulty) {
        switch (difficulty) {
            case 0: {
                return this.messages[53];
            }
            case 1: {
                return this.messages[54];
            }
            case 2: {
                return this.messages[55];
            }
        }
        return "?";
    }

    private void saveLevels(String key) {
        RMS.getInstance().set(key, this.levels);
        if (key.equals("Akatis_story_levels")) {
            byte[] arcade = RMS.getInstance().get("Akatis_arcade_levels");
            if (arcade == null) {
                arcade = this.levels;
            } else {
                for (int i = 0; i < this.levels.length; ++i) {
                    if (this.levels[i] <= arcade[i]) continue;
                    arcade[i] = this.levels[i];
                }
            }
            RMS.getInstance().set("Akatis_arcade_levels", arcade);
        }
    }

    private void loadLevels(String key) {
        this.levels = RMS.getInstance().get(key);
        if (this.levels == null) {
            this.levels = new byte[]{0, 0, 0};
        }
    }

    private void startUpgrade() {
        this.shopWeaponFront = this.shipWeaponFront;
        this.shopWeaponBack = this.shipWeaponBack;
        this.shopWeaponShield = this.shipWeaponShield;
        this.shopWeaponExtra = this.shipWeaponExtra;
        Engine.initShield(this.shopWeaponShield);
        if (this.isArcade()) {
            this.score = this.getScore();
        }
        Engine.menu[27] = -1;
        this.setState(9);
    }

    private void setMenu(int menuIndex, String reason) {
        this.menuIndex = menuIndex;
        this.menuSelect = 0;
    }

    private int getScore() {
        int level = levelNum;
        if (level >= MAX_SCORES.length) {
            level = MAX_SCORES.length - 1;
        }
        return MAX_SCORES[level];
    }

    private int getNextWeapon(int type, int weapon, int direction) {
        int available = this.getMaxAvailableWeapon(type);
        if (available == -1) {
            return -1;
        }
        int index = this.getIndex(WEAPONS[type], weapon) + direction;
        if (index > available) {
            index = 0;
        } else if (index < 0) {
            index = available;
        }
        int next = WEAPONS[type][index];
        return next;
    }

    private int getIndex(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != value) continue;
            return i;
        }
        this.warning("getIndex(): NOT FOUND!");
        return -1;
    }

    private int getMaxAvailableWeapon(int type) {
        int level = this.getMaxLevel();
        if (this.isArcade()) {
            level = levelNum;
        }
        if (level >= AVAILABLE_WEAPONS[type].length) {
            level = AVAILABLE_WEAPONS[type].length - 1;
        }
        int weapon = AVAILABLE_WEAPONS[type][level];
        return weapon;
    }

    private boolean isNewWeapon(int type, int weapon) {
        int[][] weapons = WEAPONS_NEW[type];
        int level = this.getMaxLevel();
        if (this.isArcade()) {
            level = levelNum;
        }
        if (level >= weapons.length) {
            return false;
        }
        return this.isContains(weapons[level], weapon);
    }

    private boolean isContains(int[] array, int item) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != item) continue;
            return true;
        }
        return false;
    }

    private void sellWeapon(int menuParent) {
        switch (menuParent) {
            case 20: {
                if (this.shipWeaponFront < 0) break;
                this.score += weaponPrice[this.shipWeaponFront];
                this.shopWeaponFront = -1;
                this.shipWeaponFront = -1;
                break;
            }
            case 21: {
                if (this.shipWeaponBack < 0) break;
                this.score += weaponPrice[this.shipWeaponBack];
                this.shopWeaponBack = -1;
                this.shipWeaponBack = -1;
                break;
            }
            case 22: {
                if (this.shipWeaponShield < 0) break;
                this.score += weaponPrice[16 + this.shipWeaponShield];
                this.shopWeaponShield = -1;
                this.shipWeaponShield = -1;
                Engine.initShield(this.shopWeaponShield);
                break;
            }
            case 23: {
                if (this.shipWeaponExtra < 0) break;
                this.score += weaponPrice[18 + this.shipWeaponExtra];
                this.shopWeaponExtra = -1;
                this.shipWeaponExtra = -1;
            }
        }
    }

    private void lang(String langmenu) {
        ngage = true;
        this.setMenu(0, "arcboljatekmenube");
        InputStream is = this.getClass().getResourceAsStream(langmenu);
        this.messages = Streaming.readLines(is, true);
        for (int i = 0; i < this.messages.length; ++i) {
            language = false;
        }
        this.menuSelect = 30;
        this.menuIndex = 0;
        ngage = false;
        this.setState(2);
    }

    private void paintMenu(Graphics g) {
        this.animateTopBorder(g, 256);
        int se = 0;
        if (this.menuIndex > 0) {
            se = this.menuIndex / 5;
        }
        this.animateMenuk(g, 256, 1);
        this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[se + 58]);
        if (this.messages[62] == "") {
            this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[this.menuSelect]);
        }
        this.animateLeftDoor(g, 256);
        buttonRight = menuHelp[this.menuSelect + this.menuIndex] >= 0 ? bottomHelp : bottomNext;
        this.animateBottomMenuIcons(g, 256, bottomPrev, buttonRight);
        Engine.menu[10] = this.score > 0 ? 70 : 9;
        int menuStartX = this.SCREEN_WIDTH - rightDoorWidth;
        int menuPointHeight = actMenuHeight / 5;
        int menuStartY = topHeight + menuPointYOffset;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(this.menuBG, menuStartX, topHeight, 20);
        g.setClip(menuStartX, menuStartY + menuPointHeight * this.menuSelect, rightDoorWidth, menuPointHeight);
        g.drawImage(this.menuBGAct, menuStartX, menuStartY, 20);
        if (this.prevState == 36 || this.prevState == 102 || this.prevState == 104) {
            this.prevState = -1;
            this.animateLeftDoor(g, 256);
        }
        for (int i = 0; i < 5; ++i) {
            int mess = menu[this.menuIndex + i];
            if (mess < 0) continue;
            if (i != this.menuSelect) {
                int type = -1;
                switch (mess) {
                    case 17: {
                        type = 0;
                        break;
                    }
                    case 18: {
                        type = 1;
                        break;
                    }
                    case 19: {
                        type = 2;
                        break;
                    }
                    case 20: {
                        type = 3;
                    }
                }
                if (type != -1) {
                    int level = this.getMaxLevel();
                    if (this.isArcade()) {
                        level = levelNum;
                    }
                    if (level < WEAPONS_NEW[type].length && WEAPONS_NEW[type][level].length > 0) {
                        g.setClip(menuStartX, menuStartY + menuPointHeight * i, rightDoorWidth, menuPointHeight);
                        g.drawImage(this.menuBGActNew, menuStartX, menuStartY, 20);
                    }
                }
            }
            this.writeStringCentered(g, menuStartX + this.SCREEN_WIDTH >> 1, menuStartY + (menuPointHeight - fontHeight >> 1) + i * menuPointHeight, this.messages[mess]);
        }
        this.animateBottomDisplay(g, 256);
        this.animateBottomMenuIcons(g, 256, bottomPrev, buttonRight);
    }

    private void paintUpgrade(Graphics g) {
        Bullet b;
        int i;
        g.setColor(0);
        g.fillRect(0, topHeight, leftDoorWidth, this.doorImageLeft.getHeight());
        int topLimit = topHeight;
        if (topScorePos == top1Height) {
            this.animateMenuk(g, 256, 1);
            this.animateTopScore(g, 256);
            Engine.writeNumRight(g, (this.SCREEN_WIDTH >> 1) + (menukWidth >> 1) - 10, fontHeight / 2 + 2, this.score);
            topLimit = Math.max(topHeight, top1Height);
        }
        int areaBottom = pbottom - weaponInfoPos;
        if (weaponInfoPos > 0) {
            g.setClip(0, ptop, this.SCREEN_WIDTH, pheight);
            Image infoImage = this.weaponInfoImage;
            switch (menuParent) {
                case 20: {
                    if (!this.isNewWeapon(0, this.shopWeaponFront)) break;
                    infoImage = this.weaponInfoImageNew;
                    break;
                }
                case 21: {
                    if (!this.isNewWeapon(1, this.shopWeaponBack)) break;
                    infoImage = this.weaponInfoImageNew;
                    break;
                }
                case 22: {
                    if (!this.isNewWeapon(2, this.shopWeaponShield)) break;
                    infoImage = this.weaponInfoImageNew;
                    break;
                }
                case 23: {
                    if (!this.isNewWeapon(3, this.shopWeaponExtra)) break;
                    infoImage = this.weaponInfoImageNew;
                }
            }
            g.drawImage(infoImage, 0, areaBottom, 20);
            if (weaponInfoPos == weaponInfoHeight) {
                switch (menuParent) {
                    case 20: {
                        if (this.shopWeaponFront >= 0) {
                            this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[30 + this.shopWeaponFront / 3]);
                            Engine.writeShop(g, leftDoorWidth, areaBottom + weaponInfo2YOffset, weaponPrice[this.shopWeaponFront]);
                            Engine.writeShop(g, leftDoorWidth + 13, areaBottom + weaponInfo3YOffset, this.shopWeaponFront % 3 + 1);
                            break;
                        }
                        this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[29]);
                        break;
                    }
                    case 21: {
                        if (this.shopWeaponBack >= 12) {
                            this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[34 + (this.shopWeaponBack - 12 >> 1)]);
                            Engine.writeShop(g, leftDoorWidth, areaBottom + weaponInfo2YOffset, weaponPrice[this.shopWeaponBack]);
                            Engine.writeShop(g, leftDoorWidth + 13, areaBottom + weaponInfo3YOffset, (this.shopWeaponBack & 1) + 1);
                            break;
                        }
                        this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[29]);
                        break;
                    }
                    case 22: {
                        if (this.shopWeaponShield >= 0) {
                            this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[36]);
                            Engine.writeShop(g, leftDoorWidth, areaBottom + weaponInfo2YOffset, weaponPrice[this.shopWeaponShield + 16]);
                            Engine.writeShop(g, leftDoorWidth + 13, areaBottom + weaponInfo3YOffset, this.shopWeaponShield + 1);
                            break;
                        }
                        this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[29]);
                        break;
                    }
                    case 23: {
                        if (this.shopWeaponExtra >= 0) {
                            this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[37]);
                            Engine.writeShop(g, leftDoorWidth, areaBottom + weaponInfo2YOffset, weaponPrice[this.shopWeaponExtra + 18]);
                            Engine.writeShop(g, leftDoorWidth + 13, areaBottom + weaponInfo3YOffset, this.shopWeaponExtra + 1);
                            break;
                        }
                        this.writeStringLeft(g, storyMargin >> 1, areaBottom + weaponInfo1YOffset, this.messages[29]);
                    }
                }
            }
        }
        int fShipX = leftDoorWidth / 2 - shipWidth / 2 << 8;
        int fShipY = (topHeight << 8) + (areaBottom - topHeight << 7);
        int fShipMiddleX = fShipX + (fShipWidth >> 1);
        int fShipMiddleY = fShipY + (fShipHeight >> 1);
        if (this.shopWeaponShield >= 0) {
            int ad = this.lastFrameTime * 90 + 128 >> 8;
            for (i = 0; i <= this.shopWeaponShield; ++i) {
                b = bullets[shieldBulletIndex[i]];
                b.angle += ad;
                while (b.angle >= 360) {
                    b.angle -= 360;
                }
                b.fxAct = fShipMiddleX + (Stuff.cos(b.angle) * fShipWidth >> 16) - (fBulletWidth[14] >> 1);
                b.fyAct = fShipMiddleY + (Stuff.sin(b.angle) * fShipHeight >> 16) - (fBulletHeight[14] >> 1);
            }
        }
        int actLastBullet = 0;
        for (i = 0; i < bulletLast; ++i) {
            b = bullets[i];
            if (b == null) continue;
            b.move(this.lastFrameTime);
            int actX = b.fxAct >> 8;
            int actY = b.fyAct >> 8;
            int type = b.type;
            if (actX + bulletWidth[type] <= 0 || actX >= leftDoorWidth || actY + bulletHeight[type] <= topLimit || actY >= areaBottom) {
                if (b.type == 14) continue;
                Engine.bullets[i] = null;
                continue;
            }
            g.setClip(actX, actY, bulletWidth[type], bulletHeight[type]);
            g.clipRect(0, topLimit, leftDoorWidth, areaBottom - topLimit);
            g.drawImage(bulletImages[type], actX - b.actFrame * bulletWidth[type], actY, 20);
            actLastBullet = i;
        }
        bulletLast = actLastBullet + 1;
        if (this.shopWeaponFront >= 0 && this.shopWeaponFront < 12) {
            shipFrontFired += this.lastFrameTime;
            while (shipFrontFired > this.weaponRate[this.shopWeaponFront]) {
                shipFrontFired -= this.weaponRate[this.shopWeaponFront];
                this.fireWeapon(false, fShipMiddleX, fShipY, this.shopWeaponFront);
            }
        }
        if (this.shopWeaponBack >= 12 && this.shopWeaponBack < 16) {
            shipBackFired += this.lastFrameTime;
            while (shipBackFired > this.weaponRate[this.shopWeaponBack]) {
                shipBackFired -= this.weaponRate[this.shopWeaponBack];
                this.fireWeapon(false, fShipMiddleX, fShipY - 1024, this.shopWeaponBack);
            }
        }
        if (this.shopWeaponExtra >= 0) {
            int actBullet = 15 + this.shopWeaponExtra;
            int actWeapon = this.shopWeaponExtra * 3;
            fExtraGunX = fShipX + fShipWidth;
            fExtraGunY = fShipY + fShipHeight - fBulletHeight[actBullet] - extraGunVerticalTilt[this.shopWeaponExtra];
            g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
            g.drawImage(bulletImages[actBullet], fExtraGunX >> 8, fExtraGunY >> 8, 20);
            shipExtraFired += this.lastFrameTime;
            while (shipExtraFired > this.weaponRate[actWeapon]) {
                shipExtraFired -= this.weaponRate[actWeapon];
                this.fireWeapon(false, fExtraGunX + (fBulletWidth[actBullet] >> 1), fExtraGunY, actWeapon);
            }
        }
        int actShipX = fShipX >> 8;
        int actShipY = fShipY >> 8;
        g.setClip(actShipX, actShipY, shipWidth, shipHeight);
        g.drawImage(shipImage, actShipX - shipWidth, actShipY, 20);
    }

    private void paintHighScore(Graphics g, int accMenuTime) {
        gameend = false;
        g.setClip(0, ptop, this.SCREEN_WIDTH, pbottom);
        this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, ptop + storyMargin, this.messages[38]);
        int scoresBegin = ptop + storyMargin + (fontHeight + storyMargin << 1);
        int size = HighScores.getInsctance().getSize();
        if (this.SCREEN_HEIGHT != 160) {
            size = this.SCREEN_HEIGHT == 140 ? --size : --size;
        }
        for (int i = 0; i < size; ++i) {
            HighScoreItem item = HighScores.getInsctance().get(i);
            if (this.highScorePossible && item.getPoints() < this.score) {
                this.highScorePossible = false;
                editingHighScore = i;
                editingHighScorePos = 0;
                item = new HighScoreItem();
                HighScores.getInsctance().put(item, i);
                size = HighScores.getInsctance().getSize();
                if (this.SCREEN_HEIGHT != 160) {
                    size = this.SCREEN_HEIGHT == 140 ? --size : --size;
                }
                item.setPoints(this.score);
                item.setDifficulty(this.getDifficulty());
                editingName = "a       ".toCharArray();
                this.resetGame("paintHighScore");
            }
            if (editingHighScore == i) {
                String actName = new String(editingName);
                if ((accMenuTime & 0x40) > 0) {
                    int xPos = this.getStringWidth(actName.substring(0, editingHighScorePos + 1));
                    this.writeStringLeft(g, storyMargin, scoresBegin, actName.substring(0, editingHighScorePos));
                    this.writeStringLeft(g, storyMargin + xPos, scoresBegin, actName.substring(editingHighScorePos + 1));
                } else {
                    this.writeStringLeft(g, storyMargin, scoresBegin, actName);
                }
            } else {
                this.writeStringLeft(g, storyMargin, scoresBegin, item.getName());
            }
            this.writeStringCentered(g, this.SCREEN_WIDTH / 2, scoresBegin, this.getDifficulty(item.getDifficulty()));
            this.writeStringRight(g, this.SCREEN_WIDTH - storyMargin, scoresBegin, Integer.toString(item.getPoints()));
            scoresBegin += fontHeight + (storyMargin >> 1);
        }
        if (this.highScorePossible) {
            this.resetGame("highScorePossible");
            this.highScorePossible = false;
        }
    }

    private void paintStoryPage(Graphics g, int xshift, int page) {
        String s = this.messages[43 + actStory];
        int lastIndex = s.length();
        int xPos = storyMargin + xshift;
        int yPos = ptop + storyMargin;
        int indstart = storyPageIndex[page];
        int indend = this.getNextLine(s, indstart, storyWidth);
        while (true) {
            String actline = s.substring(indstart, indend).trim();
            this.writeStringLeft(g, xPos, yPos, actline);
            if (indend >= lastIndex) {
                lastStoryPage = Math.max(actStoryPage, prevStoryPage);
                break;
            }
            if ((yPos += fontHeight + storyMargin) > pbottom - storyMargin - fontHeight) {
                Engine.storyPageIndex[Engine.actStoryPage + 1] = indend + 1;
                break;
            }
            indstart = indend;
            indend = this.getNextLine(s, indstart + 1, storyWidth);
        }
    }

    private void paintStory(Graphics g, int accMenuTime) {
        g.setClip(0, ptop, this.SCREEN_WIDTH, pheight);
        this.paintStoryPage(g, 0, actStoryPage);
    }

    private void animateMenuk(Graphics g, int accMenuTime, int down) {
        menukPos = down == 1 ? accMenuTime * menukHeight << 3 >> 2 : 8448 - accMenuTime * menukHeight;
        if (menukPos > 8300) {
            menukPos = 8448;
        }
        g.drawImage(menuk, (this.SCREEN_WIDTH >> 1) - (menukWidth >> 1), (menukPos >> 8) - menukHeight, 20);
    }

    private void animateTopBorder(Graphics g, int accMenuTime) {
        topBorderPos = accMenuTime * topHeight;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(topBorder, 0, (topBorderPos + 128 >> 8) - topHeight, 20);
    }

    private void animateRightDoor(Graphics g, int doorTime) {
        rightDoorPos = doorTime * doorTime * rightDoorWidth >> 8;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(this.doorImageRight, this.SCREEN_WIDTH - (rightDoorPos + 128 >> 8), topHeight, 20);
        if (this.prevState != 1) {
            this.animateBottomMenuIcons(g, 256, bottomPrev, bottomNext);
        }
    }

    private void animateLeftDoor(Graphics g, int doorTime) {
        leftDoorPos = doorTime * doorTime * leftDoorWidth >> 8;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(this.doorImageLeft, (leftDoorPos + 128 >> 8) - leftDoorWidth, topHeight, 20);
    }

    private void animateMenuAsDoor(Graphics g, int doorTime) {
        rightDoorPos = doorTime * doorTime * rightDoorWidth >> 8;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(this.menuBG, this.SCREEN_WIDTH - (rightDoorPos + 128 >> 8), topHeight, 20);
    }

    private void animateTopLives(Graphics g, int topTime) {
        topLivesPos = topTime * top1Height + 128 >> 8;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(topLives, this.SCREEN_WIDTH - top3Width, topLivesPos - top1Height, 20);
    }

    private void animateTopScore(Graphics g, int topTime) {
        topScorePos = topTime * top1Height + 128 >> 8;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        if (this.state != 15 && this.state != 11 && this.state != 14 && this.state != 16) {
            g.drawImage(topScore, 0, topScorePos - top1Height, 20);
        }
    }

    private void animateBottomDisplay(Graphics g, int accMenuTime) {
        bottomBorderPos = accMenuTime * bottomHeight;
        bottomLeftDisplayPos = accMenuTime * bottom1Width;
        bottomRightDisplayPos = accMenuTime * bottom3Width;
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        g.drawImage(this.bottomBorder, bottom1Width, this.SCREEN_HEIGHT - (bottomBorderPos + 128 >> 8), 20);
        g.drawImage(this.bottomLeftDisplay, (bottomLeftDisplayPos + 128 >> 8) - bottom1Width, this.SCREEN_HEIGHT - bottomHeight, 20);
        g.drawImage(this.bottomRightDisplay, this.SCREEN_WIDTH - (bottomRightDisplayPos + 128 >> 8), this.SCREEN_HEIGHT - bottomHeight, 20);
    }

    private void animateBottomMenuIcons(Graphics g, int accMenuTime, Image leftIcon, Image rightIcon) {
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        if ((this.state == 22 || this.state != 22 && !language && this.menuIndex != 0) && leftIcon != null) {
            bottomLeftIconPos = accMenuTime * accMenuTime * bottom1Width >> 7;
            g.drawImage(leftIcon, (bottomLeftIconPos + 128 >> 8) - ((bottom1Width << 1) - bottom1ButtonXOffset), this.SCREEN_HEIGHT - bottomHeight + bottomButtonYOffset, 20);
        }
        if (rightIcon != null) {
            bottomRightIconPos = accMenuTime * accMenuTime * bottom3Width >> 7;
            int xPos = this.SCREEN_WIDTH + bottom3Width - (bottomRightIconPos + 128 >> 8) + bottom3ButtonXOffset;
            if (rightIcon == bottomHP) {
                int hpLen = shipHP * ((button3Width << 8) / maxShipHP) + 128 >> 8;
                if (hpLen == 0) {
                    return;
                }
                g.setClip(xPos, this.SCREEN_HEIGHT - bottomHeight + bottomButtonYOffset, hpLen, bottomHP.getHeight());
            }
            g.drawImage(rightIcon, xPos, this.SCREEN_HEIGHT - bottomHeight + bottomButtonYOffset, 20);
        }
    }

    static void animateWeaponInfo(Graphics g, int accMenuTime) {
        weaponInfoPos = accMenuTime * accMenuTime * weaponInfoHeight + 32768 >> 16;
    }

    static void disposeStoryImages() {
        storyImages = null;
    }

    private void paintStoryBackground(Graphics g, int actTime) {
        if (topause == 1) {
            this.animateTopBorder(g, 256);
            this.animateMenuk(g, 256, 1);
            this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[actStory + 59]);
            topause = 0;
        }
        if (this.state == 21 && actStory == 7 || actStory == 8) {
            this.animateMenuk(g, 256, 1);
            this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[actStory + 59]);
        } else if (this.state == 18 || this.state == 19 || this.state == 30) {
            this.animateMenuk(g, 256, 1);
            this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[68]);
        }
        if (actStory >= 35 && actStory <= 42 && this.state != 18 && this.state != 38 && this.state != 19 && this.state != 20) {
            this.animateMenuk(g, 256, 1);
            this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[67]);
        }
        accStoryBGTime += actTime;
        g.setClip(0, ptop, this.SCREEN_WIDTH, pheight);
        g.setColor(0, 0, 0);
        g.fillRect(0, ptop, this.SCREEN_WIDTH, pheight);
        this.animateBottomDisplay(g, 256);
        this.animateBottomMenuIcons(g, 256, bottomPrev, bottomNext);
    }

    private void clearScreen(Graphics g) {
        g.setClip(0, 0, this.REAL_WIDTH + 64, this.REAL_HEIGHT + 128);
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.REAL_WIDTH + 64, this.REAL_HEIGHT + 128);
    }

    private void displayImageCentered(Graphics g, String file) {
        try {
            this.clearScreen(g);
            Image actIm = Image.createImage((String)file);
            int xPos = this.SCREEN_WIDTH - actIm.getWidth() >> 1;
            int yPos = this.SCREEN_HEIGHT - actIm.getHeight() >> 1;
            g.drawImage(actIm, xPos, yPos, 20);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopMidi() {
        if (player == null) {
            return;
        }
        try {
            player.stop();
            player.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        player = null;
    }

    private void setSound(boolean soundEnabled) {
        if (isRunning) {
            this.isSoundEnabled = soundEnabled;
            RMS.getInstance().setString("Akatis_sound", "" + soundEnabled);
        }
        this.stopMidi();
        if (soundEnabled) {
            Engine.menu[30] = 26;
            this.startMidi("setSound");
        } else {
            Engine.menu[30] = 25;
        }
    }

    private void startMidi(String reason) {
        if (!this.isSoundEnabled || actMusic == null || player != null) {
            return;
        }
        this.t = new Thread(this);
        this.t = new Thread(new Runnable(){

            public void run() {
                try {
                    player = Manager.createPlayer((InputStream)this.getClass().getResourceAsStream(actMusic), (String)"audio/midi");
                    player.setLoopCount(-1);
                    player.realize();
                    player.start();
                }
                catch (Exception e) {
                    Logger.error(this, "Unable to start player", e);
                }
            }
        });
        this.t.start();
    }

    private void playMidi(String file, String reason) {
        if (file.equals(actMusic)) {
            return;
        }
        actMusic = file;
        this.stopMidi();
        this.startMidi("playMidi");
    }

    private void playSound(int sound) {
    }

    public void paint(Graphics g) {
        switch (this.state) {
            case 105: {
                this.paintQuestionBackground(g, 72);
                this.setState(this.nextState);
                break;
            }
            case 104: {
                this.setArcade(false);
                this.setContinue(false);
                this.deleteGame("newGame");
                this.resetGame("newGame");
                this.setMaxLevel(0, "newGame");
                this.levels = new byte[]{0, 0, 0};
                this.saveLevels("Akatis_story_levels");
                this.isRestartable = false;
                this.prevState = this.state;
                this.setState(2);
                break;
            }
            case 217: {
                this.clearScreen(g);
                this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, (this.SCREEN_HEIGHT >> 2) - fontHeight / 2, "buy akatis");
                this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, (this.SCREEN_HEIGHT >> 1) - fontHeight / 2, "www.game-ever.com");
                if (++accMenuTime <= 300) break;
                this.stop();
                Main.getInstance().exitApp();
                break;
            }
            case 31: {
                if (accMenuTime == 0) {
                    this.clearScreen(g);
                    this.displayImageCentered(g, "/ge.png");
                    ++accMenuTime;
                } else if (this.messages == null) {
                    this.loadStatic();
                    this.messages[0] = "language";
                    this.messages[1] = "sprache";
                    this.messages[2] = "langue";
                    this.messages[3] = "lingua";
                    this.messages[4] = "lenguaje";
                    this.messages[5] = "sngolul";
                    this.messages[6] = "sngolul";
                    this.messages[7] = "sngolul";
                    this.messages[9] = "sngolul";
                    this.messages[17] = "english";
                    this.messages[18] = "german";
                    this.messages[19] = "italian";
                    this.messages[20] = "french";
                    this.messages[8] = "spanich";
                    this.messages[62] = "";
                    this.setMenu(20, "nelvre");
                }
                if ((accMenuTime += this.lastFrameTime) <= 320) break;
                accMenuTime = 0;
                if (TT.compareTo("NOK") != 0) {
                    this.setState(217);
                    break;
                }
                this.setState(0);
                break;
            }
            case 0: {
                if (accMenuTime == 0) {
                    this.displayImageCentered(g, "/start.png");
                    this.loadMenu(true);
                    actMusic = "/menu.mid";
                    this.startMidi("setSound");
                }
                if ((accMenuTime += this.lastFrameTime) <= 256) break;
                accMenuTime = -this.lastFrameTime;
                this.setState(1);
                break;
            }
            case 1: {
                this.prevState = this.state;
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                    this.animateBottomDisplay(g, accMenuTime);
                    this.animateBottomMenuIcons(g, accMenuTime, bottomPrev, buttonRight);
                    this.animateTopBorder(g, accMenuTime);
                    this.animateMenuk(g, accMenuTime, 1);
                    break;
                }
                this.animateLeftDoor(g, 256);
                this.animateRightDoor(g, 256);
                this.animateBottomDisplay(g, 256);
                this.animateBottomMenuIcons(g, 256, bottomPrev, buttonRight);
                this.animateTopBorder(g, 256);
                this.animateMenuk(g, 256, 1);
                accMenuTime = 0;
                this.setState(7);
                break;
            }
            case 7: {
                if ((accMenuTime += this.lastFrameTime) < 96) break;
                if (accMenuTime < 224) {
                    this.animateMenuAsDoor(g, 256);
                    this.animateLeftDoor(g, 256);
                    this.animateRightDoor(g, 224 - accMenuTime << 1);
                    if (storyAfterLevel[levelNum] == -1 || this.prevState == 101 || this.prevState == 26 || this.prevState == 20) break;
                    this.animateMenuk(g, accMenuTime, 1);
                    break;
                }
                accMenuTime = 0;
                if (!this.isArcade() && gameend) {
                    this.setMenu(20, "start update");
                    this.startUpgrade();
                    gameend = false;
                    break;
                }
                this.setState(2);
                break;
            }
            case 8: {
                if ((accMenuTime += this.lastFrameTime) < 0) {
                    accMenuTime = 0;
                    if (this.isArcade()) {
                        this.setMenu(20, "start update");
                        this.startUpgrade();
                        break;
                    }
                    this.disposeMenu(false);
                    System.gc();
                    this.initLevel();
                    this.setState(3);
                    break;
                }
                if (accMenuTime < 128) {
                    this.animateRightDoor(g, accMenuTime << 1);
                    break;
                }
                accMenuTime = Integer.MIN_VALUE;
                this.animateRightDoor(g, 256);
                break;
            }
            case 3: {
                this.paintLevel(g);
                vscrl = levelNum == 6 || levelNum == 7 || levelNum == 8 ? vseged - 224 : vseged;
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    this.animateBottomDisplay(g, 256);
                    if (this.prevState != 102) break;
                    this.animateTopBorder(g, 256);
                    this.animateMenuk(g, accMenuTime, 0);
                    break;
                }
                this.animateBottomDisplay(g, 256);
                accMenuTime = 0;
                this.setState(12);
                this.disposeMenu(true);
                break;
            }
            case 33: {
                this.paintChapter(g);
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                } else {
                    this.animateRightDoor(g, 256);
                    this.setState(34);
                    chapterScrollDelta = 0;
                }
                this.animateMenuk(g, 256, 1);
                this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[69]);
                break;
            }
            case 34: {
                int dx = this.lastFrameTime * 2;
                if (chapterScrollDelta < 0) {
                    if (chapterBigImageX > 0 && chapterBigImageX <= dx) {
                        chapterBigImageX = 0;
                        chapterScrollDelta = 0;
                    } else if ((chapterBigImageX -= dx) <= -256) {
                        chapterBigImageX = 0;
                        chapterScrollDelta = 0;
                        ++this.selectedChapter;
                    }
                } else if (chapterScrollDelta > 0) {
                    if (chapterBigImageX < 0 && chapterBigImageX >= -dx) {
                        chapterBigImageX = 0;
                        chapterScrollDelta = 0;
                    } else if ((chapterBigImageX += dx) >= 256) {
                        chapterBigImageX = 0;
                        chapterScrollDelta = 0;
                        --this.selectedChapter;
                    }
                }
                this.paintChapter(g);
                break;
            }
            case 35: {
                this.paintChapter(g);
                if ((accMenuTime -= this.lastFrameTime) > 0) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    if (this.isArcade()) break;
                    this.animateTopBorder(g, 256);
                    this.animateMenuk(g, accMenuTime - 120, 1);
                    break;
                }
                this.animateLeftDoor(g, 256);
                if (this.isArcade()) {
                    accMenuTime = Integer.MIN_VALUE;
                    Engine.initStory(storyBeforeLevel[levelNum]);
                    this.setState(8);
                    break;
                }
                if (storyBeforeLevel[levelNum] >= 0) {
                    Engine.initStory(storyBeforeLevel[levelNum]);
                    accMenuTime = 0;
                    this.setState(21);
                    break;
                }
                accMenuTime = Integer.MIN_VALUE;
                this.paintQuestionBackground(g, 72);
                this.setState(8);
                break;
            }
            case 101: {
                this.paintChapter(g);
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, accMenuTime);
                    break;
                }
                this.animateLeftDoor(g, 256);
                accMenuTime = 0;
                this.prevState = this.state;
                this.setState(7);
                break;
            }
            case 5: {
                if ((accMenuTime += this.lastFrameTime) < 0) {
                    this.stopMidi();
                    actMusic = "/menu.mid";
                    this.startMidi("setSound");
                    Engine.disposeLevel();
                    System.gc();
                    this.loadMenu(true);
                    accMenuTime = 0;
                    this.resetLevel();
                    boolean isGameOver = false;
                    if (this.prevState == 27) {
                        int nextLevel = levelNum + 1;
                        if (nextLevel > this.getAbsoluteMaxLevel()) {
                            isGameOver = true;
                        } else if (this.getMaxLevel() < nextLevel && !this.isArcade()) {
                            this.setMaxLevel(nextLevel, "STATE_GAME_LEVEL_END");
                        }
                    }
                    if (isGameOver) {
                        this.deleteGame("STATE_GAME_TO_MENU_PAR -> game over");
                    } else if (playerLives >= 0) {
                        this.saveGame("STATE_GAME_TO_MENU_PAR");
                    }
                    if (this.isArcade()) {
                        this.setMenu(5, "back to game menu in arcade mode");
                    }
                    this.setState(this.nextState);
                    break;
                }
                if (accMenuTime < 256) {
                    this.animateLeftDoor(g, accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                    this.animateBottomDisplay(g, 256);
                    if (storyAfterLevel[levelNum] == -1) {
                        this.animateMenuk(g, accMenuTime, 1);
                    }
                    this.paintQuestionBackground(g, 72);
                    break;
                }
                this.animateLeftDoor(g, 256);
                this.animateRightDoor(g, 256);
                this.animateBottomDisplay(g, 256);
                this.animateBottomMenuIcons(g, 256, bottomPrev, bottomNext);
                accMenuTime = Integer.MIN_VALUE;
                this.paintQuestionBackground(g, 72);
                break;
            }
            case 29: {
                this.score += weaponPrice[this.shipWeaponFront];
                if (this.shipWeaponShield != -1) {
                    this.score += weaponPrice[this.shipWeaponShield + 16];
                }
                if (this.shipWeaponBack != -1) {
                    this.score += weaponPrice[this.shipWeaponBack];
                }
                if (this.shipWeaponExtra != -1) {
                    this.score += weaponPrice[this.shipWeaponExtra + 18];
                }
                if (accMenuTime <= 0) {
                    this.resetLevel();
                }
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintHighScore(g, accMenuTime);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    if (this.prevState == 5 && storyAfterLevel[this.levelNums] < 0) break;
                    this.animateMenuk(g, accMenuTime, 1);
                    break;
                }
                accMenuTime = 0;
                this.setState(19);
                break;
            }
            case 18: {
                if (accMenuTime <= 0) {
                    // empty if block
                }
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintHighScore(g, accMenuTime);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    break;
                }
                accMenuTime = 0;
                this.setState(19);
                break;
            }
            case 19: {
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintHighScore(g, accMenuTime);
                accMenuTime += this.lastFrameTime;
                break;
            }
            case 20: {
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintHighScore(g, accMenuTime);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                    break;
                }
                this.animateLeftDoor(g, 256);
                this.animateRightDoor(g, 256);
                Engine.disposeStoryImages();
                accMenuTime = 0;
                editingHighScore = -1;
                this.setState(7);
                break;
            }
            case 9: {
                if (!this.isArcade()) {
                    this.paintUpgrade(g);
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    if (!this.isArcade()) break;
                    this.paintMenu(g);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    this.paintUpgrade(g);
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    break;
                }
                accMenuTime = 0;
                this.setState(11);
                break;
            }
            case 10: {
                this.paintUpgrade(g);
                if ((accMenuTime += this.lastFrameTime) < 262) {
                    this.animateLeftDoor(g, accMenuTime);
                    if (this.isArcade()) {
                        this.animateRightDoor(g, accMenuTime);
                        this.animateTopBorder(g, 256);
                        this.animateMenuk(g, accMenuTime, 0);
                    }
                    if (!this.isArcade() || accMenuTime < 250) break;
                    this.paintQuestionBackground(g, 72);
                    break;
                }
                this.animateLeftDoor(g, 256);
                accMenuTime = 0;
                if (this.isArcade()) {
                    this.animateRightDoor(g, 256);
                    Engine.disposeStoryImages();
                    this.initLevel();
                    accMenuTime = 0;
                    this.setState(3);
                    break;
                }
                this.setState(2);
                break;
            }
            case 11: {
                this.paintMenu(g);
                this.paintUpgrade(g);
                break;
            }
            case 2: {
                if (accMenuTime != 0) {
                    accMenuTime = 1;
                }
                if (ngage) break;
                this.paintMenu(g);
                break;
            }
            case 12: {
                this.paintLevel(g);
                if ((accMenuTime += this.lastFrameTime) < 128) {
                    this.animateTopLives(g, accMenuTime << 1);
                    this.animateTopScore(g, accMenuTime << 1);
                    this.animateBottomDisplay(g, 256);
                    this.animateBottomMenuIcons(g, 256, null, bottomHP);
                    break;
                }
                this.animateTopLives(g, 256);
                this.animateTopScore(g, 256);
                this.animateBottomDisplay(g, 256);
                this.animateBottomMenuIcons(g, 256, null, bottomHP);
                accMenuTime = 0;
                this.setState(4);
                break;
            }
            case 13: {
                this.prevState = this.state;
                this.paintQuestionBackground(g, 72);
                if ((accMenuTime += this.lastFrameTime) < 0) {
                    accMenuTime = 0;
                    this.loadMenu(false);
                    this.setState(5);
                    break;
                }
                if (accMenuTime < 128) {
                    int remTime = 256 - (accMenuTime << 1);
                    this.animateTopBorder(g, 256);
                    this.animateTopLives(g, remTime);
                    this.animateTopScore(g, remTime);
                    this.animateBottomDisplay(g, 256);
                    break;
                }
                this.animateTopBorder(g, 256);
                this.animateTopLives(g, 0);
                this.animateTopScore(g, 0);
                this.animateBottomDisplay(g, 256);
                this.animateBottomMenuIcons(g, 0, null, bottomHP);
                accMenuTime = Integer.MIN_VALUE;
                break;
            }
            case 4: {
                int hpLen;
                this.paintLevel(g);
                if (prevPlayerLives != playerLives) {
                    g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                    g.drawImage(topLives, this.SCREEN_WIDTH - topLives.getWidth(), 0, 20);
                    Engine.writeNumLeft(g, this.SCREEN_WIDTH - top3NumXOffset, top3NumYOffset, playerLives);
                    prevPlayerLives = playerLives;
                }
                if (prevScore != this.score) {
                    g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                    g.drawImage(topScore, 0, 0, 20);
                    Engine.writeNumRight(g, top1Width - top1NumXOffset, top1NumYOffset, this.score);
                    prevScore = this.score;
                }
                if (shipPrevHP != shipHP) {
                    g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                    g.drawImage(this.bottomRightDisplay, this.SCREEN_WIDTH - bottom3Width, this.SCREEN_HEIGHT - bottomHeight, 20);
                    shipPrevHP = shipHP;
                    hpLen = shipHP * ((button3Width << 8) / maxShipHP) + 128 >> 8;
                    if (hpLen > 0) {
                        int xPos = this.SCREEN_WIDTH - bottom3Width + bottom3ButtonXOffset;
                        int yPos = this.SCREEN_HEIGHT - bottomHeight + bottomButtonYOffset;
                        g.setClip(xPos, yPos, hpLen, bottomHeight);
                        g.drawImage(bottomHP, xPos, yPos, 20);
                    }
                }
                if (mainEnemy == null || prevMainEnemyHP == Engine.mainEnemy.hp) break;
                g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
                g.drawImage(this.bottomLeftDisplay, 0, this.SCREEN_HEIGHT - bottomHeight, 20);
                prevMainEnemyHP = Engine.mainEnemy.hp;
                hpLen = Engine.mainEnemy.hp * ((button1Width << 8) / Engine.mainEnemy.entype.hp) + 128 >> 8;
                if (hpLen <= 0) break;
                g.setColor(255, 0, 0);
                g.fillRect(bottom1ButtonXOffset, this.SCREEN_HEIGHT - bottomHeight + bottomButtonYOffset, hpLen, buttonHeight);
                break;
            }
            case 32: {
                this.paintQuestionBackground(g, 41);
                gameend = false;
                this.prevState = this.state;
                break;
            }
            case 36: {
                this.paintQuestionBackground(g, 42);
                break;
            }
            case 102: {
                this.paintQuestionBackground(g, 57);
                this.prevState = this.state;
                break;
            }
            case 14: {
                Engine.menu[27] = this.shopWeaponFront == -1 || this.shopWeaponBack == -1 || this.shopWeaponShield == -1 || this.shopWeaponExtra == -1 ? -1 : 23;
                this.paintUpgrade(g);
                if ((accMenuTime += this.lastFrameTime) < 128) {
                    Engine.animateWeaponInfo(g, accMenuTime << 1);
                    this.animateTopScore(g, accMenuTime << 1);
                    break;
                }
                Engine.animateWeaponInfo(g, 256);
                this.animateTopScore(g, 256);
                accMenuTime = 0;
                this.setState(11);
                break;
            }
            case 15: {
                this.paintUpgrade(g);
                if ((accMenuTime += this.lastFrameTime) < 128) {
                    Engine.animateWeaponInfo(g, 256 - (accMenuTime << 1));
                    this.animateTopScore(g, 256 - (accMenuTime << 1));
                    break;
                }
                Engine.animateWeaponInfo(g, 0);
                accMenuTime = 0;
                topScorePos = 0;
                this.setState(11);
                break;
            }
            case 16: {
                if ((accMenuTime += this.lastFrameTime) < 192) {
                    topScorePos = 0;
                    this.paintUpgrade(g);
                    this.animateTopScore(g, 256);
                    this.animateMenuk(g, 256, 1);
                    this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[71]);
                    break;
                }
                topScorePos = top1Height;
                accMenuTime = 0;
                this.setState(11);
                break;
            }
            case 25: {
                if (accMenuTime <= 0) {
                    g.setColor(0);
                }
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintStory(g, -1);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    break;
                }
                this.setState(22);
                break;
            }
            case 38: {
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateRightDoor(g, accMenuTime);
                    break;
                }
                accMenuTime = 0;
                this.setState(18);
                break;
            }
            case 103: {
                if ((accMenuTime += this.lastFrameTime) < 258) {
                    this.animateLeftDoor(g, accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                    this.animateMenuk(g, accMenuTime, 1);
                    break;
                }
                accMenuTime = 0;
                this.setState(30);
                break;
            }
            case 106: {
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.paintMenu(g);
                    this.animateRightDoor(g, accMenuTime);
                    this.animateTopBorder(g, 256);
                    this.animateMenuk(g, accMenuTime, 0);
                    break;
                }
                accMenuTime = 0;
                this.setState(3);
                break;
            }
            case 37: {
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateRightDoor(g, accMenuTime);
                    break;
                }
                accMenuTime = 0;
                this.setState(21);
                break;
            }
            case 21: {
                if (accMenuTime <= 0) {
                    g.setColor(0);
                }
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintStory(g, -1);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    break;
                }
                this.animateBottomMenuIcons(g, 256, bottomPrev, bottomNext);
                this.setState(22);
                break;
            }
            case 22: {
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintStory(g, accMenuTime);
                accMenuTime += this.lastFrameTime;
                break;
            }
            case 26: {
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintStory(g, -1);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                    if (actStory >= 5) break;
                    this.animateMenuk(g, accMenuTime, 1);
                    break;
                }
                this.animateLeftDoor(g, 256);
                this.animateRightDoor(g, 256);
                Engine.disposeStoryImages();
                accMenuTime = 0;
                this.setState(7);
                break;
            }
            case 30: {
                if (accMenuTime == 0) {
                    this.score += weaponPrice[this.shipWeaponFront];
                    if (this.shipWeaponShield != -1) {
                        this.score += weaponPrice[this.shipWeaponShield + 16];
                    }
                    if (this.shipWeaponBack != -1) {
                        this.score += weaponPrice[this.shipWeaponBack];
                    }
                    if (this.shipWeaponExtra != -1) {
                        this.score += weaponPrice[this.shipWeaponExtra + 18];
                    }
                }
                if (accMenuTime <= 0) {
                    this.resetLevel();
                }
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintHighScore(g, accMenuTime);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, 256 - accMenuTime);
                    this.animateRightDoor(g, 256 - accMenuTime);
                    if (this.prevState == 5 || this.prevState == 103) break;
                    this.animateMenuk(g, accMenuTime, 1);
                    break;
                }
                accMenuTime = 0;
                this.setState(19);
                break;
            }
            case 24: {
                if (accMenuTime < 0) {
                    Engine.disposeStoryImages();
                    this.initLevel();
                    accMenuTime = 0;
                    this.setState(3);
                    break;
                }
                this.paintStoryBackground(g, this.lastFrameTime);
                this.paintStory(g, -1);
                if (this.lastFrameTime < 10) {
                    this.lastFrameTime = 10;
                }
                if ((accMenuTime += this.lastFrameTime) < 256) {
                    this.animateLeftDoor(g, accMenuTime);
                    this.animateRightDoor(g, accMenuTime);
                    this.animateTopBorder(g, 256);
                    break;
                }
                this.animateLeftDoor(g, 256);
                this.animateRightDoor(g, 256);
                accMenuTime = Integer.MIN_VALUE;
                this.paintQuestionBackground(g, 72);
                break;
            }
            case 27: {
                shipHP = 2000;
                shouldDrawShip = false;
                gameend = true;
                this.paintLevel(g);
                if ((accMenuTime += this.lastFrameTime) < 0) {
                    this.loadMenu(false);
                    if (!this.isArcade() && storyAfterLevel[levelNum] >= 0) {
                        Engine.initStory(storyAfterLevel[levelNum]);
                        this.nextState = 25;
                    } else if (!this.isArcade() && levelNum == this.getAbsoluteMaxLevel()) {
                        this.deleteGame("Game Over!");
                        this.nextState = 29;
                        this.highScorePossible = true;
                    } else {
                        this.nextState = 7;
                    }
                    accMenuTime = 0;
                    this.setState(5);
                    break;
                }
                if (accMenuTime < 128) {
                    int actShipX = (fShipX - fenshift + 128 >> 8) + pleft;
                    int actShipShift = accMenuTime * accMenuTime * pheight * 4 >> 8;
                    int actShipY = (fShipY - actShipShift + 128 >> 8) + ptop;
                    if (this.shipWeaponExtra >= 0) {
                        int extraGunX = fExtraGunX - fenshift + 128 >> 8;
                        int extraGunY = (fExtraGunY - actShipShift >> 8) + ptop;
                        g.setClip(0, ptop, this.SCREEN_WIDTH, pheight);
                        g.drawImage(bulletImages[15 + this.shipWeaponExtra], extraGunX, extraGunY, 20);
                    }
                    if (this.shipWeaponShield >= 0) {
                        for (int i = 0; i <= this.shipWeaponShield; ++i) {
                            Bullet b = bullets[shieldBulletIndex[i]];
                            b.fxAct = -5000;
                            b.fyAct = -5000;
                        }
                    }
                    g.setClip(actShipX, actShipY, shipWidth, shipHeight);
                    g.drawImage(shipImage, actShipX - (shipSlideTime + 16 >> 5) * shipWidth, actShipY, 20);
                    int remTime = 256 - (accMenuTime << 1);
                    this.animateTopLives(g, remTime);
                    this.animateTopScore(g, remTime);
                    this.animateBottomDisplay(g, 256);
                    this.animateTopBorder(g, 256);
                    break;
                }
                this.animateTopLives(g, 0);
                this.animateTopScore(g, 0);
                this.animateBottomDisplay(g, 256);
                this.animateTopBorder(g, 256);
                accMenuTime = Integer.MIN_VALUE;
                break;
            }
            case 28: {
                this.stop();
            }
        }
    }

    private void paintQuestionBackground(Graphics g, int index) {
        g.setColor(0);
        g.fillRect(0, (this.SCREEN_HEIGHT >> 1) - fontHeight, this.SCREEN_WIDTH, fontHeight * 2);
        this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, (this.SCREEN_HEIGHT >> 1) - fontHeight / 2, this.messages[index]);
        this.animateBottomMenuIcons(g, 256, bottomPrev, bottomNext);
    }

    static final boolean collide(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2) {
        x1max = ax1 < bx1 ? bx1 : ax1;
        int n = x2min = ax2 > bx2 ? bx2 : ax2;
        if (x1max < x2min) {
            y1max = ay1 < by1 ? by1 : ay1;
            int n2 = y2min = ay2 > by2 ? by2 : ay2;
            if (y1max < y2min) {
                return true;
            }
        }
        return false;
    }

    static final void createParticle(int fx, int fy) {
        for (int i = 0; i < particlefTime.length; ++i) {
            if (particlefTime[i] > 0) continue;
            Engine.particlefTime[i] = 80;
            Engine.particlefXPos[i] = fx;
            Engine.particlefYPos[i] = fy;
            Engine.particleAngleSin[i] = -65536;
            Engine.particleAngleCos[i] = 0;
            Engine.particleSpeed[i] = 20;
            Engine.particleAnimPos[i] = 0;
            break;
        }
    }

    static final void createParticles(int fx, int fy, int damage, int timeAnd, int speedAnd, int speedOffset) {
        int num = 2 + (damage >> 1);
        block0: for (int j = 0; j < num; ++j) {
            for (int i = 0; i < particlefTime.length; ++i) {
                if (particlefTime[i] > 0) continue;
                Engine.particlefTime[i] = Math.abs(random.nextInt()) & timeAnd;
                int angle = Math.abs(random.nextInt()) % 360;
                Engine.particleAngleSin[i] = Stuff.sin(angle);
                Engine.particleAngleCos[i] = Stuff.cos(angle);
                Engine.particlefXPos[i] = fx;
                Engine.particlefYPos[i] = fy;
                Engine.particleSpeed[i] = (Math.abs(random.nextInt()) & speedAnd) + speedOffset;
                Engine.particleAnimPos[i] = 0;
                continue block0;
            }
        }
    }

    private void paintChapter(Graphics g) {
        int x = chapterBigImageX * leftDoorWidth >> 8;
        g.setClip(0, PAINT_CHAPTER_Y, leftDoorWidth, this.softTop);
        this.paintChapter(g, 0, x, PAINT_CHAPTER_Y, this.softTop);
        if (x > 0) {
            this.paintChapter(g, -1, x, PAINT_CHAPTER_Y, this.softTop);
            this.paintChapter(g, 0, x, PAINT_CHAPTER_Y, this.softTop);
        } else if (x < 0) {
            this.paintChapter(g, 1, x, PAINT_CHAPTER_Y, this.softTop);
        }
    }

    private void paintChapter(Graphics g, int sign, int x, int y, int height) {
        int chShaded = this.getLevelImageIndex(this.selectedChapter + sign);
        g.drawImage(chapterLabelImages[chShaded], x + leftDoorWidth * sign, y + 10, 20);
        int w = leftDoorWidth - x - 74 - leftDoorWidth * sign;
        this.paintChapterNumImages(g, w, x, y, leftDoorWidth * sign, height, chShaded, this.selectedChapter + sign);
        this.paintChapterBigImage(g, this.selectedChapter + sign, x + leftDoorWidth * sign, y + 24, height);
        if (topause == 1) {
            g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
            if (accMenuTime >= 256) {
                this.animateRightDoor(g, 256);
            }
            topause = 0;
            this.animateBottomDisplay(g, 256);
            this.animateBottomMenuIcons(g, 256, bottomPrev, bottomNext);
            this.animateTopBorder(g, 256);
            this.animateMenuk(g, 256, 1);
            this.writeStringCentered(g, this.SCREEN_WIDTH >> 1, fontHeight / 2 - 1, this.messages[69]);
        }
    }

    private void paintChapterBigImage(Graphics g, int index, int x, int y, int height) {
        Image image = chapterBigImages[chapterBigImageIndices[index]];
        g.setClip(0, y, leftDoorWidth, height - y);
        g.drawImage(image, x, y + 20, 20);
        g.setClip(0, PAINT_CHAPTER_Y, leftDoorWidth, height);
    }

    private void paintChapterNumImages(Graphics g, int w, int x, int y, int width, int height, int chShaded, int selectedChapter) {
        if (w > 0) {
            if (w > 15) {
                w = 15;
            }
            g.setClip(x + 73 + width, 45, w, 12);
            g.drawImage(chapterNumImages[chShaded], x + 72 - selectedChapter * 15 + width, 45, 20);
            g.setClip(0, y, leftDoorWidth, height - y);
        }
    }

    private int getLevelImageIndex(int level) {
        if (this.isContinue()) {
            return level == this.getMaxLevel() ? 0 : 1;
        }
        return level <= this.getMaxLevel() ? 0 : 1;
    }

    public void ready(Graphics g) {
        if (messageTime > 0) {
            g.setColor(0, 0, 0);
            if ((messageTime -= this.lastFrameTime) < 1200) {
                if (messageTime > 1150 || messageTime <= 50) {
                    g.fillRect(0, (this.SCREEN_HEIGHT >> 1) - 1, this.SCREEN_WIDTH, 2);
                    g.setClip((this.SCREEN_WIDTH >> 1) - (readyWidth >> 1), (this.SCREEN_HEIGHT >> 1) - (readyHeight >> 1), readyWidth, readyHeight);
                    g.drawImage(readyImage, (this.SCREEN_WIDTH >> 1) - (readyWidth >> 1), (this.SCREEN_HEIGHT >> 1) - (readyHeight >> 1), 20);
                } else if (messageTime > 1100 || messageTime <= 100) {
                    g.fillRect(0, (this.SCREEN_HEIGHT >> 1) - 2, this.SCREEN_WIDTH, 4);
                    g.setClip((this.SCREEN_WIDTH >> 1) - (readyWidth >> 1), (this.SCREEN_HEIGHT >> 1) - (readyHeight >> 1), readyWidth, readyHeight);
                    g.drawImage(readyImage, (this.SCREEN_WIDTH >> 1) - (readyWidth >> 1) - readyWidth, (this.SCREEN_HEIGHT >> 1) - (readyHeight >> 1), 20);
                } else {
                    g.fillRect(0, (this.SCREEN_HEIGHT >> 1) - 5, this.SCREEN_WIDTH, 10);
                    g.setClip((this.SCREEN_WIDTH >> 1) - (readyWidth >> 1), (this.SCREEN_HEIGHT >> 1) - (readyHeight >> 1), readyWidth, readyHeight);
                    g.drawImage(readyImage, (this.SCREEN_WIDTH >> 1) - (readyWidth >> 1) - readyWidth - readyWidth, (this.SCREEN_HEIGHT >> 1) - (readyHeight >> 1), 20);
                }
            }
        }
    }

    private void paintlang(Graphics g, Image FW, int xposFW, int yposFW, int typeEN, int framesz) {
        int engineParticleXFW = xposFW + (enemyImages[typeEN].getWidth() >> framesz) - (FW.getWidth() >> 2);
        int engineParticleYFW = yposFW - FW.getHeight();
        int shipEngineParticleXSizeFW = FW.getWidth() >> 1;
        int shipEngineParticleYSizeFW = FW.getHeight();
        g.setClip(engineParticleXFW, Math.max(ptop, engineParticleYFW), shipEngineParticleXSizeFW, Math.min(shipEngineParticleYSizeFW, pbottom - engineParticleYFW));
        if ((this.accFrameTime & 0x10) > 0) {
            engineParticleXFW -= shipEngineParticleXSizeFW;
        }
        g.drawImage(FW, engineParticleXFW, engineParticleYFW, 20);
    }

    private void paintLevel(Graphics g) {
        int j;
        int i;
        int lastFrameTime = this.lastFrameTime * 1;
        int time = (this.accFrameTime + this.fAccBGTime) * 1;
        for (int i2 = 0; i2 < bgLayers.length; ++i2) {
            bgLayers[i2].draw(g, time);
        }
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        this.ready(g);
        g.drawImage(this.nyil, 2, this.softTop - 5, 20);
        if (!(gombok[0] || gombok[1] || gombok[2] || gombok[3])) {
            this.ehLast = this.ehFirst;
        }
        if (topause == 1) {
            this.animateTopBorder(g, 256);
            this.animateTopLives(g, 256);
            this.animateTopScore(g, 256);
            this.animateBottomDisplay(g, 256);
            this.animateBottomMenuIcons(g, 256, null, bottomHP);
            Engine.writeNumRight(g, top1Width - top1NumXOffset, top1NumYOffset, this.score);
            Engine.writeNumLeft(g, this.SCREEN_WIDTH - top3NumXOffset, top3NumYOffset, playerLives);
            topause = 0;
        }
        int actLastBullet = 0;
        for (int i3 = 0; i3 < bulletLast; ++i3) {
            Bullet b = bullets[i3];
            if (b == null) continue;
            if (b.type == 13) {
                int mind = Integer.MAX_VALUE;
                int mindx = 0;
                int mindy = 0;
                for (int j2 = enBegin; j2 < enemies.length; ++j2) {
                    if (enemies[j2] == null) continue;
                    Enemy en = enemies[j2];
                    if (en.explosionTime >= 0) continue;
                    if (en.pathPoint < 0) break;
                    this.dxtt = en.fxAct + (fenWidth[en.type] >> 1) - b.fxAct;
                    this.dytt = en.fyAct + (fenHeight[en.type] >> 1) - b.fyAct;
                    this.actdtt = this.dxtt * this.dxtt + this.dytt * this.dytt;
                    this.actdtt = Math.abs(this.actdtt);
                    if (this.actdtt >= mind) continue;
                    mind = this.actdtt;
                    mindx = this.dxtt;
                    mindy = this.dytt;
                }
                if (mind < Integer.MAX_VALUE) {
                    mind = Stuff.sqrt(mind);
                    b.seek(mindx, mindy, mind, lastFrameTime);
                } else {
                    b.move(lastFrameTime);
                }
            } else {
                b.move(lastFrameTime);
                if (b.type == 24 && b.spawnParticle > 50) {
                    Engine.createParticle(b.fxAct, b.fyAct + rocketParticleYOffset);
                    b.spawnParticle = 0;
                }
            }
            actLastBullet = i3;
        }
        bulletLast = actLastBullet + 1;
        enbgpos = ((this.accFrameTime + this.fAccBGTime) * fEnemyBGSpeed >> 16) + pheight;
        int fShipLeft = fShipX;
        int fShipRight = fShipLeft + fShipWidth;
        int fShipTop = fShipY;
        int fShipBottom = fShipY + fShipHeight;
        int fShipMiddleX = fShipLeft + (fShipWidth >> 1);
        int fShipMiddleY = fShipY + (fShipHeight >> 1);
        int actvill = this.accFrameTime / 170 % 3;
        if (mainEnemy != null && Engine.mainEnemy.type == 22 && scrollLevel && Engine.mainEnemy.bgPos <= enbgpos) {
            scrollLevel = false;
        }
        if (shipDestroyTime < 0 && shouldDrawShip) {
            if (this.shipWeaponFront >= 0 && this.shipWeaponFront < 12) {
                shipFrontFired += lastFrameTime;
                while (shipFrontFired > this.weaponRate[this.shipWeaponFront]) {
                    shipFrontFired -= this.weaponRate[this.shipWeaponFront];
                    this.fireWeapon(false, fShipMiddleX, fShipY, this.shipWeaponFront);
                }
            }
            if (this.shipWeaponBack >= 12 && this.shipWeaponBack < 16) {
                shipBackFired += lastFrameTime;
                while (shipBackFired > this.weaponRate[this.shipWeaponBack]) {
                    shipBackFired -= this.weaponRate[this.shipWeaponBack];
                    this.fireWeapon(false, fShipMiddleX, fShipY - 1024, this.shipWeaponBack);
                }
            }
            if (this.shipWeaponShield >= 0) {
                int ad = lastFrameTime * 90 + 128 >> 8;
                for (int i4 = 0; i4 <= this.shipWeaponShield; ++i4) {
                    Bullet b = bullets[shieldBulletIndex[i4]];
                    b.angle += ad;
                    while (b.angle >= 360) {
                        b.angle -= 360;
                    }
                    b.fxAct = fShipMiddleX + (Stuff.cos(b.angle) * fShipWidth >> 16) - (fBulletWidth[14] >> 1);
                    b.fyAct = fShipMiddleY + (Stuff.sin(b.angle) * fShipHeight >> 16) - (fBulletHeight[14] >> 1);
                }
            }
            if (this.shipWeaponExtra >= 0) {
                int actBullet = 15 + this.shipWeaponExtra;
                int actWeapon = this.shipWeaponExtra * 3;
                int actD = 96 * lastFrameTime;
                int diffX = fShipX;
                diffX = shipWeaponExtraLeft ? (diffX -= fBulletWidth[actBullet]) : (diffX += fShipWidth);
                int diffY = fShipY + fShipHeight - fBulletHeight[actBullet] - extraGunVerticalTilt[this.shipWeaponExtra] - fExtraGunY;
                int targetD = Stuff.sqrt((diffX -= fExtraGunX) * diffX + diffY * diffY);
                if (targetD <= actD) {
                    fExtraGunX += diffX;
                    fExtraGunY += diffY;
                } else {
                    int ratio = (actD << 8) / targetD;
                    fExtraGunX += diffX * ratio + 128 >> 8;
                    fExtraGunY += diffY * ratio + 128 >> 8;
                }
                shipExtraFired += lastFrameTime;
                while (shipExtraFired > this.weaponRate[actWeapon]) {
                    shipExtraFired -= this.weaponRate[actWeapon];
                    this.fireWeapon(false, fExtraGunX + (fBulletWidth[actBullet] >> 1), fExtraGunY, actWeapon);
                }
            }
        }
        for (i = 0; i < particlefTime.length; ++i) {
            if (particlefTime[i] <= 0) continue;
            int n = i;
            particlefTime[n] = particlefTime[n] - lastFrameTime;
            int d = lastFrameTime * particleSpeed[i];
            int n2 = i;
            particlefXPos[n2] = particlefXPos[n2] + (particleAngleSin[i] * d >> 16);
            int n3 = i;
            particlefYPos[n3] = particlefYPos[n3] + (particleAngleCos[i] * d >> 16);
        }
        i = enBegin;
        while (i < enemies.length) {
            block146: {
                int j3;
                int fyPos2;
                int fxPos2;
                Enemy en;
                block150: {
                    block148: {
                        block152: {
                            block151: {
                                block149: {
                                    block147: {
                                        block145: {
                                            if (enemies[i] != null) break block145;
                                            if (i == enBegin) {
                                                ++enBegin;
                                            }
                                            break block146;
                                        }
                                        en = enemies[i];
                                        if (en.type < 64) break block147;
                                        if (en.bgPos <= enbgpos) {
                                            switch (en.type) {
                                                case 64: {
                                                    messageID = en.actorParams[0];
                                                    messageTime = en.actorParams[1] * 256;
                                                    break;
                                                }
                                                case 65: {
                                                    if (this.accFrameTime <= 768) break;
                                                    messageID = 39;
                                                    messageTime = 768;
                                                    this.fAccBGTime = this.accFrameTime;
                                                    this.accFrameTime = 0;
                                                    this.saveGame("checkpoint");
                                                    break;
                                                }
                                                case 66: {
                                                    break;
                                                }
                                                case 67: {
                                                    this.endGame();
                                                }
                                            }
                                            Engine.enemies[i] = null;
                                        }
                                        break block146;
                                    }
                                    if (en.pathPoint < 0) break block148;
                                    if (en.explosionTime >= 0) break block149;
                                    en.move(lastFrameTime, penwidth, pheight);
                                    break block150;
                                }
                                if (en.p == null) {
                                    en.move(lastFrameTime, penwidth, pheight);
                                    if (en.type < 16) {
                                        en.fyAct += fenHeight[en.type] - fExplSize >> 1;
                                    }
                                }
                                en.explosionTime += lastFrameTime;
                                if (en.type >= 16) break block151;
                                if (en.explosionTime < 192) break block150;
                                Engine.enemies[i] = null;
                                break block146;
                            }
                            if (en.type >= 20) break block152;
                            if (en.fwait == 0) {
                                if (en.explosionTime < 192) {
                                    en.fyAct += fenHeight[en.type] - fExplSize >> 1;
                                } else {
                                    en.fxAct -= fenWidth[en.type] - fExplSize >> 1;
                                    en.fwait = 1;
                                }
                            }
                            break block150;
                        }
                        if (en.explosionTime < 1280) break block150;
                        Engine.enemies[i] = null;
                        this.endGame();
                        break block146;
                    }
                    if (en.bgPos > enbgpos + enHeight[en.type]) break;
                    en.activate(penmiddle, penwidth, pheight, this.fAccBGTime, this.accFrameTime);
                    if (en.type >= 20) {
                        mainEnemy = en;
                        prevMainEnemyHP = -1;
                        meDestroyY = null;
                        meDestroyX = null;
                        meDestroyTime = null;
                        mainEnemyFront = 0;
                    }
                }
                int fxPos = en.fxAct;
                int fyPos = en.fyAct;
                if (en.explosionTime < 0 && en.ghostTime < 0 && (en.type != 19 || actvill != en.fwait)) {
                    fxPos2 = fxPos + fenWidth[en.type];
                    fyPos2 = fyPos + fenHeight[en.type];
                    if (en.type == 19) {
                        fyPos2 -= 2048;
                    }
                    if (en.lastShot >= 0) {
                        en.lastShot += lastFrameTime;
                        while (en.lastShot > en.bulletFreq) {
                            en.lastShot -= en.bulletFreq;
                            this.fireWeapon(true, fxPos + (fenWidth[en.type] >> 1), fyPos + (fenHeight[en.type] >> 1), en.entype.bulletType);
                        }
                    }
                    if (shipBlinkingTime < 0 && shipDestroyTime < 0 && Engine.collide(fxPos, fyPos, fxPos2, fyPos2, fShipLeft, fShipTop, fShipRight, fShipBottom)) {
                        int damage = Math.min(shipHP, en.hp);
                        shipHP -= damage;
                        en.hp -= damage;
                        shipFlashTime = 64;
                        shipFlashType = 1;
                        int enWidthHalf = fenWidth[en.type] >> 1;
                        int enHeightHalf = fenHeight[en.type] >> 1;
                        if (en.hp <= 0) {
                            en.explosionTime = 0;
                            if (en.type < 20) {
                                int dx = enWidthHalf - (fExplSize >> 1);
                                int dy = enHeightHalf - (fExplSize >> 1);
                                en.fxAct += dx;
                                en.fyAct += dy;
                                fxPos2 = (fxPos += dx) + fExplSize;
                                fyPos2 = (fyPos += dy) + fExplSize;
                            }
                        }
                        if (shipHP <= 0) {
                            --playerLives;
                            shipDestroyTime = 0;
                            fShipX += shipWidth - explSize << 7;
                            fShipY += shipHeight - explSize << 7;
                        } else {
                            this.score += en.entype.point;
                            this.actScore += en.entype.point;
                            if (this.actScore >= this.levelNumHPScore) {
                                this.actScore = 20;
                                int nextInd = 0;
                                while (bullets[nextInd] != null) {
                                    ++nextInd;
                                }
                                Engine.bullets[nextInd] = new Bullet(true, en.fxAct + (enWidthHalf - 1024), en.fyAct + (enHeightHalf - 1024), 270, fEnemyBGSpeed >> 8, 34, 0);
                            }
                        }
                    } else if (en.type != 19) {
                        for (j3 = 0; j3 < bulletLast; ++j3) {
                            int fbulletBottom;
                            int fbulletRight;
                            int fbulletTop;
                            int fbulletLeft;
                            Bullet b = bullets[j3];
                            if (b == null || b.enemy || !Engine.collide(fxPos, fyPos, fxPos2, fyPos2, fbulletLeft = b.fxAct, fbulletTop = b.fyAct, fbulletRight = fbulletLeft + fBulletWidth[b.type], fbulletBottom = fbulletTop + fBulletHeight[b.type])) continue;
                            en.hp -= b.damage;
                            if (b.type == 9 || b.type == 10 || b.type == 11) {
                                if (en.hp < 0) {
                                    b.damage = -en.hp;
                                } else {
                                    Engine.bullets[j3] = null;
                                }
                            } else if (b.type != 14) {
                                Engine.bullets[j3] = null;
                            }
                            if (en.hp <= 0) {
                                en.explosionTime = 0;
                                this.score += en.entype.point;
                                this.actScore += en.entype.point;
                                int enWidthHalf = fenWidth[en.type] >> 1;
                                int enHeightHalf = fenHeight[en.type] >> 1;
                                if (en.p != null && this.actScore >= this.levelNumHPScore) {
                                    this.actScore = 20;
                                    int nextInd = 0;
                                    while (bullets[nextInd] != null) {
                                        ++nextInd;
                                    }
                                    Engine.bullets[nextInd] = new Bullet(true, en.fxAct + (enWidthHalf - 1024), en.fyAct + (enHeightHalf - 1024), 270, fEnemyBGSpeed >> 8, 34, 0);
                                }
                                if (en.type < 20) {
                                    int dx = enWidthHalf - (fExplSize >> 1);
                                    int dy = enHeightHalf - (fExplSize >> 1);
                                    en.fxAct += dx;
                                    en.fyAct += dy;
                                    fxPos2 = (fxPos += dx) + fExplSize;
                                    fyPos2 = (fyPos += dy) + fExplSize;
                                }
                                Engine.createParticles(x1max + x2min >> 1, y1max + y2min >> 1, b.damage, 255, 31, 20);
                                break;
                            }
                            if (en.type < 16) {
                                en.flashTime = 32;
                            }
                            Engine.createParticles(x1max + x2min >> 1, y1max + y2min >> 1, b.damage, 127, 63, 20);
                        }
                    }
                } else {
                    fxPos2 = fxPos + fExplSize;
                    fyPos2 = fyPos + fExplSize;
                }
                if (en.ghostTime >= 0 && en.explosionTime < 0) {
                    int gxPos = en.fxGhost * penwidth - fenshift + 128 >> 8;
                    int gyPos = (en.fyGhost * pheight + 128 >> 8) + ptop;
                    if (gxPos < pright && gyPos < pbottom && gxPos + enWidth[10] > pleft && gyPos + enHeight[10] > ptop) {
                        g.setClip(gxPos, Math.max(gyPos, ptop), enWidth[10], Math.min(enHeight[10], pbottom - gyPos));
                        g.drawImage(enemyImages[10], gxPos - (4 - (en.ghostTime >> 5)) * enWidth[10], gyPos, 20);
                    }
                }
                if (en.type == 9 && en.explosionTime < 0) {
                    for (j3 = 2; j3 >= 0; --j3) {
                        int sxPos = en.shadows[j3].fxAct - fenshift + 128 >> 8;
                        int syPos = (en.shadows[j3].fyAct + 128 >> 8) + ptop;
                        if (sxPos >= pright || syPos >= pbottom || sxPos + enWidth[9] <= pleft || syPos + enHeight[9] <= ptop) continue;
                        g.setClip(sxPos, Math.max(syPos, ptop), enWidth[9], Math.min(enHeight[9], pbottom - syPos));
                        g.drawImage(enemyImages[9], sxPos - (2 + j3) * enWidth[9], syPos, 20);
                    }
                }
                int xPos = (fxPos + 128 >> 8) - enshift;
                int yPos = (fyPos + 128 >> 8) + ptop;
                int xPos2 = (fxPos2 + 128 >> 8) - enshift;
                int yPos2 = (fyPos2 + 128 >> 8) + ptop;
                if (en.type == 19) {
                    int actYPos = yPos - 8;
                    if (actYPos >= pbottom) {
                        Engine.enemies[i] = null;
                    } else {
                        g.setClip(0, ptop, this.SCREEN_WIDTH, pheight);
                        if (actvill != en.fwait) {
                            byte[] actorParams = en.actorParams;
                            actorParams[0] = (byte)(actorParams[0] + lastFrameTime);
                            if (actorParams[0] >= 16) {
                                actorParams[0] = 0;
                                actorParams[1] = (byte)(Math.abs(random.nextInt()) % 104);
                            }
                            for (int j4 = -actorParams[1]; j4 <= this.SCREEN_WIDTH; j4 += 104) {
                                g.drawImage(enemyImages[19], j4, yPos, 20);
                            }
                        }
                        g.drawImage(enemyImages[18], 16 - (fenshift + 128 >> 8), actYPos, 20);
                        g.drawImage(enemyImages[18], penwidth - 48 - (fenshift + 128 >> 8), actYPos, 20);
                    }
                } else if (xPos2 <= pleft || xPos >= pright || yPos2 <= ptop || yPos >= pbottom) {
                    if (en.p != null) {
                        if (en.pathPoint == en.p.length) {
                            Engine.enemies[i] = null;
                        }
                    } else if (yPos >= pbottom) {
                        Engine.enemies[i] = null;
                    }
                } else if (en.explosionTime >= 0 && en.type < 18) {
                    if (en.type >= 16) {
                        int actyPos;
                        int actxPos;
                        if (en.explosionTime < 192) {
                            int dx = fenWidth[en.type] - fExplSize >> 1;
                            int dy = fenHeight[en.type] - fExplSize >> 1;
                            actxPos = fxPos - fenshift - dx >> 8;
                            actyPos = (fyPos - dy + 128 >> 8) + ptop;
                        } else {
                            actxPos = xPos;
                            actyPos = yPos;
                        }
                        g.setClip(actxPos, Math.max(ptop, actyPos), enWidth[en.type], Math.min(enHeight[en.type], pbottom - actyPos));
                        g.drawImage(enemyImages[en.type], actxPos - enWidth[en.type], actyPos, 20);
                    }
                    g.setClip(xPos, Math.max(ptop, yPos), explSize, Math.min(explSize, pbottom - yPos));
                    g.drawImage(explosionImages[enExpl[en.type]], xPos - (en.explosionTime >> 5) * explSize, yPos, 20);
                } else {
                    g.setClip(xPos, Math.max(ptop, yPos), enWidth[en.type], Math.min(enHeight[en.type], pbottom - yPos));
                    if (en.flashTime > 0) {
                        g.drawImage(enemyImages[en.type], xPos - enWidth[en.type], yPos, 20);
                        en.flashTime -= lastFrameTime;
                    } else if (en.ghostTime >= 0) {
                        g.drawImage(enemyImages[en.type], xPos - (2 + (en.ghostTime >> 5)) * enWidth[10], yPos, 20);
                    } else if (en.type < 20) {
                        g.drawImage(enemyImages[en.type], xPos, yPos, 20);
                    } else {
                        if (en.explosionTime < 1024) {
                            g.drawImage(enemyImages[en.type], xPos, yPos, 20);
                        }
                        if (en.explosionTime >= 0) {
                            int j5;
                            if (meDestroyTime == null) {
                                int len = 5;
                                if (en.type == 22) {
                                    len = 8;
                                }
                                meDestroyTime = new int[len];
                                meDestroyX = new int[len];
                                meDestroyY = new int[len];
                                for (j5 = 0; j5 < len; ++j5) {
                                    Engine.meDestroyTime[j5] = Integer.MAX_VALUE;
                                }
                            }
                            boolean found = false;
                            for (j5 = 0; j5 < meDestroyTime.length; ++j5) {
                                if (meDestroyTime[j5] >= 192) {
                                    if (found) continue;
                                    found = true;
                                    Engine.meDestroyTime[j5] = 0;
                                    int r = Math.abs(random.nextInt());
                                    Engine.meDestroyX[j5] = r % enWidth[en.type] - (explSize >> 1);
                                    Engine.meDestroyY[j5] = r % enHeight[en.type] - (explSize >> 1);
                                }
                                int explX = xPos + meDestroyX[j5];
                                int explY = yPos + meDestroyY[j5];
                                g.setClip(explX, Math.max(ptop, explY), explSize, Math.min(explSize, pbottom - explY));
                                g.drawImage(explosionImages[(j5 & 1) << 1], explX - (meDestroyTime[j5] >> 5) * explSize, explY, 20);
                                int n = j5;
                                meDestroyTime[n] = meDestroyTime[n] + lastFrameTime;
                            }
                        }
                    }
                    if (en.type != 7 && en.type != 8 && en.type != 9 && en.type != 10 && en.type != 12 && en.type != 14 && en.type != 16 && en.type != 17 && en.type != 22) {
                        if (en.type == 2) {
                            this.paintlang(g, shipEngineParticleImageFW2, xPos, yPos, en.type, 2);
                        } else if (en.type == 20 || en.type == 21 || en.type == 23) {
                            if (prevMainEnemyHP > 0) {
                                this.paintlang(g, shipEngineParticleImageFW2, xPos - 10, yPos, en.type, 1);
                                this.paintlang(g, shipEngineParticleImageFW2, xPos + 10, yPos, en.type, 1);
                            }
                        } else {
                            this.paintlang(g, shipEngineParticleImageFW, xPos, yPos, en.type, 2);
                        }
                    }
                }
            }
            ++i;
        }
        if (shipDestroyTime < 0) {
            for (j = 0; j < bulletLast; ++j) {
                int fbulletBottom;
                int fbulletRight;
                int fbulletTop;
                int fbulletLeft;
                Bullet b = bullets[j];
                if (b == null || !b.enemy || !Engine.collide(fShipLeft, fShipTop, fShipRight, fShipBottom, fbulletLeft = b.fxAct, fbulletTop = b.fyAct, fbulletRight = fbulletLeft + fBulletWidth[b.type], fbulletBottom = fbulletTop + fBulletHeight[b.type])) continue;
                boolean collided = true;
                if (b.type >= 29 && b.type <= 33) {
                    shipHP = shipPrevHP - 5;
                    if (shipFrostTime < b.damage) {
                        shipFrostTime = b.damage;
                    }
                    shipFlashTime = 64;
                    shipFlashType = 2;
                } else if (b.type == 34) {
                    shipHP = maxShipHP;
                    shipFlashTime = 64;
                    shipFlashType = 3;
                } else if (shipBlinkingTime < 0) {
                    shipFlashTime = 64;
                    shipFlashType = 1;
                    if ((shipHP -= b.damage) < 0) {
                        --playerLives;
                        shipDestroyTime = 0;
                        fShipX += shipWidth - explSize << 7;
                        fShipY += shipHeight - explSize << 7;
                        break;
                    }
                    Engine.createParticles(x1max + x2min >> 1, y1max + y2min >> 1, b.damage, 255, 31, 20);
                } else {
                    collided = false;
                }
                if (!collided) continue;
                Engine.bullets[j] = null;
            }
        } else {
            if (shipDestroyTime == 0 && playerLives < 0) {
                this.deleteGame("shipDestroyTime == 0 && playerLives < 0");
            }
            if (shipDestroyTime >= 192 && this.state == 4) {
                if (playerLives >= 0) {
                    shipBlinkingTime = 512;
                    shipDestroyTime = -1 - lastFrameTime;
                    shipHP = maxShipHP;
                    fShipX = fShipLimitX >> 1;
                    fShipY = fShipLimitY;
                } else {
                    if (!this.isArcade()) {
                        this.nextState = 29;
                        this.highScorePossible = true;
                    } else {
                        this.nextState = 7;
                    }
                    this.setState(13);
                }
            }
            shipDestroyTime += lastFrameTime;
        }
        for (j = 0; j < bulletLast; ++j) {
            Bullet b = bullets[j];
            if (b == null) continue;
            int actX = b.fxAct - fenshift + 128 >> 8;
            int actY = (b.fyAct + 128 >> 8) + ptop;
            int type = b.type;
            if (b.fxAct <= -4096 || b.fxAct >= fpenwidth || actY + bulletHeight[type] <= ptop || actY >= pbottom) {
                if (b.type == 14) continue;
                Engine.bullets[j] = null;
                continue;
            }
            g.setClip(actX, Math.max(actY, ptop), bulletWidth[type], Math.min(bulletHeight[type], pbottom - actY));
            g.drawImage(bulletImages[type], actX - b.actFrame * bulletWidth[type], actY, 20);
        }
        if (shouldDrawShip) {
            if (this.shipWeaponExtra >= 0) {
                int extraGunX = fExtraGunX - fenshift + 128 >> 8;
                int extraGunY = (fExtraGunY >> 8) + ptop;
                g.setClip(0, ptop, this.SCREEN_WIDTH, pheight);
                g.drawImage(bulletImages[15 + this.shipWeaponExtra], extraGunX, extraGunY, 20);
            }
            int actShipX = (fShipX - fenshift + 128 >> 8) + pleft;
            int actShipY = (fShipY + 128 >> 8) + ptop;
            if (shipDestroyTime >= 0) {
                if (shipDestroyTime < 192) {
                    g.setClip(actShipX, Math.max(ptop, actShipY), explSize, Math.min(explSize, pbottom - actShipY));
                    g.drawImage(explosionImages[0], actShipX - (shipDestroyTime >> 5) * explSize, actShipY, 20);
                }
            } else {
                this.ready(g);
                if (shipBlinkingTime < 0 || (shipBlinkingTime & 0x20) == 32) {
                    g.setClip(actShipX, actShipY, shipWidth, shipHeight);
                    g.drawImage(shipImage, actShipX - (shipSlideTime + 16 >> 5) * shipWidth, actShipY, 20);
                    int engineParticleX = actShipX + shipEngineParticleXOffset;
                    int engineParticleY = actShipY + shipEngineParticleYOffset;
                    g.setClip(engineParticleX, engineParticleY, shipEngineParticleXSize, Math.min(shipEngineParticleYSize, pbottom - engineParticleY));
                    if ((this.accFrameTime & 0x10) > 0) {
                        engineParticleX -= shipEngineParticleXSize;
                    }
                    g.drawImage(shipEngineParticleImage, engineParticleX, engineParticleY, 20);
                    if ((shipEngineParticleSpawnTime += lastFrameTime) > 80) {
                        // empty if block
                    }
                }
                if (shipBlinkingTime >= 0) {
                    shipBlinkingTime -= lastFrameTime;
                    this.movePlayer(1, 1, 0);
                }
            }
        }
        for (i = 0; i < particlefTime.length; ++i) {
            int t = particlefTime[i];
            if (t <= 0) continue;
            int px = particlefXPos[i] - fenshift >> 8;
            int py = (particlefYPos[i] >> 8) + ptop;
            g.setClip(px, py, 8, 8);
            g.clipRect(0, ptop, this.SCREEN_WIDTH, pheight);
            g.drawImage(particleImages[i % 5], px - (particleAnimPos[i] & 0xFFF8), py, 20);
            int n = i;
            particleAnimPos[n] = particleAnimPos[n] + (lastFrameTime >> 1);
            while (particleAnimPos[i] >= 40) {
                int n4 = i;
                particleAnimPos[n4] = particleAnimPos[n4] - 16;
            }
        }
        if (shipFlashTime > 0) {
            int actVal;
            g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
            for (i = 0; i < shipFlashWidth && (actVal = (shipFlashTime << 1) - 16 * i) >= 0; ++i) {
                switch (shipFlashType) {
                    case 1: {
                        g.setColor(255, 0, 0);
                        break;
                    }
                    case 2: {
                        g.setColor(0, 255, 255);
                        break;
                    }
                    case 3: {
                        g.setColor(255, 255, 255);
                    }
                }
                g.fillRect(i, ptop2, 8, shipFlashHeight - 11);
                g.fillRect(this.SCREEN_WIDTH - i - 8, ptop2, 8, shipFlashHeight - 11);
            }
            shipFlashTime -= lastFrameTime;
        }
        if (messageTime > 0) {
            messageTime -= lastFrameTime;
        }
    }

    private int getColor(int color) {
        if (color < 0) {
            return 0;
        }
        if (color > 255) {
            return 255;
        }
        return color;
    }

    private void endGame() {
        this.setState(27);
    }

    public static void writeNumRight(Graphics g, int x, int y, int num) {
        if (num < 0) {
            return;
        }
        do {
            int digit = num % 10;
            g.setClip(x -= numberWidth[digit], y, numberWidth[digit], numberHeight);
            g.drawImage(numberImage, x - numberStart[digit], y, 20);
        } while ((num /= 10) > 0);
    }

    public static void writeShop(Graphics g, int x, int y, int num) {
        if (num < 0) {
            return;
        }
        do {
            int digit = num % 10;
            g.setClip((x -= shopNumberWidth[digit]) - 15, y - 1, shopNumberWidth[digit], shopNumberHeight);
            g.drawImage(shopNumberImage, x - shopNumberStart[digit] - 15, y - 1, 20);
        } while ((num /= 10) > 0);
    }

    public static void writeNumLeft(Graphics g, int x, int y, int num) {
        if (num < 0) {
            return;
        }
        byte[] digits = new byte[10];
        int p = -1;
        do {
            digits[++p] = (byte)(num % 10);
        } while ((num /= 10) > 0);
        while (p >= 0) {
            byte digit = digits[p];
            g.setClip(x, y, numberWidth[digit], numberHeight);
            g.drawImage(numberImage, x - numberStart[digit], y, 20);
            x += numberWidth[digit];
            --p;
        }
    }

    private int getCharIndex(char c) {
        for (int i = 0; i < fontChar.length; ++i) {
            if (fontChar[i] != c) continue;
            return i;
        }
        this.error("UNKNOWN CHAR AT GETCHARINDEX: " + c + "(" + (byte)c + ")", null);
        return 0;
    }

    private int getStringWidth(String s) {
        int len = s.length();
        int width = 0;
        for (int i = 0; i < len; ++i) {
            int ind = this.getCharIndex(s.charAt(i));
            width += fontWidth[ind] - 1;
        }
        return width;
    }

    private int getNextLine(String s, int index, int swidth) {
        int len = s.length();
        int width = 0;
        int lastWordEnd = index;
        int ind = 0;
        char ch = '\u0000';
        for (int i = index; i < len; ++i) {
            ch = s.charAt(i);
            if (ch == '\\') {
                return i + 1;
            }
            if (ch == ' ') {
                lastWordEnd = i;
            }
            if ((width += fontWidth[ind = this.getCharIndex(ch)] - 1) <= swidth) continue;
            return lastWordEnd;
        }
        return len;
    }

    private void writeStringLeft(Graphics g, int x, int y, String s) {
        g.setClip(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            int ind = this.getCharIndex(s.charAt(i));
            int fwidth = fontWidth[ind];
            if (fwidth + x >= 0 && x < this.SCREEN_WIDTH) {
                g.setClip(x, y, fwidth, fontHeight);
                g.drawImage(fontImage, x - fontStart[ind], y, 20);
            }
            x += fwidth - 1;
        }
    }

    private void writeStringCentered(Graphics g, int x, int y, String s) {
        this.writeStringLeft(g, x - (this.getStringWidth(s) >> 1), y, s);
    }

    private void writeStringRight(Graphics g, int x, int y, String s) {
        this.writeStringLeft(g, x - this.getStringWidth(s), y, s);
    }

    private int ehSize() {
        return this.ehLast - this.ehFirst;
    }

    private Event ehNext() {
        if (this.ehFirst == this.ehLast) {
            return null;
        }
        Event ret = this.ehie[this.ehFirst & 0xF];
        this.ehie[this.ehFirst & 0xF] = null;
        ++this.ehFirst;
        return ret;
    }

    private void ehAdd(Event e) {
        if (this.ehLast >= 16 && this.ehFirst >= 16) {
            this.ehLast &= 0xF;
            this.ehFirst &= 0xF;
        }
        this.ehie[this.ehLast & 0xF] = e;
        ++this.ehLast;
    }

    private Event ehSearch(int key) {
        for (int i = this.ehFirst; i < this.ehLast; ++i) {
            int j = i & 0xF;
            if (this.ehie[j] == null || this.ehie[j].key != key || this.ehie[j].length >= 0) continue;
            return this.ehie[j];
        }
        return null;
    }

    private void ehRemove(int key) {
        for (int i = this.ehFirst; i < this.ehLast; ++i) {
            int j = i & 0xF;
            if (this.ehie[j] == null || this.ehie[j].key != key) continue;
            this.ehie[j] = null;
        }
    }

    public void keyPressed(int i) {
        int time = (int)(System.currentTimeMillis() - levelStartTime);
        int key = i;
        key = i == -6 || i == 42 ? -6 : (i == 52 ? 2 : (i == 53 ? 8 : (i == -7 || i == 35 ? -7 : (i == 54 ? 5 : (i == 50 ? 1 : (i == 56 ? 6 : this.getGameAction(i)))))));
        block0 : switch (this.state) {
            case 4: {
                if (key == 2) {
                    Engine.gombok[0] = true;
                }
                if (key == 5) {
                    Engine.gombok[1] = true;
                }
                if (key == 1) {
                    Engine.gombok[2] = true;
                }
                if (key == 6) {
                    Engine.gombok[3] = true;
                }
                if (key == -7) break;
                if (key == -6 && this.state == 4) {
                    this.ehFirst = this.ehLast;
                    this.setState(32);
                    break;
                }
                Event nie = new Event();
                nie.start = time;
                nie.key = key;
                this.ehAdd(nie);
                break;
            }
            case 32: {
                if (key == -6) {
                    if (!this.isArcade()) {
                        this.score = this.restartScore;
                        this.shipWeaponFront = this.restartShipWeaponFront;
                        this.shipWeaponBack = this.restartShipWeaponBack;
                        this.shipWeaponShield = this.restartShipWeaponShield;
                        this.shipWeaponExtra = this.restartShipWeaponExtra;
                    }
                    this.setState(13);
                    this.nextState = 7;
                }
                if (key != -7) break;
                this.setState(4);
                break;
            }
            case 36: {
                if (key == -6) {
                    this.setState(105);
                    this.nextState = 104;
                    break;
                }
                if (key != -7) break;
                menuParent = 0;
                this.setMenu(5, "soft right");
                this.setState(2);
                break;
            }
            case 102: {
                if (key == -6) {
                    this.score = this.restartScore;
                    this.shipWeaponFront = this.restartShipWeaponFront;
                    this.shipWeaponBack = this.restartShipWeaponBack;
                    this.shipWeaponShield = this.restartShipWeaponShield;
                    this.shipWeaponExtra = this.restartShipWeaponExtra;
                    this.initLevel();
                    this.setState(106);
                    break;
                }
                if (key != -7) break;
                this.setState(2);
                break;
            }
            case 2: 
            case 11: {
                if (key != 0) {
                    this.moveMenu(key);
                    break;
                }
                this.moveMenu(i);
                break;
            }
            case 34: {
                if (key == -6) {
                    accMenuTime = 0;
                    if (this.isArcade()) {
                        this.setMenu(5, "back to menu in arcademode");
                    }
                    this.setState(101);
                    break;
                }
                if ((key == -7 || key == 8) && chapterScrollDelta == 0) {
                    int index = this.getLevelImageIndex(this.selectedChapter);
                    if (index != 0) break;
                    levelNum = this.selectedChapter;
                    if (this.isArcade()) {
                        this.score = this.getScore();
                    }
                    this.setState(35);
                    break;
                }
                if (key == 2 && (this.selectedChapter > 0 || chapterBigImageX < 0)) {
                    chapterScrollDelta = 1;
                    break;
                }
                if (key != 5 || this.selectedChapter >= 9 && chapterBigImageX <= 0) break;
                chapterScrollDelta = -1;
                break;
            }
            case 28: {
                switch (key) {
                    case -7: 
                    case -6: 
                    case 8: 
                    case 53: {
                        accMenuTime = 2000;
                    }
                }
                break;
            }
            case 19: {
                switch (key) {
                    case -7: 
                    case -6: 
                    case 8: 
                    case 53: {
                        if (editingHighScore >= 0) {
                            HighScoreItem item = HighScores.getInsctance().get(editingHighScore);
                            item.setName(new String(editingName));
                            HighScores.getInsctance().save();
                        }
                        this.setMenu(5, "STATE_SCORES_TO_MENU");
                        this.setState(20);
                        accMenuTime = 0;
                        break block0;
                    }
                }
                if (editingHighScore < 0) break;
                switch (key) {
                    case 2: {
                        int actChar = this.getCharIndex(editingName[editingHighScorePos]);
                        actChar = actChar == 0 ? fontChar.length - 1 : --actChar;
                        Engine.editingName[Engine.editingHighScorePos] = fontChar[actChar];
                        break;
                    }
                    case 5: {
                        int actChar = this.getCharIndex(editingName[editingHighScorePos]);
                        if (++actChar >= fontChar.length) {
                            actChar -= fontChar.length;
                        }
                        Engine.editingName[Engine.editingHighScorePos] = fontChar[actChar];
                        break;
                    }
                    case 6: {
                        if (editingHighScorePos <= 0) break;
                        --editingHighScorePos;
                        break;
                    }
                    case 1: {
                        if (editingHighScorePos >= 8) break;
                        ++editingHighScorePos;
                    }
                }
                break;
            }
            case 22: {
                if (key == 2 || key == -6) {
                    if (actStoryPage <= 0) break;
                    prevStoryPage = actStoryPage--;
                    accMenuTime = 0;
                    break;
                }
                if (key == 5 || key == -7) {
                    if (actStoryPage >= lastStoryPage) break;
                    prevStoryPage = actStoryPage++;
                    accMenuTime = 0;
                    break;
                }
                if (key != 8 && key != -7) break;
                this.leaveStory();
                accMenuTime = 0;
            }
        }
    }

    private void leaveStory() {
        if (levelNum == this.getAbsoluteMaxLevel() && !this.isArcade()) {
            this.deleteGame("leaveStory");
            this.setState(103);
            this.highScorePossible = true;
        } else if (actStory == storyBeforeLevel[levelNum]) {
            this.setState(24);
        } else {
            this.setState(26);
        }
    }

    public void keyRepeated(int i) {
        if (this.state == 2 || this.state == 11) {
            this.moveMenu(this.getGameAction(i));
        }
    }

    public void keyReleased(int i) {
        if (this.state == 4 || this.state == 12 || this.state == 3) {
            Event eie;
            int time = (int)(System.currentTimeMillis() - levelStartTime);
            int key = i;
            key = i == -6 || i == 42 ? -6 : (i == 52 ? 2 : (i == 53 ? 8 : (i == -7 || i == 35 ? -7 : (i == 54 ? 5 : (i == 50 ? 1 : (i == 56 ? 6 : this.getGameAction(i)))))));
            if (key == 2) {
                Engine.gombok[0] = false;
            }
            if (key == 5) {
                Engine.gombok[1] = false;
            }
            if (key == 1) {
                Engine.gombok[2] = false;
            }
            if (key == 6) {
                Engine.gombok[3] = false;
            }
            if ((eie = this.ehSearch(key)) != null) {
                eie.length = time - eie.start;
            }
        }
    }

    protected void hideNotify() {
        super.hideNotify();
        this.stop();
        if (this.state == 4) {
            this.setState(32);
        }
    }

    protected void showNotify() {
        super.showNotify();
        this.start();
    }

    protected void error(String message, Throwable t) {
        if (this.error) {
            return;
        }
        this.error = true;
        this.stop();
        System.err.println("Error: " + message);
        if (t != null) {
            t.printStackTrace();
        }
        Alert alert = new Alert("Error", message + ":\n" + t, null, AlertType.ERROR);
        alert.setTimeout(-2);
        Display.getDisplay((MIDlet)Main.getInstance()).setCurrent((Displayable)alert);
    }

    protected void warning(String message) {
    }

    static {
        numberWidth = new int[]{10, 8, 10, 10, 10, 10, 10, 10, 10, 10};
        fontWidth = new int[]{7, 13, 11, 11, 12, 10, 10, 12, 12, 8, 9, 11, 10, 14, 12, 13, 11, 13, 11, 10, 12, 12, 13, 18, 12, 12, 10, 4, 6, 4, 9, 4, 5, 7, 9, 6, 9, 10, 8, 11, 10, 11, 10, 10, 10, 11, 10, 13, 10, 8, 13, 13, 13, 12, 12, 12, 13, 10, 13, 12, 11, 13, 10, 8, 13, 13, 10, 7, 8, 0};
        maxShipHP = 100;
        shipWeaponExtraLeft = false;
        language = true;
        gombok = new boolean[]{false, false, false, false};
        ngage = false;
        gameend = false;
        figyel = 0L;
        enemyImages = new Image[32];
        enWidth = new int[32];
        enHeight = new int[32];
        fenWidth = new int[32];
        fenHeight = new int[32];
        enExpl = new int[]{2, 2, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        enBegin = 0;
        bulletImages = new Image[38];
        bulletHeight = new int[38];
        bulletWidth = new int[38];
        fBulletHeight = new int[38];
        fBulletWidth = new int[38];
        bullets = new Bullet[64];
        bulletLast = 0;
        topause = 0;
        tothread = 0;
        weaponPrice = new int[]{1000, 1700, 4800, 1300, 2700, 6600, 4600, 7600, 11000, 7000, 9500, 0, 1000, 1300, 2200, 4700, 5700, 9200, 4500, 6400, 9500};
        bulletFrameNum = new int[]{1, 3, 2, 2, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 3, 3, 1, 1};
        fontChar = new char[]{' ', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '.', ',', '!', '?', ':', ';', '-', '/', '\"', '\'', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '_', '@', '\ufffd', '=', '~', '#', '$', '%', '^', '&', '+', '*', 'A', 'B', '\\'};
        fontStart = new int[fontChar.length];
        numberStart = new int[10];
        shopNumberStart = new int[10];
        chapterBigImageIndices = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 1};
        menu = new int[]{0, 1, 2, 3, 4, 5, 6, 52, 7, 8, 9, 11, -1, 8, -1, 13, 14, 15, 16, 8, 17, 18, 19, 20, 8, 21, 22, 23, 24, 8, 25, 8, -1, -1, -1, 13, 14, 15, 8, -1, -1};
        menuJump = new int[]{5, 30, -1, -1, -1, 35, 10, 35, -1, 0, -1, 20, -1, 5, -1, -1, -1, -1, -1, 10, 25, 25, 25, 25, 10, -1, -1, -1, -1, 20, 0, 0, -1, -1, -1, 10, 10, 10, 5, -1};
        menuHelp = new int[]{-1, -1, -1, -1, -1, 1, 2, 3, -1, -1, 5, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 4, -1, -1, -1, -1};
        entypes = null;
        messageTime = -1;
        shipBlinkingTime = -1;
        random = new Random();
        shipFlashTime = -1;
        shipFlashType = -1;
        levelNum = 0;
        shieldBulletIndex = new int[2];
        storyPageIndex = new int[32];
        actStory = 43;
        actStoryPage = 0;
        prevStoryPage = 0;
        lastStoryPage = Integer.MAX_VALUE;
        prevMainEnemyHP = -1;
        mainEnemy = null;
        scrollLevel = true;
        meDestroyTime = null;
        meDestroyX = null;
        meDestroyY = null;
        mainEnemyDualLeft = false;
        mainEnemyFront = 0;
        playerLives = 2;
        storyBeforeLevel = new int[]{0, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        storyAfterLevel = new int[]{-1, -1, 1, -1, -1, 2, -1, -1, 3, 4};
        shouldDrawShip = true;
        TT = System.getProperty("microedition.platform").substring(0, 3).toUpperCase();
        INSTANCE = new Engine();
        isRunning = false;
        WEAPONS_FRONT = new int[]{0, 1, 3, 4, 2, 5, 6, 7, 9, 10, 8};
        WEAPONS_BACK = new int[]{12, 13, 14, 15};
        WEAPONS_SHIELD = new int[]{0, 1};
        WEAPONS_EXTRA = new int[]{0, 1, 2};
        WEAPONS = new int[][]{WEAPONS_FRONT, WEAPONS_BACK, WEAPONS_SHIELD, WEAPONS_EXTRA};
        AVAILABLE_WEAPONS = new int[][]{{0, 1, 3, 3, 4, 6, 8, 9, 10}, {-1, 0, 1, 1, 2, 2, 2, 3, 3}, {-1, -1, -1, -1, -1, 0, 0, 0, 1}, {-1, -1, -1, 1, 1, 1, 1, 2}};
        MAX_SCORES = new int[]{0, 2000, 4500, 7500, 10500, 14500, 19000, 24000, 29000, 34000};
        WEAPONS_NEW_FRONT = new int[][]{new int[0], {1}, {3, 4}, new int[0], {2}, {5, 6}, {7, 9}, {10}, {8}};
        WEAPONS_NEW_BACK = new int[][]{new int[0], {12}, {13}, new int[0], {14}, new int[0], new int[0], {15}};
        WEAPONS_NEW_SHIELD = new int[][]{new int[0], new int[0], new int[0], new int[0], new int[0], {0}, new int[0], new int[0], {1}};
        WEAPONS_NEW_EXTRA = new int[][]{new int[0], new int[0], new int[0], {0, 1}, new int[0], new int[0], new int[0], {2}, new int[0]};
        WEAPONS_NEW = new int[][][]{WEAPONS_NEW_FRONT, WEAPONS_NEW_BACK, WEAPONS_NEW_SHIELD, WEAPONS_NEW_EXTRA};
        editingHighScore = -1;
        editingHighScorePos = 0;
        storyImages = null;
        storyBG = null;
    }
}

