/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Image;

final class Player {
    static final byte FACE_DOWN = 0;
    static final byte FACE_LEFT = 1;
    static final byte FACE_RIGHT = 3;
    static final byte FACE_UP = 2;
    static final byte MODE_DEAD = 2;
    static final byte MODE_DYING = 1;
    static final byte MODE_NORMAL = 0;
    static final int NONE = 0;
    static final int[] STEPS = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
    static int bombs;
    static int bonus;
    static byte exCnt;
    static byte extra;
    static int face;
    static boolean fire;
    static boolean fireExtra;
    static boolean fireExtraOnce;
    static boolean fireOnce;
    static int flames;
    static int fx;
    static int fy;
    static GameScreen gameScreen;
    static Image[][] images;
    static Image[] imagesD;
    static int invinc;
    static boolean killedByTouch;
    static int lastFX;
    static int lastFY;
    static int lives;
    static byte mode;
    static boolean moveDown;
    static boolean moveDownOnce;
    static boolean moveLeft;
    static boolean moveLeftOnce;
    static boolean moveRight;
    static boolean moveRightOnce;
    static boolean moveUp;
    static boolean moveUpOnce;
    static Playfield playfield;
    static int points;
    static boolean powerUp;
    static int speed;
    static int startX;
    static int startY;
    static int step;
    static int x;
    static int y;

    static {
        killedByTouch = false;
    }

    Player(GameScreen gameScreen) {
        Player.gameScreen = gameScreen;
    }

    static boolean decode(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            x = dataInputStream.readInt();
            y = dataInputStream.readInt();
            fx = dataInputStream.readInt();
            fy = dataInputStream.readInt();
            face = dataInputStream.readInt();
            step = dataInputStream.readInt();
            startX = dataInputStream.readInt();
            startY = dataInputStream.readInt();
            lastFX = dataInputStream.readInt();
            lastFY = dataInputStream.readInt();
            lives = dataInputStream.readInt();
            bombs = dataInputStream.readInt();
            flames = dataInputStream.readInt();
            speed = dataInputStream.readInt();
            points = dataInputStream.readInt();
            bonus = dataInputStream.readInt();
            invinc = dataInputStream.readInt();
            mode = dataInputStream.readByte();
            extra = dataInputStream.readByte();
            exCnt = dataInputStream.readByte();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static boolean encode(OutputStream outputStream) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(x);
            dataOutputStream.writeInt(y);
            dataOutputStream.writeInt(fx);
            dataOutputStream.writeInt(fy);
            dataOutputStream.writeInt(face);
            dataOutputStream.writeInt(step);
            dataOutputStream.writeInt(startX);
            dataOutputStream.writeInt(startY);
            dataOutputStream.writeInt(lastFX);
            dataOutputStream.writeInt(lastFY);
            dataOutputStream.writeInt(lives);
            dataOutputStream.writeInt(bombs);
            dataOutputStream.writeInt(flames);
            dataOutputStream.writeInt(speed);
            dataOutputStream.writeInt(points);
            dataOutputStream.writeInt(bonus);
            dataOutputStream.writeInt(invinc);
            dataOutputStream.writeByte(mode);
            dataOutputStream.writeByte(extra);
            dataOutputStream.writeByte(exCnt);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static Image getImage() {
        if (mode == 1) {
            return imagesD[step / 5];
        }
        return images[face][step % 2];
    }

    static void givePoints(int n) {
        bonus = 20;
        points += n;
    }

    static void kill(boolean bl) {
        if (invinc > 0) {
            return;
        }
        HALEffects.playSound(2);
        HALEffects.vibrate(0);
        mode = 1;
        step = 0;
        killedByTouch = bl;
        if (!killedByTouch) {
            Playfield.firetype[Player.y / Playfield.TILESIZE][Player.x / Playfield.TILESIZE] = 38;
        }
    }

    static void loadImages() {
        int n;
        if (images == null) {
            images = new Image[4][2];
            n = 0;
            while (n < 4) {
                int n2 = 0;
                while (n2 < 2) {
                    Player.images[n][n2] = ReadPackage.getImage("aikia" + n + "" + n2);
                    ++n2;
                }
                ++n;
            }
        }
        if (imagesD == null) {
            imagesD = new Image[4];
            n = 0;
            while (n < 4) {
                Player.imagesD[n] = ReadPackage.getImage("die" + (1 + n));
                ++n;
            }
        }
    }

    static void reset() {
        points = 0;
        startX = 0;
        startY = 0;
        lives = 3;
        bombs = 3;
        flames = 2;
        speed = 6;
        extra = (byte)28;
        exCnt = (byte)2;
        Player.resetPos();
    }

    static void resetPos() {
        x = startX;
        y = startY;
        fx = lastFX = playfield.getGridX(x);
        fy = lastFY = playfield.getGridY(y);
        face = 0;
        step = 0;
        speed = 6;
        mode = 0;
        powerUp = false;
        fireExtra = false;
        fire = false;
        moveRight = false;
        moveLeft = false;
        moveDown = false;
        moveUp = false;
        fireExtraOnce = false;
        fireOnce = false;
        moveRightOnce = false;
        moveLeftOnce = false;
        moveDownOnce = false;
        moveUpOnce = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void update() {
        int n;
        block60: {
            block62: {
                block61: {
                    block59: {
                        if (mode == 2) {
                            Player.gameScreen.mode = 5;
                            return;
                        }
                        if (mode == 1) {
                            if (++step == 20) {
                                if (--lives > 0) {
                                    extra = 0;
                                    exCnt = 0;
                                    Playfield.trace[Player.fy][Player.fx] = -1;
                                    Player.resetPos();
                                    invinc = 40;
                                } else {
                                    mode = (byte)2;
                                    Player.gameScreen.mode = 5;
                                }
                            }
                            return;
                        }
                        if (invinc > 0) {
                            --invinc;
                        }
                        n = Playfield.TILESIZE / 2;
                        fx = playfield.getGridX(x + n);
                        fy = playfield.getGridY(y + n);
                        int n2 = (x + n) % Playfield.TILESIZE;
                        int n3 = (y + n) % Playfield.TILESIZE;
                        boolean bl = false;
                        byte by = playfield.passThrough(fx, fy, true);
                        if (by == 31 && flames < 7) {
                            ++flames;
                        } else if (by == 30 && bombs < 7) {
                            ++bombs;
                        } else if (by == 11) {
                            gameScreen.levelClear();
                        } else if (by == 10) {
                            if (!Player.gameScreen.godmode) {
                                Player.kill(false);
                            }
                        } else if (by == 37) {
                            Player.givePoints(50);
                        } else if (by >= 32 && by <= 35) {
                            if (extra == by) {
                                exCnt = (byte)(exCnt + 3);
                            } else {
                                exCnt = (byte)3;
                                extra = (byte)(by - 6);
                            }
                        }
                        if (powerUp) {
                            ++bombs;
                            ++flames;
                            powerUp = false;
                        }
                        GameScreen gameScreen = GameScreen.instance;
                        synchronized (gameScreen) {
                            if (moveDown || moveDownOnce) {
                                face = 0;
                                moveDownOnce = false;
                                moveUpOnce = false;
                                moveLeftOnce = false;
                                moveRightOnce = false;
                                if (n2 == n && n3 < n) {
                                    y += Math.min(speed, n - n3);
                                    bl = true;
                                } else if (playfield.isPassable(fx, fy + 1, -2)) {
                                    if (n2 == n) {
                                        y += speed;
                                    } else {
                                        x = n2 > n ? (x -= Math.min(speed, n2 - n)) : (x += Math.min(speed, n - n2));
                                    }
                                    bl = true;
                                }
                            } else if (moveUp || moveUpOnce) {
                                face = 2;
                                moveDownOnce = false;
                                moveUpOnce = false;
                                moveLeftOnce = false;
                                moveRightOnce = false;
                                if (n2 == n && n3 > n) {
                                    y -= Math.min(speed, n3 - n);
                                    bl = true;
                                } else if (playfield.isPassable(fx, fy - 1, -2)) {
                                    if (n2 == n) {
                                        y -= speed;
                                    } else {
                                        x = n2 > n ? (x -= Math.min(speed, n2 - n)) : (x += Math.min(speed, n - n2));
                                    }
                                    bl = true;
                                }
                            }
                            if (moveRight || moveRightOnce) {
                                face = 3;
                                moveDownOnce = false;
                                moveUpOnce = false;
                                moveLeftOnce = false;
                                moveRightOnce = false;
                                if (n3 == n && n2 < n) {
                                    x += Math.min(speed, n - n2);
                                    bl = true;
                                } else if (playfield.isPassable(fx + 1, fy, -2)) {
                                    if (n3 == n) {
                                        x += speed;
                                    } else {
                                        y = n3 > n ? (y -= Math.min(speed, n3 - n)) : (y += Math.min(speed, n - n3));
                                    }
                                    bl = true;
                                }
                            } else if (moveLeft || moveLeftOnce) {
                                face = 1;
                                moveDownOnce = false;
                                moveUpOnce = false;
                                moveLeftOnce = false;
                                moveRightOnce = false;
                                if (n3 == n && n2 > n) {
                                    x -= Math.min(speed, n2 - n);
                                    bl = true;
                                } else if (playfield.isPassable(fx - 1, fy, -2)) {
                                    if (n3 == n) {
                                        x -= speed;
                                    } else {
                                        y = n3 > n ? (y -= Math.min(speed, n3 - n)) : (y += Math.min(speed, n - n3));
                                    }
                                    bl = true;
                                }
                            }
                        }
                        if (bl && ++step == 8) {
                            step = 0;
                        }
                        if (!fire && !fireOnce) break block59;
                        playfield.setBomb((byte)25, fx, fy, 32);
                        fireOnce = false;
                        break block60;
                    }
                    if (!fireExtra && !fireExtraOnce) break block60;
                    if (extra == 27) break block61;
                    if (extra == 26) break block61;
                    if (extra == 28) break block61;
                    if (extra != 29) break block62;
                }
                if (playfield.setBomb(extra, fx, fy, 32)) {
                    exCnt = (byte)(exCnt - 1);
                }
                if (exCnt == 0) {
                    extra = 0;
                }
            }
            fireExtraOnce = false;
        }
        fx = playfield.getGridX(x + n);
        fy = playfield.getGridY(y + n);
        if (fx != lastFX) {
            int n4 = Playfield.trace[Player.lastFY][Player.lastFX] = lastFX < fx ? 3 : 1;
        }
        if (fy != lastFY) {
            Playfield.trace[Player.lastFY][Player.lastFX] = lastFY < fy ? 0 : 2;
        }
        lastFX = fx;
        lastFY = fy;
    }
}

