/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class Playfield {
    static final byte BOMB = 25;
    static final byte BRANCHBOMB = 28;
    static final byte BRICK = 11;
    static final byte CHEST = 22;
    static final byte CLOSED_DOOR = 13;
    static final byte EFF_BURN = 10;
    static final byte EFF_EXIT = 11;
    static final byte EFF_NONE = 0;
    static final byte EMPTY = 0;
    private static final byte _$1971 = 4;
    private static final byte _$1968 = 0;
    private static final byte _$1970 = 3;
    static final byte FIRE_STRAIGHT = 1;
    static final byte FLAME = 23;
    static final byte FLAME2 = 38;
    static final byte GOLD = 37;
    static final byte HUGEBOMB = 29;
    static final byte OBJECTIVE_CLEAN = 2;
    static final byte OBJECTIVE_COLLECT = 1;
    static final byte OBJECTIVE_NONE = 0;
    static final byte OPEN_DOOR = 14;
    static final byte POWERBOMB = 27;
    static final byte POWERUP = 36;
    static final byte POWER_BOMB = 30;
    private static final byte _$1964 = 34;
    static final byte POWER_FLAME = 31;
    static final byte POWER_HUGEBOMB = 35;
    private static final byte _$1963 = 33;
    static final byte POWER_RINGBOMB = 32;
    static final byte RINGBOMB = 26;
    static final byte ROAD1 = 1;
    static final byte ROAD2 = 2;
    static final byte ROAD3 = 3;
    static final byte ROAD4 = 4;
    static final byte ROAD5 = 5;
    static final byte ROAD6 = 6;
    static final byte ROAD7 = 7;
    static final byte ROAD8 = 8;
    static final byte ROAD9 = 9;
    static final byte ROCK = 12;
    static final byte SGATEH_CLOSED = 20;
    static final byte SGATEH_OPEN = 21;
    static final byte SGATEV_CLOSED = 18;
    static final byte SGATEV_OPEN = 19;
    static final byte SPAWNER = 15;
    private static final int _$1967 = 120;
    static final byte SWITCH_OFF = 16;
    static final byte SWITCH_ON = 17;
    static int TILESIZE = 16;
    static final byte TREASURE = 24;
    static final byte WALL = 10;
    static Image[] allImages;
    static int bombs;
    static Image[] chfireImages;
    static byte[][] cnt;
    static int drawHeight;
    static int drawWidth;
    static Enemies enemies;
    static Image[] fireImages;
    static byte[][] firemap;
    private static Fire[] _$1980;
    static byte[][] firetype;
    static int firstEmpty;
    static byte[][] grid;
    static int height;
    static Image[] iceImages;
    static Image[] iceImages2;
    static Image[] icons;
    private static String _$1976;
    static int levCount;
    private static int _$1975;
    static boolean levelClear;
    static String levelName;
    static byte levelObjective;
    private static String[] _$1978;
    static int nextSwitchActivationId;
    private static final int _$1972 = 28;
    static byte[][] occ;
    static int pAnim;
    static boolean[] passableTiles;
    static Player player;
    static int switchActivationId;
    static byte[][] trace;
    static int width;

    static {
        levCount = 0;
        passableTiles = new boolean[]{true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, false, false, false, true, false, true, true, true, true, true, false, false, false, false, false, true, true, true, true, true, true, true, true};
    }

    Playfield(int n, int n2) {
        this._$1994();
        width = n;
        height = n2;
        this._$1995(n, n2);
        _$1980 = new Fire[28];
        int n3 = 0;
        while (n3 < 28) {
            Playfield._$1980[n3] = new Fire();
            ++n3;
        }
        this._$1996();
        pAnim = 0;
    }

    private void _$1994() {
        try {
            InputStream inputStream = ((Object)((Object)GameMidlet.instance)).getClass().getResourceAsStream("/levels.txt");
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            char[] cArray = new char[1000];
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            levCount = 1;
            while (n2 < levCount) {
                n = ((Reader)inputStreamReader).read(cArray, n4, 1000 - n4);
                if (n != -1) {
                    n4 += n;
                }
                n6 = n3;
                while (n6 < n4 && cArray[n6] != '\n') {
                    ++n6;
                }
                n5 = n6 - 1;
                String string = new String(cArray, n3, n5 - n3);
                n3 = 0;
                n5 += 2;
                while (n5 < n4) {
                    cArray[n3] = cArray[n5];
                    ++n3;
                    ++n5;
                }
                n4 = n3;
                n3 = 0;
                if (bl) {
                    bl = false;
                    levCount = Integer.parseInt(string);
                    _$1978 = new String[levCount];
                    continue;
                }
                Playfield._$1978[n2++] = string;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception in ReadLevels: ");
            exception.printStackTrace();
        }
    }

    int addFire(byte by, int n, int n2, int n3, int n4, byte by2) {
        int n5 = firstEmpty;
        while (n5 < 28) {
            if (Playfield._$1980[n5].type == 0) break;
            ++n5;
        }
        if (n5 == 28) {
            return -1;
        }
        Playfield._$1980[n5].type = by;
        Playfield._$1980[n5].x = n;
        Playfield._$1980[n5].y = n2;
        Playfield._$1980[n5].xsp = n3;
        Playfield._$1980[n5].ysp = n4;
        Playfield._$1980[n5].cnt = by2;
        firstEmpty = n5;
        return n5;
    }

    int getGridX(int n) {
        return n / TILESIZE;
    }

    int getGridY(int n) {
        return n / TILESIZE;
    }

    boolean isBomb(int n, int n2) {
        block3: {
            block2: {
                if (n < 0) break block2;
                if (n >= width || n2 < 0) break block2;
                if (n2 < height) break block3;
            }
            return false;
        }
        return firetype[n2][n] > 23;
    }

    boolean isOccupied(int n, int n2) {
        return occ[n2][n] != 0;
    }

    boolean isPassable(int n, int n2, int n3) {
        block5: {
            block4: {
                if (n < 0) break block4;
                if (n >= width || n2 < 0) break block4;
                if (n2 < height) break block5;
            }
            return false;
        }
        if (firetype[n2][n] > 23) {
            return false;
        }
        return passableTiles[grid[n2][n]];
    }

    static void loadImages() {
        if (allImages == null) {
            allImages = new Image[45];
            Playfield.allImages[0] = ReadPackage.getImage("grass1");
            TILESIZE = allImages[0].getHeight();
            Playfield.allImages[10] = ReadPackage.getImage("mountain");
            Playfield.allImages[11] = ReadPackage.getImage("tree2");
            Playfield.allImages[13] = ReadPackage.getImage("door1");
            Playfield.allImages[14] = ReadPackage.getImage("door2");
            Playfield.allImages[12] = ReadPackage.getImage("tree1");
            Playfield.allImages[16] = ReadPackage.getImage("switch1");
            Playfield.allImages[17] = ReadPackage.getImage("switch2");
            Playfield.allImages[18] = ReadPackage.getImage("sgate0");
            Playfield.allImages[19] = ReadPackage.getImage("sgate1");
            Playfield.allImages[20] = ReadPackage.getImage("sgate2");
            Playfield.allImages[21] = ReadPackage.getImage("sgate3");
            Playfield.allImages[22] = ReadPackage.getImage("chest");
            Playfield.allImages[1] = ReadPackage.getImage("road1");
            Playfield.allImages[2] = ReadPackage.getImage("road2");
            Playfield.allImages[3] = allImages[0];
            Playfield.allImages[4] = allImages[0];
            Playfield.allImages[5] = allImages[0];
            Playfield.allImages[6] = allImages[0];
            Playfield.allImages[7] = allImages[0];
            Playfield.allImages[8] = allImages[0];
            Playfield.allImages[9] = allImages[0];
            Playfield.allImages[24] = ReadPackage.getImage("treasure");
            Playfield.allImages[30] = ReadPackage.getImage("poweri1");
            Playfield.allImages[31] = ReadPackage.getImage("poweri2");
            Playfield.allImages[32] = ReadPackage.getImage("poweri4");
            Playfield.allImages[33] = ReadPackage.getImage("poweri5");
            Playfield.allImages[34] = ReadPackage.getImage("poweri6");
            Playfield.allImages[35] = ReadPackage.getImage("poweri7");
            Playfield.allImages[23] = null;
            Playfield.allImages[36] = ReadPackage.getImage("power0");
            Playfield.allImages[37] = ReadPackage.getImage("power1");
            Playfield.allImages[38] = ReadPackage.getImage("power2");
        }
        if (iceImages == null) {
            iceImages = new Image[4];
            iceImages2 = new Image[6];
            Playfield.iceImages2[0] = ReadPackage.getImage("w5");
            Playfield.iceImages2[1] = ReadPackage.getImage("w4");
            Playfield.iceImages2[2] = ReadPackage.getImage("w2");
            Playfield.iceImages2[3] = ReadPackage.getImage("w1");
            Playfield.iceImages2[4] = ReadPackage.getImage("w3");
            Playfield.iceImages2[5] = ReadPackage.getImage("w6");
            Playfield.iceImages[0] = ReadPackage.getImage("w6");
            Playfield.iceImages[1] = ReadPackage.getImage("w5");
            Playfield.iceImages[2] = ReadPackage.getImage("w4");
            Playfield.iceImages[3] = ReadPackage.getImage("w5");
        }
        if (fireImages == null) {
            fireImages = new Image[2];
            Playfield.fireImages[0] = ReadPackage.getImage("fire1");
            Playfield.fireImages[1] = ReadPackage.getImage("fire2");
        }
        if (chfireImages == null) {
            chfireImages = new Image[2];
            Playfield.chfireImages[0] = ReadPackage.getImage("chestf1");
            Playfield.chfireImages[1] = ReadPackage.getImage("chestf2");
        }
        if (icons == null) {
            icons = new Image[4];
            int n = 0;
            while (n < 12) {
                if (n < icons.length) {
                    Playfield.icons[n] = ReadPackage.getImage("icon" + (n + 1));
                }
                ++n;
            }
        }
    }

    void loadLevel(int n) {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            if (--n >= _$1978.length) {
                n = _$1978.length - 1;
            }
            this._$2001(_$1978[n]);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n5 = this._$2002()) != 59) {
                stringBuffer.append((char)n5);
            }
            width = Integer.parseInt(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while ((n5 = this._$2002()) != 59) {
                stringBuffer.append((char)n5);
            }
            height = Integer.parseInt(stringBuffer.toString());
            levelName = "";
            while ((n5 = this._$2002()) != 59) {
                levelName = levelName + (char)n5;
            }
            this._$1995(width, height);
            levelObjective = (byte)2;
            int n6 = 0;
            while (n6 < height) {
                n4 = 0;
                while (n4 < width) {
                    Playfield.grid[n6][n4] = (byte)((byte)this._$2002() - 65);
                    Playfield.trace[n6][n4] = -1;
                    Playfield.firemap[n6][n4] = 0;
                    Playfield.firetype[n6][n4] = 0;
                    if (grid[n6][n4] == 14) {
                        levelObjective = 0;
                    }
                    ++n4;
                }
                ++n6;
            }
            enemies.reset();
            n4 = this._$2002();
            if (n4 == 77) {
                n3 = 1;
                while (n3 != 0) {
                    stringBuffer = new StringBuffer();
                    while ((n5 = this._$2002()) != 59) {
                        if (n5 == 77) {
                            n3 = 0;
                            break;
                        }
                        stringBuffer.append((char)n5);
                    }
                    if (n3 == 0) continue;
                    enemies.decode(stringBuffer.toString());
                }
                n4 = this._$2002();
            }
            if (n4 == 84) {
                n3 = 1;
                n2 = 1;
                while (n3 != 0) {
                    stringBuffer = new StringBuffer();
                    while ((n5 = this._$2002()) != 59) {
                        if (n5 == 84) {
                            n3 = 0;
                            break;
                        }
                        stringBuffer.append((char)n5);
                    }
                    if (n3 == 0) break;
                    String string = stringBuffer.toString();
                    try {
                        int n7;
                        int n8;
                        int n9;
                        int n10;
                        if (string.charAt(0) == 's') {
                            string = string.substring(1);
                            n10 = string.indexOf(44);
                            int n11 = string.indexOf(58);
                            int n12 = 0;
                            int n13 = Integer.parseInt(string.substring(0, n10));
                            n9 = Integer.parseInt(string.substring(n10 + 1, n11));
                            while (n12 != string.length()) {
                                n10 = string.indexOf(44, n11 + 1);
                                n12 = string.indexOf(44, n10 + 1);
                                if (n12 == -1) {
                                    n12 = string.length();
                                }
                                n8 = Integer.parseInt(string.substring(n11 + 1, n10));
                                n7 = Integer.parseInt(string.substring(n10 + 1, n12));
                                n11 = n12;
                                byte[] byArray = cnt[n7];
                                int n14 = n8;
                                byArray[n14] = (byte)(byArray[n14] + n2);
                            }
                            Playfield.cnt[n9][n13] = n2;
                            n2 = (byte)(n2 * 2);
                            continue;
                        }
                        if (string.charAt(0) != 'c') continue;
                        n7 = string.indexOf(44);
                        n10 = string.indexOf(58);
                        int n15 = Integer.parseInt(string.substring(1, n7));
                        n9 = Integer.parseInt(string.substring(n7 + 1, n10));
                        n8 = Integer.parseInt(string.substring(n10 + 1));
                        Playfield.cnt[n9][n15] = (byte)n8;
                    }
                    catch (Exception exception) {
                        System.err.println("Playfield.loadlevel");
                        exception.printStackTrace();
                    }
                }
            }
            n3 = 0;
            while (n3 < height) {
                n2 = 0;
                while (n2 < width) {
                    if (grid[n3][n2] == 10) {
                        int n16 = 0;
                        if (n3 < height - 1 && grid[n3 + 1][n2] == 10) {
                            n16 = (byte)(n16 + 1);
                        }
                        if (n2 > 0 && grid[n3][n2 - 1] == 10) {
                            n16 = (byte)(n16 + 2);
                        }
                        if (n3 > 0 && grid[n3 - 1][n2] == 10) {
                            n16 = (byte)(n16 + 4);
                        }
                        if (n2 < width - 1 && grid[n3][n2 + 1] == 10) {
                            n16 = (byte)(n16 + 8);
                        }
                        Playfield.cnt[n3][n2] = n16;
                    }
                    ++n2;
                }
                ++n3;
            }
            player.resetPos();
            levelClear = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Playfield.loadlevel2");
        }
    }

    private void _$1995(int n, int n2) {
        grid = new byte[n2][n];
        cnt = new byte[n2][n];
        occ = new byte[n2][n];
        trace = new byte[n2][n];
        firemap = new byte[n2][n];
        firetype = new byte[n2][n];
        switchActivationId = 0;
        nextSwitchActivationId = 0;
    }

    void occupy(int n, int n2) {
        Playfield.occ[n2][n] = 2;
    }

    private void _$2001(String string) {
        _$1976 = string;
        _$1975 = 0;
    }

    byte passThrough(int n, int n2, boolean bl) {
        byte by = grid[n2][n];
        if (firetype[n2][n] == 23) {
            return 10;
        }
        switch (by) {
            case 14: {
                return 11;
            }
            case 24: {
                if (!bl) {
                    return 0;
                }
                Playfield.grid[n2][n] = 0;
                return 37;
            }
            case 36: {
                if (!bl) {
                    return 0;
                }
                byte by2 = cnt[n2][n];
                Playfield.grid[n2][n] = 0;
                System.out.println("bonus: " + by2);
                return by2;
            }
        }
        return 0;
    }

    private int _$2002() {
        if (_$1975 >= _$1976.length()) {
            return -1;
        }
        return _$1976.charAt(_$1975++);
    }

    private void _$2000(int n) {
        Playfield._$1980[n].type = 0;
        if (firstEmpty > n) {
            firstEmpty = n;
        }
    }

    void reset() {
        int n = 0;
        while (n < height) {
            int n2 = 0;
            while (n2 < width) {
                Playfield.grid[n][n2] = 0;
                Playfield.cnt[n][n2] = 0;
                Playfield.trace[n][n2] = -1;
                Playfield.firemap[n][n2] = 0;
                Playfield.firetype[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
        bombs = 0;
    }

    private void _$1996() {
        int n = 0;
        while (n < 28) {
            Playfield._$1980[n].type = 0;
            ++n;
        }
        firstEmpty = 0;
    }

    boolean setBomb(byte by, int n, int n2, int n3) {
        if (bombs >= Player.bombs) {
            return false;
        }
        if (grid[n2][n] > 9 || firetype[n2][n] > 23) {
            return false;
        }
        Playfield.firetype[n2][n] = by;
        Playfield.firemap[n2][n] = (byte)n3;
        ++bombs;
        return true;
    }

    void setDrawDimensions(int n, int n2) {
        drawWidth = n;
        drawHeight = n2;
    }

    boolean setFlame(int n, int n2, int n3, boolean bl) {
        block14: {
            block13: {
                if (n < 0) break block13;
                if (n >= width || n2 < 0) break block13;
                if (n2 < height) break block14;
            }
            return true;
        }
        byte by = grid[n2][n];
        if (firetype[n2][n] > 23) {
            Playfield.firemap[n2][n] = (byte)Math.min(firemap[n2][n], (byte)(1 + n3));
            return !bl;
        }
        if (by <= 9 || by == 36) {
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            return false;
        }
        if (by == 11) {
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            return true;
        }
        if (by == 22) {
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            Playfield.grid[n2][n] = cnt[n2][n] == 37 ? 24 : 36;
            return false;
        }
        if (by == 12) {
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            if (cnt[n2][n] != 2 && !bl) {
                byte[] byArray = cnt[n2];
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] + 1);
            }
            return true;
        }
        if (by == 15) {
            Player.givePoints(10);
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            if (bl) {
                return false;
            }
        }
        if (by == 21 || by == 19) {
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            return false;
        }
        if (by == 16 || by == 17) {
            Playfield.firetype[n2][n] = 23;
            Playfield.firemap[n2][n] = (byte)(0 - n3);
            nextSwitchActivationId |= cnt[n2][n];
            Playfield.grid[n2][n] = by == 16 ? 17 : 16;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void update() {
        try {
            var1_1 = 0;
            Playfield.switchActivationId = Playfield.nextSwitchActivationId;
            Playfield.nextSwitchActivationId = 0;
            var2_3 = 0;
            while (var2_3 < Playfield.width) {
                var3_4 = 0;
                while (var3_4 < Playfield.height) {
                    if (Playfield.occ[var3_4][var2_3] > 0) {
                        v0 = Playfield.occ[var3_4];
                        v1 = var2_3;
                        v0[v1] = (byte)(v0[v1] - 1);
                    }
                    var4_5 = Playfield.grid[var3_4][var2_3];
                    if (Playfield.firetype[var3_4][var2_3] == 23 || Playfield.firetype[var3_4][var2_3] == 38) {
                        if (Playfield.firemap[var3_4][var2_3] >= 10) {
                            Playfield.firetype[var3_4][var2_3] = 0;
                            if (var4_5 == 12 && Playfield.cnt[var3_4][var2_3] == 2 || var4_5 == 15 || var4_5 == 11) {
                                Playfield.grid[var3_4][var2_3] = 0;
                            }
                        } else {
                            v2 = Playfield.firemap[var3_4];
                            v3 = var2_3;
                            v2[v3] = (byte)(v2[v3] + 1);
                        }
                    } else if (Playfield.firetype[var3_4][var2_3] > 23 && Playfield.firetype[var3_4][var2_3] != 38) {
                        v4 = Playfield.firemap[var3_4];
                        v5 = var2_3;
                        v4[v5] = (byte)(v4[v5] - 1);
                        if (Playfield.firemap[var3_4][var2_3] == 0) {
                            HALEffects.playSound(0);
                            --Playfield.bombs;
                            Playfield.firemap[var3_4][var2_3] = 0;
                            if (Playfield.firetype[var3_4][var2_3] == 29) {
                                this.setFlame(var2_3, var3_4, 1, false);
                                Playfield.firetype[var3_4][var2_3] = 23;
                                return;
                            }
                            var5_7 = Playfield.firetype[var3_4][var2_3] == 25 ? 1 : (Playfield.firetype[var3_4][var2_3] == 28 ? 4 : 3);
                            this.addFire(var5_7, var2_3 * Playfield.TILESIZE, var3_4 * Playfield.TILESIZE, -Playfield.TILESIZE, 0, (byte)(Player.flames + 1));
                            this.addFire(var5_7, var2_3 * Playfield.TILESIZE, var3_4 * Playfield.TILESIZE, Playfield.TILESIZE, 0, (byte)(Player.flames + 1));
                            this.addFire(var5_7, var2_3 * Playfield.TILESIZE, var3_4 * Playfield.TILESIZE, 0, -Playfield.TILESIZE, (byte)(Player.flames + 1));
                            this.addFire(var5_7, var2_3 * Playfield.TILESIZE, var3_4 * Playfield.TILESIZE, 0, Playfield.TILESIZE, (byte)(Player.flames + 1));
                            Playfield.firetype[var3_4][var2_3] = 23;
                        }
                    } else if (Playfield.firetype[var3_4][var2_3] == 26) {
                        v6 = Playfield.firemap[var3_4];
                        v7 = var2_3;
                        v6[v7] = (byte)(v6[v7] - 1);
                        if (Playfield.firemap[var3_4][var2_3] == 0) {
                            --Playfield.bombs;
                            var5_7 = -2;
                            while (var5_7 <= 2) {
                                this.setFlame(var2_3 - 2, var3_4 + var5_7, 1, false);
                                this.setFlame(var2_3 + 2, var3_4 + var5_7, 1, false);
                                this.setFlame(var2_3 + var5_7, var3_4 - 2, 1, false);
                                this.setFlame(var2_3 + var5_7, var3_4 + 2, 1, false);
                                ++var5_7;
                            }
                            Playfield.firetype[var3_4][var2_3] = 0;
                            Playfield.firemap[var3_4][var2_3] = 0;
                        }
                    }
                    if (var4_5 == 13) {
                        if (Playfield.levelClear) {
                            Playfield.grid[var3_4][var2_3] = 14;
                        }
                    } else if (var4_5 >= 18 && var4_5 <= 21 && (Playfield.cnt[var3_4][var2_3] & Playfield.switchActivationId) != 0) {
                        switch (var4_5) {
                            case 20: {
                                Playfield.grid[var3_4][var2_3] = 21;
                                break;
                            }
                            case 21: {
                                Playfield.grid[var3_4][var2_3] = 20;
                                break;
                            }
                            case 18: {
                                Playfield.grid[var3_4][var2_3] = 19;
                                break;
                            }
                            case 19: {
                                Playfield.grid[var3_4][var2_3] = 18;
                            }
                        }
                    } else if (var4_5 == 15) {
                        ++var1_1;
                        v8 = Playfield.cnt[var3_4];
                        v9 = var2_3;
                        v8[v9] = (byte)(v8[v9] + 1);
                        if (Playfield.cnt[var3_4][var2_3] == 120) {
                            Playfield.cnt[var3_4][var2_3] = 0;
                            if (!this.isOccupied(var2_3, var3_4)) {
                                Playfield.enemies.addEnemy((byte)2, var2_3, var3_4, (byte)0, (byte)2, 0);
                            }
                        }
                    }
                    ++var3_4;
                }
                ++var2_3;
            }
            var3_4 = 0;
            while (var3_4 < 28) {
                block44: {
                    block46: {
                        block45: {
                            if (Playfield._$1980[var3_4].type == 0) break block44;
                            var4_6 = Playfield._$1980[var3_4];
                            var4_6.x += var4_6.xsp;
                            var4_6.y += var4_6.ysp;
                            var4_6.cnt = (byte)(var4_6.cnt - 1);
                            if (var4_6.cnt != 0) break block45;
                            this._$2000(var3_4);
                            break block44;
                        }
                        var5_7 = this.getGridX(var4_6.x);
                        var6_8 = this.getGridY(var4_6.y);
                        if (var4_6.type != 1 || !this.setFlame(var5_7, var6_8, 1, false)) break block46;
                        this._$2000(var3_4);
                        break block44;
                    }
                    if (var4_6.type != 4) ** GOTO lbl-1000
                    if (var4_6.cnt > 1) {
                        if (var4_6.xsp != 0) {
                            if (this.isPassable(var5_7, var6_8 + 1, -1)) {
                                this.addFire((byte)1, var4_6.x, var4_6.y, 0, Playfield.TILESIZE, (byte)(var4_6.cnt - 2));
                            }
                            if (this.isPassable(var5_7, var6_8 - 1, -1)) {
                                this.addFire((byte)1, var4_6.x, var4_6.y, 0, -Playfield.TILESIZE, (byte)(var4_6.cnt - 2));
                            }
                        }
                        if (var4_6.ysp != 0) {
                            if (this.isPassable(var5_7 + 1, var6_8, -1)) {
                                this.addFire((byte)1, var4_6.x, var4_6.y, Playfield.TILESIZE, 0, (byte)(var4_6.cnt - 2));
                            }
                            if (this.isPassable(var5_7 - 1, var6_8, -1)) {
                                this.addFire((byte)1, var4_6.x, var4_6.y, -Playfield.TILESIZE, 0, (byte)(var4_6.cnt - 2));
                            }
                        }
                    }
                    if (this.setFlame(var5_7, var6_8, 1, false)) {
                        this._$2000(var3_4);
                    } else if (var4_6.type == 3 && this.setFlame(var5_7, var6_8, 1, true)) {
                        this._$2000(var3_4);
                    }
                }
                ++var3_4;
            }
            if (Playfield.levelObjective == 2 && (var1_1 += Playfield.enemies.update()) == 0) {
                Playfield.levelClear = true;
            }
        }
        catch (Exception var1_2) {
            System.err.println("exception in update " + var1_2.toString());
            var1_2.printStackTrace();
        }
    }

    void updateScreen(Graphics graphics) {
        byte by = 0;
        try {
            int n = Font.getFont((int)0, (int)0, (int)8).getHeight();
            int n2 = drawHeight - TILESIZE;
            graphics.setColor(-10432257);
            graphics.fillRect(0, 0, drawWidth, drawHeight);
            graphics.setColor(0xFFFFFF);
            graphics.drawRect(0, 0, drawWidth - 1, TILESIZE - 1);
            int n3 = Player.x + TILESIZE / 2;
            int n4 = Player.y + TILESIZE / 2;
            int n5 = n3 - drawWidth / 2;
            int n6 = n4 - n2 / 2;
            if (n5 <= 0 || drawWidth >= grid[0].length * TILESIZE) {
                n5 = 0;
            } else if (n5 + drawWidth > grid[0].length * TILESIZE) {
                n5 = grid[0].length * TILESIZE - drawWidth;
            }
            if (n6 <= 0 || n2 >= grid.length * TILESIZE) {
                n6 = 0;
            } else if (n6 + n2 > grid.length * TILESIZE) {
                n6 = grid.length * TILESIZE - n2;
            }
            int n7 = n5 / TILESIZE;
            int n8 = n6 / TILESIZE;
            int n9 = -(n5 % TILESIZE);
            int n10 = -(n6 % TILESIZE);
            int n11 = drawWidth / TILESIZE + 2;
            int n12 = n2 / TILESIZE + 2;
            if (n7 + n11 > grid[0].length) {
                n11 = grid[0].length - n7;
            }
            if (n8 + n12 > grid.length) {
                n12 = grid.length - n8;
            }
            int n13 = 0;
            int n14 = 0;
            graphics.setClip(0, TILESIZE, drawWidth, n2);
            n13 = 0;
            while (n13 < n11) {
                n14 = 0;
                while (n14 < n12) {
                    byte by2 = grid[n8 + n14][n7 + n13];
                    by = cnt[n8 + n14][n7 + n13];
                    if (by < 1) {
                        by = 1;
                    }
                    if (by2 == 36) {
                        graphics.drawImage(allImages[0], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                        graphics.drawImage(allImages[cnt[n8 + n14][n7 + n13]], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                    } else {
                        if (by2 > 12) {
                            graphics.drawImage(allImages[0], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                        }
                        graphics.drawImage(allImages[by2], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                    }
                    ++n14;
                }
                ++n13;
            }
            enemies.updateGraphics(-n5 + TILESIZE / 2, TILESIZE + -n6 + TILESIZE / 2, drawWidth, drawHeight + TILESIZE, graphics);
            if (Player.mode == 1 && !Player.killedByTouch) {
                graphics.setClip(Player.x - n5, TILESIZE + Player.y - n6, TILESIZE, TILESIZE);
                graphics.drawImage(Player.getImage(), Player.x - n5 + TILESIZE / 2, TILESIZE + Player.y - n6 + TILESIZE / 2 + TILESIZE * Player.step / 20, 3);
            } else if (Player.invinc % 3 < 2) {
                graphics.drawImage(Player.getImage(), Player.x - n5 + TILESIZE / 2, TILESIZE + Player.y - n6 + TILESIZE / 2, 3);
            }
            try {
                graphics.setClip(0, TILESIZE, drawWidth, n2);
                n13 = 0;
                while (n13 < n11) {
                    n14 = 0;
                    while (n14 < n12) {
                        if (firetype[n8 + n14][n7 + n13] > 0) {
                            if (firetype[n8 + n14][n7 + n13] == 23) {
                                if (grid[n8 + n14][n7 + n13] == 24 || grid[n8 + n14][n7 + n13] == 36) {
                                    graphics.drawImage(chfireImages[(1 + firemap[n8 + n14][n7 + n13]) % 2], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                                } else {
                                    graphics.drawImage(iceImages[(1 + firemap[n8 + n14][n7 + n13]) / 3], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                                }
                            } else if (firetype[n8 + n14][n7 + n13] == 38) {
                                graphics.drawImage(iceImages2[firemap[n8 + n14][n7 + n13] / 2], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                            } else {
                                graphics.drawImage(fireImages[firemap[n8 + n14][n7 + n13] % 4 / 2], n13 * TILESIZE + n9, TILESIZE + n14 * TILESIZE + n10, 20);
                            }
                        }
                        ++n14;
                    }
                    ++n13;
                }
            }
            catch (Exception exception) {
                System.err.println("exception in draw fires. " + firemap[n8 + n14][n7 + n13] + " " + firetype[n8 + n14][n7 + n13]);
            }
            if (MenuScreen.gameScreen.godmode) {
                graphics.setColor(0, 0, 0);
                graphics.setClip(0, TILESIZE, drawWidth, 30);
                graphics.drawString("Cheater!", 0, TILESIZE, 0x10 | 4);
            }
            graphics.setColor(0xFFFFFF);
            graphics.setClip(0, 0, drawWidth, TILESIZE);
            int n15 = 1;
            graphics.drawImage(icons[0], 1, TILESIZE / 2, 6);
            Smallnums.drawNums(Player.lives - 1, graphics, n15 += icons[0].getWidth() + 1, TILESIZE / 2 - Smallnums.charHeight / 2);
            graphics.drawImage(icons[1], n15 += Smallnums.charWidth + 1, TILESIZE / 2, 6);
            Smallnums.drawNums(Player.bombs, graphics, n15 += icons[1].getWidth() + 1, TILESIZE / 2 - Smallnums.charHeight / 2);
            graphics.drawImage(icons[2], n15 += Smallnums.charWidth + 1, TILESIZE / 2, 6);
            Smallnums.drawNums(Player.flames, graphics, n15 += icons[2].getWidth() + 1, TILESIZE / 2 - Smallnums.charHeight / 2);
            Smallnums.drawNumsRight(Integer.toString(Player.points), graphics, drawWidth - 2, TILESIZE / 2 - Smallnums.charHeight / 2);
            if (++pAnim == 120) {
                pAnim = 0;
            }
        }
        catch (Exception exception) {
            System.err.println("exception in updatescreen " + exception.toString());
        }
    }

    class Fire {
        static final int DATA_LENGTH = 18;
        byte cnt;
        byte type;
        int x;
        int xsp;
        int y;
        int ysp;

        Fire() {
        }
    }
}

