/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class Enemies {
    static final byte BLOB = 2;
    static final byte BLUE_BUG = 8;
    static final byte BUG = 4;
    static final byte CASTING = 4;
    static final byte DYING = 3;
    static final byte FACE_DOWN = 0;
    static final byte FACE_LEFT = 1;
    static final byte FACE_RIGHT = 3;
    static final byte FACE_UP = 2;
    static final byte FROZEN = 5;
    static final byte GHOST = 1;
    static final byte IMMOBILE = 1;
    static final byte MAGE = 5;
    static final byte MOVING = 0;
    static final byte NONE = 0;
    static final byte NORMAL = 6;
    static final byte NO_FACE = -1;
    static final byte PLAYER = 6;
    static final int[] STEPS5 = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
    static final byte THINKING = 2;
    static final byte TROLL = 3;
    static final byte YETI = 7;
    static int activeEnemies;
    static Image[] blobIm;
    static Image[] bugIm;
    static Image[] bugbIm;
    private static Enemy[] _$1672;
    static final byte[] enemyHits;
    static final int[] enemyPoints;
    static final byte[] enemySpeeds;
    static int firstEmpty;
    static Image[] ghostIm;
    static Image[] mageIm;
    static int numEnemies;
    static Player player;
    static Playfield playfield;
    private static Random _$2075;
    static Image[] trollIm;
    static Image[] yetiIm;

    static {
        enemySpeeds = new byte[]{0, 4, 2, 3, 1, 2, 0, 3, 2};
        enemyHits = new byte[]{0, 1, 1, 3, 3, 1, 0, 3, 1};
        enemyPoints = new int[]{0, 7, 5, 30, 8, 20, 0, 20, 10};
        _$2075 = new Random();
    }

    Enemies(int n) {
        numEnemies = n;
        _$1672 = new Enemy[n];
        int n2 = 0;
        while (n2 < n) {
            Enemies._$1672[n2] = new Enemy();
            ++n2;
        }
        this.reset();
    }

    int addEnemy(byte by, int n, int n2, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, int n3, byte by8, int n4, boolean bl) {
        int n5 = firstEmpty;
        while (n5 < numEnemies) {
            if (Enemies._$1672[n5].type == 0) break;
            ++n5;
        }
        if (n5 == numEnemies) {
            return -1;
        }
        Enemies._$1672[n5].type = by;
        Enemies._$1672[n5].x = n;
        Enemies._$1672[n5].y = n2;
        Enemies._$1672[n5].face = by2;
        Enemies._$1672[n5].state = by3;
        Enemies._$1672[n5].speed = by4;
        Enemies._$1672[n5].step = by5;
        Enemies._$1672[n5].mode = by6;
        Enemies._$1672[n5].hits = by7;
        Enemies._$1672[n5].span = n3;
        Enemies._$1672[n5].invinc = by8;
        Enemies._$1672[n5].power = n4;
        Enemies._$1672[n5].immaterial = bl;
        firstEmpty = n5;
        return n5;
    }

    int addEnemy(byte by, int n, int n2, byte by2, byte by3, int n3) {
        return this.addEnemy(by, n * Playfield.TILESIZE, n2 * Playfield.TILESIZE, by2, by3, enemySpeeds[by], (byte)0, (byte)6, enemyHits[by], 0, (byte)0, 0, false);
    }

    byte canISeeThePlayer(int n, int n2) {
        if (Player.mode == 2) {
            return -1;
        }
        if (Player.fx == n) {
            if (Player.fy == n2) {
                return -1;
            }
            int n3 = Player.fy;
            int n4 = n2;
            byte by = 2;
            if (Player.fy > n2) {
                n4 = n3;
                n3 = n2;
                by = 0;
            }
            int n5 = n3;
            while (n5 <= n4) {
                if (!playfield.isPassable(n, n5, -1)) {
                    return -1;
                }
                ++n5;
            }
            return by;
        }
        if (Player.fy == n2) {
            int n6 = Player.fx;
            int n7 = n;
            byte by = 1;
            if (Player.fx > n) {
                n7 = n6;
                n6 = n;
                by = 3;
            }
            int n8 = n6;
            while (n8 <= n7) {
                if (!playfield.isPassable(n8, n2, -1)) {
                    return -1;
                }
                ++n8;
            }
            return by;
        }
        return -1;
    }

    boolean canMove(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 == -1) {
            return false;
        }
        int n6 = n3 == 1 ? -1 : (n5 = n3 == 3 ? 1 : 0);
        int n7 = n3 == 2 ? -1 : (n3 == 0 ? 1 : 0);
        return playfield.isPassable(n + n5, n2 + n7, n4) && !playfield.isOccupied(n + n5, n2 + n7);
    }

    void decode(String string) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        try {
            int n3 = string.indexOf(44);
            int n4 = string.indexOf(44, n3 + 1);
            n = Integer.parseInt(string.substring(0, n3));
            n2 = Integer.parseInt(string.substring(n3 + 1, n4));
            by = (byte)Integer.parseInt(string.substring(n4 + 1));
        }
        catch (Exception exception) {
            System.err.println("Enemies.decode");
            exception.printStackTrace();
        }
        if (by == 6) {
            Player.startX = n * Playfield.TILESIZE;
            Player.startY = n2 * Playfield.TILESIZE;
            return;
        }
        this.addEnemy(by, n, n2, (byte)0, (byte)2, 0);
    }

    private byte _$2086(byte by) {
        if (by == 0) {
            return 3;
        }
        return (byte)(by - 1);
    }

    private byte _$2087(byte by) {
        if (by == 3) {
            return 0;
        }
        return (byte)(by + 1);
    }

    byte getRandomStrollDirection(int n, int n2, byte by, boolean bl) {
        int n3 = Math.abs(_$2075.nextInt()) % 2 == 0 ? 1 : -1;
        boolean[] blArray = new boolean[]{this.canMove(n, n2, by, -1), this.canMove(n, n2, this.turn(by, n3), -1), this.canMove(n, n2, this.turn(by, -n3), -1), this.canMove(n, n2, this.turn(by, 2), -1)};
        if (!blArray[0]) {
            if (!blArray[1]) {
                if (!blArray[2]) {
                    if (!blArray[3]) {
                        return -1;
                    }
                    return this.turn(by, 2);
                }
                return this.turn(by, -n3);
            }
            return this.turn(by, n3);
        }
        if (!bl) {
            return by;
        }
        if (blArray[1] && Math.abs(_$2075.nextInt()) % 4 == 0) {
            return this.turn(by, n3);
        }
        if (blArray[2] && Math.abs(_$2075.nextInt()) % 4 == 0) {
            return this.turn(by, -n3);
        }
        return by;
    }

    static void loadImages() {
        if (ghostIm == null) {
            ghostIm = new Image[2];
            Enemies.ghostIm[0] = ReadPackage.getImage("enemy40");
            Enemies.ghostIm[1] = ReadPackage.getImage("enemy41");
        }
        if (blobIm == null) {
            blobIm = new Image[2];
            Enemies.blobIm[0] = ReadPackage.getImage("enemy60");
            Enemies.blobIm[1] = ReadPackage.getImage("enemy61");
        }
        if (bugIm == null) {
            bugIm = new Image[2];
            Enemies.bugIm[0] = ReadPackage.getImage("enemy30");
            Enemies.bugIm[1] = ReadPackage.getImage("enemy31");
        }
        if (bugbIm == null) {
            bugbIm = new Image[2];
            Enemies.bugbIm[0] = ReadPackage.getImage("enemy20");
            Enemies.bugbIm[1] = ReadPackage.getImage("enemy21");
        }
        if (trollIm == null) {
            trollIm = new Image[2];
            Enemies.trollIm[0] = ReadPackage.getImage("enemy70");
            Enemies.trollIm[1] = ReadPackage.getImage("enemy71");
        }
        if (mageIm == null) {
            mageIm = new Image[2];
            Enemies.mageIm[0] = ReadPackage.getImage("enemy10");
            Enemies.mageIm[1] = ReadPackage.getImage("enemy11");
        }
        if (yetiIm == null) {
            yetiIm = new Image[2];
            Enemies.yetiIm[0] = ReadPackage.getImage("enemy50");
            Enemies.yetiIm[1] = ReadPackage.getImage("enemy51");
        }
    }

    private void _$2091(int n) {
        Enemies._$1672[n].type = 0;
        if (firstEmpty > n) {
            firstEmpty = n;
        }
    }

    void reset() {
        int n = 0;
        while (n < numEnemies) {
            Enemies._$1672[n].type = 0;
            ++n;
        }
        activeEnemies = 0;
        firstEmpty = 0;
    }

    byte turn(byte by, int n) {
        if ((by = (byte)(by + n)) > 3) {
            by = (byte)(by - 4);
        }
        if (by < 0) {
            by = (byte)(by + 4);
        }
        return by;
    }

    int update() {
        int n = 0;
        int n2 = Playfield.TILESIZE / 2;
        int n3 = 0;
        while (n3 < numEnemies) {
            if (Enemies._$1672[n3].type != 0) {
                ++n;
                Enemy enemy = _$1672[n3];
                int n4 = playfield.getGridX(enemy.x + n2);
                int n5 = playfield.getGridY(enemy.y + n2);
                int n6 = (enemy.x + n2) % Playfield.TILESIZE;
                int n7 = (enemy.y + n2) % Playfield.TILESIZE;
                if (enemy.invinc > 0) {
                    enemy.invinc = (byte)(enemy.invinc - 1);
                }
                if (enemy.state == 3) {
                    if (enemy.step < 20) {
                        enemy.step = (byte)(enemy.step + 1);
                    } else {
                        this._$2091(n3);
                    }
                } else {
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    if (n4 == Player.fx) {
                        if (n5 == Player.fy) {
                            if (Player.mode != 1) {
                                if (Player.mode != 2) {
                                    if (!MenuScreen.gameScreen.godmode) {
                                        Player.kill(true);
                                    }
                                }
                            }
                        }
                    }
                    if ((n11 = playfield.passThrough(n4, n5, false)) == 10 && enemy.invinc == 0) {
                        if (enemy.type == 7) {
                            if (enemy.mode == 5) {
                                enemy.state = (byte)3;
                                Playfield.firetype[enemy.y / Playfield.TILESIZE][enemy.x / Playfield.TILESIZE] = 38;
                                enemy.step = 0;
                                enemy.mode = (byte)6;
                                Player.givePoints(enemyPoints[enemy.type]);
                                HALEffects.playSound(1);
                                enemy.span = 1;
                            } else {
                                enemy.mode = (byte)5;
                                enemy.step = (byte)70;
                            }
                        } else {
                            enemy.hits = (byte)(enemy.hits - 1);
                        }
                        enemy.invinc = (byte)15;
                        if (enemy.hits == 0) {
                            enemy.state = (byte)3;
                            Playfield.firetype[enemy.y / Playfield.TILESIZE][enemy.x / Playfield.TILESIZE] = 38;
                            enemy.step = 0;
                            Player.givePoints(enemyPoints[enemy.type]);
                            HALEffects.playSound(1);
                            enemy.span = 0;
                        }
                    }
                    if (enemy.type == 1) {
                        enemy.step = (byte)(enemy.step + 1);
                        if (enemy.step == 8) {
                            enemy.step = 0;
                        }
                        if (enemy.state == 2) {
                            if (this.canMove(n4, n5, enemy.face, n3)) {
                                enemy.state = 0;
                                enemy.span = Playfield.TILESIZE;
                            } else {
                                enemy.face = this.getRandomStrollDirection(n4, n5, enemy.face, true);
                            }
                        }
                    } else if (enemy.type == 3) {
                        if (enemy.state == 2) {
                            enemy.speed = (byte)(6 - enemy.hits);
                            n10 = this.getRandomStrollDirection(n4, n5, enemy.face, true);
                            if (n10 != -1) {
                                enemy.face = n10;
                                enemy.state = 0;
                                enemy.span = Playfield.TILESIZE;
                            }
                            if ((n10 = this.canISeeThePlayer(n4, n5)) != -1) {
                                enemy.speed = (byte)5;
                                enemy.face = n10;
                                enemy.span = n10 == 0 || n10 == 2 ? Math.abs(Player.fy - n5) : Math.abs(Player.fx - n4);
                                enemy.span *= Playfield.TILESIZE;
                            }
                        }
                        if (enemy.state != 0) {
                            enemy.step = 0;
                        } else {
                            enemy.step = (byte)(enemy.step + 1);
                            if (enemy.step == 8) {
                                enemy.step = 0;
                            }
                        }
                    } else if (enemy.type == 4 || enemy.type == 8) {
                        if (enemy.state == 2 && (n10 = this.getRandomStrollDirection(n4, n5, enemy.face, true)) != -1) {
                            enemy.face = n10;
                            enemy.state = 0;
                            enemy.span = Playfield.TILESIZE;
                        }
                    } else if (enemy.type == 7) {
                        if (enemy.mode == 5) {
                            enemy.step = (byte)(enemy.step - 1);
                            if (enemy.step == 0) {
                                enemy.step = 0;
                                enemy.mode = (byte)6;
                            }
                        } else {
                            if (enemy.state == 2) {
                                n9 = Playfield.trace[n5][n4];
                                n10 = n9 == -1 ? this.getRandomStrollDirection(n4, n5, enemy.face, true) : (this.canMove(n4, n5, n9, n3) ? n9 : -1);
                                if (n10 != -1) {
                                    enemy.face = (byte)n10;
                                    enemy.state = 0;
                                    enemy.span = Playfield.TILESIZE;
                                }
                            }
                            if (enemy.state != 0) {
                                enemy.step = 0;
                            } else {
                                enemy.step = (byte)(enemy.step + 1);
                                if (enemy.step == 16) {
                                    enemy.step = 0;
                                }
                            }
                        }
                    } else if (enemy.type == 5) {
                        if (enemy.power < 30) {
                            ++enemy.power;
                        }
                        if (enemy.state != 3 && enemy.face == this.canISeeThePlayer(n4, n5) && enemy.mode != 4) {
                            enemy.mode = (byte)4;
                            enemy.step = (byte)15;
                        }
                        if (enemy.mode == 4) {
                            enemy.step = (byte)(enemy.step - 1);
                            if (enemy.step == 13) {
                                int n12 = enemy.face == 1 ? -1 : (n9 = enemy.face == 3 ? 1 : 0);
                                n8 = enemy.face == 2 ? -1 : (enemy.face == 0 ? 1 : 0);
                                playfield.addFire((byte)1, n4 * Playfield.TILESIZE, n5 * Playfield.TILESIZE, n9 * Playfield.TILESIZE, n8 * Playfield.TILESIZE, (byte)4);
                                enemy.power = 0;
                            } else if (enemy.step == 0) {
                                enemy.mode = (byte)6;
                            }
                        } else {
                            if (enemy.state == 2 && (n10 = (int)this.getRandomStrollDirection(n4, n5, enemy.face, true)) != -1) {
                                enemy.face = (byte)n10;
                                enemy.state = 0;
                                enemy.span = Playfield.TILESIZE;
                            }
                            if (enemy.state != 0) {
                                enemy.step = 0;
                            } else {
                                enemy.step = (byte)(enemy.step + 1);
                                if (enemy.step == 8) {
                                    enemy.step = 0;
                                }
                            }
                        }
                    } else if (enemy.type == 2) {
                        enemy.step = (byte)(enemy.step + 1);
                        if (enemy.step == 8) {
                            enemy.step = 0;
                        }
                        enemy.speed = (byte)(1 + Math.abs(_$2075.nextInt()) % 3);
                        if (enemy.state == 2) {
                            int n13;
                            n10 = Player.fx - n4;
                            n9 = Player.fy - n5;
                            int n14 = n10 == 0 ? -1 : (n8 = n10 > 0 ? 3 : 1);
                            int n15 = n9 == 0 ? -1 : (n13 = n9 > 0 ? 0 : 2);
                            if (Math.abs(n10) < Math.abs(n9)) {
                                int n16 = n8;
                                n8 = n13;
                                n13 = n16;
                            }
                            if (this.canMove(n4, n5, n8, n3)) {
                                enemy.state = 0;
                                enemy.face = (byte)n8;
                                enemy.span = Playfield.TILESIZE;
                            } else if (this.canMove(n4, n5, n13, n3)) {
                                enemy.state = 0;
                                enemy.face = (byte)n13;
                                enemy.span = Playfield.TILESIZE;
                            }
                        }
                    }
                    enemy.hasMoved = false;
                    if (enemy.state == 0 && enemy.mode == 6) {
                        n11 = Math.min(enemy.speed, enemy.span);
                        if (n11 != 0) {
                            enemy.hasMoved = true;
                        }
                        switch (enemy.face) {
                            case 0: {
                                if (!playfield.isPassable(playfield.getGridX(enemy.x + n2), playfield.getGridY(enemy.y + Playfield.TILESIZE), n3)) {
                                    enemy.face = (byte)2;
                                    enemy.span = n7 > n2 ? n7 - n2 : n7 + n2;
                                    break;
                                }
                                enemy.y += n11;
                                enemy.span -= n11;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 2: {
                                if (!playfield.isPassable(playfield.getGridX(enemy.x + n2), playfield.getGridY(enemy.y - 1), n3)) {
                                    enemy.face = 0;
                                    enemy.span = n7 < n2 ? n2 - n7 : n2 * 3 - n7;
                                    break;
                                }
                                enemy.y -= n11;
                                enemy.span -= n11;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 3: {
                                if (!playfield.isPassable(playfield.getGridX(enemy.x + Playfield.TILESIZE), playfield.getGridY(enemy.y + n2), n3)) {
                                    enemy.face = 1;
                                    enemy.span = n6 > n2 ? n6 - n2 : n6 + n2;
                                    break;
                                }
                                enemy.x += n11;
                                enemy.span -= n11;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 1: {
                                if (!playfield.isPassable(playfield.getGridX(enemy.x - 1), playfield.getGridY(enemy.y + n2), n3)) {
                                    enemy.face = (byte)3;
                                    enemy.span = n6 < n2 ? n2 - n6 : n2 * 3 - n6;
                                    break;
                                }
                                enemy.x -= n11;
                                enemy.span -= n11;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                            }
                        }
                    }
                    if (enemy.type == 2) {
                        playfield.occupy(n4, n5);
                    }
                }
            }
            ++n3;
        }
        return n;
    }

    void updateGraphics(int n, int n2, int n3, int n4, Graphics graphics) {
        Image[] imageArray = ghostIm;
        int n5 = 0;
        while (n5 < numEnemies) {
            if (Enemies._$1672[n5].type != 0) {
                Enemy enemy = _$1672[n5];
                if (enemy.hasMoved) {
                    enemy.animID = (enemy.animID + 1) % 4;
                }
                if (enemy.type == 1) {
                    imageArray = ghostIm;
                } else if (enemy.type == 3) {
                    imageArray = trollIm;
                } else if (enemy.type == 4 || enemy.type == 8) {
                    imageArray = enemy.type == 4 ? bugIm : bugbIm;
                } else if (enemy.type == 7) {
                    imageArray = enemy.mode == 5 ? yetiIm : (enemy.state == 2 ? yetiIm : yetiIm);
                } else if (enemy.type == 5) {
                    imageArray = mageIm;
                } else if (enemy.type == 2) {
                    imageArray = blobIm;
                }
                int n6 = enemy.x + n;
                int n7 = enemy.y + n2;
                if (n6 > -8 && n6 < n3 + 8 && n7 > -8 && n7 < n4 + 8 && (enemy.invinc % 2 == 0 || enemy.state == 3)) {
                    if (enemy.state == 3) {
                        graphics.setClip(n6 - Playfield.TILESIZE / 2, n7 - Playfield.TILESIZE / 2, Playfield.TILESIZE, Playfield.TILESIZE);
                        graphics.drawImage(imageArray[enemy.animID >> 1], n6, n7 + Playfield.TILESIZE * enemy.step / 20, 3);
                        graphics.setClip(0, 0, Playfield.drawWidth, Playfield.drawHeight);
                    } else {
                        graphics.drawImage(imageArray[enemy.animID >> 1], n6, n7, 3);
                    }
                }
            }
            ++n5;
        }
    }

    class Enemy {
        static final int DATA_LENGTH = 25;
        int animID = 0;
        byte face;
        boolean hasMoved = false;
        byte hits;
        boolean immaterial;
        byte invinc;
        byte mode;
        int power;
        int span;
        byte speed;
        byte state;
        byte step;
        byte type = 0;
        int x;
        int y;

        Enemy() {
        }
    }
}

