/*
 * Decompiled with CFR 0.152.
 */
package py.com.roshka.j2me.bubble.gui;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import py.com.roshka.j2me.bubble.BubbleCrash;
import py.com.roshka.j2me.bubble.BubbleEngine;
import py.com.roshka.j2me.bubble.BubbleException;
import py.com.roshka.j2me.bubble.gui.sprites.Bubble;
import py.com.roshka.j2me.bubble.gui.sprites.Cabo;
import py.com.roshka.j2me.bubble.gui.sprites.Canhon;
import py.com.roshka.j2me.bubble.gui.sprites.ScorePanel;
import py.com.roshka.j2me.bubble.gui.sprites.Techo;
import py.com.roshka.j2me.bubbleCrash.sounds.SoundManager;
import py.com.roshka.j2me.util.gui.Background;
import py.com.roshka.j2me.util.gui.SpriteManager;

public class BubbleCCanvas
extends Canvas
implements Runnable {
    private static final long MS_PER_FRAME = 25L;
    private static final int AJUSTE_CABO = 10;
    private static final int POSX_NEXT_BUBBLE = 33;
    private static final int ALTO_MUNEHECO_AZUL = 30;
    private static final int AJUSTE_BALA_CANHON_X = 15;
    private static final int AJUSTE_BALA_CANHON_Y = 8;
    public Graphics offGrfx;
    public Image offImage;
    private Background backGround;
    public Bubble nextBubbleToFire;
    public Bubble bubbleReadyToFire;
    private Techo techo;
    private Cabo cabo;
    private Canhon canhon;
    private ScorePanel scorePanel;
    private SpriteManager spriteManager;
    private BubbleEngine engine;
    public boolean endOfGame = false;
    private BubbleCrash midlet;
    private SoundManager soundManager;
    public boolean bajoTecho = false;
    private boolean pelotaEnAire;
    private long lastCycleTime;
    public boolean salir = false;
    public boolean pause;

    public BubbleCCanvas(BubbleCrash bubbleCrash, SoundManager soundManager) {
        this.setFullScreenMode(true);
        this.midlet = bubbleCrash;
        this.soundManager = soundManager;
        try {
            Image image = Image.createImage((String)"/fondo.png");
            this.backGround = new Background(image, this.getHeight());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.spriteManager = new SpriteManager(this.backGround);
        this.engine = new BubbleEngine(this.spriteManager, this, soundManager);
        this.initComponent();
        new Thread(this).start();
    }

    public void cambioScore(int n, int n2) {
        this.scorePanel.scoreChanged(n, n2);
        this.spriteManager.forzarRepintado();
    }

    public void initComponent() {
        this.scorePanel = new ScorePanel(this, this.backGround.width);
        this.scorePanel.setWantToPaint(false);
        this.spriteManager.addSprite(this.scorePanel);
        this.canhon = new Canhon();
        this.cabo = new Cabo();
        this.cabo.setZOrder(1);
        this.canhon.setZOrder(2);
        this.cabo.setWantToPaint(true);
        this.canhon.setWantToPaint(true);
        this.canhon.setPos(this.backGround.width / 2 - this.canhon.getWidth() / 2, this.getHeight() - this.scorePanel.getHeight() - this.canhon.getHeight());
        this.canhon.setLastPost(this.backGround.width / 2 - this.canhon.getWidth() / 2, this.getHeight() - this.scorePanel.getHeight() - this.canhon.getHeight());
        this.cabo.setPos(this.backGround.width / 2 + this.canhon.getWidth() / 2 - 10, this.getHeight() - this.scorePanel.getHeight() - this.cabo.getHeight());
        this.cabo.setLastPost(this.backGround.width / 2 + this.canhon.getWidth() / 2 - 10, this.getHeight() - this.scorePanel.getHeight() - this.cabo.getHeight());
        this.engine.techo = this.techo = new Techo();
        this.spriteManager.addSprite(this.techo);
        this.spriteManager.addSprite(this.canhon);
        this.spriteManager.addSprite(this.cabo);
        this.spriteManager.forzarRepintado();
    }

    public void setPosicionForBubble() {
        this.nextBubbleToFire.setPos(33, this.getHeight() - 30);
        this.nextBubbleToFire.setLastPost(33, this.getHeight() - 30);
        this.bubbleReadyToFire.setPos(this.canhon.getPosX() + 15, this.canhon.getPosY() + this.canhon.getHeight() / 2 + this.bubbleReadyToFire.getHeight() / 2 - 8);
        this.bubbleReadyToFire.setLastPost(this.canhon.getPosX() + this.bubbleReadyToFire.getWidth() + 15, this.canhon.getPosY() + this.canhon.getHeight() / 2 + this.bubbleReadyToFire.getHeight() / 2 - 8);
        this.bubbleReadyToFire.setWantToPaint(true);
    }

    protected void paint(Graphics graphics) {
        int n;
        if (this.offGrfx == null) {
            this.offImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.offGrfx = this.offImage.getGraphics();
        }
        if (this.bajoTecho) {
            this.bajoTecho = false;
            n = this.offGrfx.getColor();
            this.offGrfx.setColor(255, 255, 255);
            this.offGrfx.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.offGrfx.setColor(n);
        }
        this.spriteManager.draw(this.offGrfx);
        if (this.endOfGame) {
            n = this.offGrfx.getColor();
            Font font = this.offGrfx.getFont();
            Font font2 = Font.getFont((int)32, (int)1, (int)16);
            this.offGrfx.setFont(font2);
            this.offGrfx.setColor(255, 0, 0);
            if (this.backGround.getHeight() < this.getHeight()) {
                this.offGrfx.drawString("Game Over", this.backGround.width / 2, this.getHeight() - this.backGround.getHeight() / 2, 33);
            } else {
                this.offGrfx.drawString("Game Over", this.backGround.width / 2, this.getHeight() / 2, 17);
            }
            this.offGrfx.setColor(n);
            this.offGrfx.setFont(font);
        }
        graphics.drawImage(this.offImage, 0, 0, 20);
    }

    protected void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n == -7 || n == -6) {
            this.pause();
            this.midlet.menuGral();
            return;
        }
        if (!this.endOfGame) {
            switch (n2) {
                case 2: {
                    this.canhon.moverDerecha = false;
                    this.canhon.moverIzquierda = true;
                    this.cabo.mover = true;
                    break;
                }
                case 5: {
                    this.canhon.moverDerecha = true;
                    this.canhon.moverIzquierda = false;
                    this.cabo.mover = true;
                    break;
                }
                case 8: {
                    this.cabo.mover = true;
                    this.fire();
                    break;
                }
                case 1: {
                    this.cabo.mover = true;
                    this.fire();
                }
            }
        }
    }

    protected void keyReleased(int n) {
        this.canhon.moverDerecha = false;
        this.canhon.moverIzquierda = false;
        this.cabo.mover = false;
        this.cabo.resetEstado();
    }

    public void cycle() {
        if (this.lastCycleTime > 0L) {
            long l = System.currentTimeMillis() - this.lastCycleTime;
            this.canhon.cycle(l);
            this.cabo.cycle(l);
            if (this.pelotaEnAire) {
                this.bubbleReadyToFire.move();
                if (this.engine.estaPegadaVer2(this.bubbleReadyToFire)) {
                    try {
                        this.engine.addBubble(this.bubbleReadyToFire, this.bubbleReadyToFire.row, this.bubbleReadyToFire.col);
                        this.pelotaEnAire = false;
                        this.recargar();
                        this.spriteManager.forzarRepintado();
                    }
                    catch (BubbleException bubbleException) {}
                }
            } else if (this.engine.bajarRow()) {
                this.bajoTecho = true;
                this.spriteManager.forzarRepintado();
            }
        }
        this.lastCycleTime = System.currentTimeMillis();
    }

    public void recargar() {
        this.bubbleReadyToFire = this.nextBubbleToFire;
        this.nextBubbleToFire = this.engine.getNextBubbleToFire();
        this.spriteManager.addSprite(this.nextBubbleToFire);
        this.setPosicionForBubble();
    }

    public void fire() {
        if (!this.pelotaEnAire) {
            this.bubbleReadyToFire.setAngle(this.canhon.angle);
            this.bubbleReadyToFire.paredIzquierda = 0;
            this.bubbleReadyToFire.paredDerecha = this.backGround.width - 9;
            this.bubbleReadyToFire.resetMov();
            this.bubbleReadyToFire.calcularDeltas();
            this.bubbleReadyToFire.setWantToPaint(true);
            this.pelotaEnAire = true;
            if (this.soundManager != null && this.soundManager.getsonido()) {
                this.soundManager.run_disparo();
            }
        }
    }

    public void run() {
        while (!this.salir) {
            while (!this.endOfGame) {
                long l;
                long l2 = System.currentTimeMillis();
                if (!this.pause) {
                    this.cycle();
                    this.repaint();
                }
                if ((l = System.currentTimeMillis() - l2) >= 25L) continue;
                try {
                    Thread.sleep(25L - l);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void startGame() {
        this.spriteManager.remove(this.nextBubbleToFire);
        this.spriteManager.remove(this.bubbleReadyToFire);
        this.bubbleReadyToFire = this.engine.getRandomBubble();
        this.nextBubbleToFire = this.engine.getRandomBubble();
        this.spriteManager.addSprite(this.nextBubbleToFire);
        this.spriteManager.addSprite(this.bubbleReadyToFire);
        this.setPosicionForBubble();
        this.endOfGame = false;
        this.play();
        this.resetCanhon();
        this.engine.currentNivel = 1;
        this.engine.totalscore = 0;
        this.engine.score = 0;
        this.engine.iniTecho = this.getHeight() - this.backGround.getHeight();
        this.techo.setPos(0, this.getHeight() - this.backGround.getHeight());
        this.engine.nivelCanhon = this.getHeight() - this.scorePanel.getHeight() - this.canhon.getHeight() - 9;
        this.engine.startGame();
        this.spriteManager.forzarRepintado();
    }

    public void endOfGame() {
        this.endOfGame = true;
        this.nextBubbleToFire.endurecer();
        this.bubbleReadyToFire.endurecer();
        this.spriteManager.forzarRepintado();
        this.repaint();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.spriteManager.remove(this.nextBubbleToFire);
        this.spriteManager.remove(this.bubbleReadyToFire);
        this.midlet.endOfGame();
    }

    public void play() {
        this.pause = false;
        this.lastCycleTime = 0L;
    }

    public void pause() {
        this.pause = true;
    }

    public int getScore() {
        return this.engine.totalscore;
    }

    public void resetCanhon() {
        this.canhon.reset();
    }
}

