/*
 * Decompiled with CFR 0.152.
 */
package py.com.roshka.j2me.bubble;

import java.util.Random;
import py.com.roshka.j2me.bubble.BubbleException;
import py.com.roshka.j2me.bubble.LevelManager;
import py.com.roshka.j2me.bubble.gui.BubbleCCanvas;
import py.com.roshka.j2me.bubble.gui.sprites.Bubble;
import py.com.roshka.j2me.bubble.gui.sprites.Posicion;
import py.com.roshka.j2me.bubble.gui.sprites.Techo;
import py.com.roshka.j2me.bubbleCrash.sounds.SoundManager;
import py.com.roshka.j2me.util.gui.SpriteManager;

public class BubbleEngine {
    private static final int MAX_FILAS = 13;
    private static final int MAX_COL = 13;
    public int cambiascore;
    public int totalscore;
    private boolean control;
    public boolean borrando;
    public int score;
    public int currentNivel;
    boolean cadena;
    int contadorbubble;
    private int valorx;
    private int valory;
    public Bubble[][] burbujas;
    private Random rand = new Random();
    private SpriteManager spriteManager;
    private LevelManager levelManager;
    public int topX;
    public int topY;
    public Techo techo;
    public int nivelCanhon;
    private BubbleCCanvas canvas;
    public int iniTecho;
    public SoundManager sound;
    public long lastTimeRowAdd;

    public BubbleEngine(SpriteManager spriteManager, BubbleCCanvas bubbleCCanvas, SoundManager soundManager) {
        this.burbujas = new Bubble[13][13];
        this.spriteManager = spriteManager;
        this.canvas = bubbleCCanvas;
        this.currentNivel = 1;
        this.topX = 6;
        this.sound = soundManager;
        this.levelManager = new LevelManager();
    }

    public void removeAllBubble() {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null) continue;
                this.removeBubble(i, j);
            }
        }
    }

    public void startGame() {
        this.topY = this.iniTecho;
        this.techo.setPosY(this.iniTecho);
        this.removeAllBubble();
        this.cargarBurbujas(this.levelManager.getCantIncialFilas(this.currentNivel));
        this.lastTimeRowAdd = System.currentTimeMillis();
    }

    public void cargarBurbujas(int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 13; ++j) {
                this.burbujas[i][j] = this.getRandomBubble();
                this.spriteManager.addSprite(this.burbujas[i][j]);
            }
        }
        this.setPosicionBurbujas();
    }

    public synchronized void setPosicionBurbujas() {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null) continue;
                this.burbujas[i][j].setPos(this.translateJtoPosX(i, j), this.translateItoPosY(i));
            }
        }
    }

    public void removeBubble(int n, int n2) {
        this.spriteManager.remove(this.burbujas[n][n2]);
        this.burbujas[n][n2] = null;
    }

    public int translateXToCol(int n, int n2) {
        int n3 = n - this.topX + 9;
        int n4 = this.translateYToRow(n2);
        if (n4 % 2 == 0) {
            return n3 / 18;
        }
        return (n3 + 9) / 18;
    }

    public int translateYToRow(int n) {
        int n2 = n - this.topY;
        return n2 / 18;
    }

    public int translateJtoPosX(int n, int n2) {
        int n3 = n2 * 18;
        if (n % 2 == 0) {
            return n3 + this.topX;
        }
        return n3 + this.topX - 9;
    }

    public int translateItoPosY(int n) {
        int n2 = n * 18;
        return n2 + this.topY;
    }

    public boolean finJuego() {
        return false;
    }

    public Bubble getNextBubbleToFire() {
        Bubble bubble = null;
        while ((bubble = this.getRandomBubble()).getType() != this.canvas.nextBubbleToFire.getType() && !this.hayColorBubble(bubble.getType())) {
        }
        return bubble;
    }

    public boolean hayColorBubble(int n) {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null || this.burbujas[i][j].getType() != n) continue;
                return true;
            }
        }
        return false;
    }

    public Bubble getRandomBubble() {
        return new Bubble(Math.abs(this.rand.nextInt() % 4));
    }

    public void fixBubble(Bubble bubble, int n, int n2) {
        if (bubble != null) {
            bubble.row = n;
            bubble.col = n2;
            bubble.setPosX(this.translateJtoPosX(n, n2));
            bubble.setPosY(this.translateItoPosY(n));
        }
    }

    public synchronized boolean estaPegadaVer2(Bubble bubble) {
        int n = this.translateYToRow(bubble.getPosY());
        int n2 = this.translateXToCol(bubble.getPosX(), bubble.getPosY());
        Posicion posicion = bubble.nextPos();
        int n3 = this.translateYToRow(posicion.y);
        int n4 = this.translateXToCol(posicion.x, posicion.y);
        if (n >= 13) {
            return false;
        }
        if (n >= 0 && n < 13 && n2 >= 0 && n2 < 13 && this.burbujas[n][n2] != null) {
            this.fixBubble(bubble, n + 1, n2);
            return true;
        }
        if ((n2 == 12 || n2 == 0) && n > 0 && n < 13 && this.burbujas[n - 1][n2] != null) {
            this.fixBubble(bubble, n, n2);
            return true;
        }
        if (n3 >= 0 && n3 < 13 && n4 >= 0 && n4 < 13 && this.burbujas[n3][n4] != null && n >= 0 && n < 13 && n2 >= 0 && n2 < 13) {
            this.fixBubble(bubble, n, n2);
            return true;
        }
        if (n == 0) {
            if (n3 < 0 || n3 >= 13 || n4 < 0 || n4 >= 13) {
                this.fixBubble(bubble, n, n2);
                return true;
            }
            if (bubble.getPosY() - 9 <= this.topY) {
                this.fixBubble(bubble, n, n2);
                return true;
            }
        }
        if (n > 0 && n <= 13) {
            if (n % 2 == 0) {
                if (n2 < 13) {
                    this.fixBubble(this.burbujas[n - 1][n2], n - 1, n2);
                    if (bubble.chocaCon(this.burbujas[n - 1][n2])) {
                        this.fixBubble(bubble, n, n2);
                        return true;
                    }
                }
                if (n2 < 12) {
                    this.fixBubble(this.burbujas[n - 1][n2 + 1], n - 1, n2 + 1);
                    if (bubble.chocaCon(this.burbujas[n - 1][n2 + 1])) {
                        this.fixBubble(bubble, n, n2);
                        return true;
                    }
                }
            } else {
                if (n2 > 0) {
                    this.fixBubble(this.burbujas[n - 1][n2 - 1], n - 1, n2 - 1);
                    if (bubble.chocaCon(this.burbujas[n - 1][n2 - 1])) {
                        this.fixBubble(bubble, n, n2);
                        return true;
                    }
                }
                if (n2 < 13) {
                    this.fixBubble(this.burbujas[n - 1][n2], n - 1, n2);
                    if (bubble.chocaCon(this.burbujas[n - 1][n2])) {
                        this.fixBubble(bubble, n, n2);
                        return true;
                    }
                }
            }
        }
        if (n >= 0 && n < 13) {
            if (n2 > 0) {
                this.fixBubble(this.burbujas[n][n2 - 1], n, n2 - 1);
                if (bubble.chocaCon(this.burbujas[n][n2 - 1])) {
                    this.fixBubble(bubble, n, n2);
                    return true;
                }
            }
            if (n2 < 12) {
                this.fixBubble(this.burbujas[n][n2 + 1], n, n2 + 1);
                if (bubble.chocaCon(this.burbujas[n][n2 + 1])) {
                    this.fixBubble(bubble, n, n2);
                    return true;
                }
            }
        }
        return false;
    }

    public void addBubble(Bubble bubble, int n, int n2) throws BubbleException {
        if (this.burbujas[n][n2] != null) {
            throw new BubbleException(n, n2);
        }
        this.burbujas[n][n2] = bubble;
        this.burbujas[n][n2].setWantToPaint(false);
        this.burbujas[n][n2].setPos(this.translateJtoPosX(n, n2), this.translateItoPosY(n));
        this.cadena = false;
        this.valorx = n;
        this.valory = n2;
        this.contadorbubble = 0;
        this.cambiascore = 0;
        this.borrando = false;
        this.spriteManager.forzarRepintado();
        this.canvas.repaint();
        this.newBubbleAdded(n, n2);
        if (this.borrando) {
            this.quitarBurbujasSueltas();
            this.spriteManager.forzarRepintado();
            this.canvas.repaint();
            try {
                Thread.sleep(80L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.quitarBurbujasExplotadas();
            int n3 = this.score;
            this.totalscore = this.score;
            this.totalscore += (this.cambiascore - 2) * 10;
            this.score = this.totalscore;
            this.canvas.cambioScore(this.currentNivel, this.totalscore);
        }
        if (this.verifyEndOfLevel()) {
            this.endOfLevel();
        } else if (this.verifyEndOfGame()) {
            this.endOfGame();
        }
    }

    public void quitarBurbujasExplotadas() {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null || !this.burbujas[i][j].exploto) continue;
                this.removeBubble(i, j);
                ++this.cambiascore;
            }
        }
    }

    public void newBubbleAdded(int n, int n2) {
        if (n % 2 != 0) {
            if (!(n2 <= 0 || this.valorx == n && this.valory == n2 - 1 || this.cadena || this.burbujas[n][n2 - 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n][n2 - 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n, n2 - 1);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n2 + 1 >= 13 || this.valorx == n && this.valory == n2 + 1 || this.cadena || this.burbujas[n][n2 + 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n][n2 + 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n, n2 + 1);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n <= 0 || this.valorx == n - 1 && this.valory == n2 || this.cadena || this.burbujas[n - 1][n2] == null || this.burbujas[n][n2].getType() != this.burbujas[n - 1][n2].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n - 1, n2);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n <= 0 || n2 <= 0 || this.valorx == n - 1 && this.valory == n2 - 1 || this.cadena || this.burbujas[n - 1][n2 - 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n - 1][n2 - 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n - 1, n2 - 1);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n + 1 >= 13 || this.valorx == n + 1 && this.valory == n2 || this.cadena || this.burbujas[n + 1][n2] == null || this.burbujas[n][n2].getType() != this.burbujas[n + 1][n2].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n + 1, n2);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n + 1 >= 13 || n2 <= 0 || this.valorx == n + 1 && this.valory == n2 - 1 || this.cadena || this.burbujas[n + 1][n2 - 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n + 1][n2 - 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n + 1, n2 - 1);
                } else {
                    this.cadena = true;
                }
            }
        }
        if (n % 2 == 0) {
            if (!(n2 <= 0 || this.valorx == n && this.valory == n2 - 1 || this.cadena || this.burbujas[n][n2 - 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n][n2 - 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n, n2 - 1);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n2 + 1 >= 13 || this.valorx == n && this.valory == n2 + 1 || this.cadena || this.burbujas[n][n2 + 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n][n2 + 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n, n2 + 1);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n <= 0 || this.valorx == n - 1 && this.valory == n2 || this.cadena || this.burbujas[n - 1][n2] == null || this.burbujas[n][n2].getType() != this.burbujas[n - 1][n2].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n - 1, n2);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n <= 0 || n2 + 1 >= 13 || this.valorx == n - 1 && this.valory == n2 + 1 || this.cadena || this.burbujas[n - 1][n2 + 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n - 1][n2 + 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n - 1, n2 + 1);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n + 1 >= 13 || this.valorx == n + 1 && this.valory == n2 || this.cadena || this.burbujas[n + 1][n2] == null || this.burbujas[n][n2].getType() != this.burbujas[n + 1][n2].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n + 1, n2);
                } else {
                    this.cadena = true;
                }
            }
            if (!(n + 1 >= 13 || n2 + 1 >= 13 || this.valorx == n + 1 && this.valory == n2 + 1 || this.cadena || this.burbujas[n + 1][n2 + 1] == null || this.burbujas[n][n2].getType() != this.burbujas[n + 1][n2 + 1].getType())) {
                if (this.valorx == n && this.valory == n2) {
                    ++this.contadorbubble;
                    this.newBubbleAdded(n + 1, n2 + 1);
                } else {
                    this.cadena = true;
                }
            }
        }
        if (this.contadorbubble > 1) {
            this.cadena = true;
        }
        if (this.cadena) {
            this.borrando = true;
            this.borrarCadena(this.valorx, this.valory, this.burbujas[this.valorx][this.valory].getType());
        }
    }

    public void borrarCadena(int n, int n2, int n3) {
        if (n3 == this.burbujas[n][n2].getType()) {
            if (this.sound != null && this.sound.getsonido()) {
                this.sound.run_explosion();
            }
            this.burbujas[n][n2].explotar();
            if (n % 2 != 0) {
                if (n2 > 0 && this.burbujas[n][n2 - 1] != null && n3 == this.burbujas[n][n2 - 1].getType() && !this.burbujas[n][n2 - 1].exploto) {
                    this.borrarCadena(n, n2 - 1, n3);
                }
                if (n2 + 1 < 13 && this.burbujas[n][n2 + 1] != null && n3 == this.burbujas[n][n2 + 1].getType() && !this.burbujas[n][n2 + 1].exploto) {
                    this.borrarCadena(n, n2 + 1, n3);
                }
                if (n > 0 && this.burbujas[n - 1][n2] != null && n3 == this.burbujas[n - 1][n2].getType() && !this.burbujas[n - 1][n2].exploto) {
                    this.borrarCadena(n - 1, n2, n3);
                }
                if (n > 0 && n2 > 0 && this.burbujas[n - 1][n2 - 1] != null && n3 == this.burbujas[n - 1][n2 - 1].getType() && !this.burbujas[n - 1][n2 - 1].exploto) {
                    this.borrarCadena(n - 1, n2 - 1, n3);
                }
                if (n + 1 < 13 && this.burbujas[n + 1][n2] != null && n3 == this.burbujas[n + 1][n2].getType() && !this.burbujas[n + 1][n2].exploto) {
                    this.borrarCadena(n + 1, n2, n3);
                }
                if (n + 1 < 13 && n2 > 0 && this.burbujas[n + 1][n2 - 1] != null && n3 == this.burbujas[n + 1][n2 - 1].getType() && !this.burbujas[n + 1][n2 - 1].exploto) {
                    this.borrarCadena(n + 1, n2 - 1, n3);
                }
            }
            if (n % 2 == 0) {
                if (n2 > 0 && this.burbujas[n][n2 - 1] != null && n3 == this.burbujas[n][n2 - 1].getType() && !this.burbujas[n][n2 - 1].exploto) {
                    this.borrarCadena(n, n2 - 1, n3);
                }
                if (n2 + 1 < 13 && this.burbujas[n][n2 + 1] != null && n3 == this.burbujas[n][n2 + 1].getType() && !this.burbujas[n][n2 + 1].exploto) {
                    this.borrarCadena(n, n2 + 1, n3);
                }
                if (n > 0 && this.burbujas[n - 1][n2] != null && n3 == this.burbujas[n - 1][n2].getType() && !this.burbujas[n - 1][n2].exploto) {
                    this.borrarCadena(n - 1, n2, n3);
                }
                if (n > 0 && n2 + 1 < 13 && this.burbujas[n - 1][n2 + 1] != null && n3 == this.burbujas[n - 1][n2 + 1].getType() && !this.burbujas[n - 1][n2 + 1].exploto) {
                    this.borrarCadena(n - 1, n2 + 1, n3);
                }
                if (n + 1 < 13 && this.burbujas[n + 1][n2] != null && n3 == this.burbujas[n + 1][n2].getType() && !this.burbujas[n + 1][n2].exploto) {
                    this.borrarCadena(n + 1, n2, n3);
                }
                if (n + 1 < 13 && n2 + 1 < 13 && this.burbujas[n + 1][n2 + 1] != null && n3 == this.burbujas[n + 1][n2 + 1].getType() && !this.burbujas[n + 1][n2 + 1].exploto) {
                    this.borrarCadena(n + 1, n2 + 1, n3);
                }
            }
        }
    }

    public int controlarDesconectadas(int n, int n2) {
        this.burbujas[n][n2].control = true;
        if (n % 2 != 0) {
            if (n > 0) {
                if (!(this.burbujas[n - 1][n2] == null || this.burbujas[n - 1][n2].exploto || this.control || this.burbujas[n - 1][n2].control)) {
                    this.controlarDesconectadas(n - 1, n2);
                }
            } else {
                this.control = true;
                return 1;
            }
            if (n > 0 && n2 > 0) {
                if (!(this.burbujas[n - 1][n2 - 1] == null || this.burbujas[n - 1][n2 - 1].exploto || this.control || this.burbujas[n - 1][n2 - 1].control)) {
                    this.controlarDesconectadas(n - 1, n2 - 1);
                }
            } else if (n <= 0) {
                this.control = true;
                return 1;
            }
            if (!(n2 <= 0 || this.burbujas[n][n2 - 1] == null || this.burbujas[n][n2 - 1].exploto || this.control || this.burbujas[n][n2 - 1].control)) {
                this.controlarDesconectadas(n, n2 - 1);
            }
            if (!(n2 + 1 >= 13 || this.burbujas[n][n2 + 1] == null || this.burbujas[n][n2 + 1].exploto || this.control || this.burbujas[n][n2 + 1].control)) {
                this.controlarDesconectadas(n, n2 + 1);
            }
        }
        if (n % 2 == 0) {
            if (n > 0) {
                if (!(this.burbujas[n - 1][n2] == null || this.burbujas[n - 1][n2].exploto || this.control || this.burbujas[n - 1][n2].control)) {
                    this.controlarDesconectadas(n - 1, n2);
                }
            } else {
                this.control = true;
                return 1;
            }
            if (n > 0 && n2 + 1 < 13) {
                if (!(this.burbujas[n - 1][n2 + 1] == null || this.burbujas[n - 1][n2 + 1].exploto || this.control || this.burbujas[n - 1][n2 + 1].control)) {
                    this.controlarDesconectadas(n - 1, n2 + 1);
                }
            } else if (n <= 0) {
                this.control = true;
                return 1;
            }
            if (!(n2 <= 0 || this.burbujas[n][n2 - 1] == null || this.burbujas[n][n2 - 1].exploto || this.control || this.burbujas[n][n2 - 1].control)) {
                this.controlarDesconectadas(n, n2 - 1);
            }
            if (!(n2 + 1 >= 13 || this.burbujas[n][n2 + 1] == null || this.burbujas[n][n2 + 1].exploto || this.control || this.burbujas[n][n2 + 1].control)) {
                this.controlarDesconectadas(n, n2 + 1);
            }
        }
        return 1;
    }

    public void quitarBurbujasSueltas() {
        int n;
        int n2;
        for (n2 = 0; n2 < 13; ++n2) {
            for (n = 0; n < 13; ++n) {
                if (this.burbujas[n2][n] == null) continue;
                this.burbujas[n2][n].control = false;
                this.burbujas[n2][n].enlista = false;
            }
        }
        for (n2 = 12; n2 >= 0; --n2) {
            for (n = 12; n >= 0; --n) {
                int n3;
                int n4;
                if (this.burbujas[n2][n] == null || this.burbujas[n2][n].exploto || this.burbujas[n2][n].enlista) continue;
                this.control = false;
                int n5 = this.controlarDesconectadas(n2, n);
                if (!this.control) {
                    for (n4 = 0; n4 < 13; ++n4) {
                        for (n3 = 0; n3 < 13; ++n3) {
                            if (this.burbujas[n4][n3] == null || !this.burbujas[n4][n3].control) continue;
                            if (this.sound != null && this.sound.getsonido()) {
                                this.sound.run_explosion();
                            }
                            this.burbujas[n4][n3].explotar();
                            this.burbujas[n4][n3].control = false;
                        }
                    }
                    continue;
                }
                for (n4 = 0; n4 < 13; ++n4) {
                    for (n3 = 0; n3 < 13; ++n3) {
                        if (this.burbujas[n4][n3] == null || !this.burbujas[n4][n3].control) continue;
                        this.burbujas[n4][n3].enlista = true;
                        this.burbujas[n4][n3].control = false;
                    }
                }
            }
        }
    }

    public boolean bajarRow() {
        if (this.lastTimeRowAdd > 0L) {
            long l = System.currentTimeMillis() - this.lastTimeRowAdd;
            if (this.levelManager.getIntervalTime(this.currentNivel) <= l) {
                int n = this.levelManager.getBajadaTecho(this.currentNivel);
                this.topY += n;
                this.techo.bajar(n);
                this.setPosicionBurbujas();
                this.lastTimeRowAdd = System.currentTimeMillis();
                if (this.verifyEndOfGame()) {
                    this.endOfGame();
                }
                return true;
            }
        }
        return false;
    }

    public boolean verifyEndOfGame() {
        int n = this.getMaxRow();
        int n2 = this.translateItoPosY(n);
        return n2 >= this.nivelCanhon;
    }

    public boolean verifyEndOfLevel() {
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null) continue;
                return false;
            }
        }
        return true;
    }

    public void endOfLevel() {
        if (this.sound != null && this.sound.getsonido()) {
            this.sound.run_nivel();
        }
        ++this.currentNivel;
        this.canvas.cambioScore(this.currentNivel, this.totalscore);
        this.canvas.resetCanhon();
        this.startGame();
    }

    public void endOfGame() {
        if (this.sound.getsonido()) {
            this.sound.run_over();
        }
        for (int i = 0; i < 13; ++i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null) continue;
                this.burbujas[i][j].endurecer();
            }
        }
        this.canvas.endOfGame();
    }

    public int getMaxRow() {
        for (int i = 12; i >= 0; --i) {
            for (int j = 0; j < 13; ++j) {
                if (this.burbujas[i][j] == null) continue;
                return i;
            }
        }
        return 0;
    }
}

