/*
 * Decompiled with CFR 0.152.
 */
package py.com.roshka.j2me.bubble;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import py.com.roshka.j2me.bubble.gui.BubbleCCanvas;
import py.com.roshka.j2me.bubble.gui.BubbleInicioCanvas;
import py.com.roshka.j2me.bubble.gui.BubbleRanking;
import py.com.roshka.j2me.bubble.gui.MenuGral;
import py.com.roshka.j2me.bubble.gui.MenuIniciador;
import py.com.roshka.j2me.bubble.gui.MenuInstrucciones;
import py.com.roshka.j2me.bubble.gui.MenuSonido;
import py.com.roshka.j2me.bubbleCrash.persister.BubblePersister;
import py.com.roshka.j2me.bubbleCrash.persister.SoundPersister;
import py.com.roshka.j2me.bubbleCrash.sounds.SoundManager;
import py.com.roshka.j2me.bubbleCrash.sounds.SoundManagerIMPL;

public class BubbleCrash
extends MIDlet
implements CommandListener {
    private MenuGral menuGral;
    private SoundManager soundManager;
    private SoundPersister soundPersister;
    private boolean lastsound;
    private Command commandAceptar;
    private Command commandMenu;
    private TextBox textBox;
    private int opcion_menu = 0;
    private MenuSonido menuSonido;
    private BubbleCCanvas bubbleCanvas;
    private boolean wantToExit;
    private MenuInstrucciones instrucciones;
    private BubbleRanking bubbleRanking;
    public BubbleInicioCanvas InicioCanvas;

    public BubbleCrash() {
        try {
            this.soundPersister = new SoundPersister();
            this.soundManager = new SoundManagerIMPL();
            if (this.soundPersister.getSonido() == 0) {
                this.soundManager.setsonido(true);
                this.soundManager.run_beatles();
            } else {
                this.soundManager.setsonido(false);
            }
            this.lastsound = this.soundManager.getsonido();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.commandAceptar = new Command("Accept", 1, 1);
        this.commandMenu = new Command("Menu", 1, 1);
    }

    protected void startApp() throws MIDletStateChangeException {
        BubbleInicioCanvas bubbleInicioCanvas = new BubbleInicioCanvas();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)bubbleInicioCanvas);
        Timer timer = new Timer();
        timer.schedule((TimerTask)new MenuIniciador(this), 2000L);
    }

    public void iniciarJuego() {
        try {
            Runtime.getRuntime().gc();
            this.soundManager.stop();
            this.lastsound = !this.lastsound;
            if (this.bubbleCanvas == null) {
                this.bubbleCanvas = new BubbleCCanvas(this, this.soundManager);
                this.bubbleCanvas.setFullScreenMode(true);
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.bubbleCanvas);
            this.bubbleCanvas.startGame();
        }
        catch (Exception exception) {
            this.menuGral = null;
            this.instrucciones = null;
            this.bubbleRanking = null;
            this.menuSonido = null;
            Runtime.getRuntime().gc();
            this.iniciarJuego();
        }
    }

    protected void pauseApp() {
    }

    protected void destroyApp(boolean bl) throws MIDletStateChangeException {
    }

    public void menuGral() {
        try {
            if (this.lastsound != this.soundManager.getsonido()) {
                if (this.soundManager.getsonido()) {
                    this.soundPersister.setSonido(0);
                    this.soundManager.run_beatles();
                } else {
                    this.soundPersister.setSonido(1);
                    this.soundManager.stop();
                }
                this.lastsound = this.soundManager.getsonido();
            }
            if (this.bubbleCanvas != null && !this.bubbleCanvas.endOfGame) {
                this.bubbleCanvas.pause();
            }
            if (this.menuGral == null) {
                this.menuGral = new MenuGral(this);
                this.menuGral.setFullScreenMode(true);
                this.menuGral.seleccion = this.opcion_menu;
            }
            Runtime.getRuntime().gc();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuGral);
        }
        catch (Exception exception) {
            this.instrucciones = null;
            this.bubbleRanking = null;
            this.menuSonido = null;
            this.bubbleCanvas = null;
            Runtime.getRuntime().gc();
            this.menuGral();
        }
    }

    public void verInstrucciones() {
        try {
            Runtime.getRuntime().gc();
            if (this.instrucciones == null) {
                this.instrucciones = new MenuInstrucciones(this);
                this.instrucciones.addCommand(this.commandMenu);
                this.instrucciones.setCommandListener(this);
            }
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.instrucciones);
        }
        catch (Exception exception) {
            this.menuGral = null;
            this.bubbleCanvas = null;
            this.bubbleRanking = null;
            this.menuSonido = null;
            Runtime.getRuntime().gc();
            if (this.instrucciones == null) {
                this.verInstrucciones();
            }
            this.instrucciones.repaint();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.instrucciones);
        }
    }

    public void verRanking() {
        try {
            Runtime.getRuntime().gc();
            this.bubbleRanking = new BubbleRanking(new BubblePersister(), this);
            this.bubbleRanking.addCommand(this.commandMenu);
            this.bubbleRanking.setCommandListener(this);
            this.bubbleRanking.cargar();
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.bubbleRanking);
        }
        catch (Exception exception) {
            this.menuGral = null;
            this.instrucciones = null;
            this.bubbleCanvas = null;
            this.menuSonido = null;
            Runtime.getRuntime().gc();
            this.verRanking();
        }
    }

    public void continuar() {
        try {
            if (this.bubbleCanvas != null && !this.bubbleCanvas.endOfGame) {
                this.soundManager.stop();
                this.lastsound = !this.lastsound;
                Runtime.getRuntime().gc();
                this.bubbleCanvas.play();
                Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.bubbleCanvas);
            }
        }
        catch (Exception exception) {
            this.menuGral = null;
            this.instrucciones = null;
            this.bubbleRanking = null;
            this.menuSonido = null;
            Runtime.getRuntime().gc();
            this.continuar();
        }
    }

    public void switchMusica() {
        try {
            Runtime.getRuntime().gc();
            this.menuSonido = new MenuSonido(this);
            if (this.soundManager.getsonido()) {
                this.menuSonido.setSelectedIndex(0, true);
            } else {
                this.menuSonido.setSelectedIndex(1, true);
            }
            this.menuSonido.addCommand(this.commandAceptar);
            this.menuSonido.setCommandListener(this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuSonido);
        }
        catch (Exception exception) {
            this.instrucciones = null;
            this.bubbleRanking = null;
            this.bubbleCanvas = null;
            Runtime.getRuntime().gc();
            this.switchMusica();
        }
    }

    public void opcionMenu() {
        this.opcion_menu = this.menuGral.seleccion;
        switch (this.opcion_menu) {
            case 0: {
                this.iniciarJuego();
                break;
            }
            case 1: {
                this.switchMusica();
                break;
            }
            case 2: {
                this.verInstrucciones();
                break;
            }
            case 3: {
                this.verRanking();
                break;
            }
            case 4: {
                this.continuar();
                break;
            }
            case 5: {
                this.salir();
            }
        }
    }

    public void salir() {
        this.soundManager.stop_all();
        this.soundManager.stop();
        this.wantToExit = true;
        try {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            // empty catch block
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        if (displayable == this.menuGral && command == this.commandAceptar) {
            this.opcionMenu();
        }
        if (displayable == this.textBox && command == this.commandAceptar) {
            try {
                BubblePersister bubblePersister = new BubblePersister();
                bubblePersister.lastScore = this.bubbleCanvas.getScore();
                bubblePersister.usuario = this.textBox.getString();
                bubblePersister.save();
                bubblePersister.readRecords();
                bubblePersister = null;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (this.wantToExit) {
                try {
                    this.destroyApp(true);
                    this.notifyDestroyed();
                }
                catch (MIDletStateChangeException mIDletStateChangeException) {}
            } else {
                this.textBox = null;
                Runtime.getRuntime().gc();
                this.menuGral();
            }
        }
        if (displayable == this.menuSonido && command == this.commandAceptar) {
            int n = this.menuSonido.getSelectedIndex();
            if (n == 0) {
                this.soundManager.setsonido(true);
            } else if (this.soundManager.getsonido()) {
                this.soundManager.setsonido(false);
            }
            Runtime.getRuntime().gc();
            this.menuGral();
        }
        if (command == this.commandMenu) {
            if (this.bubbleCanvas != null) {
                this.bubbleCanvas.pause();
            }
            this.menuGral();
        }
    }

    public void endOfGame() {
        int n = this.bubbleCanvas.getScore();
        BubblePersister bubblePersister = new BubblePersister();
        bubblePersister.lastScore = n;
        int n2 = bubblePersister.dignoDeRanking();
        if (n2 >= 0 && n2 < 5 && n > 0) {
            bubblePersister = null;
            Runtime.getRuntime().gc();
            this.textBox = new TextBox("Name:", "", 5, 0);
            this.textBox.addCommand(this.commandAceptar);
            this.textBox.setCommandListener((CommandListener)this);
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.textBox);
        } else {
            bubblePersister = null;
            Runtime.getRuntime().gc();
            this.menuGral();
        }
    }
}

