/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class MiscUtils {
    static int MAX_DEBUGSTRINGS = 200;
    static String[] ms_zDebugString = new String[MAX_DEBUGSTRINGS];
    static int ms_iDebugLine = 0;
    static int ms_iDebugMsg_PosX = 0;
    static int ms_iDebugMaxLine = 0;
    static boolean ms_bShowDebug = false;
    static boolean ms_bAllowLogging = true;
    static final String POSTMORTEM_NAME = "DOND2PM";
    static byte[] ms_iSaveData;
    static final String STORE_NAME_NAME = "DOND2NM";
    static final String STORE_NAME_CHARNO_CHARM = "DOND2CC";
    static final String STORE_FROM = "DOND2FR";
    static final String STORE_JOB = "DOND2JB";
    static final String STORE_LUCKYNUMBER = "DOND2LN";
    static final String STORE_PIC = "DOND2PC";
    static final String STORE_PIC_OFFSET_X = "DOND2PCX";
    static final String STORE_PIC_OFFSET_Y = "DOND2PCY";
    static final String STORE_CHAR_INDEX = "DOND2CHAR";
    static final String STORE_VIB_OPTS = "DOND2VIB";
    static final String STORE_HISTORY = "DOND2HIS";
    private static RecordStore m_RecordStore;

    public MiscUtils() {
        System.out.println("9999999----->");
    }

    static void HandleDebugKeys() {
    }

    static void DebugMsg(String _zMensaje) {
        if (ms_bAllowLogging) {
            System.out.println(_zMensaje);
            if (ms_iDebugMaxLine < MAX_DEBUGSTRINGS - 1) {
                MiscUtils.ms_zDebugString[MiscUtils.ms_iDebugMaxLine] = _zMensaje;
                ++ms_iDebugMaxLine;
            } else {
                for (int i = 0; i < MAX_DEBUGSTRINGS - 1; ++i) {
                    MiscUtils.ms_zDebugString[i] = ms_zDebugString[i + 1];
                }
                MiscUtils.ms_zDebugString[MiscUtils.MAX_DEBUGSTRINGS - 1] = _zMensaje;
            }
        }
    }

    static void DrawDebug(Graphics _g) {
    }

    static int intFromBytes(byte[] data, int offset) {
        int iRet = ((char)data[offset] & 0xFF) << 24;
        iRet += ((char)data[offset + 1] & 0xFF) << 16;
        iRet += ((char)data[offset + 2] & 0xFF) << 8;
        return iRet += (char)data[offset + 3] & 0xFF;
    }

    static short shortFromBytes(byte[] data, int offset) {
        int iRet = ((char)data[offset] & 0xFF) << 8;
        return (short)(iRet += (char)data[offset + 1] & 0xFF);
    }

    static int asBytes(int i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 24 & 0xFF);
        data[offset++] = (byte)(i >> 16 & 0xFF);
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset] = (byte)(i & 0xFF);
        return 4;
    }

    static int asBytes(short i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset] = (byte)(i & 0xFF);
        return 2;
    }

    static int asBytes(byte i, byte[] data, int offset) {
        data[offset] = i;
        return 1;
    }

    static int asBytes(boolean i, byte[] data, int offset) {
        data[offset] = i ? (byte)1 : 0;
        return 1;
    }

    static byte byteFromBytes(byte[] data, int[] offset) {
        byte cRet = data[offset[0]];
        offset[0] = offset[0] + 1;
        return cRet;
    }

    static boolean booleanFromBytes(byte[] data, int[] offset) {
        boolean bRet = data[offset[0]] != 0;
        offset[0] = offset[0] + 1;
        return bRet;
    }

    static void ReadPostmortemData() {
    }

    static void DebugPostmortemMsg(String _zMessage) {
    }

    static boolean Delete(String _File) {
        m_RecordStore = null;
        try {
            m_RecordStore = RecordStore.openRecordStore((String)_File, (boolean)true);
            if (m_RecordStore != null) {
                RecordStore.deleteRecordStore((String)_File);
                m_RecordStore.closeRecordStore();
                m_RecordStore = null;
            }
        }
        catch (RecordStoreException rse) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static byte[] OpenSavedData(String _File) {
        _File = _File + ModeMenu.ms_iselectedProfile;
        byte[] vData = null;
        m_RecordStore = null;
        try {
            m_RecordStore = RecordStore.openRecordStore((String)_File, (boolean)false);
            int iNumRecords = m_RecordStore.getNumRecords();
            if (iNumRecords == 0) {
                return null;
            }
            RecordEnumeration recEnum = m_RecordStore.enumerateRecords(null, null, false);
            vData = m_RecordStore.getRecord(recEnum.nextRecordId());
            m_RecordStore.closeRecordStore();
        }
        catch (RecordStoreNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            MiscUtils.Delete(_File);
            return null;
        }
        return vData;
    }

    static void SaveFILE(String _File, int _iSize) {
        _File = _File + ModeMenu.ms_iselectedProfile;
        m_RecordStore = null;
        try {
            m_RecordStore = RecordStore.openRecordStore((String)_File, (boolean)true);
            if (_iSize > m_RecordStore.getSizeAvailable()) {
                return;
            }
            if (m_RecordStore.getNumRecords() > 0) {
                RecordEnumeration recEnum = m_RecordStore.enumerateRecords(null, null, false);
                m_RecordStore.setRecord(recEnum.nextRecordId(), ms_iSaveData, 0, _iSize);
            } else {
                m_RecordStore.addRecord(ms_iSaveData, 0, _iSize);
            }
            m_RecordStore.closeRecordStore();
        }
        catch (Exception e) {
            MiscUtils.Delete(_File);
        }
        ms_iSaveData = null;
    }

    static void SaveVibrationOptionsToRecord() {
        byte[] vibOpt = new byte[1];
        if (ModeMenu.ms_bVibrationOn) {
            vibOpt[0] = 1;
        }
        ms_iSaveData = vibOpt;
        MiscUtils.SaveFILE(STORE_VIB_OPTS, vibOpt.length);
    }

    static void GetVibrationOptionsFromRecord() {
        byte[] iData = MiscUtils.OpenSavedData(STORE_VIB_OPTS);
        ModeMenu.ms_bVibrationOn = iData == null || iData[0] == 1;
    }

    static void SavePlayerNameToRecord(String name) {
        ms_iSaveData = name.getBytes();
        MiscUtils.SaveFILE(STORE_NAME_NAME, name.length());
        byte[] charNo = new byte[]{ModeMenu.ms_iCurrentCHARAPlayer, ModeMenu.ms_iCurrentCHARM};
        ms_iSaveData = charNo;
        MiscUtils.SaveFILE(STORE_NAME_CHARNO_CHARM, charNo.length);
    }

    static void SavePlayerStringToRecord(String recordName, String str) {
        ms_iSaveData = str.getBytes();
        MiscUtils.SaveFILE(recordName, str.length());
    }

    static void SavePlayerIntToRecord(String recordName, byte number) {
        ms_iSaveData = new byte[1];
        int length = MiscUtils.asBytes(number, ms_iSaveData, 0);
        MiscUtils.SaveFILE(recordName, length);
    }

    static void SavePlayerPicToRecord(String recordName, int[] rawData) {
        ms_iSaveData = new byte[rawData.length * 4];
        for (int i = 0; i < rawData.length; ++i) {
            MiscUtils.asBytes(rawData[i], ms_iSaveData, i * 4);
        }
        MiscUtils.SaveFILE(recordName, rawData.length * 4);
    }

    static String GetPlayerNameFromRecord() {
        String name = "";
        byte[] iData = MiscUtils.OpenSavedData(STORE_NAME_NAME);
        if (iData == null) {
            return name;
        }
        name = new String(iData);
        iData = MiscUtils.OpenSavedData(STORE_NAME_CHARNO_CHARM);
        ModeMenu.ms_iCurrentCHARAPlayer = iData[0];
        ModeMenu.ms_iCurrentCHARM = iData[1];
        return name;
    }

    static String GetPlayerStringFromRecord(String recordName) {
        String str = "";
        byte[] iData = MiscUtils.OpenSavedData(recordName);
        if (iData == null) {
            return str;
        }
        str = new String(iData);
        return str;
    }

    static int GetPlayerIntFromRecord(String recordName) {
        int number = -1;
        byte[] iData = MiscUtils.OpenSavedData(recordName);
        if (iData == null) {
            return number;
        }
        return iData[0];
    }

    static int[] GetPlayerPicFromRecord(String recordName) {
        byte[] iData = MiscUtils.OpenSavedData(recordName);
        if (iData != null) {
            int[] outputData = new int[iData.length / 4];
            if (iData == null) {
                return outputData;
            }
            for (int offset = 0; offset < outputData.length; ++offset) {
                outputData[offset] = MiscUtils.intFromBytes(iData, offset * 4);
            }
            return outputData;
        }
        return null;
    }

    static void LoadSavedData() {
        byte[] iData = MiscUtils.OpenSavedData(STORE_HISTORY);
        if (iData != null) {
            ModeQuiz.ms_iHistory = iData;
        }
    }

    static void SaveSavedData() {
        ms_iSaveData = ModeQuiz.ms_iHistory;
        MiscUtils.SaveFILE(STORE_HISTORY, ModeQuiz.ms_iHistory.length);
    }

    public static int[] RandomizeArray(int[] listIn) {
        int[] destination = new int[listIn.length];
        int[] stagingList = listIn;
        for (int i = 0; i < listIn.length; ++i) {
            int[] tempList = new int[stagingList.length == 1 ? stagingList.length : stagingList.length - 1];
            int randomNumber = Game.GetRandomInt(stagingList.length);
            destination[i] = randomNumber == 0 ? stagingList[0] : stagingList[randomNumber - 1];
            int item = 0;
            for (int j = 0; j < stagingList.length; ++j) {
                if (j == (randomNumber == 0 ? 0 : randomNumber - 1)) continue;
                tempList[item] = stagingList[j];
                ++item;
            }
            stagingList = tempList;
        }
        return destination;
    }

    static {
        m_RecordStore = null;
    }
}

