/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class PhotoCanvas
extends Canvas
implements CommandListener {
    static final int CAM_VIEWPORT_HEIGHT = 420;
    static final int CAM_VIEWPORT_WIDTH = 315;
    static final int CAM_VIEWPORT_X = 83;
    static final int CAM_VIEWPORT_Y = 20;
    static PhotoCanvas m_instance = new PhotoCanvas();
    boolean m_running = false;
    boolean m_error = false;
    private Player m_player;
    private VideoControl m_videoControl;
    boolean m_takeReq = false;
    boolean m_cancelReq = false;
    private Command m_cmdTakePhoto = new Command("Ok", 4, 1);
    private Command m_cmdCancelPhoto = new Command("Cancel", 2, 1);

    private PhotoCanvas() {
        System.out.println("ccccccc----->");
        this.m_cancelReq = false;
        this.m_takeReq = false;
        this.m_error = false;
        this.addCommand(this.m_cmdTakePhoto);
        this.addCommand(this.m_cmdCancelPhoto);
    }

    public void open() {
        try {
            this.m_player = Manager.createPlayer((String)"capture://video");
            this.m_player.realize();
            this.m_videoControl = (VideoControl)this.m_player.getControl("VideoControl");
            this.m_videoControl.initDisplayMode(1, (Object)this);
            this.m_player.start();
            this.m_videoControl.setVisible(true);
            try {
                this.m_videoControl.setDisplayFullScreen(false);
                this.m_videoControl.setDisplaySize(480, 320);
                this.m_videoControl.setDisplayLocation(0, 0);
            }
            catch (Exception me) {
                this.m_videoControl.setDisplayFullScreen(true);
            }
            Main.ms_vDisplay.setCurrent((Displayable)this);
            this.setCommandListener(this);
            this.m_running = true;
        }
        catch (Exception e) {
            this.m_error = true;
            MiscUtils.DebugMsg("*** Cam: Init error: " + e);
        }
        MiscUtils.DebugMsg("*** Cam: Init done...");
    }

    public void close() {
        this.m_running = false;
        Main.ms_vDisplay.setCurrent((Displayable)Game.ms_Game);
        this.setCommandListener(null);
        this.m_videoControl.setVisible(false);
        try {
            this.m_player.stop();
        }
        catch (Exception e) {
            MiscUtils.DebugMsg("player stop Exception");
        }
        this.m_player.close();
        this.m_player = null;
        this.m_videoControl = null;
        ModeMenu.m_bIsPromptShown = false;
        ModeMenu.m_bIsInitShown = false;
    }

    public Image click() {
        Image pic = null;
        try {
            MiscUtils.DebugMsg("*** Cam: Taking capture...");
            byte[] raw = this.m_videoControl.getSnapshot(null);
            pic = Image.createImage((byte[])raw, (int)0, (int)raw.length);
        }
        catch (Exception e) {
            MiscUtils.DebugMsg("*** Cam: Capture failed");
            MiscUtils.DebugMsg("*** Cam: Reason: " + e.toString() + ": " + e.getMessage());
            this.m_error = true;
        }
        return pic;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.m_cmdTakePhoto) {
            this.m_takeReq = true;
            MiscUtils.DebugMsg("*** Cam: Capture req");
        } else if (c == this.m_cmdCancelPhoto) {
            this.m_cancelReq = true;
            MiscUtils.DebugMsg("*** Cam: Cancel req");
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.getGameAction(keyCode) == 8) {
            this.m_takeReq = true;
            MiscUtils.DebugMsg("*** Cam: Capture req");
        }
    }

    public void paint(Graphics g) {
    }
}

