/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Board {
    static final int PSY_SHAPE_POINT = 0;
    static final int PSY_SHAPE_CIRCLE = 1;
    static final int PSY_SHAPE_SEGMENT = 2;
    static final int PSY_SHAPE_DISK = 3;
    private static final int PSY_SHAPE_MASK = 7;
    static final int PSY_SHAPE_CIRCLE_RADIUS = 0;
    static final int PSY_SHAPE_SEGMENT_ANGLE = 0;
    static final int PSY_SHAPE_SEGMENT_LENGTH = 1;
    static final int PSY_SHAPE_DISK_INN_RADIUS = 0;
    static final int PSY_SHAPE_DISK_WIDTH = 1;
    static final int PSY_DRAW_COLOR = 256;
    static final int PSY_DRAW_SPRITE = 512;
    static final int PSY_DRAW_NUMBER = 768;
    private static final int PSY_DRAW_MASK = 3840;
    static final int PSY_DRAW_COLOR_BEGIN = 0;
    static final int PSY_DRAW_COLOR_END = 1;
    static final int PSY_DRAW_SPRITE_BASE = 0;
    static final int PSY_DRAW_SPRITE_FRAMES = 1;
    static final int PSY_DRAW_NUMBER_FONT = 0;
    static final int PSY_DRAW_NUMBER_VAL = 1;
    static final int PSY_ENABLE = 8;
    static final int PSY_EMITTING = 16;
    static final int PSY_UPDATING = 32;
    static final int PSY_VISIBLE = 64;
    static final int PSY_DEAD = 4096;
    static final int PSY_RELATIVE = 8192;
    static final int PSY_FULL_ENABLE = 120;
    static final int PSY_SH_RADIUS = 0;
    static int[] psy_maxParticle;
    static int[][][] psy_pPos;
    static int[][][] psy_pDeltaPos;
    static int[][][] psy_pVel;
    static int[][] psy_pAngle;
    static int[][] psy_pLife;
    static int[][] psy_pColor;
    static byte[][] psy_pEmitter;
    static short[][] psy_pPool;
    static byte[] psy_eLayer;
    static int[][] psy_ePos;
    static int[] psy_eInitLife;
    static int[] psy_eInitLifeVar;
    static int[] psy_eInitVelMag;
    static int[] psy_eInitVelMagVar;
    static int[] psy_eInitVelAng;
    static int[] psy_eInitVelAngVar;
    static int[] psy_eFriction;
    static int[][] psy_eForce;
    static int[] psy_eFreq;
    static int[] psy_eFreqVar;
    static int[] psy_eFreqCount;
    static int[] psy_eCount;
    static int[] psy_eMaxCount;
    static int[] psy_eFlags;
    static int[][] psy_eDrawParams;
    static int[] psy_eFrameLife;
    static int[][] psy_eShapeParams;
    static short[] psy_ePool;
    static final int MAX_BLEND = 255;
    static final long[] BOARD_VALUE;
    static final int BOARD_MAX_DECIMAL_PRIZE = 2;
    static final long[] BOARD_VALUE_ROOT;
    static final int[] BOARD_ROUND_FACTOR;
    static final byte[] BOARD_NORMAL_PRIZES;
    static final byte[] BOARD_XMAS_PRIZES;
    static final byte[] BOARD_TEST_PRIZES;
    static final byte[][][] BOARD_LIGHT_ANIM;
    static final byte BOARD_ANIM_FLASHING_NAMES = 0;
    static final byte BOARD_ANIM_LIGHTS_ON = 1;
    static final byte BOARD_LAYOUT_EMPTY = 0;
    static final byte BOARD_LAYOUT_PRIZES = 2;
    static final byte BOARD_LAYOUT_FIREWORKS = 3;
    static final int BOARD_OFFSET_LEFT = 1;
    static final int BOARD_OFFSET_RIGHT = 2;
    static final int BOARD_MAX_FRAME_TILES = 29;
    static final int BOARD_MAX_TILES_TOP = 18;
    static final int BOARD_MAX_TILES_SIDE = 10;
    static final int BOARD_FIRST_LEFT = 0;
    static final int BOARD_FIRST_TOP = 10;
    static final int BOARD_FIRST_RIGHT = 19;
    static final int BOARD_FRAME_TILE_WID;
    static final int BOARD_FRAME_TILE_HEI;
    static final int BOARD_LEFT_X = -1;
    static final int BOARD_RIGHT_X;
    static final int BOARD_TOP_Y = 0;
    static final int BOARD_BOTTOM_Y;
    static final int BOARD_FLOOR_Y = 320;
    static final int BOARD_PRIZE_FIRST_BLUE = 0;
    static final int BOARD_PRIZE_FIRST_RED = 11;
    static final int BOARD_PRIZE_FIRST_SPRITE = 392;
    static final int BOARD_PRIZE_TOP_MARGIN = 4;
    static final int BOARD_PRIZE_BLUE_X;
    static final int BOARD_PRIZE_RED_X = 240;
    static final int BOARD_PRIZE_TOP_Y;
    static final int BOARD_PRIZE_WID;
    static final int BOARD_PRIZE_HEI;
    static final int BOARD_MAX_SCROLLING_FRAME;
    static final int BOARD_SCROLLING_STEP = 5;
    static final int BOARD_SHADOW_LEFT_X;
    static final int BOARD_SHADOW_RIGHT_X;
    static final int BOARD_SHADOW_TOP_Y;
    static final int BOARD_SHADOW_WID = 1;
    static final int BOARD_SHADOW_HEI;
    static final int BOARD_RED_BG_X;
    static final int BOARD_RED_BG_Y;
    static final int BOARD_RED_BG_WID;
    static final int BOARD_RED_BG_HEI;
    static final int BOARD_FW_MARGIN = 20;
    static final int BOARD_FW_WID;
    static final int BOARD_FW_HEI;
    static final int BOARD_FW_X;
    static final int BOARD_FW_Y;
    static final int BOARD_MAX_FRAME_BOX = 256;
    static final int BOARD_RED_COLOR = 12719109;
    static final int BOARD_FW_EM_OUT_INIT_LIFE = 262144;
    static final int BOARD_FW_EM_OUT_INIT_LIFE_VAR = 131072;
    static final int BOARD_FW_EM_OUT_INIT_VEL_MAG = 0x180000;
    static final int BOARD_FW_EM_OUT_INIT_VEL_MAG_VAR = 458752;
    static final int BOARD_FW_EM_OUT_INIT_VEL_ANGLE = 0;
    static final int BOARD_FW_EM_OUT_INIT_VEL_ANGLE_VAR = 0x2000000;
    static final int BOARD_FW_EM_OUT_FRICTION = 32768;
    static final int[] BOARD_FW_EM_OUT_FORCE;
    static final int BOARD_FW_EM_OUT_SPAWN_FREQ = 65536000;
    static final int BOARD_FW_EM_OUT_SPAWN_FREQ_VAR = 65536;
    static final int BOARD_FW_EM_OUT_MAX_PARTICLE = 100;
    static final int BOARD_FW_EM_OUT_FLAGS = 376;
    static final int[] BOARD_FW_EM_OUT_COLOR_MAP;
    static final int BOARD_FW_TIME = 6553;
    static final int BOARD_FW_PERIOD_BASE = 12;
    static final int BOARD_FW_PERIOD_VAR = 20;
    static final int MAX_BOX = 22;
    static boolean[] board_isPrizePresent;
    static byte board_scrollingPrize;
    static int board_frame;
    static byte board_anim;
    static int board_animFrame;
    static int board_animSequence;
    static byte board_layout;
    static int[] board_tile;
    static byte[] board_prize;
    static int board_fwEm;
    static int board_fwTime;
    static int board_fwPrizeSprite;
    static final int PLA_MAX_PAL_COLOR = 256;
    static final short PLA_CANVAS_WID;
    static final short PLA_CANVAS_HEI;
    static final int PLA_CANVAS_TOP_Y;
    static final int PLA_PIXEL_SIZE = 6;
    static final int PLA_PAL_CYCLES_1 = 7;
    static final int PLA_PAL_CYCLES_2 = 6;
    static final int PLA_PAL_CYCLES_4 = 5;
    static final int PLA_PAL_CYCLES_8 = 4;
    static final int PLA_FRAME_STEP = 4;
    static int[] pla_palette;
    static Image pla_imageBuffer;
    static short pla_canvas_wid;
    static short pla_canvas_hei;
    static short pla_pixelSize;
    static int pla_frame;

    static void psy_init(int[] a_maxParticle, int a_maxEmitter) {
        psy_maxParticle = a_maxParticle;
        int layers = a_maxParticle.length;
        psy_pPos = new int[layers][][];
        psy_pDeltaPos = new int[layers][][];
        psy_pVel = new int[layers][][];
        psy_pAngle = new int[layers][];
        psy_pLife = new int[layers][];
        psy_pColor = new int[layers][];
        psy_pEmitter = new byte[layers][];
        psy_pPool = new short[layers][];
        for (int i = 0; i < layers; ++i) {
            Board.psy_pPos[i] = new int[a_maxParticle[i]][2];
            Board.psy_pDeltaPos[i] = new int[a_maxParticle[i]][2];
            Board.psy_pVel[i] = new int[a_maxParticle[i]][2];
            Board.psy_pAngle[i] = new int[a_maxParticle[i]];
            Board.psy_pLife[i] = new int[a_maxParticle[i]];
            Board.psy_pColor[i] = new int[a_maxParticle[i]];
            Board.psy_pEmitter[i] = new byte[a_maxParticle[i]];
            Board.psy_pPool[i] = Data.sl_create(a_maxParticle[i]);
        }
        psy_eLayer = new byte[a_maxEmitter];
        psy_ePos = new int[a_maxEmitter][];
        psy_eInitLife = new int[a_maxEmitter];
        psy_eInitLifeVar = new int[a_maxEmitter];
        psy_eInitVelMag = new int[a_maxEmitter];
        psy_eInitVelMagVar = new int[a_maxEmitter];
        psy_eInitVelAng = new int[a_maxEmitter];
        psy_eInitVelAngVar = new int[a_maxEmitter];
        psy_eFriction = new int[a_maxEmitter];
        psy_eForce = new int[a_maxEmitter][];
        psy_eFreq = new int[a_maxEmitter];
        psy_eFreqVar = new int[a_maxEmitter];
        psy_eFreqCount = new int[a_maxEmitter];
        psy_eCount = new int[a_maxEmitter];
        psy_eMaxCount = new int[a_maxEmitter];
        psy_eFlags = new int[a_maxEmitter];
        psy_eDrawParams = new int[a_maxEmitter][];
        psy_eFrameLife = new int[a_maxEmitter];
        psy_eShapeParams = new int[a_maxEmitter][];
        psy_ePool = Data.sl_create(a_maxEmitter);
    }

    static void psy_clear() {
        for (int i = 0; i < psy_maxParticle.length; ++i) {
            Data.sl_clear(psy_pPool[i]);
        }
        Data.sl_clear(psy_ePool);
    }

    static int psy_createEmitter(int[] a_pos, int a_layer, int a_initLife, int a_initLifeVar, int a_initVelMag, int a_initVelMagVar, int a_initVelAng, int a_initVelAngVar, int a_friction, int[] a_force, int a_spawnFreq, int a_spawnFreqVar, int a_maxParticles, int a_flags, int[] a_drawParams, int[] a_shapeParams) {
        if (!Data.sl_canPush(psy_ePool)) {
            return -1;
        }
        int em = Data.sl_push(psy_ePool);
        Board.psy_eLayer[em] = (byte)a_layer;
        Board.psy_ePos[em] = a_pos;
        Board.psy_eInitLife[em] = a_initLife;
        Board.psy_eInitLifeVar[em] = a_initLifeVar;
        Board.psy_eInitVelMag[em] = a_initVelMag;
        Board.psy_eInitVelMagVar[em] = a_initVelMagVar;
        Board.psy_eInitVelAng[em] = a_initVelAng;
        Board.psy_eInitVelAngVar[em] = a_initVelAngVar;
        Board.psy_eFriction[em] = a_friction;
        Board.psy_eForce[em] = a_force;
        Board.psy_eFreqCount[em] = 0;
        Board.psy_eFreq[em] = a_spawnFreq;
        Board.psy_eFreqVar[em] = a_spawnFreqVar;
        Board.psy_eCount[em] = 0;
        Board.psy_eMaxCount[em] = a_maxParticles;
        Board.psy_eFlags[em] = a_flags;
        Board.psy_eDrawParams[em] = a_drawParams;
        if ((a_flags & 0xF00) == 512) {
            Board.psy_eFrameLife[em] = (psy_eInitLife[em] + psy_eInitLifeVar[em]) / psy_eDrawParams[em][1];
        }
        Board.psy_eShapeParams[em] = a_shapeParams;
        return em;
    }

    static void psy_killEmitter(int em) {
        int n = em;
        psy_eFlags[n] = psy_eFlags[n] | 0x1000;
    }

    static void psy_setDynamics(int em, int a_initVelMag, int a_initVelMagVar, int a_initVelAng, int a_initVelAngVar) {
        Board.psy_eInitVelMag[em] = a_initVelMag;
        Board.psy_eInitVelMagVar[em] = a_initVelMagVar;
        Board.psy_eInitVelAng[em] = a_initVelAng;
        Board.psy_eInitVelAngVar[em] = a_initVelAngVar;
    }

    static void psy_setFlags(int em, int a_flags) {
        int n = em;
        psy_eFlags[n] = psy_eFlags[n] | a_flags;
    }

    static void psy_clearFlags(int em, int a_flags) {
        int n = em;
        psy_eFlags[n] = psy_eFlags[n] & ~a_flags;
    }

    static void psy_runEmitters(int a_time) {
        int[] tmp0 = Data.vec_push();
        int j = Data.sl_first(psy_ePool);
        while (psy_ePool[j] != -1) {
            short em = psy_ePool[j];
            byte lay = psy_eLayer[em];
            if ((psy_eFlags[em] & 0x1000) != 0) {
                if (psy_eCount[em] > 0) {
                    j = psy_ePool[j];
                    continue;
                }
                Data.sl_remove(psy_ePool, j);
                continue;
            }
            if ((psy_eFlags[em] & 0x38) != 56) {
                j = psy_ePool[j];
                continue;
            }
            int freq = psy_eFreq[em] + Game.Random(psy_eFreqVar[em]);
            long numParts = FMath.mul(freq, a_time);
            short s = em;
            psy_eFreqCount[s] = (int)((long)psy_eFreqCount[s] + numParts);
            numParts = FMath.fix2Int(psy_eFreqCount[em]);
            short s2 = em;
            psy_eFreqCount[s2] = (int)((long)psy_eFreqCount[s2] - FMath.fix(numParts));
            int i = 0;
            while ((long)i < numParts && psy_eCount[em] < psy_eMaxCount[em] && Data.sl_canPush(psy_pPool[lay])) {
                int angle;
                int radius;
                int p = Data.sl_push(psy_pPool[lay]);
                Board.psy_pEmitter[lay][p] = (byte)em;
                int shape = psy_eFlags[em] & 7;
                if (shape == 0) {
                    FMath.vecReset(psy_pPos[lay][p]);
                } else if (shape == 1) {
                    radius = Game.Random(psy_eShapeParams[em][0]);
                    angle = Game.Random(0x2000000);
                    FMath.vecFromPolarF(radius, angle, psy_pPos[lay][p]);
                } else if (shape == 2) {
                    int angle2 = psy_eShapeParams[em][0];
                    int offs = Game.Random(psy_eShapeParams[em][1]);
                    FMath.vecFromPolarF(offs, angle2, psy_pPos[lay][p]);
                } else if (shape == 3) {
                    radius = psy_eShapeParams[em][0] + Game.Random(psy_eShapeParams[em][1]);
                    angle = Game.Random(0x2000000);
                    FMath.vecFromPolarF(radius, angle, psy_pPos[lay][p]);
                }
                if ((psy_eFlags[em] & 0x2000) == 0) {
                    FMath.addV(psy_ePos[em], psy_pPos[lay][p], psy_pPos[lay][p]);
                }
                int velMag = psy_eInitVelMag[em] + Game.Random(psy_eInitVelMagVar[em] << 1) - psy_eInitVelMagVar[em];
                int velAng = FMath.normAngle(psy_eInitVelAng[em] + Game.Random(psy_eInitVelAngVar[em] << 1) - psy_eInitVelAngVar[em]);
                FMath.vecFromPolarF(velMag, velAng, psy_pVel[lay][p]);
                Board.psy_pAngle[lay][p] = velAng;
                Board.psy_pLife[lay][p] = psy_eInitLife[em] + Game.Random(psy_eInitLifeVar[em]);
                ++i;
                short s3 = em;
                psy_eCount[s3] = psy_eCount[s3] + 1;
            }
            j = psy_ePool[j];
        }
        Data.vec_pop();
    }

    static void psy_runParticles(int a_layer, int a_time) {
        int[] delta = Data.vec_push();
        int i = Data.sl_first(psy_pPool[a_layer]);
        while (psy_pPool[a_layer][i] != -1) {
            long curLife;
            short p = psy_pPool[a_layer][i];
            byte em = psy_pEmitter[a_layer][p];
            if ((psy_eFlags[em] & 0x28) != 40) continue;
            if (psy_pLife[a_layer][p] < 0) {
                Data.sl_remove(psy_pPool[a_layer], i);
                byte by = em;
                psy_eCount[by] = psy_eCount[by] - 1;
                continue;
            }
            FMath.vecFromPolarF(psy_eFriction[em], psy_pAngle[a_layer][p], delta);
            FMath.subV(psy_pVel[a_layer][p], delta, psy_pVel[a_layer][p]);
            FMath.mmulVS(psy_eForce[em], a_time, delta);
            FMath.addV(delta, psy_pVel[a_layer][p], psy_pVel[a_layer][p]);
            FMath.vecCopy(psy_pPos[a_layer][p], psy_pDeltaPos[a_layer][p]);
            FMath.mmulVS(psy_pVel[a_layer][p], a_time, delta);
            FMath.addV(delta, psy_pPos[a_layer][p], psy_pPos[a_layer][p]);
            FMath.subV(psy_pDeltaPos[a_layer][p], psy_pPos[a_layer][p], psy_pDeltaPos[a_layer][p]);
            int[] nArray = psy_pLife[a_layer];
            short s = p;
            nArray[s] = nArray[s] - a_time;
            if ((psy_eFlags[em] & 0xF00) == 256) {
                if (psy_eDrawParams[em].length == 1) {
                    Board.psy_pColor[a_layer][p] = psy_eDrawParams[em][0];
                } else {
                    curLife = Math.max(0, psy_eInitLife[em] - psy_pLife[a_layer][p]);
                    int blend = Math.min(255, FMath.fix2Int(FMath.div(curLife * 255L, psy_eInitLife[em])));
                    Board.psy_pColor[a_layer][p] = GfxManager.GetBlendedColor(psy_eDrawParams[em][0], psy_eDrawParams[em][1], blend);
                }
            } else if ((psy_eFlags[em] & 0xF00) == 512) {
                curLife = psy_eInitLife[em] + psy_eInitLifeVar[em] - psy_pLife[a_layer][p];
                int frame = Math.min(psy_eDrawParams[em][1] - 1, FMath.fix2Int(FMath.div(curLife, psy_eFrameLife[em])));
                Board.psy_pColor[a_layer][p] = psy_eDrawParams[em][0] + frame;
            }
            i = psy_pPool[a_layer][i];
        }
        Data.vec_pop();
    }

    static void psy_drawParticles(Graphics g, int a_layer, int[] a_offs) {
        int[] pos = Data.vec_push();
        int i = Data.sl_first(psy_pPool[a_layer]);
        while (psy_pPool[a_layer][i] != -1) {
            short p = psy_pPool[a_layer][i];
            byte em = psy_pEmitter[a_layer][p];
            if ((psy_eFlags[em] & 0x48) == 72) {
                FMath.addV(psy_pPos[a_layer][p], a_offs, pos);
                if ((psy_eFlags[em] & 0x2000) != 0) {
                    FMath.addV(psy_ePos[em], pos, pos);
                }
                int posX = FMath.fix2Int(pos[0]);
                int posY = FMath.fix2Int(pos[1]);
                int oldPosX = FMath.fix2Int(pos[0] + psy_pDeltaPos[a_layer][p][0]);
                int oldPosY = FMath.fix2Int(pos[1] + psy_pDeltaPos[a_layer][p][1]);
                if ((psy_eFlags[em] & 0xF00) == 256) {
                    g.setColor(psy_pColor[a_layer][p]);
                    g.drawLine(oldPosX, oldPosY, posX, posY);
                } else if ((psy_eFlags[em] & 0xF00) == 512) {
                    GfxManager.Draw(psy_pColor[a_layer][p], posX, posY, 0, 0);
                } else if ((psy_eFlags[em] & 0xF00) == 768) {
                    // empty if block
                }
            }
            i = psy_pPool[a_layer][i];
        }
        Data.vec_pop();
    }

    static void board_init(byte[] a_distribution) {
        int i;
        for (i = 0; i < 22; ++i) {
            Board.board_prize[i] = a_distribution[i];
            Board.board_isPrizePresent[i] = true;
        }
        for (i = 0; i < 29; ++i) {
            Board.board_tile[i] = board_layout == 3 ? 427 : 428;
        }
        board_anim = 1;
        board_animFrame = 0;
        board_animSequence = 0;
    }

    static void board_setLayout(byte a_layout) {
        board_layout = a_layout;
        board_frame = 0;
    }

    static void board_initPrizeScroll(byte a_prize) {
        if (board_scrollingPrize == -1) {
            board_scrollingPrize = a_prize;
            board_frame = 0;
        }
    }

    static boolean board_canScroll() {
        return board_scrollingPrize == -1;
    }

    static boolean board_isPrizePresent(int a_prize) {
        return board_isPrizePresent[a_prize];
    }

    static int board_prizesLeft() {
        int count = 0;
        for (int i = 0; i < 22; ++i) {
            if (!board_isPrizePresent[i]) continue;
            ++count;
        }
        return count;
    }

    static void board_run() {
        Board.pla_run();
        Board.board_runLights();
        switch (board_layout) {
            case 2: {
                Board.board_runScroll();
                break;
            }
            case 3: {
                Board.board_runFireworks();
            }
        }
    }

    static void board_draw(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 480, 320);
        Board.board_drawShadow(g);
        switch (board_layout) {
            case 2: {
                Board.pla_draw(g);
                Board.board_drawPrizes(g);
                break;
            }
            case 3: {
                Board.board_drawFireworks(g);
                break;
            }
            case 0: {
                Board.pla_draw(g);
            }
        }
        Board.board_drawFrame(g);
    }

    static void board_drawFireworks(Graphics g) {
        g.setColor(12719109);
        g.fillRect(BOARD_RED_BG_X, BOARD_RED_BG_Y, BOARD_RED_BG_WID, BOARD_RED_BG_HEI);
        GfxManager.Draw(415, 240, 160, 0, 0);
        g.setClip(BOARD_RED_BG_X, BOARD_RED_BG_Y, BOARD_RED_BG_WID, BOARD_RED_BG_HEI);
        Board.psy_drawParticles(g, 0, FMath.ZEROV);
        GfxManager.Draw(board_fwPrizeSprite, 240, 160, 0, 0);
    }

    static void board_drawPrizes(Graphics g) {
        int offset;
        int i;
        int x = BOARD_PRIZE_BLUE_X;
        int y = BOARD_PRIZE_TOP_Y;
        for (i = 0; i < 11; ++i) {
            if (board_isPrizePresent[i]) {
                offset = i == board_scrollingPrize ? board_frame : 0;
                GfxManager.Draw(392 + board_prize[i], x - offset, y, 0, 0);
            }
            y += BOARD_PRIZE_HEI;
        }
        x = 240;
        y = BOARD_PRIZE_TOP_Y;
        for (i = 11; i < 22; ++i) {
            if (board_isPrizePresent[i]) {
                offset = i == board_scrollingPrize ? board_frame : 0;
                GfxManager.Draw(392 + board_prize[i], x + offset + 25, y, 0, 0);
            }
            y += BOARD_PRIZE_HEI;
        }
    }

    static void board_drawFrame(Graphics g) {
        int tile;
        int i;
        GfxManager.Draw(426, 0, 320, 0, 0);
        int x = -1;
        int y = 0;
        for (i = 0; i < 18; ++i) {
            tile = board_tile[i + 10];
            GfxManager.Draw(tile, x, y, 0, 0);
            x += BOARD_FRAME_TILE_WID;
        }
        x = -1;
        y = BOARD_BOTTOM_Y;
        for (i = 0; i < 10; ++i) {
            tile = board_tile[i + 0];
            GfxManager.Draw(tile, x, y, 0, 0);
            y -= BOARD_FRAME_TILE_HEI;
        }
        x = BOARD_RIGHT_X;
        y = 0 + BOARD_FRAME_TILE_HEI;
        for (i = 0; i < 10; ++i) {
            tile = board_tile[i + 19];
            GfxManager.Draw(tile, x, y, 0, 0);
            y += BOARD_FRAME_TILE_HEI;
        }
        if (Main.ms_iSeasonal == 1) {
            GfxManager.Draw(134, 0, 0, 0, 0);
        } else if (Main.ms_iSeasonal == 2) {
            GfxManager.Draw(155, 0, 0, 0, 0);
        } else if (Main.ms_iSeasonal == 3) {
            GfxManager.Draw(133, 0, 0, 0, 0);
        }
    }

    static void board_runFireworks() {
        Board.psy_runEmitters(6553);
        Board.psy_runParticles(0, 6553);
        if (board_fwEm != -1) {
            Board.psy_killEmitter(board_fwEm);
            board_fwEm = -1;
        }
        if (board_fwTime == 0) {
            board_fwTime = 12 + Constants.getRandomInt(20);
            int x = FMath.fix(Constants.getRandomInt(BOARD_FW_WID) + BOARD_FW_X);
            int y = FMath.fix(Constants.getRandomInt(BOARD_FW_HEI) + BOARD_FW_Y);
            board_fwEm = Board.psy_createEmitter(new int[]{x, y}, 0, 262144, 131072, 0x180000, 458752, 0, 0x2000000, 32768, BOARD_FW_EM_OUT_FORCE, 65536000, 65536, 100, 376, BOARD_FW_EM_OUT_COLOR_MAP, BOARD_FW_EM_OUT_COLOR_MAP);
        }
        --board_fwTime;
    }

    static void board_runScroll() {
        if (board_scrollingPrize != -1 && (board_frame += 5) > BOARD_MAX_SCROLLING_FRAME) {
            Board.board_isPrizePresent[Board.board_scrollingPrize] = false;
            board_scrollingPrize = (byte)-1;
        }
    }

    static void board_runLights() {
        byte frameStep;
        if (board_anim == -1) {
            return;
        }
        if (board_animFrame == 0) {
            int i;
            for (i = 0; i < 29; ++i) {
                Board.board_tile[i] = 428;
            }
            if (board_layout == 3) {
                for (i = 0; i < BOARD_LIGHT_ANIM[board_anim][board_animSequence].length; ++i) {
                    Board.board_tile[Board.BOARD_LIGHT_ANIM[Board.board_anim][Board.board_animSequence][i]] = 427;
                }
            }
            board_animSequence = (board_animSequence + 1) % (BOARD_LIGHT_ANIM[board_anim].length - 1);
        }
        board_animFrame = (frameStep = BOARD_LIGHT_ANIM[board_anim][BOARD_LIGHT_ANIM[board_anim].length - 1][0]) > 0 ? (board_animFrame + 1) % frameStep : 1;
    }

    static void board_drawShadow(Graphics g) {
        g.setColor(0);
        g.drawRect(BOARD_SHADOW_LEFT_X, BOARD_SHADOW_TOP_Y, 1, BOARD_SHADOW_HEI);
        g.drawRect(BOARD_SHADOW_RIGHT_X, BOARD_SHADOW_TOP_Y, 1, BOARD_SHADOW_HEI);
    }

    static void pla_init(int a_canvasWid, int a_canvasHei, int a_pixelSize) {
        pla_imageBuffer = Image.createImage((int)a_canvasWid, (int)a_canvasHei);
        System.out.println("Width--->" + a_canvasWid);
        pla_canvas_wid = (short)a_canvasWid;
        pla_canvas_hei = (short)a_canvasHei;
        pla_pixelSize = (short)a_pixelSize;
    }

    static void pla_reset() {
        pla_frame = 0;
    }

    static void pla_generatePalette(int a_cycles) {
        for (int i = 0; i < 256; ++i) {
            int b = Math.min(255, 128 + FMath.fix2Int(64 * FMath.sin(256 * i >> a_cycles)));
            int b2 = b * 75 / 100;
            Board.pla_palette[i] = GfxManager.rgbColor(b2, b2, b2);
        }
    }

    static void pla_drawPal(Graphics g) {
        for (int i = 0; i < 256; ++i) {
            g.setColor(pla_palette[i]);
            g.drawLine(0, i, 480, i);
        }
    }

    static void pla_run() {
        Graphics g = pla_imageBuffer.getGraphics();
        for (int x = 0; x < pla_canvas_wid; x += pla_pixelSize) {
            for (int y = 0; y < pla_canvas_hei; y += pla_pixelSize) {
                int color = Board.pla_sinFunc(x, y, pla_frame);
                g.setColor(pla_palette[color]);
                g.fillRect(x, y, (int)pla_pixelSize, (int)pla_pixelSize);
            }
        }
        pla_frame += 4;
    }

    static int pla_sinFunc(int x, int y, int a_time) {
        int color = 128 + FMath.fix2Int(128 * FMath.sin((x << 1) + a_time));
        color += 128 + FMath.fix2Int(128 * FMath.sin(y + (a_time << 1)));
        color += 128 + FMath.fix2Int(128 * FMath.sin(x + y << 0) - a_time);
        color += 128 + FMath.fix2Int(128 * FMath.sin(x - y << 0) + a_time);
        color = Math.min(255, color / 4);
        return color;
    }

    static void pla_draw(Graphics g) {
        g.drawImage(pla_imageBuffer, 240, PLA_CANVAS_TOP_Y, 17);
    }

    static {
        BOARD_VALUE = new long[]{655L, 6553L, 32768L, 65536L, 327680L, FMath.fix(10L), FMath.fix(50L), FMath.fix(100L), FMath.fix(250L), FMath.fix(500L), FMath.fix(750L), FMath.fix(1000L), FMath.fix(3000L), FMath.fix(5000L), FMath.fix(10000L), FMath.fix(15000L), FMath.fix(20000L), FMath.fix(35000L), FMath.fix(50000L), FMath.fix(75000L), FMath.fix(100000L), FMath.fix(250000L)};
        BOARD_VALUE_ROOT = new long[]{655L, 1966L, 45875L, 65536L, 131072L, FMath.fix(3L), FMath.fix(7L), FMath.fix(10L), FMath.fix(15L), FMath.fix(22L), FMath.fix(27L), FMath.fix(31L), FMath.fix(54L), FMath.fix(70L), FMath.fix(100L), FMath.fix(122L), FMath.fix(141L), FMath.fix(187L), FMath.fix(223L), FMath.fix(273L), FMath.fix(316L), FMath.fix(500L)};
        BOARD_ROUND_FACTOR = new int[]{15, 12, 10, 8, 5, 0, 0};
        BOARD_NORMAL_PRIZES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
        BOARD_XMAS_PRIZES = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 18, 19, 20, 21, 22, 23};
        BOARD_TEST_PRIZES = new byte[]{0, 1, 2, 3, 4, 5, 10, 9, 8, 7, 6, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22};
        BOARD_LIGHT_ANIM = new byte[][][]{new byte[][]{{2, 8, 14, 20, 26}, {3, 9, 19, 25}, {4, 10, 18, 24}, {5, 11, 17, 23}, {0, 6, 12, 16, 22, 28}, {1, 7, 13, 15, 21, 27}, {6}}, new byte[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28}, {0}}};
        BOARD_FRAME_TILE_WID = GfxManager.SPRITE_DATA[427][3];
        BOARD_FRAME_TILE_HEI = GfxManager.SPRITE_DATA[427][4];
        BOARD_RIGHT_X = 480 - BOARD_FRAME_TILE_WID + 2;
        BOARD_BOTTOM_Y = 0 + 10 * BOARD_FRAME_TILE_HEI;
        BOARD_PRIZE_BLUE_X = BOARD_FRAME_TILE_WID;
        BOARD_PRIZE_TOP_Y = BOARD_FRAME_TILE_HEI + 4;
        BOARD_PRIZE_WID = GfxManager.SPRITE_DATA[393][3];
        BOARD_PRIZE_HEI = GfxManager.SPRITE_DATA[393][4];
        BOARD_MAX_SCROLLING_FRAME = BOARD_PRIZE_WID + 4;
        BOARD_SHADOW_LEFT_X = BOARD_FRAME_TILE_WID - 1;
        BOARD_SHADOW_RIGHT_X = BOARD_SHADOW_LEFT_X + BOARD_FRAME_TILE_WID * 16 - 2;
        BOARD_SHADOW_TOP_Y = BOARD_FRAME_TILE_HEI;
        BOARD_SHADOW_HEI = BOARD_FRAME_TILE_HEI * 10 - 1;
        BOARD_RED_BG_X = BOARD_SHADOW_LEFT_X + 2;
        BOARD_RED_BG_Y = BOARD_SHADOW_TOP_Y + 2;
        BOARD_RED_BG_WID = (short)(BOARD_FRAME_TILE_WID * 16 - 4);
        BOARD_RED_BG_HEI = (short)(BOARD_FRAME_TILE_HEI * 10 - 2);
        BOARD_FW_WID = BOARD_RED_BG_WID - 40;
        BOARD_FW_HEI = BOARD_RED_BG_HEI - 40;
        BOARD_FW_X = BOARD_RED_BG_X + 20;
        BOARD_FW_Y = BOARD_RED_BG_Y + 20;
        BOARD_FW_EM_OUT_FORCE = new int[]{0, 131072};
        BOARD_FW_EM_OUT_COLOR_MAP = new int[]{0xFFFF40, 12719109};
        board_isPrizePresent = new boolean[22];
        board_scrollingPrize = (byte)-1;
        board_tile = new int[29];
        board_prize = new byte[22];
        board_fwEm = -1;
        board_fwTime = 0;
        board_fwPrizeSprite = 416;
        PLA_CANVAS_WID = (short)BOARD_RED_BG_WID;
        PLA_CANVAS_HEI = (short)BOARD_RED_BG_HEI;
        PLA_CANVAS_TOP_Y = BOARD_FRAME_TILE_HEI + 2;
        pla_palette = new int[256];
        pla_imageBuffer = null;
        pla_canvas_wid = PLA_CANVAS_WID;
        pla_canvas_hei = PLA_CANVAS_HEI;
        pla_pixelSize = (short)6;
        pla_frame = 0;
    }
}

