/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public final class Sound
extends MergeDest {
    private static boolean m_soundEnabled = true;
    private static boolean m_vibrationEnabled = true;
    private static Player m_musicPlayer;
    private static Player m_sfxPlayer;
    private static int m_musicCurrentId;
    private static long m_pausedMusicMediaTime;
    private static String[] m_musicFilenames;
    private static String[] m_sfxFilenames;
    private static int m_lastSFX_index;
    private static int[] m_bgms;

    static void InitializeMusic() {
        m_musicFilenames = new String[15];
        Sound.m_musicFilenames[0] = "/m_title.mid";
        Sound.m_musicFilenames[1] = "/m_victory.mid";
        Sound.m_musicFilenames[2] = "/m_gameover.mid";
        Sound.m_musicFilenames[3] = "/m_arpeggio_BGM.mid";
        Sound.m_musicFilenames[4] = "/m_disco_BGM.mid";
        Sound.m_musicFilenames[5] = "/m_flute_BGM.mid";
        Sound.m_musicFilenames[6] = "/m_funny_BGM.mid";
        Sound.m_musicFilenames[7] = "/m_jazzy_BGM.mid";
        Sound.m_musicFilenames[8] = "/m_rock_n_roll_BGM.mid";
        Sound.m_musicFilenames[9] = "/m_rock_BGM.mid";
        Sound.m_musicFilenames[10] = "/m_suspense_BGM.mid";
        Sound.m_musicFilenames[11] = "/sfx_random_squares.mid";
        Sound.m_musicFilenames[14] = "/m_intro.mid";
    }

    static int GetRandomBGM() {
        int n = Utils.NextRandom(0, m_bgms.length);
        return m_bgms[n];
    }

    static void InitializeSoundEffects() {
        m_sfxFilenames = new String[1];
        Sound.m_sfxFilenames[0] = "/sfx_buzzer.mid";
        m_sfxPlayer = Sound.LoadPlayerFromFile(m_sfxFilenames[0]);
        m_lastSFX_index = 0;
    }

    static boolean isEnabled() {
        return m_soundEnabled;
    }

    static void SetEnabled(boolean bl) {
        if (!bl) {
            Sound.StopAllSounds();
        }
        m_soundEnabled = bl;
    }

    static void PlayMusic(int n, boolean bl) {
        if (!m_soundEnabled) {
            return;
        }
        Sound.StopMusic();
        m_musicPlayer = Sound.LoadPlayerFromFile(m_musicFilenames[n]);
        if (bl) {
            System.out.println("setLoopCount");
            m_musicPlayer.setLoopCount(30);
        }
        m_musicCurrentId = n;
        Sound.Play(m_musicPlayer);
    }

    static void StopMusic() {
        m_pausedMusicMediaTime = 0L;
        if (m_musicPlayer != null) {
            Sound.Stop(m_musicPlayer);
            m_musicPlayer = null;
        }
    }

    static boolean ResumeMusic() {
        if (!m_soundEnabled) {
            return true;
        }
        if (m_musicCurrentId != -1) {
            try {
                if (m_musicPlayer == null) {
                    m_musicPlayer = Sound.LoadPlayerFromFile(m_musicFilenames[m_musicCurrentId]);
                }
                try {
                    m_musicPlayer.setMediaTime(m_pausedMusicMediaTime);
                }
                catch (Exception exception) {}
                m_musicPlayer.start();
                return true;
            }
            catch (MediaException mediaException) {}
        }
        return false;
    }

    static void PauseMusic() {
        if (m_musicPlayer != null) {
            try {
                m_pausedMusicMediaTime = m_musicPlayer.getMediaTime();
                m_musicPlayer.stop();
                return;
            }
            catch (MediaException mediaException) {}
        }
    }

    static void PlaySound(int n) {
        if (!m_soundEnabled) {
            return;
        }
        if (n < 0 || n >= 1) {
            return;
        }
        if (m_lastSFX_index != n) {
            Sound.StopSound();
            m_sfxPlayer = Sound.LoadPlayerFromFile(m_sfxFilenames[n]);
            m_lastSFX_index = n;
        }
        Sound.Play(m_sfxPlayer);
    }

    static void StopSound() {
        m_lastSFX_index = -1;
        Sound.Stop(m_sfxPlayer);
    }

    static void StopAllSounds() {
        SoundThread.StopMusic();
        SoundThread.StopSound();
    }

    static boolean IsVibrationEnabled() {
        return m_vibrationEnabled;
    }

    static void SetVibration(boolean bl) {
        m_vibrationEnabled = bl;
    }

    static void Vibrate() {
        if (!m_vibrationEnabled) {
            return;
        }
        Display display = Display.getDisplay((MIDlet)GameBase.m_midlet);
        display.vibrate(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Player LoadPlayerFromFile(String string) {
        InputStream inputStream;
        Player player;
        block16: {
            if (string == null) {
                return null;
            }
            player = null;
            inputStream = null;
            inputStream = "".getClass().getResourceAsStream(string);
            if (inputStream != null) break block16;
            Object var3_3 = null;
            if (inputStream == null) return null;
            try {
                inputStream.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
        String string2 = string.endsWith("wav") ? "audio/x-wav" : (string.endsWith("amr") ? "audio/amr" : "audio/midi");
        player = Manager.createPlayer((InputStream)inputStream, (String)string2);
        try {
            player.realize();
            player.prefetch();
        }
        catch (Exception exception) {}
        if (inputStream == null) return player;
        try {
            inputStream.close();
            return player;
        }
        catch (Exception exception) {}
        return player;
        catch (Exception exception) {
            try {
                if (inputStream == null) return player;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                inputStream.close();
                return player;
            }
            catch (Exception exception3) {}
            return player;
        }
    }

    private static void Play(Player player) {
        if (player == null) {
            return;
        }
        try {
            player.start();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void Stop(Player player) {
        if (player == null) {
            return;
        }
        try {
            if (player.getState() == 400) {
                player.stop();
            }
        }
        catch (Exception exception) {}
        try {
            player.getState();
        }
        catch (Exception exception) {}
        try {
            player.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static {
        m_musicCurrentId = -1;
        m_lastSFX_index = -1;
        m_bgms = new int[]{3, 4, 5, 6, 7, 8, 9, 10};
    }
}

