/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public final class ResourceManager
extends MergeDest {
    public static boolean m_canCloseResourceWhenLoading = true;
    public static int[][] m_resourceIndex;
    public static byte[] m_resourceData;
    public static int m_resourceDataLength;
    static InputStream m_resourceStream;
    static int m_resourceCurrentPackage;
    static int m_resourceCurrentOffset;
    static int m_language;

    public static void ResourceManagerInitialize() {
        try {
            InputStream inputStream = "".getClass().getResourceAsStream("/i");
            int n = ResourceManager.ReadInt(inputStream);
            m_resourceIndex = new int[n][];
            for (int i = 0; i < n; ++i) {
                int n2 = ResourceManager.ReadInt(inputStream);
                ResourceManager.m_resourceIndex[i] = new int[n2 * 2];
                for (int j = 0; j < n2; ++j) {
                    ResourceManager.m_resourceIndex[i][j * 2] = ResourceManager.ReadInt(inputStream);
                    ResourceManager.m_resourceIndex[i][j * 2 + 1] = ResourceManager.ReadInt(inputStream);
                }
            }
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static int PrepareStream(int n) {
        int n2 = 0;
        try {
            boolean bl = false;
            if ((n & 0x10000000) != 0) {
                bl = true;
                n &= 0xFFFFFFF;
            }
            int n3 = n >> 16;
            int n4 = n & 0xFFFF;
            if (bl) {
                n4 += m_language;
            }
            if (n3 != m_resourceCurrentPackage) {
                ResourceManager.ResourceManagerClose();
                ResourceManager.ResourceManagerOpen(n3);
            }
            int n5 = m_resourceIndex[n3][n4 << 1];
            n2 = m_resourceIndex[n3][(n4 << 1) + 1];
            if (n5 < m_resourceCurrentOffset) {
                ResourceManager.ResourceManagerClose();
                ResourceManager.ResourceManagerOpen(n3);
            }
            m_resourceStream.skip(n5 - m_resourceCurrentOffset);
            m_resourceCurrentOffset = n5;
        }
        catch (IOException iOException) {}
        return n2;
    }

    public static void LoadResource(int n) {
        try {
            int n2 = ResourceManager.PrepareStream(n);
            m_resourceStream.read(m_resourceData, 0, n2);
            m_resourceDataLength = n2;
            m_resourceCurrentOffset += n2;
            if (m_canCloseResourceWhenLoading) {
                ResourceManager.ResourceManagerClose();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static void ResourceManagerClose() {
        try {
            if (m_resourceStream != null) {
                m_resourceStream.close();
                m_resourceStream = null;
                Console.GC();
                m_resourceCurrentOffset = 0;
                m_resourceCurrentPackage = -1;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static void ResourceManagerOpen(int n) {
        m_resourceStream = "".getClass().getResourceAsStream("/" + String.valueOf(n));
        m_resourceCurrentPackage = n;
    }

    private static int ReadInt(InputStream inputStream) throws IOException {
        return inputStream.read() << 24 | inputStream.read() << 16 | inputStream.read() << 8 | inputStream.read();
    }

    public static void FreeResourceData() {
        ResourceManager.ResourceManagerClose();
        Console.GC();
    }

    public static int GetInt(int n) {
        int n2 = m_resourceData[n + 3] & 0xFF;
        n2 |= (m_resourceData[n + 2] & 0xFF) << 8;
        n2 |= (m_resourceData[n + 1] & 0xFF) << 16;
        return n2 |= (m_resourceData[n + 0] & 0xFF) << 24;
    }

    static {
        m_resourceData = new byte[12668];
        m_resourceCurrentPackage = -1;
        m_resourceCurrentOffset = 0;
        m_language = 0;
    }
}

