/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    private static Player playerSE;
    private static Player playerBGM;
    public boolean bSound = false;
    private boolean bMultiPlayer;
    public int previousMusic = -1;
    public static final int SOUND = 1;
    public static final int MUSIC = 16;
    public static final int MIXED = 32;
    public static final int VOLUME_FULL = 100;
    public static final int VOLUME_HALF = 50;
    public static final int VOLUME_OFF = 0;
    private byte[] soundBuffer;

    public SoundPlayer(boolean bl) {
        this.bMultiPlayer = bl;
    }

    private void playSE(int n, boolean bl) {
        try {
            if (playerSE != null) {
                playerSE.stop();
                playerSE.deallocate();
                playerSE.close();
                playerSE = null;
            }
            int n2 = Constants.RES_SOUND[n + 1] - Constants.RES_SOUND[n];
            this.soundBuffer = new byte[n2];
            InputStream inputStream = this.getClass().getResourceAsStream("/RES_SND.bin");
            inputStream.skip(Constants.RES_SOUND[n]);
            try {
                inputStream.read(this.soundBuffer, 0, n2);
            }
            catch (Exception exception) {
                System.out.println("idx: " + n);
                exception.printStackTrace();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.soundBuffer);
            playerSE = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
            playerSE.realize();
            if (bl) {
                playerSE.setLoopCount(-1);
            } else {
                playerSE.setLoopCount(1);
            }
            playerSE.start();
            ((InputStream)byteArrayInputStream).close();
            inputStream.close();
            this.soundBuffer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void playBGM(int n) {
        try {
            if (playerBGM != null) {
                playerBGM.stop();
                playerBGM.deallocate();
                playerBGM.close();
                playerBGM = null;
            }
            int n2 = Constants.RES_SOUND[n + 1] - Constants.RES_SOUND[n];
            this.soundBuffer = new byte[n2];
            InputStream inputStream = this.getClass().getResourceAsStream("/RES_SND.bin");
            inputStream.skip(Constants.RES_SOUND[n]);
            try {
                inputStream.read(this.soundBuffer, 0, n2);
            }
            catch (Exception exception) {
                System.out.println("idx: " + n);
                exception.printStackTrace();
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.soundBuffer);
            playerBGM = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
            playerBGM.realize();
            playerBGM.setLoopCount(-1);
            playerBGM.start();
            inputStream.close();
            ((InputStream)byteArrayInputStream).close();
            this.soundBuffer = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void play(int n, int n2) {
        if (this.bSound) {
            if (n2 == 1) {
                this.playSE(n, false);
            } else if (n2 == 16) {
                this.previousMusic = n;
                if (this.bMultiPlayer) {
                    this.playBGM(n);
                } else {
                    this.playSE(n, true);
                }
            }
        }
    }

    public void setVolume(int n, int n2) {
        if (!this.bMultiPlayer) {
            n2 = 1;
        }
        try {
            if (n2 == 1) {
                if (playerSE != null) {
                    playerSE.realize();
                    VolumeControl volumeControl = (VolumeControl)playerSE.getControl("VolumeControl");
                    volumeControl.setLevel(n);
                }
            } else if (n2 == 16) {
                if (playerBGM != null) {
                    playerBGM.realize();
                    VolumeControl volumeControl = (VolumeControl)playerBGM.getControl("VolumeControl");
                    volumeControl.setLevel(n);
                }
            } else {
                VolumeControl volumeControl;
                if (playerSE != null) {
                    playerSE.realize();
                    volumeControl = (VolumeControl)playerSE.getControl("VolumeControl");
                    volumeControl.setLevel(n);
                }
                if (playerBGM != null) {
                    playerBGM.realize();
                    volumeControl = (VolumeControl)playerBGM.getControl("VolumeControl");
                    volumeControl.setLevel(n);
                }
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void stop(int n) {
        try {
            if (!this.bMultiPlayer) {
                n = 1;
            }
            if (n == 1) {
                if (playerSE != null) {
                    playerSE.stop();
                    playerSE.deallocate();
                    playerSE.close();
                }
                playerSE = null;
            } else if (n == 16) {
                if (playerBGM != null) {
                    playerBGM.stop();
                    playerBGM.deallocate();
                    playerBGM.close();
                }
                playerBGM = null;
            } else if (n == 32) {
                if (playerSE != null) {
                    playerSE.stop();
                    playerSE.deallocate();
                    playerSE.close();
                }
                playerSE = null;
                if (playerBGM != null) {
                    playerBGM.stop();
                    playerBGM.deallocate();
                    playerBGM.close();
                }
                playerBGM = null;
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void forcePlayPreviousMusic() {
        this.soundOn();
        if (this.bSound) {
            int n = this.previousMusic;
            InputStream inputStream = null;
            ByteArrayInputStream byteArrayInputStream = null;
            try {
                if (playerBGM != null) {
                    playerBGM.stop();
                    playerBGM.deallocate();
                    playerBGM.close();
                    playerBGM = null;
                }
                int n2 = Constants.RES_SOUND[n + 1] - Constants.RES_SOUND[n];
                this.soundBuffer = new byte[n2];
                inputStream = this.getClass().getResourceAsStream("/RES_SND.bin");
                inputStream.skip(Constants.RES_SOUND[n]);
                try {
                    inputStream.read(this.soundBuffer, 0, n2);
                }
                catch (Exception exception) {
                    System.out.println("idx: " + n);
                    exception.printStackTrace();
                }
                byteArrayInputStream = new ByteArrayInputStream(this.soundBuffer);
                playerBGM = Manager.createPlayer((InputStream)byteArrayInputStream, (String)"audio/midi");
                playerBGM.realize();
                playerBGM.setLoopCount(-1);
                while (playerBGM.getState() != 400) {
                    try {
                        playerBGM.start();
                    }
                    catch (MediaException mediaException) {
                        mediaException.printStackTrace();
                    }
                }
                inputStream.close();
                ((InputStream)byteArrayInputStream).close();
                this.soundBuffer = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void forceStop() {
        if (playerSE != null) {
            try {
                while (playerSE.getState() == 400) {
                    playerSE.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (playerBGM != null) {
            try {
                while (playerBGM.getState() == 400) {
                    playerBGM.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void soundOff() {
        this.bSound = false;
        this.stop(32);
    }

    public void soundOn() {
        this.bSound = true;
    }

    public void playPreviousMusic() {
        this.play(this.previousMusic, 16);
    }
}

