/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer {
    private static Player playerSE;
    private static Player playerBGM;
    public boolean bSound = false;
    private boolean bMultiPlayer;
    public int previousMusic = -1;
    public static final int SOUND = 1;
    public static final int MUSIC = 16;
    public static final int MIXED = 32;
    public static final int VOLUME_FULL = 100;
    public static final int VOLUME_HALF = 50;
    public static final int VOLUME_OFF = 0;
    private byte[] soundBuffer;

    public SoundPlayer(boolean multi) {
        this.bMultiPlayer = multi;
    }

    private void playSE(int name, boolean loop) {
        try {
            if (playerSE != null) {
                playerSE.stop();
                playerSE.deallocate();
                playerSE.close();
                playerSE = null;
            }
            int dataSize = Constants.RES_SOUND[name + 1] - Constants.RES_SOUND[name];
            this.soundBuffer = new byte[dataSize];
            InputStream in = this.getClass().getResourceAsStream("/RES_SND.bin");
            in.skip(Constants.RES_SOUND[name]);
            try {
                in.read(this.soundBuffer, 0, dataSize);
            }
            catch (Exception e) {
                System.out.println("idx: " + name);
                e.printStackTrace();
            }
            ByteArrayInputStream in2 = new ByteArrayInputStream(this.soundBuffer);
            playerSE = Manager.createPlayer((InputStream)in2, (String)"audio/midi");
            playerSE.realize();
            if (loop) {
                playerSE.setLoopCount(-1);
            } else {
                playerSE.setLoopCount(1);
            }
            playerSE.start();
            ((InputStream)in2).close();
            in.close();
            this.soundBuffer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playBGM(int name) {
        try {
            if (playerBGM != null) {
                playerBGM.stop();
                playerBGM.deallocate();
                playerBGM.close();
                playerBGM = null;
            }
            int dataSize = Constants.RES_SOUND[name + 1] - Constants.RES_SOUND[name];
            this.soundBuffer = new byte[dataSize];
            InputStream in = this.getClass().getResourceAsStream("/RES_SND.bin");
            in.skip(Constants.RES_SOUND[name]);
            try {
                in.read(this.soundBuffer, 0, dataSize);
            }
            catch (Exception e) {
                System.out.println("idx: " + name);
                e.printStackTrace();
            }
            ByteArrayInputStream in2 = new ByteArrayInputStream(this.soundBuffer);
            playerBGM = Manager.createPlayer((InputStream)in2, (String)"audio/midi");
            playerBGM.realize();
            playerBGM.setLoopCount(-1);
            playerBGM.start();
            in.close();
            ((InputStream)in2).close();
            this.soundBuffer = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void play(int name, int mode) {
        if (this.bSound) {
            if (mode == 1) {
                this.playSE(name, false);
            } else if (mode == 16) {
                this.previousMusic = name;
                if (this.bMultiPlayer) {
                    this.playBGM(name);
                } else {
                    this.playSE(name, true);
                }
            }
        }
    }

    public void setVolume(int volume, int mode) {
        if (!this.bMultiPlayer) {
            mode = 1;
        }
        try {
            if (mode == 1) {
                if (playerSE != null) {
                    playerSE.realize();
                    VolumeControl vcSound = (VolumeControl)playerSE.getControl("VolumeControl");
                    vcSound.setLevel(volume);
                }
            } else if (mode == 16) {
                if (playerBGM != null) {
                    playerBGM.realize();
                    VolumeControl vcMusic = (VolumeControl)playerBGM.getControl("VolumeControl");
                    vcMusic.setLevel(volume);
                }
            } else {
                VolumeControl vcMixed;
                if (playerSE != null) {
                    playerSE.realize();
                    vcMixed = (VolumeControl)playerSE.getControl("VolumeControl");
                    vcMixed.setLevel(volume);
                }
                if (playerBGM != null) {
                    playerBGM.realize();
                    vcMixed = (VolumeControl)playerBGM.getControl("VolumeControl");
                    vcMixed.setLevel(volume);
                }
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stop(int mode) {
        try {
            if (!this.bMultiPlayer) {
                mode = 1;
            }
            if (mode == 1) {
                if (playerSE != null) {
                    playerSE.stop();
                    playerSE.deallocate();
                    playerSE.close();
                }
                playerSE = null;
            } else if (mode == 16) {
                if (playerBGM != null) {
                    playerBGM.stop();
                    playerBGM.deallocate();
                    playerBGM.close();
                }
                playerBGM = null;
            } else if (mode == 32) {
                if (playerSE != null) {
                    playerSE.stop();
                    playerSE.deallocate();
                    playerSE.close();
                }
                playerSE = null;
                if (playerBGM != null) {
                    playerBGM.stop();
                    playerBGM.deallocate();
                    playerBGM.close();
                }
                playerBGM = null;
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void forcePlayPreviousMusic() {
        this.soundOn();
        if (this.bSound) {
            int name = this.previousMusic;
            InputStream in = null;
            ByteArrayInputStream in2 = null;
            try {
                if (playerSE != null) {
                    playerSE.stop();
                    playerSE.deallocate();
                    playerSE.close();
                    playerSE = null;
                }
                int dataSize = Constants.RES_SOUND[name + 1] - Constants.RES_SOUND[name];
                this.soundBuffer = new byte[dataSize];
                in = this.getClass().getResourceAsStream("/RES_SND.bin");
                in.skip(Constants.RES_SOUND[name]);
                try {
                    in.read(this.soundBuffer, 0, dataSize);
                }
                catch (Exception e) {
                    System.out.println("idx: " + name);
                    e.printStackTrace();
                }
                in2 = new ByteArrayInputStream(this.soundBuffer);
                playerSE = Manager.createPlayer((InputStream)in2, (String)"audio/midi");
                playerSE.realize();
                playerSE.setLoopCount(-1);
                while (playerSE.getState() != 400) {
                    try {
                        playerSE.start();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                }
                in.close();
                ((InputStream)in2).close();
                this.soundBuffer = null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void forceStop() {
        if (playerSE != null) {
            try {
                while (playerSE.getState() == 400) {
                    playerSE.stop();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (playerBGM != null) {
            try {
                while (playerBGM.getState() == 400) {
                    playerBGM.stop();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void soundOff() {
        this.bSound = false;
        this.stop(32);
    }

    public void soundOn() {
        this.bSound = true;
    }

    public void playPreviousMusic() {
        this.play(this.previousMusic, 16);
    }
}

