/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontEngine {
    private static final StringBuffer CHARSET = new StringBuffer().append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'\"(){}[].,:;?!~^+-*%/\\>=<_#&@").append("\u00c1").append("\u00c0").append("\u00c4").append("\u00c2").append("\u00c6").append("\u00c7").append("\u00c9").append("\u00c8").append("\u00cb").append("\u00ca").append("\u00cd").append("\u00cc").append("\u00cf").append("\u00ce").append("\u00d3").append("\u00d2").append("\u00d6").append("\u00d4").append("\u00da").append("\u00d9").append("\u00dc").append("\u00db").append("\u00e1").append("\u00e0").append("\u00e4").append("\u00e2").append("\u00e6").append("\u00e7").append("\u00e9").append("\u00e8").append("\u00eb").append("\u00ea").append("\u00ed").append("\u00ec").append("\u00ef").append("\u00ee").append("\u00f3").append("\u00f2").append("\u00f6").append("\u00f4").append("\u00fa").append("\u00f9").append("\u00fc").append("\u00fb").append("\u00bf").append("\u00df").append("\u00a1").append("\u00d1").append("\u00a9").append('\u00f0');
    private static final String charsetString = CHARSET.toString();
    private int fontNumbers = 0;
    private int screenWidth;
    private int bckupScreenWidth;
    private int[] fontHeight;
    private int[][] fontWidths;
    private int spacing = 0;
    private StringBuffer tempStringBuffer = new StringBuffer();
    private Image[] font;
    private Graphics gx;
    public static final int NOWRAP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 8;
    public static final int TOP = 16;
    public static final int VCENTER = 32;
    public static final int BOTTOM = 64;
    public static final int SUPERCENTER = 128;
    private DataInputStream in = null;
    private InputStream ini = null;
    byte[] FontBuffer;
    private int oldResIdx = -1;

    public FontEngine(int screen_width, int font_number) {
        this.screenWidth = screen_width;
        this.bckupScreenWidth = screen_width;
        this.fontNumbers = font_number;
        this.font = new Image[font_number];
        this.fontHeight = new int[font_number];
        this.fontWidths = new int[font_number][CHARSET.length()];
    }

    public void openTextStream() {
        this.ini = this.getClass().getResourceAsStream("/RES_FONT.bin");
        this.in = new DataInputStream(this.ini);
    }

    public void closeTextStream() {
        try {
            this.in.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.oldResIdx = -1;
    }

    public boolean addFont(int index, int idx, int[] widths, int height) {
        if (index >= this.fontNumbers) {
            return false;
        }
        this.font[index] = null;
        int dataSize = Constants.RES_FONT[idx + 1] - Constants.RES_FONT[idx];
        if (this.FontBuffer == null || this.FontBuffer.length < dataSize) {
            this.FontBuffer = new byte[dataSize];
        }
        try {
            if (this.oldResIdx != -1) {
                this.in.skipBytes(Constants.RES_FONT[idx] - Constants.RES_FONT[this.oldResIdx + 1]);
            } else {
                this.in.skipBytes(Constants.RES_FONT[idx]);
            }
            this.in.read(this.FontBuffer, 0, dataSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.oldResIdx = idx;
        this.font[index] = Image.createImage((byte[])this.FontBuffer, (int)0, (int)dataSize);
        this.fontWidths[index] = widths;
        this.fontHeight[index] = height;
        return true;
    }

    public boolean removeFont(int index) {
        if (this.font[index] == null) {
            return false;
        }
        this.font[index] = null;
        this.fontWidths[index] = null;
        this.fontHeight[index] = 0;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public int getFontHeight(int index) {
        return this.fontHeight[index];
    }

    public String wrapText(int index, String text, int width) {
        int offset;
        int length = 0;
        int iCharWidth = 0;
        int indexChar = 0;
        int underscoreCharIndex = this.getCharIndex('_');
        int textLength = text.length();
        int buffWord = 0;
        String buffer = new String();
        this.tempStringBuffer.setLength(0);
        int spaceLineEnd = this.fontWidths[index][underscoreCharIndex] + this.spacing;
        for (offset = 0; offset < textLength; ++offset) {
            char character = text.charAt(offset);
            if (character != '|') {
                indexChar = character == ' ' ? underscoreCharIndex : this.getCharIndex(character);
                iCharWidth = this.fontWidths[index][indexChar];
            }
            if (character == '|') {
                length = 0;
            } else if (length + buffWord - spaceLineEnd > width && character == ' ') {
                length = 0;
                if (this.tempStringBuffer.charAt(this.tempStringBuffer.length() - 1) == ' ') {
                    this.tempStringBuffer.setCharAt(this.tempStringBuffer.length() - 1, '|');
                } else {
                    this.tempStringBuffer.append('|');
                }
            }
            if (character == ' ' && character != '|') {
                length += buffWord + iCharWidth + this.spacing;
                buffWord = 0;
                this.tempStringBuffer.append(buffer + ' ');
                buffer = "";
                continue;
            }
            buffWord += iCharWidth + this.spacing;
            buffer = buffer + character;
        }
        if (offset >= textLength - 2 && length + buffWord <= width) {
            this.tempStringBuffer.append(buffer);
            buffer = "";
        } else {
            int tmpStringLength = this.tempStringBuffer.length();
            if (tmpStringLength != 0) {
                this.tempStringBuffer.deleteCharAt(tmpStringLength - 1);
            }
            if (buffer.indexOf("|") == -1) {
                this.tempStringBuffer.append("|" + buffer);
            } else {
                this.tempStringBuffer.append(buffer);
            }
            buffer = "";
        }
        return this.tempStringBuffer.toString();
    }

    public void setGraphics(Graphics g) {
        this.gx = g;
    }

    public void drawFont(int index, String text, int x, int y, int align) {
        this.drawFont(this.gx, index, text, x, y, align);
    }

    public void drawFontR(int index, String text, int x, int y, int align) {
        this.drawFont(this.gx, index, text, x - this.getTextWidth(index, text), y, align);
    }

    public void drawFont(Graphics g, int index, String text, int x, int y, int align) {
        int dx = x;
        int dy = y;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        int indexChar = 0;
        int textWidth = 0;
        boolean space = false;
        textWidth = this.getMaxLineWidtht(index, text, 0);
        if ((align & 8) != 0) {
            if (this.screenWidth != this.bckupScreenWidth) {
                this.screenWidth = textWidth;
            }
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.screenWidth);
            }
            dx -= textWidth >> 1;
        } else if ((align & 0x80) != 0) {
            if (this.screenWidth != this.bckupScreenWidth) {
                this.screenWidth = textWidth;
            }
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.screenWidth);
            }
            dx -= this.getLineWidth(index, text, 0) >> 1;
        } else if ((align & 4) != 0) {
            this.screenWidth = this.screenWidth != this.bckupScreenWidth ? textWidth : x;
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.screenWidth);
            }
            dx -= this.getLineWidth(index, text, 0);
        } else {
            this.screenWidth = this.screenWidth != this.bckupScreenWidth ? textWidth : (this.screenWidth -= x);
            if ((align & 1) == 0) {
                text = this.wrapText(index, text, this.screenWidth);
            }
        }
        if ((align & 0x20) != 0) {
            dy -= this.getTextHeight(index, text) / 2;
        } else if ((align & 0x40) != 0) {
            dy -= this.getTextHeight(index, text);
        }
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char character = text.charAt(i);
            if (character == '|') {
                if ((align & 8) != 0) {
                    dx = x;
                    dx -= textWidth >> 1;
                    dy += this.fontHeight[index];
                    continue;
                }
                if ((align & 0x80) != 0) {
                    dx = x;
                    dx -= this.getLineWidth(index, text, i + 1) >> 1;
                    dy += this.fontHeight[index];
                    continue;
                }
                if ((align & 4) != 0) {
                    dx = x;
                    dx -= this.getLineWidth(index, text, i + 1);
                    dy += this.fontHeight[index];
                    continue;
                }
                if ((align & 2) == 0) continue;
                dx = x;
                dy += this.fontHeight[index];
                continue;
            }
            if (character == ' ') {
                space = true;
                indexChar = this.getCharIndex('_');
            } else {
                indexChar = this.getCharIndex(character);
                space = false;
            }
            int iCharWidth = this.fontWidths[index][indexChar];
            if (iCharWidth < 0) continue;
            int iCharPosX = this.getCharPosX(index, indexChar);
            int iCharPosY = this.getCharPosY(index, indexChar);
            g.setClip(dx, dy, iCharWidth, this.fontHeight[index]);
            if (!space) {
                g.drawImage(this.font[index], dx - iCharPosX, dy - iCharPosY, 20);
            }
            dx += iCharWidth + this.spacing;
        }
        this.resetWidth();
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public int getTextHeight(int index, String text) {
        int height = 0;
        int buffPos = 0;
        while (buffPos != -1) {
            ++height;
            if ((buffPos = text.indexOf(124, buffPos)) == -1) continue;
            ++buffPos;
        }
        return height * this.fontHeight[index];
    }

    public int getTextWidth(int index, String text) {
        int textLength = text.length();
        char character = '\u0000';
        int length = 0;
        int iCharWidth = 0;
        int indexChar = 0;
        for (int i = 0; i < textLength; ++i) {
            character = text.charAt(i);
            indexChar = character == ' ' ? this.getCharIndex('_') : this.getCharIndex(character);
            iCharWidth = this.fontWidths[index][indexChar];
            length += iCharWidth + this.spacing;
        }
        return length;
    }

    public int getLineWidth(int index, String text, int offset) {
        int length = 0;
        int iCharWidth = 0;
        int indexChar = 0;
        int textLength = text.length();
        int buffWord = 0;
        int spaceLineEnd = 0;
        char character = '\u0000';
        spaceLineEnd = this.fontWidths[index][this.getCharIndex('_')] + this.spacing;
        while (offset < textLength) {
            character = text.charAt(offset);
            if (character == '|' || length + buffWord > this.screenWidth) {
                if (character == '|') break;
                return length;
            }
            indexChar = character == ' ' ? this.getCharIndex('_') : this.getCharIndex(character);
            iCharWidth = this.fontWidths[index][indexChar];
            if (character == ' ' && character != '|') {
                length += buffWord;
                buffWord = spaceLineEnd + this.spacing;
            } else {
                buffWord += iCharWidth + this.spacing;
            }
            ++offset;
        }
        return length += buffWord;
    }

    public int getMaxLineWidtht(int index, String text, int offset) {
        int length = 0;
        int iCharWidth = 0;
        int indexChar = 0;
        int textLength = text.length();
        int buffWord = 0;
        int longestLine = 0;
        int spaceLineEnd = this.fontWidths[index][this.getCharIndex('_')] + this.spacing;
        int startLoop = --offset;
        char character = '\u0000';
        while (offset < textLength) {
            if (startLoop != offset) {
                if (character == ' ' && character != '|') {
                    length += buffWord;
                    buffWord = spaceLineEnd + this.spacing;
                } else {
                    buffWord += iCharWidth + this.spacing;
                }
            }
            if (++offset != textLength) {
                character = text.charAt(offset);
                if (character != '|' && length + buffWord <= this.screenWidth) {
                    indexChar = character == ' ' ? this.getCharIndex('_') : this.getCharIndex(character);
                    iCharWidth = this.fontWidths[index][indexChar];
                    continue;
                }
                if (length > longestLine) {
                    longestLine = length;
                }
                length = 0;
                continue;
            }
            if (length + buffWord <= longestLine) continue;
            longestLine = length + buffWord;
        }
        if (length + buffWord <= this.screenWidth && length + buffWord > longestLine) {
            longestLine = length + buffWord;
        }
        return longestLine;
    }

    public int getLineWidth(int index, String text) {
        return this.getLineWidth(index, text, 0);
    }

    public int getCharIndex(char character) {
        return charsetString.indexOf(character);
    }

    private int getCharPosX(int font_index, int index) {
        int offset = 0;
        for (int i = this.getLineBreak(this.getFontLineNumber(index)); i < index; ++i) {
            offset += this.fontWidths[font_index][i];
        }
        return offset;
    }

    private int getCharPosY(int font_index, int index) {
        return this.fontHeight[font_index] * this.getFontLineNumber(index);
    }

    private int getFontLineNumber(int index) {
        int line = 0;
        if (index <= 14) {
            line = 0;
        }
        if (index > 14 && index <= 30) {
            line = 1;
        }
        if (index > 30 && index <= 53) {
            line = 2;
        }
        if (index > 53 && index <= 80) {
            line = 3;
        }
        if (index > 80 && index <= 97) {
            line = 4;
        }
        if (index > 97 && index <= 114) {
            line = 5;
        }
        if (index > 114 && index <= 139) {
            line = 6;
        }
        return line;
    }

    private int getLineBreak(int line_num) {
        int count = 0;
        switch (line_num) {
            case 0: {
                count = 0;
                break;
            }
            case 1: {
                count = 15;
                break;
            }
            case 2: {
                count = 31;
                break;
            }
            case 3: {
                count = 54;
                break;
            }
            case 4: {
                count = 81;
                break;
            }
            case 5: {
                count = 98;
                break;
            }
            case 6: {
                count = 115;
            }
        }
        return count;
    }

    private boolean isFontLoaded(int index) {
        return this.font[index] != null;
    }

    public void setSpacing(int space) {
        this.spacing = space;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void resetSpacing() {
        this.spacing = 0;
    }

    public void setDrawWidth(int width) {
        this.screenWidth = width;
    }

    public void resetWidth() {
        this.screenWidth = this.bckupScreenWidth;
    }
}

