/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;

final class Storage {
    private int progressFinish;
    private int progress;
    private String currentPackage;
    private Hashtable fileMap;
    private Vector stringKeys = null;
    private Vector stringValues = null;
    private static final int TYPE_UNKNOWN = 0;
    private static final int TYPE_SPRITE = 4;
    private static final int ANCHOR_LEFT = 1;
    private static final int ANCHOR_TOP = 2;
    private static final int COLLISION = 4;
    static final int SPRITE_FRAMES = 0;
    static final int SPRITE_BOX = 1;
    static final int SPRITE_FRAME_BOXES = 2;
    static final int SPRITE_COLLISION_BOXES = 3;
    private static Storage theStorage = null;

    private Storage() {
        this.loadStrings();
    }

    static Storage getTheStorage() {
        if (theStorage == null) {
            theStorage = new Storage();
        }
        return theStorage;
    }

    static void destroy() {
        if (theStorage != null) {
            theStorage = null;
        }
    }

    static final int convertByte(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    static final int parseInt(byte[] byArray, int n) {
        return Storage.convertByte(byArray[n++]) << 24 | Storage.convertByte(byArray[n++]) << 16 | Storage.convertByte(byArray[n++]) << 8 | Storage.convertByte(byArray[n]);
    }

    static final int parseUnsignedShort(byte[] byArray, int n) {
        return Storage.convertByte(byArray[n++]) << 8 | Storage.convertByte(byArray[n]);
    }

    static final int countBits(int n) {
        int n2 = 0;
        while (n != 0) {
            if ((n & 1) != 0) {
                ++n2;
            }
            n >>>= 1;
        }
        return n2;
    }

    final int readInteger(InputStream inputStream) throws IOException {
        this.advanceProgress(4);
        return (inputStream.read() & 0xFF) << 24 | (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
    }

    final int readUnsignedShort(InputStream inputStream) throws IOException {
        this.advanceProgress(2);
        return (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
    }

    final int readUnsignedByte(InputStream inputStream) throws IOException {
        this.advanceProgress(1);
        return inputStream.read();
    }

    final int readArray(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        do {
            if ((n = byArray.length - n2) > 1024) {
                n = 1024;
            }
            if ((n = inputStream.read(byArray, n2, n)) < 1) break;
            this.advanceProgress(n);
        } while ((n2 += n) < byArray.length);
        return n2;
    }

    private Object[] readSpriteData(InputStream inputStream, int n) throws IOException {
        Image[] imageArray;
        Object[] objectArray = new Object[]{null, null, null, null};
        objectArray[0] = imageArray = new Image[this.readUnsignedByte(inputStream)];
        int[] nArray = new int[]{0, 0, this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream)};
        objectArray[1] = nArray;
        int n2 = this.readUnsignedByte(inputStream);
        int[] nArray2 = null;
        if ((n2 & 4) != 0) {
            nArray2 = new int[]{this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream)};
        }
        Object object = null;
        Object object2 = null;
        int n3 = 0;
        int n4 = 0;
        for (int k = 0; k < imageArray.length; ++k) {
            int n5;
            n2 = this.readUnsignedByte(inputStream);
            if ((n2 & 3) != 0) {
                if (object == null) {
                    object = new int[imageArray.length][];
                    for (n5 = 0; n5 < ((int[][])object).length; ++n5) {
                        object[k] = null;
                    }
                    objectArray[2] = object;
                }
                n3 = 0;
                n4 = 0;
                if ((n2 & 1) != 0) {
                    n3 = this.readUnsignedShort(inputStream);
                }
                if ((n2 & 2) != 0) {
                    n4 = this.readUnsignedShort(inputStream);
                }
                if ((n3 | n4) != 0) {
                    object[k] = new int[]{n3, n4, 0, 0};
                }
            }
            if (object2 == null && (nArray2 != null || (n2 & 4) != 0)) {
                object2 = new int[imageArray.length][];
                for (n5 = 0; n5 < ((int[][])object2).length; ++n5) {
                    object2[k] = null;
                }
                objectArray[3] = object2;
            }
            if ((n2 & 4) != 0) {
                object2[k] = new int[]{this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream), this.readUnsignedShort(inputStream)};
            } else if (object2 != null) {
                object2[k] = nArray2;
            }
            int n6 = this.readInteger(inputStream);
            byte[] byArray = new byte[n6];
            this.readArray(inputStream, byArray);
            imageArray[k] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
            byArray = null;
            if ((object == null || object[k] == null) && imageArray[k].getWidth() == nArray[2] && imageArray[k].getHeight() == nArray[3]) continue;
            if (object == null && object == null) {
                object = new int[imageArray.length][];
                for (n5 = 0; n5 < ((int[][])object).length; ++n5) {
                    object[k] = null;
                }
                objectArray[2] = object;
            }
            if (object[k] == null) {
                object[k] = new int[]{0, 0, imageArray[k].getWidth(), imageArray[k].getHeight()};
                continue;
            }
            object[k][2] = imageArray[k].getWidth();
            object[k][3] = imageArray[k].getHeight();
        }
        return objectArray;
    }

    private byte[] readSoundData(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[this.readUnsignedShort(inputStream)];
        this.readArray(inputStream, byArray);
        return byArray;
    }

    void unloadPackage() {
        this.fileMap = null;
        this.currentPackage = null;
        System.gc();
    }

    void loadPackage(String string, boolean bl) throws IOException {
        if (string.equals(this.currentPackage)) {
            return;
        }
        this.unloadPackage();
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string + " not found");
        }
        int n = (this.readUnsignedByte(inputStream) << 24) + (this.readUnsignedByte(inputStream) << 16) + (this.readUnsignedByte(inputStream) << 8) + this.readUnsignedByte(inputStream);
        int n2 = (this.readUnsignedByte(inputStream) << 8) + this.readUnsignedByte(inputStream);
        byte[] byArray = new byte[n];
        if (this.readArray(inputStream, byArray) != n) {
            throw new IOException();
        }
        int n3 = 0;
        if (bl) {
            this.initProgress(Storage.getTotalPackageSize(byArray));
        } else {
            this.endProgress();
        }
        this.fileMap = new Hashtable(n2);
        block3: for (int k = 0; k < n2; ++k) {
            int n4 = (Storage.convertByte(byArray[n3++]) << 24) + (Storage.convertByte(byArray[n3++]) << 16) + (Storage.convertByte(byArray[n3++]) << 8) + Storage.convertByte(byArray[n3++]);
            byte by = byArray[n3++];
            int n5 = Storage.convertByte(byArray[n3++]);
            String string2 = new String(byArray, n3, n5, "ISO8859_1");
            n3 += n5;
            switch (by) {
                case 4: {
                    this.fileMap.put(string2, this.readSpriteData(inputStream, n4));
                    continue block3;
                }
                default: {
                    byte[] byArray2 = new byte[n4];
                    this.readArray(inputStream, byArray2);
                    this.fileMap.put(string2, byArray2);
                }
            }
        }
        inputStream.close();
        this.endProgress();
    }

    private static int getTotalPackageSize(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = (Storage.convertByte(byArray[n2++]) << 24) + (Storage.convertByte(byArray[n2++]) << 16) + (Storage.convertByte(byArray[n2++]) << 8) + Storage.convertByte(byArray[n2++]);
            int n4 = ++n2;
            ++n2;
            int n5 = Storage.convertByte(byArray[n4]);
            n2 += n5;
            n += n3;
        }
        return n;
    }

    Object[] loadSprite(String string) throws IOException {
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string + " not found");
        }
        return this.readSpriteData(inputStream, 0);
    }

    byte[] loadSound(String string) throws IOException {
        InputStream inputStream = string.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new IOException(string + " not found");
        }
        return this.readSoundData(inputStream, 0);
    }

    Object[] getSpriteData(String string) {
        Object[] objectArray = (Object[])this.fileMap.get(string.toLowerCase());
        if (objectArray == null) {
            throw new RuntimeException("sprite \"" + string + "\" not loaded");
        }
        return objectArray;
    }

    byte[] getData(String string) {
        byte[] byArray = (byte[])this.fileMap.get(string);
        if (byArray == null) {
            throw new RuntimeException("data \"" + string + "\" not loaded");
        }
        return byArray;
    }

    private void initProgress(int n) {
        this.progressFinish = n;
        this.progress = 0;
        Screen screen = Screen.getScreen();
        screen.setProgress(0, true);
    }

    private void endProgress() {
        this.progressFinish = -1;
    }

    private void advanceProgress(int n) {
        if (this.progressFinish > 0 && FlippysFlyingFrenzy.game != null) {
            this.progress += n;
            int n2 = this.progress * 100 / this.progressFinish;
            if (n2 != FlippysFlyingFrenzy.game.getProgress()) {
                Game.setProgress(n2, true);
            }
        }
    }

    private void loadStrings() {
        try {
            this.stringKeys = new Vector();
            this.stringValues = new Vector();
            String string = "/res/language.txt";
            DataInputStream dataInputStream = new DataInputStream(string.getClass().getResourceAsStream(string));
            int n = dataInputStream.readUnsignedShort();
            if (n != 65534) {
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while (!bl) {
                boolean bl4 = true;
                String string2 = "";
                Character c2 = null;
                while (bl4) {
                    try {
                        Character c3 = new Character((char)(dataInputStream.readUnsignedByte() + (dataInputStream.readUnsignedByte() << 8)));
                        if (c2 == null) {
                            c2 = c3;
                        }
                        if (c3.charValue() != '\n' && c3.charValue() != '\r') {
                            if (c3.charValue() == 'n' && string2.charAt(string2.length() - 1) == '\\') {
                                string2 = string2.substring(0, string2.length() - 1);
                                string2 = string2 + "\n";
                            } else {
                                string2 = string2 + c3;
                            }
                        }
                        if (c3.charValue() == '\n' && c2.charValue() == '\r') {
                            bl4 = false;
                        }
                        c2 = c3;
                    }
                    catch (Exception exception) {
                        bl4 = false;
                        bl = true;
                    }
                }
                if (string2 == null) continue;
                String string3 = string2;
                string3.trim();
                if (!string3.equals("")) {
                    String string4 = string3.substring(0, string3.indexOf("=")).trim();
                    String string5 = string3.substring(string3.indexOf("=") + 1, string3.length()).trim();
                    string5 = string5.substring(1, string5.length() - 1);
                    this.stringKeys.addElement(string4);
                    this.stringValues.addElement(string5);
                }
                string2 = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getString(String string) {
        int n = this.stringKeys.size();
        for (int k = 0; k < n; ++k) {
            String string2 = (String)this.stringKeys.elementAt(k);
            if (!string2.equals(string)) continue;
            return (String)this.stringValues.elementAt(k);
        }
        return string;
    }
}

