/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Sprite2
extends Showable {
    protected static final int NONE = 0;
    protected static final int FLIPPED = 8192;
    protected static final int ROT90 = 90;
    protected static final int ROT180 = 180;
    protected static final int ROT270 = 270;
    private Object[] spriteData;
    private Image[] spriteDataMirror;
    int x;
    int y;
    int xVelocity;
    int yVelocity;
    int ticksSinceFrameChange;
    int frame;
    boolean mirrored = false;
    boolean mirroredVer = false;
    boolean loopedHorizontally;
    byte[] frameSequence;
    boolean tiled = false;
    int tileCount = 0;
    int subFrame = 0;
    int transform = 0;
    int ticksPerFrame;

    Sprite2() {
        this.reset();
    }

    Sprite2(Object[] objectArray) {
        this();
        this.setVisible(true);
        this.transmogrify(objectArray);
    }

    void createMirrorData() {
    }

    void createMirrorDataVertical() {
    }

    void transmogrify(Object[] objectArray) {
        this.spriteData = objectArray;
        this.ticksSinceFrameChange = 0;
        this.frameSequence = null;
        this.frame = 0;
    }

    Object[] getSpriteData() {
        return this.spriteData;
    }

    void reset() {
        this.x = 0;
        this.y = 0;
        this.xVelocity = 0;
        this.yVelocity = 0;
        this.visible = false;
        this.ticksSinceFrameChange = 0;
        this.frame = 0;
        this.frameSequence = null;
        this.ticksPerFrame = 256;
    }

    void setPosition(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    void setFrame(int n) {
        this.frame = n;
    }

    void update() {
        if (this.ticksPerFrame > 0) {
            this.ticksSinceFrameChange += 256;
            int n = this.ticksSinceFrameChange / this.ticksPerFrame;
            if (n > 0) {
                this.frame += n;
                this.frame %= this.frameSequence == null ? this.getRawFrameCount() : this.frameSequence.length;
                this.ticksSinceFrameChange = 0;
            }
        }
        this.x += this.xVelocity;
        this.y += this.yVelocity;
    }

    int getRawFrame() {
        return this.frameSequence == null ? this.frame : this.frameSequence[this.frame];
    }

    void paint(Graphics graphics, int n, int n2) {
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)graphics);
        int n3 = this.getRawFrame();
        if (n3 >= 0) {
            int[] nArray = this.getBoundingRect(n3);
            if (this.transform == 0) {
                graphics.drawImage(this.getImage(n3), n + nArray[0], n2 + nArray[1], 0);
            } else {
                directGraphics.drawImage(this.getImage(n3), n + nArray[0], n2 + nArray[1], 0, this.transform);
            }
        }
    }

    void paintLooped(Graphics graphics, int n, int n2) {
        Screen screen = Screen.getScreen();
        int n3 = this.getWidth();
        n %= n3;
        while (n < screen.right) {
            this.paint(graphics, n, n2);
            n += n3;
        }
    }

    void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        Screen screen = Screen.getScreen();
        int n = screen.toScreenSpaceX(this.x);
        int n2 = screen.toScreenSpaceY(this.y);
        if (this.loopedHorizontally) {
            this.paintLooped(graphics, n, n2);
        } else {
            this.paint(graphics, n, n2);
        }
    }

    int getWidth() {
        return ((int[])this.spriteData[1])[2];
    }

    int getHeight() {
        return ((int[])this.spriteData[1])[3];
    }

    int getCenterX() {
        return this.x + Screen.toObjectSpace(this.getWidth() >> 1);
    }

    int getCenterY() {
        return this.y + Screen.toObjectSpace(this.getHeight() >> 1);
    }

    int getRawFrameCount() {
        return ((Image[])this.spriteData[0]).length;
    }

    Image getImage(int n) {
        return ((Image[])this.spriteData[0])[n];
    }

    int[] getBoundingRect(int n) {
        if (n >= 0) {
            int[] nArray;
            if (this.spriteData[2] != null && (nArray = ((int[][])this.spriteData[2])[n]) != null) {
                if (!this.mirrored) {
                    return nArray;
                }
                return nArray;
            }
            return (int[])this.spriteData[1];
        }
        return Screen.NULL_RECT;
    }

    int[] getCollisionRect(int n) {
        if (n >= 0) {
            int[] nArray;
            if (this.spriteData[3] != null && (nArray = ((int[][])this.spriteData[3])[n]) != null) {
                return nArray;
            }
            return this.getBoundingRect(n);
        }
        return Screen.NULL_RECT;
    }

    boolean canCollide() {
        int[] nArray = this.getCollisionRect(this.getRawFrame());
        return this.isVisible() && nArray[2] > 0 && nArray[3] > 0;
    }

    int checkCollision(Sprite2[] sprite2Array, int n) {
        int[] nArray = this.getCollisionRect(this.getRawFrame());
        int n2 = nArray[0] + Screen.toPixelSpace(this.x);
        int n3 = nArray[1] + Screen.toPixelSpace(this.y);
        int n4 = n2 + nArray[2];
        int n5 = n3 + nArray[3];
        for (int k = n; k < sprite2Array.length; ++k) {
            int n6;
            int n7;
            int n8;
            int[] nArray2;
            int n9;
            if (!sprite2Array[k].canCollide() || !Sprite2.isIntersecting(n2, n3, n4, n5, n9 = (nArray2 = sprite2Array[k].getCollisionRect(sprite2Array[k].getRawFrame()))[0] + Screen.toPixelSpace(sprite2Array[k].x), n8 = nArray2[1] + Screen.toPixelSpace(sprite2Array[k].y), n7 = n9 + nArray2[2], n6 = n8 + nArray2[3])) continue;
            return k;
        }
        return -1;
    }

    boolean checkCollision(Sprite2 sprite2) {
        int[] nArray = this.getCollisionRect(this.getRawFrame());
        int n = nArray[0] + Screen.toPixelSpace(this.x);
        int n2 = nArray[1] + Screen.toPixelSpace(this.y);
        int n3 = n + nArray[2];
        int n4 = n2 + nArray[3];
        int[] nArray2 = sprite2.getCollisionRect(sprite2.getRawFrame());
        int n5 = nArray2[0] + Screen.toPixelSpace(sprite2.x);
        int n6 = nArray2[1] + Screen.toPixelSpace(sprite2.y);
        int n7 = n5 + nArray2[2];
        int n8 = n6 + nArray2[3];
        return Sprite2.isIntersecting(n, n2, n3, n4, n5, n6, n7, n8);
    }

    boolean isOnScreen() {
        Screen screen = Screen.getScreen();
        int[] nArray = this.getBoundingRect(this.getRawFrame());
        int n = nArray[0] + screen.toScreenSpaceX(this.x);
        int n2 = nArray[1] + screen.toScreenSpaceY(this.y);
        int n3 = n + nArray[2];
        int n4 = n2 + nArray[3];
        int[] nArray2 = screen.getScreenRect();
        int n5 = nArray2[0];
        int n6 = nArray2[1];
        int n7 = n5 + nArray2[2];
        int n8 = n6 + nArray2[3];
        return Sprite2.isIntersecting(n, n2, n3, n4, n5, n6, n7, n8);
    }

    static boolean isIntersecting(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        return n <= n7 && n3 >= n5 && n2 <= n8 && n4 >= n6;
    }

    static boolean checkDistance(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - n3;
        int n7 = n2 - n4;
        return n6 * n6 + n7 * n7 <= n5 * n5;
    }

    boolean checkDistance(Sprite2 sprite2, int n) {
        return Sprite2.checkDistance(this.getCenterX(), this.getCenterY(), sprite2.getCenterX(), sprite2.getCenterY(), n);
    }

    void destroy() {
        this.spriteData = null;
        this.frameSequence = null;
    }

    void setMirrored(boolean bl) {
        this.mirrored = bl;
    }

    void setMirroredVer(boolean bl) {
        this.mirroredVer = bl;
    }
}

