/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class AnimatedObject {
    private AnimatedObject pNext;
    private int nPriority;
    private int nLayer;
    AnimatedObjectData pAnimatedObjectData;
    int nAObjectDataType;
    int nScreenPosX;
    int nScreenPosY;
    Image pImg;
    byte nFrameTick;
    int nCurrentAction;
    int nNextAction = -1;
    short nCurrentFrame;
    byte nFlags;
    byte nDelay = 1;
    boolean bLoop = true;
    boolean bUseWiseDraw;
    boolean bNeedDrawUpdate;
    static int[][] m_cueColorDark = new int[10][];
    static int[][] m_cueColorLight = new int[10][];
    static int m_cueAlpha = 255;
    static AnimatedObject[] pRoot = new AnimatedObject[3];

    AnimatedObject() {
    }

    AnimatedObject(int n, int n2) {
        this.CreateAnimatedObject(n, n2, -1, 0, true, 0);
    }

    AnimatedObject(int n, int n2, int n3, int n4, boolean bl, int n5) {
        this.CreateAnimatedObject(n, n2, n3, n4, bl, n5);
    }

    void InitAnimatedObject(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (n != -99) {
            this.nAObjectDataType = (short)n;
        }
        this.nScreenPosX = n2;
        this.nScreenPosY = n3;
        if (n4 != -99) {
            this.nCurrentFrame = (short)n4;
        }
        if (n5 != -99) {
            this.nCurrentAction = n5;
        }
        if (n6 != -99) {
            this.nNextAction = n6;
        }
        this.changePriority(n7, n8);
        this.bUseWiseDraw = bl;
    }

    void CreateAnimatedObject(int n, int n2, int n3, int n4, boolean bl, int n5) {
        if (n != -1) {
            GameCanvasEx.RM_Load(n);
        }
        if (n2 != -1) {
            GameCanvasEx.RM_Load(n2);
        }
        if (n3 != -1) {
            GameCanvasEx.RM_Load(n3);
        }
        GameCanvasEx.RM_Synchronize(-1);
        this.pAnimatedObjectData = AnimatedObjectData.loadData(GameCanvasEx.RM_GetResource_Array_Byte(n));
        this.nAObjectDataType = this.pAnimatedObjectData.nType;
        if (n2 != -1) {
            this.pImg = GameCanvasEx.RM_GetResource_Image(n2);
        }
        if (bl) {
            if (n3 != -1) {
                GameCanvasEx.RM_Free(n3);
            }
            if (n2 != -1) {
                GameCanvasEx.RM_Free(n2);
            }
            if (n != -1) {
                GameCanvasEx.RM_Free(n);
            }
            GameCanvasEx.RM_Synchronize(-1);
        }
    }

    private void play() {
        this.nFrameTick = (byte)(this.nFrameTick + 1);
        if (this.nNextAction != -1) {
            this.nCurrentAction = this.nNextAction;
            this.nCurrentFrame = 0;
            this.nFrameTick = 0;
            this.nNextAction = -1;
        } else if (this.nFrameTick >= this.nDelay) {
            this.nFrameTick = 0;
            this.nCurrentFrame = (short)(this.nCurrentFrame + 1);
            if (this.nCurrentFrame >= (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][0] & 0xFF)) {
                this.nCurrentFrame = this.bLoop ? (short)0 : (short)(this.nCurrentFrame - 1);
            }
        }
        this.nDelay = (byte)(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameDurationColBox[(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][1 + this.nCurrentFrame] & 0xFF) << 1] & 0x7F);
    }

    void setCurrentAction(int n) {
        this.nCurrentAction = (short)n;
        this.nNextAction = -1;
        this.rewind();
        this.bLoop = true;
    }

    void setLooping(boolean bl) {
        this.bLoop = bl;
    }

    void setPosition(int n, int n2) {
        this.nScreenPosX = (short)n;
        this.nScreenPosY = (short)n2;
    }

    Image getImage() {
        return this.pImg;
    }

    void setImage(Image image) {
        this.pImg = image;
    }

    boolean isInDrawList() {
        return AnimatedObject.AnimationPlayer_Check(this, this.nLayer);
    }

    void addToDrawList() {
        AnimatedObject.AnimationPlayer_Play(this, this.nLayer);
    }

    void removeFromDrawList() {
        AnimatedObject.AnimationPlayer_Stop(this);
    }

    void setFlag(boolean bl, byte by) {
        this.nFlags = bl ? (byte)(this.nFlags | by) : (byte)(this.nFlags & ~by);
    }

    void changePriority(int n, int n2) {
        boolean bl = this.isInDrawList();
        if (bl) {
            this.removeFromDrawList();
        }
        if (n >= 0) {
            this.nPriority = n;
        }
        if (n2 >= 0) {
            this.nLayer = n2;
        }
        if (bl) {
            this.addToDrawList();
        }
    }

    boolean isEndOfAnimation() {
        return this.nCurrentFrame == (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][0] & 0xFF) - 1;
    }

    void rewind() {
        this.nCurrentFrame = 0;
        this.nFrameTick = this.nDelay = this.pAnimatedObjectData != null ? (byte)(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameDurationColBox[(AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pActions[this.nCurrentAction][1 + this.nCurrentFrame] & 0xFF) << 1] & 0x7F) : (byte)0;
    }

    static void drawNativeInterfaceBall(Graphics graphics, int n, int n2, int n3, int n4) {
        try {
            graphics.setClip(n2, n3, n4, n4 + 5);
            int n5 = 0xFFFFFF - GameCanvasEx.m_colorBalls[n];
            int n6 = n > 8 ? 2 : 3;
            int n7 = 0xFF0000 & (0xFF0000 & n5) >> n6;
            int n8 = 0xFF00 & (0xFF00 & n5) >> n6;
            int n9 = 0xFF & (0xFF & n5) >> n6;
            n5 = n7 | n8 | n9;
            if (n > 8) {
                graphics.setColor(GameCanvasEx.m_colorBalls[0]);
            } else {
                graphics.setColor(GameCanvasEx.m_colorBalls[n]);
            }
            graphics.fillArc(n2, n3, n4, n4, 0, 360);
            if (n > 8) {
                graphics.setClip(n2, n3 + (n4 >> 1) - 3, n4, 7);
                graphics.setColor(GameCanvasEx.m_colorBalls[n]);
                graphics.fillArc(n2, n3, n4, n4, 0, 360);
            }
            graphics.setColor(GameCanvasEx.m_colorBalls[n] + n5);
            graphics.fillArc(n2 + 1, n3 + 1, n4 - 6, n4 - 6, 0, 360);
            graphics.setColor(GameCanvasEx.m_colorBalls[n] + (n5 << 1));
            graphics.fillArc(n2 + 2, n3 + 2, n4 - 10, n4 - 10, 0, 360);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void drawATInterfaceBall(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(n2, n3, 20, 20);
        if (this.bLoop) {
            this.bNeedDrawUpdate = true;
            int n4 = 255 - (GameCanvasEx.m_iTimeTick & 0xF) * 16;
            int n5 = GameCanvasEx.Color_ChangeBrightness_RGB888(0xFF0000, n4);
            graphics.setClip(0, 0, 240, 298);
            graphics.setColor(n5);
            graphics.drawArc(n2 - 1, n3 - 1, 21, 21, 0, 360);
            GameCanvasEx.GfxFontDrawStringCenteredColor(graphics, Integer.toString(this.nCurrentFrame), n2 + 10, n3 + 2, 0);
        } else {
            graphics.drawImage(GameCanvasEx.RM_GetResource_Image(GameCanvasEx.p_imageBalls[this.nCurrentFrame]), n2, n3, 20);
        }
    }

    void drawWidescreenEffect(Graphics graphics) {
        graphics.setColor(0);
        graphics.setClip(0, 0, 240, 298);
        graphics.fillRect(0, 0, 240, 41);
        graphics.fillRect(0, 257, 240, 41);
    }

    void drawATThinking(int n, int n2, int n3, Graphics graphics) {
        n3 = 172;
        graphics.setClip(0, 0, 240, 298);
        GameCanvasEx.Game_WideScreen_Dialog(graphics, n2, n3, 240, 58, 0);
        GameCanvasEx.GfxFontDrawStringCenteredColor(graphics, GameCanvasEx.RM_GetString(6815797), 120 + n2, n3 + 25, 0);
    }

    void drawATPowerBar(int n, int n2, int n3, Graphics graphics) {
        if (GloftMD3D.Instance_Game.IsStatePowerUp()) {
            graphics.setClip(0, 0, 240, 298);
            graphics.drawImage(GameCanvasEx.RM_GetResource_Image(47), n2 - 3, n3 - 3, 20);
        }
        n = 138 - n;
        graphics.setClip(n2, n3 + n, 6, 138 - n);
        graphics.drawImage(GameCanvasEx.RM_GetResource_Image(46), n2, n3, 20);
    }

    void drawATCue(int n, int n2, int n3, Graphics graphics) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        boolean bl = false;
        if (n < 10 || n > 245) {
            n8 = 1;
            n5 = 1;
        } else if (n < 52) {
            n8 = 2;
            bl = true;
            n4 = 1;
            n5 = 1;
            n6 = 1;
        } else if (n < 74) {
            n8 = 3;
            n4 = 1;
        } else if (n < 117) {
            n8 = 4;
            bl = true;
            n4 = 1;
            n5 = -1;
            n7 = -1;
        } else if (n < 138) {
            n8 = 5;
            n5 = -1;
        } else if (n < 181) {
            n8 = 6;
            bl = true;
            n4 = -1;
            n5 = -1;
            n6 = -1;
        } else if (n < 202) {
            n8 = 7;
            n4 = -1;
        } else {
            n8 = 8;
            bl = true;
            n4 = -1;
            n5 = 1;
            n7 = 1;
        }
        int n9 = 0;
        int n10 = 0;
        if (n9 < 0) {
            n9 *= -1;
            n10 = 1;
        }
        int n11 = n9 + 128;
        if (n > n9 && n < n11) {
            n10 = 1;
        } else if (n11 == 256) {
            if (n == n9 || n == 0) {
                n10 = 2;
            }
        } else if (n == n9 || n == n11) {
            n10 = 2;
        }
        int n12 = n2 + (GameCanvasEx.cos(n += 128) * 175 >> 14);
        int n13 = n3 - (GameCanvasEx.sin(n) * 175 >> 14);
        graphics.setClip(0, 0, 240, 298);
        graphics.setColor(m_cueColorLight[GameCanvasEx.s_pPlayerCue[GameCanvasEx.m_nCurrentPlayer]][3]);
        graphics.drawLine(n2 + n4, n3 + n5, n12 + n4, n13 + n5);
        if (bl) {
            graphics.drawLine(n2 + n6, n3 + n7, n12 + n6, n13 + n7);
        }
        graphics.drawLine(n2, n3, n12, n13);
    }

    void IGA_drawATString(int n, int n2, int n3, Graphics graphics) {
        String string = "";
        if (GameCanvasEx.m_pStringAObjPool[this.nCurrentAction] != null && GameCanvasEx.m_pStringAObjPool[this.nCurrentAction].length() > 0) {
            string = string + GameCanvasEx.m_pStringAObjPool[this.nCurrentAction];
            System.out.println("\n **************** message[1] :" + string);
            if (this.nNextAction == 1) {
                GameCanvasEx.GfxFontChangeSecondary(4);
                GameCanvasEx.GfxFontDrawMultiStringsCenteredColor(graphics, string, n2, n3, 1);
            } else {
                GameCanvasEx.GfxFontChangeSecondary(4);
                GameCanvasEx.GfxFontDrawStringColor(graphics, string, n2, n3, 1);
            }
        }
    }

    void drawATString(int n, int n2, int n3, Graphics graphics) {
        String string = "";
        if (GameCanvasEx.m_pStringAObjPool[this.nCurrentAction] != null && GameCanvasEx.m_pStringAObjPool[this.nCurrentAction].length() > 0) {
            string = string + GameCanvasEx.m_pStringAObjPool[this.nCurrentAction];
            if (this.nNextAction == 1) {
                GameCanvasEx.GfxFontDrawMultiStringsCenteredColor(graphics, string, n2, n3, this.nCurrentFrame);
            } else {
                GameCanvasEx.GfxFontDrawStringColor(graphics, string, n2, n3, this.nCurrentFrame);
            }
        }
    }

    void drawATStringTitle(int n, int n2, int n3, Graphics graphics) {
        if (GameCanvasEx.m_pStringAObjPool[this.nCurrentAction] != null && GameCanvasEx.m_pStringAObjPool[this.nCurrentAction].length() > 0) {
            GameCanvasEx.GfxFontDrawTitle(graphics, GameCanvasEx.m_pStringAObjPool[this.nCurrentAction], n2, n3, 0);
        }
    }

    void drawATDialog(int n, int n2, int n3, Graphics graphics) {
        if (GameCanvasEx.m_pStringAObjPool[this.nCurrentAction] != null && GameCanvasEx.m_pStringAObjPool[this.nCurrentAction].length() > 0) {
            GameCanvasEx.Font_GfxFontDrawLinesCenteredColor(graphics, GameCanvasEx.m_pStringAObjPool[this.nCurrentAction], n2, n3, this.nCurrentFrame, this.nNextAction, 4);
        }
    }

    static void drawATView3D(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(0, 0, 240, 298);
        GameCanvasEx.Game_View3D_Refresh(graphics, n2, n3);
    }

    void drawATMenuBox(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(n2, n3, (int)this.nCurrentFrame, this.nCurrentAction);
        GameCanvasEx.Game_WideScreen_Dialog(graphics, n2, n3, this.nCurrentFrame, this.nCurrentAction, 0);
    }

    void drawATDialogBox(int n, int n2, int n3, Graphics graphics) {
        graphics.setClip(n2, n3, (int)this.nCurrentFrame, this.nCurrentAction);
        GameCanvasEx.Game_WideScreen_Dialog(graphics, 0, n3, 240, this.nCurrentAction, 0);
    }

    void drawATColorBox(Graphics graphics) {
        System.out.println("***************************************** kMenu_Options_Arrow ***********************************");
        graphics.setClip(this.nScreenPosX, this.nScreenPosY - 1 + 3, 15, 11);
        graphics.setColor(this.nNextAction);
        graphics.fillRect(this.nScreenPosX, this.nScreenPosY - 1 + 3, 14, 10);
        graphics.setColor(0x333399);
        graphics.drawRect(this.nScreenPosX, this.nScreenPosY - 1 + 3, 14, 10);
        if (this.nCurrentFrame == 1) {
            graphics.setColor((GameCanvasEx.m_iTimeTick & 1) != 0 ? 0x333399 : 0xFF0000);
        }
        this.drawArrows(graphics, this.nScreenPosX, this.nScreenPosY - 1 + 3);
        if (this.bLoop) {
            graphics.setClip(0, 0, 240, 298);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(this.nScreenPosX + 4, this.nScreenPosY + 4 + 3, 7, 4);
            graphics.drawArc(this.nScreenPosX + 5, this.nScreenPosY + 1 + 3, 4, 3, 0, 360);
        }
    }

    void drawArrows(Graphics graphics, int n, int n2) {
        graphics.setClip(n - 5 - 2, n2 + 5 - 2, n - 7, n2 + 5);
        graphics.drawLine(n - 5, n2 + 5 - 2, n - 5, n2 + 5 + 2);
        graphics.drawLine(n - 5 - 1, n2 + 5 - 1, n - 6, n2 + 5 + 1);
        graphics.drawLine(n - 5 - 2, n2 + 5, n - 7, n2 + 5);
        graphics.setClip(n + 14 + 5, n2 + 5 - 2, n + 14 + 7, n2 + 5);
        graphics.drawLine(n + 14 + 5, n2 + 5 - 2, n + 14 + 5, n2 + 5 + 2);
        graphics.drawLine(n + 14 + 6, n2 + 5 - 1, n + 14 + 6, n2 + 5 + 1);
        graphics.drawLine(n + 14 + 7, n2 + 5, n + 14 + 7, n2 + 5);
    }

    void drawATAimingLine(Graphics graphics) {
        if (GameCanvasEx.m_bAimingLinesOn) {
            PhysicalObject.PhysicEngine_resetSimulation();
            GameCanvasEx.ApplyShotParamsToBall(GameCanvasEx.m_pCueBall.pCopy, true);
            this.nCurrentAction = 1;
            AnimatedObject.Game_DrawAimingLines(graphics, this.bLoop);
        }
    }

    void drawATCursor(Graphics graphics, int n, int n2) {
        graphics.setClip(0, this.nScreenPosY - 1, 240, 17);
        graphics.setColor(n);
        graphics.fillRect(0, this.nScreenPosY - 0, 240, 16);
        graphics.setColor(n2);
        graphics.drawLine(0, this.nScreenPosY - 0, 240, this.nScreenPosY - 0);
        graphics.drawLine(0, this.nScreenPosY + 15, 240, this.nScreenPosY + 15);
    }

    static void drawATPause(Graphics graphics, int n) {
        int n2;
        int n3 = Math.max(240, 298);
        graphics.setClip(0, 0, 240, 298);
        graphics.setColor(n);
        for (n2 = 0; n2 <= n3; n2 += 2) {
            graphics.drawLine(0, n2, n2, 0);
        }
        for (n2 = n3; n2 >= 0; n2 -= 2) {
            graphics.drawLine(n3, n2, n2, n3);
        }
    }

    void drawATOptions(Graphics graphics, int n) {
        this.drawATString(n, this.nScreenPosX, this.nScreenPosY, graphics);
        if (this.bLoop) {
            graphics.setColor((GameCanvasEx.m_iTimeTick & 1) != 0 ? 0x333399 : 0xFF0000);
        } else {
            graphics.setColor(0x333399);
        }
        this.drawArrows(graphics, this.nScreenPosX - 7, this.nScreenPosY - 1 + 3);
    }

    void drawFrame(int n, int n2, int n3, Graphics graphics) {
        int n4 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameDurationColBox[(n << 1) + 1] & 0xFF;
        int n5 = this.nAObjectDataType;
        for (int i = 0; i < n4; ++i) {
            int n6;
            int n7;
            byte by = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 0];
            byte by2 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 1];
            int n8 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 2] & 0xFF;
            byte by3 = AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pFrameSprite[n][(i << 2) + 3];
            int n9 = 0;
            if ((this.nFlags & 1) != 0) {
                n7 = n2 - by - (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pModuleTypeAndSize[n8 * 3 + 1] & 0xFF);
                if ((by3 & 1) == 0) {
                    n9 |= 1;
                }
            } else {
                n7 = n2 + by;
                if ((by3 & 1) != 0) {
                    n9 |= 1;
                }
            }
            if ((this.nFlags & 2) != 0) {
                n6 = n3 - by2 - (AnimatedObjectData.pStaticAnimatedObjectData[this.pAnimatedObjectData.nType].pModuleTypeAndSize[n8 * 3 + 2] & 0xFF);
                if ((by3 & 2) == 0) {
                    n9 |= 2;
                }
            } else {
                n6 = n3 + by2;
                if ((by3 & 2) != 0) {
                    n9 |= 2;
                }
            }
            this.pAnimatedObjectData.drawModule(this, n8, n7, n6, n9, graphics);
        }
    }

    void drawFrame(int n, Graphics graphics) {
        switch (this.nAObjectDataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 66: {
                break;
            }
            case 27: {
                this.drawATPowerBar(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 16: {
                break;
            }
            case 77: {
                this.drawATThinking(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 24: {
                if (GameCanvasEx.m_bIsStartMenuDesactivated) break;
                this.drawATCue(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 93: {
                this.IGA_drawATString(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 39: {
                this.drawATString(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 40: {
                this.drawATStringTitle(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 79: {
                this.drawATDialog(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case -1: {
                break;
            }
            case 43: {
                AnimatedObject.drawATView3D(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 55: {
                this.drawATDialogBox(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 60: {
                this.drawATMenuBox(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 61: {
                if (this != GameCanvasEx.m_pInterfaceBall[GameCanvasEx.m_nCurrentPlayer]) break;
                graphics.setClip(0, 0, 240, 298);
                graphics.setColor(0);
                graphics.fillRect(this.nScreenPosX - 2, this.nScreenPosY - 2, 24, 24);
                graphics.setColor(0x444466);
                graphics.drawRect(this.nScreenPosX - 2, this.nScreenPosY - 2, 23, 23);
                graphics.drawRect(this.nScreenPosX - 0, this.nScreenPosY - 0, 19, 19);
                graphics.setColor(0x9999CC);
                graphics.drawRect(this.nScreenPosX - 1, this.nScreenPosY - 1, 21, 21);
                this.drawATInterfaceBall(n, this.nScreenPosX, this.nScreenPosY, graphics);
                break;
            }
            case 78: {
                this.drawWidescreenEffect(graphics);
                break;
            }
            case 81: {
                this.drawATColorBox(graphics);
                break;
            }
            case 90: {
                this.drawATOptions(graphics, n);
                break;
            }
            case 83: {
                break;
            }
            case 41: {
                this.drawATCursor(graphics, 0x444466, 0x9999CC);
                break;
            }
            case 92: {
                AnimatedObject.drawATPause(graphics, 0x404040);
                break;
            }
            case 82: {
                graphics.setClip(GameCanvasEx.m_pClipAO[0], GameCanvasEx.m_pClipAO[1] - 15, GameCanvasEx.m_pClipAO[2], 15);
                graphics.drawImage(GameCanvasEx.RM_GetResource_Image(63), 0, 0, 20);
                graphics.setClip(GameCanvasEx.m_pClipAO[0], GameCanvasEx.m_pClipAO[1] + GameCanvasEx.m_pClipAO[3], GameCanvasEx.m_pClipAO[2], 15);
                graphics.drawImage(GameCanvasEx.RM_GetResource_Image(63), 0, 0, 20);
                break;
            }
            case 89: {
                if (GloftMD3D.Instance_Game.IsRendering3D()) break;
                GameCanvasEx.Game_FlashingBall(graphics, this.nCurrentFrame);
                break;
            }
            default: {
                this.drawFrame(n, this.nScreenPosX, this.nScreenPosY, graphics);
            }
        }
    }

    static boolean AnimationPlayer_Check(AnimatedObject animatedObject, int n) {
        if (animatedObject == null) {
            return false;
        }
        AnimatedObject animatedObject2 = pRoot[n];
        while (animatedObject2 != null) {
            if (animatedObject == animatedObject2) {
                return true;
            }
            animatedObject2 = animatedObject2.pNext;
        }
        return false;
    }

    static void AnimationPlayer_Play(AnimatedObject animatedObject, int n) {
        if (animatedObject == null) {
            System.out.println("\n************ pAnimatedObject == null*********************");
            return;
        }
        AnimatedObject animatedObject2 = pRoot[n];
        while (animatedObject2 != null) {
            if (animatedObject == animatedObject2) {
                return;
            }
            animatedObject2 = animatedObject2.pNext;
        }
        if (animatedObject.bUseWiseDraw) {
            animatedObject.bNeedDrawUpdate = true;
        }
        if (pRoot[n] == null) {
            animatedObject.pNext = null;
            AnimatedObject.pRoot[n] = animatedObject;
        } else if (AnimatedObject.pRoot[n].pNext == null) {
            if (animatedObject.nPriority <= AnimatedObject.pRoot[n].nPriority) {
                animatedObject.pNext = pRoot[n];
                AnimatedObject.pRoot[n] = animatedObject;
            } else {
                AnimatedObject.pRoot[n].pNext = animatedObject;
                animatedObject.pNext = null;
            }
        } else if (animatedObject.nPriority <= AnimatedObject.pRoot[n].nPriority) {
            animatedObject.pNext = pRoot[n];
            AnimatedObject.pRoot[n] = animatedObject;
        } else {
            AnimatedObject animatedObject3 = pRoot[n];
            AnimatedObject animatedObject4 = AnimatedObject.pRoot[n].pNext;
            while (animatedObject4 != null) {
                if (animatedObject.nPriority <= animatedObject4.nPriority) {
                    animatedObject3.pNext = animatedObject;
                    animatedObject.pNext = animatedObject4;
                    return;
                }
                animatedObject3 = animatedObject4;
                animatedObject4 = animatedObject4.pNext;
            }
            animatedObject3.pNext = animatedObject;
            animatedObject.pNext = animatedObject4;
        }
    }

    static void AnimationPlayer_Stop(AnimatedObject animatedObject) {
        int n = animatedObject.nLayer;
        AnimatedObject animatedObject2 = pRoot[n];
        if (animatedObject2 == animatedObject) {
            AnimatedObject.pRoot[n] = animatedObject.pNext;
            animatedObject.pNext = null;
            return;
        }
        while (animatedObject2 != null) {
            if (animatedObject2.pNext == animatedObject) {
                animatedObject2.pNext = animatedObject.pNext;
                animatedObject.pNext = null;
                return;
            }
            animatedObject2 = animatedObject2.pNext;
        }
    }

    static void AnimationPlayer_Execute(Graphics graphics, boolean bl) {
        for (int i = 0; i < 3; ++i) {
            AnimatedObject animatedObject = pRoot[i];
            while (animatedObject != null) {
                boolean bl2 = true;
                if (bl) {
                    if (animatedObject.bUseWiseDraw) {
                        if (graphics != null) {
                            if (GameCanvasEx.m_bRedrawWiseObject || animatedObject.bNeedDrawUpdate) {
                                animatedObject.bNeedDrawUpdate = false;
                            } else {
                                bl2 = false;
                            }
                        }
                    } else {
                        bl2 = false;
                    }
                } else if (animatedObject.bUseWiseDraw) {
                    bl2 = false;
                }
                if (bl2) {
                    if (graphics == null) {
                        switch (animatedObject.nAObjectDataType) {
                            case 27: {
                                animatedObject.nCurrentFrame = (short)(GameCanvasEx.m_fPower_Interface * 138 >> 14);
                                break;
                            }
                            case -1: 
                            case 16: 
                            case 24: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 43: 
                            case 55: 
                            case 60: 
                            case 61: 
                            case 77: 
                            case 78: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 89: 
                            case 90: 
                            case 92: 
                            case 93: {
                                break;
                            }
                            default: {
                                if (!GameCanvasEx.m_bIsGamePaused) {
                                    animatedObject.play();
                                    break;
                                } else {
                                    break;
                                }
                            }
                        }
                    } else {
                        int n = 0;
                        switch (animatedObject.nAObjectDataType) {
                            case -1: 
                            case 16: 
                            case 39: 
                            case 40: 
                            case 41: 
                            case 43: 
                            case 55: 
                            case 60: 
                            case 61: 
                            case 78: 
                            case 79: 
                            case 81: 
                            case 82: 
                            case 83: 
                            case 84: 
                            case 89: 
                            case 90: 
                            case 92: 
                            case 93: {
                                break;
                            }
                            case 27: {
                                n = GameCanvasEx.m_fPower_Interface * 138 >> 14;
                                break;
                            }
                            case 77: {
                                n = GameCanvasEx.m_iThinking;
                                break;
                            }
                            case 24: {
                                n = GameCanvasEx.arctan(GameCanvasEx.m_cueTargetDirection[1], GameCanvasEx.m_cueTargetDirection[0]);
                                break;
                            }
                            default: {
                                n = AnimatedObjectData.pStaticAnimatedObjectData[animatedObject.pAnimatedObjectData.nType].pActions[animatedObject.nCurrentAction][1 + animatedObject.nCurrentFrame] & 0xFF;
                            }
                        }
                        animatedObject.drawFrame(n, graphics);
                    }
                }
                animatedObject = animatedObject.pNext;
            }
        }
    }

    static void Game_DrawInterface() {
        GameCanvasEx.g_graBackBuffer.setClip(0, 0, 240, 298);
        GameCanvasEx.g_graBackBuffer.setColor(0);
        GameCanvasEx.g_graBackBuffer.fillRect(GameCanvasEx.m_tableOffset_X - 0, GameCanvasEx.m_tableOffset_Y - 0, 240 - (GameCanvasEx.m_tableOffset_X - 0), 298 - (GameCanvasEx.m_tableOffset_Y - 0));
        GameCanvasEx.g_graBackBuffer.fillRect(GameCanvasEx.m_tableOffset_X + 148, GameCanvasEx.m_tableOffset_Y, 240 - (GameCanvasEx.m_tableOffset_X + 148), 298 - GameCanvasEx.m_tableOffset_Y);
    }

    static void Game_AimingLineSetShotParams() {
        GameCanvasEx.m_nbCollisions = 0;
        GameCanvasEx.m_pCueBall.pCopy.jumpTimeLeft = 0;
        GameCanvasEx.m_pCueBall.pCopy.jumpStep = 0;
        GameCanvasEx.Vector2D_setTo3(GameCanvasEx.m_pCueBall.pCopy.XY_spin, 0, 0);
        GameCanvasEx.m_pCueBall.pCopy.Z_spin_ratio = 0;
        if (GameCanvasEx.m_pCueBall.pCopy.speed != 0) {
            GameCanvasEx.m_pCueBall.pCopy.speed = 1228800;
        }
    }

    static void Game_DrawAimingLines(Graphics graphics, boolean bl) {
        if (GameCanvasEx.m_bRecalculateCueLine) {
            int n = 0;
            int n2 = 1000;
            GameCanvasEx.m_bDrawGhost = false;
            AnimatedObject.Game_AimingLineSetShotParams();
            PhysicalObject.g_iBallsMovingInFrame = 1;
            while (PhysicalObject.g_iBallsMovingInFrame != 0 && n < 1) {
                PhysicalObject.g_iBallsMovingInFrame = 0;
                if ((n2 = PhysicalObject.PhysicEngine_updateBallsToFirstCollision(PhysicalObject.PhysicEngine_pRootBalls_sim, n2, true)) >= 0) {
                    if (PhysicalObject.PhysicEngine_pCollidingObject.type == 1) {
                        GameCanvasEx.m_pCueAimingBallHit = PhysicalObject.PhysicEngine_pCollidingBall;
                        GameCanvasEx.m_iCueAimingBallVisorX = GameCanvasEx.m_pCueAimingBallHit.x + GameCanvasEx.m_pCueAimingBallHit.direction[0] * 27;
                        GameCanvasEx.m_iCueAimingBallVisorY = -(GameCanvasEx.m_pCueAimingBallHit.y + GameCanvasEx.m_pCueAimingBallHit.direction[1] * 27);
                    } else {
                        GameCanvasEx.m_pCueAimingBallHit = null;
                    }
                    if (PhysicalObject.PhysicEngine_pCollidingObject.type == 1 || PhysicalObject.PhysicEngine_pCollidingObject.type == 8 || PhysicalObject.PhysicEngine_pCollidingObject.type == 16) {
                        GameCanvasEx.m_bDrawGhost = true;
                    } else {
                        n = 1;
                    }
                    ++n;
                    continue;
                }
                n2 = 1000;
            }
            GameCanvasEx.m_bRecalculateCueLine = false;
            GameCanvasEx.m_iLastCueTargetX = GameCanvasEx.m_pCueBall.pCopy.x;
            GameCanvasEx.m_iLastCueTargetY = -GameCanvasEx.m_pCueBall.pCopy.y;
            PhysicalObject physicalObject = GameCanvasEx.m_pCueBall.pCopy;
            if (physicalObject.speed > 16384) {
                GameCanvasEx.m_iCueAimingVisorX = physicalObject.x + physicalObject.direction[0] * 27;
                GameCanvasEx.m_iCueAimingVisorY = -(physicalObject.y + physicalObject.direction[1] * 27);
            } else {
                GameCanvasEx.m_iCueAimingVisorX = GameCanvasEx.m_iLastCueTargetX;
                GameCanvasEx.m_iCueAimingVisorY = GameCanvasEx.m_iLastCueTargetY;
            }
        }
        if (bl) {
            // empty if block
        }
        GameCanvasEx.m_pCueBall.pCopy.speed = 0;
    }

    static void Game_LoadCueColor(int n) {
        int n2;
        if (m_cueColorLight[n] != null && m_cueColorDark[n] != null) {
            return;
        }
        if (GameCanvasEx.s_pCueColorsData == null) {
            GameCanvasEx.RM_Load(132);
            GameCanvasEx.RM_Synchronize(-1);
            GameCanvasEx.s_pCueColorsData = GameCanvasEx.RM_GetResource_Array_Byte(132);
        }
        int n3 = n * 24;
        int[] nArray = new int[6];
        for (n2 = 0; n2 < 6; ++n2) {
            nArray[n2] = GameCanvasEx.readIntBigEndian(GameCanvasEx.s_pCueColorsData, n3);
            n3 += 4;
        }
        AnimatedObject.m_cueColorLight[n] = new int[10];
        AnimatedObject.m_cueColorDark[n] = new int[10];
        n2 = 0;
        AnimatedObject.m_cueColorLight[n][n2] = 2;
        AnimatedObject.m_cueColorDark[n][n2] = 2;
        AnimatedObject.m_cueColorLight[n][++n2] = nArray[4];
        AnimatedObject.m_cueColorDark[n][n2] = nArray[5];
        AnimatedObject.m_cueColorLight[n][++n2] = 100;
        AnimatedObject.m_cueColorDark[n][n2] = 100;
        AnimatedObject.m_cueColorLight[n][++n2] = nArray[0];
        AnimatedObject.m_cueColorDark[n][n2] = nArray[1];
        AnimatedObject.m_cueColorLight[n][++n2] = 2;
        AnimatedObject.m_cueColorDark[n][n2] = 2;
        AnimatedObject.m_cueColorLight[n][++n2] = nArray[4];
        AnimatedObject.m_cueColorDark[n][n2] = nArray[5];
        AnimatedObject.m_cueColorLight[n][++n2] = 70;
        AnimatedObject.m_cueColorDark[n][n2] = 70;
        AnimatedObject.m_cueColorLight[n][++n2] = nArray[2];
        AnimatedObject.m_cueColorDark[n][n2] = nArray[3];
        AnimatedObject.m_cueColorLight[n][++n2] = 2;
        AnimatedObject.m_cueColorDark[n][n2] = 2;
        AnimatedObject.m_cueColorLight[n][++n2] = nArray[4];
        AnimatedObject.m_cueColorDark[n][n2] = nArray[5];
        ++n2;
        nArray = null;
    }
}

