/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;

public class SudokuPuzzle {
    private Cell[][] grid;
    public static int curX;
    public static int curY;
    public static int left;
    public static long endTime;
    public static boolean timeStoped;
    public int figureHightLighted;
    public static boolean isMistake;
    public static final int EXPOSED = 1;
    public static final int FILLED = 2;
    public static final int WRONG = 4;
    public static final int HIGHLIGHTED = 8;
    public static final int PENCIL_MARK = 16;
    public static final int EMPTY = 32;
    public static final int MAX_PENCIL_MARK_COUNT = 6;

    public SudokuPuzzle() {
        isMistake = false;
        timeStoped = true;
        System.out.println("SudokuPuzzle creating!!");
        this.grid = new Cell[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.grid[i][j] = new Cell();
                this.grid[i][j].setKind(32);
            }
        }
        curX = 0;
        curY = 0;
        endTime = System.currentTimeMillis();
        left = 81;
        this.figureHightLighted = 0;
    }

    public int[][] getPuzzle() {
        int[][] nArray = new int[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                nArray[i][j] = this.isKind(i, j, 1) ? this.getFigure(i, j) : 0;
            }
        }
        return nArray;
    }

    public void giveUp() {
        System.out.println("GIVING UP!!");
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.setFigure(i, j, this.grid[i][j].getGoodFigure());
                System.out.print(" " + this.grid[i][j].getGoodFigure());
                this.setKind(i, j, 1);
            }
            System.out.println("");
        }
        left = 0;
        this.highlightFigure(0);
        this.stopTime();
    }

    public void fill(int[][] nArray, int[][] nArray2) {
        System.out.println("Fill!!");
        left = 81;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (nArray2[i][j] != 0) {
                    this.grid[i][j].setKind(1);
                    this.grid[i][j].setUserFigure(nArray2[i][j]);
                    --left;
                } else {
                    this.grid[i][j].setKind(32);
                }
                if (nArray == null) continue;
                this.grid[i][j].setGoodFigure(nArray[i][j]);
            }
        }
        this.markDoubleFigures();
    }

    public int getFigure(int n, int n2) {
        return this.grid[n][n2].getUserFigure();
    }

    public void setFigure(int n, int n2, int n3) {
        if (!this.isKind(curX, curY, 2)) {
            --left;
        }
        this.grid[n][n2].setUserFigure(n3);
        this.addKind(n, n2, 2);
        this.eraseKind(n, n2, 32);
        this.markDoubleFigures();
    }

    public boolean setFigure(int n) {
        if (!this.isKind(curX, curY, 1)) {
            if (!this.isKind(curX, curY, 2)) {
                --left;
            }
            this.grid[curX][curY].clearPencilMarks();
            this.grid[curX][curY].setUserFigure(n);
            this.grid[curX][curY].setKind(2);
            this.markDoubleFigures();
            return true;
        }
        return false;
    }

    public void eraseCell(int n, int n2) {
        if (this.isKind(n, n2, 2)) {
            ++left;
        }
        this.grid[n][n2].setKind(32);
        this.grid[n][n2].setUserFigure(0);
        this.grid[n][n2].clearPencilMarks();
    }

    public boolean eraseCell() {
        if ((this.grid[curX][curY].getKind() & 1) != 1) {
            this.eraseCell(curX, curY);
            return true;
        }
        return false;
    }

    public void eraseAll(boolean bl) {
        for (curX = 0; curX < 9; ++curX) {
            for (curY = 0; curY < 9; ++curY) {
                if (bl) {
                    this.eraseCell(curX, curY);
                    continue;
                }
                this.eraseCell();
            }
        }
        if (bl) {
            left = 81;
        }
        this.markDoubleFigures();
        curX = 0;
        curY = 0;
    }

    public int getPencilMark(int n, int n2, int n3) {
        return this.grid[n][n2].getPencilMark(n3);
    }

    public boolean addOrTakePencilMark(int n) {
        if (this.isKind(curX, curY, 1)) {
            return false;
        }
        if (this.isKind(curX, curY, 2)) {
            ++left;
        }
        this.grid[curX][curY].setKind(16);
        this.grid[curX][curY].setUserFigure(0);
        if (!this.grid[curX][curY].addPencilMark(n) && this.getPMCount(curX, curY) == 0) {
            this.grid[curX][curY].setKind(32);
        }
        this.markDoubleFigures();
        return true;
    }

    public int getKind(int n, int n2) {
        return this.grid[n][n2].getKind();
    }

    public void setKind(int n, int n2, int n3) {
        this.grid[n][n2].setKind(n3);
    }

    public void addKind(int n, int n2, int n3) {
        this.setKind(n, n2, this.grid[n][n2].getKind() | n3);
    }

    public void eraseKind(int n, int n2, int n3) {
        int n4 = 0;
        if (this.isKind(n, n2, 32) && n3 != 32) {
            n4 |= 0x20;
        }
        if (this.isKind(n, n2, 1) && n3 != 1) {
            n4 |= 1;
        }
        if (this.isKind(n, n2, 4) && n3 != 4) {
            n4 |= 4;
        }
        if (this.isKind(n, n2, 2) && n3 != 2) {
            n4 |= 2;
        }
        if (this.isKind(n, n2, 16) && n3 != 16) {
            n4 |= 0x10;
        }
        if (this.isKind(n, n2, 8) && n3 != 8) {
            n4 |= 8;
        }
        this.setKind(n, n2, n4);
    }

    public boolean isKind(int n, int n2, int n3) {
        return (n3 & this.getKind(n, n2)) == n3;
    }

    public boolean isGood() {
        return !isMistake;
    }

    public void markDoubleFigures() {
        int n;
        int n2;
        isMistake = false;
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n < 9; ++n) {
                this.eraseKind(n2, n, 4);
            }
        }
        for (n2 = 0; n2 < 9; ++n2) {
            this.checkRow(n2);
            this.checkCol(n2);
        }
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                this.checkSquare(n2, n);
            }
        }
        this.highlightFigure(this.figureHightLighted);
    }

    public void checkRow(int n) {
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < 9; ++n2) {
            if (vector.contains(new Integer(this.getFigure(n2, n)))) {
                vector2.addElement(new Integer(this.getFigure(n2, n)));
                continue;
            }
            vector.addElement(new Integer(this.getFigure(n2, n)));
        }
        for (n2 = 0; n2 < 9; ++n2) {
            if (!vector2.contains(new Integer(this.getFigure(n2, n)))) continue;
            this.addKind(n2, n, 4);
            isMistake = true;
        }
    }

    public void checkCol(int n) {
        int n2;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n2 = 0; n2 < 9; ++n2) {
            if (vector.contains(new Integer(this.getFigure(n, n2)))) {
                vector2.addElement(new Integer(this.getFigure(n, n2)));
                continue;
            }
            vector.addElement(new Integer(this.getFigure(n, n2)));
        }
        for (n2 = 0; n2 < 9; ++n2) {
            if (!vector2.contains(new Integer(this.getFigure(n, n2)))) continue;
            this.addKind(n, n2, 4);
            isMistake = true;
        }
    }

    public void checkSquare(int n, int n2) {
        int n3;
        int n4;
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Integer> vector2 = new Vector<Integer>();
        for (n4 = n * 3; n4 < n * 3 + 3; ++n4) {
            for (n3 = n2 * 3; n3 < n2 * 3 + 3; ++n3) {
                if (vector.contains(new Integer(this.getFigure(n4, n3)))) {
                    vector2.addElement(new Integer(this.getFigure(n4, n3)));
                    continue;
                }
                vector.addElement(new Integer(this.getFigure(n4, n3)));
            }
        }
        for (n4 = n * 3; n4 < n * 3 + 3; ++n4) {
            for (n3 = n2 * 3; n3 < n2 * 3 + 3; ++n3) {
                if (!vector2.contains(new Integer(this.getFigure(n4, n3)))) continue;
                this.addKind(n4, n3, 4);
                isMistake = true;
            }
        }
    }

    public void highlightFigure(int n) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.grid[i][j].getUserFigure() == n) {
                    this.addKind(i, j, 8);
                    continue;
                }
                this.eraseKind(i, j, 8);
            }
        }
    }

    public void cursorLeft() {
        if (--curX < 0) {
            curX = 8;
        }
    }

    public void cursorRight() {
        if (++curX >= 9) {
            curX = 0;
        }
    }

    public void cursorUp() {
        if (--curY < 0) {
            curY = 8;
        }
    }

    public void cursorDown() {
        if (++curY >= 9) {
            curY = 0;
        }
    }

    public int getLeft() {
        return left;
    }

    public void stopTime() {
        endTime -= System.currentTimeMillis();
        timeStoped = true;
    }

    public void setTimeLeft(int n) {
        endTime = System.currentTimeMillis() + (long)(n * 60 * 1000);
        timeStoped = false;
    }

    public String getTimeLeft() {
        String string = "";
        long l = timeStoped ? endTime : endTime - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        long l2 = (l /= 1000L) / 60L;
        l -= l2 * 60L;
        long l3 = l2 / 60L;
        string = "" + (l3 < 10L ? "0" : "") + l3 + ":" + ((l2 -= l3 * 60L) < 10L ? "0" : "") + l2 + ":" + (l < 10L ? "0" : "") + l;
        return string;
    }

    public int getTimeLeftNum() {
        long l = endTime - System.currentTimeMillis();
        if (l < 0L) {
            l = 0L;
        }
        long l2 = (l /= 1000L) / 60L;
        new Integer(1);
        return Integer.valueOf(new Long(l2).toString());
    }

    public int getPMCount(int n, int n2) {
        return this.grid[n][n2].getPMCount();
    }

    public void saveState(DataOutputStream dataOutputStream) {
        System.out.println("SAVE SUDOKU");
        try {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.grid[i][j].save(dataOutputStream);
                }
                System.out.println("");
            }
            dataOutputStream.writeByte(curX);
            dataOutputStream.writeByte(curY);
            dataOutputStream.writeByte(left);
            dataOutputStream.writeLong(endTime);
            dataOutputStream.writeByte(this.figureHightLighted);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadState(DataInputStream dataInputStream) {
        System.out.println("LOAD SUDOKU");
        try {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    this.grid[i][j].load(dataInputStream);
                }
                System.out.println("");
            }
            curX = dataInputStream.readByte();
            curY = dataInputStream.readByte();
            left = dataInputStream.readByte();
            endTime = dataInputStream.readLong();
            this.figureHightLighted = dataInputStream.readByte();
            timeStoped = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Cell {
        private int kind = 0;
        private int userFigure;
        private int goodFigure;
        private Vector vectorOfMarks = new Vector(6);
        private int pencilMarksCount = 0;

        public void setKind(int n) {
            this.kind = n;
        }

        public int getKind() {
            return this.kind;
        }

        public int getUserFigure() {
            return this.userFigure;
        }

        public void setUserFigure(int n) {
            this.userFigure = n;
        }

        public int getGoodFigure() {
            return this.goodFigure;
        }

        public void setGoodFigure(int n) {
            this.goodFigure = n;
        }

        public boolean addPencilMark(int n) {
            Integer n2 = new Integer(n);
            if (this.vectorOfMarks.contains(n2)) {
                this.vectorOfMarks.removeElement(n2);
                --this.pencilMarksCount;
                return false;
            }
            if (this.pencilMarksCount < 6) {
                int n3;
                for (n3 = 0; n3 < this.pencilMarksCount && (Integer)this.vectorOfMarks.elementAt(n3) < n; ++n3) {
                }
                this.vectorOfMarks.insertElementAt(n2, n3);
                ++this.pencilMarksCount;
            }
            return true;
        }

        public int getPencilMark(int n) {
            if (n < this.pencilMarksCount) {
                return (Integer)this.vectorOfMarks.elementAt(n);
            }
            return 0;
        }

        public void clearPencilMarks() {
            this.pencilMarksCount = 0;
            this.vectorOfMarks.removeAllElements();
        }

        public int getPMCount() {
            return this.pencilMarksCount;
        }

        public void save(DataOutputStream dataOutputStream) {
            try {
                dataOutputStream.writeByte(this.kind);
                int n = MainCanvas.pack(this.userFigure, this.goodFigure);
                dataOutputStream.writeByte(n);
                dataOutputStream.writeByte(this.pencilMarksCount);
                for (int i = 0; i < this.pencilMarksCount; ++i) {
                    n = this.getPencilMark(i);
                    dataOutputStream.writeByte(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void load(DataInputStream dataInputStream) {
            try {
                this.kind = dataInputStream.readByte();
                int n = dataInputStream.readByte();
                this.userFigure = MainCanvas.unpackOld(n);
                this.goodFigure = MainCanvas.unpackYoung(n);
                n = dataInputStream.readByte();
                for (int i = 0; i < n; ++i) {
                    this.addPencilMark(dataInputStream.readByte());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

