/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameCanvas
extends SubCanvas {
    public MainCanvas parent;
    public static Image[] imgCommon;
    public static Image imgSquare;
    public static Image imgProfessor;
    public static Image[] imgLips;
    public static Image imgEraser;
    public static Image imgPencil;
    public static Image imgCorn;
    public static int lipsNr;
    public static final int GAME_IMG_CNT = 7;
    public static final int SM_BORDER = 9;
    public static final int CORNER_RADIUS = 5;
    public static final int LINES_IN_TEXT = 10;
    public static final int LIPS_X = 43;
    public static final int LIPS_Y = 37;
    public int SQUARE_TOP = 60;
    public int SQUARE_LEFT = 25;
    public static boolean solving;
    static final int MARK_COLOR = 16769970;
    static final int CUR_COLOR = 0xFFCF7C;
    public static int FONT_HEIGHT;
    public static int FIGURES_HEIGHT;
    public static final int LINES_SPACE = 1;
    public static final int PUZZLES_CNT = 100;
    public static final int GAME_TIME = 60;
    public int squareSize;
    public int cellSize;
    public int SPACE = 1;
    public int EDGE = 1;
    public int LEFT = 8;
    public int TIME = 13;
    public static final int LT_SPACE = 4;
    public static final int CLOUD_WIDTH;
    public static final int SMALL_REC_HEIGHT = 6;
    public static int cloudHeight;
    public static int cloudX;
    public static int cloudY;
    public static boolean isPenMode;
    public static boolean isMarkRow;
    public static boolean isMarkColumn;
    public SudokuPuzzle sudoku;
    public Menu subMenu;
    public Menu gameMenu;
    public Menu settingsMenu;
    public Menu creatorMenu;
    public MenuItem mainMenu;
    public MenuItem solve;
    public MenuItem play;
    public MenuItem giveUp;
    public MenuItem clearAll;
    public MenuItem highLight;
    public MenuItem continueGame;
    public MenuItem settings;
    public static SlideItem sound;
    public SlideItem tutorial;
    public SlideItem markRow;
    public SlideItem markColumn;
    public boolean isSubMenu = false;
    public TextMenu rulesTxt;
    public TextMenu pencilTxt;
    public TextMenu mistakeTxt;
    public TextMenu highLightTxt;
    public TextMenu hlQuestionTxt;
    public TextMenu giveUpTxt;
    public TextMenu mainMenuTxt;
    public TextMenu activeTxt;
    public TextMenu congratTxt;
    public TextMenu mistakesLeftTxt;
    public TextMenu wellDoneTxt;
    public TextMenu totalTxt;
    public TextMenu laden;
    public TextMenu clearTxt;
    public TextMenu loadingMenu;
    public TextMenu solverText;
    public TextMenu[] saveGridTxt;
    public TextMenu[] solverResponse;
    public static boolean isTutorial;
    public static boolean isRulesTxt;
    public static boolean isPencilTxt;
    public static boolean isMistakeTxt;
    public static boolean isHighLightTxt;
    public static boolean isUp;
    public static boolean isDown;
    public static boolean isLeft;
    public static boolean isRight;
    public static int keyFrame;
    public static boolean oneKeyDone;
    public static final int ONE_KEY_FRAMES = 3;
    public static int penFrame;
    public static boolean isPenAnimatied;
    public static boolean isEraserAnimated;
    public static int animXOffset;
    public static int animYOffset;
    public static boolean isEnd;
    public static int blinkRedCnt;
    public static final int EASY = 0;
    public static final int MEDIUM = 1;
    public static final int HARD = 2;
    public static final int NET_MODE = 3;
    public static int level;
    public static int points;
    public static int[] pointsLevels;
    public static boolean pointsMode;
    public static boolean isSolverMode;
    private GridSolver gridSolver;
    public static int GridNumber;
    public boolean startGame = false;
    public static final int IDLeft = 48;
    public static final int IDTime = 49;
    public static final int IDSmall = 50;
    public static final int IDLarge = 51;
    public static final int IDOptions = 52;
    public static final int IDMainMenu = 53;
    public static final int IDGiveUp = 54;
    public static final int IDClearAll = 55;
    public static final int IDHighLight = 56;
    public static final int IDContinue = 57;
    public static final int IDRulesTxt = 63;
    public static final int IDPencilTxt = 64;
    public static final int IDMistakeTxt = 65;
    public static final int IDHighLightTxt = 66;
    public static final int IDHLQuestionTxt = 67;
    public static final int IDGiveUpTxt = 68;
    public static final int IDmainMenuTxt = 69;
    public static final int IDSolve = 70;
    public static final int IDPlay = 71;
    public static final int IDMark = 72;
    public static final int IDUnmark = 73;
    public static final int IDSelect = 74;
    public static final int IDBack = 75;
    public static final int IDOn = 76;
    public static final int IDSoundLevels = 76;
    public static final int IDSound = 83;
    public static final int IDTutorial = 84;
    public static final int IDMarkRow = 85;
    public static final int IDMarkColumn = 86;
    public static final int IDSettings = 87;
    public static final int IDGivens = 88;
    public static final int IDClearTxt = 90;
    public static final int IDSolverTxt = 91;
    public static final int IDManySolutions = 92;
    public static final int IDNoSolution = 93;
    public static final int IDOneSolution = 94;
    public static final int IDSaveGrid1 = 95;
    public static final int IDSaveGrid2 = 96;
    public static final int IDSaveGrid3 = 97;
    public static final int IDExposedFont = 98;
    public static final int IDMistakeFont = 107;
    public static final int IDFilledFont = 116;
    public static final int IDHighLightedFont = 125;
    public static final int IDMistakesLeft = 134;
    public static final int IDCongrat = 135;
    public static final int IDExit = 136;
    public static final int IDLoading = 137;
    public static final int IDTotal = 138;
    public static final int IDWellDone = 139;

    public GameCanvas(MainCanvas mainCanvas) {
        System.out.println("CONSTRUCITNG GAMECANVAS 1 Freememory: " + Runtime.getRuntime().freeMemory());
        FONT_HEIGHT = BPFontReader.fontHeight[6];
        FIGURES_HEIGHT = BPFontReader.fontHeight[2];
        this.parent = mainCanvas;
        this.gameMenu = new Menu(240, 320, 1);
        this.mainMenu = new MenuItem(53, 1, FONT_HEIGHT);
        this.giveUp = new MenuItem(54, 1, FONT_HEIGHT);
        this.clearAll = new MenuItem(55, 1, FONT_HEIGHT);
        this.highLight = new MenuItem(56, 1, FONT_HEIGHT);
        this.continueGame = new MenuItem(57, 1, FONT_HEIGHT);
        this.settings = new MenuItem(87, 1, FONT_HEIGHT);
        this.gameMenu.addItem(this.continueGame);
        this.gameMenu.addItem(this.highLight);
        this.gameMenu.addItem(this.clearAll);
        this.gameMenu.addItem(this.settings);
        this.gameMenu.addItem(this.giveUp);
        this.gameMenu.addItem(this.mainMenu);
        this.creatorMenu = new Menu(240, 320, 1);
        this.solve = new MenuItem(70, 1, FONT_HEIGHT);
        this.play = new MenuItem(71, 1, FONT_HEIGHT);
        this.creatorMenu.addItem(this.continueGame);
        this.creatorMenu.addItem(this.clearAll);
        this.creatorMenu.addItem(this.play);
        this.creatorMenu.addItem(this.solve);
        this.creatorMenu.addItem(this.settings);
        this.creatorMenu.addItem(this.mainMenu);
        this.settingsMenu = new Menu(240, 320, 1);
        sound = new SlideItem(83, 76, 2, 1, FONT_HEIGHT);
        this.tutorial = new SlideItem(84, 76, 2, 1, FONT_HEIGHT);
        this.markRow = new SlideItem(85, 76, 2, 1, FONT_HEIGHT);
        this.markColumn = new SlideItem(86, 76, 2, 1, FONT_HEIGHT);
        this.settingsMenu.addItem(sound);
        this.settingsMenu.addItem(this.tutorial);
        this.settingsMenu.addItem(this.markRow);
        this.settingsMenu.addItem(this.markColumn);
        System.out.println("CONSTRUCITNG GAMECANVAS 2 Freememory: " + Runtime.getRuntime().freeMemory());
        this.rulesTxt = new TextMenu(CLOUD_WIDTH, cloudY, 63, 10, FONT_HEIGHT, 1, 6);
        this.pencilTxt = new TextMenu(CLOUD_WIDTH, cloudY, 64, 10, FONT_HEIGHT, 1, 6);
        this.mistakeTxt = new TextMenu(CLOUD_WIDTH, cloudY, 65, 10, FONT_HEIGHT, 1, 6);
        this.highLightTxt = new TextMenu(CLOUD_WIDTH, cloudY, 66, 10, FONT_HEIGHT, 1, 6);
        this.hlQuestionTxt = new TextMenu(CLOUD_WIDTH, cloudY, 67, 10, FONT_HEIGHT, 1, 6);
        this.giveUpTxt = new TextMenu(CLOUD_WIDTH, cloudY, 68, 10, FONT_HEIGHT, 1, 6);
        this.mainMenuTxt = new TextMenu(CLOUD_WIDTH, cloudY, 69, 10, FONT_HEIGHT, 1, 6);
        this.clearTxt = new TextMenu(CLOUD_WIDTH, cloudY, 90, 10, FONT_HEIGHT, 1, 6);
        this.solverText = new TextMenu(CLOUD_WIDTH, cloudY, 91, 10, FONT_HEIGHT, 1, 6);
        this.saveGridTxt = new TextMenu[3];
        this.saveGridTxt[0] = new TextMenu(CLOUD_WIDTH, cloudY, 95, 10, FONT_HEIGHT, 1, 6);
        this.saveGridTxt[1] = new TextMenu(CLOUD_WIDTH, cloudY, 96, 10, FONT_HEIGHT, 1, 6);
        this.saveGridTxt[2] = new TextMenu(CLOUD_WIDTH, cloudY, 97, 10, FONT_HEIGHT, 1, 6);
        this.solverResponse = new TextMenu[3];
        this.solverResponse[0] = new TextMenu(CLOUD_WIDTH, cloudY, 93, 10, FONT_HEIGHT, 1, 6);
        this.solverResponse[1] = new TextMenu(CLOUD_WIDTH, cloudY, 94, 10, FONT_HEIGHT, 1, 6);
        this.solverResponse[2] = new TextMenu(CLOUD_WIDTH, cloudY, 92, 10, FONT_HEIGHT, 1, 6);
        this.congratTxt = new TextMenu(CLOUD_WIDTH, cloudY, 135, 10, FONT_HEIGHT, 1, 6);
        this.mistakesLeftTxt = new TextMenu(CLOUD_WIDTH, cloudY, 134, 10, FONT_HEIGHT, 1, 6);
        this.loadingMenu = new TextMenu(CLOUD_WIDTH, cloudY, 137, 10, FONT_HEIGHT, 1, 6);
        this.totalTxt = new TextMenu(CLOUD_WIDTH, cloudY, 138, 10, FONT_HEIGHT, 1, 6);
        this.wellDoneTxt = new TextMenu(CLOUD_WIDTH, cloudY, 139, 10, FONT_HEIGHT, 1, 6);
        this.laden = null;
        System.out.println("GAME CANVAS CONSTRUCTED");
        System.out.println("CONSTRUCITNG GAMECANVAS  3Freememory: " + Runtime.getRuntime().freeMemory());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionKeyPressed(int n, int n2) {
        isLeft = false;
        isRight = false;
        isUp = false;
        isDown = false;
        isPenAnimatied = false;
        isEraserAnimated = false;
        if (this.activeTxt != null) {
            if (n2 == 300 || n2 == 301) {
                this.activeTxt.keyPressed(n);
                return;
            }
            this.activeTxt.firstLine = 0;
            if (this.activeTxt == this.mainMenuTxt) {
                this.parent.changeCanvas(this.parent.menuCanvas);
                this.activeTxt = null;
                return;
            } else if (this.activeTxt == this.saveGridTxt[GridNumber]) {
                if (!isEnd) {
                    this.parent.menuCanvas.savePuzzle(this.sudoku.getPuzzle(), GridNumber);
                }
                if (this.creatorMenu.selected == 2) {
                    this.activeTxt = this.loadingMenu;
                    this.parent.repaint();
                    this.parent.serviceRepaints();
                    this.startPlayingInSolverMode();
                    return;
                } else {
                    this.parent.changeCanvas(this.parent.menuCanvas);
                    this.activeTxt = null;
                }
                return;
            } else if (this.activeTxt == this.congratTxt) {
                this.activeTxt = this.totalTxt;
                return;
            } else if (this.activeTxt == this.highLightTxt) {
                this.activeTxt = this.hlQuestionTxt;
                return;
            } else if (this.activeTxt == this.giveUpTxt) {
                if (n == 304 && !isEnd) {
                    this.activeTxt = this.loadingMenu;
                    this.parent.repaint();
                    this.parent.serviceRepaints();
                    this.sudoku.giveUp();
                    isEnd = true;
                    this.activeTxt = null;
                    return;
                } else {
                    if (n != 305) return;
                    this.activeTxt = null;
                }
                return;
            } else if (this.activeTxt == this.mistakeTxt) {
                this.activeTxt = this.sudoku.getLeft() == 0 ? this.mistakesLeftTxt : null;
                return;
            } else if (this.activeTxt == this.hlQuestionTxt) {
                int n3 = n2 - 48;
                if (n3 >= 0 && n3 <= 9) {
                    this.sudoku.highlightFigure(n3);
                    this.sudoku.figureHightLighted = n3;
                    this.activeTxt = null;
                }
                if (n != 305) return;
                this.activeTxt = null;
                return;
            } else if (this.activeTxt == this.clearTxt) {
                if (n == 304 && !isEnd) {
                    if (isSolverMode) {
                        this.sudoku.eraseAll(true);
                    } else {
                        this.sudoku.eraseAll(false);
                    }
                    this.activeTxt = null;
                    return;
                } else {
                    if (n != 305) return;
                    this.activeTxt = null;
                }
                return;
            } else if (this.activeTxt == this.rulesTxt) {
                this.sudoku.setTimeLeft(60);
                this.activeTxt = null;
                return;
            } else {
                this.activeTxt = null;
            }
            return;
        }
        if (this.isSubMenu) {
            if (n == 305) {
                if (this.subMenu == this.settingsMenu) {
                    this.subMenu = isSolverMode ? this.creatorMenu : this.gameMenu;
                    return;
                } else {
                    this.isSubMenu = false;
                }
                return;
            }
            boolean bl = false;
            if (GameCanvas.sound.value == 1) {
                bl = true;
            }
            if (n == 299 || n == 304) {
                MenuItem menuItem = this.subMenu.getSelected();
                if (menuItem == this.continueGame) {
                    this.isSubMenu = false;
                } else if (menuItem == this.play) {
                    this.activeTxt = this.saveGridTxt[GridNumber];
                } else if (menuItem == this.solve) {
                    this.activeTxt = this.loadingMenu;
                    this.isSubMenu = false;
                    this.parent.repaint();
                    this.parent.serviceRepaints();
                    this.solveSudokuInSolverMode();
                } else if (menuItem == this.highLight) {
                    if (isTutorial && isHighLightTxt) {
                        isHighLightTxt = false;
                        this.activeTxt = this.highLightTxt;
                    } else {
                        this.activeTxt = this.hlQuestionTxt;
                    }
                } else {
                    if (menuItem == this.settings) {
                        this.subMenu = this.settingsMenu;
                        this.subMenu.selected = 0;
                        return;
                    }
                    if (menuItem == this.clearAll) {
                        if (isEnd) return;
                        this.activeTxt = this.clearTxt;
                    } else if (menuItem == this.mainMenu) {
                        if (isSolverMode) {
                            this.activeTxt = this.saveGridTxt[GridNumber];
                        } else if (!isEnd && pointsMode) {
                            this.activeTxt = this.mainMenuTxt;
                        } else {
                            this.parent.changeCanvas(this.parent.menuCanvas);
                        }
                    } else if (menuItem == this.giveUp) {
                        if (isEnd) return;
                        this.activeTxt = this.giveUpTxt;
                    } else if (menuItem instanceof SlideItem) {
                        ((SlideItem)menuItem).increment();
                        MenuCanvas.sound.value = GameCanvas.sound.value;
                        isMarkRow = this.markRow.getValue() == 0;
                        isMarkColumn = this.markColumn.getValue() == 0;
                        isTutorial = this.tutorial.getValue() == 0;
                        return;
                    }
                }
                this.isSubMenu = false;
                return;
            } else {
                this.subMenu.keyPressed(n);
                MenuCanvas.sound.value = GameCanvas.sound.value;
                isMarkRow = this.markRow.getValue() == 0;
                isMarkColumn = this.markColumn.getValue() == 0;
                isTutorial = this.tutorial.getValue() == 0;
            }
            return;
        }
        if (n == 305) {
            if (isEnd) {
                if (isSolverMode) {
                    this.activeTxt = this.saveGridTxt[GridNumber];
                    return;
                } else {
                    this.parent.changeCanvas(this.parent.menuCanvas);
                }
                return;
            } else {
                this.isSubMenu = true;
                this.subMenu.selected = 0;
            }
            return;
        }
        if (n2 == 302) {
            keyFrame = 0;
            isLeft = true;
            oneKeyDone = false;
        } else if (n2 == 303) {
            keyFrame = 0;
            isRight = true;
            oneKeyDone = false;
        } else if (n2 == 300) {
            keyFrame = 0;
            isUp = true;
            oneKeyDone = false;
        } else if (n2 == 301) {
            keyFrame = 0;
            isDown = true;
            oneKeyDone = false;
        }
        if (isEnd) {
            return;
        }
        int n4 = n2 - 48;
        if (n4 >= 1 && n4 <= 9) {
            if (isSolverMode) {
                this.sudoku.setFigure(SudokuPuzzle.curX, SudokuPuzzle.curY, n4);
                this.sudoku.addKind(SudokuPuzzle.curX, SudokuPuzzle.curY, 1);
                isPenAnimatied = true;
                penFrame = this.cellSize;
                if (this.sudoku.isKind(SudokuPuzzle.curX, SudokuPuzzle.curY, 4)) {
                    SudokuMidlet.playSound(4);
                } else {
                    SudokuMidlet.playSound(3);
                }
            } else if (isPenMode) {
                if (this.sudoku.setFigure(n4)) {
                    isPenAnimatied = true;
                    penFrame = this.cellSize;
                    if (this.sudoku.getLeft() == 0) {
                        if (this.sudoku.isGood()) {
                            if (pointsMode) {
                                this.activeTxt = this.congratTxt;
                                isEnd = true;
                                this.setPoints();
                                return;
                            }
                            this.activeTxt = this.wellDoneTxt;
                            isEnd = true;
                        } else {
                            this.activeTxt = this.mistakesLeftTxt;
                        }
                    }
                    if (this.sudoku.isKind(SudokuPuzzle.curX, SudokuPuzzle.curY, 4)) {
                        SudokuMidlet.playSound(4);
                    } else {
                        SudokuMidlet.playSound(3);
                    }
                } else {
                    blinkRedCnt = 3;
                }
            } else if (!this.sudoku.addOrTakePencilMark(n4)) {
                blinkRedCnt = 3;
            }
        }
        if (n2 == 42 && !isSolverMode) {
            if (isTutorial && isHighLightTxt) {
                isHighLightTxt = false;
                this.activeTxt = this.highLightTxt;
                return;
            } else {
                this.activeTxt = this.hlQuestionTxt;
            }
            return;
        }
        if (n == 304) {
            if (isSolverMode) return;
            boolean bl = isPenMode = !isPenMode;
            if (!isTutorial || !isPencilTxt) return;
            isPencilTxt = false;
            this.activeTxt = this.pencilTxt;
            return;
        }
        if (n2 != 48 && n != 306) return;
        if (isSolverMode) {
            this.sudoku.eraseCell(SudokuPuzzle.curX, SudokuPuzzle.curY);
            this.sudoku.markDoubleFigures();
            isEraserAnimated = true;
            penFrame = this.cellSize;
        } else if (this.sudoku.eraseCell()) {
            isEraserAnimated = true;
            penFrame = this.cellSize;
            this.sudoku.markDoubleFigures();
        } else {
            blinkRedCnt = 3;
            return;
        }
        SudokuMidlet.playSound(2);
    }

    public void setPoints() {
        int n;
        int n2 = 4;
        int n3 = this.sudoku.getTimeLeftNum();
        if (n3 > 60) {
            n3 = 0;
        }
        points = n3 * pointsLevels[level];
        this.sudoku.stopTime();
        System.out.println("setPoints");
        for (n = 0; n < MenuCanvas.bestTimes[level].length; ++n) {
            System.out.println("i := " + n);
            if (points <= MenuCanvas.bestTimes[level][n]) continue;
            System.out.println("setting TMP :" + n);
            n2 = n;
            break;
        }
        System.out.println("moving:");
        for (n = MenuCanvas.bestTimes[level].length - 2; n >= n2; --n) {
            System.out.println("i:" + n);
            MenuCanvas.bestTimes[GameCanvas.level][n + 1] = MenuCanvas.bestTimes[level][n];
        }
        System.out.println("setting record : MenuCanvas.bestTimes[level][tmp]");
        if (n2 < MenuCanvas.bestTimes[level].length) {
            MenuCanvas.bestTimes[GameCanvas.level][n2] = points;
        }
        MenuCanvas.totalPoints += points;
        SudokuMidlet.playSound(1);
    }

    public void actionKeyReleased(int n, int n2) {
        if (this.activeTxt != null && (n2 == 300 || n2 == 301)) {
            this.activeTxt.keyReleased(n);
            return;
        }
        isLeft = false;
        isRight = false;
        isUp = false;
        isDown = false;
    }

    public void createGridSolver() {
        solving = true;
        this.disposeGraph();
        this.parent.menuCanvas.disposeCommonGraph();
        BPFontReader.freeMemory(true);
        System.gc();
        System.out.println("CREATING NEW PUZZLE: FREE MEM: " + Runtime.getRuntime().freeMemory());
        this.gridSolver = new GridSolver(3);
        System.out.println("FREE MEM WITH GRID SOLVER: " + Runtime.getRuntime().freeMemory());
    }

    public void disposeGridSolver() {
        this.gridSolver = null;
        System.gc();
        System.out.println("FREE MEM AFTER: " + Runtime.getRuntime().freeMemory());
        this.parent.menuCanvas.initCommonGraph();
        this.initGraph();
        BPFontReader.init(MainCanvas.midlet, "PL", true);
        solving = false;
    }

    public void startPlayingInSolverMode() {
        int[][] nArray = this.sudoku.getPuzzle();
        int n = this.solvePuzzle(nArray);
        this.activeTxt = this.solverResponse[n];
        if (n == 0) {
            return;
        }
        pointsMode = false;
        isSolverMode = false;
        isRulesTxt = true;
        isPencilTxt = true;
        isMistakeTxt = true;
        isHighLightTxt = true;
        isSolverMode = false;
        isTutorial = this.tutorial.getValue() == 0;
        isPenMode = true;
        this.subMenu = this.gameMenu;
        this.sudoku.fill(this.getSolvedPuzzle(), nArray);
        this.sudoku.setTimeLeft(60);
        nArray = null;
    }

    public void solveSudokuInSolverMode() {
        this.parent.menuCanvas.savePuzzle(this.sudoku.getPuzzle(), GridNumber);
        int[][] nArray = this.sudoku.getPuzzle();
        int n = this.solvePuzzle(nArray);
        this.activeTxt = this.solverResponse[n];
        if (n == 0) {
            return;
        }
        this.sudoku.fill(this.getSolvedPuzzle(), nArray);
        this.sudoku.giveUp();
        isEnd = true;
        nArray = null;
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (solving) {
            graphics.setClip(0, 0, 240, 320);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, 0, 240, 320);
            graphics.setColor(0);
            graphics.drawString("Wait...", 10, 10, 20);
            return;
        }
        graphics.setClip(0, 0, 240, 320);
        graphics.drawImage(MenuCanvas.imgNote, 0, 0, 0);
        boolean bl = true;
        graphics.setClip(0, 0, 240, 320);
        graphics.translate(0, this.SQUARE_TOP);
        int n4 = this.SQUARE_LEFT + this.EDGE + SudokuPuzzle.curX * this.cellSize + (this.EDGE + this.SPACE) * (SudokuPuzzle.curX / 3);
        int n5 = this.EDGE + SudokuPuzzle.curY * this.cellSize + (this.EDGE + this.SPACE) * (SudokuPuzzle.curY / 3);
        graphics.setColor(16769970);
        if (isMarkRow) {
            for (n3 = 0; n3 < 3; ++n3) {
                graphics.fillRect(this.SQUARE_LEFT + n3 * (this.squareSize + this.SPACE), n5, this.squareSize, this.cellSize);
            }
        }
        if (isMarkColumn) {
            for (n3 = 0; n3 < 3; ++n3) {
                graphics.fillRect(n4, n3 * (this.squareSize + this.SPACE), this.cellSize, this.squareSize);
            }
        }
        graphics.setColor(0xFFCF7C);
        graphics.fillRect(n4, n5, this.cellSize, this.cellSize);
        for (n3 = 0; n3 < 3; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                graphics.drawImage(imgSquare, this.SQUARE_LEFT + n3 * (this.squareSize + this.SPACE), n2 * (this.squareSize + this.SPACE), 0);
            }
        }
        for (n = 0; n < 9; ++n) {
            n2 = this.SQUARE_LEFT + this.EDGE + this.cellSize * n + (this.EDGE + this.SPACE) * (n / 3);
            for (int i = 0; i < 9; ++i) {
                int n6 = this.EDGE + this.cellSize * i + (this.EDGE + this.SPACE) * (i / 3);
                if (this.sudoku.isKind(n, i, 1)) {
                    if (n == SudokuPuzzle.curX) {
                        if (i == SudokuPuzzle.curY && blinkRedCnt > 0) {
                            graphics.setClip(0, 0, 240, 320);
                            graphics.setColor(0xFF0000);
                            graphics.drawRect(n2, n6, this.cellSize - this.EDGE - 1, this.cellSize - this.EDGE - 1);
                        }
                    }
                }
                if (this.sudoku.isKind(n, i, 32)) continue;
                if (this.sudoku.isKind(n, i, 16)) {
                    int n7;
                    String string = "";
                    String string2 = "";
                    for (int j = 0; j < this.sudoku.getPMCount(n, i) && (n7 = this.sudoku.getPencilMark(n, i, j)) != 0; ++j) {
                        if (j < 3) {
                            string2 = string2 + n7 + "";
                            continue;
                        }
                        string = string + n7 + "";
                    }
                    n3 = 7;
                    BPFontReader.drawGraphicText(string2, n2 + this.EDGE, n6 + (this.cellSize >> 1) - MenuCanvas.SMALLFONT_HEIGHT - this.EDGE, n3, 2, graphics);
                    BPFontReader.drawGraphicText(string, n2 + this.EDGE, n6 + (this.cellSize >> 1), n3, 2, graphics);
                    continue;
                }
                n3 = this.setAlphabet(n, i);
                int n8 = BPFontReader.getGraphicTextWidth(n3 + this.sudoku.getFigure(n, i), 0) >> 1;
                BPFontReader.drawGraphicText(n3 + this.sudoku.getFigure(n, i), 0, n2 + (this.cellSize >> 1) - n8, n6 + (this.cellSize >> 1) - (FIGURES_HEIGHT >> 1), graphics);
            }
        }
        if (this.activeTxt == null && !this.isSubMenu) {
            graphics.setClip(-240, -320, 480, 640);
            if (isPenAnimatied) {
                graphics.drawImage(imgPencil, n4 + (this.cellSize >> 1) + animXOffset, n5 + (this.cellSize >> 1) + animYOffset, 36);
            } else if (isEraserAnimated) {
                graphics.drawImage(imgEraser, n4 + (this.cellSize >> 1) - penFrame, n5 + this.cellSize + animYOffset, 36);
            }
        }
        if (!isSolverMode) {
            int n9;
            graphics.translate(0, 3 * this.squareSize + 2 * this.SPACE);
            BPFontReader.drawGraphicText(48, 0, this.SQUARE_LEFT + this.LEFT, 4, graphics);
            if (pointsMode) {
                n9 = BPFontReader.getGraphicTextWidth(49, 0);
                BPFontReader.drawGraphicText(49, 0, this.SQUARE_LEFT + 3 * this.squareSize + 2 * this.SPACE - this.TIME - n9, 4, graphics);
            }
            graphics.translate(0, MenuCanvas.FONT_HEIGHT + 1);
            int n10 = BPFontReader.getTextWidth("" + this.sudoku.getLeft(), 0, 2) >> 1;
            n9 = BPFontReader.getGraphicTextWidth(48, 0) >> 1;
            BPFontReader.drawGraphicText("" + this.sudoku.getLeft(), this.SQUARE_LEFT + this.LEFT + n9 - n10, 0, 0, 2, graphics);
            if (pointsMode) {
                n9 = BPFontReader.getGraphicTextWidth(49, 0) >> 1;
                n10 = BPFontReader.getTextWidth("00:00:00", 0, 2) >> 1;
                if (this.activeTxt != this.rulesTxt) {
                    BPFontReader.drawGraphicText("" + this.sudoku.getTimeLeft(), this.SQUARE_LEFT + 3 * this.squareSize + 2 * this.SPACE - this.TIME - n9 - n10, 0, 0, 2, graphics);
                } else {
                    BPFontReader.drawGraphicText("01:00:00", this.SQUARE_LEFT + 3 * this.squareSize + 2 * this.SPACE - this.TIME - n9 - n10, 0, 0, 2, graphics);
                }
            }
        } else {
            graphics.translate(0, 3 * this.squareSize + 2 * this.SPACE);
            BPFontReader.drawGraphicText(88, 0, this.SQUARE_LEFT + this.LEFT, 4, graphics);
            graphics.translate(0, MenuCanvas.FONT_HEIGHT + 1);
            int n11 = BPFontReader.getTextWidth("" + (81 - this.sudoku.getLeft()), 0, 2) >> 1;
            int n12 = BPFontReader.getGraphicTextWidth(88, 0) >> 1;
            BPFontReader.drawGraphicText("" + (81 - this.sudoku.getLeft()), this.SQUARE_LEFT + this.LEFT + n12 - n11, 0, 0, 2, graphics);
        }
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        graphics.setClip(0, 0, 240, 320);
        if (this.isSubMenu) {
            graphics.drawImage(imgProfessor, 0, 320, 36);
            this.drawFilledRoundRect(graphics, cloudX + (CLOUD_WIDTH >> 1) - (this.subMenu.w >> 1) - 9 - 1, cloudY - this.subMenu.h - 18, this.subMenu.w + 18 + 2, this.subMenu.h + 18);
            this.subMenu.paint(graphics, cloudX + (CLOUD_WIDTH >> 1), cloudY - this.subMenu.h - 9);
            graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
            graphics.setClip(0, 0, 240, 320);
        } else if (this.activeTxt != null) {
            graphics.drawImage(imgProfessor, 0, 320, 36);
            graphics.drawImage(imgLips[lipsNr], 43, cloudY + 37, 0);
            this.drawFilledRoundRect(graphics, cloudX, cloudY - cloudHeight, CLOUD_WIDTH, cloudHeight);
            graphics.drawImage(imgCorn, cloudX + (CLOUD_WIDTH >> 1), cloudY, 0);
            if (this.activeTxt == this.congratTxt) {
                n = BPFontReader.getTextWidth("" + this.sudoku.getTimeLeft(), 8, 2) >> 1;
                BPFontReader.drawGraphicText("" + this.sudoku.getTimeLeft(), cloudX + (CLOUD_WIDTH >> 1) - n, cloudY - cloudHeight + 9 + 2 * FONT_HEIGHT + 1, 8, 2, graphics);
                n = BPFontReader.getTextWidth("" + points, 8, 2) >> 1;
                BPFontReader.drawGraphicText("" + points, cloudX + (CLOUD_WIDTH >> 1) - n, cloudY - cloudHeight + 9 + 4 * FONT_HEIGHT + 3, 8, 2, graphics);
            } else if (this.activeTxt == this.totalTxt) {
                n = BPFontReader.getTextWidth("" + MenuCanvas.totalPoints, 8, 2) >> 1;
                BPFontReader.drawGraphicText("" + MenuCanvas.totalPoints, cloudX + (CLOUD_WIDTH >> 1) - n, cloudY - cloudHeight + 9 + 2 * FONT_HEIGHT + 1, 8, 2, graphics);
            }
            n = 0;
            if (this.activeTxt.length == 1) {
                n = 2;
            } else if (this.activeTxt.length <= 3) {
                n = 1;
            }
            this.activeTxt.paint(graphics, cloudX + (CLOUD_WIDTH >> 1), cloudY - cloudHeight + 9 + n * (FONT_HEIGHT + 1));
        }
        graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
        graphics.setClip(0, 0, 240, 320);
        if (this.activeTxt == null) {
            if (this.isSubMenu) {
                BPFontReader.drawGraphicText(74, 0, 2, 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
                BPFontReader.drawGraphicText(44, 0, 238 - BPFontReader.getGraphicTextWidth(44, 0), 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            } else if (isEnd) {
                BPFontReader.drawGraphicText(136, 0, 238 - BPFontReader.getGraphicTextWidth(136, 0), 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            } else {
                if (!isSolverMode) {
                    BPFontReader.drawGraphicText(isPenMode ? 50 : 51, 0, 2, 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
                }
                BPFontReader.drawGraphicText(52, 0, 238 - BPFontReader.getGraphicTextWidth(52, 0), 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            }
        } else if (this.activeTxt == this.giveUpTxt || this.activeTxt == this.clearTxt || this.activeTxt == this.laden) {
            BPFontReader.drawGraphicText(45, 0, 2, 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
            BPFontReader.drawGraphicText(46, 0, 238 - BPFontReader.getGraphicTextWidth(46, 0), 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
        } else if (this.activeTxt != this.mainMenuTxt && this.activeTxt != this.loadingMenu) {
            BPFontReader.drawGraphicText(75, 0, 238 - BPFontReader.getGraphicTextWidth(75, 0), 320 - MenuCanvas.SOFT_KEYS_FONT_HEIGHT - 1, graphics);
        }
    }

    public void drawFilledRoundRect(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(0);
        graphics.fillRoundRect(n - 1, n2 - 1, n3 + 2, n4 + 2, 18, 18);
        graphics.setColor(0xFFFFFF);
        graphics.fillRoundRect(n, n2, n3, n4, 18, 18);
    }

    public void init() {
        if (this.startGame) {
            this.startGame = false;
            int[][] nArray = GameCanvas.getPuzzle(level, Math.abs(MenuCanvas.rand.nextInt() % 100));
            this.solvePuzzle(nArray);
            System.out.println("FILLING SUDOKU");
            this.sudoku.fill(this.getSolvedPuzzle(), nArray);
            this.sudoku.setTimeLeft(60);
            nArray = null;
            System.out.println("NEW PUZZLE CREATED");
        }
        blinkRedCnt = 0;
        Menu.animadedStress = false;
        isEnd = false;
        isUp = false;
        isDown = false;
        isLeft = false;
        isRight = false;
        isPenAnimatied = false;
        isEraserAnimated = false;
        penFrame = 0;
        animYOffset = 0;
        isMarkRow = MenuCanvas.markRow.getValue() == 0;
        isMarkColumn = MenuCanvas.markColumn.getValue() == 0;
        isTutorial = MenuCanvas.tutorial.getValue() == 0;
        this.isSubMenu = false;
        isPenMode = true;
        this.subMenu = isSolverMode ? this.creatorMenu : this.gameMenu;
        GameCanvas.sound.value = MenuCanvas.sound.value;
        this.tutorial.value = MenuCanvas.tutorial.value;
        this.markRow.value = MenuCanvas.markRow.value;
        this.markColumn.value = MenuCanvas.markColumn.value;
    }

    public void initGraph() {
        System.out.println("GRAFY w GAME");
        try {
            imgCommon = new Image[7];
            this.parent.loadImages("g", imgCommon);
            System.out.println("GRAFY w GAME 1");
            imgSquare = imgCommon[0];
            this.squareSize = imgSquare.getWidth();
            this.cellSize = (this.squareSize - this.EDGE) / 3;
            System.out.println("GRAFY w GAME 2, SQUARE_LEFT: " + this.SQUARE_LEFT);
            imgCorn = imgCommon[1];
            imgProfessor = imgCommon[2];
            imgPencil = MenuCanvas.imgPen;
            imgEraser = imgCommon[3];
            System.out.println("GRAFY w GAME 3");
            imgLips = new Image[3];
            GameCanvas.imgLips[0] = imgCommon[4];
            GameCanvas.imgLips[1] = imgCommon[5];
            GameCanvas.imgLips[2] = imgCommon[6];
            lipsNr = 0;
            System.out.println("GRAFY w GAME 4");
            cloudX = 120 - (CLOUD_WIDTH >> 1);
            cloudY = 320 - imgProfessor.getHeight();
            cloudHeight = 9 + 10 * FONT_HEIGHT + 18;
        }
        catch (Exception exception) {
            System.out.println("ZONK PRZY INICJALIZAJI GRAFY w GAME");
        }
        long l = Runtime.getRuntime().freeMemory();
        this.gridSolver = new GridSolver(3);
        System.out.println("GRIDSOLVER MEMORY USAGE: " + (l - Runtime.getRuntime().freeMemory()));
    }

    public int setAlphabet(int n, int n2) {
        if (this.sudoku.isKind(n, n2, 4)) {
            if (isTutorial && isMistakeTxt) {
                isMistakeTxt = false;
                this.activeTxt = this.mistakeTxt;
            }
            return 106;
        }
        if (this.sudoku.isKind(n, n2, 8)) {
            return 124;
        }
        if (this.sudoku.isKind(n, n2, 1)) {
            return 97;
        }
        if (this.sudoku.isKind(n, n2, 2)) {
            return 115;
        }
        return 0;
    }

    public void dispose() {
        MenuCanvas.sound.value = GameCanvas.sound.value;
        MenuCanvas.tutorial.value = this.tutorial.value;
        MenuCanvas.markRow.value = this.markRow.value;
        MenuCanvas.markColumn.value = this.markColumn.value;
        if (isEnd) {
            MenuCanvas cfr_ignored_0 = this.parent.menuCanvas;
            MenuCanvas.continueGame.Active = false;
        }
    }

    public void disposeGraph() {
        if (imgCommon != null) {
            for (int i = 0; i < 7; ++i) {
                GameCanvas.imgCommon[i] = null;
            }
        }
        imgCommon = null;
        imgSquare = null;
        this.gridSolver = null;
        System.gc();
    }

    public void startCreating(int[][] nArray) {
        this.sudoku = new SudokuPuzzle();
        if (nArray != null) {
            this.sudoku.fill(null, nArray);
        }
        isSolverMode = true;
        isMistakeTxt = true;
        isRulesTxt = true;
        if (isTutorial && isRulesTxt) {
            this.activeTxt = this.solverText;
            isRulesTxt = false;
        } else {
            this.activeTxt = null;
        }
    }

    public int solvePuzzle(int[][] nArray) {
        System.out.println("Solving puzzle using GridSolver");
        return this.gridSolver.solve(nArray, true);
    }

    public int[][] getSolvedPuzzle() {
        System.out.println("Getting solved puzzle using GridSolver");
        int[][] nArray = new int[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                nArray[i][j] = Math.abs(this.gridSolver.get(i, j));
            }
        }
        System.out.println("Puzzle Getted");
        return nArray;
    }

    public void startGame(int n) {
        System.out.println("GameCanvas - starting game ");
        level = n;
        pointsMode = true;
        isPencilTxt = true;
        isMistakeTxt = true;
        isRulesTxt = true;
        isHighLightTxt = true;
        isSolverMode = false;
        isPenMode = true;
        isTutorial = this.tutorial.getValue() == 0;
        isPenMode = true;
        this.subMenu = this.gameMenu;
        if (isTutorial && isRulesTxt) {
            this.activeTxt = this.rulesTxt;
            isRulesTxt = false;
        }
        this.startGame = true;
        this.sudoku = null;
        this.sudoku = new SudokuPuzzle();
    }

    public static int[][] getPuzzle(int n, int n2) {
        int[][] nArray = new int[9][9];
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        System.out.println("CZYTAM PUZZLE ");
        try {
            inputStream = ((Object)((Object)MainCanvas.midlet)).getClass().getResourceAsStream("/" + n);
            inputStreamReader = new InputStreamReader(inputStream);
            inputStreamReader.skip(n2 * 81);
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 9; ++j) {
                    nArray[i][j] = inputStreamReader.read();
                    System.out.print("" + nArray[i][j]);
                }
                System.out.println("");
            }
            System.out.println("Mutuje! ");
            nArray = GameCanvas.mutate(nArray);
            System.out.println("ZMUTOWANE! ");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        inputStreamReader = null;
        inputStream = null;
        System.out.println(" ReadEnd! ");
        return nArray;
    }

    public static int[][] mutate(int[][] nArray) {
        Random random = new Random(System.currentTimeMillis());
        Random random2 = new Random(System.currentTimeMillis() % (long)Math.abs(random.nextInt()));
        int n = Math.abs(random.nextInt() % 4);
        for (int i = 0; i < n; ++i) {
            GameCanvas.mutatePairOfNumbers(nArray, Math.abs(random.nextInt() % 9) + 1, Math.abs(random2.nextInt() % 9) + 1);
            if (Math.abs(random.nextInt() % 2) == 0) {
                nArray = GameCanvas.mirroreGrid(nArray);
            }
            GameCanvas.mutatePairOfLines(nArray, Math.abs(random.nextInt() % 3));
            if (Math.abs(random2.nextInt() % 2) == 0) {
                nArray = GameCanvas.turnGrid90(nArray);
            }
            GameCanvas.mutatePairOfBlocks(nArray);
        }
        random = null;
        random2 = null;
        return nArray;
    }

    public static int[][] mutatePairOfNumbers(int[][] nArray, int n, int n2) {
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (nArray[i][j] == n) {
                    nArray[i][j] = n2;
                    continue;
                }
                if (nArray[i][j] != n2) continue;
                nArray[i][j] = n;
            }
        }
        return nArray;
    }

    public static int[][] mutatePairOfLines(int[][] nArray, int n) {
        int n2 = 0;
        int n3 = 2;
        if (n2 != n3) {
            int n4 = 3 * n + n2;
            int n5 = 3 * n + n3;
            int[] nArray2 = nArray[n4];
            nArray[n4] = nArray[n5];
            nArray[n5] = nArray2;
            if (n != 1) {
                n = n == 0 ? 2 : 0;
                n5 = 3 * n + n2;
                n4 = 3 * n + n3;
                nArray2 = nArray[n4];
                nArray[n4] = nArray[n5];
                nArray[n5] = nArray2;
            }
        }
        return nArray;
    }

    public static int[][] mutatePairOfBlocks(int[][] nArray) {
        int n = 0;
        int n2 = 2;
        for (int i = 0; i < 3; ++i) {
            int[] nArray2 = nArray[n * 3 + i];
            nArray[n * 3 + i] = nArray[n2 * 3 + i];
            nArray[n2 * 3 + i] = nArray2;
        }
        return nArray;
    }

    public static int[][] turnGrid90(int[][] nArray) {
        int[][] nArray2 = new int[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                nArray2[i][j] = nArray[8 - j][i];
            }
        }
        nArray = nArray2;
        nArray2 = null;
        return nArray;
    }

    public static int[][] mirroreGrid(int[][] nArray) {
        int[][] nArray2 = new int[9][9];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                nArray2[i][j] = nArray[j][i];
            }
        }
        nArray = nArray2;
        nArray2 = null;
        return nArray;
    }

    public void run() {
        if (this.activeTxt != null) {
            this.activeTxt.run();
        }
        if (this.activeTxt != null || this.isSubMenu) {
            int n = Math.abs(MenuCanvas.rand.nextInt() % 3);
            while (lipsNr == n) {
                n = Math.abs(MenuCanvas.rand.nextInt() % 3);
            }
            lipsNr = n;
        } else {
            if (++keyFrame > 3 || !oneKeyDone) {
                if (isLeft) {
                    this.sudoku.cursorLeft();
                } else if (isRight) {
                    this.sudoku.cursorRight();
                } else if (isUp) {
                    this.sudoku.cursorUp();
                } else if (isDown) {
                    this.sudoku.cursorDown();
                }
                oneKeyDone = true;
            }
            if (isPenAnimatied || isEraserAnimated) {
                animYOffset = MenuCanvas.rand.nextInt() % 5;
                animXOffset = MenuCanvas.rand.nextInt() % 5;
                if (--penFrame == 0) {
                    isPenAnimatied = false;
                    isEraserAnimated = false;
                }
            }
        }
        if (blinkRedCnt > 0) {
            --blinkRedCnt;
        }
    }

    public void saveGame(DataOutputStream dataOutputStream) {
        System.out.println("SAVE GAMEs");
        try {
            this.sudoku.saveState(dataOutputStream);
            dataOutputStream.writeBoolean(isSolverMode);
            int n = MainCanvas.pack(GridNumber, level);
            dataOutputStream.writeByte(n);
            dataOutputStream.writeBoolean(isRulesTxt);
            dataOutputStream.writeBoolean(isPencilTxt);
            dataOutputStream.writeBoolean(isMistakeTxt);
            dataOutputStream.writeBoolean(isHighLightTxt);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadState(DataInputStream dataInputStream) {
        System.out.println("LOAD MENU");
        try {
            this.sudoku = new SudokuPuzzle();
            this.sudoku.loadState(dataInputStream);
            isSolverMode = dataInputStream.readBoolean();
            byte by = dataInputStream.readByte();
            GridNumber = MainCanvas.unpackOld(by);
            level = MainCanvas.unpackYoung(by);
            isHighLightTxt = dataInputStream.readBoolean();
            isPencilTxt = dataInputStream.readBoolean();
            isMistakeTxt = dataInputStream.readBoolean();
            isHighLightTxt = dataInputStream.readBoolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        isTutorial = MenuCanvas.tutorial.getValue() == 0;
    }

    static {
        solving = false;
        CLOUD_WIDTH = Math.min(118, 236);
        isPenMode = true;
        isMarkRow = true;
        isMarkColumn = true;
        level = 0;
        pointsLevels = new int[]{15, 50, 100, 150};
        pointsMode = true;
        isSolverMode = false;
        GridNumber = 0;
    }
}

