/*
 * Decompiled with CFR 0.152.
 */
class GridSolver {
    private byte[][] puzzle;
    private int sizeBox;
    private int size;
    private int numCells;
    private int numCol;
    private int numRow;
    private short[][] matrixCol;
    private short[][] matrixRow;
    private int maxColSize;
    private int maxRowSize;
    private byte[] colCounter;
    private byte[] colCounterInit;
    private boolean[] rowActive;
    private boolean[] colActive;
    private int stackptr;
    private short[] stack;
    private boolean foundSol;
    private byte[][] solution;
    private byte[] moves;
    private byte[] solMoves;
    private byte[] boxIndex;
    private boolean fastSolve;

    public GridSolver(byte by) {
        int n;
        int n2;
        this.sizeBox = by;
        this.size = by * by;
        this.numCells = this.size * this.size;
        this.puzzle = new byte[this.size][this.size];
        this.maxRowSize = 4;
        this.maxColSize = this.size;
        this.numCol = this.numCells * 4;
        this.numRow = this.size * this.numCells;
        this.matrixRow = new short[this.numRow][this.maxRowSize];
        this.matrixCol = new short[this.numCol][this.maxColSize];
        this.colCounter = new byte[this.numCol];
        this.colCounterInit = new byte[this.numCol];
        this.rowActive = new boolean[this.numRow];
        this.colActive = new boolean[this.numCol];
        this.stack = new short[this.numRow * 3];
        this.solution = new byte[this.size][this.size];
        this.moves = new byte[this.numCells];
        this.solMoves = new byte[this.numCells];
        this.boxIndex = new byte[this.size];
        for (n2 = 0; n2 < this.size; ++n2) {
            this.boxIndex[n2] = (byte)(n2 / this.sizeBox);
        }
        for (n2 = 0; n2 < this.numCol; ++n2) {
            this.colCounter[n2] = 0;
            this.colActive[n2] = true;
            for (n = 0; n < this.maxColSize; ++n) {
                this.matrixCol[n2][n] = -1;
            }
        }
        for (n2 = 0; n2 < this.numRow; ++n2) {
            this.rowActive[n2] = true;
            for (n = 0; n < this.maxRowSize; ++n) {
                this.matrixRow[n2][n] = -1;
            }
        }
        n2 = 0;
        for (n = 0; n < this.size; ++n) {
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    this.setMatrix(i * this.size + n, n2);
                    this.setMatrix(this.numCells + n * this.size + j, n2);
                    this.setMatrix(this.numCells * 2 + i * this.size + j, n2);
                    int n3 = this.boxIndex[i] * this.sizeBox + this.boxIndex[n];
                    this.setMatrix(this.numCells * 3 + n3 * this.size + j, n2);
                    ++n2;
                }
            }
        }
    }

    private void setMatrix(int n, int n2) {
        int n3 = 0;
        while (this.matrixRow[n2][n3] >= 0) {
            ++n3;
        }
        this.matrixRow[n2][n3] = (short)n;
        n3 = 0;
        while (this.matrixCol[n][n3] >= 0) {
            ++n3;
        }
        this.matrixCol[n][n3] = (short)n2;
        int n4 = n;
        this.colCounterInit[n4] = (byte)(this.colCounterInit[n4] + 1);
    }

    public void set(int n, int n2, byte by) {
        this.puzzle[n][n2] = by;
    }

    public int get(int n, int n2) {
        return this.puzzle[n][n2];
    }

    public int solve(int[][] nArray, boolean bl) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < this.size; ++n3) {
            for (n2 = 0; n2 < this.size; ++n2) {
                n = Math.abs(nArray[n2][n3]);
                this.puzzle[n2][n3] = (byte)(n > this.size ? 0 : n);
            }
        }
        this.fastSolve = bl;
        for (n3 = 0; n3 < this.numCol; ++n3) {
            this.colCounter[n3] = this.colCounterInit[n3];
            this.colActive[n3] = true;
        }
        for (n3 = 0; n3 < this.numRow; ++n3) {
            this.rowActive[n3] = true;
        }
        this.stackptr = 0;
        for (n3 = 0; n3 < this.size; ++n3) {
            for (n2 = 0; n2 < this.size; ++n2) {
                if (this.puzzle[n3][n2] <= 0) continue;
                n = (n3 * this.size + n2) * this.size + this.puzzle[n3][n2] - 1;
                if (this.rowActive[n]) {
                    this.placeRow(n, true);
                    continue;
                }
                return 0;
            }
        }
        this.stackptr = 0;
        this.foundSol = false;
        n3 = this.dosearch(0) ? 1 : 0;
        if (!this.foundSol) {
            return 0;
        }
        for (n2 = 0; n2 < this.size; ++n2) {
            for (n = 0; n < this.size; ++n) {
                this.puzzle[n2][n] = this.solution[n2][n];
            }
        }
        return n3 == 0 ? 1 : 2;
    }

    private void placeRow(int n, boolean bl) {
        if (this.rowActive[n]) {
            short s;
            this.stack[this.stackptr++] = 0;
            this.markRowBad(n);
            int n2 = n % this.size;
            int n3 = n / this.size / this.size;
            int n4 = (n - this.size * this.size * n3 - n2) / this.size;
            if (!bl) {
                this.puzzle[n3][n4] = (byte)(-n2 - 1);
            }
            for (int i = 0; i < this.maxRowSize && (s = this.matrixRow[n][i]) >= 0; ++i) {
                short s2;
                if (!this.colActive[s]) continue;
                this.colActive[s] = false;
                this.stack[this.stackptr++] = (short)(-s - 1);
                for (int j = 0; j < this.maxColSize && (s2 = this.matrixCol[s][j]) >= 0; ++j) {
                    if (!this.rowActive[s2]) continue;
                    this.markRowBad(s2);
                }
            }
        }
    }

    private void unplaceRow(int n) {
        this.unstack();
        int n2 = n % this.size;
        int n3 = n / this.size / this.size;
        int n4 = (n - this.size * this.size * n3 - n2) / this.size;
        this.puzzle[n3][n4] = 0;
    }

    private void unstack() {
        while (this.stack[--this.stackptr] != 0) {
            int n = this.stack[this.stackptr];
            if (n > 0) {
                this.unmarkRowBad(n - 1);
                continue;
            }
            n = -n - 1;
            this.colActive[n] = true;
        }
    }

    private void markRowBad(int n) {
        if (this.rowActive[n]) {
            short s;
            this.rowActive[n] = false;
            for (int i = 0; i < this.maxRowSize && (s = this.matrixRow[n][i]) >= 0; ++i) {
                if (!this.colActive[s]) continue;
                short s2 = s;
                this.colCounter[s2] = (byte)(this.colCounter[s2] - 1);
            }
            this.stack[this.stackptr++] = (short)(n + 1);
        }
    }

    private boolean isInCol(int n, int n2) {
        short s;
        for (int i = 0; i < this.maxColSize && (s = this.matrixCol[n][i]) >= 0; ++i) {
            if (s != n2) continue;
            return true;
        }
        return false;
    }

    private void unmarkRowBad(int n) {
        short s;
        for (int i = 0; i < this.maxRowSize && (s = this.matrixRow[n][i]) >= 0; ++i) {
            if (!this.colActive[s]) continue;
            short s2 = s;
            this.colCounter[s2] = (byte)(this.colCounter[s2] + 1);
        }
        this.rowActive[n] = true;
    }

    private boolean dosearch(int n) {
        int n2;
        int n3;
        int n4 = -1;
        int n5 = this.numRow + 1;
        for (n3 = 0; n3 < this.numCol; ++n3) {
            if (!this.colActive[n3] || n5 <= this.colCounter[n3] || (n5 = this.colCounter[n4 = n3]) != 0) continue;
            return false;
        }
        if (n4 < 0) {
            if (this.foundSol) {
                return true;
            }
            this.foundSolution(n);
            return false;
        }
        if (n5 == 1) {
            short s;
            n3 = -1;
            while (!this.rowActive[s = this.matrixCol[n4][++n3]]) {
            }
            this.placeRow(s, false);
            this.moves[n] = (byte)s;
            if (this.dosearch(n + 1)) {
                return true;
            }
            this.unplaceRow(s);
            return false;
        }
        if (!this.fastSolve) {
            int n6;
            int n7;
            int n8;
            for (n3 = 0; n3 < this.numCol; ++n3) {
                if (!this.colActive[n3]) continue;
                for (n2 = 0; n2 < this.numCol; ++n2) {
                    if (!this.colActive[n2] || this.colCounter[n3] >= this.colCounter[n2]) continue;
                    n8 = 1;
                    for (n7 = 0; n8 != 0 && n7 < this.maxColSize && (n6 = this.matrixCol[n3][n7]) >= 0; ++n7) {
                        if (!this.rowActive[n6]) continue;
                        n8 &= this.isInCol(n2, n6);
                    }
                    if (n8 == 0) continue;
                    this.stack[this.stackptr++] = 0;
                    for (n7 = 0; n7 < this.maxColSize && (n6 = this.matrixCol[n2][n7]) >= 0; ++n7) {
                        if (!this.rowActive[n6] || this.isInCol(n3, n6)) continue;
                        this.markRowBad(n6);
                    }
                    if (this.dosearch(n)) {
                        return true;
                    }
                    this.unstack();
                    return false;
                }
            }
            for (n3 = 0; n3 < this.numCol; ++n3) {
                if (!this.colActive[n3] || this.colCounter[n3] != 2) continue;
                n2 = -1;
                while (!this.rowActive[n8 = this.matrixCol[n3][++n2]]) {
                }
                while (!this.rowActive[n7 = this.matrixCol[n3][++n2]]) {
                }
                for (n6 = n3 + 1; n6 < this.numCol; ++n6) {
                    short s;
                    int n9;
                    short s2;
                    short s3;
                    if (!this.colActive[n6] || this.colCounter[n6] != 2) continue;
                    int n10 = -1;
                    while (!this.rowActive[s3 = this.matrixCol[n6][++n10]]) {
                    }
                    if (n8 == s3 || n7 == s3) continue;
                    while (!this.rowActive[s2 = this.matrixCol[n6][++n10]]) {
                    }
                    if (n8 == s2 || n7 == s2) continue;
                    int n11 = this.getConflictColumn(n8, s3);
                    int n12 = n9 = n11 < 0 ? -1 : this.getConflictColumn(n7, s2);
                    if (n11 < 0 || n9 < 0) {
                        s = s3;
                        s3 = s2;
                        s2 = s;
                        n11 = this.getConflictColumn(n8, s3);
                        int n13 = n9 = n11 < 0 ? -1 : this.getConflictColumn(n7, s2);
                    }
                    if (n11 < 0 || n9 < 0) continue;
                    s = 0;
                    for (int i = 0; i < this.numCol; ++i) {
                        short s4;
                        int n14;
                        if (!this.colActive[i] || this.colCounter[i] <= 2) continue;
                        if (this.isInCol(i, n8) && this.isInCol(i, s3)) {
                            for (n14 = 0; n14 < this.maxColSize && (s4 = this.matrixCol[i][n14]) >= 0; ++n14) {
                                if (!this.rowActive[s4] || s4 == n8 || s4 == s3) continue;
                                if (s == 0) {
                                    this.stack[this.stackptr++] = 0;
                                    s = 1;
                                }
                                this.markRowBad(s4);
                            }
                            continue;
                        }
                        if (!this.isInCol(i, n7) || !this.isInCol(i, s2)) continue;
                        for (n14 = 0; n14 < this.maxColSize && (s4 = this.matrixCol[i][n14]) >= 0; ++n14) {
                            if (!this.rowActive[s4] || s4 == n7 || s4 == s2) continue;
                            if (s == 0) {
                                this.stack[this.stackptr++] = 0;
                                s = 1;
                            }
                            this.markRowBad(s4);
                        }
                    }
                    if (s == 0) continue;
                    if (this.dosearch(n)) {
                        return true;
                    }
                    this.unstack();
                    return false;
                }
            }
        }
        for (n3 = 0; n3 < this.maxColSize && (n2 = this.matrixCol[n4][n3]) >= 0; ++n3) {
            if (!this.rowActive[n2]) continue;
            this.placeRow(n2, false);
            this.moves[n] = (byte)n2;
            if (this.dosearch(n + 1)) {
                return true;
            }
            this.unplaceRow(n2);
        }
        return false;
    }

    private int getConflictColumn(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        do {
            short s = this.matrixRow[n][n3];
            short s2 = this.matrixRow[n2][n4];
            if (s < 0 || s2 < 0) break;
            if (s == s2 && this.colActive[s]) {
                return s;
            }
            if (s < s2) {
                ++n3;
                continue;
            }
            ++n4;
        } while (n3 < this.maxRowSize && n4 < this.maxRowSize);
        return -1;
    }

    private void foundSolution(int n) {
        int n2;
        this.foundSol = true;
        for (n2 = 0; n2 < this.size; ++n2) {
            for (int i = 0; i < this.size; ++i) {
                this.solution[n2][i] = this.puzzle[n2][i];
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.solMoves[n2] = this.moves[n2];
        }
        for (n2 = n; n2 < this.numCells; ++n2) {
            this.solMoves[n2] = -1;
        }
    }

    public int[] getCodeCells(int n) {
        int n2;
        int n3;
        for (n3 = this.numCells - 1; n3 >= 0 && this.solMoves[n3] < 0; --n3) {
        }
        if (n > n3 + 1) {
            n = n3 + 1;
        }
        if ((n2 = n3 - n - n) < 0) {
            n2 = 0;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.solMoves[n2];
            if (++n2 + n - 1 - i >= n3) continue;
            ++n2;
        }
        return nArray;
    }
}

