/*
 * Decompiled with CFR 0.152.
 */
package dribbler;

import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import de.tuttas.GameAPI.Score.GlobalListListener;
import de.tuttas.GameAPI.Score.GlobalScoreListManager;
import de.tuttas.GameAPI.Score.Score;
import de.tuttas.GameAPI.Score.ScoreList;
import de.tuttas.GameAPI.ScrollText;
import de.tuttas.GameAPI.ScrollTextListener;
import de.tuttas.GameAPI.Send2Friend;
import de.tuttas.GameAPI.Send2FriendListener;
import dribbler.AlphaBoard;
import dribbler.Ball;
import dribbler.BallListener;
import dribbler.Config;
import dribbler.ConfigGeneric;
import dribbler.ConfigSound;
import dribbler.Dribbler;
import dribbler.FormatString;
import dribbler.KickPanel;
import dribbler.MyCanvas;
import dribbler.Number;
import dribbler.NumberDisplayable;
import dribbler.Panel;
import dribbler.PanelListener;
import dribbler.Spieler;
import dribbler.Window;
import dribbler.WindowListener;
import java.io.IOException;
import java.util.NoSuchElementException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Displayable
extends MyCanvas
implements BallListener,
MenuListener,
ScrollTextListener,
GlobalListListener,
PanelListener,
WindowListener,
Send2FriendListener {
    public static final int GAME = 1;
    public static final int PAUSE = 2;
    public static final int GAME_OVER = 3;
    public static final int GAME_OVER_FINISHED = 4;
    public static final int MAIN = 5;
    public static final int HELP = 6;
    public static final int SCORE = 7;
    public static final int NEWSCORE = 8;
    public static final int LOAD_GLOBAL = 9;
    public static final int DISPLAY_GLOBAL = 10;
    public static final int SUBMIT_FINISHED = 12;
    public static final int LOAD_ERROR = 13;
    public static final int SUBMIT_START = 14;
    public static final int SUBMIT_ERROR = 15;
    public static final int DISPLAY_WINDOW = 16;
    public static final int ENDE_GAME = 17;
    public static final int LOADING = 18;
    public static final int ABOUT = 19;
    public static final int SEND2FRIEND = 20;
    public static final int SEND2FRIENDFINISHED = 21;
    public static final int SPLASH = 22;
    static boolean soundOption = true;
    static int globalType;
    public static boolean fullRepaint;
    long paintTime = 0L;
    Window w;
    int state;
    int nextState;
    int percent;
    String msg;
    private Spieler spieler;
    public static KickPanel kPanel;
    public static Ball ball;
    public static Panel panel;
    int rank;
    int score;
    public static Number number;
    public static Image mainImage;
    public static Image greatImage;
    ScrollText st;
    public static int nextScore;
    AlphaBoard ab;
    Menu m;
    MenuItem start = new MenuItem("Start", 0xFFFFFF, 0, 0);
    MenuItem leaque = new MenuItem("Leaque", 0xFFFFFF, 0, 0);
    MenuItem help = new MenuItem("Help", 0xFFFFFF, 0, 0);
    MenuItem opt = new MenuItem("Options", 0xFFFFFF, 0, 0);
    MenuItem about = new MenuItem("About", 0xFFFFFF, 0, 0);
    MenuItem send2friend = new MenuItem("Send2Friend", 0xFFFFFF, 0, 0);
    MenuItem exit = new MenuItem("Exit", 0xFFFFFF, 0, 0);
    Menu mOpt;
    MenuItem soundItem = new MenuItem("Sound ON ", 0xFFFFFF, 0, 0);
    Menu mGame;
    MenuItem cont = new MenuItem("Continue", 0xFF0000, 0, 0);
    MenuItem mexit = new MenuItem("Exit", 0xFF0000, 0, 0);
    Menu mLeaqe;
    MenuItem localScores = new MenuItem("Local", 0xFFFFFF, 0, 0);
    MenuItem globalScores = new MenuItem("Global", 0xFFFFFF, 0, 0);
    MenuItem todayScores = new MenuItem("Todays", 0xFFFFFF, 0, 0);
    MenuItem lastScores = new MenuItem("Last", 0xFFFFFF, 0, 0);
    MenuItem submitScore = new MenuItem("Submit", 0xFFFFFF, 0, 0);
    MenuItem back = new MenuItem("Back", 0xFFFFFF, 0, 0);
    Send2Friend send2FriendServer;
    int balls;

    public Displayable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ab.setText(Dribbler.user);
        ball = new Ball();
        ball.setListener(this);
        kPanel = new KickPanel();
        this.balls = 3;
    }

    public void newGame() {
        fullRepaint = true;
        if (this.spieler == null) {
            this.spieler = new Spieler(68, 109);
        }
        this.spieler.reset(68, 109);
        this.w.move2State(1);
        this.state = 1;
        Displayable.number.value = 0;
        this.balls = 3;
        ball.reset();
        Displayable.number.digits = 4;
        nextScore = 1;
        panel.set(greatImage, 3);
        this.addPauseButton("Pause");
        super.startThread();
    }

    private void jbInit() throws Exception {
        this.spieler = new Spieler(68, 109);
        this.w = new Window(88, 60, MenuItem.width + 20, 2 * Config.HELP_FONT.getHeight(), 0, 0xFFFFFF, 2);
        this.w.setListener(this);
        panel = new Panel(4);
        panel.setListener(this);
        greatImage = Image.createImage((String)"/great.png");
        number = new Number(Image.createImage((String)"/segment.png"), 4, 0);
        try {
            mainImage = Image.createImage((String)"/splash.png");
            this.state = 22;
            this.startThread();
        }
        catch (IOException iox) {
            mainImage = Image.createImage((String)"/titel.png");
            this.state = 5;
            ConfigSound.startTitel();
        }
        this.m = new Menu(21);
        this.m.add(this.start);
        this.m.add(this.help);
        this.m.add(this.leaque);
        this.m.add(this.opt);
        this.m.add(this.about);
        if (ConfigGeneric.GAME_CODE != null) {
            this.m.add(this.send2friend);
        }
        this.m.add(this.exit);
        this.m.setListener(this);
        this.m.setVisible(true);
        this.mGame = new Menu(60 - Config.MENU_FONT.getHeight() / 2);
        this.mGame.add(this.cont);
        this.mGame.add(this.mexit);
        this.mGame.setListener(this);
        this.mLeaqe = new Menu(21);
        this.mLeaqe.add(this.localScores);
        this.mLeaqe.add(this.globalScores);
        this.mLeaqe.add(this.todayScores);
        this.mLeaqe.add(this.lastScores);
        this.mLeaqe.add(this.submitScore);
        this.mLeaqe.add(this.back);
        this.mLeaqe.setListener(this);
        this.mOpt = new Menu(21);
        this.mOpt.add(this.soundItem);
        this.mOpt.add(this.back);
        this.mOpt.setListener(this);
        FormatString fs = new FormatString("Move left (4) right (6) jump with up(2) or kick with fire (5).\nJust try as long as you can to keep one of your three balls in the air. You score by every kick and a good combination.\n\n If you got a new topscore you are able to enter your name into the high score list", Config.HELP_FONT, 0, 29, 176, 179);
        this.st = new ScrollText(fs.txt, 176, 179, 1, Config.HELP_FONT);
        this.st.setListener(this);
        this.ab = new AlphaBoard(32, 151, 8, 4, 14, 14);
        if (ConfigGeneric.GAME_CODE != null) {
            this.send2FriendServer = new Send2Friend("http://midlet.dyndns.org/cms/");
            this.send2FriendServer.setListener(this);
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread && this.state != 9) {
            this.repaint();
            try {
                if (this.state == 22) {
                    Thread.sleep(3000L);
                } else {
                    Thread.sleep(35L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (this.state != 22) continue;
            this.stopThread();
            this.exchange("/titel.png", 5);
            ConfigSound.startTitel();
            this.repaint();
        }
    }

    public void keyReleased(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (this.state == 1) {
            this.spieler.stop();
        }
    }

    public void keyPressed(int keyCode) {
        int action = 0;
        try {
            action = this.getGameAction(keyCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.state == 22) {
            this.exchange("/titel.png", 5);
            this.stopThread();
            this.repaint();
            ConfigSound.startTitel();
        } else if (this.state == 1) {
            if (keyCode == -6 || keyCode == -7) {
                this.state = 16;
                this.nextState = 2;
                this.w.move2State(1);
                this.removePauseButton();
            } else {
                switch (action) {
                    case 2: {
                        this.spieler.left(3);
                        break;
                    }
                    case 5: {
                        this.spieler.right(3);
                        break;
                    }
                    case 1: {
                        this.spieler.jump(ball);
                        break;
                    }
                    case 8: {
                        this.spieler.kick(ball);
                    }
                }
            }
            this.repaint();
        } else if (this.state == 20) {
            this.send2FriendServer.stop();
            this.state = 21;
        } else if (this.state == 21) {
            this.exchange("/titel.png", 5);
            this.m.setVisible(true);
            ConfigSound.startTitel();
            this.repaint();
        } else if (this.state == 3) {
            panel.setType(1);
        } else if (this.state == 5) {
            switch (action) {
                case 2: {
                    if (this.m.isVisible()) {
                        this.m.left();
                        break;
                    }
                    if (this.mOpt.isVisible()) {
                        this.mOpt.left();
                        break;
                    }
                    if (!this.mLeaqe.isVisible()) break;
                    this.mLeaqe.left();
                    break;
                }
                case 5: {
                    if (this.m.isVisible()) {
                        this.m.right();
                        break;
                    }
                    if (this.mOpt.isVisible()) {
                        this.mOpt.right();
                        break;
                    }
                    if (!this.mLeaqe.isVisible()) break;
                    this.mLeaqe.right();
                    break;
                }
                case 8: {
                    if (this.m.isVisible()) {
                        this.m.select();
                        break;
                    }
                    if (this.mOpt.isVisible()) {
                        this.mOpt.select();
                        break;
                    }
                    if (!this.mLeaqe.isVisible()) break;
                    this.mLeaqe.select();
                }
            }
            this.repaint();
        } else if (this.state == 2) {
            switch (action) {
                case 2: {
                    this.mGame.left();
                    break;
                }
                case 5: {
                    this.mGame.right();
                    break;
                }
                case 8: {
                    this.mGame.select();
                }
            }
            this.repaint();
        } else if (this.state == 8) {
            if (keyCode == -7 && this.ab.getText().length() > 0) {
                Dribbler.sl.add(new Score(this.score, this.ab.getText(), Dribbler.location));
                Dribbler.setUser(this.ab.getText());
                this.removePauseButton();
                this.exchange("/titel.png", 5);
                this.spieler = new Spieler(68, 109);
                ConfigSound.startTitel();
            } else {
                switch (action) {
                    case 1: {
                        this.ab.up();
                        break;
                    }
                    case 6: {
                        this.ab.down();
                        break;
                    }
                    case 2: {
                        this.ab.left();
                        break;
                    }
                    case 5: {
                        this.ab.right();
                        break;
                    }
                    case 8: {
                        this.ab.select();
                    }
                }
            }
            this.repaint();
        } else if (this.state == 7) {
            switch (action) {
                case 1: {
                    Dribbler.slm.up();
                    break;
                }
                case 6: {
                    Dribbler.slm.down();
                    break;
                }
                default: {
                    this.stopThread();
                    this.st.reset();
                    this.exchange("/titel.png", 5);
                    this.repaint();
                }
            }
            this.repaint();
        } else if (this.state == 10) {
            switch (action) {
                case 1: {
                    Dribbler.gslm.up();
                    break;
                }
                case 6: {
                    Dribbler.gslm.down();
                    break;
                }
                case 8: {
                    this.exchange("/titel.png", 5);
                    ConfigSound.startTitel();
                    this.mLeaqe.setVisible(true);
                }
            }
            this.repaint();
        } else if (this.state == 9 || this.state == 14) {
            Dribbler.gslm.stop();
            this.repaint();
            this.serviceRepaints();
            this.state = 13;
        } else if (this.state == 13 || this.state == 15 || this.state == 12) {
            this.exchange("/titel.png", 5);
            this.mLeaqe.setVisible(true);
            ConfigSound.startTitel();
            this.repaint();
        } else if (this.state == 6 || this.state == 19) {
            this.stopThread();
            this.scrollFinished(null);
        }
    }

    private void gameEnd() {
        this.stopThread();
        Displayable.panel.fi.largeImage = null;
        this.rank = Dribbler.sl.inList(Displayable.number.value);
        this.state = 18;
        this.repaint();
        this.serviceRepaints();
        if (this.rank != -1) {
            this.spieler = null;
            this.exchange("/help.png", 8);
            this.score = Displayable.number.value;
            this.ab.setText(Dribbler.user);
            ConfigSound.soundJingle();
            this.addPauseButton("OK");
            this.startThread();
        } else {
            this.exchange("/titel.png", 5);
            ConfigSound.startTitel();
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        long paintStart = System.currentTimeMillis();
        g = super.paintBegin(g);
        g.setClip(0, 0, 176, 208);
        if (this.state == 5) {
            g.drawImage(mainImage, 0, 0, 20);
            if (this.m.isVisible()) {
                this.m.paint(g);
            } else if (this.mOpt.isVisible()) {
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)0, (int)0, (int)8));
                g.drawString("Options", 88, 19, 33);
                this.mOpt.paint(g);
            } else if (this.mLeaqe.isVisible()) {
                g.setColor(0xFFFFFF);
                g.setFont(Font.getFont((int)0, (int)0, (int)8));
                g.drawString("Leaque", 88, 19, 33);
                this.mLeaqe.paint(g);
            }
        } else if (this.state == 22) {
            g.drawImage(mainImage, 0, 0, 20);
        } else if (this.state == 18) {
            g.drawImage(mainImage, 0, 0, 20);
            g.setFont(Config.HEAD_FONT);
            g.setColor(0xFFFFFF);
            if (this.nextState == 1 || this.nextState == 9 || this.nextState == 7 || this.nextState == 14 || this.nextState == 6 || this.nextState == 19) {
                g.drawString("Loading..", 88, 21, 17);
            } else {
                g.drawString("Loading..", 88, 27, 33);
            }
        } else if (this.state == 20 || this.state == 21) {
            g.drawImage(mainImage, 0, 0, 20);
            g.setFont(Config.HEAD_FONT);
            g.setColor(0xFFFFFF);
            g.drawString("Send2Friend", 88, 29, 33);
            if (this.msg != null) {
                g.drawString(this.msg, 88, 104, 17);
            }
        } else if (this.state == 15 || this.state == 14 || this.state == 13 || this.state == 9) {
            g.drawImage(mainImage, 0, 0, 20);
            g.setFont(Config.HEAD_FONT);
            g.setColor(0xFFFFFF);
            if (globalType == GlobalScoreListManager.GET) {
                g.drawString("Global Leaque", 88, 27, 33);
            } else if (globalType == GlobalScoreListManager.GET_LAST) {
                g.drawString("Last Scores", 88, 27, 33);
            } else if (globalType == GlobalScoreListManager.GET_TODAY) {
                g.drawString("Today Scores", 88, 27, 33);
            } else if (globalType == GlobalScoreListManager.SUBMIT) {
                g.drawString("Submit Score", 88, 27, 33);
            }
            g.setFont(Config.SCORE_FONT);
            ball.next();
            if (this.msg != null) {
                g.drawString(this.msg, 88, 104, 17);
            }
            if (this.percent > 0 && this.percent < 100) {
                g.drawString(this.percent + "%", 88, 104 + g.getFont().getHeight(), 17);
            }
            ball.paint(g, 79, 68);
        } else if (this.state == 12) {
            g.drawImage(mainImage, 0, 0, 20);
            g.setColor(0xFFFFFF);
            g.setFont(Config.HEAD_FONT);
            g.drawString("Submit Score", 88, 29, 33);
            g.setFont(Config.SCORE_FONT);
            g.drawString("You take Place ", 88, 104 - g.getFont().getHeight(), 17);
            MenuItem.Text3D(g, Integer.toString(this.rank), 88, 104, 0xFFFFFF, 17);
        } else if (this.state == 6 || this.state == 19) {
            g.drawImage(mainImage, 0, 0, 20);
            g.setColor(0xFFFFFF);
            g.setFont(Config.HEAD_FONT);
            if (this.state == 6) {
                g.drawString("How to play", 88, 27, 33);
            } else {
                g.drawString("About", 88, 29, 33);
            }
            g.setClip(0, 29, 176, 179);
            g.setFont(Config.HELP_FONT);
            this.st.paint(g);
        } else if (this.state == 7) {
            Dribbler.slm.paint(g);
        } else if (this.state == 10) {
            Dribbler.gslm.paint(g);
        } else if (this.state == 8) {
            g.drawImage(mainImage, 0, 0, 20);
            g.setColor(0xFFFFFF);
            g.setFont(Config.HEAD_FONT);
            g.drawString("You take Place " + this.rank, 88, 27, 33);
            g.setColor(0xFFFFFF);
            g.setFont(Config.HELP_FONT);
            g.drawString("Enter Name", 88, 29 + g.getFont().getHeight(), 17);
            g.setFont(Font.getFont((int)32, (int)1, (int)16));
            g.drawString(this.ab.getText() + "_", 88, 29 + 2 * Config.HELP_FONT.getHeight(), 17);
            g.setFont(Font.getFont((int)32, (int)1, (int)8));
            this.ab.paint(g);
            if (!super.hasPauseButton()) {
                g.drawString("OK", 175, 207, 40);
            }
        } else if (this.state == 16) {
            g.drawImage(mainImage, 0, 0, 20);
            if (this.nextState != 5 && this.nextState != 17) {
                this.spieler.paint(g);
            }
            this.w.paint(g);
        } else if (this.state == 2) {
            g.drawImage(mainImage, 0, 0, 20);
            this.spieler.paint(g);
            this.w.paint(g);
            g.setColor(0xFF0000);
            g.setFont(Config.MENU_FONT);
            g.drawString("Paused", 88, 0, 17);
            this.mGame.paint(g);
        } else {
            if (!fullRepaint) {
                g.setClip(0, 24, 176, 184);
            }
            g.drawImage(mainImage, 0, 0, 20);
            if (fullRepaint) {
                g.setClip(0, 0, 176, 208);
                number.paint(g, 1, 1);
                kPanel.paint(g);
                int x = 176;
                int i = 0;
                while (i <= this.balls) {
                    Ball.ballImage.paint(g, x, 0, 0, 0, 18, 18);
                    x = x - 18 - 1;
                    ++i;
                }
                fullRepaint = false;
            }
            this.spieler.paint(g);
            if (this.state == 3) {
                panel.paint(g, 88, 29);
                panel.next();
            } else if (this.state != 4 && this.state == 1) {
                if (Displayable.panel.type == 2) {
                    panel.paint(g, 88, 29);
                    panel.next();
                }
                ball.paint(g);
            }
        }
        super.paintEnde(g);
        this.paintTime = System.currentTimeMillis() - paintStart;
    }

    public void disappear(Ball b) {
        block2: {
            fullRepaint = true;
            --this.balls;
            ConfigSound.soundLostBall();
            b.reset();
            kPanel.next();
            if (this.balls > 0) break block2;
            this.repaint();
            this.serviceRepaints();
            this.state = 3;
            try {
                panel.set(Image.createImage((String)"/gameover.png"), 0);
            }
            catch (IOException iox) {}
        }
    }

    public void select(MenuItem mi) {
        if (mi == this.start) {
            ConfigSound.stopTitel();
            this.exchange("/bg.png", 1);
            this.newGame();
        } else if (mi == this.about) {
            FormatString fs = new FormatString("JugglingChamp \ndeveloped 2006\nby\nTinySolutions\n \nGraphics\nby\nWolff & Neitzke", Config.HELP_FONT, 0, 29, 176, 179);
            this.st.text = fs.txt;
            this.spieler = null;
            this.exchange("/help.png", 19);
            this.st.reset();
            this.startThread();
        } else if (mi == this.help) {
            FormatString fs = new FormatString("Move left (4) right (6) jump with up(2) or kick with fire (5).\nJust try as long as you can to keep one of your three balls in the air. You score by every kick and a good combination.\n\n If you got a new topscore you are able to enter your name into the high score list", Config.HELP_FONT, 0, 29, 176, 179);
            this.st.text = fs.txt;
            this.spieler = null;
            this.exchange("/help.png", 6);
            this.st.reset();
            this.startThread();
        } else if (mi == this.send2friend) {
            ConfigSound.stopTitel();
            NumberDisplayable nd = new NumberDisplayable();
            Dribbler.display.setCurrent((javax.microedition.lcdui.Displayable)nd);
        } else if (mi == this.globalScores) {
            this.exchange("/help.png", 9);
            this.mLeaqe.setVisible(false);
            ConfigSound.stopTitel();
            globalType = GlobalScoreListManager.GET;
            Dribbler.gslm.get("Tengel", 10);
        } else if (mi == this.todayScores) {
            this.exchange("/help.png", 9);
            this.mLeaqe.setVisible(false);
            ConfigSound.stopTitel();
            globalType = GlobalScoreListManager.GET_TODAY;
            Dribbler.gslm.getToday("Tengel", 10);
        } else if (mi == this.lastScores) {
            this.exchange("/help.png", 9);
            this.mLeaqe.setVisible(false);
            globalType = GlobalScoreListManager.GET_LAST;
            ConfigSound.stopTitel();
            Dribbler.gslm.getLast("Tengel", 10);
        } else if (mi == this.submitScore) {
            this.exchange("/help.png", 14);
            this.mLeaqe.setVisible(false);
            globalType = GlobalScoreListManager.SUBMIT;
            ConfigSound.stopTitel();
            Dribbler.gslm.submit("Tengel");
        } else if (mi == this.leaque) {
            this.m.setVisible(false);
            this.mLeaqe.setVisible(true);
            this.mLeaqe.setSelectedItem(0);
        } else if (mi == this.opt) {
            this.m.setVisible(false);
            this.mOpt.setVisible(true);
            this.mOpt.setSelectedItem(0);
        } else if (mi == this.soundItem) {
            boolean bl = soundOption = !soundOption;
            if (soundOption) {
                this.soundItem.text = "Sound ON ";
                ConfigSound.startTitel();
            } else {
                this.soundItem.text = "Sound OFF";
                ConfigSound.stopTitel();
            }
        } else if (mi == this.back) {
            this.m.setVisible(true);
            this.mLeaqe.setVisible(false);
            this.mOpt.setVisible(false);
        } else if (mi == this.localScores) {
            this.exchange("/help.png", 7);
        } else if (mi == this.exit) {
            Dribbler.quitApp();
        } else if (mi == this.cont) {
            this.w.move2State(2);
            this.state = 16;
            this.nextState = 1;
            this.addPauseButton("Pause");
        } else if (mi == this.mexit) {
            this.state = 16;
            this.nextState = 17;
            this.w.move2State(2);
        }
    }

    public void startSend2Friend(String num) {
        this.m.setVisible(false);
        this.exchange("/help.png", 20);
        this.send2FriendServer.send(num, ConfigGeneric.GAME_CODE);
    }

    private void exchange(String n, int ns) {
        this.nextState = ns;
        this.stopThread();
        this.state = 18;
        this.repaint();
        this.serviceRepaints();
        mainImage = null;
        Config.gc();
        try {
            mainImage = Image.createImage((String)n);
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        this.state = ns;
    }

    public void scrollFinished(ScrollText t) {
        this.exchange("/titel.png", 5);
        this.repaint();
    }

    public void setPercent(int i) {
        this.percent = i;
        if (this.percent % 5 == 0) {
            this.repaint();
        }
    }

    public void globalList(ScoreList sl, int type) {
        if (sl != null) {
            Dribbler.gslm.setScoreListe(sl);
            this.state = 10;
            globalType = type;
            ConfigSound.soundJingle();
        } else {
            this.state = 13;
            ConfigSound.soundError();
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void submitFinished(int r) {
        if (r != -1) {
            this.state = 12;
            this.rank = r;
            this.repaint();
            this.serviceRepaints();
            ConfigSound.soundJingle();
        } else {
            try {
                Score s = (Score)Dribbler.sl.scoreVector.firstElement();
                if (!s.sync) {
                    this.msg = "Failed";
                }
            }
            catch (NoSuchElementException nus) {
                this.msg = "List Empty";
            }
            this.state = 15;
            this.repaint();
            this.serviceRepaints();
            ConfigSound.soundError();
        }
    }

    public void globalMessage(String s) {
        this.msg = s;
        this.repaint();
        this.serviceRepaints();
    }

    public void panelFinished(int type) {
        if (type == 0) {
            this.state = 3;
        } else if (type == 1) {
            this.state = 4;
            panel.setType(3);
            this.gameEnd();
        } else if (type == 2) {
            panel.setType(3);
        }
    }

    public void windowClosed() {
        if (this.nextState == 17) {
            this.gameEnd();
            this.repaint();
            this.serviceRepaints();
        } else if (this.nextState == 5) {
            ConfigSound.startTitel();
            this.exchange("/titel.png", 5);
            this.state = this.nextState;
            this.repaint();
            this.serviceRepaints();
        } else {
            fullRepaint = true;
            this.state = this.nextState;
        }
    }

    public void windowOpened() {
        this.state = this.nextState;
    }

    public void send2FriendMessage(String s) {
        this.msg = s;
        this.repaint();
    }

    public void send2FriendFinished(boolean b) {
        this.state = 21;
        if (!b) {
            ConfigSound.soundError();
        } else {
            this.msg = "OK";
            ConfigSound.soundJingle();
        }
        this.repaint();
    }

    static {
        fullRepaint = true;
    }
}

