/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.ScrollTextListener;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class ScrollText {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public String[] text;
    public int speed = 1;
    private int width;
    private int height;
    public int direction;
    private ScrollTextListener listener;
    public int y;
    private int ymax;
    Font font;

    public ScrollText(String[] t, int w, int h, int d) {
        this.init(t, w, h, d);
        this.ymax = this.text.length * (Font.getDefaultFont().getHeight() + 2);
        this.font = Font.getDefaultFont();
    }

    public ScrollText(String[] t, int w, int h, int d, Font f) {
        this.init(t, w, h, d);
        this.font = f;
        this.ymax = this.text.length * (f.getDefaultFont().getHeight() + 2);
    }

    private void init(String[] t, int w, int h, int d) {
        this.text = t;
        this.width = w;
        this.height = h;
        this.direction = d;
        this.y = d == 1 ? h : -this.text.length * Font.getDefaultFont().getHeight();
    }

    public void setText(String[] t) {
        this.text = t;
        this.ymax = this.text.length * (this.font.getHeight() + 2);
    }

    public void reset() {
        this.y = this.direction == 1 ? this.height : -this.text.length * Font.getDefaultFont().getHeight();
    }

    public void setListener(ScrollTextListener l) {
        this.listener = l;
    }

    public void paint(Graphics g) {
        int starty = this.y + g.getClipY();
        int i = 0;
        while (i < this.text.length) {
            if (starty > g.getClipY() - g.getFont().getHeight()) {
                g.drawString(this.text[i], this.width / 2 + g.getClipX(), starty, 17);
            }
            if ((starty = starty + g.getFont().getHeight() + 2) > g.getClipY() + g.getClipHeight()) break;
            ++i;
        }
        if (this.direction == 1) {
            if (this.y < -this.ymax && this.listener != null) {
                this.listener.scrollFinished(this);
            } else {
                this.y -= this.speed;
            }
        } else if (this.y > 0 && this.listener != null) {
            this.listener.scrollFinished(this);
        } else {
            this.y += this.speed;
        }
    }
}

