/*
 * Decompiled with CFR 0.152.
 */
package dribbler;

import dribbler.ConfigPlayerLarge;
import dribbler.Displayable;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class ConfigSound
extends ConfigPlayerLarge {
    static Player greatPlayer;
    static Player lostPlayer;
    static Player wallPlayer;
    static Player kickPlayer;
    static Player errorPlayer;
    static Player jinglePlayer;
    static Player titelPlayer;

    public ConfigSound() {
        greatPlayer = this.createSound("/great.amr", "audio/amr", 1);
        lostPlayer = this.createSound("/lost.mid", "audio/midi", 1);
        wallPlayer = this.createSound("/ground.mid", "audio/midi", 1);
        kickPlayer = this.createSound("/kick.amr", "audio/amr", 1);
        errorPlayer = this.createSound("/error.mid", "audio/midi", 1);
        jinglePlayer = this.createSound("/displayscore.mid", "audio/midi", 1);
        titelPlayer = this.createSound("/titel.mid", "audio/midi", 100);
        try {
            greatPlayer.prefetch();
            lostPlayer.prefetch();
            wallPlayer.prefetch();
            kickPlayer.prefetch();
        }
        catch (MediaException mex) {
            mex.printStackTrace();
        }
    }

    public static void soundGreat() {
        ConfigSound.playSound(greatPlayer);
    }

    public static void soundLostBall() {
        ConfigSound.playSound(lostPlayer);
    }

    public static void soundWall() {
        ConfigSound.playSound(wallPlayer);
    }

    public static void soundKick() {
        ConfigSound.playSound(kickPlayer);
    }

    public static void soundError() {
        ConfigSound.playSound(errorPlayer);
    }

    public static void soundJingle() {
        ConfigSound.playSound(jinglePlayer);
    }

    public static void startTitel() {
        ConfigSound.playSound(titelPlayer);
    }

    public static void stopTitel() {
        try {
            titelPlayer.stop();
        }
        catch (MediaException mex) {}
    }

    private Player createSound(String name, String type, int loop) {
        try {
            InputStream stream = this.getClass().getResourceAsStream(name);
            Player player = Manager.createPlayer((InputStream)stream, (String)type);
            player.setLoopCount(loop);
            return player;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("name=" + name + " type=" + type);
            return null;
        }
    }

    private static void playSound(Player sound) {
        if (sound == null || !Displayable.soundOption) {
            return;
        }
        try {
            sound.start();
        }
        catch (MediaException e) {
            e.printStackTrace();
            return;
        }
    }
}

