/*
 * Decompiled with CFR 0.152.
 */
package dribbler;

import de.tuttas.GameAPI.AnimatedFragment;
import de.tuttas.GameAPI.AnimatedFragmentListener;
import de.tuttas.GameAPI.Winkel;
import dribbler.Ball;
import dribbler.Displayable;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Spieler
implements AnimatedFragmentListener {
    public static Random random = new Random();
    public final int MOVE;
    public final int STILL;
    public final int KICK_FEET_LEFT;
    public final int KICK_FEET_RIGHT;
    public final int KICK_KNEE_LEFT;
    public final int KICK_KNEE_RIGHT;
    public final int KICK_HEAD;
    int state;
    public static final int ANIMATIONDELAY = 2;
    int delay = 2;
    int dx;
    int moveWidth;
    AnimatedFragment moveImage;
    AnimatedFragment kickLeftImage;
    AnimatedFragment kickRightImage;
    AnimatedFragment kneeLeftImage;
    AnimatedFragment kneeRightImage;
    AnimatedFragment headImage;
    Image stillImage;
    int xPos;
    int yPos;
    int jumpPhi = 30;

    public Spieler(int x, int y) {
        this.MOVE = 1;
        this.STILL = 2;
        this.KICK_FEET_LEFT = 3;
        this.KICK_FEET_RIGHT = 4;
        this.KICK_KNEE_LEFT = 5;
        this.KICK_KNEE_RIGHT = 6;
        this.KICK_HEAD = 7;
        try {
            Image i = Image.createImage((String)"/player.png");
            this.moveImage = new AnimatedFragment(i, 41, 1, 1, x, y);
            i = Image.createImage((String)"/kick_left.png");
            this.kickLeftImage = new AnimatedFragment(i, 41, 3, 1, x, y);
            i = Image.createImage((String)"/kick_right.png");
            this.kickRightImage = new AnimatedFragment(i, 41, 3, 1, x, y);
            i = Image.createImage((String)"/kick_left_knee.png");
            this.kneeLeftImage = new AnimatedFragment(i, 41, 3, 1, x, y);
            i = Image.createImage((String)"/kick_right_knee.png");
            this.kneeRightImage = new AnimatedFragment(i, 41, 3, 1, x, y);
            i = Image.createImage((String)"/head.png");
            this.headImage = new AnimatedFragment(i, 41, 3, 1, x, y);
            this.stillImage = Image.createImage((String)"/still.png");
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        this.moveImage.setListener(this);
        this.kneeRightImage.setListener(this);
        this.kickRightImage.setListener(this);
        this.kickLeftImage.setListener(this);
        this.kneeLeftImage.setListener(this);
        this.headImage.setListener(this);
        this.reset(x, y);
    }

    public void reset(int x, int y) {
        this.xPos = x;
        this.yPos = y;
        this.state = 2;
        this.jumpPhi = 0;
    }

    public void paint(Graphics g) {
        if (this.state == 2) {
            g.drawImage(this.stillImage, this.xPos, this.yPos, 20);
        } else if (this.state == 1) {
            this.moveImage.xPos = this.xPos;
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 2;
                this.moveImage.next();
            }
            this.moveImage.paint(g);
            this.xPos -= this.moveWidth;
            if (this.xPos < 0) {
                this.xPos = 0;
                this.stop();
                this.state = 2;
            }
            if (this.xPos > 167) {
                this.xPos = 167;
                this.stop();
                this.state = 2;
            }
        } else if (this.state == 3) {
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 2;
                this.kickLeftImage.next();
            }
            if (this.kickLeftImage.actualDir == 3 && this.kickLeftImage.counter == 2) {
                this.testBall(Displayable.ball, 3);
            }
            this.kickLeftImage.xPos = this.xPos;
            this.kickLeftImage.paint(g);
        } else if (this.state == 4) {
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 2;
                this.kickRightImage.next();
            }
            if (this.kickRightImage.actualDir == 3 && this.kickRightImage.counter == 2) {
                this.testBall(Displayable.ball, 4);
            }
            this.kickRightImage.xPos = this.xPos;
            this.kickRightImage.paint(g);
        } else if (this.state == 6) {
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 2;
                this.kneeRightImage.next();
            }
            if (this.kneeRightImage.actualDir == 3 && this.kneeRightImage.counter == 2) {
                this.testBall(Displayable.ball, 6);
            }
            this.kneeRightImage.xPos = this.xPos;
            this.kneeRightImage.paint(g);
        } else if (this.state == 5) {
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 2;
                this.kneeLeftImage.next();
            }
            if (this.kneeLeftImage.actualDir == 3 && this.kneeLeftImage.counter == 2) {
                this.testBall(Displayable.ball, 5);
            }
            this.kneeLeftImage.xPos = this.xPos;
            this.kneeLeftImage.paint(g);
        } else if (this.state == 7) {
            --this.delay;
            if (this.delay <= 0) {
                this.delay = 2;
                this.headImage.next();
                this.jumpPhi += 30;
                if (this.jumpPhi > 180) {
                    this.jumpPhi = 180;
                }
            }
            if (this.jumpPhi <= 90) {
                this.testBall(Displayable.ball, 7);
            }
            this.headImage.xPos = this.xPos;
            this.headImage.yPos = this.yPos = 105 - 5 * Winkel.sin(this.jumpPhi) / 1000;
            this.headImage.paint(g);
        }
    }

    public void disappear(AnimatedFragment af) {
    }

    public void animationFinished(AnimatedFragment af) {
        if (this.moveWidth == 0) {
            this.state = 2;
        } else {
            af.reset();
        }
        this.jumpPhi = 30;
    }

    public void left(int d) {
        if (this.state == 2) {
            this.state = 1;
            this.moveWidth = d;
        }
    }

    public void right(int d) {
        if (this.state == 2) {
            this.state = 1;
            this.moveWidth = -d;
        }
    }

    public static void hold(long l) {
    }

    private void testBall(Ball b, int s) {
        int k2;
        int by = b.yPos + 9;
        int bx = b.xPos + 9;
        if (b.getDy() > 0 && s == 7 && b.yPos + 18 > this.yPos && b.yPos < this.yPos && bx > this.xPos + 10 && bx < this.xPos + 32) {
            int k2 = this.kickBall(b, s, s);
            if (k2 != 0) {
                b.bounce(k2, Displayable.nextScore, 2);
                Spieler.hold(3000L);
            }
        } else if (b.getDy() >= 0 && by >= 50 + this.yPos - 9 && by < 50 + this.yPos + 9) {
            int k2;
            if ((s == 5 || s == 6) && (k2 = this.kickBall(b, s, s)) != 0) {
                b.bounce(k2, Displayable.nextScore, 1);
                Spieler.hold(3000L);
            }
        } else if (b.getDy() > 0 && by >= 69 + this.yPos - 9 && by <= 69 + this.yPos + 9 && (s == 3 || s == 4) && (k2 = this.kickBall(b, s, s)) != 0) {
            b.bounce(k2, Displayable.nextScore, 0);
            Spieler.hold(3000L);
        }
    }

    public void jump(Ball b) {
        if (this.state == 2) {
            this.state = 7;
            this.headImage.reset();
            this.jumpPhi = 30;
        }
    }

    public void kick(Ball b) {
        int bx = b.xPos + 9;
        int by = b.yPos + 9;
        if (this.state == 2) {
            this.delay = 2;
            this.moveWidth = 0;
            if (b.getDy() > 0 && by >= 27 + this.yPos && by <= 48 + this.yPos) {
                int k = this.kickBall(b, 5, 6);
                if (k != 0) {
                    this.kneeLeftImage.reset();
                    this.kneeRightImage.reset();
                }
            } else if (b.getDy() > 0 && by >= 48 + this.yPos) {
                int k = this.kickBall(b, 3, 4);
                if (k != 0) {
                    this.kickRightImage.reset();
                    this.kickLeftImage.reset();
                }
            } else {
                int k = (random.nextInt() >>> 1) % 3;
                if (k == 1) {
                    this.kickRightImage.reset();
                    this.kickLeftImage.reset();
                    this.kickBall(b, 3, 4);
                } else {
                    this.kneeLeftImage.reset();
                    this.kneeRightImage.reset();
                    this.kickBall(b, 5, 6);
                }
            }
        }
    }

    private int kickBall(Ball b, int sl, int sr) {
        if (b.xPos + 9 < this.xPos + 20) {
            this.state = sl;
            if (b.xPos + 18 > this.xPos) {
                this.dx = this.xPos + 20 - (b.xPos + 9);
                this.dx *= 2;
                if (this.dx == 0) {
                    this.dx = -1;
                }
                return -this.dx;
            }
        } else {
            this.state = sr;
            if (b.xPos < this.xPos + 41) {
                this.dx = this.xPos + 20 - (b.xPos + 9);
                this.dx *= 2;
                if (this.dx == 0) {
                    this.dx = 1;
                }
                return -this.dx;
            }
        }
        return 0;
    }

    public void stop() {
        this.moveWidth = 0;
        if (this.state == 1) {
            this.state = 2;
        }
        this.moveImage.reset();
    }
}

