/*
 * Decompiled with CFR 0.152.
 */
package dribbler;

import javax.microedition.lcdui.Graphics;

public class AlphaBoard {
    private int xPos;
    private int yPos;
    private int width;
    private int height;
    private int pointer;
    private int columns;
    private int rows;
    private int elementWidth;
    private int elementHeight;
    private String text = "empty";
    private String[] letters = new String[]{"<", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", " ", "."};

    public AlphaBoard(int x, int y, int c, int r, int w, int h) {
        this.xPos = x;
        this.yPos = y;
        this.columns = c;
        this.rows = r;
        this.elementWidth = w;
        this.elementHeight = h;
        this.width = c * w;
        this.height = r * h;
        this.pointer = 0;
    }

    public void setText(String s) {
        this.text = s;
    }

    public String getText() {
        return this.text;
    }

    public void up() {
        if (this.pointer >= this.columns) {
            this.pointer -= this.columns;
        }
    }

    public void down() {
        this.pointer += this.columns;
        if (this.pointer > this.columns * this.rows) {
            this.pointer -= this.columns * this.rows;
        }
        try {
            String s = this.letters[this.pointer];
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.pointer %= this.columns;
        }
    }

    public void left() {
        --this.pointer;
        if (this.pointer < 0) {
            this.pointer = this.letters.length - 1;
        }
    }

    public void right() {
        ++this.pointer;
        if (this.pointer >= this.letters.length) {
            this.pointer = 0;
        }
    }

    public void select() {
        if (this.letters[this.pointer] == "<") {
            if (this.text.length() > 0) {
                this.text = this.text.substring(0, this.text.length() - 1);
            }
        } else if (this.text.length() <= 8) {
            this.text = this.text + this.letters[this.pointer];
        }
    }

    public void paint(Graphics g) {
        int p = 0;
        try {
            int y = this.yPos;
            while (y < this.yPos + this.height) {
                int x = this.xPos;
                while (x < this.xPos + this.width) {
                    g.drawString(this.letters[p], x + this.elementWidth / 2, y, 17);
                    if (p == this.pointer) {
                        int oc = g.getColor();
                        g.setColor(0xFF0000);
                        g.drawRect(x - 1, y - 1, this.elementWidth, this.elementHeight);
                        g.setColor(oc);
                    }
                    ++p;
                    x += this.elementWidth;
                }
                y += this.elementHeight;
            }
        }
        catch (ArrayIndexOutOfBoundsException aob) {}
    }
}

