/*
 * Decompiled with CFR 0.152.
 */
package dribbler;

import de.tuttas.GameAPI.Score.Score;
import de.tuttas.GameAPI.Score.ScoreList;
import de.tuttas.GameAPI.Score.ScoreListManager;
import dribbler.Config;
import dribbler.Displayable;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MyScoreListManager
extends ScoreListManager {
    private boolean toggle = false;
    public static int color1 = 0x80FF80;
    public static int color2 = 16439392;
    static Image upImage;
    static Image downImage;

    public MyScoreListManager(ScoreList sl) {
        super(sl);
        try {
            upImage = Image.createImage((String)"/up.png");
            downImage = Image.createImage((String)"/down.png");
        }
        catch (IOException iox) {}
    }

    public void paint(Graphics g) {
        g.drawImage(Displayable.mainImage, 0, 0, 20);
        g.setFont(Config.HEAD_FONT);
        g.setColor(0xFFFFFF);
        g.drawString("Local Leaque", 104, 27, 33);
        g.setFont(Config.SCORE_FONT);
        int i = MyScoreListManager.paintScoreList(g, 29, this.scores, this.startIndex);
        this.setLastIndex(i);
        if (this.allowDown()) {
            g.drawImage(downImage, 208, 109, 24);
        }
        if (this.allowUp()) {
            g.drawImage(upImage, 208, 99, 40);
        }
    }

    public boolean allowDown() {
        return this.lastIndex < 10;
    }

    public void up() {
        --this.startIndex;
        if (this.startIndex < 0) {
            this.startIndex = 0;
        }
    }

    public void down() {
        ++this.startIndex;
        if (this.lastIndex >= 10) {
            --this.startIndex;
        }
    }

    public static int paintScoreList(Graphics g, int y, ScoreList scores, int startIndex) {
        int i = 0;
        boolean toggle = false;
        i = 0;
        while (i < startIndex) {
            toggle = !toggle;
            ++i;
        }
        int wrank = g.getFont().stringWidth("ran");
        String scoreString = "00000";
        int w = Displayable.number.width * 6;
        i = startIndex;
        while (i < 10) {
            Score tmpScore;
            try {
                tmpScore = (Score)scores.scoreVector.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException aob) {
                tmpScore = null;
            }
            if (toggle) {
                g.setColor(color1);
            } else {
                g.setColor(color2);
            }
            toggle = !toggle;
            int x = g.getFont().stringWidth(scoreString + "000");
            if (tmpScore == null) {
                g.drawString("------", wrank, y + 1, 20);
                g.drawString("-.-", x + wrank, y + 1, 20);
            } else {
                String s = Long.toString(tmpScore.value);
                if (tmpScore.rank == -1) {
                    g.drawString(Integer.toString(i + 1), 0, y + 1, 20);
                } else {
                    g.drawString(Integer.toString(tmpScore.rank), 0, y + 1, 20);
                }
                g.drawString(scoreString.substring(0, 5 - s.length()) + s, wrank, y + 1, 20);
                if (tmpScore.sync) {
                    g.drawString(tmpScore.name + " *", x + wrank, y + 1, 20);
                } else {
                    g.drawString(tmpScore.name, x + wrank, y + 1, 20);
                }
            }
            if (y > g.getClipHeight() - g.getFont().getHeight()) {
                --i;
                break;
            }
            y = y + g.getFont().getHeight() + 2;
            ++i;
        }
        return i;
    }

    public void setLastIndex(int i) {
        this.lastIndex = i;
    }
}

