/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI;

import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Menu {
    private Vector items;
    public MenuItem selectedItem;
    public int index;
    private int yOffset;
    public MenuListener listener;
    private boolean visible;
    public int MenuStart;
    public static Image left = null;
    public static Image right = null;

    public Menu(int offsetY, int start) {
        this.items = new Vector();
        this.visible = false;
        this.yOffset = offsetY;
        this.MenuStart = start;
    }

    public Menu(int yPos) {
        block2: {
            this.items = new Vector();
            this.visible = false;
            this.MenuStart = yPos;
            this.yOffset = -1;
            if (left != null) break block2;
            try {
                left = Image.createImage((String)"/de/tuttas/GameAPI/left.png");
                right = Image.createImage((String)"/de/tuttas/GameAPI/right.png");
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        }
    }

    public void setListener(MenuListener ml) {
        this.listener = ml;
    }

    public void add(MenuItem mi) {
        if (this.items.size() == 0) {
            this.selectedItem = mi;
            mi.setSelect(true);
        }
        this.items.addElement(mi);
    }

    public void remove(MenuItem mi) {
        this.items.removeElement(mi);
    }

    public void select() {
        this.listener.select(this.selectedItem);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void up() {
        try {
            this.selectedItem.setSelect(false);
            this.selectedItem = (MenuItem)this.items.elementAt(this.index - 1);
            --this.index;
            this.selectedItem.setSelect(true);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.selectedItem.setSelect(true);
        }
    }

    public void down() {
        try {
            this.selectedItem.setSelect(false);
            this.selectedItem = (MenuItem)this.items.elementAt(this.index + 1);
            ++this.index;
            this.selectedItem.setSelect(true);
        }
        catch (ArrayIndexOutOfBoundsException aob) {
            this.selectedItem.setSelect(true);
        }
    }

    public void left() {
        this.up();
    }

    public void right() {
        this.down();
    }

    public MenuItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(MenuItem mi) {
        if (this.selectedItem != null) {
            this.selectedItem.setSelect(false);
        }
        this.selectedItem = mi;
        mi.isSelected = true;
        this.index = this.items.indexOf(mi);
    }

    public void setSelectedItem(int i) {
        if (this.selectedItem != null) {
            this.selectedItem.setSelect(false);
        }
        this.selectedItem = (MenuItem)this.items.elementAt(i);
        this.selectedItem.isSelected = true;
        this.index = i;
    }

    public void paint(Graphics g, int x) {
        int y = this.MenuStart;
        int h = g.getFont().getHeight();
        if (this.yOffset != -1) {
            int i = 0;
            while (i < this.items.size()) {
                MenuItem tmpItem = (MenuItem)this.items.elementAt(i);
                tmpItem.paint(g, x, y);
                y += this.yOffset;
                ++i;
            }
        } else {
            int width = MenuItem.width;
            if (this.selectedItem != (MenuItem)this.items.firstElement()) {
                g.drawImage(left, x - MenuItem.width / 2 - 2, y + h / 2, 10);
            }
            if (this.selectedItem != (MenuItem)this.items.lastElement()) {
                g.drawImage(right, x + MenuItem.width / 2 + 2, y + h / 2, 6);
            }
            this.selectedItem.paint(g, x, y);
        }
    }

    public void paint(Graphics g) {
        this.paint(g, g.getClipWidth() / 2);
    }
}

