/*
 * Decompiled with CFR 0.152.
 */
package de.tuttas.GameAPI.Score;

import de.tuttas.GameAPI.Score.GlobalListListener;
import de.tuttas.GameAPI.Score.Score;
import de.tuttas.GameAPI.Score.ScoreList;
import de.tuttas.GameAPI.Score.ScoreListManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public abstract class GlobalScoreListManager
extends ScoreListManager
implements Runnable {
    public static int SUBMIT = 1;
    public static int GET = 2;
    public static int GET_TODAY = 3;
    public static int GET_LAST = 4;
    int state;
    public static String CONNECT = "Connect";
    public static String OPEN = "Open";
    public static String CLOSE = "Close";
    public static String ABBORT = "Abbort";
    public static String PARSING = "Parse";
    public static String FAILED = "Failed";
    public static String FINISHED = "Finished";
    public static String FORBIDDEN = "Forbidden";
    public static String LIST_EMPTY = "List Empty";
    public static String SCORE_USED = "TopScrore used";
    public static String RECEIVE = "Receive";
    String server;
    ScoreList scoreList;
    Thread runner;
    GlobalListListener listener;
    private boolean stop = false;
    String gameName;
    int numbers;
    String extension;

    public GlobalScoreListManager(ScoreList sl, String ip, String ext) {
        this.server = ip;
        this.scoreList = sl;
        this.extension = ext;
    }

    public void setListener(GlobalListListener l) {
        this.listener = l;
    }

    public void submit(String game) {
        this.gameName = game;
        this.state = SUBMIT;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void get(String name, int num) {
        this.gameName = name;
        this.numbers = num;
        this.state = GET;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.setPriority(1);
        this.runner.start();
    }

    public void getToday(String name, int num) {
        this.gameName = name;
        this.numbers = num;
        this.state = GET_TODAY;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void getLast(String name, int num) {
        this.gameName = name;
        this.numbers = num;
        this.state = GET_LAST;
        this.stop = false;
        this.runner = new Thread(this);
        this.runner.start();
    }

    public void stop() {
        this.stop = true;
        this.listener.globalMessage(ABBORT);
        this.listener.setPercent(100);
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            if (this.state == SUBMIT) {
                try {
                    Score tmpScore = (Score)this.scoreList.scoreVector.firstElement();
                    this.submitScore(tmpScore);
                }
                catch (NoSuchElementException ne) {
                    this.listener.globalMessage(LIST_EMPTY);
                    this.listener.submitFinished(-1);
                }
            } else if (this.state == GET) {
                this.getGlobal(this.numbers);
            } else if (this.state == GET_TODAY) {
                this.getToday(this.numbers);
            } else if (this.state == GET_LAST) {
                this.getLast(this.numbers);
            }
            this.runner = null;
        }
    }

    private void getToday(int num) {
        block3: {
            try {
                String s = this.getViaHttpConnection(this.server + "gettoday" + this.extension + ".php?game=" + this.gameName + "&num=" + num + "&type=plain");
                if (this.stop) {
                    this.listener.globalList(null, GET_TODAY);
                    break block3;
                }
                this.listener.globalMessage(PARSING);
                this.listener.globalList(this.parseString(s), GET_TODAY);
            }
            catch (IOException iox) {
                this.listener.globalMessage(FAILED);
                this.listener.globalList(null, -1);
            }
        }
    }

    private void getLast(int num) {
        block3: {
            try {
                String s = this.getViaHttpConnection(this.server + "getlast" + this.extension + ".php?game=" + this.gameName + "&num=" + num + "&type=plain");
                if (this.stop) {
                    this.listener.globalList(null, GET_LAST);
                    break block3;
                }
                this.listener.globalMessage(PARSING);
                this.listener.globalList(this.parseString(s), GET_LAST);
            }
            catch (IOException iox) {
                this.listener.globalMessage(FAILED);
                this.listener.globalList(null, -1);
            }
        }
    }

    private void getGlobal(int num) {
        block3: {
            try {
                String s = this.getViaHttpConnection(this.server + "get" + this.extension + ".php?game=" + this.gameName + "&num=" + num + "&type=plain");
                if (this.stop) {
                    this.listener.globalList(null, GET);
                    break block3;
                }
                this.listener.globalMessage(PARSING);
                this.listener.globalList(this.parseString(s), GET);
            }
            catch (IOException iox) {
                this.listener.globalMessage(FAILED);
                this.listener.globalList(null, -1);
            }
        }
    }

    private ScoreList parseString(String s) {
        if (s == null) {
            return null;
        }
        int lines = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\n') {
                ++lines;
            }
            ++i;
        }
        ScoreList sl = new ScoreList();
        this.listener.setPercent(0);
        int j = 0;
        while (s.indexOf("\n") != -1) {
            Score tmpScore = new Score(s.substring(0, s.indexOf("\n")));
            sl.scoreVector.addElement(tmpScore);
            if (this.stop) {
                return null;
            }
            s = s.substring(s.indexOf("\n") + 1);
            this.listener.setPercent(++j * 100 / lines);
        }
        this.listener.setPercent(100);
        this.listener.globalMessage(FINISHED);
        return sl;
    }

    private void submitScore(Score tmpScore) {
        if (!tmpScore.sync) {
            try {
                String g = "";
                g = tmpScore.location != null ? this.server + "add.php?game=" + this.gameName + "&name=" + GlobalScoreListManager.encode(tmpScore.name) + "&score=" + tmpScore.value + "&location=" + GlobalScoreListManager.encode(tmpScore.location) : this.server + "add.php?game=" + this.gameName + "&name=" + GlobalScoreListManager.encode(tmpScore.name) + "&score=" + tmpScore.value;
                String s = this.getViaHttpConnection(g);
                try {
                    int rank = Integer.parseInt(s);
                    this.listener.submitFinished(rank);
                    this.scoreList.use(tmpScore);
                }
                catch (IllegalArgumentException io) {
                    this.listener.globalMessage(s);
                    this.listener.submitFinished(-1);
                }
            }
            catch (IOException iox) {
                this.listener.globalMessage(FAILED);
                this.listener.submitFinished(-1);
            }
            catch (NoSuchElementException ne) {
                this.listener.globalMessage(LIST_EMPTY);
                this.listener.submitFinished(-1);
            }
        } else {
            this.listener.globalMessage(SCORE_USED);
            this.listener.submitFinished(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getViaHttpConnection(String url) throws IOException {
        StringBuffer sb;
        block14: {
            HttpConnection c = null;
            InputStream is = null;
            byte[] data = new byte[1];
            sb = new StringBuffer();
            try {
                this.listener.globalMessage(CONNECT);
                c = (HttpConnection)Connector.open((String)url);
                this.listener.globalMessage(OPEN);
                is = c.openInputStream();
                String type = c.getType();
                if (this.stop) {
                    String string = null;
                    return string;
                }
                this.listener.globalMessage(RECEIVE);
                this.listener.setPercent(0);
                int b = is.read();
                boolean p = false;
                int len = (int)c.getLength();
                if (len != -1) {
                    int i = 0;
                    while (i < len) {
                        sb.append((char)b);
                        if (this.stop) {
                            String string = null;
                            return string;
                        }
                        b = is.read();
                        this.listener.setPercent(i * 100 / len);
                        ++i;
                    }
                    this.listener.setPercent(100);
                    break block14;
                }
                this.listener.setPercent(100);
                this.listener.globalMessage("No Data");
                String string = null;
                return string;
            }
            catch (SecurityException se) {
                this.listener.globalMessage(FORBIDDEN);
                this.stop = true;
            }
            finally {
                if (!this.stop) {
                    this.listener.globalMessage(CLOSE);
                }
                if (is != null) {
                    is.close();
                }
                if (c != null) {
                    c.close();
                }
            }
        }
        return sb.toString();
    }

    private static String encode(String in) {
        byte[] src = in.getBytes();
        if (src == null) {
            return "";
        }
        int sl = src.length;
        StringBuffer dst = new StringBuffer(3 * sl);
        int i = 0;
        while (i < sl) {
            char c = (char)(src[i] & 0xFF);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '.') {
                dst.append(c);
            } else if (c == ' ') {
                dst.append('+');
            } else {
                String hex = "00" + Integer.toString(c & 0xFF, 16);
                dst.append('%');
                dst.append(hex.substring(hex.length() - 2).toUpperCase());
            }
            ++i;
        }
        return dst.toString();
    }
}

