/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class BitmapFont {
    public int m_iFontID = ++s_iLastID;
    public int m_iFontHeight;
    public int m_iFontColor;
    public int m_iBorderColor;
    public int m_iSpaceCharWidth;
    public boolean m_hasBorder;
    public byte m_bFixedWidth = 0;
    private byte[] m_abFixedWidth;
    private String m_sEnumChars;
    private int[] m_aiFontImageData;
    private byte[] m_bFontWidth;
    private byte[] m_abFontPackData;
    private int[] m_aiFontPackDataOffset;
    private int m_iBitToShift;
    private int m_iBitAND;
    private int m_iBitToCheckBorder;
    private int m_iScale;
    private boolean m_isLoadDataBitmapFont = false;
    private int m_iCurrentPal;
    public static int s_iMaxCachePool = 0;
    public static int s_iCurCachePool;
    public static Image[] s_imgCachePool;
    public static String s_sCharsCachePool;
    public static int[] s_aiPalCachePool;
    private static int s_iLastID;

    public void SetColor(int n) {
        this.m_iFontColor = n | 0xFF000000;
    }

    public void SetBorderColor(int n) {
        this.m_hasBorder = true;
        this.m_iBorderColor = n | 0xFF000000;
    }

    public int DrawChar(Graphics graphics, char c, int n, int n2) {
        if (c == ' ') {
            if (false) {
                return this.m_bFixedWidth;
            }
            return this.m_iSpaceCharWidth;
        }
        if (c == ASprite.k_cCanBreakLine) {
            return 0;
        }
        if (false && s_iMaxCachePool > 0 && this.m_iCurrentPal >= 0) {
            return this.DrawCachePoolChar(graphics, c, n, n2);
        }
        if (false) {
            return this.DrawCharPixel(graphics, c, n, n2);
        }
        return this.DrawCharImage(graphics, c, n, n2);
    }

    public void SetCurrentPalette(int n) {
        this.m_iCurrentPal = n;
    }

    private int DrawCachePoolChar(Graphics graphics, char c, int n, int n2) {
        if (!this.m_isLoadDataBitmapFont) {
            if (false) {
                // empty if block
            }
            return 0;
        }
        int n3 = this.MapChar(c);
        if (n3 == -1) {
            return 0;
        }
        byte by = this.m_bFontWidth[n3];
        int n4 = s_sCharsCachePool.indexOf(c);
        int n5 = this.m_iCurrentPal | this.m_iFontID << 8;
        if (n4 >= 0 && s_aiPalCachePool[n4] != n5) {
            boolean bl = true;
            while (n4 >= 0 && n4 < s_iMaxCachePool) {
                if ((n4 = s_sCharsCachePool.indexOf(c, n4)) < 0) continue;
                if (s_aiPalCachePool[n4] == n5) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) {
                n4 = -1;
            }
        }
        if (n4 < 0) {
            s_iCurCachePool = (s_iCurCachePool + 1) % s_iMaxCachePool;
            StringBuffer stringBuffer = new StringBuffer(s_sCharsCachePool);
            stringBuffer.setCharAt(s_iCurCachePool, c);
            s_sCharsCachePool = stringBuffer.toString();
            BitmapFont.s_aiPalCachePool[BitmapFont.s_iCurCachePool] = n5;
            this.DecodeFont(n3, this.m_aiFontImageData);
            try {
                BitmapFont.s_imgCachePool[BitmapFont.s_iCurCachePool] = GLLib.CreateRGBImage(this.m_aiFontImageData, by, this.m_iFontHeight, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphics.drawImage(s_imgCachePool[s_iCurCachePool], n, n2, 0);
        } else {
            graphics.drawImage(s_imgCachePool[n4], n, n2, 0);
        }
        if (false) {
            return this.m_abFixedWidth[n3];
        }
        return by;
    }

    private int DrawCharImage(Graphics graphics, char c, int n, int n2) {
        if (!this.m_isLoadDataBitmapFont) {
            if (false) {
                // empty if block
            }
            return 0;
        }
        int n3 = this.MapChar(c);
        if (n3 == -1) {
            return 0;
        }
        this.DecodeFont(n3, this.m_aiFontImageData);
        byte by = this.m_bFontWidth[n3];
        GLLib.DrawRGB(graphics, this.m_aiFontImageData, 0, by, n, n2, by, this.m_iFontHeight, true);
        if (false) {
            return this.m_abFixedWidth[n3];
        }
        return by;
    }

    private int DrawCharPixel(Graphics graphics, char c, int n, int n2) {
        if (!this.m_isLoadDataBitmapFont) {
            if (false) {
                // empty if block
            }
            return 0;
        }
        int n3 = this.MapChar(c);
        if (n3 == -1) {
            return 0;
        }
        byte by = this.m_bFontWidth[n3];
        int n4 = this.m_iFontHeight * by;
        int n5 = 0;
        int n6 = 0;
        int n7 = n;
        int n8 = graphics.getColor();
        graphics.setColor(this.m_iFontColor);
        for (int i = 0; i < n4; ++i) {
            n5 = i >> this.m_iBitToShift;
            n6 = (i & this.m_iBitAND) << this.m_iScale;
            int n9 = this.m_abFontPackData[this.m_aiFontPackDataOffset[n3] + n5] >> n6 & this.m_iBitToCheckBorder;
            if (--n9 == 0) {
                graphics.drawLine(n7, n2, n7, n2);
            } else if (this.m_hasBorder && n9 > 0) {
                graphics.setColor(this.m_iBorderColor);
                graphics.drawLine(n7, n2, n7, n2);
                graphics.setColor(this.m_iFontColor);
            }
            if (++n7 - n < by) continue;
            n7 = n;
            ++n2;
        }
        graphics.setColor(n8);
        if (false) {
            return this.m_abFixedWidth[n3];
        }
        return by;
    }

    public int GetCharWidth(char c) {
        if (c == ' ') {
            if (false) {
                return this.m_bFixedWidth;
            }
            return this.m_iSpaceCharWidth;
        }
        if (c == ASprite.k_cCanBreakLine) {
            return 0;
        }
        int n = this.MapChar(c);
        if (n == -1) {
            return 0;
        }
        if (false) {
            return this.m_abFixedWidth[n];
        }
        return this.m_bFontWidth[n];
    }

    private int MapChar(char c) {
        return this.m_sEnumChars.indexOf(c);
    }

    private void DecodeFont(int n, int[] nArray) {
        int n2 = this.m_iFontHeight * this.m_bFontWidth[n];
        int n3 = 0;
        int n4 = 0;
        if (nArray == null) {
            nArray = new int[n2];
        }
        int n5 = n2;
        while (--n5 >= 0) {
            n3 = n5 >> this.m_iBitToShift;
            n4 = (n5 & this.m_iBitAND) << this.m_iScale;
            int n6 = this.m_abFontPackData[this.m_aiFontPackDataOffset[n] + n3] >> n4 & this.m_iBitToCheckBorder;
            if (--n6 == 0) {
                nArray[n5] = this.m_iFontColor | 0xF000000;
                continue;
            }
            if (this.m_hasBorder && n6 > 0) {
                nArray[n5] = this.m_iBorderColor | 0xF000000;
                continue;
            }
            nArray[n5] = 0;
        }
    }

    static {
        s_iLastID = 0;
    }
}

