/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.TempoControl;
import javax.microedition.media.control.VolumeControl;

class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    int curFlags;
    ASprite sprite;
    private int curAnim;
    private int curFrame;
    public int curTime;
    private int nbLoop;
    private boolean animIsOver;
    private int curBlend;
    private int curScale;
    private static int k_animBaseFrameTime = 1000 / 25;
    private int palette;
    public static int k_AnimNone = -1;
    private static final int k_snd_nbChannel = 1;
    static int s_snd_masterVolume;
    static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static int[] s_snd_sndDuration;
    private static String[] s_snd_sndResourceURL;
    private static boolean s_snd_IgnoreSoundsOnInterrupt;
    private static Player[] s_snd_Player;
    private static Player[] s_snd_PlayerSlot;
    private static long[] s_snd_playTime;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    private static int[] s_snd_queue_size;
    private static boolean s_snd_bInUpdate;
    private static int[] s_snd_requestBuffer;
    private static int[] s_snd_fade;
    private static int[] s_snd_fadeTempo;
    private static int[] s_snd_fadeMidi;
    private static int[] s_snd_MidiChannelActiveFlags;
    private static boolean[] s_snd_fadeParamsNeedRefresh;
    private static int[] s_snd_fadeLoopingFixState;
    private static int s_snd_fadeDeltaTime;
    static final short[] m_adpcm_index;
    static final short[] m_adpcm_data;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;
    private static final int k_TilesetLayerAreaCount;
    private static int[] s_TilesetInfo;
    private static int[][] s_TilesetLayerInfo;
    private static Image[][] s_TilesetLayerImage;
    private static Graphics[][] s_TilesetLayerGraphics;
    private static int[][][] s_TilesetLayerLastUpdatedArea;
    private static int s_TilesetLayerLastUpdatedAreaIndex;

    GLLibPlayer() {
        this.Reset();
    }

    void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = k_AnimNone;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.palette = -1;
        this.animIsOver = true;
        if (false) {
            this.curScale = -1;
        }
        if (true) {
            this.curBlend = -1;
        }
    }

    private static final int SndQueue_NormalizeIndex(int n) {
        while (n >= 7) {
            n -= 7;
        }
        while (n < 0) {
            n += 7;
        }
        return n;
    }

    private static final int SndQueue_GetIndex(int n, int n2) {
        return n * 7 * 5 + n2 * 5;
    }

    private static void SndQueue_Push_Normal(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        int n8 = s_snd_queue_pointer[n];
        int n9 = s_snd_queue_size[n];
        int n10 = GLLibPlayer.SndQueue_NormalizeIndex(n8 + n9);
        for (int i = 0; i < n9; ++i) {
            n7 = GLLibPlayer.SndQueue_NormalizeIndex(n10 - i - 1);
            if (s_snd_queue[(n7 = GLLibPlayer.SndQueue_GetIndex(n, n7)) + 0] != n2 || (n2 == 3 || n2 == 1) && s_snd_queue[n7 + 2] < n4) continue;
            GLLibPlayer.s_snd_queue[n7 + 0] = 0;
        }
        n7 = GLLibPlayer.SndQueue_GetIndex(n, n10);
        GLLibPlayer.s_snd_queue[n7 + 0] = n2;
        GLLibPlayer.s_snd_queue[n7 + 1] = n3;
        GLLibPlayer.s_snd_queue[n7 + 2] = n4;
        GLLibPlayer.s_snd_queue[n7 + 3] = n5;
        GLLibPlayer.s_snd_queue[n7 + 4] = n6;
        int n11 = n;
        s_snd_queue_size[n11] = s_snd_queue_size[n11] + 1;
    }

    private static synchronized void SndQueue_Push_Synched(int n, int n2, int n3, int n4, int n5, int n6) {
        GLLibPlayer.SndQueue_Push_Normal(n, n2, n3, n4, n5, n6);
    }

    private static void SndQueue_Push(int n, int n2, int n3, int n4, int n5, int n6) {
        if (false && false) {
            GLLibPlayer.SndQueue_Push_Synched(n, n2, n3, n4, n5, n6);
        } else {
            GLLibPlayer.SndQueue_Push_Normal(n, n2, n3, n4, n5, n6);
        }
    }

    private static final void SndQueue_Push(int n, int n2) {
        GLLibPlayer.SndQueue_Push(n, n2, -1, -1, -1, -1);
    }

    private static void SndQueue_Pop_Normal(int n, int[] nArray) {
        nArray[5] = s_snd_queue_size[n];
        if (s_snd_queue_size[n] > 0) {
            int n2 = GLLibPlayer.SndQueue_GetIndex(n, s_snd_queue_pointer[n]);
            System.arraycopy(s_snd_queue, n2, nArray, 0, 5);
            GLLibPlayer.s_snd_queue_pointer[n] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[n] + 1);
            int n3 = n;
            s_snd_queue_size[n3] = s_snd_queue_size[n3] - 1;
        }
    }

    private static synchronized void SndQueue_Pop_Synched(int n, int[] nArray) {
        GLLibPlayer.SndQueue_Pop_Normal(n, nArray);
    }

    private static void SndQueue_Pop(int n, int[] nArray) {
        if (false && false) {
            GLLibPlayer.SndQueue_Pop_Synched(n, nArray);
        } else {
            GLLibPlayer.SndQueue_Pop_Normal(n, nArray);
        }
    }

    static final void Snd_Stop(int n) {
        if (!true) {
            return;
        }
        if (false) {
            // empty if block
        }
        GLLibPlayer.SndQueue_Push(n, 4);
        if (false) {
            GLLibPlayer.Snd_FadeStopChannel(n, true);
        }
    }

    private static void Snd_PrepareExec(int n, int n2, int n3) throws Exception {
        if (!true) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (s_snd_state[n] == 2 && s_snd_priority[n] < n3) {
            return;
        }
        if (s_snd_index[n] == n2 && s_snd_state[n] != 0) {
            return;
        }
        int n4 = s_snd_index[n];
        GLLibPlayer.Snd_FreeChannelExec(n);
        if (false) {
            // empty if block
        }
        if (false) {
            // empty if block
        }
        if (false) {
            GLLibPlayer.s_snd_Player[n] = s_snd_PlayerSlot[n2];
        }
        if (false && s_snd_Player[n] == null && s_snd_sndResourceURL[n2] != null) {
            s_snd_IgnoreSoundsOnInterrupt = true;
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((String)s_snd_sndResourceURL[n2]);
            s_snd_IgnoreSoundsOnInterrupt = false;
        }
        if (s_snd_Player[n] == null) {
            if (false) {
                // empty if block
            }
            if (s_snd_sndSlot[n2] == null) {
                return;
            }
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        if (!false) {
            if (false) {
                // empty if block
            }
            s_snd_Player[n].realize();
        }
        if (!false) {
            if (false) {
                // empty if block
            }
            s_snd_Player[n].prefetch();
        }
        GLLibPlayer.s_snd_state[n] = 1;
        GLLibPlayer.s_snd_index[n] = n2;
        if (n4 >= 0 && n4 < s_snd_maxNbSoundSlot && false && GLLibPlayer.Snd_GetSlotState(n4) == 400) {
            s_snd_PlayerSlot[n4].stop();
        }
    }

    private static void Snd_PlayExec(int n, int n2, int n3, int n4, int n5) throws Exception {
        if (!true || GLLib.s_game_isPaused) {
            return;
        }
        if (false) {
            // empty if block
        }
        GLLibPlayer.Snd_PrepareExec(n, n2, n3);
        if (GLLib.s_game_isPaused) {
            return;
        }
        if (s_snd_state[n] != 1 || s_snd_Player[n] == null) {
            if (false) {
                // empty if block
            }
            return;
        }
        if (false) {
            // empty if block
        }
        if (n4 == 0) {
            s_snd_Player[n].setLoopCount(-1);
        } else {
            s_snd_Player[n].setLoopCount(n4);
        }
        if (true) {
            if (false) {
                // empty if block
            }
            ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n5 * s_snd_masterVolume * 100 / 10000);
        }
        if (false) {
            // empty if block
        }
        if (false) {
            s_snd_Player[n].setMediaTime(0L);
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
        GLLibPlayer.s_snd_volume[n] = n5;
        GLLibPlayer.s_snd_loop[n] = n4;
        GLLibPlayer.s_snd_priority[n] = n3;
        GLLibPlayer.s_snd_index[n] = n2;
        if (false) {
            GLLibPlayer.s_snd_playTime[n] = System.currentTimeMillis();
        }
    }

    static int Snd_GetChannelVolume(int n) throws Exception {
        if (!true) {
            return 0;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return 0;
        }
        try {
            if (s_snd_Player[n] == null) {
                return 0;
            }
            return ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).getLevel() * 100 * 100 / (s_snd_masterVolume * 100);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    static void Snd_SetChannelVolume(int n, int n2) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized || s_snd_Player[n] == null) {
            return;
        }
        try {
            if (s_snd_Player[n] != null && true) {
                ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n2 * s_snd_masterVolume * 100 / 10000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void Snd_StopExec(int n) throws Exception {
        if (false) {
            // empty if block
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 1;
        if (false) {
            GLLibPlayer.Snd_FreeChannelExec(n);
        }
        if (false) {
            GLLibPlayer.s_snd_playTime[n] = 0L;
        }
    }

    private static void Snd_PauseExec(int n) throws Exception {
        if (false) {
            // empty if block
        }
        if (s_snd_state[n] != 2) {
            return;
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 3;
    }

    private static void Snd_ResumeExec(int n) throws Exception {
        if (false) {
            // empty if block
        }
        if (s_snd_state[n] != 3) {
            if (false) {
                // empty if block
            }
            return;
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
    }

    static void Snd_Update() {
        if (false) {
            if (s_pThread != null && !s_pThread.isAlive()) {
                s_pThread.start();
            }
        } else {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    private static void Snd_Update_Exec() {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            if (s_snd_bInUpdate) {
                return;
            }
            s_snd_bInUpdate = true;
        }
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.SndQueue_Pop(i, s_snd_requestBuffer);
            if (s_snd_requestBuffer[5] > 0) {
                if (s_snd_state[i] == 2) {
                    boolean bl;
                    try {
                        bl = GLLibPlayer.Snd_IsPlaying(i);
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                    if (!bl) {
                        GLLibPlayer.s_snd_state[i] = 1;
                    }
                }
                while (s_snd_requestBuffer[5] > 0) {
                    try {
                        if (false) {
                            // empty if block
                        }
                        switch (s_snd_requestBuffer[0]) {
                            case 1: {
                                GLLibPlayer.Snd_PrepareExec(i, s_snd_requestBuffer[1], s_snd_requestBuffer[2]);
                                break;
                            }
                            case 2: {
                                GLLibPlayer.Snd_FreeChannelExec(i);
                                break;
                            }
                            case 3: {
                                GLLibPlayer.Snd_PlayExec(i, s_snd_requestBuffer[1], s_snd_requestBuffer[2], s_snd_requestBuffer[4], s_snd_requestBuffer[3]);
                                break;
                            }
                            case 4: {
                                GLLibPlayer.Snd_StopExec(i);
                                break;
                            }
                            case 5: {
                                GLLibPlayer.Snd_PauseExec(i);
                                break;
                            }
                            case 6: {
                                GLLibPlayer.Snd_ResumeExec(i);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GLLibPlayer.SndQueue_Pop(i, s_snd_requestBuffer);
                }
            }
            if (!false) continue;
            GLLibPlayer.SndFade_Update(i);
        }
        if (false) {
            s_snd_bInUpdate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                if (false && !false) {
                    GLLib gLLib = GLLib.s_gllib_instance;
                    synchronized (gLLib) {
                        if (GLLib.s_game_isPaused) {
                            this.wait();
                        }
                    }
                }
                Thread.sleep(1000 / 8);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean Snd_IsPlaying(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (n >= k_snd_nbChannel || s_snd_Player[n] == null) {
            return false;
        }
        if (false) {
            int n2 = GLLibPlayer.Snd_GetCurrentSoundIndex(n);
            if (n2 < 0) {
                return false;
            }
            if (s_snd_loop[n] != 0 && System.currentTimeMillis() - s_snd_playTime[n] > (long)(s_snd_sndDuration[n2] * s_snd_loop[n])) {
                return false;
            }
        } else if (s_snd_Player[n].getState() != 400) {
            return false;
        }
        return true;
    }

    static int Snd_GetSlotState(int n) {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (n < 0 || n >= s_snd_maxNbSoundSlot || s_snd_PlayerSlot == null || s_snd_PlayerSlot[n] == null) {
            return -1;
        }
        return s_snd_PlayerSlot[n].getState();
    }

    private static void Snd_FreeChannelExec(int n) throws Exception {
        if (!true || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (false) {
            // empty if block
        }
        if (s_snd_Player[n] != null) {
            s_snd_Player[n].stop();
            if (!false) {
                s_snd_Player[n].deallocate();
            }
            if (!false) {
                s_snd_Player[n].close();
            } else {
                int n2 = s_snd_index[n];
                if (n2 < 0 || s_snd_PlayerSlot[n2] == null) {
                    s_snd_Player[n].close();
                }
            }
            GLLibPlayer.s_snd_Player[n] = null;
            GLLib.Gc();
        }
        GLLibPlayer.s_snd_state[n] = 0;
        GLLibPlayer.s_snd_index[n] = -1;
    }

    static void Snd_StopAllSounds() {
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.Snd_Stop(i);
        }
        if (!false) {
            GLLibPlayer.Snd_Update();
        } else if (GLLib.s_game_isPaused) {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    static int Snd_GetCurrentSoundIndex(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (s_snd_index != null) {
            return s_snd_index[n];
        }
        return -1;
    }

    static long Snd_MediaTimeGet(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1L;
        }
        try {
            long l = s_snd_Player[n].getMediaTime();
            return l;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    static boolean Snd_MidiSetChannelVolume(int n, int n2, int n3) throws Exception {
        MIDIControl mIDIControl;
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (false) {
            GLLibPlayer.s_snd_fadeMidi[(n * 16 + n2) * 9 + 3] = n3;
        }
        if (false && (mIDIControl = (MIDIControl)s_snd_Player[n].getControl("MIDIControl")) != null) {
            mIDIControl.shortMidiEvent(0xB0 | n2, 7, n3);
            return true;
        }
        return false;
    }

    static int Snd_TempoGet(int n) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (false) {
            try {
                TempoControl tempoControl = (TempoControl)s_snd_Player[n].getControl("TempoControl");
                if (tempoControl != null) {
                    return tempoControl.getTempo();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    static boolean Snd_TempoSet(int n, int n2) throws Exception {
        TempoControl tempoControl;
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (false && (tempoControl = (TempoControl)s_snd_Player[n].getControl("TempoControl")) != null) {
            tempoControl.setTempo(n2);
            return true;
        }
        return false;
    }

    private static void Snd_FadeCommand(int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n2 * 3;
            GLLibPlayer.s_snd_fade[n5 + 0] = n;
            GLLibPlayer.s_snd_fade[n5 + 1] = n3;
            GLLibPlayer.s_snd_fade[n5 + 2] = n4;
        }
    }

    private static void Snd_FadeTempoCommand(int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n2 * 3;
            GLLibPlayer.s_snd_fadeTempo[n5 + 0] = n;
            if (n != 1) {
                GLLibPlayer.s_snd_fadeTempo[n5 + 1] = n3;
                GLLibPlayer.s_snd_fadeTempo[n5 + 2] = n4;
            }
        }
    }

    private static void Snd_FadeMidiCommand(int n, int n2, int n3, int n4, int n5) {
        if (false) {
            int n6 = (n2 * 16 + n3) * 9;
            GLLibPlayer.s_snd_fadeMidi[n6 + 0] = n;
            if (n == 0 || n == 1) {
                int n7 = n2;
                s_snd_MidiChannelActiveFlags[n7] = s_snd_MidiChannelActiveFlags[n7] & ~(1 << n3);
            } else {
                GLLibPlayer.s_snd_fadeMidi[n6 + 1] = n4;
                GLLibPlayer.s_snd_fadeMidi[n6 + 2] = n5;
                int n8 = n2;
                s_snd_MidiChannelActiveFlags[n8] = s_snd_MidiChannelActiveFlags[n8] | 1 << n3;
            }
        }
    }

    static void Snd_FadeStopChannel(int n, boolean bl) {
        if (false) {
            GLLibPlayer.Snd_FadeCommand(0, n, 0, 0);
            GLLibPlayer.Snd_FadeTempoCommand(0, n, 0, 0);
            if (bl) {
                for (int i = 0; i < 16; ++i) {
                    GLLibPlayer.Snd_FadeMidiCommand(0, n, i, 0, 0);
                }
            }
        }
    }

    private static void Snd_ResetRandomlyActivatedMidiTrack(int n, int n2, boolean bl) {
        int n3;
        int n4;
        if (false && ((n4 = s_snd_fadeMidi[(n3 = (n * 16 + n2) * 9) + 0]) == 6 || n4 == 7)) {
            if (bl) {
                GLLibPlayer.s_snd_fadeMidi[n3 + 0] = 6;
                GLLibPlayer.s_snd_fadeMidi[n3 + 8] = GLLib.Math_Rand(s_snd_fadeMidi[n3 + 4], s_snd_fadeMidi[n3 + 5] + 1);
            } else {
                GLLibPlayer.s_snd_fadeMidi[n3 + 0] = 7;
                GLLibPlayer.s_snd_fadeMidi[n3 + 8] = GLLib.Math_Rand(s_snd_fadeMidi[n3 + 6], s_snd_fadeMidi[n3 + 7] + 1);
            }
        }
    }

    private static void SndFade_Update(int n) {
        if (false) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if ((s_snd_fadeDeltaTime += GLLib.s_game_frameDT) < 0) {
                return;
            }
            int n7 = s_snd_fadeDeltaTime;
            s_snd_fadeDeltaTime = 0;
            long l = GLLibPlayer.Snd_MediaTimeGet(n);
            if (l >= 0L && l <= (long)(n7 * 1000)) {
                GLLibPlayer.s_snd_fadeParamsNeedRefresh[n] = true;
            }
            try {
                if (!GLLibPlayer.Snd_IsPlaying(n)) {
                    if (false && !GLLib.s_game_isPaused && s_snd_loop[n] == 0 && s_snd_fadeLoopingFixState[n] < 3) {
                        switch (s_snd_fadeLoopingFixState[n]) {
                            case 0: {
                                if (s_snd_state[n] != 2) break;
                                GLLibPlayer.s_snd_fadeLoopingFixState[n] = 1;
                                GLLibPlayer.s_snd_fadeParamsNeedRefresh[n] = true;
                                break;
                            }
                            case 1: {
                                GLLibPlayer.s_snd_fadeLoopingFixState[n] = 2;
                                s_snd_Player[n].stop();
                                GLLibPlayer.s_snd_state[n] = 1;
                                if (!false) break;
                                GLLibPlayer.s_snd_playTime[n] = 0L;
                                break;
                            }
                            case 2: {
                                GLLibPlayer.Snd_PlayExec(n, s_snd_index[n], s_snd_priority[n], 0, s_snd_volume[n]);
                                GLLibPlayer.s_snd_fadeLoopingFixState[n] = 3;
                            }
                        }
                    }
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            if (false) {
                GLLibPlayer.s_snd_fadeLoopingFixState[n] = 0;
            }
            if ((n6 = s_snd_fade[(n5 = n * 3) + 0]) != 0 && n6 != 1) {
                n4 = s_snd_fade[n5 + 1];
                try {
                    n3 = GLLibPlayer.Snd_GetChannelVolume(n);
                    int n8 = n2 = 1 > s_snd_fade[n5 + 2] * n7 / 1000 ? 1 : s_snd_fade[n5 + 2] * n7 / 1000;
                    n3 = n3 < n4 ? (n4 < n3 + n2 ? n4 : n3 + n2) : (n4 > n3 - n2 ? n4 : n3 - n2);
                    GLLibPlayer.Snd_SetChannelVolume(n, n3);
                }
                catch (Exception exception) {
                    n3 = n4;
                }
                if (n3 == n4) {
                    if (n6 == 4) {
                        GLLibPlayer.Snd_Stop(n);
                    }
                    GLLibPlayer.Snd_FadeCommand(0, n, 0, 0);
                }
            }
            if ((n6 = s_snd_fadeTempo[n5 + 0]) != 0 && n6 != 1) {
                n4 = s_snd_fadeTempo[n5 + 1];
                n3 = -1;
                try {
                    n3 = GLLibPlayer.Snd_TempoGet(n);
                    int n9 = n2 = 1 > s_snd_fadeTempo[n5 + 2] * n7 / 1000 ? 1 : s_snd_fadeTempo[n5 + 2] * n7 / 1000;
                    n3 = n3 < n4 ? (n4 < n3 + n2 ? n4 : n3 + n2) : (n4 > n3 - n2 ? n4 : n3 - n2);
                    GLLibPlayer.Snd_TempoSet(n, n3);
                }
                catch (Exception exception) {
                    GLLibPlayer.Snd_FadeTempoCommand(0, n, 0, 0);
                }
                if (n3 < 0 || (n3 - n4 < 0 ? -(n3 - n4) : n3 - n4) < 500) {
                    GLLibPlayer.Snd_FadeTempoCommand(1, n, 0, 0);
                }
            } else if (s_snd_fadeParamsNeedRefresh[n] && n6 == 1) {
                try {
                    n4 = s_snd_fadeTempo[n5 + 1];
                    n3 = GLLibPlayer.Snd_TempoGet(n);
                    if ((n3 - n4 < 0 ? -(n3 - n4) : n3 - n4) >= 500) {
                        GLLibPlayer.Snd_TempoSet(n, n4);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (s_snd_MidiChannelActiveFlags[n] == 0 && !s_snd_fadeParamsNeedRefresh[n]) {
                return;
            }
            block25: for (int i = 0; i < 16; ++i) {
                if ((s_snd_MidiChannelActiveFlags[n] & 1 << i) == 0 && !s_snd_fadeParamsNeedRefresh[n]) continue;
                n5 = (n * 16 + i) * 9;
                n6 = s_snd_fadeMidi[n5 + 0];
                switch (n6) {
                    case 0: {
                        continue block25;
                    }
                    case 1: {
                        if (!s_snd_fadeParamsNeedRefresh[n]) continue block25;
                        n3 = s_snd_fadeMidi[n5 + 1];
                        try {
                            GLLibPlayer.Snd_MidiSetChannelVolume(n, i, n3);
                        }
                        catch (Exception exception) {}
                        continue block25;
                    }
                    case 2: {
                        int n10;
                        n3 = s_snd_fadeMidi[n5 + 1];
                        int n11 = s_snd_fadeMidi[n5 + 3];
                        int n12 = n10 = 1 > s_snd_fadeMidi[n5 + 2] * n7 / 1000 ? 1 : s_snd_fadeMidi[n5 + 2] * n7 / 1000;
                        n11 = n11 < n3 ? (n3 < n11 + n10 ? n3 : n11 + n10) : (n3 > n11 - n10 ? n3 : n11 - n10);
                        try {
                            GLLibPlayer.Snd_MidiSetChannelVolume(n, i, n11);
                        }
                        catch (Exception exception) {
                            n11 = n3;
                        }
                        if (n11 != n3) continue block25;
                        GLLibPlayer.Snd_FadeMidiCommand(1, n, i, 0, 0);
                        continue block25;
                    }
                    case 6: 
                    case 7: {
                        int n10;
                        n3 = n6 == 6 ? s_snd_fadeMidi[n5 + 1] : 0;
                        int n13 = s_snd_fadeMidi[n5 + 3];
                        if (n13 != n3) {
                            int n14 = n10 = 1 > s_snd_fadeMidi[n5 + 2] * n7 / 1000 ? 1 : s_snd_fadeMidi[n5 + 2] * n7 / 1000;
                            n13 = n13 < n3 ? (n3 < n13 + n10 ? n3 : n13 + n10) : (n3 > n13 - n10 ? n3 : n13 - n10);
                            try {
                                GLLibPlayer.Snd_MidiSetChannelVolume(n, i, n13);
                            }
                            catch (Exception exception) {
                                n13 = n3;
                            }
                        }
                        int n15 = n5 + 8;
                        s_snd_fadeMidi[n15] = s_snd_fadeMidi[n15] - n7;
                        if (s_snd_fadeMidi[n5 + 8] > 0) continue block25;
                        GLLibPlayer.Snd_ResetRandomlyActivatedMidiTrack(n, i, n6 == 7);
                        continue block25;
                    }
                }
            }
            GLLibPlayer.s_snd_fadeParamsNeedRefresh[n] = false;
        }
    }

    static void Snd_PauseNotify() {
        if (!(!true || s_snd_IgnoreSoundsOnInterrupt && false)) {
            try {
                GLLibPlayer.Snd_StopAllSounds();
                if (false && GLLib.s_game_isPaused) {
                    GLLibPlayer.Snd_Update_Exec();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static final boolean isFlag(int n, int n2) {
        return (s_TilesetLayerInfo[n][15] & n2) != 0;
    }

    private static final int Tileset_GetTranslatedOriginY(int n, int n2) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][6] - s_TilesetInfo[1] - n2;
        }
        return n2;
    }

    static final Image Tileset_GetBufferImage(int n) {
        return GLLibPlayer.Tileset_GetBufferImage(n, 0);
    }

    static final Image Tileset_GetBufferImage(int n, int n2) {
        return s_TilesetLayerImage[n][n2];
    }

    static final void Tileset_PaintSpriteFrame(int n, ASprite aSprite, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        GLLibPlayer.Tileset_PaintToBuffer(0, n, aSprite, 0, n2, n3, n4, n6, n7, n5, bl);
    }

    private static void Tileset_PaintToBuffer(int n, int n2, ASprite aSprite, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        GLLibPlayer.Tileset_PaintToBuffer(n, n2, aSprite, n3, n4, n5, n6, n7, n8, 0, 0, 0, 0, 1, 1, n9, bl);
    }

    private static void Tileset_PaintToBuffer(int n, int n2, ASprite aSprite, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, boolean bl) {
        int n16;
        int n17;
        int n18;
        int n19;
        if (false && s_TilesetLayerLastUpdatedAreaIndex == 0 && !bl) {
            return;
        }
        int[] nArray = s_TilesetLayerInfo[n2];
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        if (n == 0) {
            n20 = aSprite.GetFrameMinX(n4);
            n21 = aSprite.GetFrameMinY(n4);
            n22 = aSprite.GetFrameWidth(n4);
            n23 = aSprite.GetFrameHeight(n4);
        } else if (n == 1 || n == 2 || n == 3) {
            n22 = n7;
            n23 = n8;
        }
        if ((n15 & 1) != 0) {
            n20 = -n20 - n22;
        }
        if ((n15 & 2) != 0) {
            n21 = -n21 - n23;
        }
        if ((n15 & 4) != 0) {
            n19 = n20;
            n20 = -n21 - n23;
            n21 = n19;
            n18 = n22;
            n22 = n23;
            n23 = n18;
        }
        n6 = GLLibPlayer.Tileset_GetTranslatedOriginY(n2, n6);
        n19 = nArray[13];
        n18 = nArray[14];
        if (false && GLLibPlayer.isFlag(n2, 256)) {
            n17 = nArray[2];
            n16 = nArray[3];
        } else {
            n17 = s_TilesetInfo[2];
            n16 = s_TilesetInfo[5];
        }
        int n24 = n19 % n17;
        int n25 = n18 % n16;
        if (n24 < 0) {
            n24 = n17 + n24;
        }
        if (n25 < 0) {
            n25 = n16 + n25;
        }
        n5 -= (n19 -= n24);
        n6 -= (n18 -= n25);
        if (GLLibPlayer.isFlag(n2, 273) && n19 < 0) {
            n19 = nArray[7] + n19 % nArray[7];
        }
        if (GLLibPlayer.isFlag(n2, 290) && n18 < 0) {
            n18 = nArray[8] + n18 % nArray[8];
        }
        int n26 = n19 % nArray[7];
        int n27 = n18 % nArray[8];
        int n28 = nArray[7] - n26;
        int n29 = nArray[8] - n27;
        Graphics graphics = s_TilesetLayerGraphics[n2][0];
        if (false) {
            ASprite.SetGraphicsSize(s_TilesetLayerInfo[n2][7], s_TilesetLayerInfo[n2][8]);
        }
        int n30 = GLLib.GetClipX(graphics);
        int n31 = GLLib.GetClipY(graphics);
        int n32 = GLLib.GetClipWidth(graphics);
        int n33 = GLLib.GetClipHeight(graphics);
        int n34 = 1;
        if (false && !bl) {
            n34 = s_TilesetLayerLastUpdatedAreaIndex;
        }
        boolean bl2 = false;
        if (false && (true || true || true) && GLLibPlayer.isFlag(n2, 4) && (GLLib.PFX_IsEffectEnabled(5) || GLLib.PFX_IsEffectEnabled(6) || GLLib.PFX_IsEffectEnabled(7))) {
            bl2 = true;
            GLLib.PFX_SetCustomBuffer(GLLibPlayer.Tileset_GetBufferImage(n2));
        }
        if (n13 < 1) {
            n13 = 1;
        }
        if (n14 < 1) {
            n14 = 1;
        }
        int n35 = n13;
        int n36 = n14;
        int n37 = n9;
        int n38 = n10;
        int n39 = n11;
        int n40 = n12;
        int n41 = nArray[7];
        int n42 = nArray[8];
        int n43 = GLLib.GetGraphicsWidth();
        int n44 = GLLib.GetGraphicsHeight();
        ASprite.SetGraphicsSize(n41, n42);
        int n45 = n34;
        int n46 = n5 + n20;
        int n47 = n6 + n21;
        int n48 = n46 + n22;
        int n49 = n47 + n23;
        for (int i = 0; i < n35; ++i) {
            int n50 = n46;
            int n51 = n47;
            int n52 = n48;
            int n53 = n49;
            n46 += n37;
            n47 += n38;
            n48 += n37;
            n49 += n38;
            for (int j = 0; j < n36; ++j) {
                int n54 = n50;
                int n55 = n51;
                int n56 = n52;
                int n57 = n53;
                n50 += n39;
                n51 += n40;
                n52 += n39;
                n53 += n40;
                if (n54 > n41 || n57 < 0 || n56 < 0 || n55 > n42) continue;
                n34 = n45;
                while (--n34 >= 0) {
                    int[] nArray2 = null;
                    if (false && !bl) {
                        int n58;
                        int n59;
                        nArray2 = s_TilesetLayerLastUpdatedArea[n2][n34];
                        int n60 = nArray2[0] - n26;
                        if (nArray2[0] < n26) {
                            n60 += nArray[7];
                        }
                        if (n54 >= (n59 = n60 + nArray2[2]) || n56 < n60) continue;
                        int n61 = nArray2[1] - n27;
                        if (nArray2[1] < n27) {
                            n61 += nArray[8];
                        }
                        if (n55 >= (n58 = n61 + nArray2[3]) || n57 < n61) continue;
                    }
                    if (n54 < n28) {
                        if (n55 < n29) {
                            GLLib.SetClip(graphics, n30, n31, n32, n33);
                            GLLib.ClipRect(graphics, n26, n27, n28, n29);
                            if (false && !bl) {
                                GLLib.ClipRect(graphics, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
                            }
                            if (n == 0) {
                                aSprite.PaintFrameExec(graphics, n4, n26 + n54 - n20, n27 + n55 - n21, n15, n7, n8);
                            } else if (n == 1) {
                                GLLib.DrawRect(graphics, n26 + n54 - n20, n27 + n55 - n21, n7, n8);
                            } else if (n == 2) {
                                GLLib.FillRect(graphics, n26 + n54 - n20, n27 + n55 - n21, n7, n8);
                            } else if (n == 3) {
                                GLLib.AlphaRect_Draw(graphics, n26 + n54 - n20, n27 + n55 - n21, n7, n8);
                            }
                        }
                        if (n57 >= n29 && n27 != 0) {
                            GLLib.SetClip(graphics, n30, n31, n32, n33);
                            GLLib.ClipRect(graphics, n26, 0, n28, n27);
                            if (false && !bl) {
                                GLLib.ClipRect(graphics, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
                            }
                            if (n == 0) {
                                aSprite.PaintFrameExec(graphics, n4, n26 + n54 - n20, n55 - n21 - n29, n15, n7, n8);
                            } else if (n == 1) {
                                GLLib.DrawRect(graphics, n26 + n54 - n20, n55 - n21 - n29, n7, n8);
                            } else if (n == 2) {
                                GLLib.FillRect(graphics, n26 + n54 - n20, n55 - n21 - n29, n7, n8);
                            } else if (n == 3) {
                                GLLib.AlphaRect_Draw(graphics, n26 + n54 - n20, n55 - n21 - n29, n7, n8);
                            }
                        }
                    }
                    if (n56 < n28 || n26 == 0) continue;
                    if (n55 < n29) {
                        GLLib.SetClip(graphics, n30, n31, n32, n33);
                        GLLib.ClipRect(graphics, 0, n27, n26, n29);
                        if (false && !bl) {
                            GLLib.ClipRect(graphics, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
                        }
                        if (n == 0) {
                            aSprite.PaintFrameExec(graphics, n4, n54 - n20 - n28, n27 + n55 - n21, n15, n7, n8);
                        } else if (n == 1) {
                            GLLib.DrawRect(graphics, n54 - n20 - n28, n27 + n55 - n21, n7, n8);
                        } else if (n == 2) {
                            GLLib.FillRect(graphics, n54 - n20 - n28, n27 + n55 - n21, n7, n8);
                        } else if (n == 3) {
                            GLLib.AlphaRect_Draw(graphics, n54 - n20 - n28, n27 + n55 - n21, n7, n8);
                        }
                    }
                    if (n57 < n29 || n27 == 0) continue;
                    GLLib.SetClip(graphics, n30, n31, n32, n33);
                    GLLib.ClipRect(graphics, 0, 0, n26, n27);
                    if (false && !bl) {
                        GLLib.ClipRect(graphics, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
                    }
                    if (n == 0) {
                        aSprite.PaintFrameExec(graphics, n4, n54 - n20 - n28, n55 - n21 - n29, n15, n7, n8);
                        continue;
                    }
                    if (n == 1) {
                        GLLib.DrawRect(graphics, n54 - n20 - n28, n55 - n21 - n29, n7, n8);
                        continue;
                    }
                    if (n == 2) {
                        GLLib.FillRect(graphics, n54 - n20 - n28, n55 - n21 - n29, n7, n8);
                        continue;
                    }
                    if (n != 3) continue;
                    GLLib.AlphaRect_Draw(graphics, n54 - n20 - n28, n55 - n21 - n29, n7, n8);
                }
            }
        }
        GLLib.SetClip(graphics, n30, n31, n32, n33);
        ASprite.SetGraphicsSize(n43, n44);
        if (false && (true || true || true) && bl2) {
            GLLib.PFX_SetCustomBuffer(null);
        }
        if (false) {
            ASprite.SetGraphicsSize(GLLib.GetScreenWidth(), GLLib.GetScreenHeight());
        }
    }

    static {
        s_snd_IgnoreSoundsOnInterrupt = false;
        m_adpcm_index = new short[]{-1, -1, -1, -1, 2, 4, 6, 8, -1, -1, -1, -1, 2, 4, 6, 8};
        m_adpcm_data = new short[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = 1;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
        k_TilesetLayerAreaCount = 6;
    }
}

