/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public abstract class GLLib
extends Canvas
implements Runnable {
    public static Graphics g = null;
    private static Graphics s_lastPaintGraphics = null;
    public static Graphics s_screenGraphics = null;
    static boolean s_game_isPaused;
    static int s_game_state;
    static long s_game_timeWhenFrameStart;
    static long s_game_lastFrameTime;
    static boolean s_game_interruptNotify;
    private static int s_screenWidth;
    private static int s_screenHeight;
    static Display s_display;
    private static boolean s_game_isInPaint;
    static MIDlet s_application;
    private static int m_FPSLimiter;
    private long m_frameCoheranceTimer;
    private static int m_customSleepTime;
    private static Image m_imgBackBuffer;
    private static Graphics m_gBackBuffer;
    private static boolean m_bBackBufferEnabled;
    static int s_game_frameDT;
    private static long s_game_frameDTTimer;
    static int s_game_totalExecutionTime;
    static int s_game_FPSAverage;
    static int s_game_currentFrameNB;
    static GLLib s_gllib_instance;
    static byte[] s_keyState;
    static byte[] s_keyStateRT;
    static int s_keyLastKeyPressUntranslatedCode;
    static int s_game_keyEventIndex;
    static int s_game_keyJustPressed;
    static long s_game_keyPressedTime;
    static int m_keys_pressed;
    static int m_keys_released;
    static int m_keys_state;
    static int m_current_keys_state;
    static int m_current_keys_pressed;
    static int m_current_keys_released;
    static int m_last_key_pressed;
    private static int s_keysDisabledTimer;
    private static Hashtable standardKeyTable;
    private static Hashtable gameActionKeyTable;
    private static int s_nbKey;
    private static int s_dbg_console_logSlotsSize;
    private static int s_dbg_console_nbVisibleSlots;
    private static int s_dbg_console_fontColor;
    private static int s_dbg_console_fontBackgroundColor;
    private static boolean s_dbg_console_recordLogCurrentTime;
    private static boolean s_dbg_console_forceFocusNextAvailableSlot;
    private static boolean s_dbg_console_isScreenConsoleEnabled;
    private static String[] s_dbg_console_logs;
    private static long[] s_dbg_console_logs_time;
    private static int s_dbg_console_nextAvailableLogSlot;
    private static int s_dbg_console_firstVisibleLogSlot;
    private static long s_dbg_console_keyHeldTime;
    private static long s_dbg_console_keyHeldTimer;
    private static int s_dbg_console_currentAction;
    private static int[][] s_dbg_console_touchActionAreas;
    static final int s_math_F_1;
    static final int s_math_F_05;
    static Random s_math_random;
    private static int[] s_math_cosTable;
    static final int Math_AngleMUL;
    static final int Math_Angle90;
    static final int Math_Angle180;
    static final int Math_Angle270;
    static final int Math_Angle360;
    static final int Math_FixedPoint_PI;
    static final int Math_FixedPoint_E;
    private static final int ratioRadiansToDegrees;
    private static final int ratioDegreesToAngleFixedPoint;
    static int[][] s_Math_intersectPoints;
    static byte[][] MIME_type;
    private static int Stream_readOffset;
    static String text_encoding;
    public static boolean s_tProf_isProfilerEnabled;
    public static int s_tProf_maxSlots;
    public static long[][] s_tProf_profilerPool;
    public static String[] s_tProf_profilerNames;
    public static int s_tProf_activeSlots;
    public static int s_tProf_yDisplay;
    public static int s_tProf_lineHeight;
    public static int s_tProf_liveTextColor;
    public static boolean s_tProf_isScrollDown;
    public static boolean s_tProf_updateScroll;
    public static long s_tProf_scrollStartTime;
    public static long s_tProf_scrollTimer;
    public static boolean s_tProf_isIndicatorEnabled;
    public static boolean s_tProf_isDefaultProfilingEnabled;
    public static long s_tProf_keyHeldTimer;
    public static long s_tProf_keyHeldTime;
    public static boolean s_tProf_isDrawReport;
    private static int s_alphaRectCurrentARGB;
    private static int[] s_alphaRectARGBData;
    private static Image s_alphaRectImage;
    static final boolean pfx_usingScreenBuffer;
    static final boolean pfx_useSpriteEffects;
    private static boolean s_PFX_initializd;
    private static int s_PFX_type;
    private static int[][] s_PFX_params;
    static boolean s_PFX_hasAlpha;
    static int s_PFX_sizeX;
    static int s_PFX_sizeY;
    static int s_PFX_newSizeX;
    static int s_PFX_newSizeY;
    private static Image s_PFX_screenBuffer;
    private static Graphics s_PFX_screenBufferG;
    private static Image s_PFX_customBuffer;
    private static int s_PFX_enableScreenBuffer;
    private static int s_PFX_enableScreenBufferThisFrame;
    private static boolean s_PFX_screenIsBuffered;
    private static int s_PFX_windowX;
    private static int s_PFX_windowY;
    private static int s_PFX_windowWidth;
    private static int s_PFX_windowHeight;
    private static int s_PFX_timer;
    public static int s_pointerState;
    public static int s_pointerX;
    public static int s_pointerY;
    public static int s_prevPointerX;
    public static int s_prevPointerY;
    private static int s_tmpPrevPointerX;
    private static int s_tmpPrevPointerY;
    private static boolean s_isPointerPressedSystem;
    private static boolean s_isPointerReleasedSystem;
    private static boolean s_isPointerDraggedSystem;
    public static int s_currentPointer;
    public static int[] s_pointerX_multi;
    public static int[] s_pointerY_multi;
    public static int[] s_prevPointerX_multi;
    public static int[] s_prevPointerY_multi;
    public static int[] s_pointerState_multi;
    private static int[] s_tmpPrevPointerX_multi;
    private static int[] s_tmpPrevPointerY_multi;
    private static boolean[] s_isPointerPressedSystem_multi;
    private static boolean[] s_isPointerReleasedSystem_multi;
    private static boolean[] s_isPointerDraggedSystem_multi;

    abstract void Game_update() throws Exception;

    public void Game_Run() throws Exception {
    }

    public static void ModuleMarkerCallback_Start(ASprite aSprite, int n, int n2, int n3, int n4, boolean bl) {
    }

    public static void ModuleMarkerCallback_End(ASprite aSprite, int n, int n2, int n3, int n4, boolean bl) {
    }

    public GLLib(Object object, Object object2) {
        s_gllib_instance = this;
        s_game_state = -1;
        s_game_isInPaint = true;
        s_application = (MIDlet)object;
        s_display = (Display)object2;
        this.SetupDisplay();
        GLLib.SetupDefaultKey();
        this.m_frameCoheranceTimer = s_game_frameDTTimer = System.currentTimeMillis();
    }

    protected void UnInit() {
        if (false) {
            s_keyState = null;
            s_keyStateRT = null;
        }
        if (true || false) {
            m_imgBackBuffer = null;
            m_gBackBuffer = null;
        }
        MIME_type = null;
        GLLib.Gc();
    }

    protected void Pause() {
        if (!s_game_isPaused) {
            s_game_isPaused = true;
            GLLibPlayer.Snd_PauseNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void Resume() {
        if (s_game_isPaused) {
            long l;
            s_game_timeWhenFrameStart = l = System.currentTimeMillis();
            s_game_frameDTTimer = l;
            this.m_frameCoheranceTimer = l;
            s_game_isPaused = false;
            this.SetupDisplay();
            s_game_interruptNotify = true;
            if (true && !s_game_isInPaint) {
                this.repaint();
            }
            GLLib.ResetKey();
        }
        if (false && !false && s_game_state >= 0) {
            GLLib gLLib = s_gllib_instance;
            synchronized (gLLib) {
                try {
                    this.notifyAll();
                }
                catch (IllegalMonitorStateException illegalMonitorStateException) {
                    // empty catch block
                }
            }
        }
    }

    public void hideNotify() {
        this.Pause();
    }

    public void showNotify() {
        this.Resume();
    }

    public void sizeChanged(int n, int n2) {
        if (!false && !false) {
            s_screenWidth = n;
            s_screenHeight = n2;
        }
    }

    protected void SetupDisplay() {
        if (!false) {
            this.setFullScreenMode(true);
        }
        if (s_display != null && s_display.getCurrent() != this) {
            s_display.setCurrent((Displayable)this);
        }
    }

    protected static void SetupDefaultKey() {
        GLLib.Game_KeyClearKeyCode();
        standardKeyTable.put(new Integer(48), new Integer(6));
        standardKeyTable.put(new Integer(49), new Integer(7));
        standardKeyTable.put(new Integer(50), new Integer(1));
        standardKeyTable.put(new Integer(51), new Integer(9));
        standardKeyTable.put(new Integer(52), new Integer(3));
        standardKeyTable.put(new Integer(53), new Integer(5));
        standardKeyTable.put(new Integer(54), new Integer(4));
        standardKeyTable.put(new Integer(55), new Integer(13));
        standardKeyTable.put(new Integer(56), new Integer(2));
        standardKeyTable.put(new Integer(57), new Integer(15));
        standardKeyTable.put(new Integer(35), new Integer(17));
        standardKeyTable.put(new Integer(42), new Integer(16));
        if (true) {
            standardKeyTable.put(new Integer(-6), new Integer(18));
            standardKeyTable.put(new Integer(-7), new Integer(19));
        } else {
            standardKeyTable.put(new Integer(-6), new Integer(19));
            standardKeyTable.put(new Integer(-7), new Integer(18));
        }
        standardKeyTable.put(new Integer(-8), new Integer(24));
        if (true) {
            standardKeyTable.put(new Integer(100), new Integer(22));
            standardKeyTable.put(new Integer(101), new Integer(23));
        }
        gameActionKeyTable.put(new Integer(-5), new Integer(5));
        gameActionKeyTable.put(new Integer(-1), new Integer(1));
        gameActionKeyTable.put(new Integer(-2), new Integer(2));
        gameActionKeyTable.put(new Integer(-3), new Integer(3));
        gameActionKeyTable.put(new Integer(-4), new Integer(4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!false) {
            // empty if block
        }
        try {
            if (!false) {
                this.SetupDisplay();
            }
            s_game_isInPaint = false;
            while (s_game_state >= 0) {
                if (false) {
                    GLLib.Time_Profiler_UpdateKey();
                }
                if (false) {
                    GLLib.Dbg_Console_UpdateKey();
                }
                if (!s_game_isPaused) {
                    this.repaint();
                    if (true) {
                        this.serviceRepaints();
                    }
                    if (false) {
                        if (!s_tProf_isDrawReport) {
                            if (s_tProf_isDefaultProfilingEnabled) {
                                GLLib.Time_Profiler_StartSlot("UPDATE");
                            }
                            this.Game_Run();
                            if (s_tProf_isDefaultProfilingEnabled) {
                                GLLib.Time_Profiler_EndSlot("UPDATE");
                            }
                        }
                    } else {
                        this.Game_Run();
                    }
                    s_game_interruptNotify = false;
                    long l = System.currentTimeMillis();
                    this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, l);
                    if (false && m_customSleepTime >= 0) {
                        if (m_customSleepTime == 0) {
                            Thread.yield();
                        } else {
                            Thread.sleep(m_customSleepTime);
                        }
                    } else if (false) {
                        Thread.sleep(Math.max(1L, (long)m_FPSLimiter - (l - this.m_frameCoheranceTimer)));
                    } else {
                        while (l - this.m_frameCoheranceTimer < (long)m_FPSLimiter) {
                            Thread.yield();
                            l = System.currentTimeMillis();
                            this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, l);
                        }
                    }
                    this.m_frameCoheranceTimer = System.currentTimeMillis();
                } else if (false && !false) {
                    GLLib gLLib = s_gllib_instance;
                    synchronized (gLLib) {
                        if (s_game_isPaused) {
                            this.wait();
                        }
                    }
                } else {
                    this.m_frameCoheranceTimer = Math.min(this.m_frameCoheranceTimer, System.currentTimeMillis());
                    if (false) {
                        Thread.sleep(1);
                    } else {
                        Thread.yield();
                    }
                }
                if (false) {
                    GLLib.Time_Profiler_EndFrame();
                }
                if (!false) continue;
                s_display.callSerially((Runnable)this);
                return;
            }
        }
        catch (Exception exception) {
            s_game_state = -1;
        }
        this.UnInit();
        if (!false) {
            s_application.notifyDestroyed();
        }
    }

    public void paint(Graphics graphics) {
        this.Game_Paint(graphics);
    }

    private void Game_Paint(Graphics graphics) {
        if (false && s_tProf_isDefaultProfilingEnabled) {
            GLLib.Time_Profiler_StartSlot("RENDER");
        }
        s_screenGraphics = graphics;
        if (false) {
            long l = System.currentTimeMillis() - s_game_lastFrameTime;
            s_game_lastFrameTime = System.currentTimeMillis();
            if (l > (long)3000 && s_game_lastFrameTime != 0L) {
                this.Pause();
                this.Resume();
            }
        }
        if (s_game_isPaused || s_game_isInPaint) {
            return;
        }
        s_game_isInPaint = true;
        this.UpdateKeypad();
        if (false) {
            GLLib.Pointer_Reset();
            GLLib.Pointer_Update();
        }
        if (false && GLLib.WasKeyPressed(6)) {
            ASprite.s_debugSkipPaintModule = !ASprite.s_debugSkipPaintModule;
        }
        s_game_timeWhenFrameStart = System.currentTimeMillis();
        if (true) {
            s_game_frameDT = (int)(s_game_timeWhenFrameStart - s_game_frameDTTimer);
            if (s_game_frameDT < 0) {
                s_game_frameDT = 0;
            }
            if (s_game_frameDT > 1000) {
                s_game_frameDT = 1000;
            }
            s_game_frameDTTimer = s_game_timeWhenFrameStart;
            s_game_FPSAverage = 100000 * s_game_currentFrameNB / ((s_game_totalExecutionTime += s_game_frameDT) + 1);
        }
        ++s_game_currentFrameNB;
        try {
            if ((true || false) && m_bBackBufferEnabled) {
                g = s_lastPaintGraphics = m_gBackBuffer;
                this.Game_update();
                if (false) {
                    ASprite.ScaleAndBlitBuffer(graphics, m_imgBackBuffer);
                } else if (false) {
                    g = GLLib.GetScreenGraphics();
                    int n = GLLib.GetScreenHeight();
                    int n2 = GLLib.GetScreenWidth();
                    if (false) {
                        int n3 = 2;
                        int n4 = 4;
                        int n5 = n2 / n3;
                        int n6 = n / n4;
                        int n7 = 0;
                        int n8 = 0;
                        for (int i = 0; i < n3; ++i) {
                            for (int j = 0; j < n4; ++j) {
                                if (false) {
                                    GLLib.DrawRegion(m_imgBackBuffer, n7, n8, n5, n6, 6, n8, n2 - (n5 + n7), 20);
                                } else {
                                    GLLib.DrawRegion(m_imgBackBuffer, n7, n8, n5, n6, 5, n - (n8 + n6), n7, 20);
                                }
                                n8 += n6;
                            }
                            n7 += n5;
                            n8 = 0;
                        }
                    } else if (false) {
                        GLLib.DrawRegion(m_imgBackBuffer, 0, 0, n2, n, 6, 0, 0, 20);
                    } else {
                        GLLib.DrawRegion(m_imgBackBuffer, 0, 0, n2, n, 5, 0, 0, 20);
                    }
                } else {
                    graphics.drawImage(m_imgBackBuffer, 0, 0, 20);
                }
            } else {
                g = pfx_usingScreenBuffer && GLLib.PFX_NeedScreenBufferThisFrame() ? (s_lastPaintGraphics = s_PFX_screenBufferG) : (s_lastPaintGraphics = graphics);
                this.Game_update();
                if (pfx_usingScreenBuffer && s_PFX_initializd) {
                    boolean bl = false;
                    if (true) {
                        if (s_PFX_params[1][4] != 0) {
                            bl = true;
                        }
                        GLLib.s_PFX_params[1][4] = 0;
                    }
                    if (GLLib.PFX_NeedScreenBufferThisFrame()) {
                        if (!bl) {
                            g = s_lastPaintGraphics = graphics;
                            if (false) {
                                GLLib.DrawImage(graphics, s_PFX_screenBuffer, 0, 0, 20, false);
                            } else {
                                GLLib.DrawImage(graphics, s_PFX_screenBuffer, 0, 0, 20);
                            }
                        }
                        s_PFX_enableScreenBufferThisFrame = 0;
                    }
                }
            }
        }
        catch (Exception exception) {
            s_game_state = -1;
        }
        if (0 > 0 && 0 > 0) {
            if (Runtime.getRuntime().totalMemory() > (long)0 && Runtime.getRuntime().freeMemory() < (long)0) {
                System.gc();
            }
        } else if (0 > 0 && Runtime.getRuntime().totalMemory() > (long)0) {
            System.gc();
        } else if (0 > 0 && Runtime.getRuntime().freeMemory() < (long)0) {
            System.gc();
        }
        s_game_isInPaint = false;
        s_screenGraphics = null;
        if (false) {
            if (s_tProf_isDefaultProfilingEnabled) {
                GLLib.Time_Profiler_EndSlot("RENDER");
            }
            GLLib.Time_Profiler_OutputInfo();
        }
        if (false) {
            GLLib.Dbg_Console_OutputToScreen();
        }
    }

    public static final Graphics GetScreenGraphics() {
        return s_screenGraphics;
    }

    protected void keyPressed(int n) {
        if (false) {
            if (m_last_key_pressed != n && m_last_key_pressed != -9999) {
                this.keyReleased(m_last_key_pressed);
            }
            m_last_key_pressed = n;
        }
        if (false) {
            s_keyLastKeyPressUntranslatedCode = n;
            byte by = this.Game_TranslateKeyCode(n);
            if (s_keyStateRT == null) {
                return;
            }
            if (s_keyStateRT[by] > 0) {
                return;
            }
            if (s_keyStateRT[by] < 0) {
                GLLib.s_keyStateRT[by] = 0;
            }
            if (s_keyStateRT[by] < 126) {
                byte by2 = by;
                s_keyStateRT[by2] = (byte)(s_keyStateRT[by2] + 1);
            }
        } else {
            s_keyLastKeyPressUntranslatedCode = n;
            int n2 = 1 << this.Game_TranslateKeyCode(n);
            m_current_keys_pressed |= n2;
            m_current_keys_state |= n2;
        }
    }

    protected void keyReleased(int n) {
        if (false && n == m_last_key_pressed) {
            m_last_key_pressed = -9999;
        }
        if (false) {
            byte by = this.Game_TranslateKeyCode(n);
            if (s_keyStateRT == null) {
                return;
            }
            if (s_keyStateRT[by] > 0) {
                byte by2 = by;
                s_keyStateRT[by2] = (byte)(s_keyStateRT[by2] * -1);
            }
        } else {
            int n2 = 1 << this.Game_TranslateKeyCode(n);
            m_current_keys_released |= n2;
            m_current_keys_state &= ~n2;
        }
    }

    private void UpdateKeypad() {
        if (false) {
            s_game_keyEventIndex = -1;
            s_game_keyJustPressed = -1;
            for (int i = 0; i < s_nbKey; ++i) {
                GLLib.s_keyState[i] = s_keyStateRT[i];
                if (s_keyStateRT[i] == 0) continue;
                s_game_keyEventIndex = i;
                if (s_keyStateRT[i] < 0) {
                    GLLib.s_keyStateRT[i] = 0;
                    continue;
                }
                if (s_keyStateRT[i] >= 126) continue;
                if (s_keyStateRT[i] == 1) {
                    s_game_keyJustPressed = i;
                    s_game_keyPressedTime = s_game_timeWhenFrameStart;
                }
                int n = i;
                s_keyStateRT[n] = (byte)(s_keyStateRT[n] + 1);
                if (i < 18) continue;
                int n2 = i;
                s_keyStateRT[n2] = (byte)(s_keyStateRT[n2] * -1);
            }
        } else {
            m_keys_pressed = m_current_keys_pressed;
            m_keys_released = m_current_keys_released;
            m_keys_state = m_current_keys_state;
            m_current_keys_pressed = 0;
            m_current_keys_released = 0;
            s_game_keyPressedTime = s_game_timeWhenFrameStart;
        }
        if (s_keysDisabledTimer > 0) {
            if (true && s_keysDisabledTimer != Integer.MAX_VALUE) {
                s_keysDisabledTimer -= s_game_frameDT;
            }
            GLLib.ResetKey();
        }
    }

    public static void Game_KeyClearKeyCode() {
        gameActionKeyTable = new Hashtable();
        standardKeyTable = new Hashtable();
    }

    private byte Game_TranslateKeyCode(int n) {
        if (false && n < 0) {
            n *= -1;
        }
        Integer n2 = new Integer(n);
        if (standardKeyTable == null) {
            return 0;
        }
        Integer n3 = (Integer)standardKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        n3 = (Integer)gameActionKeyTable.get(n2);
        if (n3 != null) {
            return n3.byteValue();
        }
        return 0;
    }

    public static void ResetKey() {
        if (false) {
            if (s_keyState != null && s_keyStateRT != null) {
                for (int i = 0; i < s_nbKey; ++i) {
                    GLLib.s_keyState[i] = 0;
                    GLLib.s_keyStateRT[i] = 0;
                }
            }
        } else {
            m_keys_pressed = 0;
            m_keys_released = 0;
            m_keys_state = 0;
            m_current_keys_state = 0;
            m_current_keys_pressed = 0;
            m_current_keys_released = 0;
        }
    }

    public static int IsAnyKeyDown() {
        if (false) {
            int n = s_nbKey;
            while (--n >= 0) {
                if (s_keyState[n] <= 0) continue;
                return n;
            }
            return -1;
        }
        int n = s_nbKey;
        while (--n >= 0) {
            if ((m_keys_state & 1 << n) == 0) continue;
            return n;
        }
        return -1;
    }

    public static int WasAnyKeyPressed() {
        if (false) {
            int n = s_nbKey;
            while (--n >= 0) {
                if (s_keyState[n] != 1) continue;
                return n;
            }
            return -1;
        }
        if (m_keys_pressed == 0) {
            return -1;
        }
        int n = s_nbKey;
        while (--n >= 0) {
            if ((m_keys_pressed & 1 << n) == 0) continue;
            return n;
        }
        return -1;
    }

    public static boolean WasKeyPressed(int n) {
        if (false) {
            return s_keyState[n] == 1;
        }
        return (m_keys_pressed & 1 << n) != 0;
    }

    static void Dbg(String string) {
    }

    private static void Dbg_Console_Init() {
        if (false) {
            System.out.println("WARNING: SCREEN CONSOLE SUPPORTED!");
            s_dbg_console_logs = new String[s_dbg_console_logSlotsSize];
            if (s_dbg_console_recordLogCurrentTime) {
                s_dbg_console_logs_time = new long[s_dbg_console_logSlotsSize];
            }
            s_dbg_console_firstVisibleLogSlot = 0;
            s_dbg_console_nextAvailableLogSlot = 0;
            if (false) {
                s_dbg_console_touchActionAreas = new int[4][4];
                GLLib.s_dbg_console_touchActionAreas[0] = new int[]{0, 0, 50, 50};
                GLLib.s_dbg_console_touchActionAreas[1] = new int[]{320 - 50, 0, 50, 50};
                GLLib.s_dbg_console_touchActionAreas[2] = new int[]{320 - 50, 240 - 50, 50, 50};
                GLLib.s_dbg_console_touchActionAreas[3] = new int[]{0, 240 - 50, 50, 50};
            }
        }
    }

    public static void Dbg_Console_Add(Object object) {
        if (false) {
            if (s_dbg_console_logs == null) {
                GLLib.Dbg_Console_Init();
            }
            if (s_dbg_console_nextAvailableLogSlot == s_dbg_console_logSlotsSize) {
                String[] stringArray = new String[s_dbg_console_logSlotsSize - 1];
                System.arraycopy(s_dbg_console_logs, 1, stringArray, 0, s_dbg_console_logSlotsSize - 1);
                System.arraycopy(stringArray, 0, s_dbg_console_logs, 0, s_dbg_console_logSlotsSize - 1);
                --s_dbg_console_nextAvailableLogSlot;
            }
            if (s_dbg_console_recordLogCurrentTime) {
                GLLib.s_dbg_console_logs_time[GLLib.s_dbg_console_nextAvailableLogSlot] = System.currentTimeMillis();
            }
            GLLib.s_dbg_console_logs[GLLib.s_dbg_console_nextAvailableLogSlot++] = object.toString();
            if (s_dbg_console_forceFocusNextAvailableSlot && s_dbg_console_nextAvailableLogSlot - s_dbg_console_firstVisibleLogSlot > s_dbg_console_nbVisibleSlots) {
                ++s_dbg_console_firstVisibleLogSlot;
            }
        }
    }

    public static void Dbg_Console_Reset() {
        if (false) {
            GLLib.Dbg_Console_Init();
        }
    }

    private static void Dbg_Console_UpdateKey() {
        if (false) {
            if (false && s_dbg_console_touchActionAreas == null) {
                GLLib.Dbg_Console_Init();
            }
            int n = GLLib.WasAnyKeyPressed();
            if (false && GLLib.Pointer_IsPressed() && GLLib.Pointer_IsInRect(s_dbg_console_touchActionAreas[0])) {
                n = 17;
            }
            if (n == 17) {
                s_dbg_console_keyHeldTime = System.currentTimeMillis();
                if (!s_dbg_console_isScreenConsoleEnabled) {
                    s_dbg_console_keyHeldTimer = 0L;
                }
            }
            int n2 = GLLib.IsAnyKeyDown();
            if (false && GLLib.Pointer_IsHeldDown() && GLLib.Pointer_IsInRect(s_dbg_console_touchActionAreas[0])) {
                n2 = 17;
            }
            if (n2 == 17) {
                long l = System.currentTimeMillis();
                s_dbg_console_keyHeldTimer += l - s_dbg_console_keyHeldTime;
                s_dbg_console_keyHeldTime = l;
                if (s_dbg_console_keyHeldTimer > 2000L) {
                    s_dbg_console_isScreenConsoleEnabled = !s_dbg_console_isScreenConsoleEnabled;
                    s_dbg_console_keyHeldTimer = 0L;
                }
            } else {
                s_dbg_console_keyHeldTimer = 0L;
            }
            s_dbg_console_currentAction = -1;
            if (n2 == 1 || n2 == 8 || false && (GLLib.Pointer_IsPressed() || GLLib.Pointer_IsHeldDown()) && GLLib.Pointer_IsInRect(s_dbg_console_touchActionAreas[1])) {
                s_dbg_console_currentAction = 1;
            } else if (n2 == 2 || n2 == 14 || false && (GLLib.Pointer_IsPressed() || GLLib.Pointer_IsHeldDown()) && GLLib.Pointer_IsInRect(s_dbg_console_touchActionAreas[2])) {
                s_dbg_console_currentAction = 2;
            } else if (n2 == 3 || n2 == 10 || false && GLLib.Pointer_IsPressed() && GLLib.Pointer_IsInRect(s_dbg_console_touchActionAreas[3])) {
                s_dbg_console_currentAction = 3;
            }
            if (s_dbg_console_isScreenConsoleEnabled) {
                if (s_dbg_console_currentAction == 1) {
                    if (s_dbg_console_firstVisibleLogSlot > 0) {
                        --s_dbg_console_firstVisibleLogSlot;
                    }
                } else if (s_dbg_console_currentAction == 2) {
                    if (s_dbg_console_firstVisibleLogSlot + s_dbg_console_nbVisibleSlots < s_dbg_console_nextAvailableLogSlot) {
                        ++s_dbg_console_firstVisibleLogSlot;
                    }
                } else if (s_dbg_console_currentAction == 3) {
                    GLLib.Dbg_Console_Reset();
                }
            }
        }
    }

    private static void Dbg_Console_OutputToScreen() {
        if (false) {
            if (!s_dbg_console_isScreenConsoleEnabled) {
                if (g != null) {
                    String string = "WARNING: SCREEN CONSOLE SUPPORTED!";
                    GLLib.SetColor(s_dbg_console_fontBackgroundColor);
                    GLLib.FillRect(0, 0, GLLib.GetFont().stringWidth(string), GLLib.GetFont().getHeight());
                    GLLib.SetColor(s_dbg_console_fontColor);
                    GLLib.DrawString(string, 0, 0, 20);
                }
                return;
            }
            int n = s_dbg_console_firstVisibleLogSlot;
            int n2 = n + s_dbg_console_nbVisibleSlots;
            if (s_dbg_console_nextAvailableLogSlot < n + s_dbg_console_nbVisibleSlots) {
                n2 = s_dbg_console_nextAvailableLogSlot;
            }
            if (s_dbg_console_nextAvailableLogSlot == 0) {
                GLLib.Dbg_Console_Add("All debug log slots are emtpy!");
            }
            if (g != null) {
                int n3;
                int n4;
                boolean bl = false;
                int n5 = 0;
                for (n4 = n; n4 < n2; ++n4) {
                    String string = "";
                    String string2 = "[" + n4 + "]='" + s_dbg_console_logs[n4] + "'";
                    if (s_dbg_console_recordLogCurrentTime && n4 > 0) {
                        string2 = string2 + ",dt=" + (s_dbg_console_logs_time[n4] - s_dbg_console_logs_time[n4 - 1]) + "ms";
                    }
                    char[] cArray = string2.toCharArray();
                    n3 = 0;
                    for (int i = 0; i < cArray.length; ++i) {
                        int n6 = GLLib.GetFont().charWidth(cArray[i]);
                        if (n3 + n6 > 320) {
                            GLLib.SetColor(s_dbg_console_fontBackgroundColor);
                            GLLib.FillRect(0, n5, n3, GLLib.GetFont().getHeight());
                            GLLib.SetColor(s_dbg_console_fontColor);
                            GLLib.DrawString(string, 0, n5, 20);
                            n3 = 0;
                            string = "";
                            n5 += GLLib.GetFont().getHeight();
                        }
                        string = string + cArray[i];
                        n3 += n6;
                    }
                    GLLib.SetColor(s_dbg_console_fontBackgroundColor);
                    GLLib.FillRect(0, n5, n3, GLLib.GetFont().getHeight());
                    GLLib.SetColor(s_dbg_console_fontColor);
                    GLLib.DrawString(string, 0, n5, 20);
                    n5 += GLLib.GetFont().getHeight();
                }
                for (n4 = 0; n4 < s_dbg_console_touchActionAreas.length; ++n4) {
                    int n7 = s_dbg_console_touchActionAreas[n4][0];
                    int n8 = s_dbg_console_touchActionAreas[n4][1];
                    int n9 = s_dbg_console_touchActionAreas[n4][2];
                    n3 = s_dbg_console_touchActionAreas[n4][3];
                    GLLib.SetColor(s_dbg_console_fontColor);
                    GLLib.DrawRect(n7, n8, n9, n3);
                }
            }
        }
    }

    static final int Math_IntToFixedPoint(int n) {
        return n << 8;
    }

    static final int Math_FixedPointToInt(int n) {
        return n + (1 << 8 - 1) >> 8;
    }

    static int Math_Rand(int n, int n2) {
        if (n2 != n) {
            int n3 = s_math_random.nextInt();
            if (n3 < 0) {
                n3 *= -1;
            }
            return n + n3 % (n2 - n);
        }
        return n2;
    }

    static final int Math_DegreeToFixedPointAngle(int n) {
        return n * Math_AngleMUL / 360;
    }

    static final int Math_Sin(int n) {
        return GLLib.Math_Cos(Math_Angle90 - n);
    }

    static int Math_Cos(int n) {
        if (n < 0) {
            n *= -1;
        }
        if ((n &= Math_Angle360 - 1) <= Math_Angle90) {
            return s_math_cosTable[n];
        }
        if (n < Math_Angle180) {
            n = Math_Angle180 - n;
            return -s_math_cosTable[n];
        }
        if (n <= Math_Angle270) {
            return -s_math_cosTable[n -= Math_Angle180];
        }
        n = Math_Angle360 - n;
        return s_math_cosTable[n];
    }

    static final boolean Math_RectIntersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n3 < n5) {
            return false;
        }
        if (n > n7) {
            return false;
        }
        if (n4 < n6) {
            return false;
        }
        return n2 <= n8;
    }

    static final int Math_FixedPoint_Add(int n, int n2) {
        return n + n2;
    }

    static final int Math_FixedPoint_Divide(int n, int n2) {
        return (int)(((long)n << 8 << 1) / (long)n2 + 1L) >> 1;
    }

    static final int Math_Abs(int n) {
        return Math.abs(n);
    }

    static final int Math_Max(int n, int n2) {
        return Math.max(n, n2);
    }

    static final int Math_Min(int n, int n2) {
        return Math.min(n, n2);
    }

    static String GetMIME(int n) {
        if (n >= MIME_type.length) {
            return "";
        }
        try {
            return new String(MIME_type[n], "UTF-8");
        }
        catch (Exception exception) {
            return "";
        }
    }

    static final int GetScreenWidth() {
        return s_screenWidth;
    }

    static final int GetScreenHeight() {
        return s_screenHeight;
    }

    static final int GetGraphicsWidth() {
        return ASprite._graphicsWidth;
    }

    static final int GetGraphicsHeight() {
        return ASprite._graphicsHeight;
    }

    static final void Gc() {
        if (true) {
            System.gc();
        }
    }

    static final void SetColor(int n) {
        g.setColor(n);
    }

    static final void SetColor(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(n << 16 | n2 << 8 | n3);
    }

    static final Font GetFont() {
        return g.getFont();
    }

    static final int GetClipX() {
        return GLLib.GetClipX(g);
    }

    static final int GetClipY() {
        return GLLib.GetClipY(g);
    }

    static final int GetClipWidth() {
        return GLLib.GetClipWidth(g);
    }

    static final int GetClipHeight() {
        return GLLib.GetClipHeight(g);
    }

    static final void SetClip(int n, int n2, int n3, int n4) {
        GLLib.SetClip(g, n, n2, n3, n4);
    }

    static final int GetClipX(Graphics graphics) {
        if (false && ASprite._customGraphics != null) {
            if (false) {
                return ASprite._customGraphicsClipY;
            }
            return ASprite._customGraphicsClipX;
        }
        if (false) {
            return graphics.getClipY();
        }
        return graphics.getClipX();
    }

    static final int GetClipY(Graphics graphics) {
        if (false && ASprite._customGraphics != null) {
            if (false) {
                return GLLib.GetGraphicsHeight() - ASprite._customGraphicsClipX - ASprite._customGraphicsClipW;
            }
            return ASprite._customGraphicsClipY;
        }
        if (false) {
            return GLLib.GetGraphicsHeight() - graphics.getClipX() - graphics.getClipWidth();
        }
        return graphics.getClipY();
    }

    static final int GetClipWidth(Graphics graphics) {
        if (false && ASprite._customGraphics != null) {
            if (false) {
                return ASprite._customGraphicsClipH;
            }
            return ASprite._customGraphicsClipW;
        }
        if (false) {
            return graphics.getClipHeight();
        }
        return graphics.getClipWidth();
    }

    static final int GetClipHeight(Graphics graphics) {
        if (false && ASprite._customGraphics != null) {
            if (false) {
                return ASprite._customGraphicsClipW;
            }
            return ASprite._customGraphicsClipH;
        }
        if (false) {
            return graphics.getClipWidth();
        }
        return graphics.getClipHeight();
    }

    static final void ClipRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n;
            n = GLLib.GetGraphicsHeight() - n2 - n4;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (false && ASprite._customGraphics != null) {
            ASprite._customGraphicsClipW += ASprite._customGraphicsClipX;
            ASprite._customGraphicsClipH += ASprite._customGraphicsClipY;
            ASprite._customGraphicsClipX = ASprite._customGraphicsClipX > n ? ASprite._customGraphicsClipX : n;
            ASprite._customGraphicsClipY = ASprite._customGraphicsClipY > n2 ? ASprite._customGraphicsClipY : n2;
            ASprite._customGraphicsClipW = ASprite._customGraphicsClipW < n3 ? ASprite._customGraphicsClipW : (n3 += n);
            ASprite._customGraphicsClipH = ASprite._customGraphicsClipH < n4 ? ASprite._customGraphicsClipH : (n4 += n2);
            ASprite._customGraphicsClipW -= ASprite._customGraphicsClipX;
            ASprite._customGraphicsClipH -= ASprite._customGraphicsClipY;
        } else {
            graphics.clipRect(n, n2, n3, n4);
        }
    }

    static final void SetClip(Graphics graphics, int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n;
            n = GLLib.GetGraphicsHeight() - n2 - n4;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        if (false && ASprite._customGraphics != null) {
            ASprite._customGraphicsClipX = n;
            ASprite._customGraphicsClipY = n2;
            ASprite._customGraphicsClipW = n3;
            ASprite._customGraphicsClipH = n4;
        } else {
            graphics.setClip(n, n2, n3, n4);
            if (false) {
                graphics.clipRect(n, n2, n3, n4);
            }
        }
    }

    static final boolean IsClipValid(Graphics graphics) {
        if (false && ASprite._customGraphics != null) {
            return true;
        }
        return graphics != null;
    }

    static final void DrawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        if (false) {
            n5 = n;
            n = GLLib.GetGraphicsHeight() - n2 - 1;
            n2 = n5;
            n5 = n3;
            n3 = GLLib.GetGraphicsHeight() - n4 - 1;
            n4 = n5;
        }
        if (false && ASprite._customGraphics != null) {
            ASprite.DrawLineARGB(ASprite._customGraphics, ASprite._customGraphicsWidth, ASprite._customGraphicsHeight, ASprite._customGraphicsAlpha, n, n2, n3, n4, 0xFF000000 | graphics.getColor());
        } else {
            if (false && ASprite.s_resizeOn) {
                n = ASprite.scaleX(n);
                n2 = ASprite.scaleY(n2);
                n3 = ASprite.scaleX(n3);
                n4 = ASprite.scaleY(n4);
            }
            if (false && n2 > n4) {
                n5 = n;
                n = n3;
                n3 = n5;
                n5 = n2;
                n2 = n4;
                n4 = n5;
            }
            graphics.drawLine(n, n2, n3, n4);
        }
    }

    static final void FillRect(int n, int n2, int n3, int n4) {
        GLLib.FillRect(g, n, n2, n3, n4);
    }

    static final void FillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n;
            n = GLLib.GetGraphicsHeight() - n2 - n4;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        if (false && ASprite._customGraphics != null) {
            ASprite.FillRectARGB(ASprite._customGraphics, ASprite._customGraphicsWidth, ASprite._customGraphicsHeight, ASprite._customGraphicsAlpha, n, n2, n3, n4, 0xFF000000 | graphics.getColor());
        } else if (false) {
            Image image = Image.createImage((int)n3, (int)n4);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(graphics.getColor());
            graphics2.fillRect(0, 0, n3, n4);
            graphics.drawImage(image, n, n2, 0);
        } else {
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    static final void DrawRect(int n, int n2, int n3, int n4) {
        GLLib.DrawRect(g, n, n2, n3, n4);
    }

    static final void DrawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        if (false) {
            int n5 = n;
            n = s_screenHeight - n2 - n4 - 1;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        if (false && ASprite._customGraphics != null) {
            ASprite.DrawRectARGB(ASprite._customGraphics, ASprite._customGraphicsWidth, ASprite._customGraphicsHeight, ASprite._customGraphicsAlpha, n, n2, n3, n4, 0xFF000000 | graphics.getColor());
        } else {
            graphics.drawRect(n, n2, n3, n4);
        }
    }

    static final void DrawRoundRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (false) {
            int n7 = n;
            n = s_screenHeight - n2 - n4;
            n2 = n7;
            n7 = n3;
            n3 = n4;
            n4 = n7;
            n7 = n5;
            n5 = n6;
            n6 = n7;
        }
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    static final void FillArc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (false) {
            int n7 = n;
            n = GLLib.GetGraphicsHeight() - n2 - n4;
            n2 = n7;
            n7 = n3;
            n3 = n4;
            n4 = n7;
            n5 -= 90;
        }
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    static final void DrawArc(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (false) {
            int n7 = n;
            n = GLLib.GetGraphicsHeight() - n2 - n4;
            n2 = n7;
            n7 = n3;
            n3 = n4;
            n4 = n7;
            n5 -= 90;
        }
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    private static final int transformAnchorForText(int n) {
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFD;
            n |= 0x40;
        }
        return n;
    }

    static final void DrawString(String string, int n, int n2, int n3) {
        n3 = GLLib.transformAnchorForText(n3);
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
        }
        try {
            g.drawString(string, n, n2, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final void DrawImage(Graphics graphics, Image image, int n, int n2, int n3) {
        GLLib.DrawImage(graphics, image, n, n2, n3, true);
    }

    static final void DrawImage(Graphics graphics, Image image, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        int n5 = 0;
        if (false) {
            n4 = image.getWidth();
            n5 = image.getHeight();
        }
        if (false && ASprite._customGraphics != null) {
            n4 = image.getWidth();
            n5 = image.getHeight();
            if ((n3 & 8) == 8) {
                n -= n4;
            } else if ((n3 & 1) == 1) {
                n -= n4 >> 1;
            }
            if ((n3 & 0x20) == 32) {
                n2 -= n5;
            } else if ((n3 & 2) == 2) {
                n2 -= n5 >> 1;
            }
            int[] nArray = ASprite.GetPixelBuffer_int(null);
            int n6 = nArray.length / n4;
            int n7 = 0;
            while (n6 != 0) {
                n6 = n6 < n5 - n7 ? n6 : n5 - n7;
                GLLib.GetRGB(image, nArray, 0, n4, 0, n7, n4, n6);
                GLLib.DrawRGB(graphics, nArray, 0, n4, n, n2 + n7, n4, n6, false);
                n7 += n6;
            }
        } else if (false && (n4 > 1000 || n5 > 1000)) {
            int n8;
            int n9;
            int n10;
            int n11;
            if ((n3 & 8) == 8) {
                n -= n4;
            } else if ((n3 & 1) == 1) {
                n -= n4 >> 1;
            }
            if ((n3 & 0x20) == 32) {
                n2 -= n5;
            } else if ((n3 & 2) == 2) {
                n2 -= n5 >> 1;
            }
            int n12 = 1000;
            int n13 = 1000;
            int n14 = n4;
            int n15 = n5;
            int n16 = 0;
            int n17 = 0;
            int n18 = n;
            int n19 = n2;
            int n20 = n12;
            int n21 = n13;
            if (false && !bl) {
                n11 = GLLib.GetClipHeight(graphics);
                n10 = GLLib.GetGraphicsHeight() - GLLib.GetClipY(graphics) - n11;
                n9 = GLLib.GetClipX(graphics);
                n8 = GLLib.GetClipWidth(graphics);
            } else {
                n10 = GLLib.GetClipX(graphics);
                n9 = GLLib.GetClipY(graphics);
                n11 = GLLib.GetClipWidth(graphics);
                n8 = GLLib.GetClipHeight(graphics);
            }
            if (n10 > n18) {
                n16 = n10 - n18;
                n14 -= n16;
                n18 = n10;
            }
            if (n10 + n11 < n18 + n14) {
                n14 -= n18 + n14 - (n10 + n11);
            }
            if (n9 > n19) {
                n17 = n9 - n19;
                n15 -= n17;
                n19 = n9;
            }
            if (n9 + n8 < n19 + n15) {
                n15 -= n19 + n15 - (n9 + n8);
            }
            if (n14 < n20) {
                n20 = n14;
            }
            if (n15 < n21) {
                n21 = n15;
            }
            int n22 = n20;
            int n23 = n16;
            int n24 = n14;
            int n25 = n18;
            while (n15 > 0) {
                while (n14 > 0) {
                    GLLib.DrawRegion(image, n16, n17, n20, n21, 0, n18, n19, 20, bl);
                    n16 += n20;
                    n18 += n20;
                    if ((n14 -= n20) >= n20) continue;
                    n20 = n14;
                }
                n17 += n21;
                n19 += n21;
                if ((n15 -= n21) < n21) {
                    n21 = n15;
                }
                n18 = n25;
                n16 = n23;
                n20 = n22;
                n14 = n24;
            }
        } else {
            try {
                if (false && bl) {
                    GLLib.DrawRegion(image, 0, 0, image.getWidth(), image.getHeight(), 0, n, n2, n3);
                }
                graphics.drawImage(image, n, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final void DrawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        GLLib.DrawRegion(image, n, n2, n3, n4, n5, n6, n7, n8, true);
    }

    private static final void DrawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        if (false && bl) {
            n10 = 0;
            if ((n8 & 4) != 0) {
                n10 |= 0x10;
            }
            if ((n8 & 8) != 0) {
                n10 |= 0x20;
            }
            if ((n8 & 0x10) != 0) {
                n10 |= 8;
            }
            if ((n8 & 0x20) != 0) {
                n10 |= 4;
            }
            if ((n8 & 1) != 0) {
                n10 |= 2;
            }
            if ((n8 & 2) != 0) {
                n10 |= 1;
            }
            if (n5 == 0) {
                n5 = 5;
            } else if (n5 == 5) {
                n5 = 3;
            } else if (n5 == 3) {
                n5 = 6;
            } else if (n5 == 6) {
                n5 = 0;
            } else if (n5 == 2) {
                n5 = 7;
            }
            n9 = n6;
            n6 = GLLib.GetGraphicsHeight() - n7;
            n7 = n9;
            n8 = n10;
        }
        if (true) {
            if (n < 0) {
                n3 += n;
                n = 0;
            }
            if (n + n3 >= image.getWidth()) {
                n3 += image.getWidth() - (n + n3);
            }
            if (n2 < 0) {
                n4 += n2;
                n2 = 0;
            }
            if (n2 + n4 >= image.getHeight()) {
                n4 += image.getHeight() - (n2 + n4);
            }
            if (n4 <= 0 || n3 <= 0) {
                return;
            }
        }
        if (false && (n5 == 5 || n5 == 6 || n5 == 7)) {
            n10 = n4;
            n9 = n3;
            if ((n8 & 8) != 0) {
                n6 -= n10;
            } else if ((n8 & 1) != 0) {
                n6 -= n10 >> 1;
            }
            if ((n8 & 0x20) != 0) {
                n7 -= n9;
            }
            if ((n8 & 2) != 0) {
                n7 -= n9 >> 1;
            }
            n8 = 20;
        }
        try {
            if (false) {
                Image image2 = Image.createImage((Image)image, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
                g.drawImage(image2, n6, n7, n8);
            } else {
                g.drawRegion(image, n, n2, n3, n4, n5, n6, n7, n8);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final void FillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        if (true) {
            GLLib.DrawLine(graphics, n, n2, n3, n4);
            GLLib.DrawLine(graphics, n, n2, n5, n6);
            GLLib.DrawLine(graphics, n5, n6, n3, n4);
        }
        if (false) {
            int n7 = n;
            n = GLLib.GetGraphicsHeight() - n2;
            n2 = n7;
            n7 = n3;
            n3 = GLLib.GetGraphicsHeight() - n4;
            n4 = n7;
            n7 = n5;
            n5 = GLLib.GetGraphicsHeight() - n6;
            n6 = n7;
        }
        graphics.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    static final Image CreateRGBImage(int[] nArray, int n, int n2, boolean bl) {
        Image image = null;
        image = false ? Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true) : Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)bl);
        return image;
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        GLLib.DrawRGB(graphics, nArray, n, n2, n3, n4, n5, n6, bl, true, 0);
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7) {
        GLLib.DrawRGB(graphics, nArray, n, n2, n3, n4, n5, n6, bl, bl2, n7, -1);
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, int n8) {
        GLLib.DrawRGB(graphics, nArray, n, n2, n3, n4, n5, n6, bl, bl2, n7, n8, true);
    }

    static final void DrawRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, int n7, int n8, boolean bl3) {
        int n9;
        int n10;
        if (false && bl3) {
            n10 = n6;
            if ((n7 & 4) != 0) {
                n10 = n5;
                n7 = ((n7 &= 0xFFFFFFFB) & 2) != 0 ? (n7 &= 0xFFFFFFFD) : (n7 |= 2);
                n7 = (n7 & 1) != 0 ? (n7 &= 0xFFFFFFFE) : (n7 |= 1);
            } else {
                n7 |= 4;
            }
            n9 = n3;
            n3 = GLLib.GetGraphicsHeight() - n4 - n10;
            n4 = n9;
        }
        if (false && ASprite._customGraphics != null) {
            if (false && n8 >= 0) {
                ASprite.BlitARGB(ASprite._customGraphics, ASprite._customGraphicsWidth, ASprite._customGraphicsHeight, ASprite._customGraphicsAlpha, n3, n4, nArray, n5, n6, 3, n7, n8);
            } else {
                ASprite.BlitARGB(ASprite._customGraphics, ASprite._customGraphicsWidth, ASprite._customGraphicsHeight, ASprite._customGraphicsAlpha, n3, n4, nArray, n5, n6, bl ? (bl2 ? 2 : 1) : 0, n7, -1);
            }
        } else {
            if (n7 != 0) {
                n10 = 0;
                if ((n7 & 4) != 0) {
                    n10 = n5;
                    n5 = n6;
                    n6 = n2;
                    n2 = n5;
                }
                nArray = ASprite.TransformRGB(nArray, n5, n6, n7);
                if ((n7 & 4) != 0) {
                    n6 = n10;
                }
            }
            if (false) {
                Image image = GLLib.CreateRGBImage(nArray, n5, n6, bl);
                graphics.drawImage(image, n3, n4, 0);
            } else if (false || false) {
                if (graphics == s_lastPaintGraphics) {
                    GLLib.drawPartialRGB(graphics, nArray, n2, n % n2, n / n2, n3, n4, n5, n6, bl);
                } else {
                    GLLib.drawPartialRGB(graphics, graphics.getClipX() + graphics.getClipWidth(), graphics.getClipY() + graphics.getClipHeight(), nArray, n2, n % n2, n / n2, n3, n4, n5, n6, bl);
                }
            } else if (false) {
                n10 = graphics.getTranslateX();
                n9 = graphics.getTranslateY();
                graphics.translate(-n10, -n9);
                graphics.drawRGB(nArray, n, n2, n3 + n10, n4 + n9, n5, n6, bl);
                graphics.translate(n10, n9);
            } else {
                graphics.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
            }
        }
    }

    public static final void drawPartialRGB(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (false) {
            GLLib.drawPartialRGB(graphics, GLLib.GetScreenHeight(), GLLib.GetScreenWidth(), nArray, n, n2, n3, n4, n5, n6, n7, bl);
        } else {
            GLLib.drawPartialRGB(graphics, GLLib.GetScreenWidth(), GLLib.GetScreenHeight(), nArray, n, n2, n3, n4, n5, n6, n7, bl);
        }
    }

    public static final void drawPartialRGB(Graphics graphics, int n, int n2, int[] nArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl) {
        int n10;
        int n11;
        int n12;
        int n13 = 0;
        int n14 = 0;
        if (false) {
            n13 = graphics.getTranslateX();
            n14 = graphics.getTranslateY();
            graphics.translate(-n13, -n14);
            n6 += n13;
            n7 += n14;
        }
        int n15 = n4 + n5 * n3;
        if (graphics == s_lastPaintGraphics || false) {
            if (n6 >= n || n6 + n8 <= 0 || n7 >= n2 || n7 + n9 <= 0) {
                return;
            }
            if (false) {
                int n16 = GLLib.GetClipX();
                n12 = GLLib.GetClipY();
                n11 = GLLib.GetClipWidth();
                n10 = GLLib.GetClipHeight();
                if (n16 >= n || n16 + n11 <= 0 || n12 >= n2 || n12 + n10 <= 0) {
                    return;
                }
            }
            if (n6 <= 0) {
                n15 -= n6;
                n8 += n6;
                n6 = 0;
            }
            if (n6 + n8 >= n) {
                n8 = n - n6;
            }
            if (n7 + n9 >= n2) {
                n9 = n2 - n7;
            }
            if (n7 <= 0) {
                n15 -= n7 * n3;
                n9 += n7;
                n7 = 0;
            }
        }
        if (false && n15 > 0) {
            int[] nArray2 = ASprite.GetPixelBuffer_int(nArray);
            if (nArray2.length < nArray.length - n15) {
                n12 = nArray2.length / n3;
                n11 = n9 / n12 + (n9 % n12 == 0 ? -1 : 0);
                n10 = n3 * n12;
                int n17 = n10 - n15 % n3;
                int n18 = n7 + n9;
                while (n11-- > 0) {
                    System.arraycopy(nArray, n15, nArray2, 0, n17);
                    graphics.drawRGB(nArray2, 0, n3, n6, n7, n8, n12, bl);
                    n7 += n12;
                    n15 += n10;
                }
                if (n7 + n12 > n18) {
                    int n19 = n7 + n12 - n18;
                    n12 -= n19;
                    n17 -= n3 * n19;
                }
                System.arraycopy(nArray, n15, nArray2, 0, n17);
                n9 = n12;
            } else {
                System.arraycopy(nArray, n15, nArray2, 0, nArray.length - n15);
            }
            nArray = nArray2;
            n15 = 0;
        }
        graphics.drawRGB(nArray, n15, n3, n6, n7, n8, n9, bl);
        if (false) {
            graphics.translate(n13, n14);
        }
    }

    static final int GetDisplayColor(int n) {
        if (-1 != -1 && (n & 0xFFFFFF) == 0xFF00FF) {
            return -1;
        }
        return g.getDisplayColor(n);
    }

    public static final Image CreateImage(byte[] byArray, int n, int n2) {
        if (false) {
            return GLLib.FixImageLackingTransparencyBug(Image.createImage((byte[])byArray, (int)n, (int)n2));
        }
        return Image.createImage((byte[])byArray, (int)n, (int)n2);
    }

    public static final Image FixImageLackingTransparencyBug(Image image) {
        int n = image.getWidth();
        int n2 = image.getHeight();
        int n3 = n * n2;
        Image image2 = Image.createImage((int)n, (int)n2);
        Graphics graphics = image2.getGraphics();
        graphics.setColor(0xFF00FF);
        graphics.fillRect(0, 0, n, n2);
        graphics.drawImage(image, 0, 0, 0);
        int[] nArray = ASprite.temp_int;
        if (nArray == null || nArray.length < n3) {
            nArray = new int[n * n2];
        }
        GLLib.GetRGB(image2, nArray, 0, n, 0, 0, n, n2);
        for (int i = n3 - 1; i >= 0; --i) {
            if ((nArray[i] & 0xFFFFFF) != 0xFF00FF) continue;
            nArray[i] = 0xFF00FF;
        }
        return Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)true);
    }

    public static final Image CreateImage(int n, int n2) {
        return Image.createImage((int)n, (int)n2);
    }

    public static final Graphics GetGraphics(Image image) {
        return image.getGraphics();
    }

    public static final void GetRGB(Image image, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        image.getRGB(nArray, n, n2, n3, n4, n5, n6);
        if (false) {
            int n7 = n + n5 * n6;
            while (n7-- > n) {
                if ((nArray[n7] & 0xFFFFFF) != 0xFF00FF) continue;
                nArray[n7] = 0xFF00FF;
            }
        }
    }

    public static void Time_Profiler_StartSlot(String string) {
        if (false) {
            if (!s_tProf_isProfilerEnabled || s_tProf_maxSlots <= 0) {
                return;
            }
            int n = -1;
            for (int i = s_tProf_maxSlots - 1; i > 0; --i) {
                if (s_tProf_profilerNames[i] == string) {
                    GLLib.s_tProf_profilerPool[i][5] = System.currentTimeMillis();
                    return;
                }
                if (s_tProf_profilerNames[i] != null) continue;
                n = i;
            }
            if (n == -1) {
                return;
            }
            GLLib.s_tProf_profilerNames[n] = string;
            GLLib.s_tProf_profilerPool[n][5] = System.currentTimeMillis();
            ++s_tProf_activeSlots;
        }
    }

    public static void Time_Profiler_EndSlot(String string) {
        if (false) {
            if (!s_tProf_isProfilerEnabled || s_tProf_maxSlots <= 0) {
                return;
            }
            for (int i = s_tProf_maxSlots - 1; i > 0; --i) {
                if (s_tProf_profilerNames[i] != string) continue;
                long l = System.currentTimeMillis() - s_tProf_profilerPool[i][5];
                if (l < s_tProf_profilerPool[i][12]) {
                    GLLib.s_tProf_profilerPool[i][12] = l;
                }
                if (l > s_tProf_profilerPool[i][13]) {
                    GLLib.s_tProf_profilerPool[i][13] = l;
                }
                long[] lArray = s_tProf_profilerPool[i];
                lArray[6] = lArray[6] + l;
                long[] lArray2 = s_tProf_profilerPool[i];
                lArray2[2] = lArray2[2] + 1L;
                long[] lArray3 = s_tProf_profilerPool[i];
                lArray3[3] = lArray3[3] + 1L;
                return;
            }
        }
    }

    private static void Time_Profiler_EndFrame() {
        if (false) {
            if (!s_tProf_isProfilerEnabled || s_tProf_maxSlots <= 0) {
                return;
            }
            for (int i = s_tProf_maxSlots - 1; i >= 0; --i) {
                if (s_tProf_profilerNames[i] == null) continue;
                if (i == 0) {
                    long l = System.currentTimeMillis();
                    if (s_tProf_profilerPool[i][5] == 0L) {
                        GLLib.s_tProf_profilerPool[i][5] = l - 1L;
                    }
                    long[] lArray = s_tProf_profilerPool[i];
                    lArray[6] = lArray[6] + (l - s_tProf_profilerPool[i][5]);
                    GLLib.s_tProf_profilerPool[i][5] = l;
                    long[] lArray2 = s_tProf_profilerPool[i];
                    lArray2[2] = lArray2[2] + 1L;
                    long[] lArray3 = s_tProf_profilerPool[i];
                    lArray3[3] = lArray3[3] + 1L;
                    if (s_tProf_profilerPool[i][6] <= 1000L) continue;
                    if (s_tProf_profilerPool[i][3] < s_tProf_profilerPool[i][7]) {
                        GLLib.s_tProf_profilerPool[i][7] = s_tProf_profilerPool[i][3];
                    }
                    if (s_tProf_profilerPool[i][3] > s_tProf_profilerPool[i][8]) {
                        GLLib.s_tProf_profilerPool[i][8] = s_tProf_profilerPool[i][3];
                    }
                    GLLib.s_tProf_profilerPool[i][10] = s_tProf_profilerPool[i][3];
                    GLLib.s_tProf_profilerPool[i][3] = 0L;
                    long[] lArray4 = s_tProf_profilerPool[i];
                    lArray4[1] = lArray4[1] + s_tProf_profilerPool[i][6];
                    GLLib.s_tProf_profilerPool[i][6] = 0L;
                    GLLib.s_tProf_profilerPool[i][9] = s_tProf_profilerPool[i][2] * 1000L / s_tProf_profilerPool[i][1];
                    continue;
                }
                if (s_tProf_profilerPool[i][3] > 0L) {
                    long[] lArray = s_tProf_profilerPool[i];
                    lArray[11] = lArray[11] + 1L;
                }
                if (s_tProf_profilerPool[i][6] < s_tProf_profilerPool[i][7]) {
                    GLLib.s_tProf_profilerPool[i][7] = s_tProf_profilerPool[i][6];
                }
                if (s_tProf_profilerPool[i][6] > s_tProf_profilerPool[i][8]) {
                    GLLib.s_tProf_profilerPool[i][8] = s_tProf_profilerPool[i][6];
                }
                long[] lArray = s_tProf_profilerPool[i];
                lArray[1] = lArray[1] + s_tProf_profilerPool[i][6];
                GLLib.s_tProf_profilerPool[i][10] = s_tProf_profilerPool[i][6];
                GLLib.s_tProf_profilerPool[i][6] = 0L;
                GLLib.s_tProf_profilerPool[i][9] = s_tProf_profilerPool[i][1] / s_tProf_profilerPool[i][2];
                GLLib.s_tProf_profilerPool[i][4] = s_tProf_profilerPool[i][3];
                GLLib.s_tProf_profilerPool[i][3] = 0L;
                GLLib.s_tProf_profilerPool[i][14] = s_tProf_profilerPool[i][1] / s_tProf_profilerPool[i][11];
            }
        }
    }

    private static void Time_Profiler_ResetProfilingInfo() {
        if (false) {
            for (int i = s_tProf_maxSlots - 1; i >= 0; --i) {
                for (int j = 0; j < 15; ++j) {
                    GLLib.s_tProf_profilerPool[i][j] = 0L;
                    if (j != 7 && j != 12) continue;
                    GLLib.s_tProf_profilerPool[i][j] = 99999999L;
                }
            }
        }
    }

    public static void Time_Profiler_DrawReport() {
        if (false) {
            if (s_tProf_maxSlots <= 0) {
                return;
            }
            GLLib.SetColor(0);
            GLLib.FillRect(0, 0, GLLib.GetScreenWidth(), GLLib.GetScreenHeight());
            int n = s_tProf_liveTextColor;
            s_tProf_liveTextColor = 0xFFFFFF;
            GLLib.Time_Profiler_OutputToScreen();
            s_tProf_liveTextColor = n;
        }
    }

    public static void Time_Profiler_OutputToScreen() {
        if (false) {
            if (s_tProf_maxSlots <= 0) {
                return;
            }
            int n = s_tProf_yDisplay;
            GLLib.SetColor(s_tProf_liveTextColor);
            for (int i = 0; i < s_tProf_maxSlots; ++i) {
                String string;
                int n2 = 10;
                if (s_tProf_profilerNames[i] == null) continue;
                GLLib.DrawString(s_tProf_profilerNames[i], n2, n, 20);
                n2 += 10;
                if (i == 0) {
                    string = "Cur FPS " + s_tProf_profilerPool[i][10];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "AVG FPS " + s_tProf_profilerPool[i][9];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "Min FPS " + s_tProf_profilerPool[i][7];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "Max FPS " + s_tProf_profilerPool[i][8];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                } else {
                    string = "Cur Frame MS " + s_tProf_profilerPool[i][10];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "AVG Frame MS " + s_tProf_profilerPool[i][14];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "Min Frame MS " + s_tProf_profilerPool[i][7];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "Max Frame MS " + s_tProf_profilerPool[i][8];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    string = "Exec Count " + s_tProf_profilerPool[i][4];
                    GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    if (s_tProf_profilerPool[i][4] > 1L) {
                        string = "AVG Exec MS " + s_tProf_profilerPool[i][9];
                        GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                        string = "Min Exec MS " + s_tProf_profilerPool[i][12];
                        GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                        string = "Max Exec MS " + s_tProf_profilerPool[i][13];
                        GLLib.DrawString(string, n2, n += s_tProf_lineHeight, 20);
                    }
                }
                n += s_tProf_lineHeight;
            }
            if (!s_tProf_isDrawReport) {
                GLLib.Time_Profiler_UpdateScrolling();
            }
        }
    }

    private static void Time_Profiler_UpdateScrolling() {
        if (false && s_tProf_activeSlots * (6 * s_tProf_lineHeight) > GLLib.GetScreenHeight()) {
            long l = System.currentTimeMillis();
            if (s_tProf_scrollStartTime == 0L) {
                s_tProf_scrollStartTime = l - 1L;
            }
            s_tProf_scrollTimer += l - s_tProf_scrollStartTime;
            s_tProf_scrollStartTime = l;
            if (s_tProf_scrollTimer > 1000L) {
                s_tProf_updateScroll = true;
                s_tProf_scrollTimer = 0L;
            }
            if (!s_tProf_isScrollDown && s_tProf_yDisplay < GLLib.GetScreenHeight() - s_tProf_activeSlots * (6 * s_tProf_lineHeight)) {
                s_tProf_isScrollDown = true;
            } else if (s_tProf_isScrollDown && s_tProf_yDisplay > 0) {
                s_tProf_isScrollDown = false;
            }
            if (s_tProf_updateScroll) {
                s_tProf_yDisplay = s_tProf_isScrollDown ? (s_tProf_yDisplay += s_tProf_lineHeight) : (s_tProf_yDisplay -= s_tProf_lineHeight);
                s_tProf_updateScroll = false;
            }
        }
    }

    public static void Time_Profiler_DrawSmallIndicator() {
        if (false) {
            if (!s_tProf_isIndicatorEnabled || !s_tProf_isProfilerEnabled || s_tProf_maxSlots <= 0) {
                return;
            }
            int n = 10;
            int n2 = 5;
            GLLib.SetColor(0);
            GLLib.FillRect(0, 0, GLLib.GetScreenWidth() >> 1, n2 + s_tProf_lineHeight);
            GLLib.SetColor(0xFFFFFF);
            String string = "Cur FPS " + s_tProf_profilerPool[0][10];
            GLLib.DrawString(string, n, n2, 20);
        }
    }

    private static void Time_Profiler_UpdateKey() {
        if (false) {
            int n;
            if (s_tProf_maxSlots <= 0) {
                return;
            }
            if (GLLib.WasKeyPressed(16)) {
                s_tProf_keyHeldTime = System.currentTimeMillis();
                if (!s_tProf_isProfilerEnabled && s_tProf_isDrawReport) {
                    s_tProf_isDrawReport = false;
                    s_tProf_isProfilerEnabled = false;
                    s_tProf_keyHeldTimer = 0L;
                    return;
                }
            }
            if ((n = GLLib.IsAnyKeyDown()) == 16) {
                long l = System.currentTimeMillis();
                s_tProf_keyHeldTimer += l - s_tProf_keyHeldTime;
                s_tProf_keyHeldTime = l;
                if (s_tProf_keyHeldTimer > 2000L) {
                    if (!s_tProf_isProfilerEnabled && !s_tProf_isDrawReport) {
                        s_tProf_isProfilerEnabled = true;
                        GLLib.Time_Profiler_ResetProfilingInfo();
                    } else if (s_tProf_isProfilerEnabled && !s_tProf_isDrawReport) {
                        s_tProf_isDrawReport = true;
                        s_tProf_isProfilerEnabled = false;
                    }
                    s_tProf_keyHeldTimer = 0L;
                }
            } else {
                s_tProf_keyHeldTimer = 0L;
            }
            if (s_tProf_isDrawReport) {
                if (n == 1 || n == 8) {
                    if (s_tProf_yDisplay < 0) {
                        s_tProf_yDisplay += 3;
                    }
                } else if ((n == 2 || n == 14) && s_tProf_yDisplay > GLLib.GetScreenHeight() - s_tProf_activeSlots * (6 * s_tProf_lineHeight)) {
                    s_tProf_yDisplay -= 3;
                }
            }
        }
    }

    private static void Time_Profiler_OutputInfo() {
        if (false) {
            if (s_tProf_maxSlots <= 0) {
                return;
            }
            if (!s_tProf_isProfilerEnabled) {
                if (s_tProf_isDrawReport) {
                    GLLib.Time_Profiler_DrawReport();
                }
            } else if (!s_tProf_isIndicatorEnabled) {
                GLLib.Time_Profiler_OutputToScreen();
            } else {
                GLLib.Time_Profiler_DrawSmallIndicator();
            }
        }
    }

    public static void AlphaRect_SetColor(int n) {
        if (n != s_alphaRectCurrentARGB || false && s_alphaRectImage == null || !false && s_alphaRectARGBData == null) {
            s_alphaRectCurrentARGB = n;
            if (false && 16 * 16 < 23331) {
                s_alphaRectARGBData = ASprite.temp_int;
            }
            if (s_alphaRectARGBData == null) {
                s_alphaRectARGBData = new int[16 * 16];
            }
            int n2 = 16 * 16;
            while (n2 > 0) {
                GLLib.s_alphaRectARGBData[--n2] = n;
            }
            if (false) {
                s_alphaRectImage = GLLib.CreateRGBImage(s_alphaRectARGBData, 16, 16, true);
            }
        }
    }

    public static void AlphaRect_Draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (false && ASprite.s_resizeOn) {
            n = ASprite.scaleX(n);
            n2 = ASprite.scaleY(n2);
            n3 = ASprite.scaleX(n3);
            n4 = ASprite.scaleY(n4);
        }
        int n5 = GLLib.GetClipX(graphics);
        int n6 = GLLib.GetClipY(graphics);
        int n7 = GLLib.GetClipWidth(graphics);
        int n8 = GLLib.GetClipHeight(graphics);
        int n9 = n > n5 ? n : n5;
        int n10 = n2 > n6 ? n2 : n6;
        int n11 = (n + n3 < n5 + n7 ? n + n3 : n5 + n7) - n9;
        int n12 = (n2 + n4 < n6 + n8 ? n2 + n4 : n6 + n8) - n10;
        if (n11 <= 0 || n12 <= 0) {
            return;
        }
        GLLib.SetClip(graphics, n9, n10, n11, n12);
        if (false) {
            int n13 = n9;
            n9 = GLLib.GetGraphicsHeight() - n10 - n12;
            n10 = n13;
            n13 = n11;
            n11 = n12;
            n12 = n13;
        }
        if (!false && n11 * n12 < 16 * 16) {
            if (false) {
                GLLib.DrawRGB(graphics, s_alphaRectARGBData, 0, n11, n9, n10, n11, n12, true, true, 0, -1, false);
            } else {
                GLLib.DrawRGB(graphics, s_alphaRectARGBData, 0, n11, n9, n10, n11, n12, true);
            }
        } else {
            n11 += n9;
            n12 += n10;
            for (int i = n9; i < n11; i += 16) {
                for (int j = n10; j < n12; j += 16) {
                    if (false) {
                        if (false) {
                            GLLib.DrawImage(graphics, s_alphaRectImage, i, j, 20, false);
                            continue;
                        }
                        GLLib.DrawImage(graphics, s_alphaRectImage, i, j, 20);
                        continue;
                    }
                    if (false) {
                        GLLib.DrawRGB(graphics, s_alphaRectARGBData, 0, 16, i, j, 16, 16, true, true, 0, -1, false);
                        continue;
                    }
                    GLLib.DrawRGB(graphics, s_alphaRectARGBData, 0, 16, i, j, 16, 16, true);
                }
            }
        }
        GLLib.SetClip(graphics, n5, n6, n7, n8);
    }

    static void DrawAlphaRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 >> 24 & 0xFF;
        GLLib.DrawAAAlphaLine(graphics, n + 1, n2, n + n3, n2, n5 &= 0xFFFFFF, n6, n6);
        GLLib.DrawAAAlphaLine(graphics, n, n2, n, n2 + n4, n5, n6, n6);
        GLLib.DrawAAAlphaLine(graphics, n + n3, n2 + n4, n + n3, n2, n5, n6, n6);
        GLLib.DrawAAAlphaLine(graphics, n + n3 + 1, n2 + n4, n, n2 + n4, n5, n6, n6);
    }

    private static final int[] PFX_ProcessRotating(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if ((n6 & 4) != 0) {
            n6 &= 0xFFFFFFFB;
            n5 = GLLib.Math_FixedPoint_Add(n5, GLLib.Math_DegreeToFixedPointAngle(90));
        }
        if (n6 != 0) {
            nArray = ASprite.TransformRGB(nArray, n3, n4, n6);
            nArray2 = ASprite.GetPixelBuffer_int(nArray, n3, n4);
        }
        int n7 = GLLib.Math_Sin(n5);
        int n8 = GLLib.Math_Cos(n5);
        GLLib.PFX_Rotate_GetRotatedRectSize(n7, n8, n3, n4, ASprite.s_rc);
        int n9 = ASprite.s_rc[0];
        int n10 = ASprite.s_rc[1];
        int n11 = n9 >> 1;
        int n12 = n10 >> 1;
        int n13 = n9 - n3 >> 1;
        int n14 = n10 - n4 >> 1;
        int n15 = n12 * n7;
        int n16 = -n12 * n8;
        int n17 = n11 * n7;
        int n18 = n11 * n8;
        int n19 = n11 - n13;
        int n20 = n12 - n14;
        int n21 = -n18;
        int n22 = -n17;
        for (int i = 0; i < n9; ++i) {
            int n23 = n21 - n15;
            int n24 = n16 - n22;
            int n25 = i;
            for (int j = 0; j < n10; ++j) {
                int n26 = n19 + GLLib.Math_FixedPointToInt(n23);
                int n27 = n20 + GLLib.Math_FixedPointToInt(n24);
                n23 += n7;
                n24 += n8;
                nArray2[n25] = n26 >= 0 && n27 >= 0 && n26 < n3 && n27 < n4 ? nArray[n27 * n3 + n26] : 0;
                n25 += n9;
            }
            n21 += n8;
            n22 += n7;
        }
        s_PFX_newSizeX = n9;
        s_PFX_newSizeY = n10;
        if (bl) {
            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n9, n, n2, n9, n10, true);
        }
        return bl ? null : nArray2;
    }

    private static final int[] PFX_ProcessScaling(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, int n8, boolean bl3) {
        int n9;
        int n10;
        int n11;
        int n12 = nArray.length;
        int n13 = 0;
        int n14 = n8 & 0xFFFFFFFE;
        if ((n8 & 4) != 0) {
            n14 = n8;
            n8 = 0;
        }
        if (n14 != 0) {
            if ((n14 & 4) != 0) {
                s_PFX_sizeX = n4;
                s_PFX_sizeY = n3;
                n3 = s_PFX_sizeX;
                n4 = s_PFX_sizeY;
            }
            nArray = ASprite.TransformRGB(nArray, n3, n4, n14);
            nArray2 = ASprite.GetPixelBuffer_int(nArray, n3, n4);
        }
        int n15 = n3 * n5 / 100 + (n3 * n5 % 100 != 0 ? 1 : 0);
        int n16 = n4 * n6 / 100 + (n4 * n6 % 100 != 0 ? 1 : 0);
        s_PFX_newSizeX = n15;
        s_PFX_newSizeY = n16;
        if (n15 <= 0 || n16 <= 0) {
            return null;
        }
        int n17 = (n3 << 8) / n15;
        int n18 = (n4 << 8) / n16;
        if (false) {
            n11 = GLLib.GetGraphicsHeight();
            n10 = GLLib.GetGraphicsWidth();
        } else {
            n11 = GLLib.GetGraphicsWidth();
            n10 = GLLib.GetGraphicsHeight();
        }
        int n19 = n15;
        int n20 = 0;
        int n21 = n15;
        int n22 = 0;
        int n23 = n16;
        if (n < 0) {
            if ((n15 += n) <= 0) {
                return null;
            }
            n20 = -n;
            n = 0;
        }
        if (n2 < 0) {
            if ((n16 += n2) <= 0) {
                return null;
            }
            n22 = -n2;
            n2 = 0;
        }
        if (n + n15 > n11) {
            n15 = n11 - n;
            if (n15 <= 0) {
                return null;
            }
            n21 = n20 + n15;
        }
        if (n2 + n16 > n10) {
            n16 = n10 - n2;
            if (n16 <= 0) {
                return null;
            }
            n23 = n22 + n16;
        }
        if ((n9 = nArray2.length / n15) <= 0) {
            return null;
        }
        int n24 = n9;
        int n25 = n2;
        if (n7 < 0) {
            int n26;
            int n27;
            int n28 = n9 * n15;
            if ((n8 & 1) != 0) {
                n27 = (n19 - n21) * n17;
                n26 = n17;
            } else {
                n27 = (n21 - 1) * n17;
                n26 = -n17;
            }
            n24 = n16 - n16 / n9 * n9;
            if (n24 == 0) {
                n24 = n9;
            }
            int n29 = n24;
            n13 = n24 * n15;
            n25 = n2 + n16 - n24;
            int n30 = n16;
            int n31 = (n30 + n22) * n18;
            while (--n30 >= 0) {
                int n32 = (((n31 -= n18) >> 8) * n3 << 8) + n27;
                int n33 = n21;
                while (--n33 >= n20) {
                    nArray2[--n13] = nArray[n32 >> 8];
                    n32 += n26;
                }
                if (--n24 != 0) continue;
                if (bl3) {
                    GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n29, bl);
                }
                n29 = n9;
                n25 -= n9;
                n24 = n9;
                n13 = n28;
            }
        } else {
            int n34;
            int n35;
            if ((n8 & 1) != 0) {
                n35 = (n19 - n20 - 1) * n17;
                n34 = -n17;
            } else {
                n35 = n20 * n17;
                n34 = n17;
            }
            if (!bl2 && !bl) {
                bl = true;
                n7 = (n7 & 0xFF) << 24;
                int n36 = 0;
                int n37 = n22 * n18;
                while (n36 < n16) {
                    int n38 = (n37 >> 8) * n3;
                    int n39 = 0;
                    int n40 = n35;
                    while (n39 < n15) {
                        int n41 = n38 + (n40 >> 8);
                        nArray2[n13++] = n7 | nArray[n41] & 0xFFFFFF;
                        ++n39;
                        n40 += n34;
                    }
                    if (--n24 == 0) {
                        if (bl3) {
                            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9, bl);
                        }
                        n25 += n9;
                        n24 = n9;
                        n13 = 0;
                    }
                    ++n36;
                    n37 += n18;
                }
            } else if (!bl2 && bl) {
                bl = true;
                n7 = (n7 & 0xFF) << 24;
                int n42 = 0;
                int n43 = n22 * n18;
                while (n42 < n16) {
                    int n44 = (n43 >> 8) * n3;
                    int n45 = 0;
                    int n46 = n35;
                    while (n45 < n15) {
                        int n47 = n44 + (n46 >> 8);
                        int n48 = nArray[n47] & 0xFFFFFF;
                        nArray2[n13++] = n48 != 0xFF00FF && n48 != 0 ? n7 | n48 : 0;
                        ++n45;
                        n46 += n34;
                    }
                    if (--n24 == 0) {
                        if (bl3) {
                            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9, bl);
                        }
                        n25 += n9;
                        n24 = n9;
                        n13 = 0;
                    }
                    ++n42;
                    n43 += n18;
                }
            } else {
                bl = true;
                int n49 = 0;
                int n50 = n22 * n18;
                while (n49 < n16) {
                    int n51 = (n50 >> 8) * n3;
                    int n52 = 0;
                    int n53 = n35;
                    while (n52 < n15) {
                        int n54 = n51 + (n53 >> 8);
                        int n55 = nArray[n54] >> 24 & 0xFF;
                        n55 = n55 * n7 >> 8;
                        n55 = (n55 & 0xFF & 0xFF) << 24;
                        nArray2[n13++] = n55 | nArray[n54] & 0xFFFFFF;
                        ++n52;
                        n53 += n34;
                    }
                    if (--n24 == 0) {
                        if (bl3) {
                            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9, bl);
                        }
                        n25 += n9;
                        n24 = n9;
                        n13 = 0;
                    }
                    ++n49;
                    n50 += n18;
                }
            }
            if (bl3 && n24 != n9) {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9 - n24, bl);
            }
        }
        return bl3 ? null : nArray2;
    }

    static int PFX_PrepareYPerspectiveBlock(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        int n15 = n5 >> 8;
        int n16 = 0;
        int n17 = 0;
        int n18 = GLLib.Math_FixedPointToInt(n10);
        int n19 = GLLib.Math_FixedPointToInt(n11);
        for (int i = n6; i < n7; ++i) {
            int n20;
            int n21;
            if (n19 < n8 || n18 >= n9) continue;
            if (false) {
                n21 = n16 = (i - n6) * n2;
                for (n20 = n9 - n19 - 1; n20 >= 0; --n20) {
                    nArray[n21++] = 0;
                }
                n16 += n2;
                for (n20 = n18 - n8 - 1; n20 >= 0; --n20) {
                    nArray[--n16] = 0;
                }
                --n16;
            } else {
                n21 = i - n6;
                for (n20 = n18 - n8 - 1; n20 >= 0; --n20) {
                    nArray[n21] = 0;
                    n21 += n;
                }
                n21 = (n2 - 1) * n + i - n6;
                for (n20 = n9 - n19 - 1; n20 >= 0; --n20) {
                    nArray[n21] = 0;
                    n21 -= n;
                }
            }
            if (n18 < n19) {
                int n22;
                int n23;
                int n24;
                if (!false) {
                    n16 = i - n6;
                }
                int n25 = 0;
                int n26 = 0;
                int n27 = GLLib.Math_IntToFixedPoint(n4) / (n19 - n18);
                if (n18 < n8) {
                    n21 = n27 * (n8 - n18);
                    n25 += n21;
                    n18 = n8;
                } else if (!false) {
                    n16 += n * (n18 - n8);
                }
                if (n19 > n9) {
                    n19 = n9;
                }
                if (false) {
                    n24 = n15 / n3;
                    n23 = n15 - n24 * n3;
                    n22 = nArray2[n23 * n4 + (n4 - 1 - n24)];
                } else {
                    n22 = nArray2[n15];
                }
                while (n18 < n19) {
                    n17 = n25 >> 8;
                    if (n26 != n17) {
                        n15 += (n17 - n26) * n3;
                        if (false) {
                            n24 = n15 / n3;
                            n23 = n15 - n24 * n3;
                            n22 = nArray2[n23 * n4 + (n4 - 1 - n24)];
                        } else {
                            n22 = nArray2[n15];
                        }
                        n26 = n17;
                    }
                    nArray[n16] = n22;
                    n16 = false ? --n16 : (n16 += n);
                    n25 += n27;
                    ++n18;
                }
            }
            n18 = (n10 += n13) >> 8;
            n19 = (n11 += n14) >> 8;
            n15 = (n5 += n12) >> 8;
            if (n15 < 0) {
                n15 = 0;
                n5 = 0;
                continue;
            }
            if (n15 < n3) continue;
            n15 = n3 - 1;
            n5 = n15 << 8;
        }
        return n5;
    }

    private static final int[] PFX_ProcessRotating(Graphics graphics, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if ((n6 & 4) != 0) {
            n6 &= 0xFFFFFFFB;
            n5 = GLLib.Math_FixedPoint_Add(n5, GLLib.Math_DegreeToFixedPointAngle(90));
        }
        if (n6 != 0) {
            byArray = ASprite.TransformRGB(byArray, n3, n4, n6);
            nArray2 = ASprite.GetPixelBuffer_int(null, n3, n4);
        }
        int n7 = GLLib.Math_Sin(n5);
        int n8 = GLLib.Math_Cos(n5);
        GLLib.PFX_Rotate_GetRotatedRectSize(n7, n8, n3, n4, ASprite.s_rc);
        int n9 = ASprite.s_rc[0];
        int n10 = ASprite.s_rc[1];
        int n11 = n9 >> 1;
        int n12 = n10 >> 1;
        int n13 = n9 - n3 >> 1;
        int n14 = n10 - n4 >> 1;
        int n15 = n12 * n7;
        int n16 = -n12 * n8;
        int n17 = n11 * n7;
        int n18 = n11 * n8;
        int n19 = n11 - n13;
        int n20 = n12 - n14;
        int n21 = -n18;
        int n22 = -n17;
        for (int i = 0; i < n9; ++i) {
            int n23 = n21 - n15;
            int n24 = n16 - n22;
            int n25 = i;
            for (int j = 0; j < n10; ++j) {
                int n26 = n19 + GLLib.Math_FixedPointToInt(n23);
                int n27 = n20 + GLLib.Math_FixedPointToInt(n24);
                n23 += n7;
                n24 += n8;
                nArray2[n25] = n26 >= 0 && n27 >= 0 && n26 < n3 && n27 < n4 ? nArray[byArray[n27 * n3 + n26] & 0xFF] : 0;
                n25 += n9;
            }
            n21 += n8;
            n22 += n7;
        }
        s_PFX_newSizeX = n9;
        s_PFX_newSizeY = n10;
        if (bl) {
            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n9, n, n2, n9, n10, true);
        }
        return bl ? null : nArray2;
    }

    private static final int[] PFX_ProcessScaling(Graphics graphics, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, int n8, boolean bl3) {
        int n9;
        int n10;
        int n11;
        int n12 = byArray.length;
        int n13 = 0;
        int n14 = n8 & 0xFFFFFFFE;
        if ((n8 & 4) != 0) {
            n14 = n8;
            n8 = 0;
        }
        if (n14 != 0) {
            if ((n14 & 4) != 0) {
                s_PFX_sizeX = n4;
                s_PFX_sizeY = n3;
                n3 = s_PFX_sizeX;
                n4 = s_PFX_sizeY;
            }
            byArray = ASprite.TransformRGB(byArray, n3, n4, n14);
            nArray2 = ASprite.GetPixelBuffer_int(null, n3, n4);
        }
        int n15 = n3 * n5 / 100 + (n3 * n5 % 100 != 0 ? 1 : 0);
        int n16 = n4 * n6 / 100 + (n4 * n6 % 100 != 0 ? 1 : 0);
        s_PFX_newSizeX = n15;
        s_PFX_newSizeY = n16;
        if (n15 <= 0 || n16 <= 0) {
            return null;
        }
        int n17 = (n3 << 8) / n15;
        int n18 = (n4 << 8) / n16;
        if (false) {
            n11 = GLLib.GetGraphicsHeight();
            n10 = GLLib.GetGraphicsWidth();
        } else {
            n11 = GLLib.GetGraphicsWidth();
            n10 = GLLib.GetGraphicsHeight();
        }
        int n19 = n15;
        int n20 = 0;
        int n21 = n15;
        int n22 = 0;
        int n23 = n16;
        if (n < 0) {
            if ((n15 += n) <= 0) {
                return null;
            }
            n20 = -n;
            n = 0;
        }
        if (n2 < 0) {
            if ((n16 += n2) <= 0) {
                return null;
            }
            n22 = -n2;
            n2 = 0;
        }
        if (n + n15 > n11) {
            n15 = n11 - n;
            if (n15 <= 0) {
                return null;
            }
            n21 = n20 + n15;
        }
        if (n2 + n16 > n10) {
            n16 = n10 - n2;
            if (n16 <= 0) {
                return null;
            }
            n23 = n22 + n16;
        }
        if ((n9 = nArray2.length / n15) <= 0) {
            return null;
        }
        int n24 = n9;
        int n25 = n2;
        if (n7 < 0) {
            int n26;
            int n27;
            int n28 = n9 * n15;
            if ((n8 & 1) != 0) {
                n27 = (n19 - n21) * n17;
                n26 = n17;
            } else {
                n27 = (n21 - 1) * n17;
                n26 = -n17;
            }
            n24 = n16 - n16 / n9 * n9;
            if (n24 == 0) {
                n24 = n9;
            }
            int n29 = n24;
            n13 = n24 * n15;
            n25 = n2 + n16 - n24;
            int n30 = n16;
            int n31 = (n30 + n22) * n18;
            while (--n30 >= 0) {
                int n32 = (((n31 -= n18) >> 8) * n3 << 8) + n27;
                int n33 = n21;
                while (--n33 >= n20) {
                    nArray2[--n13] = nArray[byArray[n32 >> 8] & 0xFF];
                    n32 += n26;
                }
                if (--n24 != 0) continue;
                if (bl3) {
                    GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n29, bl);
                }
                n29 = n9;
                n25 -= n9;
                n24 = n9;
                n13 = n28;
            }
        } else {
            int n34;
            int n35;
            if ((n8 & 1) != 0) {
                n35 = (n19 - n20 - 1) * n17;
                n34 = -n17;
            } else {
                n35 = n20 * n17;
                n34 = n17;
            }
            if (!bl2 && !bl) {
                bl = true;
                n7 = (n7 & 0xFF) << 24;
                int n36 = 0;
                int n37 = n22 * n18;
                while (n36 < n16) {
                    int n38 = (n37 >> 8) * n3;
                    int n39 = 0;
                    int n40 = n35;
                    while (n39 < n15) {
                        int n41 = n38 + (n40 >> 8);
                        nArray2[n13++] = n7 | nArray[byArray[n41] & 0xFF] & 0xFFFFFF;
                        ++n39;
                        n40 += n34;
                    }
                    if (--n24 == 0) {
                        if (bl3) {
                            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9, bl);
                        }
                        n25 += n9;
                        n24 = n9;
                        n13 = 0;
                    }
                    ++n36;
                    n37 += n18;
                }
            } else if (!bl2 && bl) {
                bl = true;
                n7 = (n7 & 0xFF) << 24;
                int n42 = 0;
                int n43 = n22 * n18;
                while (n42 < n16) {
                    int n44 = (n43 >> 8) * n3;
                    int n45 = 0;
                    int n46 = n35;
                    while (n45 < n15) {
                        int n47 = n44 + (n46 >> 8);
                        int n48 = nArray[byArray[n47] & 0xFF] & 0xFFFFFF;
                        nArray2[n13++] = n48 != 0xFF00FF && n48 != 0 ? n7 | n48 : 0;
                        ++n45;
                        n46 += n34;
                    }
                    if (--n24 == 0) {
                        if (bl3) {
                            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9, bl);
                        }
                        n25 += n9;
                        n24 = n9;
                        n13 = 0;
                    }
                    ++n42;
                    n43 += n18;
                }
            } else {
                bl = true;
                int n49 = 0;
                int n50 = n22 * n18;
                while (n49 < n16) {
                    int n51 = (n50 >> 8) * n3;
                    int n52 = 0;
                    int n53 = n35;
                    while (n52 < n15) {
                        int n54 = n51 + (n53 >> 8);
                        int n55 = nArray[byArray[n54] & 0xFF] >> 24 & 0xFF;
                        n55 = n55 * n7 >> 8;
                        n55 = (n55 & 0xFF & 0xFF) << 24;
                        nArray2[n13++] = n55 | nArray[byArray[n54] & 0xFF] & 0xFFFFFF;
                        ++n52;
                        n53 += n34;
                    }
                    if (--n24 == 0) {
                        if (bl3) {
                            GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9, bl);
                        }
                        n25 += n9;
                        n24 = n9;
                        n13 = 0;
                    }
                    ++n49;
                    n50 += n18;
                }
            }
            if (bl3 && n24 != n9) {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n15, n, n25, n15, n9 - n24, bl);
            }
        }
        return bl3 ? null : nArray2;
    }

    static int PFX_PrepareYPerspectiveBlock(int[] nArray, byte[] byArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        int n15 = n5 >> 8;
        int n16 = 0;
        int n17 = 0;
        int n18 = GLLib.Math_FixedPointToInt(n10);
        int n19 = GLLib.Math_FixedPointToInt(n11);
        for (int i = n6; i < n7; ++i) {
            int n20;
            int n21;
            if (n19 < n8 || n18 >= n9) continue;
            if (false) {
                n21 = n16 = (i - n6) * n2;
                for (n20 = n9 - n19 - 1; n20 >= 0; --n20) {
                    nArray[n21++] = 0;
                }
                n16 += n2;
                for (n20 = n18 - n8 - 1; n20 >= 0; --n20) {
                    nArray[--n16] = 0;
                }
                --n16;
            } else {
                n21 = i - n6;
                for (n20 = n18 - n8 - 1; n20 >= 0; --n20) {
                    nArray[n21] = 0;
                    n21 += n;
                }
                n21 = (n2 - 1) * n + i - n6;
                for (n20 = n9 - n19 - 1; n20 >= 0; --n20) {
                    nArray[n21] = 0;
                    n21 -= n;
                }
            }
            if (n18 < n19) {
                int n22;
                int n23;
                int n24;
                if (!false) {
                    n16 = i - n6;
                }
                int n25 = 0;
                int n26 = 0;
                int n27 = GLLib.Math_IntToFixedPoint(n4) / (n19 - n18);
                if (n18 < n8) {
                    n21 = n27 * (n8 - n18);
                    n25 += n21;
                    n18 = n8;
                } else if (!false) {
                    n16 += n * (n18 - n8);
                }
                if (n19 > n9) {
                    n19 = n9;
                }
                if (false) {
                    n24 = n15 / n3;
                    n23 = n15 - n24 * n3;
                    n22 = nArray2[byArray[n23 * n4 + (n4 - 1 - n24)] & 0xFF];
                } else {
                    n22 = nArray2[byArray[n15] & 0xFF];
                }
                while (n18 < n19) {
                    n17 = n25 >> 8;
                    if (n26 != n17) {
                        n15 += (n17 - n26) * n3;
                        if (false) {
                            n24 = n15 / n3;
                            n23 = n15 - n24 * n3;
                            n22 = nArray2[byArray[n23 * n4 + (n4 - 1 - n24)] & 0xFF];
                        } else {
                            n22 = nArray2[byArray[n15] & 0xFF];
                        }
                        n26 = n17;
                    }
                    nArray[n16] = n22;
                    n16 = false ? --n16 : (n16 += n);
                    n25 += n27;
                    ++n18;
                }
            }
            n18 = (n10 += n13) >> 8;
            n19 = (n11 += n14) >> 8;
            n15 = (n5 += n12) >> 8;
            if (n15 < 0) {
                n15 = 0;
                n5 = 0;
                continue;
            }
            if (n15 < n3) continue;
            n15 = n3 - 1;
            n5 = n15 << 8;
        }
        return n5;
    }

    private static final void PFX_ProcessAdditive(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = 0;
        int n11 = (n9 & 0xFF) << 24;
        for (int i = n4; i != n6; i += n5) {
            int n12 = n + n2;
            for (int j = n7; j >= 0; --j) {
                int n13;
                int n14;
                int n15 = nArray[n12];
                int n16 = nArray2[n10];
                int n17 = n15 & 0xFF0000;
                int n18 = n15 & 0xFF00;
                int n19 = n15 & 0xFF;
                int n20 = n16 & 0xFF0000;
                int n21 = n16 & 0xFF00;
                int n22 = n16 & 0xFF;
                int n23 = n17 + n20;
                if (n23 > 0xFF0000) {
                    n23 = 0xFF0000;
                }
                if ((n14 = n18 + n21) > 65280) {
                    n14 = 65280;
                }
                if ((n13 = n19 + n22) > 255) {
                    n13 = 255;
                }
                nArray2[n10] = n11 | n23 | n14 | n13;
                n12 += n8;
                ++n10;
            }
            n += n3;
        }
    }

    private static final void PFX_ProcessMultiplicative(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = 0;
        int n11 = (n9 & 0xFF) << 24;
        for (int i = n4; i != n6; i += n5) {
            int n12 = n + n2;
            for (int j = n7; j >= 0; --j) {
                int n13;
                int n14;
                int n15 = nArray[n12];
                int n16 = nArray2[n10];
                int n17 = (n15 & 0xFF0000) >> 16;
                int n18 = (n15 & 0xFF00) >> 8;
                int n19 = n15 & 0xFF;
                int n20 = (n16 & 0xFF0000) >> 16;
                int n21 = (n16 & 0xFF00) >> 8;
                int n22 = n16 & 0xFF;
                int n23 = (n17 * n20 >> 6) + n20;
                if (n23 > 255) {
                    n23 = 255;
                }
                if ((n14 = (n18 * n21 >> 6) + n21) > 255) {
                    n14 = 255;
                }
                if ((n13 = (n19 * n22 >> 6) + n22) > 255) {
                    n13 = 255;
                }
                nArray2[n10] = n11 | n23 << 16 | n14 << 8 | n13;
                n12 += n8;
                ++n10;
            }
            n += n3;
        }
    }

    private static final int[] PFX_ProcessGrayscaleEffect(int[] nArray, int[] nArray2, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = n;
        if (n3 < 0) {
            if (n2 <= 0) {
                while (n4 != 0) {
                    int n5 = nArray[--n4];
                    int n6 = (n5 & 0xFF0000) >> 16 & 0xFF;
                    nArray2[n4] = n5 & 0xFFFF0000 | n6 << 8 | n6;
                }
            } else if (n2 < 255) {
                while (n4 != 0) {
                    int n7 = nArray[--n4];
                    int n8 = (n7 & 0xFF0000) >> 16 & 0xFF;
                    nArray2[n4] = n7 & 0xFFFF0000;
                    int n9 = (n7 & 0xFF00) >> 8 & 0xFF;
                    int n10 = n8 + ((n9 - n8) * n2 >> 8);
                    int n11 = n4;
                    nArray2[n11] = nArray2[n11] | (n10 & 0xFF) << 8;
                    n9 = n7 & 0xFF;
                    int n12 = n8 + ((n9 - n8) * n2 >> 8);
                    int n13 = n4;
                    nArray2[n13] = nArray2[n13] | n12 & 0xFF;
                }
            } else {
                nArray2 = nArray;
            }
        } else {
            s_PFX_hasAlpha = true;
            if (bl2) {
                while (n4 != 0) {
                    int n14 = nArray[--n4];
                    int n15 = (n14 & 0xFF0000) >> 16 & 0xFF;
                    int n16 = nArray[n4] >> 24 & 0xFF;
                    n16 = n16 * n3 >> 8;
                    n16 = (n16 & 0xFF) << 24;
                    nArray2[n4] = n16 | n15 << 16 | n15 << 8 | n15;
                }
            } else if (bl) {
                n3 <<= 24;
                while (n4 != 0) {
                    int n17;
                    if (((n17 = nArray[--n4]) & 0xFF00FF) != 0xFF00FF) {
                        int n18 = (n17 & 0xFF0000) >> 16 & 0xFF;
                        nArray2[n4] = n3 | n18 << 16 | n18 << 8 | n18;
                        continue;
                    }
                    nArray2[n4] = 0;
                }
            } else {
                n3 <<= 24;
                while (n4 != 0) {
                    int n19 = nArray[--n4];
                    int n20 = (n19 & 0xFF0000) >> 16 & 0xFF;
                    nArray2[n4] = n3 | n20 << 16 | n20 << 8 | n20;
                }
            }
        }
        return nArray2;
    }

    private static final int[] PFX_ProcessGrayscaleEffect(byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, int n3, boolean bl, boolean bl2) {
        int[] nArray3 = GLLib.PFX_GetPalIndexARGB(byArray, nArray, nArray2);
        return GLLib.PFX_ProcessGrayscaleEffect(nArray3, nArray2, n, n2, n3, bl, bl2);
    }

    private static final int[] PFX_ProcessBlend(int[] nArray, int[] nArray2, int n, int n2, boolean bl, boolean bl2) {
        n2 = n2 < 0 ? 0 : (n2 > 255 ? 255 : n2);
        n2 &= 0xFF;
        if (bl2) {
            while (n > 0) {
                int n3;
                if ((n3 = nArray[--n] >> 24 & 0xFF) != 0) {
                    n3 = n3 * n2 >> 8;
                    n3 = (n3 & 0xFF) << 24;
                    nArray2[n] = nArray[n] & 0xFFFFFF | n3;
                    continue;
                }
                nArray2[n] = 0;
            }
        } else if (bl) {
            n2 <<= 24;
            while (n > 0) {
                if ((nArray[--n] & 0xFF000000) != 0) {
                    nArray2[n] = nArray[n] & 0xFFFFFF | n2;
                    continue;
                }
                nArray2[n] = 0;
            }
        } else {
            n2 <<= 24;
            while (n > 0) {
                nArray2[--n] = nArray[n] & 0xFFFFFF | n2;
            }
        }
        s_PFX_hasAlpha = true;
        return nArray2;
    }

    private static final int[] PFX_ProcessBlend(byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, boolean bl, boolean bl2) {
        int[] nArray3 = GLLib.PFX_GetPalIndexARGB(byArray, nArray, nArray2);
        return GLLib.PFX_ProcessBlend(nArray3, nArray2, n, n2, bl, bl2);
    }

    private static final int[] PFX_ProcessShineEffect(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, boolean bl) {
        if (false) {
            int n6 = s_PFX_params[10][1];
            int n7 = s_PFX_params[10][2];
            int n8 = s_PFX_params[10][3] & 0xFFFFFF;
            int n9 = s_PFX_params[10][5];
            int n10 = (1 << n9) - 1;
            int n11 = 0;
            if (s_PFX_params[10][4] != 0) {
                n6 -= n;
                n6 -= n7 >> 1;
            }
            GLLib.PFX_WritePixelData(graphics, nArray, 0, n3, n, n2, n3, n4, true);
            if (!bl) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n12 = 0;
                        if (j > n6 && j < n6 + n7 && (nArray[n11] & 0xFF000000) != 0) {
                            n12 = n10 - (((j - (n6 + (n7 >> 1)) < 0 ? -(j - (n6 + (n7 >> 1))) : j - (n6 + (n7 >> 1))) << n9) - 1) / (n7 >> 1);
                        }
                        nArray2[n11] = (n12 & 0xFF) << 24 | n8;
                        ++n11;
                    }
                }
            } else {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        int n13 = 0;
                        if (j > n6 && j < n6 + n7 && (nArray[n11] & 0xFF000000) != 0) {
                            n13 = n10 - ((j - (n6 + (n7 >> 1)) < 0 ? -(j - (n6 + (n7 >> 1))) : j - (n6 + (n7 >> 1))) << n9) / (n7 >> 1);
                        }
                        int n14 = nArray[n11] >> 24 & 0xFF;
                        n14 = n14 * n13 >> 8;
                        nArray2[n11] = (n14 & 0xFF) << 24 | n8;
                        ++n11;
                    }
                }
            }
            s_PFX_hasAlpha = true;
            return nArray2;
        }
        return null;
    }

    private static final int[] PFX_ProcessShineEffect(Graphics graphics, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int[] nArray3 = GLLib.PFX_GetPalIndexARGB(byArray, nArray, nArray2);
        return GLLib.PFX_ProcessShineEffect(graphics, nArray3, nArray2, n, n2, n3, n4, n5, bl);
    }

    private static final int[] PFX_ProcessStencilEffect(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, boolean bl, boolean bl2) {
        if (false) {
            while (n > 0) {
                if ((nArray[--n] & 0xFF000000) != 0) {
                    nArray2[n] = n2;
                    continue;
                }
                nArray2[n] = nArray[n];
            }
            if ((n2 & 0xFF000000) != -16777216) {
                s_PFX_hasAlpha = true;
            }
            return nArray2;
        }
        return null;
    }

    private static final int[] PFX_ProcessStencilEffect(Graphics graphics, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, boolean bl, boolean bl2) {
        int[] nArray3 = GLLib.PFX_GetPalIndexARGB(byArray, nArray, nArray2);
        return GLLib.PFX_ProcessStencilEffect(graphics, nArray3, nArray2, n, n2, bl, bl2);
    }

    static final void PFX_ApplyAlphaGradient(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        block11: {
            int n8;
            block10: {
                int n9;
                if (n3 != 32 && n3 != 16) break block10;
                if (n6 < 0) {
                    n6 = (n6 < 0 ? -n6 : n6) * n2 / 100;
                }
                if (n7 < 0) {
                    n7 = (n7 < 0 ? -n7 : n7) * n2 / 100;
                }
                if (n3 == 32) {
                    n9 = n4;
                    n4 = n5;
                    n5 = n9;
                    n9 = n6;
                    n6 = n7;
                    n7 = n9;
                }
                n9 = n5 - n4;
                int n10 = n4;
                int n11 = n2 - 1 - (0 > n6 - 1 ? 0 : n6 - 1) - (0 > n7 - 1 ? 0 : n7 - 1);
                n6 = n2 - n6;
                n9 = n11 == 0 ? 0 : (n9 << 16) / n11;
                int n12 = (n10 <<= 16) << 8 & 0xFF000000;
                int n13 = n * n2;
                int n14 = n2;
                while (n14 > 0) {
                    --n14;
                    for (int i = n; i > 0; --i) {
                        if ((nArray[--n13] & 0xFF000000) == 0) continue;
                        nArray[n13] = n12 | nArray[n13] & 0xFFFFFF;
                    }
                    if (n14 < n7 || n14 > n6) continue;
                    n12 = (n10 += n9) << 8 & 0xFF000000;
                }
                break block11;
            }
            if (n3 != 4 && n3 != 8) break block11;
            if (n6 < 0) {
                n6 = (n6 < 0 ? -n6 : n6) * n / 100;
            }
            if (n7 < 0) {
                n7 = (n7 < 0 ? -n7 : n7) * n / 100;
            }
            if (n3 == 8) {
                n8 = n4;
                n4 = n5;
                n5 = n8;
                n8 = n6;
                n6 = n7;
                n7 = n8;
            }
            n8 = n5 - n4;
            int n15 = n4;
            int n16 = n - 1 - (0 > n6 - 1 ? 0 : n6 - 1) - (0 > n7 - 1 ? 0 : n7 - 1);
            n6 = n - n6;
            n8 = n16 == 0 ? 0 : (n8 << 16) / n16;
            int n17 = (n15 <<= 16) << 8 & 0xFF000000;
            int n18 = n * n2;
            int n19 = n;
            while (n19 > 0) {
                --n19;
                for (int i = --n18; i >= 0; i -= n) {
                    if ((nArray[i] & 0xFF000000) == 0) continue;
                    nArray[i] = n17 | nArray[i] & 0xFFFFFF;
                }
                if (n19 < n7 || n19 > n6) continue;
                n17 = (n15 += n8) << 8 & 0xFF000000;
            }
        }
    }

    static final int PFX_GetGrayscaleColor(int n) {
        int n2 = (n & 0xFF0000) >> 16 & 0xFF;
        return n & 0xFFFF0000 | n2 << 8 | n2;
    }

    private static final void PFX_ReadPixelData(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6) {
        if (false && s_PFX_customBuffer != null) {
            GLLib.GetRGB(s_PFX_customBuffer, nArray, n, n2, n3, n4, n5, n6);
        } else if (false && ASprite._customGraphics != null) {
            ASprite.CopyArea(ASprite._customGraphics, ASprite._customGraphicsWidth, ASprite._customGraphicsHeight, nArray, n, n2, n3, n4, n5, n6);
        } else if (pfx_usingScreenBuffer) {
            GLLib.GetRGB(s_PFX_screenBuffer, nArray, n, n2, n3, n4, n5, n6);
        }
    }

    private static final void PFX_WritePixelData(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (false) {
            GLLib.DrawRGB(graphics, nArray, n, n2, n3, n4, n5, n6, bl, true, 0, -1, false);
        } else {
            GLLib.DrawRGB(graphics, nArray, n, n2, n3, n4, n5, n6, bl);
        }
    }

    static final void PFX_Init() {
        s_PFX_type = 0;
        s_PFX_timer = 0;
        s_PFX_windowX = 0;
        s_PFX_windowY = 0;
        s_PFX_windowWidth = GLLib.GetScreenWidth();
        s_PFX_windowHeight = GLLib.GetScreenHeight();
        s_PFX_params = new int[17][];
        if (false) {
            GLLib.s_PFX_params[0] = new int[5];
            GLLib.PFX_SetDefaultEffectParameters(0);
        }
        if (true) {
            GLLib.s_PFX_params[1] = new int[6];
            GLLib.PFX_SetDefaultEffectParameters(1);
        }
        if (false) {
            GLLib.s_PFX_params[9] = new int[3];
            GLLib.PFX_SetDefaultEffectParameters(9);
        }
        if (false) {
            GLLib.s_PFX_params[10] = new int[6];
            GLLib.PFX_SetDefaultEffectParameters(10);
        }
        if (false) {
            GLLib.s_PFX_params[11] = new int[20];
            GLLib.PFX_SetDefaultEffectParameters(11);
        }
        if (true) {
            GLLib.s_PFX_params[12] = new int[2];
            GLLib.PFX_SetDefaultEffectParameters(12);
        }
        if (false) {
            GLLib.s_PFX_params[13] = new int[5];
            GLLib.PFX_SetDefaultEffectParameters(13);
        }
        if (false) {
            GLLib.s_PFX_params[16] = new int[1];
            GLLib.PFX_SetDefaultEffectParameters(16);
        }
        if (false) {
            GLLib.s_PFX_params[14] = new int[1];
            GLLib.PFX_SetDefaultEffectParameters(14);
        }
        if (false) {
            GLLib.s_PFX_params[15] = new int[7];
            GLLib.PFX_SetDefaultEffectParameters(15);
        }
        if (true) {
            GLLib.s_PFX_params[5] = new int[1];
            GLLib.PFX_SetDefaultEffectParameters(5);
        }
        if (true) {
            GLLib.s_PFX_params[6] = new int[1];
            GLLib.PFX_SetDefaultEffectParameters(6);
        }
        if (true) {
            GLLib.s_PFX_params[7] = new int[2];
            GLLib.PFX_SetDefaultEffectParameters(7);
        }
        if (true) {
            GLLib.s_PFX_params[8] = new int[2];
            GLLib.PFX_SetDefaultEffectParameters(8);
        }
        if (pfx_usingScreenBuffer) {
            if (true || false) {
                s_PFX_screenBuffer = m_imgBackBuffer;
                s_PFX_screenBufferG = m_gBackBuffer;
            } else {
                if (false) {
                    int n = s_PFX_windowWidth;
                    s_PFX_windowWidth = s_PFX_windowHeight;
                    s_PFX_windowHeight = n;
                }
                s_PFX_screenBuffer = Image.createImage((int)s_PFX_windowWidth, (int)s_PFX_windowHeight);
                s_PFX_screenBufferG = s_PFX_screenBuffer.getGraphics();
            }
        }
        s_PFX_enableScreenBuffer = 0;
        s_PFX_initializd = true;
    }

    static final void PFX_SetDefaultEffectParameters(int n) {
        switch (n) {
            case 0: {
                if (!false) break;
                GLLib.s_PFX_params[0][4] = 250;
                break;
            }
            case 1: {
                if (!true) break;
                GLLib.s_PFX_params[1][3] = 250;
                break;
            }
            case 9: {
                if (!false) break;
                GLLib.s_PFX_params[9][1] = -1;
                GLLib.s_PFX_params[9][0] = -1;
                GLLib.s_PFX_params[9][2] = 0;
                break;
            }
            case 10: {
                if (!false) break;
                GLLib.s_PFX_params[10][1] = 0;
                GLLib.s_PFX_params[10][2] = 40;
                GLLib.s_PFX_params[10][3] = 0xFFFFFF;
                GLLib.s_PFX_params[10][4] = 0;
                GLLib.s_PFX_params[10][5] = 8;
                GLLib.s_PFX_params[10][0] = -1;
                break;
            }
            case 11: {
                if (!false) break;
                GLLib.s_PFX_params[11][0] = 172;
                GLLib.s_PFX_params[11][1] = 104;
                GLLib.s_PFX_params[11][2] = 2;
                GLLib.s_PFX_params[11][3] = 0;
                GLLib.s_PFX_params[11][4] = 0;
                GLLib.s_PFX_params[11][5] = 0;
                GLLib.s_PFX_params[11][6] = GLLib.Math_IntToFixedPoint(1);
                GLLib.s_PFX_params[11][7] = GLLib.Math_IntToFixedPoint(2);
                GLLib.s_PFX_params[11][8] = 4;
                GLLib.s_PFX_params[11][9] = 4;
                GLLib.s_PFX_params[11][10] = 16;
                GLLib.s_PFX_params[11][11] = 112;
                GLLib.s_PFX_params[11][12] = 64;
                GLLib.s_PFX_params[11][13] = 72;
                GLLib.s_PFX_params[11][14] = 3;
                break;
            }
            case 12: {
                if (!true) break;
                GLLib.s_PFX_params[12][1] = 255;
                GLLib.s_PFX_params[12][0] = -1;
                break;
            }
            case 13: {
                if (!false) break;
                GLLib.s_PFX_params[13][1] = 100;
                GLLib.s_PFX_params[13][2] = -1;
                GLLib.s_PFX_params[13][0] = -1;
                GLLib.s_PFX_params[13][3] = 100;
                GLLib.s_PFX_params[13][4] = 100;
                break;
            }
            case 16: {
                if (!false) break;
                GLLib.s_PFX_params[16][0] = 0;
                break;
            }
            case 14: {
                if (!false) break;
                GLLib.s_PFX_params[14][0] = -16777216;
                break;
            }
            case 15: {
                if (!false) break;
                GLLib.s_PFX_params[15][0] = 0;
                GLLib.s_PFX_params[15][1] = -1;
                GLLib.s_PFX_params[15][2] = -1;
                GLLib.s_PFX_params[15][3] = -1;
                GLLib.s_PFX_params[15][4] = -1;
                GLLib.s_PFX_params[15][5] = -1;
                GLLib.s_PFX_params[15][6] = -1;
                break;
            }
            case 5: {
                if (!true) break;
                GLLib.s_PFX_params[5][0] = 255;
                break;
            }
            case 6: {
                if (!true) break;
                GLLib.s_PFX_params[6][0] = 255;
                break;
            }
            case 7: {
                if (!true) break;
                GLLib.s_PFX_params[7][0] = 255;
                GLLib.s_PFX_params[7][1] = 0;
                break;
            }
            case 8: {
                if (!true) break;
                GLLib.s_PFX_params[8][0] = 255;
                break;
            }
        }
    }

    static final void PFX_EnableScreenBuffer(int n) {
        s_PFX_enableScreenBuffer |= 1 << n;
    }

    static final void PFX_DisableScreenBuffer(int n) {
        s_PFX_enableScreenBuffer &= ~(1 << n);
    }

    static final boolean PFX_NeedScreenBufferThisFrame() {
        return s_PFX_enableScreenBufferThisFrame != 0 || s_PFX_enableScreenBuffer != 0;
    }

    static final void PFX_SetCustomBuffer(Image image) {
        if (false) {
            s_PFX_customBuffer = image;
        }
    }

    static final void PFX_EnableEffect(int n) {
        GLLib.PFX_EnableEffect(n, false);
    }

    static final void PFX_EnableEffect(int n, boolean bl) {
        s_PFX_type |= 1 << n;
        if (!(pfx_usingScreenBuffer || false || false || (1 << n & 0x9FF) == 0)) {
            s_PFX_type &= 0xFFFFF600;
        }
        if ((1 << n & 0x1F) != 0) {
            GLLib.PFX_EnableScreenBuffer(n);
        }
        if (n == 14 && !false || n == 13 && !false || n == 12 && !true || n == 9 && !false || n == 10 && !false || n == 5 && !true || n == 6 && !true || n == 7 && !true || n == 8 && !true || n != 15 || !false) {
            // empty if block
        }
        if (bl) {
            GLLib.PFX_SetDefaultEffectParameters(n);
        }
    }

    static final void PFX_DisableEffect(int n) {
        GLLib.PFX_DisableEffect(n, false);
    }

    static final void PFX_DisableEffect(int n, boolean bl) {
        if (false && n == 0 && s_PFX_params[0][3] != 3) {
            if (s_PFX_params[0][3] < 2) {
                GLLib.s_PFX_params[0][3] = 2;
            }
        } else {
            s_PFX_type &= ~(1 << n);
            if ((1 << n & 0x1F) != 0) {
                GLLib.PFX_DisableScreenBuffer(n);
            }
            if (true && n == 1) {
                s_PFX_screenIsBuffered = false;
            }
        }
        if (bl) {
            GLLib.PFX_SetDefaultEffectParameters(n);
        }
    }

    static final boolean PFX_IsEffectEnabled(int n) {
        return (s_PFX_type & 1 << n) != 0;
    }

    static final int PFX_GetEnabledSpriteEffectsMask() {
        return s_PFX_type & 0x1F7E0;
    }

    static final void PFX_SetParam(int n, int n2, int n3) {
        GLLib.s_PFX_params[n][n2] = n3;
    }

    static final int PFX_GetParam(int n, int n2) {
        return s_PFX_params[n][n2];
    }

    static final int PFX_Scale_GetScaleX() {
        int n = GLLib.PFX_GetParam(13, 1);
        if (n != 100) {
            return n;
        }
        return GLLib.PFX_GetParam(13, 3);
    }

    static final int PFX_Scale_GetScaleY() {
        int n = GLLib.PFX_GetParam(13, 1);
        if (n != 100) {
            return n;
        }
        return GLLib.PFX_GetParam(13, 4);
    }

    static final int PFX_Rotate_GetAngle() {
        return GLLib.PFX_GetParam(16, 0);
    }

    static final void PFX_Rotate_GetRotatedPoint(int n, int n2, int n3, int[] nArray) {
        int n4 = GLLib.Math_Sin(n);
        int n5 = GLLib.Math_Cos(n);
        GLLib.PFX_Rotate_GetRotatedPoint(n4, n5, n2, n3, nArray);
    }

    static final void PFX_Rotate_GetRotatedPoint(int n, int n2, int n3, int n4, int[] nArray) {
        nArray[0] = GLLib.Math_FixedPointToInt(n3 * n2 - n4 * n);
        nArray[1] = GLLib.Math_FixedPointToInt(n4 * n2 + n3 * n);
    }

    static final void PFX_Rotate_GetRotatedRectSize(int n, int n2, int n3, int[] nArray) {
        int n4 = GLLib.Math_Sin(n);
        int n5 = GLLib.Math_Cos(n);
        GLLib.PFX_Rotate_GetRotatedRectSize(n4, n5, n2, n3, nArray);
    }

    static final void PFX_Rotate_GetRotatedRectSize(int n, int n2, int n3, int n4, int[] nArray) {
        GLLib.PFX_Rotate_GetRotatedPoint(n, n2, 0, n4, ASprite.s_rc);
        int n5 = ASprite.s_rc[0];
        int n6 = ASprite.s_rc[1];
        GLLib.PFX_Rotate_GetRotatedPoint(n, n2, n3, n4, ASprite.s_rc);
        int n7 = ASprite.s_rc[0];
        int n8 = ASprite.s_rc[1];
        int n9 = 0;
        int n10 = 0;
        GLLib.PFX_Rotate_GetRotatedPoint(n, n2, n3, 0, ASprite.s_rc);
        int n11 = ASprite.s_rc[0];
        int n12 = ASprite.s_rc[1];
        nArray[0] = GLLib.Math_Max(GLLib.Math_Abs(n7 - n9), GLLib.Math_Abs(n11 - n5));
        nArray[1] = GLLib.Math_Max(GLLib.Math_Abs(n8 - n10), GLLib.Math_Abs(n12 - n6));
    }

    private static final boolean PFX_UpdateMultiAlpha(boolean bl, int n) {
        if (n == 1) {
            return false;
        }
        if (n == 2) {
            return true;
        }
        return bl;
    }

    static final int[] PFX_ProcessSpriteEffects(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int[] nArray = ASprite.GetPixelBuffer_int(null);
        GLLib.GetRGB(image, nArray, 0, n3, 0, 0, n3, n4);
        return GLLib.PFX_ProcessSpriteEffects(graphics, nArray, n, n2, n3, n4, n5, bl, bl2);
    }

    static final int[] PFX_ProcessSpriteEffects(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return GLLib.PFX_ProcessSpriteEffects(graphics, nArray, n, n2, n3, n4, n5, bl, bl2, true);
    }

    static final int[] PFX_ProcessSpriteEffects(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        s_PFX_hasAlpha = bl;
        s_PFX_sizeX = n3;
        s_PFX_sizeY = n4;
        s_PFX_newSizeX = n3;
        s_PFX_newSizeY = n4;
        if ((s_PFX_type & 0x5600) != 0) {
            if ((n5 & 4) != 0) {
                s_PFX_sizeX = n4;
                s_PFX_sizeY = n3;
                n3 = s_PFX_sizeX;
                n4 = s_PFX_sizeY;
            }
            nArray = ASprite.TransformRGB(nArray, n3, n4, n5);
        }
        int[] nArray2 = ASprite.GetPixelBuffer_int(nArray, n3, n4);
        if ((s_PFX_type & 0x2000) != 0) {
            if (false) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[13][0]);
                return GLLib.PFX_ProcessScaling(graphics, nArray, nArray2, n, n2, n3, n4, GLLib.PFX_Scale_GetScaleX(), GLLib.PFX_Scale_GetScaleY(), s_PFX_params[13][2], bl, bl2, n5, bl3);
            }
        } else if ((s_PFX_type & 0x10000) != 0) {
            if (false) {
                return GLLib.PFX_ProcessRotating(graphics, nArray, nArray2, n, n2, n3, n4, GLLib.PFX_Rotate_GetAngle(), n5, bl3);
            }
        } else if ((s_PFX_type & 0x1000) != 0) {
            if (true) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[12][0]);
                return GLLib.PFX_ProcessBlend(nArray, nArray2, n3 * n4, s_PFX_params[12][1], bl, bl2);
            }
        } else if ((s_PFX_type & 0x200) != 0) {
            if (false) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[9][0]);
                return GLLib.PFX_ProcessGrayscaleEffect(nArray, nArray2, n3 * n4, s_PFX_params[9][2], s_PFX_params[9][1], bl, bl2);
            }
        } else if ((s_PFX_type & 0x400) != 0) {
            if (false) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[10][0]);
                return GLLib.PFX_ProcessShineEffect(graphics, nArray, nArray2, n, n2, n3, n4, n5, bl2);
            }
        } else if ((s_PFX_type & 0x20) != 0) {
            if (true) {
                int n6 = s_PFX_type & 0x1E0;
                int n7 = s_PFX_params[5][0];
                return GLLib.PFX_ProcessPixelEffect(graphics, nArray, nArray2, n, n2, n3, n4, n5, n6, n7, 0, true);
            }
        } else if ((s_PFX_type & 0x40) != 0) {
            if (true) {
                int n8 = s_PFX_type & 0x1E0;
                int n9 = s_PFX_params[6][0];
                return GLLib.PFX_ProcessPixelEffect(graphics, nArray, nArray2, n, n2, n3, n4, n5, n8, n9, 0, true);
            }
        } else if ((s_PFX_type & 0x80) != 0) {
            if (true) {
                int n10 = s_PFX_type & 0x1E0;
                int n11 = s_PFX_params[7][0];
                int n12 = s_PFX_params[7][1];
                return GLLib.PFX_ProcessPixelEffect(graphics, nArray, nArray2, n, n2, n3, n4, n5, n10, n11, n12, true);
            }
        } else if ((s_PFX_type & 0x100) != 0) {
            if (true) {
                int n13 = s_PFX_type & 0x1E0;
                int n14 = s_PFX_params[8][0];
                return GLLib.PFX_ProcessPixelEffect(graphics, nArray, nArray2, n, n2, n3, n4, n5, n13, n14, 0, true);
            }
        } else if ((s_PFX_type & 0x4000) != 0) {
            if (false) {
                return GLLib.PFX_ProcessStencilEffect(graphics, nArray, nArray2, n3 * n4, s_PFX_params[14][0], bl, bl2);
            }
        } else if ((s_PFX_type & 0x8000) != 0 && false && s_PFX_params[15][0] != 1 && s_PFX_params[15][0] == 2) {
            return GLLib.PFX_ProcessYPerspective(graphics, nArray, nArray2, n, n2, n3, n4, s_PFX_params[15][1], s_PFX_params[15][2], s_PFX_params[15][4], s_PFX_params[15][6], n5);
        }
        return null;
    }

    static final int[] PFX_ProcessYPerspective(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = 0;
        boolean bl = false;
        int n21 = GLLib.GetGraphicsWidth();
        int n22 = GLLib.GetGraphicsHeight();
        if (false) {
            n19 = n3;
            n3 = n4;
            n4 = n19;
            n19 = n2;
            n2 = n22 - n - n4;
            n = n19;
        }
        if (n5 <= n || n8 < n2 || n7 < n6) {
            return null;
        }
        if (n5 <= n20 || n >= n21) {
            return null;
        }
        int n23 = n19 = n5 - n;
        int n24 = GLLib.Math_IntToFixedPoint(n3);
        int n25 = n24 / n23;
        int n26 = 0;
        if ((n9 & 1) != 0) {
            n26 = n24 - s_math_F_1;
            n25 = -n25;
        }
        int n27 = GLLib.Math_IntToFixedPoint(n6 - n2) / n23;
        int n28 = GLLib.Math_IntToFixedPoint(n7 - n8) / n23;
        int n29 = 0;
        if (n6 != n2) {
            n29 = GLLib.Math_IntToFixedPoint(n23) / GLLib.Math_Abs(n6 - n2);
        }
        int n30 = GLLib.Math_IntToFixedPoint(n2);
        int n31 = GLLib.Math_IntToFixedPoint(n8);
        if (n < n20) {
            n18 = n20 - n;
            n19 -= n18;
            if ((n26 += n25 * n18) < 0 || n26 >= n24) {
                return null;
            }
            n2 = GLLib.Math_FixedPointToInt(n30 += n27 * n18);
            n8 = GLLib.Math_FixedPointToInt(n31 += n28 * n18);
            n = n20;
        }
        if ((n18 = GLLib.Math_FixedPointToInt(n26)) < 0 || n18 >= n3 || n19 <= 0) {
            return null;
        }
        if (n5 > n21) {
            n17 = n5 - n21;
            n19 -= n17;
            n6 = GLLib.Math_FixedPointToInt(GLLib.Math_IntToFixedPoint(n6) - n27 * n17);
            n7 = GLLib.Math_FixedPointToInt(GLLib.Math_IntToFixedPoint(n7) - n28 * n17);
            n5 = n21;
        }
        if (n2 >= n22) {
            n17 = n2 - n22 + 1;
            n16 = GLLib.Math_FixedPointToInt(n17 * n29);
            n19 -= n16;
            n += n16;
            if ((n26 += n25 * n16) < 0 || n26 >= n24) {
                return null;
            }
            n8 = GLLib.Math_FixedPointToInt(n31 += n28 * n16);
            n2 = n22 - 1;
            n30 = GLLib.Math_IntToFixedPoint(n2);
        }
        if (n6 >= n22) {
            n17 = n6 - n22 + 1;
            n16 = GLLib.Math_FixedPointToInt(n17 * n29);
            n5 = n + (n19 -= n16);
            n7 = GLLib.Math_FixedPointToInt(GLLib.Math_IntToFixedPoint(n7) - n28 * n16);
            n6 = n22 - 1;
        }
        if (n19 <= 0) {
            return null;
        }
        n17 = Math.min(n2, n6);
        n16 = Math.max(n7, n8);
        if (n16 > n22) {
            n16 = n22;
        }
        if ((n15 = n16 - n17) <= 0) {
            return null;
        }
        int n32 = n15;
        int n33 = nArray2.length / n32;
        int n34 = (n5 - n) / n33;
        int n35 = n2;
        int n36 = n8;
        for (n14 = 0; n14 < n34; ++n14) {
            n13 = n2 + (n6 - n2) * n33 * (n14 + 1) / n19;
            n12 = n8 + (n7 - n8) * n33 * (n14 + 1) / n19;
            n11 = GLLib.Math_Min(n35, n13);
            n10 = GLLib.Math_Max(n12, n36);
            if (n10 > n22) {
                n10 = n22;
            }
            n32 = n10 - n11;
            n30 = GLLib.Math_IntToFixedPoint(n35);
            n31 = GLLib.Math_IntToFixedPoint(n36);
            n26 = GLLib.PFX_PrepareYPerspectiveBlock(nArray2, nArray, n33, n32, n3, n4, n26, n + n33 * n14, n + n33 * (n14 + 1), n11, n10, n30, n31, n25, n27, n28);
            if (false) {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n32, n22 - n11 - n33, n + n33 * n14, n32, n33, true);
            } else {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n33, n + n33 * n14, n11, n33, n32, true);
            }
            n35 = n13;
            n36 = n12;
        }
        n14 = n19 - n33 * n34;
        if (n14 > 0) {
            n13 = n6;
            n12 = n7;
            n11 = GLLib.Math_Min(n35, n13);
            n10 = GLLib.Math_Max(n12, n36);
            if (n10 > n22) {
                n10 = n22;
            }
            n32 = n10 - n11;
            n30 = GLLib.Math_IntToFixedPoint(n35);
            n31 = GLLib.Math_IntToFixedPoint(n36);
            n26 = GLLib.PFX_PrepareYPerspectiveBlock(nArray2, nArray, n14, n32, n3, n4, n26, n + n33 * n34, n5, n11, n10, n30, n31, n25, n27, n28);
            if (false) {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n32, n22 - n11 - n32, n + n33 * n34, n32, n14, true);
            } else {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n14, n + n33 * n34, n11, n14, n32, true);
            }
        }
        return null;
    }

    static final int[] PFX_ProcessSpriteEffects(Graphics graphics, byte[] byArray, int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return GLLib.PFX_ProcessSpriteEffects(graphics, byArray, nArray, n, n2, n3, n4, n5, bl, bl2, true);
    }

    static final int[] PFX_ProcessSpriteEffects(Graphics graphics, byte[] byArray, int[] nArray, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3) {
        s_PFX_hasAlpha = bl;
        s_PFX_sizeX = n3;
        s_PFX_sizeY = n4;
        s_PFX_newSizeX = n3;
        s_PFX_newSizeY = n4;
        if ((s_PFX_type & 0x5600) != 0) {
            if ((n5 & 4) != 0) {
                s_PFX_sizeX = n4;
                s_PFX_sizeY = n3;
                n3 = s_PFX_sizeX;
                n4 = s_PFX_sizeY;
            }
            byArray = ASprite.TransformRGB(byArray, n3, n4, n5);
        }
        int[] nArray2 = ASprite.GetPixelBuffer_int(null, n3, n4);
        if ((s_PFX_type & 0x2000) != 0) {
            if (false) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[13][0]);
                return GLLib.PFX_ProcessScaling(graphics, byArray, nArray, nArray2, n, n2, n3, n4, GLLib.PFX_Scale_GetScaleX(), GLLib.PFX_Scale_GetScaleY(), s_PFX_params[13][2], bl, bl2, n5, bl3);
            }
        } else if ((s_PFX_type & 0x10000) != 0) {
            if (false) {
                return GLLib.PFX_ProcessRotating(graphics, byArray, nArray, nArray2, n, n2, n3, n4, GLLib.PFX_Rotate_GetAngle(), n5, bl3);
            }
        } else if ((s_PFX_type & 0x1000) != 0) {
            if (true) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[12][0]);
                return GLLib.PFX_ProcessBlend(byArray, nArray, nArray2, n3 * n4, s_PFX_params[12][1], bl, bl2);
            }
        } else if ((s_PFX_type & 0x200) != 0) {
            if (false) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[9][0]);
                return GLLib.PFX_ProcessGrayscaleEffect(byArray, nArray, nArray2, n3 * n4, s_PFX_params[9][2], s_PFX_params[9][1], bl, bl2);
            }
        } else if ((s_PFX_type & 0x400) != 0) {
            if (false) {
                bl2 = GLLib.PFX_UpdateMultiAlpha(bl2, s_PFX_params[10][0]);
                return GLLib.PFX_ProcessShineEffect(graphics, byArray, nArray, nArray2, n, n2, n3, n4, n5, bl2);
            }
        } else if ((s_PFX_type & 0x20) != 0) {
            if (true) {
                int n6 = s_PFX_type & 0x1E0;
                int n7 = s_PFX_params[5][0];
                return GLLib.PFX_ProcessPixelEffect(graphics, byArray, nArray, nArray2, n, n2, n3, n4, n5, n6, n7, 0, true);
            }
        } else if ((s_PFX_type & 0x40) != 0) {
            if (true) {
                int n8 = s_PFX_type & 0x1E0;
                int n9 = s_PFX_params[6][0];
                return GLLib.PFX_ProcessPixelEffect(graphics, byArray, nArray, nArray2, n, n2, n3, n4, n5, n8, n9, 0, true);
            }
        } else if ((s_PFX_type & 0x80) != 0) {
            if (true) {
                int n10 = s_PFX_type & 0x1E0;
                int n11 = s_PFX_params[7][0];
                int n12 = s_PFX_params[7][1];
                return GLLib.PFX_ProcessPixelEffect(graphics, byArray, nArray, nArray2, n, n2, n3, n4, n5, n10, n11, n12, true);
            }
        } else if ((s_PFX_type & 0x100) != 0) {
            if (true) {
                int n13 = s_PFX_type & 0x1E0;
                int n14 = s_PFX_params[8][0];
                return GLLib.PFX_ProcessPixelEffect(graphics, byArray, nArray, nArray2, n, n2, n3, n4, n5, n13, n14, 0, true);
            }
        } else if ((s_PFX_type & 0x4000) != 0) {
            if (false) {
                return GLLib.PFX_ProcessStencilEffect(graphics, byArray, nArray, nArray2, n3 * n4, s_PFX_params[14][0], bl, bl2);
            }
        } else if ((s_PFX_type & 0x8000) != 0 && false && s_PFX_params[15][0] != 1 && s_PFX_params[15][0] == 2) {
            return GLLib.PFX_ProcessYPerspective(graphics, byArray, nArray, nArray2, n, n2, n3, n4, s_PFX_params[15][1], s_PFX_params[15][2], s_PFX_params[15][4], s_PFX_params[15][6], n5);
        }
        return null;
    }

    static final int[] PFX_ProcessYPerspective(Graphics graphics, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20 = 0;
        boolean bl = false;
        int n21 = GLLib.GetGraphicsWidth();
        int n22 = GLLib.GetGraphicsHeight();
        if (false) {
            n19 = n3;
            n3 = n4;
            n4 = n19;
            n19 = n2;
            n2 = n22 - n - n4;
            n = n19;
        }
        if (n5 <= n || n8 < n2 || n7 < n6) {
            return null;
        }
        if (n5 <= n20 || n >= n21) {
            return null;
        }
        int n23 = n19 = n5 - n;
        int n24 = GLLib.Math_IntToFixedPoint(n3);
        int n25 = n24 / n23;
        int n26 = 0;
        if ((n9 & 1) != 0) {
            n26 = n24 - s_math_F_1;
            n25 = -n25;
        }
        int n27 = GLLib.Math_IntToFixedPoint(n6 - n2) / n23;
        int n28 = GLLib.Math_IntToFixedPoint(n7 - n8) / n23;
        int n29 = 0;
        if (n6 != n2) {
            n29 = GLLib.Math_IntToFixedPoint(n23) / GLLib.Math_Abs(n6 - n2);
        }
        int n30 = GLLib.Math_IntToFixedPoint(n2);
        int n31 = GLLib.Math_IntToFixedPoint(n8);
        if (n < n20) {
            n18 = n20 - n;
            n19 -= n18;
            if ((n26 += n25 * n18) < 0 || n26 >= n24) {
                return null;
            }
            n2 = GLLib.Math_FixedPointToInt(n30 += n27 * n18);
            n8 = GLLib.Math_FixedPointToInt(n31 += n28 * n18);
            n = n20;
        }
        if ((n18 = GLLib.Math_FixedPointToInt(n26)) < 0 || n18 >= n3 || n19 <= 0) {
            return null;
        }
        if (n5 > n21) {
            n17 = n5 - n21;
            n19 -= n17;
            n6 = GLLib.Math_FixedPointToInt(GLLib.Math_IntToFixedPoint(n6) - n27 * n17);
            n7 = GLLib.Math_FixedPointToInt(GLLib.Math_IntToFixedPoint(n7) - n28 * n17);
            n5 = n21;
        }
        if (n2 >= n22) {
            n17 = n2 - n22 + 1;
            n16 = GLLib.Math_FixedPointToInt(n17 * n29);
            n19 -= n16;
            n += n16;
            if ((n26 += n25 * n16) < 0 || n26 >= n24) {
                return null;
            }
            n8 = GLLib.Math_FixedPointToInt(n31 += n28 * n16);
            n2 = n22 - 1;
            n30 = GLLib.Math_IntToFixedPoint(n2);
        }
        if (n6 >= n22) {
            n17 = n6 - n22 + 1;
            n16 = GLLib.Math_FixedPointToInt(n17 * n29);
            n5 = n + (n19 -= n16);
            n7 = GLLib.Math_FixedPointToInt(GLLib.Math_IntToFixedPoint(n7) - n28 * n16);
            n6 = n22 - 1;
        }
        if (n19 <= 0) {
            return null;
        }
        n17 = Math.min(n2, n6);
        n16 = Math.max(n7, n8);
        if (n16 > n22) {
            n16 = n22;
        }
        if ((n15 = n16 - n17) <= 0) {
            return null;
        }
        int n32 = n15;
        int n33 = nArray2.length / n32;
        int n34 = (n5 - n) / n33;
        int n35 = n2;
        int n36 = n8;
        for (n14 = 0; n14 < n34; ++n14) {
            n13 = n2 + (n6 - n2) * n33 * (n14 + 1) / n19;
            n12 = n8 + (n7 - n8) * n33 * (n14 + 1) / n19;
            n11 = GLLib.Math_Min(n35, n13);
            n10 = GLLib.Math_Max(n12, n36);
            if (n10 > n22) {
                n10 = n22;
            }
            n32 = n10 - n11;
            n30 = GLLib.Math_IntToFixedPoint(n35);
            n31 = GLLib.Math_IntToFixedPoint(n36);
            n26 = GLLib.PFX_PrepareYPerspectiveBlock(nArray2, byArray, nArray, n33, n32, n3, n4, n26, n + n33 * n14, n + n33 * (n14 + 1), n11, n10, n30, n31, n25, n27, n28);
            if (false) {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n32, n22 - n11 - n33, n + n33 * n14, n32, n33, true);
            } else {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n33, n + n33 * n14, n11, n33, n32, true);
            }
            n35 = n13;
            n36 = n12;
        }
        n14 = n19 - n33 * n34;
        if (n14 > 0) {
            n13 = n6;
            n12 = n7;
            n11 = GLLib.Math_Min(n35, n13);
            n10 = GLLib.Math_Max(n12, n36);
            if (n10 > n22) {
                n10 = n22;
            }
            n32 = n10 - n11;
            n30 = GLLib.Math_IntToFixedPoint(n35);
            n31 = GLLib.Math_IntToFixedPoint(n36);
            n26 = GLLib.PFX_PrepareYPerspectiveBlock(nArray2, byArray, nArray, n14, n32, n3, n4, n26, n + n33 * n34, n5, n11, n10, n30, n31, n25, n27, n28);
            if (false) {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n32, n22 - n11 - n32, n + n33 * n34, n32, n14, true);
            } else {
                GLLib.PFX_WritePixelData(graphics, nArray2, 0, n14, n + n33 * n34, n11, n14, n32, true);
            }
        }
        return null;
    }

    private static final int[] PFX_GetPalIndexARGB(byte[] byArray, int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = ASprite.GetPixelBuffer_int(nArray2);
        int n2 = n = byArray.length;
        while (--n2 >= 0) {
            nArray3[n2] = nArray[byArray[n2] & 0xFF];
        }
        return nArray3;
    }

    static final int[] PFX_ProcessPixelEffect(Graphics graphics, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int n9;
        int n10;
        int n11 = 0;
        int n12 = 0;
        int n13 = n3;
        int n14 = n4;
        int n15 = n3;
        int n16 = n4;
        int n17 = GLLib.GetClipX(graphics);
        int n18 = GLLib.GetClipY(graphics);
        int n19 = GLLib.GetClipWidth(graphics);
        int n20 = GLLib.GetClipHeight(graphics);
        if (false) {
            n10 = n17;
            n17 = GLLib.GetGraphicsHeight() - n18 - n20;
            n18 = n10;
            n10 = n19;
            n19 = n20;
            n20 = n10;
        }
        if ((n5 & 4) != 0) {
            n13 = n16;
            n14 = n15;
        }
        n15 = n13;
        n16 = n14;
        if (n2 + n16 > n20 + n18) {
            n16 = n20 + n18 - n2;
        }
        if (n + n15 > n19 + n17) {
            n15 = n19 + n17 - n;
        }
        if (n < n17) {
            n11 = n17 - n;
            n15 -= n11;
            n += n17 - n;
        }
        if (n2 < n18) {
            n12 = n18 - n2;
            n16 -= n12;
            n2 += n18 - n2;
        }
        if (n13 <= 0 || n15 <= 0) {
            return nArray;
        }
        if (n14 <= 0 || n16 <= 0) {
            return nArray;
        }
        n10 = n14 * (n13 + 1);
        if (bl) {
            GLLib.PFX_ReadPixelData(nArray2, 0, n15, n, n2, n15, n16);
        }
        if (n15 != n13 || n16 != n14) {
            for (n9 = n16 - 1; n9 >= 0; --n9) {
                System.arraycopy(nArray2, n9 * n15, nArray2, n11 + (n9 + n12) * n13, n15);
            }
        }
        n9 = 0;
        if ((n5 & 4) != 0) {
            int n21 = 0;
            int n22 = n14;
            int n23 = 1;
            if ((n5 & 1) != 0) {
                n21 = n14 - 1;
                n22 = -1;
                n23 = -1;
            }
            int n24 = n13 - 1;
            int n25 = -n14;
            int n26 = (n13 - 1) * n14;
            if ((n5 & 2) != 0) {
                n25 = n14;
                n26 = 0;
            }
            int n27 = n23;
            int n28 = n21;
            if ((n6 & 0x20) != 0) {
                GLLib.PFX_ProcessAdditive(nArray, n28, n26, n27, nArray2, n21, n23, n22, n24, n25, n7);
            }
            if ((n6 & 0x40) != 0) {
                GLLib.PFX_ProcessMultiplicative(nArray, n28, n26, n27, nArray2, n21, n23, n22, n24, n25, n7);
            }
            if ((n6 & 0x80) != 0) {
                GLLib.PFX_ProcessOverlay(nArray, n28, n26, n27, nArray2, n21, n23, n22, n24, n25, n7, n8);
            }
            if ((n6 & 0x100) != 0) {
                GLLib.PFX_ProcessColorDodge(nArray, n28, n26, n27, nArray2, n21, n23, n22, n24, n25, n7);
            }
        } else {
            int n29 = 0;
            int n30 = n14;
            int n31 = 1;
            if ((n5 & 2) != 0) {
                n29 = n14 - 1;
                n30 = -1;
                n31 = -1;
            }
            int n32 = n13 - 1;
            int n33 = 1;
            int n34 = 0;
            if ((n5 & 1) != 0) {
                n33 = -1;
                n34 = n13 - 1;
            }
            int n35 = n31 * n3;
            int n36 = n29 * n3;
            if ((n6 & 0x20) != 0) {
                GLLib.PFX_ProcessAdditive(nArray, n36, n34, n35, nArray2, n29, n31, n30, n32, n33, n7);
            }
            if ((n6 & 0x40) != 0) {
                GLLib.PFX_ProcessMultiplicative(nArray, n36, n34, n35, nArray2, n29, n31, n30, n32, n33, n7);
            }
            if ((n6 & 0x80) != 0) {
                GLLib.PFX_ProcessOverlay(nArray, n36, n34, n35, nArray2, n29, n31, n30, n32, n33, n7, n8);
            }
            if ((n6 & 0x100) != 0) {
                GLLib.PFX_ProcessColorDodge(nArray, n36, n34, n35, nArray2, n29, n31, n30, n32, n33, n7);
            }
        }
        s_PFX_sizeX = n13;
        s_PFX_sizeY = n14;
        s_PFX_hasAlpha = n7 < 255;
        return nArray2;
    }

    static final int[] PFX_ProcessPixelEffect(Graphics graphics, byte[] byArray, int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        int[] nArray3 = GLLib.PFX_GetPalIndexARGB(byArray, nArray, nArray2);
        return GLLib.PFX_ProcessPixelEffect(graphics, nArray3, nArray2, n, n2, n3, n4, n5, n6, n7, n8, bl);
    }

    private static final void PFX_ProcessOverlay(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        int n11 = 0;
        int n12 = n9;
        if (n10 == 0) {
            for (int i = n4; i != n6; i += n5) {
                int n13 = n + n2;
                for (int j = n7; j >= 0; --j) {
                    int n14 = nArray2[n11];
                    int n15 = nArray[n13];
                    int n16 = (n14 & 0xFF0000) >> 16;
                    int n17 = (n14 & 0xFF00) >> 8;
                    int n18 = n14 & 0xFF;
                    int n19 = (n15 & 0xFF0000) >> 16;
                    int n20 = (n15 & 0xFF00) >> 8;
                    int n21 = n15 & 0xFF;
                    int n22 = n19 < 128 ? n19 * n16 >> 7 : 255 - ((255 - n19) * (255 - n16) >> 7);
                    int n23 = n20 < 128 ? n20 * n17 >> 7 : 255 - ((255 - n20) * (255 - n17) >> 7);
                    int n24 = n21 < 128 ? n21 * n18 >> 7 : 255 - ((255 - n21) * (255 - n18) >> 7);
                    nArray2[n11] = n12 << 24 | n22 << 16 | n23 << 8 | n24;
                    n13 += n8;
                    ++n11;
                }
                n += n3;
            }
        } else {
            for (int i = n4; i != n6; i += n5) {
                int n25 = n + n2;
                for (int j = n7; j >= 0; --j) {
                    int n26 = nArray[n25];
                    int n27 = nArray2[n11];
                    int n28 = (n26 & 0xFF0000) >> 16;
                    int n29 = (n26 & 0xFF00) >> 8;
                    int n30 = n26 & 0xFF;
                    int n31 = (n27 & 0xFF0000) >> 16;
                    int n32 = (n27 & 0xFF00) >> 8;
                    int n33 = n27 & 0xFF;
                    int n34 = n31 < 128 ? n31 * n28 >> 7 : 255 - ((255 - n31) * (255 - n28) >> 7);
                    int n35 = n32 < 128 ? n32 * n29 >> 7 : 255 - ((255 - n32) * (255 - n29) >> 7);
                    int n36 = n33 < 128 ? n33 * n30 >> 7 : 255 - ((255 - n33) * (255 - n30) >> 7);
                    nArray2[n11] = n12 << 24 | n34 << 16 | n35 << 8 | n36;
                    n25 += n8;
                    ++n11;
                }
                n += n3;
            }
        }
    }

    private static final void PFX_ProcessColorDodge(int[] nArray, int n, int n2, int n3, int[] nArray2, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = 0;
        int n11 = n9;
        for (int i = n4; i != n6; i += n5) {
            int n12 = n + n2;
            for (int j = n7; j >= 0; --j) {
                int n13;
                int n14;
                int n15;
                int n16 = nArray2[n10];
                int n17 = nArray[n12];
                int n18 = (n16 & 0xFF0000) >> 16;
                int n19 = (n16 & 0xFF00) >> 8;
                int n20 = n16 & 0xFF;
                int n21 = (n17 & 0xFF0000) >> 16;
                int n22 = (n17 & 0xFF00) >> 8;
                int n23 = n17 & 0xFF;
                if (n21 == 255) {
                    n15 = 255;
                } else {
                    n15 = (n18 << 8) / (255 - n21);
                    if (n15 > 255) {
                        n15 = 255;
                    }
                }
                if (n22 == 255) {
                    n14 = 255;
                } else {
                    n14 = (n19 << 8) / (255 - n22);
                    if (n14 > 255) {
                        n14 = 255;
                    }
                }
                if (n23 == 255) {
                    n13 = 255;
                } else {
                    n13 = (n20 << 8) / (255 - n23);
                    if (n13 > 255) {
                        n13 = 255;
                    }
                }
                nArray2[n10] = n11 << 24 | n15 << 16 | n14 << 8 | n13;
                n12 += n8;
                ++n10;
            }
            n += n3;
        }
    }

    public static void DrawGradientRect(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        block5: {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            block7: {
                block6: {
                    block4: {
                        n15 = n5 >> 16 & 0xFF;
                        n14 = n5 >> 8 & 0xFF;
                        n13 = n5 >> 0 & 0xFF;
                        int n16 = n6 >> 16 & 0xFF;
                        int n17 = n6 >> 8 & 0xFF;
                        int n18 = n6 >> 0 & 0xFF;
                        n12 = n16 - n15;
                        n11 = n17 - n14;
                        n10 = n18 - n13;
                        n9 = n + n3 - 1;
                        n8 = n2 + n4 - 1;
                        n15 <<= 16;
                        n14 <<= 16;
                        n13 <<= 16;
                        if (n7 != 4) break block4;
                        int n19 = n9 - n;
                        n12 = (n12 << 16) / n19;
                        n11 = (n11 << 16) / n19;
                        n10 = (n10 << 16) / n19;
                        for (int i = n9; i >= n; --i) {
                            GLLib.SetColor(graphics, n15 >> 16, n14 >> 16, n13 >> 16);
                            GLLib.DrawLine(graphics, i, n2, i, n8);
                            n15 += n12;
                            n14 += n11;
                            n13 += n10;
                        }
                        break block5;
                    }
                    if (n7 != 8) break block6;
                    int n20 = n9 - n;
                    n12 = (n12 << 16) / n20;
                    n11 = (n11 << 16) / n20;
                    n10 = (n10 << 16) / n20;
                    for (int i = n; i <= n9; ++i) {
                        GLLib.SetColor(graphics, n15 >> 16, n14 >> 16, n13 >> 16);
                        GLLib.DrawLine(graphics, i, n2, i, n8);
                        n15 += n12;
                        n14 += n11;
                        n13 += n10;
                    }
                    break block5;
                }
                if (n7 != 16) break block7;
                int n21 = n8 - n2;
                n12 = (n12 << 16) / n21;
                n11 = (n11 << 16) / n21;
                n10 = (n10 << 16) / n21;
                for (int i = n8; i >= n2; --i) {
                    GLLib.SetColor(graphics, n15 >> 16, n14 >> 16, n13 >> 16);
                    GLLib.DrawLine(graphics, n, i, n9, i);
                    n15 += n12;
                    n14 += n11;
                    n13 += n10;
                }
                break block5;
            }
            if (n7 != 32) break block5;
            int n22 = n8 - n2;
            n12 = (n12 << 16) / n22;
            n11 = (n11 << 16) / n22;
            n10 = (n10 << 16) / n22;
            for (int i = n2; i <= n8; ++i) {
                GLLib.SetColor(graphics, n15 >> 16, n14 >> 16, n13 >> 16);
                GLLib.DrawLine(graphics, n, i, n9, i);
                n15 += n12;
                n14 += n11;
                n13 += n10;
            }
        }
    }

    public void addCommand(Command command) {
        if (false && true > true && command.getLabel() == "GLSetPointer") {
            GLLib.Pointer_SetCurrentPointer(command.getCommandType());
        } else {
            super.addCommand(command);
        }
    }

    protected static void Pointer_SetCurrentPointer(int n) {
        if (false && true > true) {
            s_currentPointer = n;
        }
    }

    public static final void Pointer_Update() {
        if (false) {
            if (s_isPointerPressedSystem) {
                GLLib.Pointer_SwitchState(1);
                s_isPointerPressedSystem = false;
            } else if (s_isPointerReleasedSystem) {
                GLLib.Pointer_SwitchState(2);
                s_isPointerReleasedSystem = false;
                s_isPointerDraggedSystem = false;
            } else if (s_isPointerDraggedSystem) {
                GLLib.Pointer_SwitchState(3);
                s_isPointerDraggedSystem = false;
            }
            s_tmpPrevPointerX = s_pointerX;
            s_tmpPrevPointerY = s_pointerY;
            if (true > true) {
                for (int i = 0; i < 1; ++i) {
                    if (s_isPointerPressedSystem_multi[i]) {
                        GLLib.Pointer_SwitchState(i, 1);
                        GLLib.s_isPointerPressedSystem_multi[i] = false;
                    } else if (s_isPointerReleasedSystem_multi[i]) {
                        GLLib.Pointer_SwitchState(i, 2);
                        GLLib.s_isPointerReleasedSystem_multi[i] = false;
                        GLLib.s_isPointerDraggedSystem_multi[i] = false;
                    } else if (s_isPointerDraggedSystem_multi[i]) {
                        GLLib.Pointer_SwitchState(i, 3);
                        GLLib.s_isPointerDraggedSystem_multi[i] = false;
                    }
                    GLLib.s_tmpPrevPointerX_multi[i] = s_pointerX_multi[i];
                    GLLib.s_tmpPrevPointerY_multi[i] = s_pointerY_multi[i];
                }
            }
        }
    }

    public static final void Pointer_Reset() {
        if (false) {
            switch (s_pointerState) {
                case 0: {
                    break;
                }
                case 1: {
                    GLLib.Pointer_SwitchState(4);
                    break;
                }
                case 2: {
                    GLLib.Pointer_SwitchState(0);
                    break;
                }
            }
            s_prevPointerX = s_tmpPrevPointerX;
            s_prevPointerY = s_tmpPrevPointerY;
            if (true > true) {
                for (int i = 0; i < 1; ++i) {
                    switch (s_pointerState_multi[i]) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            GLLib.Pointer_SwitchState(i, 4);
                            break;
                        }
                        case 2: {
                            GLLib.Pointer_SwitchState(i, 0);
                            break;
                        }
                    }
                    GLLib.s_prevPointerX_multi[i] = s_tmpPrevPointerX_multi[i];
                    GLLib.s_prevPointerY_multi[i] = s_tmpPrevPointerY_multi[i];
                }
            }
        }
    }

    public static void Pointer_ChangeStateCallback(int n, int n2) {
        if (false && true > true) {
            GLLib.Pointer_ChangeStateCallback(0, n, n2);
        }
    }

    public static void Pointer_ChangeStateCallback(int n, int n2, int n3) {
        if (false && true <= true) {
            GLLib.Pointer_ChangeStateCallback(n2, n3);
        }
    }

    private static final void Pointer_SwitchState(int n) {
        GLLib.Pointer_SwitchState(0, n);
    }

    private static void Pointer_SwitchState(int n, int n2) {
        if (false) {
            if (true > true) {
                GLLib.Pointer_ChangeStateCallback(n, s_pointerState_multi[n], n2);
                GLLib.s_pointerState_multi[n] = n2;
                if (n == 0) {
                    s_pointerState = n2;
                }
            } else {
                GLLib.Pointer_ChangeStateCallback(s_pointerState, n2);
                s_pointerState = n2;
            }
        }
    }

    private static final void Pointer_AdjustToRotatedCoordinates() {
        GLLib.Pointer_AdjustToRotatedCoordinates(0);
    }

    private static void Pointer_AdjustToRotatedCoordinates(int n) {
        if (false) {
            int n2;
            if (true > true) {
                n2 = s_pointerY_multi[n];
                GLLib.s_pointerY_multi[n] = GLLib.GetScreenHeight() - s_pointerX_multi[n];
                GLLib.s_pointerX_multi[n] = n2;
            }
            if (n == 0) {
                n2 = s_pointerY;
                s_pointerY = GLLib.GetScreenHeight() - s_pointerX;
                s_pointerX = n2;
            }
        }
    }

    protected void pointerReleased(int n, int n2) {
        this.pointerReleased(s_currentPointer, n, n2);
    }

    private void pointerReleased(int n, int n2, int n3) {
        if (false) {
            if (true > true) {
                if (n == 0) {
                    s_pointerX = n2;
                    s_pointerY = n3;
                }
                GLLib.s_pointerX_multi[n] = n2;
                GLLib.s_pointerY_multi[n] = n3;
                if (false || false) {
                    GLLib.Pointer_AdjustToRotatedCoordinates(n);
                }
                GLLib.s_isPointerReleasedSystem_multi[n] = true;
                if (n == 0) {
                    s_isPointerReleasedSystem = true;
                }
            } else {
                s_pointerX = n2;
                s_pointerY = n3;
                if (false || false) {
                    GLLib.Pointer_AdjustToRotatedCoordinates();
                }
                s_isPointerReleasedSystem = true;
            }
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerPressed(s_currentPointer, n, n2);
    }

    private void pointerPressed(int n, int n2, int n3) {
        if (false) {
            if (true > true) {
                if (n == 0) {
                    s_pointerX = n2;
                    s_pointerY = n3;
                }
                GLLib.s_pointerX_multi[n] = n2;
                GLLib.s_pointerY_multi[n] = n3;
                if (false || false) {
                    GLLib.Pointer_AdjustToRotatedCoordinates(n);
                }
                GLLib.s_isPointerPressedSystem_multi[n] = true;
                if (n == 0) {
                    s_isPointerPressedSystem = true;
                }
            } else {
                s_pointerX = n2;
                s_pointerY = n3;
                if (false || false) {
                    GLLib.Pointer_AdjustToRotatedCoordinates();
                }
                s_isPointerPressedSystem = true;
            }
        }
    }

    protected void pointerDragged(int n, int n2) {
        this.pointerDragged(s_currentPointer, n, n2);
    }

    private void pointerDragged(int n, int n2, int n3) {
        if (false) {
            if (true > true) {
                if (n == 0) {
                    s_pointerX = n2;
                    s_pointerY = n3;
                }
                GLLib.s_pointerX_multi[n] = n2;
                GLLib.s_pointerY_multi[n] = n3;
                if (false || false) {
                    GLLib.Pointer_AdjustToRotatedCoordinates(n);
                }
                GLLib.s_isPointerDraggedSystem_multi[n] = true;
                if (n == 0) {
                    s_isPointerDraggedSystem = true;
                }
            } else {
                s_pointerX = n2;
                s_pointerY = n3;
                if (false || false) {
                    GLLib.Pointer_AdjustToRotatedCoordinates();
                }
                s_isPointerDraggedSystem = true;
            }
        }
    }

    public static final boolean Pointer_IsReleased() {
        return GLLib.Pointer_IsReleased(0);
    }

    public static final boolean Pointer_IsReleased(int n) {
        if (false) {
            if (true > true) {
                return s_pointerState_multi[n] == 2;
            }
            return s_pointerState == 2;
        }
        return false;
    }

    public static final boolean Pointer_IsPressed() {
        return GLLib.Pointer_IsPressed(0);
    }

    public static final boolean Pointer_IsPressed(int n) {
        if (false) {
            if (true > true) {
                return s_pointerState_multi[n] == 1;
            }
            return s_pointerState == 1;
        }
        return false;
    }

    public static final boolean Pointer_IsDragged() {
        return GLLib.Pointer_IsDragged(0);
    }

    public static final boolean Pointer_IsDragged(int n) {
        if (false) {
            if (true > true) {
                return s_pointerState_multi[n] == 3;
            }
            return s_pointerState == 3;
        }
        return false;
    }

    public static final boolean Pointer_IsIdle() {
        return GLLib.Pointer_IsIdle(0);
    }

    public static final boolean Pointer_IsIdle(int n) {
        if (false) {
            if (true > true) {
                return s_pointerState_multi[n] == 0;
            }
            return s_pointerState == 0;
        }
        return false;
    }

    public static final boolean Pointer_IsDown() {
        return GLLib.Pointer_IsDown(0);
    }

    public static final boolean Pointer_IsDown(int n) {
        if (false) {
            if (true > true) {
                return s_pointerState_multi[n] == 4;
            }
            return s_pointerState == 4;
        }
        return false;
    }

    public static final boolean Pointer_IsHeldDown() {
        return GLLib.Pointer_IsHeldDown(0);
    }

    public static final boolean Pointer_IsHeldDown(int n) {
        if (false) {
            if (true > true) {
                int n2 = s_pointerState_multi[n];
                return n2 == 4 || n2 == 1 || n2 == 3;
            }
            return s_pointerState == 4 || s_pointerState == 1 || s_pointerState == 3;
        }
        return false;
    }

    public static final boolean Pointer_IsInRect(int[] nArray) {
        if (false) {
            return GLLib.Pointer_IsInRect(nArray[0], nArray[1], nArray[2], nArray[3]);
        }
        return false;
    }

    public static final boolean Pointer_IsInRect(int n, int n2, int n3, int n4) {
        if (false) {
            if (true > true) {
                return GLLib.Pointer_IsInRect(0, s_pointerState_multi[0], n, n2, n3, n4);
            }
            return GLLib.Pointer_IsInRect(0, s_pointerState, n, n2, n3, n4);
        }
        return false;
    }

    public static boolean Pointer_IsInRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (false) {
            boolean bl = false;
            if (true > true) {
                if (s_pointerX_multi[n] > n3 && s_pointerX_multi[n] < n3 + n5 && s_pointerY_multi[n] > n4 && s_pointerY_multi[n] < n4 + n6) {
                    switch (n2) {
                        case 0: {
                            bl = GLLib.Pointer_IsIdle(n);
                            break;
                        }
                        case 1: {
                            bl = GLLib.Pointer_IsPressed(n);
                            break;
                        }
                        case 4: {
                            bl = GLLib.Pointer_IsDown(n);
                            break;
                        }
                        case 2: {
                            bl = GLLib.Pointer_IsReleased(n);
                            break;
                        }
                        case 3: {
                            bl = GLLib.Pointer_IsDragged(n);
                        }
                    }
                }
            } else if (s_pointerX > n3 && s_pointerX < n3 + n5 && s_pointerY > n4 && s_pointerY < n4 + n6) {
                switch (n2) {
                    case 0: {
                        bl = GLLib.Pointer_IsIdle();
                        break;
                    }
                    case 1: {
                        bl = GLLib.Pointer_IsPressed();
                        break;
                    }
                    case 4: {
                        bl = GLLib.Pointer_IsDown();
                        break;
                    }
                    case 2: {
                        bl = GLLib.Pointer_IsReleased();
                        break;
                    }
                    case 3: {
                        bl = GLLib.Pointer_IsDragged();
                    }
                }
            }
            return bl;
        }
        return false;
    }

    static void DrawAAAlphaLine(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9 = n3 - n;
        if ((n9 < 0 ? -n9 : n9) > ((n8 = n4 - n2) < 0 ? -n8 : n8)) {
            if (n3 < n) {
                int n10 = n;
                n = n3;
                n3 = n10;
                n10 = n2;
                n2 = n4;
                n4 = n10;
                n10 = n6;
                n6 = n7;
                n7 = n10;
            }
            n9 = n3 - n;
            n8 = n4 - n2;
            int n11 = 0;
            if (n9 != 0) {
                n11 = (n8 << 16) / n9;
            }
            int n12 = n;
            int n13 = (n2 << 16) + n11 * (n12 - n);
            int n14 = n12;
            int n15 = n13;
            int n16 = n13 + n11;
            n12 = n3;
            n13 = (n4 << 16) + n11 * (n12 - n3);
            int n17 = n12;
            int n18 = 0;
            if (n9 != 0) {
                n18 = (n7 - n6 << 16) / n9;
            }
            int[] nArray = ASprite.GetPixelBuffer_int(null);
            n6 <<= 16;
            boolean bl = false;
            int n19 = n14;
            n14 = n14 > graphics.getClipX() ? n14 : graphics.getClipX();
            n17 = n17 < graphics.getClipX() + graphics.getClipWidth() ? n17 : graphics.getClipX() + graphics.getClipWidth();
            int n20 = n14 - n19;
            n16 += n11 * n20;
            n6 += n18 * n20;
            int n21 = graphics.getClipY() + graphics.getClipHeight();
            int n22 = graphics.getClipY();
            for (int i = n14; i < n17; ++i) {
                int n23 = n16 >> 16;
                if (n23 < n22 || n23 >= n21) {
                    n16 += n11;
                    n6 += n18;
                    if (!bl) continue;
                    return;
                }
                bl = true;
                int n24 = n16 & 0xFFFF;
                int n25 = 65535 - n24;
                int n26 = (n25 >> 8) * n6 & 0xFF000000;
                nArray[0] = n26 | n5;
                n26 = (n24 >> 8) * n6 & 0xFF000000;
                nArray[1] = n26 | n5;
                GLLib.DrawRGB(graphics, nArray, 0, 1, i, n23, 1, 2, true);
                n16 += n11;
                n6 += n18;
            }
        } else {
            if (n4 < n2) {
                int n27 = n;
                n = n3;
                n3 = n27;
                n27 = n2;
                n2 = n4;
                n4 = n27;
                n27 = n6;
                n6 = n7;
                n7 = n27;
            }
            n9 = n3 - n;
            n8 = n4 - n2;
            int n28 = 0;
            if (n8 != 0) {
                n28 = (n9 << 16) / n8;
            }
            int n29 = n2;
            int n30 = (n << 16) + n28 * (n29 - n2);
            int n31 = n29;
            int n32 = n30;
            int n33 = n30 + n28;
            n29 = n4;
            n30 = (n3 << 16) + n28 * (n29 - n4);
            int n34 = n29;
            int n35 = 0;
            if (n8 != 0) {
                n35 = (n7 - n6 << 16) / n8;
            }
            n6 <<= 16;
            int[] nArray = ASprite.temp_int;
            boolean bl = false;
            int n36 = n31;
            n31 = n31 > graphics.getClipY() ? n31 : graphics.getClipY();
            n34 = n34 < graphics.getClipY() + graphics.getClipHeight() ? n34 : graphics.getClipY() + graphics.getClipHeight();
            int n37 = n31 - n36;
            n33 += n28 * n37;
            n6 += n35 * n37;
            int n38 = graphics.getClipX() + graphics.getClipWidth();
            int n39 = graphics.getClipX();
            for (int i = n31; i < n34; ++i) {
                int n40 = n33 >> 16;
                if (n40 < n39 || n40 >= n38) {
                    n33 += n28;
                    n6 += n35;
                    if (!bl) continue;
                    return;
                }
                bl = true;
                int n41 = n33 & 0xFFFF;
                int n42 = 65535 - n41;
                int n43 = (n42 >> 8) * n6 & 0xFF000000;
                nArray[0] = n43 | n5;
                n43 = (n41 >> 8) * n6 & 0xFF000000;
                nArray[1] = n43 | n5;
                GLLib.DrawRGB(graphics, nArray, 0, 2, n40, i, 2, 1, true);
                n33 += n28;
                n6 += n35;
            }
        }
    }

    static {
        s_screenWidth = 320;
        s_screenHeight = 240;
        m_FPSLimiter = 1000 / 8;
        m_customSleepTime = -1;
        m_imgBackBuffer = null;
        m_gBackBuffer = null;
        m_bBackBufferEnabled = true;
        s_keyLastKeyPressUntranslatedCode = -9999;
        m_last_key_pressed = -9999;
        s_nbKey = 25;
        s_dbg_console_logSlotsSize = 500;
        s_dbg_console_nbVisibleSlots = 5;
        s_dbg_console_fontColor = 65280;
        s_dbg_console_fontBackgroundColor = 0;
        s_dbg_console_recordLogCurrentTime = false;
        s_dbg_console_forceFocusNextAvailableSlot = true;
        s_dbg_console_currentAction = -1;
        s_math_F_1 = 1 << 8;
        s_math_F_05 = s_math_F_1 >> 1;
        Math_AngleMUL = 1 << 8;
        Math_Angle90 = GLLib.Math_DegreeToFixedPointAngle(90);
        Math_Angle180 = GLLib.Math_DegreeToFixedPointAngle(180);
        Math_Angle270 = GLLib.Math_DegreeToFixedPointAngle(270);
        Math_Angle360 = GLLib.Math_DegreeToFixedPointAngle(360);
        Math_FixedPoint_PI = 1686629713 >> 29 - 8;
        Math_FixedPoint_E = 1459366444 >> 29 - 8;
        ratioRadiansToDegrees = GLLib.Math_FixedPoint_Divide(180 << 8, Math_FixedPoint_PI);
        ratioDegreesToAngleFixedPoint = GLLib.Math_FixedPoint_Divide(1 << 8, 360);
        s_Math_intersectPoints = new int[2][2];
        Stream_readOffset = 0;
        text_encoding = "UTF-8";
        pfx_usingScreenBuffer = true && (false || true || true || false || true || false || true || true);
        pfx_useSpriteEffects = true || true || false || false || true || false || false;
        s_PFX_initializd = false;
        s_PFX_type = 0;
        s_PFX_params = null;
        s_PFX_screenBuffer = null;
        s_PFX_screenBufferG = null;
        s_PFX_customBuffer = null;
        s_PFX_enableScreenBuffer = 0;
        s_PFX_enableScreenBufferThisFrame = 0;
        s_PFX_screenIsBuffered = false;
    }
}

